/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _qualified;
	gboolean _null_safe_access;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

gboolean
vala_member_access_get_null_safe_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_null_safe_access;
	return result;
}

void
vala_member_access_set_null_safe_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_null_safe_access = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaLocalVariable* l = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaConstant* _tmp6_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	l = VALA_IS_LOCAL_VARIABLE (_tmp3_) ? ((ValaLocalVariable*) _tmp3_) : NULL;
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	m = VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL;
	_tmp6_ = c;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		ValaConstant* _tmp8_;
		_tmp8_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp8_)) {
			_tmp7_ = TRUE;
		} else {
			ValaConstant* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp9_ = c;
			_tmp10_ = vala_constant_get_type_reference (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_data_type_get_nullable (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = !_tmp13_;
		}
		result = _tmp7_;
		return result;
	} else {
		ValaLocalVariable* _tmp14_;
		_tmp14_ = l;
		if (_tmp14_ != NULL) {
			ValaDataType* type = NULL;
			ValaLocalVariable* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp15_ = l;
			_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) _tmp15_);
			_tmp17_ = _tmp16_;
			type = _tmp17_;
			_tmp18_ = type;
			if (VALA_IS_ARRAY_TYPE (_tmp18_)) {
				ValaDataType* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = type;
				_tmp20_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp21_ = _tmp20_;
				result = _tmp21_;
				return result;
			} else {
				gboolean _tmp22_ = FALSE;
				ValaDataType* _tmp23_;
				_tmp23_ = type;
				if (vala_data_type_is_real_non_null_struct_type (_tmp23_)) {
					_tmp22_ = TRUE;
				} else {
					ValaDataType* _tmp24_;
					_tmp24_ = type;
					_tmp22_ = vala_data_type_is_non_null_simple_type (_tmp24_);
				}
				result = _tmp22_;
				return result;
			}
		} else {
			ValaMethod* _tmp25_;
			_tmp25_ = m;
			if (_tmp25_ != NULL) {
				gboolean _tmp26_ = FALSE;
				ValaMethod* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = m;
				_tmp28_ = vala_method_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp26_ = TRUE;
				} else {
					gboolean _tmp30_;
					_tmp30_ = self->priv->_prototype_access;
					_tmp26_ = _tmp30_;
				}
				result = _tmp26_;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp747_ = FALSE;
	gboolean _tmp748_ = FALSE;
	gboolean _tmp749_ = FALSE;
	ValaExpression* _tmp750_;
	ValaExpression* _tmp751_;
	ValaSymbol* _tmp778_;
	ValaSymbol* _tmp779_;
	ValaSymbol* _tmp874_;
	ValaSymbol* _tmp875_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp910_;
	ValaSymbol* _tmp911_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp912_;
	ValaSymbol* _tmp913_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1366_;
	ValaSymbol* _tmp1367_;
	ValaSymbol* _tmp1369_;
	ValaVersionAttribute* _tmp1370_;
	ValaVersionAttribute* _tmp1371_;
	ValaSourceReference* _tmp1372_;
	ValaSourceReference* _tmp1373_;
	gboolean _tmp1374_ = FALSE;
	gboolean _tmp1425_ = FALSE;
	gboolean _tmp1452_ = FALSE;
	gboolean _tmp1453_ = FALSE;
	ValaDataType* _tmp1746_;
	ValaDataType* _tmp1747_;
	ValaSymbol* _tmp1750_;
	ValaSymbol* _tmp1751_;
	gboolean _tmp1792_;
	gboolean _tmp1793_;
	gboolean _tmp1794_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_null_safe_access;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		result = !_tmp6_;
		return result;
	}
	_tmp7_ = vala_member_access_get_inner (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp9_ = vala_member_access_get_inner (self);
		_tmp10_ = _tmp9_;
		vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp11_;
		gint _type_arg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _type_arg_index = 0;
		_tmp11_ = self->priv->type_argument_list;
		_type_arg_list = _tmp11_;
		_tmp12_ = _type_arg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_type_arg_size = _tmp14_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_type_arg_index = _type_arg_index + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = vala_list_get (_tmp17_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	visited_types = _tmp21_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp22_ = self->priv->_qualified;
	if (_tmp22_) {
		ValaNamespace* _tmp23_;
		ValaNamespace* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaScope* _tmp26_;
		ValaScope* _tmp27_;
		const gchar* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		_tmp23_ = vala_code_context_get_root (context);
		_tmp24_ = _tmp23_;
		base_symbol = (ValaSymbol*) _tmp24_;
		_tmp25_ = base_symbol;
		_tmp26_ = vala_symbol_get_scope (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_member_name;
		_tmp29_ = vala_scope_lookup (_tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
	} else {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		_tmp31_ = vala_member_access_get_inner (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == NULL) {
			const gchar* _tmp33_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			gboolean _tmp182_ = FALSE;
			ValaSymbol* _tmp183_;
			ValaSymbol* _tmp184_;
			_tmp33_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp33_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp34_;
				ValaSemanticAnalyzer* _tmp35_;
				_tmp34_ = vala_code_context_get_analyzer (context);
				_tmp35_ = _tmp34_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp35_)) {
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			sym = _tmp45_;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp93_;
				const gchar* _tmp94_;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp135_ = FALSE;
				gboolean _tmp136_ = FALSE;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				_tmp47_ = sym;
				if (_tmp47_ != NULL) {
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					_tmp48_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp49_ = _tmp48_;
					_tmp46_ = _tmp49_ == NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (!_tmp46_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp50_;
					_tmp50_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp50_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp51_;
						ValaCreationMethod* _tmp52_;
						ValaParameter* _tmp53_;
						ValaParameter* _tmp54_;
						_tmp51_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp52_ = cm;
						_tmp53_ = vala_method_get_this_parameter ((ValaMethod*) _tmp52_);
						_tmp54_ = _tmp53_;
						this_parameter = _tmp54_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp55_;
						_tmp55_ = sym;
						if (VALA_IS_PROPERTY (_tmp55_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaProperty* _tmp63_;
							ValaMemberBinding _tmp64_;
							ValaMemberBinding _tmp65_;
							_tmp56_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							this_parameter = _tmp59_;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_instance_members = _tmp62_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp63_ = prop;
							_tmp64_ = vala_property_get_binding (_tmp63_);
							_tmp65_ = _tmp64_;
							may_access_klass_members = _tmp65_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp66_;
							_tmp66_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp66_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaParameter* _tmp69_;
								ValaParameter* _tmp70_;
								ValaConstructor* _tmp71_;
								ValaMemberBinding _tmp72_;
								ValaMemberBinding _tmp73_;
								_tmp67_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_this_parameter (_tmp68_);
								_tmp70_ = _tmp69_;
								this_parameter = _tmp70_;
								_tmp71_ = c;
								_tmp72_ = vala_constructor_get_binding (_tmp71_);
								_tmp73_ = _tmp72_;
								may_access_instance_members = _tmp73_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp74_;
								_tmp74_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp74_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaParameter* _tmp77_;
									ValaParameter* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaMemberBinding _tmp80_;
									ValaMemberBinding _tmp81_;
									_tmp75_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_this_parameter (_tmp76_);
									_tmp78_ = _tmp77_;
									this_parameter = _tmp78_;
									_tmp79_ = d;
									_tmp80_ = vala_destructor_get_binding (_tmp79_);
									_tmp81_ = _tmp80_;
									may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp82_;
									_tmp82_ = sym;
									if (VALA_IS_METHOD (_tmp82_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp83_;
										ValaMethod* _tmp84_;
										ValaParameter* _tmp85_;
										ValaParameter* _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMethod* _tmp90_;
										ValaMemberBinding _tmp91_;
										ValaMemberBinding _tmp92_;
										_tmp83_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_METHOD, ValaMethod);
										_tmp84_ = m;
										_tmp85_ = vala_method_get_this_parameter (_tmp84_);
										_tmp86_ = _tmp85_;
										this_parameter = _tmp86_;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_instance_members = _tmp89_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_binding (_tmp90_);
										_tmp92_ = _tmp91_;
										may_access_klass_members = _tmp92_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp93_ = sym;
				_tmp94_ = self->priv->_member_name;
				_tmp95_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp93_, _tmp94_);
				_tmp96_ = _tmp95_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp96_);
				_vala_code_node_unref0 (_tmp96_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp99_;
					ValaSymbol* _tmp100_;
					_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp100_ = _tmp99_;
					_tmp98_ = _tmp100_ == NULL;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSymbol* _tmp101_;
					_tmp101_ = sym;
					_tmp97_ = VALA_IS_WITH_STATEMENT (_tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp102_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp103_;
					ValaLocalVariable* _tmp104_;
					ValaLocalVariable* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					ValaDataType* _tmp109_;
					ValaArrayList* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					const gchar* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					ValaSymbol* _tmp121_;
					_tmp102_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp103_ = w;
					_tmp104_ = vala_with_statement_get_with_variable (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_variable_get_variable_type ((ValaVariable*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = _vala_code_node_ref0 (_tmp107_);
					variable_type = _tmp108_;
					_tmp109_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp109_)) {
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_tmp110_ = variable_type;
						_tmp111_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp112_ = _tmp111_;
						_tmp113_ = _vala_code_node_ref0 (_tmp112_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp113_;
					}
					_tmp114_ = visited_types;
					_tmp115_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp114_, _tmp115_);
					_tmp116_ = variable_type;
					_tmp117_ = self->priv->_member_name;
					_tmp118_ = vala_data_type_get_member (_tmp116_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp119_);
					_vala_code_node_unref0 (_tmp119_);
					_tmp120_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp121_ = _tmp120_;
					if (_tmp121_ != NULL) {
						ValaWithStatement* _tmp122_;
						ValaLocalVariable* _tmp123_;
						ValaLocalVariable* _tmp124_;
						const gchar* _tmp125_;
						const gchar* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaSourceReference* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaMemberAccess* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaExpression* _tmp133_;
						ValaExpression* _tmp134_;
						_tmp122_ = w;
						_tmp123_ = vala_with_statement_get_with_variable (_tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_member_access_new (NULL, _tmp126_, _tmp128_);
						_tmp130_ = _tmp129_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp133_ = vala_member_access_get_inner (self);
						_tmp134_ = _tmp133_;
						vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp138_ = _tmp137_;
				if (_tmp138_ == NULL) {
					ValaSymbol* _tmp139_;
					_tmp139_ = sym;
					_tmp136_ = VALA_IS_TYPESYMBOL (_tmp139_);
				} else {
					_tmp136_ = FALSE;
				}
				if (_tmp136_) {
					_tmp135_ = may_access_instance_members;
				} else {
					_tmp135_ = FALSE;
				}
				if (_tmp135_) {
					ValaParameter* _tmp140_;
					ValaDataType* _tmp141_;
					ValaDataType* _tmp142_;
					const gchar* _tmp143_;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					gboolean _tmp146_ = FALSE;
					ValaSymbol* _tmp147_;
					ValaSymbol* _tmp148_;
					_tmp140_ = this_parameter;
					_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = self->priv->_member_name;
					_tmp144_ = vala_data_type_get_member (_tmp142_, _tmp143_);
					_tmp145_ = _tmp144_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp145_);
					_vala_code_node_unref0 (_tmp145_);
					_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp148_ = _tmp147_;
					if (_tmp148_ != NULL) {
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp146_ = vala_member_access_is_instance_symbol (_tmp150_);
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						ValaSourceReference* _tmp151_;
						ValaSourceReference* _tmp152_;
						ValaMemberAccess* _tmp153_;
						ValaMemberAccess* _tmp154_;
						ValaExpression* _tmp155_;
						ValaExpression* _tmp156_;
						ValaParameter* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaDataType* _tmp160_;
						ValaDataType* _tmp161_;
						ValaExpression* _tmp162_;
						ValaExpression* _tmp163_;
						ValaDataType* _tmp164_;
						ValaDataType* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaParameter* _tmp168_;
						ValaExpression* _tmp169_;
						ValaExpression* _tmp170_;
						ValaDataType* _tmp171_;
						ValaDataType* _tmp172_;
						const gchar* _tmp173_;
						ValaSymbol* _tmp174_;
						ValaSymbol* _tmp175_;
						_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_member_access_new (NULL, "this", _tmp152_);
						_tmp154_ = _tmp153_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = vala_member_access_get_inner (self);
						_tmp156_ = _tmp155_;
						_tmp157_ = this_parameter;
						_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
						_tmp159_ = _tmp158_;
						_tmp160_ = vala_data_type_copy (_tmp159_);
						_tmp161_ = _tmp160_;
						vala_expression_set_value_type (_tmp156_, _tmp161_);
						_vala_code_node_unref0 (_tmp161_);
						_tmp162_ = vala_member_access_get_inner (self);
						_tmp163_ = _tmp162_;
						_tmp164_ = vala_expression_get_value_type (_tmp163_);
						_tmp165_ = _tmp164_;
						vala_data_type_set_value_owned (_tmp165_, FALSE);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp167_, (ValaSymbol*) _tmp168_);
						_tmp169_ = vala_member_access_get_inner (self);
						_tmp170_ = _tmp169_;
						_tmp171_ = vala_expression_get_value_type (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = self->priv->_member_name;
						_tmp174_ = vala_data_type_get_member (_tmp172_, _tmp173_);
						_tmp175_ = _tmp174_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp175_);
						_vala_code_node_unref0 (_tmp175_);
					}
				}
				_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == NULL) {
					ValaSymbol* _tmp178_;
					_tmp178_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp178_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp179_ = sym;
				_tmp180_ = vala_symbol_get_parent_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				sym = _tmp181_;
			}
			_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp184_ = _tmp183_;
			if (_tmp184_ == NULL) {
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp186_ = _tmp185_;
				_tmp182_ = _tmp186_ != NULL;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaList* _tmp189_;
					ValaList* _tmp190_;
					gint _ns_size = 0;
					ValaList* _tmp191_;
					gint _tmp192_;
					gint _tmp193_;
					gint _ns_index = 0;
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_source_reference_get_using_directives (_tmp188_);
					_tmp190_ = _tmp189_;
					_ns_list = _tmp190_;
					_tmp191_ = _ns_list;
					_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
					_tmp193_ = _tmp192_;
					_ns_size = _tmp193_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp194_;
						gint _tmp195_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp196_;
						gpointer _tmp197_;
						ValaUsingDirective* _tmp198_;
						gboolean _tmp199_;
						gboolean _tmp200_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaSymbol* _tmp203_;
						ValaScope* _tmp204_;
						ValaScope* _tmp205_;
						const gchar* _tmp206_;
						ValaSymbol* _tmp207_;
						ValaSymbol* _tmp208_;
						_ns_index = _ns_index + 1;
						_tmp194_ = _ns_index;
						_tmp195_ = _ns_size;
						if (!(_tmp194_ < _tmp195_)) {
							break;
						}
						_tmp196_ = _ns_list;
						_tmp197_ = vala_list_get (_tmp196_, _ns_index);
						ns = (ValaUsingDirective*) _tmp197_;
						_tmp198_ = ns;
						_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
						_tmp200_ = _tmp199_;
						if (_tmp200_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp201_ = ns;
						_tmp202_ = vala_using_directive_get_namespace_symbol (_tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_symbol_get_scope (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = self->priv->_member_name;
						_tmp207_ = vala_scope_lookup (_tmp205_, _tmp206_);
						local_sym = _tmp207_;
						_tmp208_ = local_sym;
						if (_tmp208_ != NULL) {
							gboolean _tmp209_ = FALSE;
							ValaSymbol* _tmp210_;
							ValaSymbol* _tmp211_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp225_;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp247_;
							ValaExpression* _tmp248_;
							ValaExpression* _tmp249_;
							ValaSymbol* _tmp250_;
							_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp211_ = _tmp210_;
							if (_tmp211_ != NULL) {
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								ValaSymbol* _tmp214_;
								_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = local_sym;
								_tmp209_ = _tmp213_ != _tmp214_;
							} else {
								_tmp209_ = FALSE;
							}
							if (_tmp209_) {
								ValaSourceReference* _tmp215_;
								ValaSourceReference* _tmp216_;
								const gchar* _tmp217_;
								ValaSymbol* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								ValaSymbol* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = self->priv->_member_name;
								_tmp218_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp219_ = _tmp218_;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								_tmp222_ = local_sym;
								_tmp223_ = vala_symbol_get_full_name (_tmp222_);
								_tmp224_ = _tmp223_;
								vala_report_error (_tmp216_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp217_, _tmp221_, _tmp224_);
								_g_free0 (_tmp224_);
								_g_free0 (_tmp221_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp225_ = local_sym;
							_tmp226_ = vala_symbol_get_parent_symbol (_tmp225_);
							_tmp227_ = _tmp226_;
							inner_sym = _tmp227_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp228_ = FALSE;
								ValaSymbol* _tmp229_;
								ValaMemberAccess* _tmp233_;
								ValaSymbol* _tmp234_;
								const gchar* _tmp235_;
								const gchar* _tmp236_;
								ValaSourceReference* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaMemberAccess* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaExpression* _tmp242_;
								ValaExpression* _tmp243_;
								ValaSymbol* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								_tmp229_ = inner_sym;
								if (_tmp229_ != NULL) {
									ValaSymbol* _tmp230_;
									const gchar* _tmp231_;
									const gchar* _tmp232_;
									_tmp230_ = inner_sym;
									_tmp231_ = vala_symbol_get_name (_tmp230_);
									_tmp232_ = _tmp231_;
									_tmp228_ = _tmp232_ != NULL;
								} else {
									_tmp228_ = FALSE;
								}
								if (!_tmp228_) {
									break;
								}
								_tmp233_ = inner_ma;
								_tmp234_ = inner_sym;
								_tmp235_ = vala_symbol_get_name (_tmp234_);
								_tmp236_ = _tmp235_;
								_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp238_ = _tmp237_;
								_tmp239_ = vala_member_access_new (NULL, _tmp236_, _tmp238_);
								_tmp240_ = _tmp239_;
								vala_member_access_set_inner (_tmp233_, (ValaExpression*) _tmp240_);
								_vala_code_node_unref0 (_tmp240_);
								_tmp241_ = inner_ma;
								_tmp242_ = vala_member_access_get_inner (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp243_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp244_ = inner_sym;
								_tmp245_ = vala_symbol_get_parent_symbol (_tmp244_);
								_tmp246_ = _tmp245_;
								inner_sym = _tmp246_;
							}
							_tmp247_ = inner_ma;
							vala_member_access_set_qualified (_tmp247_, TRUE);
							_tmp248_ = vala_member_access_get_inner (self);
							_tmp249_ = _tmp248_;
							vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
							_tmp250_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp253_;
			gboolean _tmp254_;
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaDataType* _tmp257_;
			ValaDataType* _tmp258_;
			gboolean _tmp289_ = FALSE;
			ValaExpression* _tmp290_;
			ValaExpression* _tmp291_;
			ValaDataType* _tmp292_;
			ValaDataType* _tmp293_;
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			gboolean _tmp313_ = FALSE;
			ValaExpression* _tmp314_;
			ValaExpression* _tmp315_;
			gboolean _tmp322_ = FALSE;
			ValaExpression* _tmp323_;
			ValaExpression* _tmp324_;
			gboolean _tmp345_ = FALSE;
			ValaExpression* _tmp346_;
			ValaExpression* _tmp347_;
			gboolean _tmp362_ = FALSE;
			ValaSymbol* _tmp363_;
			ValaSymbol* _tmp364_;
			gboolean _tmp398_ = FALSE;
			gboolean _tmp399_ = FALSE;
			ValaSymbol* _tmp400_;
			ValaSymbol* _tmp401_;
			ValaSymbol* _tmp713_;
			ValaSymbol* _tmp714_;
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_code_node_get_error ((ValaCodeNode*) _tmp252_);
			_tmp254_ = _tmp253_;
			if (_tmp254_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp255_ = vala_member_access_get_inner (self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_value_type (_tmp256_);
			_tmp258_ = _tmp257_;
			if (VALA_IS_POINTER_TYPE (_tmp258_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaDataType* _tmp261_;
				ValaDataType* _tmp262_;
				gboolean _tmp263_ = FALSE;
				ValaPointerType* _tmp264_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_value_type (_tmp260_);
				_tmp262_ = _tmp261_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp262_) ? ((ValaPointerType*) _tmp262_) : NULL;
				_tmp264_ = pointer_type;
				if (_tmp264_ != NULL) {
					ValaPointerType* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					_tmp265_ = pointer_type;
					_tmp266_ = vala_pointer_type_get_base_type (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp263_ = VALA_IS_VALUE_TYPE (_tmp267_);
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaExpression* _tmp268_;
					ValaExpression* _tmp269_;
					ValaDataType* _tmp270_;
					ValaDataType* _tmp271_;
					ValaExpression* _tmp281_;
					ValaExpression* _tmp282_;
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaPointerIndirection* _tmp285_;
					ValaPointerIndirection* _tmp286_;
					ValaExpression* _tmp287_;
					ValaExpression* _tmp288_;
					_tmp268_ = vala_member_access_get_inner (self);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_expression_get_formal_value_type (_tmp269_);
					_tmp271_ = _tmp270_;
					if (VALA_IS_GENERIC_TYPE (_tmp271_)) {
						ValaExpression* _tmp272_;
						ValaExpression* _tmp273_;
						ValaPointerType* _tmp274_;
						ValaDataType* _tmp275_;
						ValaDataType* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaCastExpression* _tmp279_;
						ValaCastExpression* _tmp280_;
						_tmp272_ = vala_member_access_get_inner (self);
						_tmp273_ = _tmp272_;
						_tmp274_ = pointer_type;
						_tmp275_ = vala_data_type_copy ((ValaDataType*) _tmp274_);
						_tmp276_ = _tmp275_;
						_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp278_ = _tmp277_;
						_tmp279_ = vala_cast_expression_new (_tmp273_, _tmp276_, _tmp278_);
						_tmp280_ = _tmp279_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp280_);
						_vala_code_node_unref0 (_tmp280_);
						_vala_code_node_unref0 (_tmp276_);
					}
					_tmp281_ = vala_member_access_get_inner (self);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_pointer_indirection_new (_tmp282_, _tmp284_);
					_tmp286_ = _tmp285_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp286_);
					_vala_code_node_unref0 (_tmp286_);
					_tmp287_ = vala_member_access_get_inner (self);
					_tmp288_ = _tmp287_;
					vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp290_ = vala_member_access_get_inner (self);
			_tmp291_ = _tmp290_;
			_tmp292_ = vala_expression_get_value_type (_tmp291_);
			_tmp293_ = _tmp292_;
			if (VALA_IS_SIGNAL_TYPE (_tmp293_)) {
				const gchar* _tmp294_;
				_tmp294_ = self->priv->_member_name;
				_tmp289_ = g_strcmp0 (_tmp294_, "emit") == 0;
			} else {
				_tmp289_ = FALSE;
			}
			if (_tmp289_) {
				ValaCodeNode* _tmp295_;
				ValaCodeNode* _tmp296_;
				ValaExpression* _tmp297_;
				ValaExpression* _tmp298_;
				_tmp295_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp296_ = _tmp295_;
				_tmp297_ = vala_member_access_get_inner (self);
				_tmp298_ = _tmp297_;
				vala_code_node_replace_expression (_tmp296_, (ValaExpression*) self, _tmp298_);
				result = TRUE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp299_ = vala_member_access_get_inner (self);
			_tmp300_ = _tmp299_;
			if (VALA_IS_MEMBER_ACCESS (_tmp300_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaMemberAccess* _tmp303_;
				gboolean _tmp304_;
				_tmp301_ = vala_member_access_get_inner (self);
				_tmp302_ = _tmp301_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp303_ = ma;
				_tmp304_ = _tmp303_->priv->_prototype_access;
				if (_tmp304_) {
					ValaSourceReference* _tmp305_;
					ValaSourceReference* _tmp306_;
					ValaExpression* _tmp307_;
					ValaExpression* _tmp308_;
					ValaSymbol* _tmp309_;
					ValaSymbol* _tmp310_;
					gchar* _tmp311_;
					gchar* _tmp312_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp305_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_member_access_get_inner (self);
					_tmp308_ = _tmp307_;
					_tmp309_ = vala_expression_get_symbol_reference (_tmp308_);
					_tmp310_ = _tmp309_;
					_tmp311_ = vala_symbol_get_full_name (_tmp310_);
					_tmp312_ = _tmp311_;
					vala_report_error (_tmp306_, "Access to instance member `%s' denied", _tmp312_);
					_g_free0 (_tmp312_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp314_ = vala_member_access_get_inner (self);
			_tmp315_ = _tmp314_;
			if (VALA_IS_CAST_EXPRESSION (_tmp315_)) {
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				gboolean _tmp318_;
				gboolean _tmp319_;
				_tmp316_ = vala_member_access_get_inner (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp317_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp319_ = _tmp318_;
				_tmp313_ = _tmp319_;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaSourceReference* _tmp320_;
				ValaSourceReference* _tmp321_;
				_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				vala_report_warning (_tmp321_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp323_ = vala_member_access_get_inner (self);
			_tmp324_ = _tmp323_;
			if (VALA_IS_MEMBER_ACCESS (_tmp324_)) {
				_tmp322_ = TRUE;
			} else {
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				_tmp325_ = vala_member_access_get_inner (self);
				_tmp326_ = _tmp325_;
				_tmp322_ = VALA_IS_BASE_ACCESS (_tmp326_);
			}
			if (_tmp322_) {
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaSymbol* _tmp329_;
				ValaSymbol* _tmp330_;
				gboolean _tmp331_ = FALSE;
				ValaSymbol* _tmp332_;
				ValaSymbol* _tmp333_;
				_tmp327_ = vala_member_access_get_inner (self);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_expression_get_symbol_reference (_tmp328_);
				_tmp330_ = _tmp329_;
				base_symbol = _tmp330_;
				_tmp332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp333_ = _tmp332_;
				if (_tmp333_ == NULL) {
					gboolean _tmp334_ = FALSE;
					ValaSymbol* _tmp335_;
					_tmp335_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp335_)) {
						_tmp334_ = TRUE;
					} else {
						ValaSymbol* _tmp336_;
						_tmp336_ = base_symbol;
						_tmp334_ = VALA_IS_TYPESYMBOL (_tmp336_);
					}
					_tmp331_ = _tmp334_;
				} else {
					_tmp331_ = FALSE;
				}
				if (_tmp331_) {
					ValaSymbol* _tmp337_;
					ValaScope* _tmp338_;
					ValaScope* _tmp339_;
					const gchar* _tmp340_;
					ValaSymbol* _tmp341_;
					ValaSymbol* _tmp342_;
					ValaExpression* _tmp343_;
					ValaExpression* _tmp344_;
					_tmp337_ = base_symbol;
					_tmp338_ = vala_symbol_get_scope (_tmp337_);
					_tmp339_ = _tmp338_;
					_tmp340_ = self->priv->_member_name;
					_tmp341_ = vala_scope_lookup (_tmp339_, _tmp340_);
					_tmp342_ = _tmp341_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp342_);
					_vala_code_node_unref0 (_tmp342_);
					_tmp343_ = vala_member_access_get_inner (self);
					_tmp344_ = _tmp343_;
					if (VALA_IS_BASE_ACCESS (_tmp344_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp346_ = vala_member_access_get_inner (self);
			_tmp347_ = _tmp346_;
			if (VALA_IS_MEMBER_ACCESS (_tmp347_)) {
				ValaExpression* _tmp348_;
				ValaExpression* _tmp349_;
				ValaSymbol* _tmp350_;
				ValaSymbol* _tmp351_;
				_tmp348_ = vala_member_access_get_inner (self);
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_expression_get_symbol_reference (_tmp349_);
				_tmp351_ = _tmp350_;
				_tmp345_ = VALA_IS_TYPEPARAMETER (_tmp351_);
			} else {
				_tmp345_ = FALSE;
			}
			if (_tmp345_) {
				ValaExpression* _tmp352_;
				ValaExpression* _tmp353_;
				ValaExpression* _tmp354_;
				ValaExpression* _tmp355_;
				ValaSymbol* _tmp356_;
				ValaSymbol* _tmp357_;
				ValaSourceReference* _tmp358_;
				ValaSourceReference* _tmp359_;
				ValaGenericType* _tmp360_;
				ValaGenericType* _tmp361_;
				_tmp352_ = vala_member_access_get_inner (self);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_member_access_get_inner (self);
				_tmp355_ = _tmp354_;
				_tmp356_ = vala_expression_get_symbol_reference (_tmp355_);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp359_ = _tmp358_;
				_tmp360_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter), _tmp359_);
				_tmp361_ = _tmp360_;
				vala_expression_set_value_type (_tmp353_, (ValaDataType*) _tmp361_);
				_vala_code_node_unref0 (_tmp361_);
			}
			_tmp363_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp364_ = _tmp363_;
			if (_tmp364_ == NULL) {
				ValaExpression* _tmp365_;
				ValaExpression* _tmp366_;
				ValaDataType* _tmp367_;
				ValaDataType* _tmp368_;
				_tmp365_ = vala_member_access_get_inner (self);
				_tmp366_ = _tmp365_;
				_tmp367_ = vala_expression_get_value_type (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp362_ = _tmp368_ != NULL;
			} else {
				_tmp362_ = FALSE;
			}
			if (_tmp362_) {
				gboolean _tmp369_;
				ValaSymbol* _tmp396_;
				ValaSymbol* _tmp397_;
				_tmp369_ = self->priv->_pointer_member_access;
				if (_tmp369_) {
					ValaExpression* _tmp370_;
					ValaExpression* _tmp371_;
					ValaDataType* _tmp372_;
					ValaDataType* _tmp373_;
					const gchar* _tmp374_;
					ValaSymbol* _tmp375_;
					ValaSymbol* _tmp376_;
					_tmp370_ = vala_member_access_get_inner (self);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_expression_get_value_type (_tmp371_);
					_tmp373_ = _tmp372_;
					_tmp374_ = self->priv->_member_name;
					_tmp375_ = vala_data_type_get_pointer_member (_tmp373_, _tmp374_);
					_tmp376_ = _tmp375_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp376_);
					_vala_code_node_unref0 (_tmp376_);
				} else {
					ValaExpression* _tmp377_;
					ValaExpression* _tmp378_;
					ValaDataType* _tmp379_;
					ValaDataType* _tmp380_;
					ValaTypeSymbol* _tmp381_;
					ValaTypeSymbol* _tmp382_;
					ValaExpression* _tmp389_;
					ValaExpression* _tmp390_;
					ValaDataType* _tmp391_;
					ValaDataType* _tmp392_;
					const gchar* _tmp393_;
					ValaSymbol* _tmp394_;
					ValaSymbol* _tmp395_;
					_tmp377_ = vala_member_access_get_inner (self);
					_tmp378_ = _tmp377_;
					_tmp379_ = vala_expression_get_value_type (_tmp378_);
					_tmp380_ = _tmp379_;
					_tmp381_ = vala_data_type_get_type_symbol (_tmp380_);
					_tmp382_ = _tmp381_;
					if (_tmp382_ != NULL) {
						ValaExpression* _tmp383_;
						ValaExpression* _tmp384_;
						ValaDataType* _tmp385_;
						ValaDataType* _tmp386_;
						ValaTypeSymbol* _tmp387_;
						ValaTypeSymbol* _tmp388_;
						_tmp383_ = vala_member_access_get_inner (self);
						_tmp384_ = _tmp383_;
						_tmp385_ = vala_expression_get_value_type (_tmp384_);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_data_type_get_type_symbol (_tmp386_);
						_tmp388_ = _tmp387_;
						base_symbol = (ValaSymbol*) _tmp388_;
					}
					_tmp389_ = vala_member_access_get_inner (self);
					_tmp390_ = _tmp389_;
					_tmp391_ = vala_expression_get_value_type (_tmp390_);
					_tmp392_ = _tmp391_;
					_tmp393_ = self->priv->_member_name;
					_tmp394_ = vala_data_type_get_member (_tmp392_, _tmp393_);
					_tmp395_ = _tmp394_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp395_);
					_vala_code_node_unref0 (_tmp395_);
				}
				_tmp396_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp397_ = _tmp396_;
				if (_tmp397_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp401_ = _tmp400_;
			if (_tmp401_ == NULL) {
				ValaExpression* _tmp402_;
				ValaExpression* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp405_;
				_tmp402_ = vala_member_access_get_inner (self);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_expression_get_value_type (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp399_ = _tmp405_ != NULL;
			} else {
				_tmp399_ = FALSE;
			}
			if (_tmp399_) {
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				gboolean _tmp410_;
				gboolean _tmp411_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_data_type_get_is_dynamic (_tmp409_);
				_tmp411_ = _tmp410_;
				_tmp398_ = _tmp411_;
			} else {
				_tmp398_ = FALSE;
			}
			if (_tmp398_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp412_;
				ValaExpression* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaObjectType* _tmp416_;
				ValaCodeNode* _tmp417_;
				ValaCodeNode* _tmp418_;
				ValaSymbol* _tmp648_;
				ValaSymbol* _tmp649_;
				ValaSymbol* _tmp711_;
				ValaSymbol* _tmp712_;
				_tmp412_ = vala_member_access_get_inner (self);
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_expression_get_value_type (_tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp415_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp416_;
				_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp418_ = _tmp417_;
				if (VALA_IS_METHOD_CALL (_tmp418_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp419_;
					ValaCodeNode* _tmp420_;
					ValaMethodCall* _tmp421_;
					ValaExpression* _tmp422_;
					ValaExpression* _tmp423_;
					_tmp419_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp420_ = _tmp419_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp421_ = invoc;
					_tmp422_ = vala_callable_expression_get_call ((ValaCallableExpression*) _tmp421_);
					_tmp423_ = _tmp422_;
					if (_tmp423_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp424_;
						ValaDataType* _tmp425_;
						ValaDataType* _tmp426_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp441_;
						ValaExpression* _tmp442_;
						ValaDataType* _tmp443_;
						ValaDataType* _tmp444_;
						const gchar* _tmp445_;
						ValaDataType* _tmp446_;
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						ValaDynamicMethod* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						ValaMethodCall* _tmp451_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp452_;
						ValaSourceReference* _tmp453_;
						ValaSourceReference* _tmp454_;
						ValaErrorType* _tmp455_;
						ValaErrorType* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaErrorType* _tmp458_;
						ValaDynamicMethod* _tmp459_;
						ValaDynamicMethod* _tmp460_;
						ValaParameter* _tmp461_;
						ValaParameter* _tmp462_;
						ValaDynamicMethod* _tmp463_;
						ValaObjectType* _tmp464_;
						ValaDataType* _tmp465_;
						ValaDataType* _tmp466_;
						ValaDynamicMethod* _tmp467_;
						ValaSourceReference* _tmp468_;
						ValaSourceReference* _tmp469_;
						ValaParameter* _tmp470_;
						ValaParameter* _tmp471_;
						ValaObjectType* _tmp472_;
						ValaTypeSymbol* _tmp473_;
						ValaTypeSymbol* _tmp474_;
						ValaScope* _tmp475_;
						ValaScope* _tmp476_;
						ValaDynamicMethod* _tmp477_;
						ValaDynamicMethod* _tmp478_;
						_tmp424_ = invoc;
						_tmp425_ = vala_expression_get_target_type ((ValaExpression*) _tmp424_);
						_tmp426_ = _tmp425_;
						if (_tmp426_ != NULL) {
							ValaMethodCall* _tmp427_;
							ValaDataType* _tmp428_;
							ValaDataType* _tmp429_;
							ValaDataType* _tmp430_;
							ValaDataType* _tmp431_;
							_tmp427_ = invoc;
							_tmp428_ = vala_expression_get_target_type ((ValaExpression*) _tmp427_);
							_tmp429_ = _tmp428_;
							_tmp430_ = vala_data_type_copy (_tmp429_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp430_;
							_tmp431_ = ret_type;
							vala_data_type_set_value_owned (_tmp431_, TRUE);
						} else {
							ValaMethodCall* _tmp432_;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							_tmp432_ = invoc;
							_tmp433_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp432_);
							_tmp434_ = _tmp433_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp434_)) {
								ValaVoidType* _tmp435_;
								_tmp435_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp435_;
							} else {
								ValaExpression* _tmp436_;
								ValaExpression* _tmp437_;
								ValaDataType* _tmp438_;
								ValaDataType* _tmp439_;
								ValaDataType* _tmp440_;
								_tmp436_ = vala_member_access_get_inner (self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_expression_get_value_type (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = vala_data_type_copy (_tmp439_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp440_;
							}
						}
						_tmp441_ = vala_member_access_get_inner (self);
						_tmp442_ = _tmp441_;
						_tmp443_ = vala_expression_get_value_type (_tmp442_);
						_tmp444_ = _tmp443_;
						_tmp445_ = self->priv->_member_name;
						_tmp446_ = ret_type;
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp448_ = _tmp447_;
						_tmp449_ = vala_dynamic_method_new (_tmp444_, _tmp445_, _tmp446_, _tmp448_, NULL);
						m = _tmp449_;
						_tmp450_ = m;
						_tmp451_ = invoc;
						vala_dynamic_method_set_invocation (_tmp450_, _tmp451_);
						_tmp452_ = m;
						_tmp453_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp452_);
						_tmp454_ = _tmp453_;
						_tmp455_ = vala_error_type_new (NULL, NULL, _tmp454_);
						err = _tmp455_;
						_tmp456_ = err;
						vala_error_type_set_dynamic_error (_tmp456_, TRUE);
						_tmp457_ = m;
						_tmp458_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp457_, (ValaDataType*) _tmp458_);
						_tmp459_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp459_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp460_ = m;
						_tmp461_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp462_ = _tmp461_;
						vala_callable_add_parameter ((ValaCallable*) _tmp460_, _tmp462_);
						_vala_code_node_unref0 (_tmp462_);
						_tmp463_ = m;
						_tmp464_ = dynamic_object_type;
						_tmp465_ = vala_data_type_copy ((ValaDataType*) _tmp464_);
						_tmp466_ = _tmp465_;
						_tmp467_ = m;
						_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp467_);
						_tmp469_ = _tmp468_;
						_tmp470_ = vala_parameter_new ("this", _tmp466_, _tmp469_);
						_tmp471_ = _tmp470_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp463_, _tmp471_);
						_vala_code_node_unref0 (_tmp471_);
						_vala_code_node_unref0 (_tmp466_);
						_tmp472_ = dynamic_object_type;
						_tmp473_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp472_);
						_tmp474_ = _tmp473_;
						_tmp475_ = vala_symbol_get_scope ((ValaSymbol*) _tmp474_);
						_tmp476_ = _tmp475_;
						_tmp477_ = m;
						vala_scope_add (_tmp476_, NULL, (ValaSymbol*) _tmp477_);
						_tmp478_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp478_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp479_;
					ValaCodeNode* _tmp480_;
					_tmp479_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp480_ = _tmp479_;
					if (VALA_IS_ASSIGNMENT (_tmp480_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp481_;
						ValaCodeNode* _tmp482_;
						ValaAssignment* _tmp483_;
						ValaExpression* _tmp484_;
						ValaExpression* _tmp485_;
						_tmp481_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp482_ = _tmp481_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp483_ = a;
						_tmp484_ = vala_assignment_get_left (_tmp483_);
						_tmp485_ = _tmp484_;
						if (_tmp485_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp486_;
							ValaExpression* _tmp487_;
							ValaDataType* _tmp488_;
							ValaDataType* _tmp489_;
							const gchar* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaDynamicProperty* _tmp493_;
							ValaDynamicProperty* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaDynamicProperty* _tmp496_;
							ValaSourceReference* _tmp497_;
							ValaSourceReference* _tmp498_;
							ValaPropertyAccessor* _tmp499_;
							ValaPropertyAccessor* _tmp500_;
							ValaDynamicProperty* _tmp501_;
							ValaExpression* _tmp502_;
							ValaExpression* _tmp503_;
							ValaDataType* _tmp504_;
							ValaDataType* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaTypeSymbol* _tmp507_;
							ValaScope* _tmp508_;
							ValaScope* _tmp509_;
							ValaObjectType* _tmp510_;
							ValaTypeSymbol* _tmp511_;
							ValaTypeSymbol* _tmp512_;
							ValaScope* _tmp513_;
							ValaScope* _tmp514_;
							ValaDynamicProperty* _tmp515_;
							ValaDynamicProperty* _tmp516_;
							ValaObjectType* _tmp517_;
							ValaTypeSymbol* _tmp518_;
							ValaTypeSymbol* _tmp519_;
							ValaSemanticAnalyzer* _tmp520_;
							ValaSemanticAnalyzer* _tmp521_;
							ValaClass* _tmp522_;
							_tmp486_ = vala_member_access_get_inner (self);
							_tmp487_ = _tmp486_;
							_tmp488_ = vala_expression_get_value_type (_tmp487_);
							_tmp489_ = _tmp488_;
							_tmp490_ = self->priv->_member_name;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_dynamic_property_new (_tmp489_, _tmp490_, _tmp492_, NULL);
							prop = _tmp493_;
							_tmp494_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp494_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp495_ = prop;
							_tmp496_ = prop;
							_tmp497_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp496_);
							_tmp498_ = _tmp497_;
							_tmp499_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp498_, NULL);
							_tmp500_ = _tmp499_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp495_, _tmp500_);
							_vala_code_node_unref0 (_tmp500_);
							_tmp501_ = prop;
							_tmp502_ = vala_member_access_get_inner (self);
							_tmp503_ = _tmp502_;
							_tmp504_ = vala_expression_get_value_type (_tmp503_);
							_tmp505_ = _tmp504_;
							_tmp506_ = vala_data_type_get_type_symbol (_tmp505_);
							_tmp507_ = _tmp506_;
							_tmp508_ = vala_symbol_get_scope ((ValaSymbol*) _tmp507_);
							_tmp509_ = _tmp508_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp501_, _tmp509_);
							_tmp510_ = dynamic_object_type;
							_tmp511_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp510_);
							_tmp512_ = _tmp511_;
							_tmp513_ = vala_symbol_get_scope ((ValaSymbol*) _tmp512_);
							_tmp514_ = _tmp513_;
							_tmp515_ = prop;
							vala_scope_add (_tmp514_, NULL, (ValaSymbol*) _tmp515_);
							_tmp516_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp516_);
							_tmp517_ = dynamic_object_type;
							_tmp518_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp517_);
							_tmp519_ = _tmp518_;
							_tmp520_ = vala_code_context_get_analyzer (context);
							_tmp521_ = _tmp520_;
							_tmp522_ = _tmp521_->object_type;
							if (!vala_typesymbol_is_subtype_of (_tmp519_, (ValaTypeSymbol*) _tmp522_)) {
								ValaSourceReference* _tmp523_;
								ValaSourceReference* _tmp524_;
								ValaObjectType* _tmp525_;
								ValaTypeSymbol* _tmp526_;
								ValaTypeSymbol* _tmp527_;
								gchar* _tmp528_;
								gchar* _tmp529_;
								_tmp523_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp524_ = _tmp523_;
								_tmp525_ = dynamic_object_type;
								_tmp526_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp525_);
								_tmp527_ = _tmp526_;
								_tmp528_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp527_);
								_tmp529_ = _tmp528_;
								vala_report_error (_tmp524_, "dynamic properties are not supported for `%s'", _tmp529_);
								_g_free0 (_tmp529_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							}
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp530_ = FALSE;
						gboolean _tmp531_ = FALSE;
						ValaCodeNode* _tmp532_;
						ValaCodeNode* _tmp533_;
						_tmp532_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp533_ = _tmp532_;
						if (VALA_IS_MEMBER_ACCESS (_tmp533_)) {
							ValaExpression* _tmp534_;
							ValaExpression* _tmp535_;
							_tmp534_ = vala_member_access_get_inner (self);
							_tmp535_ = _tmp534_;
							_tmp531_ = VALA_IS_MEMBER_ACCESS (_tmp535_);
						} else {
							_tmp531_ = FALSE;
						}
						if (_tmp531_) {
							ValaCodeNode* _tmp536_;
							ValaCodeNode* _tmp537_;
							ValaCodeNode* _tmp538_;
							ValaCodeNode* _tmp539_;
							_tmp536_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp537_ = _tmp536_;
							_tmp538_ = vala_code_node_get_parent_node (_tmp537_);
							_tmp539_ = _tmp538_;
							_tmp530_ = VALA_IS_METHOD_CALL (_tmp539_);
						} else {
							_tmp530_ = FALSE;
						}
						if (_tmp530_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp540_;
							ValaCodeNode* _tmp541_;
							gboolean _tmp542_ = FALSE;
							ValaMemberAccess* _tmp543_;
							const gchar* _tmp544_;
							_tmp540_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp541_ = _tmp540_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp541_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp543_ = ma;
							_tmp544_ = _tmp543_->priv->_member_name;
							if (g_strcmp0 (_tmp544_, "connect") == 0) {
								_tmp542_ = TRUE;
							} else {
								ValaMemberAccess* _tmp545_;
								const gchar* _tmp546_;
								_tmp545_ = ma;
								_tmp546_ = _tmp545_->priv->_member_name;
								_tmp542_ = g_strcmp0 (_tmp546_, "connect_after") == 0;
							}
							if (_tmp542_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp547_;
								ValaExpression* _tmp548_;
								ValaDataType* _tmp549_;
								ValaDataType* _tmp550_;
								const gchar* _tmp551_;
								ValaVoidType* _tmp552_;
								ValaVoidType* _tmp553_;
								ValaSourceReference* _tmp554_;
								ValaSourceReference* _tmp555_;
								ValaDynamicSignal* _tmp556_;
								ValaDynamicSignal* _tmp557_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp558_;
								ValaCodeNode* _tmp559_;
								ValaCodeNode* _tmp560_;
								ValaCodeNode* _tmp561_;
								ValaMethodCall* _tmp562_;
								ValaMethodCall* _tmp563_;
								ValaList* _tmp564_;
								gint _tmp565_;
								gint _tmp566_;
								ValaDynamicSignal* _tmp598_;
								ValaObjectType* _tmp599_;
								ValaTypeSymbol* _tmp600_;
								ValaTypeSymbol* _tmp601_;
								ValaScope* _tmp602_;
								ValaScope* _tmp603_;
								ValaDynamicSignal* _tmp604_;
								ValaDynamicSignal* _tmp605_;
								_tmp547_ = vala_member_access_get_inner (self);
								_tmp548_ = _tmp547_;
								_tmp549_ = vala_expression_get_value_type (_tmp548_);
								_tmp550_ = _tmp549_;
								_tmp551_ = self->priv->_member_name;
								_tmp552_ = vala_void_type_new (NULL);
								_tmp553_ = _tmp552_;
								_tmp554_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp555_ = _tmp554_;
								_tmp556_ = vala_dynamic_signal_new (_tmp550_, _tmp551_, (ValaDataType*) _tmp553_, _tmp555_, NULL);
								_tmp557_ = _tmp556_;
								_vala_code_node_unref0 (_tmp553_);
								s = _tmp557_;
								_tmp558_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp559_ = _tmp558_;
								_tmp560_ = vala_code_node_get_parent_node (_tmp559_);
								_tmp561_ = _tmp560_;
								_tmp562_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp561_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp562_;
								_tmp563_ = mcall;
								_tmp564_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp563_);
								_tmp565_ = vala_collection_get_size ((ValaCollection*) _tmp564_);
								_tmp566_ = _tmp565_;
								if (_tmp566_ > 0) {
									ValaDynamicSignal* _tmp567_;
									ValaMethodCall* _tmp568_;
									ValaList* _tmp569_;
									gpointer _tmp570_;
									ValaExpression* _tmp571_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp572_;
									ValaExpression* _tmp573_;
									ValaExpression* _tmp574_;
									gboolean _tmp575_ = FALSE;
									gboolean _tmp576_ = FALSE;
									ValaMemberAccess* _tmp577_;
									_tmp567_ = s;
									_tmp568_ = mcall;
									_tmp569_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp568_);
									_tmp570_ = vala_list_get (_tmp569_, 0);
									_tmp571_ = (ValaExpression*) _tmp570_;
									vala_dynamic_signal_set_handler (_tmp567_, _tmp571_);
									_vala_code_node_unref0 (_tmp571_);
									_tmp572_ = s;
									_tmp573_ = vala_dynamic_signal_get_handler (_tmp572_);
									_tmp574_ = _tmp573_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp574_) ? ((ValaMemberAccess*) _tmp574_) : NULL;
									_tmp577_ = arg;
									if (_tmp577_ == NULL) {
										_tmp576_ = TRUE;
									} else {
										ValaMemberAccess* _tmp578_;
										_tmp578_ = arg;
										_tmp576_ = !vala_code_node_check ((ValaCodeNode*) _tmp578_, context);
									}
									if (_tmp576_) {
										_tmp575_ = TRUE;
									} else {
										ValaMemberAccess* _tmp579_;
										ValaSymbol* _tmp580_;
										ValaSymbol* _tmp581_;
										_tmp579_ = arg;
										_tmp580_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp579_);
										_tmp581_ = _tmp580_;
										_tmp575_ = !VALA_IS_METHOD (_tmp581_);
									}
									if (_tmp575_) {
										ValaDynamicSignal* _tmp582_;
										ValaExpression* _tmp583_;
										ValaExpression* _tmp584_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp582_ = s;
										_tmp583_ = vala_dynamic_signal_get_handler (_tmp582_);
										_tmp584_ = _tmp583_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp584_)) {
											ValaDynamicSignal* _tmp585_;
											ValaExpression* _tmp586_;
											ValaExpression* _tmp587_;
											ValaSourceReference* _tmp588_;
											ValaSourceReference* _tmp589_;
											_tmp585_ = s;
											_tmp586_ = vala_dynamic_signal_get_handler (_tmp585_);
											_tmp587_ = _tmp586_;
											_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp587_);
											_tmp589_ = _tmp588_;
											vala_report_error (_tmp589_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp590_;
											ValaExpression* _tmp591_;
											ValaExpression* _tmp592_;
											ValaSourceReference* _tmp593_;
											ValaSourceReference* _tmp594_;
											ValaDynamicSignal* _tmp595_;
											gchar* _tmp596_;
											gchar* _tmp597_;
											_tmp590_ = s;
											_tmp591_ = vala_dynamic_signal_get_handler (_tmp590_);
											_tmp592_ = _tmp591_;
											_tmp593_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp592_);
											_tmp594_ = _tmp593_;
											_tmp595_ = s;
											_tmp596_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp595_);
											_tmp597_ = _tmp596_;
											vala_report_error (_tmp594_, "Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp597_);
											_g_free0 (_tmp597_);
										}
									}
								}
								_tmp598_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp598_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp599_ = dynamic_object_type;
								_tmp600_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp599_);
								_tmp601_ = _tmp600_;
								_tmp602_ = vala_symbol_get_scope ((ValaSymbol*) _tmp601_);
								_tmp603_ = _tmp602_;
								_tmp604_ = s;
								vala_scope_add (_tmp603_, NULL, (ValaSymbol*) _tmp604_);
								_tmp605_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp605_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp606_;
								const gchar* _tmp607_;
								_tmp606_ = ma;
								_tmp607_ = _tmp606_->priv->_member_name;
								if (g_strcmp0 (_tmp607_, "emit") == 0) {
									ValaMethodCall* mcall = NULL;
									ValaMemberAccess* _tmp608_;
									ValaCodeNode* _tmp609_;
									ValaCodeNode* _tmp610_;
									ValaDataType* _tmp611_ = NULL;
									ValaMethodCall* _tmp612_;
									ValaDataType* _tmp613_;
									ValaDataType* _tmp614_;
									ValaDataType* _tmp615_;
									ValaDataType* return_type = NULL;
									ValaDataType* _tmp617_;
									ValaDataType* _tmp618_;
									ValaDynamicSignal* s = NULL;
									ValaExpression* _tmp623_;
									ValaExpression* _tmp624_;
									ValaDataType* _tmp625_;
									ValaDataType* _tmp626_;
									const gchar* _tmp627_;
									ValaDataType* _tmp628_;
									ValaSourceReference* _tmp629_;
									ValaSourceReference* _tmp630_;
									ValaDynamicSignal* _tmp631_;
									ValaDynamicSignal* _tmp632_;
									ValaDynamicSignal* _tmp633_;
									ValaParameter* _tmp634_;
									ValaParameter* _tmp635_;
									ValaObjectType* _tmp636_;
									ValaTypeSymbol* _tmp637_;
									ValaTypeSymbol* _tmp638_;
									ValaScope* _tmp639_;
									ValaScope* _tmp640_;
									ValaDynamicSignal* _tmp641_;
									ValaDynamicSignal* _tmp642_;
									_tmp608_ = ma;
									_tmp609_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp608_);
									_tmp610_ = _tmp609_;
									mcall = G_TYPE_CHECK_INSTANCE_CAST (_tmp610_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
									_tmp612_ = mcall;
									_tmp613_ = vala_expression_get_target_type ((ValaExpression*) _tmp612_);
									_tmp614_ = _tmp613_;
									_tmp615_ = _vala_code_node_ref0 (_tmp614_);
									_tmp611_ = _tmp615_;
									if (_tmp611_ == NULL) {
										ValaVoidType* _tmp616_;
										_tmp616_ = vala_void_type_new (NULL);
										_vala_code_node_unref0 (_tmp611_);
										_tmp611_ = (ValaDataType*) _tmp616_;
									}
									_tmp617_ = _tmp611_;
									_tmp611_ = NULL;
									return_type = _tmp617_;
									_tmp618_ = return_type;
									if (VALA_IS_VAR_TYPE (_tmp618_)) {
										ValaMethodCall* _tmp619_;
										ValaSourceReference* _tmp620_;
										ValaSourceReference* _tmp621_;
										const gchar* _tmp622_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp619_ = mcall;
										_tmp620_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp619_);
										_tmp621_ = _tmp620_;
										_tmp622_ = self->priv->_member_name;
										vala_report_error (_tmp621_, "Cannot infer return type for dynamic signal `%s' from given context", _tmp622_);
									}
									_tmp623_ = vala_member_access_get_inner (self);
									_tmp624_ = _tmp623_;
									_tmp625_ = vala_expression_get_value_type (_tmp624_);
									_tmp626_ = _tmp625_;
									_tmp627_ = self->priv->_member_name;
									_tmp628_ = return_type;
									_tmp629_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp630_ = _tmp629_;
									_tmp631_ = vala_dynamic_signal_new (_tmp626_, _tmp627_, _tmp628_, _tmp630_, NULL);
									s = _tmp631_;
									_tmp632_ = s;
									vala_symbol_set_access ((ValaSymbol*) _tmp632_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
									_tmp633_ = s;
									_tmp634_ = vala_parameter_new_with_ellipsis (NULL);
									_tmp635_ = _tmp634_;
									vala_callable_add_parameter ((ValaCallable*) _tmp633_, _tmp635_);
									_vala_code_node_unref0 (_tmp635_);
									_tmp636_ = dynamic_object_type;
									_tmp637_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp636_);
									_tmp638_ = _tmp637_;
									_tmp639_ = vala_symbol_get_scope ((ValaSymbol*) _tmp638_);
									_tmp640_ = _tmp639_;
									_tmp641_ = s;
									vala_scope_add (_tmp640_, NULL, (ValaSymbol*) _tmp641_);
									_tmp642_ = s;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp642_);
									_vala_code_node_unref0 (s);
									_vala_code_node_unref0 (return_type);
									_vala_code_node_unref0 (_tmp611_);
								} else {
									ValaMemberAccess* _tmp643_;
									const gchar* _tmp644_;
									_tmp643_ = ma;
									_tmp644_ = _tmp643_->priv->_member_name;
									if (g_strcmp0 (_tmp644_, "disconnect") == 0) {
										ValaMemberAccess* _tmp645_;
										ValaSourceReference* _tmp646_;
										ValaSourceReference* _tmp647_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp645_ = ma;
										_tmp646_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp645_);
										_tmp647_ = _tmp646_;
										vala_report_error (_tmp647_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
									}
								}
							}
						}
					}
				}
				_tmp648_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp649_ = _tmp648_;
				if (_tmp649_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp650_;
					ValaExpression* _tmp651_;
					ValaDataType* _tmp652_;
					ValaDataType* _tmp653_;
					const gchar* _tmp654_;
					ValaSourceReference* _tmp655_;
					ValaSourceReference* _tmp656_;
					ValaDynamicProperty* _tmp657_;
					ValaDataType* _tmp658_;
					ValaDataType* _tmp659_;
					ValaDynamicProperty* _tmp670_;
					ValaDynamicProperty* _tmp671_;
					ValaDynamicProperty* _tmp672_;
					ValaDataType* _tmp673_;
					ValaDataType* _tmp674_;
					ValaDataType* _tmp675_;
					ValaDataType* _tmp676_;
					ValaDynamicProperty* _tmp677_;
					ValaSourceReference* _tmp678_;
					ValaSourceReference* _tmp679_;
					ValaPropertyAccessor* _tmp680_;
					ValaPropertyAccessor* _tmp681_;
					ValaDynamicProperty* _tmp682_;
					ValaExpression* _tmp683_;
					ValaExpression* _tmp684_;
					ValaDataType* _tmp685_;
					ValaDataType* _tmp686_;
					ValaTypeSymbol* _tmp687_;
					ValaTypeSymbol* _tmp688_;
					ValaScope* _tmp689_;
					ValaScope* _tmp690_;
					ValaObjectType* _tmp691_;
					ValaTypeSymbol* _tmp692_;
					ValaTypeSymbol* _tmp693_;
					ValaScope* _tmp694_;
					ValaScope* _tmp695_;
					ValaDynamicProperty* _tmp696_;
					ValaDynamicProperty* _tmp697_;
					ValaObjectType* _tmp698_;
					ValaTypeSymbol* _tmp699_;
					ValaTypeSymbol* _tmp700_;
					ValaSemanticAnalyzer* _tmp701_;
					ValaSemanticAnalyzer* _tmp702_;
					ValaClass* _tmp703_;
					_tmp650_ = vala_member_access_get_inner (self);
					_tmp651_ = _tmp650_;
					_tmp652_ = vala_expression_get_value_type (_tmp651_);
					_tmp653_ = _tmp652_;
					_tmp654_ = self->priv->_member_name;
					_tmp655_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp656_ = _tmp655_;
					_tmp657_ = vala_dynamic_property_new (_tmp653_, _tmp654_, _tmp656_, NULL);
					prop = _tmp657_;
					_tmp658_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp659_ = _tmp658_;
					if (_tmp659_ != NULL) {
						ValaDynamicProperty* _tmp660_;
						ValaDataType* _tmp661_;
						ValaDataType* _tmp662_;
						_tmp660_ = prop;
						_tmp661_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp662_ = _tmp661_;
						vala_property_set_property_type ((ValaProperty*) _tmp660_, _tmp662_);
					} else {
						ValaDynamicProperty* _tmp663_;
						ValaExpression* _tmp664_;
						ValaExpression* _tmp665_;
						ValaDataType* _tmp666_;
						ValaDataType* _tmp667_;
						ValaDataType* _tmp668_;
						ValaDataType* _tmp669_;
						_tmp663_ = prop;
						_tmp664_ = vala_member_access_get_inner (self);
						_tmp665_ = _tmp664_;
						_tmp666_ = vala_expression_get_value_type (_tmp665_);
						_tmp667_ = _tmp666_;
						_tmp668_ = vala_data_type_copy (_tmp667_);
						_tmp669_ = _tmp668_;
						vala_property_set_property_type ((ValaProperty*) _tmp663_, _tmp669_);
						_vala_code_node_unref0 (_tmp669_);
					}
					_tmp670_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp670_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp671_ = prop;
					_tmp672_ = prop;
					_tmp673_ = vala_property_get_property_type ((ValaProperty*) _tmp672_);
					_tmp674_ = _tmp673_;
					_tmp675_ = vala_data_type_copy (_tmp674_);
					_tmp676_ = _tmp675_;
					_tmp677_ = prop;
					_tmp678_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp677_);
					_tmp679_ = _tmp678_;
					_tmp680_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp676_, NULL, _tmp679_, NULL);
					_tmp681_ = _tmp680_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp671_, _tmp681_);
					_vala_code_node_unref0 (_tmp681_);
					_vala_code_node_unref0 (_tmp676_);
					_tmp682_ = prop;
					_tmp683_ = vala_member_access_get_inner (self);
					_tmp684_ = _tmp683_;
					_tmp685_ = vala_expression_get_value_type (_tmp684_);
					_tmp686_ = _tmp685_;
					_tmp687_ = vala_data_type_get_type_symbol (_tmp686_);
					_tmp688_ = _tmp687_;
					_tmp689_ = vala_symbol_get_scope ((ValaSymbol*) _tmp688_);
					_tmp690_ = _tmp689_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp682_, _tmp690_);
					_tmp691_ = dynamic_object_type;
					_tmp692_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp691_);
					_tmp693_ = _tmp692_;
					_tmp694_ = vala_symbol_get_scope ((ValaSymbol*) _tmp693_);
					_tmp695_ = _tmp694_;
					_tmp696_ = prop;
					vala_scope_add (_tmp695_, NULL, (ValaSymbol*) _tmp696_);
					_tmp697_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp697_);
					_tmp698_ = dynamic_object_type;
					_tmp699_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp698_);
					_tmp700_ = _tmp699_;
					_tmp701_ = vala_code_context_get_analyzer (context);
					_tmp702_ = _tmp701_;
					_tmp703_ = _tmp702_->object_type;
					if (!vala_typesymbol_is_subtype_of (_tmp700_, (ValaTypeSymbol*) _tmp703_)) {
						ValaSourceReference* _tmp704_;
						ValaSourceReference* _tmp705_;
						ValaObjectType* _tmp706_;
						ValaTypeSymbol* _tmp707_;
						ValaTypeSymbol* _tmp708_;
						gchar* _tmp709_;
						gchar* _tmp710_;
						_tmp704_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp705_ = _tmp704_;
						_tmp706_ = dynamic_object_type;
						_tmp707_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp706_);
						_tmp708_ = _tmp707_;
						_tmp709_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp708_);
						_tmp710_ = _tmp709_;
						vala_report_error (_tmp705_, "dynamic properties are not supported for %s", _tmp710_);
						_g_free0 (_tmp710_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_vala_code_node_unref0 (prop);
				}
				_tmp711_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp712_ = _tmp711_;
				if (_tmp712_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp713_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp714_ = _tmp713_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp714_)) {
				ValaExpression* _tmp715_;
				ValaExpression* _tmp716_;
				ValaSymbol* _tmp717_;
				ValaSymbol* _tmp718_;
				_tmp715_ = vala_member_access_get_inner (self);
				_tmp716_ = _tmp715_;
				_tmp717_ = vala_expression_get_symbol_reference (_tmp716_);
				_tmp718_ = _tmp717_;
				if (VALA_IS_VARIABLE (_tmp718_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp719_;
					ValaSemanticAnalyzer* _tmp720_;
					ValaExpression* _tmp721_;
					ValaExpression* _tmp722_;
					ValaSymbol* _tmp723_;
					ValaSymbol* _tmp724_;
					ValaDataType* _tmp725_;
					ValaArrayType* _tmp726_;
					gboolean _tmp727_ = FALSE;
					ValaArrayType* _tmp728_;
					_tmp719_ = vala_code_context_get_analyzer (context);
					_tmp720_ = _tmp719_;
					_tmp721_ = vala_member_access_get_inner (self);
					_tmp722_ = _tmp721_;
					_tmp723_ = vala_expression_get_symbol_reference (_tmp722_);
					_tmp724_ = _tmp723_;
					_tmp725_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp720_, _tmp724_, TRUE);
					_tmp726_ = VALA_IS_ARRAY_TYPE (_tmp725_) ? ((ValaArrayType*) _tmp725_) : NULL;
					if (_tmp726_ == NULL) {
						_vala_code_node_unref0 (_tmp725_);
					}
					inner_type = _tmp726_;
					_tmp728_ = inner_type;
					if (_tmp728_ != NULL) {
						ValaArrayType* _tmp729_;
						gboolean _tmp730_;
						gboolean _tmp731_;
						_tmp729_ = inner_type;
						_tmp730_ = vala_array_type_get_inline_allocated (_tmp729_);
						_tmp731_ = _tmp730_;
						_tmp727_ = _tmp731_;
					} else {
						_tmp727_ = FALSE;
					}
					if (_tmp727_) {
						ValaSourceReference* _tmp732_;
						ValaSourceReference* _tmp733_;
						_tmp732_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp733_ = _tmp732_;
						vala_report_error (_tmp733_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp734_ = FALSE;
						ValaArrayType* _tmp735_;
						_tmp735_ = inner_type;
						if (_tmp735_ != NULL) {
							ValaArrayType* _tmp736_;
							gboolean _tmp737_;
							gboolean _tmp738_;
							_tmp736_ = inner_type;
							_tmp737_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp736_);
							_tmp738_ = _tmp737_;
							_tmp734_ = !_tmp738_;
						} else {
							_tmp734_ = FALSE;
						}
						if (_tmp734_) {
							ValaSourceReference* _tmp739_;
							ValaSourceReference* _tmp740_;
							_tmp739_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp740_ = _tmp739_;
							vala_report_error (_tmp740_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp741_;
					ValaExpression* _tmp742_;
					ValaSymbol* _tmp743_;
					ValaSymbol* _tmp744_;
					_tmp741_ = vala_member_access_get_inner (self);
					_tmp742_ = _tmp741_;
					_tmp743_ = vala_expression_get_symbol_reference (_tmp742_);
					_tmp744_ = _tmp743_;
					if (VALA_IS_CONSTANT (_tmp744_)) {
						ValaSourceReference* _tmp745_;
						ValaSourceReference* _tmp746_;
						_tmp745_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp746_ = _tmp745_;
						vala_report_error (_tmp746_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp750_ = vala_member_access_get_inner (self);
	_tmp751_ = _tmp750_;
	if (_tmp751_ == NULL) {
		ValaSymbol* _tmp752_;
		ValaSymbol* _tmp753_;
		_tmp752_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp753_ = _tmp752_;
		_tmp749_ = _tmp753_ == NULL;
	} else {
		_tmp749_ = FALSE;
	}
	if (_tmp749_) {
		ValaDataType* _tmp754_;
		ValaDataType* _tmp755_;
		_tmp754_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp755_ = _tmp754_;
		_tmp748_ = _tmp755_ != NULL;
	} else {
		_tmp748_ = FALSE;
	}
	if (_tmp748_) {
		ValaDataType* _tmp756_;
		ValaDataType* _tmp757_;
		ValaTypeSymbol* _tmp758_;
		ValaTypeSymbol* _tmp759_;
		_tmp756_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp757_ = _tmp756_;
		_tmp758_ = vala_data_type_get_type_symbol (_tmp757_);
		_tmp759_ = _tmp758_;
		_tmp747_ = VALA_IS_ENUM (_tmp759_);
	} else {
		_tmp747_ = FALSE;
	}
	if (_tmp747_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp760_;
		ValaDataType* _tmp761_;
		ValaTypeSymbol* _tmp762_;
		ValaTypeSymbol* _tmp763_;
		_tmp760_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp761_ = _tmp760_;
		_tmp762_ = vala_data_type_get_type_symbol (_tmp761_);
		_tmp763_ = _tmp762_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp763_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp764_;
			ValaList* _tmp765_;
			gint _val_size = 0;
			ValaList* _tmp766_;
			gint _tmp767_;
			gint _tmp768_;
			gint _val_index = 0;
			_tmp764_ = enum_type;
			_tmp765_ = vala_enum_get_values (_tmp764_);
			_val_list = _tmp765_;
			_tmp766_ = _val_list;
			_tmp767_ = vala_collection_get_size ((ValaCollection*) _tmp766_);
			_tmp768_ = _tmp767_;
			_val_size = _tmp768_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp769_;
				gint _tmp770_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp771_;
				gpointer _tmp772_;
				const gchar* _tmp773_;
				ValaEnumValue* _tmp774_;
				const gchar* _tmp775_;
				const gchar* _tmp776_;
				_val_index = _val_index + 1;
				_tmp769_ = _val_index;
				_tmp770_ = _val_size;
				if (!(_tmp769_ < _tmp770_)) {
					break;
				}
				_tmp771_ = _val_list;
				_tmp772_ = vala_list_get (_tmp771_, _val_index);
				val = (ValaEnumValue*) _tmp772_;
				_tmp773_ = self->priv->_member_name;
				_tmp774_ = val;
				_tmp775_ = vala_symbol_get_name ((ValaSymbol*) _tmp774_);
				_tmp776_ = _tmp775_;
				if (g_strcmp0 (_tmp773_, _tmp776_) == 0) {
					ValaEnumValue* _tmp777_;
					_tmp777_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp777_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp778_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp779_ = _tmp778_;
	if (_tmp779_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp780_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp781_ = FALSE;
		ValaExpression* _tmp782_;
		ValaExpression* _tmp783_;
		gchar* base_type_package = NULL;
		gchar* _tmp803_;
		gboolean _tmp804_ = FALSE;
		ValaSymbol* _tmp805_;
		gchar* visited_types_string = NULL;
		gchar* _tmp820_;
		ValaSourceReference* _tmp836_;
		ValaSourceReference* _tmp837_;
		const gchar* _tmp838_;
		const gchar* _tmp839_;
		const gchar* _tmp840_;
		const gchar* _tmp841_;
		gboolean _tmp842_ = FALSE;
		gboolean _tmp843_ = FALSE;
		ValaExpression* _tmp844_;
		ValaExpression* _tmp845_;
		ValaInvalidType* _tmp868_;
		ValaInvalidType* _tmp869_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp780_ = g_strdup ("(null)");
		base_type_name = _tmp780_;
		base_type = NULL;
		_tmp782_ = vala_member_access_get_inner (self);
		_tmp783_ = _tmp782_;
		if (_tmp783_ != NULL) {
			ValaExpression* _tmp784_;
			ValaExpression* _tmp785_;
			ValaDataType* _tmp786_;
			ValaDataType* _tmp787_;
			_tmp784_ = vala_member_access_get_inner (self);
			_tmp785_ = _tmp784_;
			_tmp786_ = vala_expression_get_value_type (_tmp785_);
			_tmp787_ = _tmp786_;
			_tmp781_ = _tmp787_ != NULL;
		} else {
			_tmp781_ = FALSE;
		}
		if (_tmp781_) {
			ValaExpression* _tmp788_;
			ValaExpression* _tmp789_;
			ValaDataType* _tmp790_;
			ValaDataType* _tmp791_;
			gchar* _tmp792_;
			ValaExpression* _tmp793_;
			ValaExpression* _tmp794_;
			ValaDataType* _tmp795_;
			ValaDataType* _tmp796_;
			ValaTypeSymbol* _tmp797_;
			ValaTypeSymbol* _tmp798_;
			_tmp788_ = vala_member_access_get_inner (self);
			_tmp789_ = _tmp788_;
			_tmp790_ = vala_expression_get_value_type (_tmp789_);
			_tmp791_ = _tmp790_;
			_tmp792_ = vala_code_node_to_string ((ValaCodeNode*) _tmp791_);
			_g_free0 (base_type_name);
			base_type_name = _tmp792_;
			_tmp793_ = vala_member_access_get_inner (self);
			_tmp794_ = _tmp793_;
			_tmp795_ = vala_expression_get_value_type (_tmp794_);
			_tmp796_ = _tmp795_;
			_tmp797_ = vala_data_type_get_type_symbol (_tmp796_);
			_tmp798_ = _tmp797_;
			base_type = (ValaSymbol*) _tmp798_;
		} else {
			ValaSymbol* _tmp799_;
			_tmp799_ = base_symbol;
			if (_tmp799_ != NULL) {
				ValaSymbol* _tmp800_;
				gchar* _tmp801_;
				ValaSymbol* _tmp802_;
				_tmp800_ = base_symbol;
				_tmp801_ = vala_symbol_get_full_name (_tmp800_);
				_g_free0 (base_type_name);
				base_type_name = _tmp801_;
				_tmp802_ = base_symbol;
				base_type = _tmp802_;
			}
		}
		_tmp803_ = g_strdup ("");
		base_type_package = _tmp803_;
		_tmp805_ = base_type;
		if (_tmp805_ != NULL) {
			ValaSymbol* _tmp806_;
			gboolean _tmp807_;
			gboolean _tmp808_;
			_tmp806_ = base_type;
			_tmp807_ = vala_symbol_get_external_package (_tmp806_);
			_tmp808_ = _tmp807_;
			_tmp804_ = _tmp808_;
		} else {
			_tmp804_ = FALSE;
		}
		if (_tmp804_) {
			ValaSymbol* _tmp809_;
			ValaSourceReference* _tmp810_;
			ValaSourceReference* _tmp811_;
			ValaSourceFile* _tmp812_;
			ValaSourceFile* _tmp813_;
			const gchar* _tmp814_;
			const gchar* _tmp815_;
			gchar* _tmp816_;
			const gchar* _tmp817_;
			_tmp809_ = base_symbol;
			_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp809_);
			_tmp811_ = _tmp810_;
			_tmp812_ = vala_source_reference_get_file (_tmp811_);
			_tmp813_ = _tmp812_;
			_tmp814_ = vala_source_file_get_package_name (_tmp813_);
			_tmp815_ = _tmp814_;
			_tmp816_ = g_strdup (_tmp815_);
			_g_free0 (base_type_package);
			base_type_package = _tmp816_;
			_tmp817_ = base_type_package;
			if (_tmp817_ != NULL) {
				const gchar* _tmp818_;
				gchar* _tmp819_;
				_tmp818_ = base_type_package;
				_tmp819_ = g_strdup_printf (" (%s)", _tmp818_);
				_g_free0 (base_type_package);
				base_type_package = _tmp819_;
			}
		}
		_tmp820_ = g_strdup ("");
		visited_types_string = _tmp820_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp821_;
			gint _type_size = 0;
			ValaArrayList* _tmp822_;
			gint _tmp823_;
			gint _tmp824_;
			gint _type_index = 0;
			_tmp821_ = visited_types;
			_type_list = _tmp821_;
			_tmp822_ = _type_list;
			_tmp823_ = vala_collection_get_size ((ValaCollection*) _tmp822_);
			_tmp824_ = _tmp823_;
			_type_size = _tmp824_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp825_;
				gint _tmp826_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp827_;
				gpointer _tmp828_;
				const gchar* _tmp829_;
				ValaDataType* _tmp830_;
				gchar* _tmp831_;
				gchar* _tmp832_;
				gchar* _tmp833_;
				gchar* _tmp834_;
				gchar* _tmp835_;
				_type_index = _type_index + 1;
				_tmp825_ = _type_index;
				_tmp826_ = _type_size;
				if (!(_tmp825_ < _tmp826_)) {
					break;
				}
				_tmp827_ = _type_list;
				_tmp828_ = vala_list_get ((ValaList*) _tmp827_, _type_index);
				type = (ValaDataType*) _tmp828_;
				_tmp829_ = visited_types_string;
				_tmp830_ = type;
				_tmp831_ = vala_code_node_to_string ((ValaCodeNode*) _tmp830_);
				_tmp832_ = _tmp831_;
				_tmp833_ = g_strdup_printf (" or `%s'", _tmp832_);
				_tmp834_ = _tmp833_;
				_tmp835_ = g_strconcat (_tmp829_, _tmp834_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp835_;
				_g_free0 (_tmp834_);
				_g_free0 (_tmp832_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp836_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp837_ = _tmp836_;
		_tmp838_ = self->priv->_member_name;
		_tmp839_ = base_type_name;
		_tmp840_ = base_type_package;
		_tmp841_ = visited_types_string;
		vala_report_error (_tmp837_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp838_, _tmp839_, _tmp840_, _tmp841_);
		_tmp844_ = vala_member_access_get_inner (self);
		_tmp845_ = _tmp844_;
		if (_tmp845_ != NULL) {
			ValaExpression* _tmp846_;
			ValaExpression* _tmp847_;
			ValaSymbol* _tmp848_;
			ValaSymbol* _tmp849_;
			_tmp846_ = vala_member_access_get_inner (self);
			_tmp847_ = _tmp846_;
			_tmp848_ = vala_expression_get_symbol_reference (_tmp847_);
			_tmp849_ = _tmp848_;
			_tmp843_ = _tmp849_ != NULL;
		} else {
			_tmp843_ = FALSE;
		}
		if (_tmp843_) {
			ValaExpression* _tmp850_;
			ValaExpression* _tmp851_;
			ValaSymbol* _tmp852_;
			ValaSymbol* _tmp853_;
			ValaSourceReference* _tmp854_;
			ValaSourceReference* _tmp855_;
			_tmp850_ = vala_member_access_get_inner (self);
			_tmp851_ = _tmp850_;
			_tmp852_ = vala_expression_get_symbol_reference (_tmp851_);
			_tmp853_ = _tmp852_;
			_tmp854_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp853_);
			_tmp855_ = _tmp854_;
			_tmp842_ = _tmp855_ != NULL;
		} else {
			_tmp842_ = FALSE;
		}
		if (_tmp842_) {
			ValaExpression* _tmp856_;
			ValaExpression* _tmp857_;
			ValaSymbol* _tmp858_;
			ValaSymbol* _tmp859_;
			ValaSourceReference* _tmp860_;
			ValaSourceReference* _tmp861_;
			ValaExpression* _tmp862_;
			ValaExpression* _tmp863_;
			ValaSymbol* _tmp864_;
			ValaSymbol* _tmp865_;
			const gchar* _tmp866_;
			const gchar* _tmp867_;
			_tmp856_ = vala_member_access_get_inner (self);
			_tmp857_ = _tmp856_;
			_tmp858_ = vala_expression_get_symbol_reference (_tmp857_);
			_tmp859_ = _tmp858_;
			_tmp860_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp859_);
			_tmp861_ = _tmp860_;
			_tmp862_ = vala_member_access_get_inner (self);
			_tmp863_ = _tmp862_;
			_tmp864_ = vala_expression_get_symbol_reference (_tmp863_);
			_tmp865_ = _tmp864_;
			_tmp866_ = vala_symbol_get_name (_tmp865_);
			_tmp867_ = _tmp866_;
			vala_report_notice (_tmp861_, "`%s' was declared here", _tmp867_);
		}
		_tmp868_ = vala_invalid_type_new ();
		_tmp869_ = _tmp868_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp869_);
		_vala_code_node_unref0 (_tmp869_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp870_;
		ValaSymbol* _tmp871_;
		gboolean _tmp872_;
		gboolean _tmp873_;
		_tmp870_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp871_ = _tmp870_;
		_tmp872_ = vala_code_node_get_error ((ValaCodeNode*) _tmp871_);
		_tmp873_ = _tmp872_;
		if (_tmp873_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp874_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp875_ = _tmp874_;
	if (VALA_IS_SIGNAL (_tmp875_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp876_;
		ValaSymbol* _tmp877_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp884_;
		ValaCodeNode* _tmp885_;
		ValaCodeNode* _tmp886_;
		gboolean _tmp887_ = FALSE;
		gboolean _tmp888_ = FALSE;
		gboolean _tmp889_ = FALSE;
		ValaCodeNode* _tmp890_;
		_tmp876_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp877_ = _tmp876_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp877_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp878_;
			ValaCodeNode* _tmp879_;
			ValaCodeNode* _tmp880_;
			ValaCodeNode* _tmp881_;
			ValaCodeNode* _tmp882_;
			ValaCodeNode* _tmp883_;
			_tmp878_ = ma;
			_tmp879_ = vala_code_node_get_parent_node (_tmp878_);
			_tmp880_ = _tmp879_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp880_)) {
				break;
			}
			_tmp881_ = ma;
			_tmp882_ = vala_code_node_get_parent_node (_tmp881_);
			_tmp883_ = _tmp882_;
			ma = _tmp883_;
		}
		_tmp884_ = ma;
		_tmp885_ = vala_code_node_get_parent_node (_tmp884_);
		_tmp886_ = _tmp885_;
		parent = _tmp886_;
		_tmp890_ = parent;
		if (_tmp890_ != NULL) {
			ValaCodeNode* _tmp891_;
			_tmp891_ = parent;
			_tmp889_ = !VALA_IS_ELEMENT_ACCESS (_tmp891_);
		} else {
			_tmp889_ = FALSE;
		}
		if (_tmp889_) {
			ValaCodeNode* _tmp892_;
			ValaExpression* _tmp893_;
			ValaExpression* _tmp894_;
			_tmp892_ = ma;
			_tmp893_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp892_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp894_ = _tmp893_;
			_tmp888_ = !VALA_IS_BASE_ACCESS (_tmp894_);
		} else {
			_tmp888_ = FALSE;
		}
		if (_tmp888_) {
			gboolean _tmp895_ = FALSE;
			ValaCodeNode* _tmp896_;
			_tmp896_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp896_)) {
				_tmp895_ = TRUE;
			} else {
				ValaCodeNode* _tmp897_;
				ValaList* _tmp898_;
				_tmp897_ = parent;
				_tmp898_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp897_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp895_ = vala_collection_contains ((ValaCollection*) _tmp898_, (ValaExpression*) self);
			}
			_tmp887_ = _tmp895_;
		} else {
			_tmp887_ = FALSE;
		}
		if (_tmp887_) {
			ValaSignal* _tmp899_;
			_tmp899_ = sig;
			if (vala_code_node_has_attribute ((ValaCodeNode*) _tmp899_, "HasEmitter")) {
				ValaSignal* _tmp900_;
				ValaSignal* _tmp901_;
				ValaMethod* _tmp902_;
				ValaMethod* _tmp903_;
				_tmp900_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp900_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp901_ = sig;
				_tmp902_ = vala_signal_get_emitter (_tmp901_);
				_tmp903_ = _tmp902_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp903_);
			} else {
				ValaSourceReference* _tmp904_;
				ValaSourceReference* _tmp905_;
				ValaSymbol* _tmp906_;
				ValaSymbol* _tmp907_;
				gchar* _tmp908_;
				gchar* _tmp909_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp904_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp905_ = _tmp904_;
				_tmp906_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp907_ = _tmp906_;
				_tmp908_ = vala_symbol_get_full_name (_tmp907_);
				_tmp909_ = _tmp908_;
				vala_report_error (_tmp905_, "Signal `%s' requires emitter in this context", _tmp909_);
				_g_free0 (_tmp909_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp910_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp911_ = _tmp910_;
	member = _tmp911_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp912_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp912_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp913_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp913_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp914_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp915_;
		ValaSymbol* _tmp916_;
		ValaSymbol* _tmp917_;
		gboolean _tmp918_ = FALSE;
		ValaBlock* _tmp919_;
		_tmp914_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp914_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp915_ = local;
		_tmp916_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp915_);
		_tmp917_ = _tmp916_;
		block = VALA_IS_BLOCK (_tmp917_) ? ((ValaBlock*) _tmp917_) : NULL;
		_tmp919_ = block;
		if (_tmp919_ != NULL) {
			ValaBlock* _tmp920_;
			ValaSymbol* _tmp921_;
			ValaSemanticAnalyzer* _tmp922_;
			ValaSemanticAnalyzer* _tmp923_;
			ValaSymbol* _tmp924_;
			ValaSymbol* _tmp925_;
			_tmp920_ = block;
			_tmp921_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp920_);
			_tmp922_ = vala_code_context_get_analyzer (context);
			_tmp923_ = _tmp922_;
			_tmp924_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp923_);
			_tmp925_ = _tmp924_;
			_tmp918_ = _tmp921_ != _tmp925_;
		} else {
			_tmp918_ = FALSE;
		}
		if (_tmp918_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp926_;
			ValaSemanticAnalyzer* _tmp927_;
			ValaSymbol* _tmp928_;
			ValaSymbol* _tmp929_;
			ValaLocalVariable* _tmp940_;
			ValaBlock* _tmp941_;
			ValaLocalVariable* _tmp942_;
			ValaDataType* _tmp943_;
			ValaDataType* _tmp944_;
			ValaTypeSymbol* _tmp945_;
			ValaTypeSymbol* _tmp946_;
			ValaSemanticAnalyzer* _tmp947_;
			ValaSemanticAnalyzer* _tmp948_;
			ValaDataType* _tmp949_;
			ValaTypeSymbol* _tmp950_;
			ValaTypeSymbol* _tmp951_;
			_tmp926_ = vala_code_context_get_analyzer (context);
			_tmp927_ = _tmp926_;
			_tmp928_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp927_);
			_tmp929_ = _tmp928_;
			sym = _tmp929_;
			while (TRUE) {
				ValaSymbol* _tmp930_;
				ValaBlock* _tmp931_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp932_;
				ValaMethod* _tmp933_;
				ValaSymbol* _tmp937_;
				ValaSymbol* _tmp938_;
				ValaSymbol* _tmp939_;
				_tmp930_ = sym;
				_tmp931_ = block;
				if (!(_tmp930_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp931_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp932_ = sym;
				method = VALA_IS_METHOD (_tmp932_) ? ((ValaMethod*) _tmp932_) : NULL;
				_tmp933_ = method;
				if (_tmp933_ != NULL) {
					ValaMethod* _tmp934_;
					ValaMethod* _tmp935_;
					ValaLocalVariable* _tmp936_;
					_tmp934_ = method;
					vala_method_set_closure (_tmp934_, TRUE);
					_tmp935_ = method;
					_tmp936_ = local;
					vala_method_add_captured_variable (_tmp935_, _tmp936_);
				}
				_tmp937_ = sym;
				_tmp938_ = vala_symbol_get_parent_symbol (_tmp937_);
				_tmp939_ = _tmp938_;
				sym = _tmp939_;
			}
			_tmp940_ = local;
			vala_local_variable_set_captured (_tmp940_, TRUE);
			_tmp941_ = block;
			vala_block_set_captured (_tmp941_, TRUE);
			_tmp942_ = local;
			_tmp943_ = vala_variable_get_variable_type ((ValaVariable*) _tmp942_);
			_tmp944_ = _tmp943_;
			_tmp945_ = vala_data_type_get_type_symbol (_tmp944_);
			_tmp946_ = _tmp945_;
			_tmp947_ = vala_code_context_get_analyzer (context);
			_tmp948_ = _tmp947_;
			_tmp949_ = _tmp948_->va_list_type;
			_tmp950_ = vala_data_type_get_type_symbol (_tmp949_);
			_tmp951_ = _tmp950_;
			if (_tmp946_ == _tmp951_) {
				ValaSourceReference* _tmp952_;
				ValaSourceReference* _tmp953_;
				ValaLocalVariable* _tmp954_;
				gchar* _tmp955_;
				gchar* _tmp956_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp952_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp953_ = _tmp952_;
				_tmp954_ = local;
				_tmp955_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp954_);
				_tmp956_ = _tmp955_;
				vala_report_error (_tmp953_, "Capturing `va_list' variable `%s' is not allowed", _tmp956_);
				_g_free0 (_tmp956_);
			}
		}
	} else {
		ValaSymbol* _tmp957_;
		_tmp957_ = member;
		if (VALA_IS_PARAMETER (_tmp957_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp958_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp959_;
			ValaSymbol* _tmp960_;
			ValaSymbol* _tmp961_;
			gboolean _tmp962_ = FALSE;
			gboolean _tmp963_ = FALSE;
			ValaMethod* _tmp964_;
			_tmp958_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp958_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp959_ = param;
			_tmp960_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp959_);
			_tmp961_ = _tmp960_;
			m = VALA_IS_METHOD (_tmp961_) ? ((ValaMethod*) _tmp961_) : NULL;
			_tmp964_ = m;
			if (_tmp964_ != NULL) {
				ValaMethod* _tmp965_;
				ValaSemanticAnalyzer* _tmp966_;
				ValaSemanticAnalyzer* _tmp967_;
				ValaSymbol* _tmp968_;
				ValaSymbol* _tmp969_;
				_tmp965_ = m;
				_tmp966_ = vala_code_context_get_analyzer (context);
				_tmp967_ = _tmp966_;
				_tmp968_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp967_);
				_tmp969_ = _tmp968_;
				_tmp963_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp965_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp969_;
			} else {
				_tmp963_ = FALSE;
			}
			if (_tmp963_) {
				ValaParameter* _tmp970_;
				ValaMethod* _tmp971_;
				ValaParameter* _tmp972_;
				ValaParameter* _tmp973_;
				_tmp970_ = param;
				_tmp971_ = m;
				_tmp972_ = vala_method_get_this_parameter (_tmp971_);
				_tmp973_ = _tmp972_;
				_tmp962_ = _tmp970_ != _tmp973_;
			} else {
				_tmp962_ = FALSE;
			}
			if (_tmp962_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp974_;
				ValaSemanticAnalyzer* _tmp975_;
				ValaSymbol* _tmp976_;
				ValaSymbol* _tmp977_;
				ValaParameter* _tmp986_;
				ValaMethod* _tmp987_;
				ValaBlock* _tmp988_;
				ValaBlock* _tmp989_;
				ValaParameter* _tmp990_;
				ValaParameterDirection _tmp991_;
				ValaParameterDirection _tmp992_;
				ValaParameter* _tmp998_;
				ValaDataType* _tmp999_;
				ValaDataType* _tmp1000_;
				ValaTypeSymbol* _tmp1001_;
				ValaTypeSymbol* _tmp1002_;
				ValaSemanticAnalyzer* _tmp1003_;
				ValaSemanticAnalyzer* _tmp1004_;
				ValaDataType* _tmp1005_;
				ValaTypeSymbol* _tmp1006_;
				ValaTypeSymbol* _tmp1007_;
				_tmp974_ = vala_code_context_get_analyzer (context);
				_tmp975_ = _tmp974_;
				_tmp976_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp975_);
				_tmp977_ = _tmp976_;
				sym = _tmp977_;
				while (TRUE) {
					ValaSymbol* _tmp978_;
					ValaMethod* _tmp979_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp980_;
					ValaMethod* _tmp981_;
					ValaSymbol* _tmp983_;
					ValaSymbol* _tmp984_;
					ValaSymbol* _tmp985_;
					_tmp978_ = sym;
					_tmp979_ = m;
					if (!(_tmp978_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp979_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp980_ = sym;
					method = VALA_IS_METHOD (_tmp980_) ? ((ValaMethod*) _tmp980_) : NULL;
					_tmp981_ = method;
					if (_tmp981_ != NULL) {
						ValaMethod* _tmp982_;
						_tmp982_ = method;
						vala_method_set_closure (_tmp982_, TRUE);
					}
					_tmp983_ = sym;
					_tmp984_ = vala_symbol_get_parent_symbol (_tmp983_);
					_tmp985_ = _tmp984_;
					sym = _tmp985_;
				}
				_tmp986_ = param;
				vala_parameter_set_captured (_tmp986_, TRUE);
				_tmp987_ = m;
				_tmp988_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp987_);
				_tmp989_ = _tmp988_;
				vala_block_set_captured (_tmp989_, TRUE);
				_tmp990_ = param;
				_tmp991_ = vala_parameter_get_direction (_tmp990_);
				_tmp992_ = _tmp991_;
				if (_tmp992_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp993_;
					ValaSourceReference* _tmp994_;
					ValaParameter* _tmp995_;
					gchar* _tmp996_;
					gchar* _tmp997_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp993_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp994_ = _tmp993_;
					_tmp995_ = param;
					_tmp996_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp995_);
					_tmp997_ = _tmp996_;
					vala_report_error (_tmp994_, "Cannot capture reference or output parameter `%s'", _tmp997_);
					_g_free0 (_tmp997_);
				}
				_tmp998_ = param;
				_tmp999_ = vala_variable_get_variable_type ((ValaVariable*) _tmp998_);
				_tmp1000_ = _tmp999_;
				_tmp1001_ = vala_data_type_get_type_symbol (_tmp1000_);
				_tmp1002_ = _tmp1001_;
				_tmp1003_ = vala_code_context_get_analyzer (context);
				_tmp1004_ = _tmp1003_;
				_tmp1005_ = _tmp1004_->va_list_type;
				_tmp1006_ = vala_data_type_get_type_symbol (_tmp1005_);
				_tmp1007_ = _tmp1006_;
				if (_tmp1002_ == _tmp1007_) {
					ValaSourceReference* _tmp1008_;
					ValaSourceReference* _tmp1009_;
					ValaParameter* _tmp1010_;
					gchar* _tmp1011_;
					gchar* _tmp1012_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1008_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1009_ = _tmp1008_;
					_tmp1010_ = param;
					_tmp1011_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1010_);
					_tmp1012_ = _tmp1011_;
					vala_report_error (_tmp1009_, "Capturing `va_list' parameter `%s' is not allowed", _tmp1012_);
					_g_free0 (_tmp1012_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp1013_;
				ValaSymbol* _tmp1014_;
				ValaSymbol* _tmp1015_;
				ValaSymbol* _tmp1016_;
				ValaSymbol* _tmp1017_;
				gboolean _tmp1018_ = FALSE;
				gboolean _tmp1019_ = FALSE;
				ValaPropertyAccessor* _tmp1020_;
				_tmp1013_ = param;
				_tmp1014_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1013_);
				_tmp1015_ = _tmp1014_;
				_tmp1016_ = vala_symbol_get_parent_symbol (_tmp1015_);
				_tmp1017_ = _tmp1016_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp1017_) ? ((ValaPropertyAccessor*) _tmp1017_) : NULL;
				_tmp1020_ = acc;
				if (_tmp1020_ != NULL) {
					ValaPropertyAccessor* _tmp1021_;
					ValaSemanticAnalyzer* _tmp1022_;
					ValaSemanticAnalyzer* _tmp1023_;
					ValaSymbol* _tmp1024_;
					ValaSymbol* _tmp1025_;
					_tmp1021_ = acc;
					_tmp1022_ = vala_code_context_get_analyzer (context);
					_tmp1023_ = _tmp1022_;
					_tmp1024_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1023_);
					_tmp1025_ = _tmp1024_;
					_tmp1019_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1021_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp1025_;
				} else {
					_tmp1019_ = FALSE;
				}
				if (_tmp1019_) {
					ValaParameter* _tmp1026_;
					ValaPropertyAccessor* _tmp1027_;
					ValaProperty* _tmp1028_;
					ValaProperty* _tmp1029_;
					ValaParameter* _tmp1030_;
					ValaParameter* _tmp1031_;
					_tmp1026_ = param;
					_tmp1027_ = acc;
					_tmp1028_ = vala_property_accessor_get_prop (_tmp1027_);
					_tmp1029_ = _tmp1028_;
					_tmp1030_ = vala_property_get_this_parameter (_tmp1029_);
					_tmp1031_ = _tmp1030_;
					_tmp1018_ = _tmp1026_ != _tmp1031_;
				} else {
					_tmp1018_ = FALSE;
				}
				if (_tmp1018_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp1032_;
					ValaSemanticAnalyzer* _tmp1033_;
					ValaSymbol* _tmp1034_;
					ValaSymbol* _tmp1035_;
					ValaParameter* _tmp1044_;
					ValaPropertyAccessor* _tmp1045_;
					ValaBlock* _tmp1046_;
					ValaBlock* _tmp1047_;
					_tmp1032_ = vala_code_context_get_analyzer (context);
					_tmp1033_ = _tmp1032_;
					_tmp1034_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1033_);
					_tmp1035_ = _tmp1034_;
					sym = _tmp1035_;
					while (TRUE) {
						ValaSymbol* _tmp1036_;
						ValaMethod* _tmp1037_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp1038_;
						ValaMethod* _tmp1039_;
						ValaSymbol* _tmp1041_;
						ValaSymbol* _tmp1042_;
						ValaSymbol* _tmp1043_;
						_tmp1036_ = sym;
						_tmp1037_ = m;
						if (!(_tmp1036_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1037_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp1038_ = sym;
						method = VALA_IS_METHOD (_tmp1038_) ? ((ValaMethod*) _tmp1038_) : NULL;
						_tmp1039_ = method;
						if (_tmp1039_ != NULL) {
							ValaMethod* _tmp1040_;
							_tmp1040_ = method;
							vala_method_set_closure (_tmp1040_, TRUE);
						}
						_tmp1041_ = sym;
						_tmp1042_ = vala_symbol_get_parent_symbol (_tmp1041_);
						_tmp1043_ = _tmp1042_;
						sym = _tmp1043_;
					}
					_tmp1044_ = param;
					vala_parameter_set_captured (_tmp1044_, TRUE);
					_tmp1045_ = acc;
					_tmp1046_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1045_);
					_tmp1047_ = _tmp1046_;
					vala_block_set_captured (_tmp1047_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp1048_;
			_tmp1048_ = member;
			if (VALA_IS_FIELD (_tmp1048_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp1049_;
				ValaField* _tmp1050_;
				ValaSymbolAccessibility _tmp1051_;
				ValaSymbolAccessibility _tmp1052_;
				ValaField* _tmp1053_;
				ValaMemberBinding _tmp1054_;
				ValaMemberBinding _tmp1055_;
				ValaField* _tmp1056_;
				ValaMemberBinding _tmp1057_;
				ValaMemberBinding _tmp1058_;
				ValaField* _tmp1059_;
				ValaDataType* _tmp1060_;
				ValaDataType* _tmp1061_;
				_tmp1049_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp1049_, VALA_TYPE_FIELD, ValaField);
				_tmp1050_ = f;
				_tmp1051_ = vala_symbol_get_access ((ValaSymbol*) _tmp1050_);
				_tmp1052_ = _tmp1051_;
				access = _tmp1052_;
				_tmp1053_ = f;
				_tmp1054_ = vala_field_get_binding (_tmp1053_);
				_tmp1055_ = _tmp1054_;
				instance = _tmp1055_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp1056_ = f;
				_tmp1057_ = vala_field_get_binding (_tmp1056_);
				_tmp1058_ = _tmp1057_;
				klass = _tmp1058_ == VALA_MEMBER_BINDING_CLASS;
				_tmp1059_ = f;
				_tmp1060_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1059_);
				_tmp1061_ = _tmp1060_;
				if (VALA_IS_GENERIC_TYPE (_tmp1061_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp1062_;
				_tmp1062_ = member;
				if (VALA_IS_CONSTANT (_tmp1062_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp1063_;
					ValaConstant* _tmp1064_;
					ValaSymbolAccessibility _tmp1065_;
					ValaSymbolAccessibility _tmp1066_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp1067_;
					ValaSymbol* _tmp1068_;
					ValaSymbol* _tmp1069_;
					gboolean _tmp1070_ = FALSE;
					ValaBlock* _tmp1071_;
					_tmp1063_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp1063_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp1064_ = c;
					_tmp1065_ = vala_symbol_get_access ((ValaSymbol*) _tmp1064_);
					_tmp1066_ = _tmp1065_;
					access = _tmp1066_;
					_tmp1067_ = c;
					_tmp1068_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1067_);
					_tmp1069_ = _tmp1068_;
					block = VALA_IS_BLOCK (_tmp1069_) ? ((ValaBlock*) _tmp1069_) : NULL;
					_tmp1071_ = block;
					if (_tmp1071_ != NULL) {
						ValaBlock* _tmp1072_;
						ValaSymbol* _tmp1073_;
						ValaSemanticAnalyzer* _tmp1074_;
						ValaSemanticAnalyzer* _tmp1075_;
						ValaSymbol* _tmp1076_;
						ValaSymbol* _tmp1077_;
						_tmp1072_ = block;
						_tmp1073_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp1072_);
						_tmp1074_ = vala_code_context_get_analyzer (context);
						_tmp1075_ = _tmp1074_;
						_tmp1076_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1075_);
						_tmp1077_ = _tmp1076_;
						_tmp1070_ = _tmp1073_ != _tmp1077_;
					} else {
						_tmp1070_ = FALSE;
					}
					if (_tmp1070_) {
						ValaSourceReference* _tmp1078_;
						ValaSourceReference* _tmp1079_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1078_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1079_ = _tmp1078_;
						vala_report_error (_tmp1079_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp1080_;
					_tmp1080_ = member;
					if (VALA_IS_METHOD (_tmp1080_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp1081_;
						ValaMethod* _tmp1082_;
						gboolean _tmp1083_;
						gboolean _tmp1084_;
						ValaMethod* _tmp1171_;
						ValaSymbolAccessibility _tmp1172_;
						ValaSymbolAccessibility _tmp1173_;
						ValaMethod* _tmp1174_;
						ValaMethod* _tmp1178_;
						ValaMemberBinding _tmp1179_;
						ValaMemberBinding _tmp1180_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1200_;
						ValaDataType* _tmp1201_;
						ValaDataType* _tmp1202_;
						gboolean _tmp1203_ = FALSE;
						ValaGenericType* _tmp1204_;
						_tmp1081_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp1081_, VALA_TYPE_METHOD, ValaMethod);
						_tmp1082_ = m;
						_tmp1083_ = vala_method_get_is_async_callback (_tmp1082_);
						_tmp1084_ = _tmp1083_;
						if (_tmp1084_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp1085_;
							ValaSemanticAnalyzer* _tmp1086_;
							ValaMethod* _tmp1087_;
							ValaMethod* _tmp1088_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp1089_;
							ValaMethod* _tmp1116_;
							ValaSemanticAnalyzer* _tmp1117_;
							ValaSemanticAnalyzer* _tmp1118_;
							ValaMethod* _tmp1119_;
							ValaMethod* _tmp1120_;
							ValaMethod* _tmp1136_;
							ValaMethod* _tmp1137_;
							ValaMethod* _tmp1138_;
							ValaSymbol* _tmp1139_;
							ValaSymbol* _tmp1140_;
							_tmp1085_ = vala_code_context_get_analyzer (context);
							_tmp1086_ = _tmp1085_;
							_tmp1087_ = vala_semantic_analyzer_get_current_async_method (_tmp1086_);
							_tmp1088_ = _tmp1087_;
							async_method = _tmp1088_;
							is_valid_access = FALSE;
							_tmp1089_ = async_method;
							if (_tmp1089_ != NULL) {
								ValaMethod* _tmp1090_;
								ValaMethod* _tmp1091_;
								ValaMethod* _tmp1092_;
								_tmp1090_ = m;
								_tmp1091_ = async_method;
								_tmp1092_ = vala_method_get_callback_method (_tmp1091_);
								if (_tmp1090_ == _tmp1092_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp1093_ = FALSE;
									ValaMethod* _tmp1094_;
									ValaMethod* _tmp1095_;
									ValaMethod* _tmp1096_;
									_tmp1094_ = async_method;
									_tmp1095_ = vala_method_get_base_method (_tmp1094_);
									_tmp1096_ = _tmp1095_;
									if (_tmp1096_ != NULL) {
										ValaMethod* _tmp1097_;
										ValaMethod* _tmp1098_;
										ValaMethod* _tmp1099_;
										ValaMethod* _tmp1100_;
										ValaMethod* _tmp1101_;
										_tmp1097_ = m;
										_tmp1098_ = async_method;
										_tmp1099_ = vala_method_get_base_method (_tmp1098_);
										_tmp1100_ = _tmp1099_;
										_tmp1101_ = vala_method_get_callback_method (_tmp1100_);
										_tmp1093_ = _tmp1097_ == _tmp1101_;
									} else {
										_tmp1093_ = FALSE;
									}
									if (_tmp1093_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1102_ = FALSE;
										ValaMethod* _tmp1103_;
										ValaMethod* _tmp1104_;
										ValaMethod* _tmp1105_;
										_tmp1103_ = async_method;
										_tmp1104_ = vala_method_get_base_interface_method (_tmp1103_);
										_tmp1105_ = _tmp1104_;
										if (_tmp1105_ != NULL) {
											ValaMethod* _tmp1106_;
											ValaMethod* _tmp1107_;
											ValaMethod* _tmp1108_;
											ValaMethod* _tmp1109_;
											ValaMethod* _tmp1110_;
											_tmp1106_ = m;
											_tmp1107_ = async_method;
											_tmp1108_ = vala_method_get_base_interface_method (_tmp1107_);
											_tmp1109_ = _tmp1108_;
											_tmp1110_ = vala_method_get_callback_method (_tmp1109_);
											_tmp1102_ = _tmp1106_ == _tmp1110_;
										} else {
											_tmp1102_ = FALSE;
										}
										if (_tmp1102_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1111_;
								ValaSourceReference* _tmp1112_;
								ValaMethod* _tmp1113_;
								gchar* _tmp1114_;
								gchar* _tmp1115_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1111_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1112_ = _tmp1111_;
								_tmp1113_ = m;
								_tmp1114_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1113_);
								_tmp1115_ = _tmp1114_;
								vala_report_error (_tmp1112_, "Access to async callback `%s' not allowed in this context", _tmp1115_);
								_g_free0 (_tmp1115_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1116_ = async_method;
							_tmp1117_ = vala_code_context_get_analyzer (context);
							_tmp1118_ = _tmp1117_;
							_tmp1119_ = vala_semantic_analyzer_get_current_method (_tmp1118_);
							_tmp1120_ = _tmp1119_;
							if (_tmp1116_ != _tmp1120_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1121_;
								ValaSemanticAnalyzer* _tmp1122_;
								ValaMethod* _tmp1123_;
								ValaMethod* _tmp1124_;
								ValaMethod* _tmp1133_;
								ValaBlock* _tmp1134_;
								ValaBlock* _tmp1135_;
								_tmp1121_ = vala_code_context_get_analyzer (context);
								_tmp1122_ = _tmp1121_;
								_tmp1123_ = vala_semantic_analyzer_get_current_method (_tmp1122_);
								_tmp1124_ = _tmp1123_;
								sym = (ValaSymbol*) _tmp1124_;
								while (TRUE) {
									ValaSymbol* _tmp1125_;
									ValaMethod* _tmp1126_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1127_;
									ValaMethod* _tmp1128_;
									ValaSymbol* _tmp1130_;
									ValaSymbol* _tmp1131_;
									ValaSymbol* _tmp1132_;
									_tmp1125_ = sym;
									_tmp1126_ = async_method;
									if (!(_tmp1125_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1126_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1127_ = sym;
									method = VALA_IS_METHOD (_tmp1127_) ? ((ValaMethod*) _tmp1127_) : NULL;
									_tmp1128_ = method;
									if (_tmp1128_ != NULL) {
										ValaMethod* _tmp1129_;
										_tmp1129_ = method;
										vala_method_set_closure (_tmp1129_, TRUE);
									}
									_tmp1130_ = sym;
									_tmp1131_ = vala_symbol_get_parent_symbol (_tmp1130_);
									_tmp1132_ = _tmp1131_;
									sym = _tmp1132_;
								}
								_tmp1133_ = async_method;
								_tmp1134_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1133_);
								_tmp1135_ = _tmp1134_;
								vala_block_set_captured (_tmp1135_, TRUE);
							}
							_tmp1136_ = async_method;
							_tmp1137_ = vala_method_get_callback_method (_tmp1136_);
							m = _tmp1137_;
							_tmp1138_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1138_);
							_tmp1139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1140_ = _tmp1139_;
							member = _tmp1140_;
						} else {
							ValaMethod* _tmp1141_;
							ValaMethod* _tmp1142_;
							ValaMethod* _tmp1143_;
							_tmp1141_ = m;
							_tmp1142_ = vala_method_get_base_method (_tmp1141_);
							_tmp1143_ = _tmp1142_;
							if (_tmp1143_ != NULL) {
								ValaMethod* _tmp1144_;
								ValaMethod* _tmp1145_;
								ValaMethod* _tmp1146_;
								ValaMethod* _tmp1147_;
								ValaSignal* _tmp1148_;
								ValaSignal* _tmp1149_;
								ValaSymbol* _tmp1154_;
								ValaSymbol* _tmp1155_;
								_tmp1144_ = m;
								_tmp1145_ = vala_method_get_base_method (_tmp1144_);
								_tmp1146_ = _tmp1145_;
								m = _tmp1146_;
								_tmp1147_ = m;
								_tmp1148_ = vala_method_get_signal_reference (_tmp1147_);
								_tmp1149_ = _tmp1148_;
								if (_tmp1149_ != NULL) {
									ValaMethod* _tmp1150_;
									ValaSignal* _tmp1151_;
									ValaSignal* _tmp1152_;
									_tmp1150_ = m;
									_tmp1151_ = vala_method_get_signal_reference (_tmp1150_);
									_tmp1152_ = _tmp1151_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1152_);
								} else {
									ValaMethod* _tmp1153_;
									_tmp1153_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1153_);
								}
								_tmp1154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1155_ = _tmp1154_;
								member = _tmp1155_;
							} else {
								ValaMethod* _tmp1156_;
								ValaMethod* _tmp1157_;
								ValaMethod* _tmp1158_;
								_tmp1156_ = m;
								_tmp1157_ = vala_method_get_base_interface_method (_tmp1156_);
								_tmp1158_ = _tmp1157_;
								if (_tmp1158_ != NULL) {
									ValaMethod* _tmp1159_;
									ValaMethod* _tmp1160_;
									ValaMethod* _tmp1161_;
									ValaMethod* _tmp1162_;
									ValaSignal* _tmp1163_;
									ValaSignal* _tmp1164_;
									ValaSymbol* _tmp1169_;
									ValaSymbol* _tmp1170_;
									_tmp1159_ = m;
									_tmp1160_ = vala_method_get_base_interface_method (_tmp1159_);
									_tmp1161_ = _tmp1160_;
									m = _tmp1161_;
									_tmp1162_ = m;
									_tmp1163_ = vala_method_get_signal_reference (_tmp1162_);
									_tmp1164_ = _tmp1163_;
									if (_tmp1164_ != NULL) {
										ValaMethod* _tmp1165_;
										ValaSignal* _tmp1166_;
										ValaSignal* _tmp1167_;
										_tmp1165_ = m;
										_tmp1166_ = vala_method_get_signal_reference (_tmp1165_);
										_tmp1167_ = _tmp1166_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1167_);
									} else {
										ValaMethod* _tmp1168_;
										_tmp1168_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1168_);
									}
									_tmp1169_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1170_ = _tmp1169_;
									member = _tmp1170_;
								}
							}
						}
						_tmp1171_ = m;
						_tmp1172_ = vala_symbol_get_access ((ValaSymbol*) _tmp1171_);
						_tmp1173_ = _tmp1172_;
						access = _tmp1173_;
						_tmp1174_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1174_)) {
							ValaMethod* _tmp1175_;
							ValaMemberBinding _tmp1176_;
							ValaMemberBinding _tmp1177_;
							_tmp1175_ = m;
							_tmp1176_ = vala_method_get_binding (_tmp1175_);
							_tmp1177_ = _tmp1176_;
							instance = _tmp1177_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1178_ = m;
						_tmp1179_ = vala_method_get_binding (_tmp1178_);
						_tmp1180_ = _tmp1179_;
						klass = _tmp1180_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1181_;
							ValaList* _tmp1182_;
							gint _param_size = 0;
							ValaList* _tmp1183_;
							gint _tmp1184_;
							gint _tmp1185_;
							gint _param_index = 0;
							_tmp1181_ = m;
							_tmp1182_ = vala_callable_get_parameters ((ValaCallable*) _tmp1181_);
							_param_list = _tmp1182_;
							_tmp1183_ = _param_list;
							_tmp1184_ = vala_collection_get_size ((ValaCollection*) _tmp1183_);
							_tmp1185_ = _tmp1184_;
							_param_size = _tmp1185_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1186_;
								gint _tmp1187_;
								ValaParameter* param = NULL;
								ValaList* _tmp1188_;
								gpointer _tmp1189_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1190_;
								ValaDataType* _tmp1191_;
								ValaDataType* _tmp1192_;
								gboolean _tmp1193_ = FALSE;
								ValaGenericType* _tmp1194_;
								_param_index = _param_index + 1;
								_tmp1186_ = _param_index;
								_tmp1187_ = _param_size;
								if (!(_tmp1186_ < _tmp1187_)) {
									break;
								}
								_tmp1188_ = _param_list;
								_tmp1189_ = vala_list_get (_tmp1188_, _param_index);
								param = (ValaParameter*) _tmp1189_;
								_tmp1190_ = param;
								_tmp1191_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1190_);
								_tmp1192_ = _tmp1191_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1192_) ? ((ValaGenericType*) _tmp1192_) : NULL;
								_tmp1194_ = generic_type;
								if (_tmp1194_ != NULL) {
									ValaGenericType* _tmp1195_;
									ValaTypeParameter* _tmp1196_;
									ValaTypeParameter* _tmp1197_;
									ValaSymbol* _tmp1198_;
									ValaSymbol* _tmp1199_;
									_tmp1195_ = generic_type;
									_tmp1196_ = vala_generic_type_get_type_parameter (_tmp1195_);
									_tmp1197_ = _tmp1196_;
									_tmp1198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1197_);
									_tmp1199_ = _tmp1198_;
									_tmp1193_ = VALA_IS_TYPESYMBOL (_tmp1199_);
								} else {
									_tmp1193_ = FALSE;
								}
								if (_tmp1193_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1200_ = m;
						_tmp1201_ = vala_callable_get_return_type ((ValaCallable*) _tmp1200_);
						_tmp1202_ = _tmp1201_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1202_) ? ((ValaGenericType*) _tmp1202_) : NULL;
						_tmp1204_ = generic_type;
						if (_tmp1204_ != NULL) {
							ValaGenericType* _tmp1205_;
							ValaTypeParameter* _tmp1206_;
							ValaTypeParameter* _tmp1207_;
							ValaSymbol* _tmp1208_;
							ValaSymbol* _tmp1209_;
							_tmp1205_ = generic_type;
							_tmp1206_ = vala_generic_type_get_type_parameter (_tmp1205_);
							_tmp1207_ = _tmp1206_;
							_tmp1208_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1207_);
							_tmp1209_ = _tmp1208_;
							_tmp1203_ = VALA_IS_TYPESYMBOL (_tmp1209_);
						} else {
							_tmp1203_ = FALSE;
						}
						if (_tmp1203_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1210_;
						_tmp1210_ = member;
						if (VALA_IS_PROPERTY (_tmp1210_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1211_;
							ValaProperty* _tmp1212_;
							ValaProperty* _tmp1213_;
							ValaProperty* _tmp1214_;
							ValaProperty* _tmp1215_;
							ValaProperty* _tmp1231_;
							ValaSymbolAccessibility _tmp1232_;
							ValaSymbolAccessibility _tmp1233_;
							gboolean _tmp1234_;
							gboolean _tmp1235_;
							ValaProperty* _tmp1334_;
							ValaMemberBinding _tmp1335_;
							ValaMemberBinding _tmp1336_;
							ValaProperty* _tmp1337_;
							ValaDataType* _tmp1338_;
							ValaDataType* _tmp1339_;
							_tmp1211_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1211_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1212_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1212_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1213_ = prop;
							_tmp1214_ = vala_property_get_base_property (_tmp1213_);
							_tmp1215_ = _tmp1214_;
							if (_tmp1215_ != NULL) {
								ValaProperty* _tmp1216_;
								ValaProperty* _tmp1217_;
								ValaProperty* _tmp1218_;
								ValaProperty* _tmp1219_;
								ValaSymbol* _tmp1220_;
								ValaSymbol* _tmp1221_;
								_tmp1216_ = prop;
								_tmp1217_ = vala_property_get_base_property (_tmp1216_);
								_tmp1218_ = _tmp1217_;
								prop = _tmp1218_;
								_tmp1219_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1219_);
								_tmp1220_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1221_ = _tmp1220_;
								member = _tmp1221_;
							} else {
								ValaProperty* _tmp1222_;
								ValaProperty* _tmp1223_;
								ValaProperty* _tmp1224_;
								_tmp1222_ = prop;
								_tmp1223_ = vala_property_get_base_interface_property (_tmp1222_);
								_tmp1224_ = _tmp1223_;
								if (_tmp1224_ != NULL) {
									ValaProperty* _tmp1225_;
									ValaProperty* _tmp1226_;
									ValaProperty* _tmp1227_;
									ValaProperty* _tmp1228_;
									ValaSymbol* _tmp1229_;
									ValaSymbol* _tmp1230_;
									_tmp1225_ = prop;
									_tmp1226_ = vala_property_get_base_interface_property (_tmp1225_);
									_tmp1227_ = _tmp1226_;
									prop = _tmp1227_;
									_tmp1228_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1228_);
									_tmp1229_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1230_ = _tmp1229_;
									member = _tmp1230_;
								}
							}
							_tmp1231_ = prop;
							_tmp1232_ = vala_symbol_get_access ((ValaSymbol*) _tmp1231_);
							_tmp1233_ = _tmp1232_;
							access = _tmp1233_;
							_tmp1234_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1235_ = _tmp1234_;
							if (_tmp1235_) {
								ValaProperty* _tmp1236_;
								ValaPropertyAccessor* _tmp1237_;
								ValaPropertyAccessor* _tmp1238_;
								ValaProperty* _tmp1282_;
								ValaSymbolAccessibility _tmp1283_;
								ValaSymbolAccessibility _tmp1284_;
								_tmp1236_ = prop;
								_tmp1237_ = vala_property_get_set_accessor (_tmp1236_);
								_tmp1238_ = _tmp1237_;
								if (_tmp1238_ == NULL) {
									ValaSourceReference* _tmp1239_;
									ValaSourceReference* _tmp1240_;
									ValaProperty* _tmp1241_;
									gchar* _tmp1242_;
									gchar* _tmp1243_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1239_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1240_ = _tmp1239_;
									_tmp1241_ = prop;
									_tmp1242_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1241_);
									_tmp1243_ = _tmp1242_;
									vala_report_error (_tmp1240_, "Property `%s' is read-only", _tmp1243_);
									_g_free0 (_tmp1243_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1244_ = FALSE;
									ValaProperty* _tmp1245_;
									ValaPropertyAccessor* _tmp1246_;
									ValaPropertyAccessor* _tmp1247_;
									gboolean _tmp1248_;
									gboolean _tmp1249_;
									_tmp1245_ = prop;
									_tmp1246_ = vala_property_get_set_accessor (_tmp1245_);
									_tmp1247_ = _tmp1246_;
									_tmp1248_ = vala_property_accessor_get_writable (_tmp1247_);
									_tmp1249_ = _tmp1248_;
									if (!_tmp1249_) {
										ValaProperty* _tmp1250_;
										ValaPropertyAccessor* _tmp1251_;
										ValaPropertyAccessor* _tmp1252_;
										gboolean _tmp1253_;
										gboolean _tmp1254_;
										_tmp1250_ = prop;
										_tmp1251_ = vala_property_get_set_accessor (_tmp1250_);
										_tmp1252_ = _tmp1251_;
										_tmp1253_ = vala_property_accessor_get_construction (_tmp1252_);
										_tmp1254_ = _tmp1253_;
										_tmp1244_ = _tmp1254_;
									} else {
										_tmp1244_ = FALSE;
									}
									if (_tmp1244_) {
										ValaSemanticAnalyzer* _tmp1255_;
										ValaSemanticAnalyzer* _tmp1256_;
										ValaMethod* _tmp1257_;
										_tmp1255_ = vala_code_context_get_analyzer (context);
										_tmp1256_ = _tmp1255_;
										_tmp1257_ = vala_semantic_analyzer_find_current_method (_tmp1256_);
										if (VALA_IS_CREATION_METHOD (_tmp1257_)) {
											ValaSourceReference* _tmp1258_;
											ValaSourceReference* _tmp1259_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1258_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1259_ = _tmp1258_;
											vala_report_error (_tmp1259_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1260_;
											ValaSemanticAnalyzer* _tmp1261_;
											_tmp1260_ = vala_code_context_get_analyzer (context);
											_tmp1261_ = _tmp1260_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1261_)) {
												ValaSemanticAnalyzer* _tmp1262_;
												ValaSemanticAnalyzer* _tmp1263_;
												ValaTypeSymbol* _tmp1264_;
												ValaTypeSymbol* _tmp1265_;
												ValaProperty* _tmp1266_;
												ValaSymbol* _tmp1267_;
												ValaSymbol* _tmp1268_;
												_tmp1262_ = vala_code_context_get_analyzer (context);
												_tmp1263_ = _tmp1262_;
												_tmp1264_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1263_);
												_tmp1265_ = _tmp1264_;
												_tmp1266_ = prop;
												_tmp1267_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1266_);
												_tmp1268_ = _tmp1267_;
												if (!vala_typesymbol_is_subtype_of (_tmp1265_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1268_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1269_;
													ValaSourceReference* _tmp1270_;
													ValaProperty* _tmp1271_;
													gchar* _tmp1272_;
													gchar* _tmp1273_;
													ValaSemanticAnalyzer* _tmp1274_;
													ValaSemanticAnalyzer* _tmp1275_;
													ValaTypeSymbol* _tmp1276_;
													ValaTypeSymbol* _tmp1277_;
													gchar* _tmp1278_;
													gchar* _tmp1279_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1269_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1270_ = _tmp1269_;
													_tmp1271_ = prop;
													_tmp1272_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1271_);
													_tmp1273_ = _tmp1272_;
													_tmp1274_ = vala_code_context_get_analyzer (context);
													_tmp1275_ = _tmp1274_;
													_tmp1276_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1275_);
													_tmp1277_ = _tmp1276_;
													_tmp1278_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1277_);
													_tmp1279_ = _tmp1278_;
													vala_report_error (_tmp1270_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1273_, _tmp1279_);
													_g_free0 (_tmp1279_);
													_g_free0 (_tmp1273_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1280_;
												ValaSourceReference* _tmp1281_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1281_ = _tmp1280_;
												vala_report_error (_tmp1281_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1282_ = prop;
								_tmp1283_ = vala_symbol_get_access ((ValaSymbol*) _tmp1282_);
								_tmp1284_ = _tmp1283_;
								if (_tmp1284_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1285_;
									ValaPropertyAccessor* _tmp1286_;
									ValaPropertyAccessor* _tmp1287_;
									ValaSymbolAccessibility _tmp1288_;
									ValaSymbolAccessibility _tmp1289_;
									_tmp1285_ = prop;
									_tmp1286_ = vala_property_get_set_accessor (_tmp1285_);
									_tmp1287_ = _tmp1286_;
									_tmp1288_ = vala_symbol_get_access ((ValaSymbol*) _tmp1287_);
									_tmp1289_ = _tmp1288_;
									access = _tmp1289_;
								} else {
									gboolean _tmp1290_ = FALSE;
									ValaProperty* _tmp1291_;
									ValaSymbolAccessibility _tmp1292_;
									ValaSymbolAccessibility _tmp1293_;
									_tmp1291_ = prop;
									_tmp1292_ = vala_symbol_get_access ((ValaSymbol*) _tmp1291_);
									_tmp1293_ = _tmp1292_;
									if (_tmp1293_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1294_;
										ValaPropertyAccessor* _tmp1295_;
										ValaPropertyAccessor* _tmp1296_;
										ValaSymbolAccessibility _tmp1297_;
										ValaSymbolAccessibility _tmp1298_;
										_tmp1294_ = prop;
										_tmp1295_ = vala_property_get_set_accessor (_tmp1294_);
										_tmp1296_ = _tmp1295_;
										_tmp1297_ = vala_symbol_get_access ((ValaSymbol*) _tmp1296_);
										_tmp1298_ = _tmp1297_;
										_tmp1290_ = _tmp1298_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1290_ = FALSE;
									}
									if (_tmp1290_) {
										ValaProperty* _tmp1299_;
										ValaPropertyAccessor* _tmp1300_;
										ValaPropertyAccessor* _tmp1301_;
										ValaSymbolAccessibility _tmp1302_;
										ValaSymbolAccessibility _tmp1303_;
										_tmp1299_ = prop;
										_tmp1300_ = vala_property_get_set_accessor (_tmp1299_);
										_tmp1301_ = _tmp1300_;
										_tmp1302_ = vala_symbol_get_access ((ValaSymbol*) _tmp1301_);
										_tmp1303_ = _tmp1302_;
										access = _tmp1303_;
									}
								}
							} else {
								ValaProperty* _tmp1304_;
								ValaPropertyAccessor* _tmp1305_;
								ValaPropertyAccessor* _tmp1306_;
								ValaProperty* _tmp1312_;
								ValaSymbolAccessibility _tmp1313_;
								ValaSymbolAccessibility _tmp1314_;
								_tmp1304_ = prop;
								_tmp1305_ = vala_property_get_get_accessor (_tmp1304_);
								_tmp1306_ = _tmp1305_;
								if (_tmp1306_ == NULL) {
									ValaSourceReference* _tmp1307_;
									ValaSourceReference* _tmp1308_;
									ValaProperty* _tmp1309_;
									gchar* _tmp1310_;
									gchar* _tmp1311_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1308_ = _tmp1307_;
									_tmp1309_ = prop;
									_tmp1310_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1309_);
									_tmp1311_ = _tmp1310_;
									vala_report_error (_tmp1308_, "Property `%s' is write-only", _tmp1311_);
									_g_free0 (_tmp1311_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1312_ = prop;
								_tmp1313_ = vala_symbol_get_access ((ValaSymbol*) _tmp1312_);
								_tmp1314_ = _tmp1313_;
								if (_tmp1314_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1315_;
									ValaPropertyAccessor* _tmp1316_;
									ValaPropertyAccessor* _tmp1317_;
									ValaSymbolAccessibility _tmp1318_;
									ValaSymbolAccessibility _tmp1319_;
									_tmp1315_ = prop;
									_tmp1316_ = vala_property_get_get_accessor (_tmp1315_);
									_tmp1317_ = _tmp1316_;
									_tmp1318_ = vala_symbol_get_access ((ValaSymbol*) _tmp1317_);
									_tmp1319_ = _tmp1318_;
									access = _tmp1319_;
								} else {
									gboolean _tmp1320_ = FALSE;
									ValaProperty* _tmp1321_;
									ValaSymbolAccessibility _tmp1322_;
									ValaSymbolAccessibility _tmp1323_;
									_tmp1321_ = prop;
									_tmp1322_ = vala_symbol_get_access ((ValaSymbol*) _tmp1321_);
									_tmp1323_ = _tmp1322_;
									if (_tmp1323_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1324_;
										ValaPropertyAccessor* _tmp1325_;
										ValaPropertyAccessor* _tmp1326_;
										ValaSymbolAccessibility _tmp1327_;
										ValaSymbolAccessibility _tmp1328_;
										_tmp1324_ = prop;
										_tmp1325_ = vala_property_get_get_accessor (_tmp1324_);
										_tmp1326_ = _tmp1325_;
										_tmp1327_ = vala_symbol_get_access ((ValaSymbol*) _tmp1326_);
										_tmp1328_ = _tmp1327_;
										_tmp1320_ = _tmp1328_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1320_ = FALSE;
									}
									if (_tmp1320_) {
										ValaProperty* _tmp1329_;
										ValaPropertyAccessor* _tmp1330_;
										ValaPropertyAccessor* _tmp1331_;
										ValaSymbolAccessibility _tmp1332_;
										ValaSymbolAccessibility _tmp1333_;
										_tmp1329_ = prop;
										_tmp1330_ = vala_property_get_get_accessor (_tmp1329_);
										_tmp1331_ = _tmp1330_;
										_tmp1332_ = vala_symbol_get_access ((ValaSymbol*) _tmp1331_);
										_tmp1333_ = _tmp1332_;
										access = _tmp1333_;
									}
								}
							}
							_tmp1334_ = prop;
							_tmp1335_ = vala_property_get_binding (_tmp1334_);
							_tmp1336_ = _tmp1335_;
							instance = _tmp1336_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1337_ = prop;
							_tmp1338_ = vala_property_get_property_type (_tmp1337_);
							_tmp1339_ = _tmp1338_;
							if (VALA_IS_GENERIC_TYPE (_tmp1339_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1340_;
							_tmp1340_ = member;
							if (VALA_IS_SIGNAL (_tmp1340_)) {
								ValaSymbol* _tmp1341_;
								ValaSymbolAccessibility _tmp1342_;
								ValaSymbolAccessibility _tmp1343_;
								instance = TRUE;
								_tmp1341_ = member;
								_tmp1342_ = vala_symbol_get_access (_tmp1341_);
								_tmp1343_ = _tmp1342_;
								access = _tmp1343_;
							} else {
								ValaSymbol* _tmp1344_;
								_tmp1344_ = member;
								if (VALA_IS_ERROR_CODE (_tmp1344_)) {
									gboolean _tmp1345_ = FALSE;
									ValaCodeNode* _tmp1346_;
									ValaCodeNode* _tmp1347_;
									_tmp1346_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
									_tmp1347_ = _tmp1346_;
									if (VALA_IS_CALLABLE_EXPRESSION (_tmp1347_)) {
										ValaCodeNode* _tmp1348_;
										ValaCodeNode* _tmp1349_;
										ValaExpression* _tmp1350_;
										ValaExpression* _tmp1351_;
										_tmp1348_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
										_tmp1349_ = _tmp1348_;
										_tmp1350_ = vala_callable_expression_get_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1349_, VALA_TYPE_CALLABLE_EXPRESSION, ValaCallableExpression));
										_tmp1351_ = _tmp1350_;
										_tmp1345_ = _tmp1351_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression);
									} else {
										_tmp1345_ = FALSE;
									}
									if (!_tmp1345_) {
										ValaSymbol* _tmp1352_;
										ValaConstant* _tmp1353_;
										ValaConstant* _tmp1354_;
										ValaSymbol* _tmp1355_;
										ValaSymbol* _tmp1356_;
										_tmp1352_ = member;
										_tmp1353_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1352_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
										_tmp1354_ = _tmp1353_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1354_);
										_tmp1355_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
										_tmp1356_ = _tmp1355_;
										member = _tmp1356_;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1357_;
		ValaSymbol* _tmp1358_;
		ValaCodeNode* _tmp1359_;
		ValaCodeNode* _tmp1360_;
		ValaCodeNode* _tmp1361_;
		gboolean _tmp1362_ = FALSE;
		ValaCodeNode* _tmp1363_;
		_tmp1357_ = parent;
		_tmp1358_ = member;
		if (!(_tmp1357_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1358_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1359_ = parent;
		_tmp1360_ = vala_code_node_get_parent_node (_tmp1359_);
		_tmp1361_ = _tmp1360_;
		parent = _tmp1361_;
		_tmp1363_ = parent;
		if (_tmp1363_ == NULL) {
			_tmp1362_ = TRUE;
		} else {
			ValaCodeNode* _tmp1364_;
			ValaSymbol* _tmp1365_;
			_tmp1364_ = parent;
			_tmp1365_ = member;
			_tmp1362_ = _tmp1364_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1365_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1362_) {
			break;
		}
	}
	_tmp1366_ = parent;
	_tmp1367_ = member;
	if (_tmp1366_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1367_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1368_;
		_tmp1368_ = member;
		vala_symbol_set_used (_tmp1368_, TRUE);
	}
	_tmp1369_ = member;
	_tmp1370_ = vala_symbol_get_version (_tmp1369_);
	_tmp1371_ = _tmp1370_;
	_tmp1372_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1373_ = _tmp1372_;
	vala_version_attribute_check (_tmp1371_, context, _tmp1373_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1375_;
		ValaSymbol* _tmp1376_;
		ValaSymbol* _tmp1377_;
		_tmp1375_ = member;
		_tmp1376_ = vala_symbol_get_parent_symbol (_tmp1375_);
		_tmp1377_ = _tmp1376_;
		_tmp1374_ = VALA_IS_TYPESYMBOL (_tmp1377_);
	} else {
		_tmp1374_ = FALSE;
	}
	if (_tmp1374_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1378_;
		ValaSymbol* _tmp1379_;
		ValaSymbol* _tmp1380_;
		gboolean in_subtype = FALSE;
		_tmp1378_ = member;
		_tmp1379_ = vala_symbol_get_parent_symbol (_tmp1378_);
		_tmp1380_ = _tmp1379_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1380_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1381_;
			ValaSemanticAnalyzer* _tmp1382_;
			ValaSymbol* _tmp1383_;
			ValaSymbol* _tmp1384_;
			ValaSymbol* _tmp1385_;
			_tmp1381_ = vala_code_context_get_analyzer (context);
			_tmp1382_ = _tmp1381_;
			_tmp1383_ = vala_semantic_analyzer_get_current_symbol (_tmp1382_);
			_tmp1384_ = _tmp1383_;
			_tmp1385_ = _vala_code_node_ref0 (_tmp1384_);
			this_symbol = _tmp1385_;
			{
				gboolean _tmp1386_ = FALSE;
				_tmp1386_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1391_;
					ValaSymbol* _tmp1392_;
					ValaTypeSymbol* _tmp1393_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1394_;
					gboolean _tmp1395_ = FALSE;
					ValaClass* _tmp1396_;
					if (!_tmp1386_) {
						ValaSymbol* _tmp1387_;
						ValaSymbol* _tmp1388_;
						ValaSymbol* _tmp1389_;
						ValaSymbol* _tmp1390_;
						_tmp1387_ = this_symbol;
						_tmp1388_ = vala_symbol_get_parent_symbol (_tmp1387_);
						_tmp1389_ = _tmp1388_;
						_tmp1390_ = _vala_code_node_ref0 (_tmp1389_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1390_;
					}
					_tmp1386_ = FALSE;
					_tmp1391_ = this_symbol;
					if (!(_tmp1391_ != NULL)) {
						break;
					}
					_tmp1392_ = this_symbol;
					_tmp1393_ = target_type;
					if (_tmp1392_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1393_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1394_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1394_) ? ((ValaClass*) _tmp1394_) : NULL;
					_tmp1396_ = cl;
					if (_tmp1396_ != NULL) {
						ValaClass* _tmp1397_;
						ValaTypeSymbol* _tmp1398_;
						_tmp1397_ = cl;
						_tmp1398_ = target_type;
						_tmp1395_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1397_, _tmp1398_);
					} else {
						_tmp1395_ = FALSE;
					}
					if (_tmp1395_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1399_;
			ValaSourceReference* _tmp1400_;
			ValaSymbol* _tmp1401_;
			gchar* _tmp1402_;
			gchar* _tmp1403_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1399_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1400_ = _tmp1399_;
			_tmp1401_ = member;
			_tmp1402_ = vala_symbol_get_full_name (_tmp1401_);
			_tmp1403_ = _tmp1402_;
			vala_report_error (_tmp1400_, "Access to protected member `%s' denied", _tmp1403_);
			_g_free0 (_tmp1403_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1404_;
			ValaSymbol* _tmp1405_;
			ValaSymbol* _tmp1406_;
			gboolean in_target_type = FALSE;
			_tmp1404_ = member;
			_tmp1405_ = vala_symbol_get_parent_symbol (_tmp1404_);
			_tmp1406_ = _tmp1405_;
			target_type = _tmp1406_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1407_;
				ValaSemanticAnalyzer* _tmp1408_;
				ValaSymbol* _tmp1409_;
				ValaSymbol* _tmp1410_;
				ValaSymbol* _tmp1411_;
				_tmp1407_ = vala_code_context_get_analyzer (context);
				_tmp1408_ = _tmp1407_;
				_tmp1409_ = vala_semantic_analyzer_get_current_symbol (_tmp1408_);
				_tmp1410_ = _tmp1409_;
				_tmp1411_ = _vala_code_node_ref0 (_tmp1410_);
				this_symbol = _tmp1411_;
				{
					gboolean _tmp1412_ = FALSE;
					_tmp1412_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1417_;
						ValaSymbol* _tmp1418_;
						ValaSymbol* _tmp1419_;
						if (!_tmp1412_) {
							ValaSymbol* _tmp1413_;
							ValaSymbol* _tmp1414_;
							ValaSymbol* _tmp1415_;
							ValaSymbol* _tmp1416_;
							_tmp1413_ = this_symbol;
							_tmp1414_ = vala_symbol_get_parent_symbol (_tmp1413_);
							_tmp1415_ = _tmp1414_;
							_tmp1416_ = _vala_code_node_ref0 (_tmp1415_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1416_;
						}
						_tmp1412_ = FALSE;
						_tmp1417_ = this_symbol;
						if (!(_tmp1417_ != NULL)) {
							break;
						}
						_tmp1418_ = target_type;
						_tmp1419_ = this_symbol;
						if (_tmp1418_ == _tmp1419_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1420_;
				ValaSourceReference* _tmp1421_;
				ValaSymbol* _tmp1422_;
				gchar* _tmp1423_;
				gchar* _tmp1424_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1420_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1421_ = _tmp1420_;
				_tmp1422_ = member;
				_tmp1423_ = vala_symbol_get_full_name (_tmp1422_);
				_tmp1424_ = _tmp1423_;
				vala_report_error (_tmp1421_, "Access to private member `%s' denied", _tmp1424_);
				_g_free0 (_tmp1424_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1426_;
		ValaExpression* _tmp1427_;
		_tmp1426_ = vala_member_access_get_inner (self);
		_tmp1427_ = _tmp1426_;
		_tmp1425_ = _tmp1427_ != NULL;
	} else {
		_tmp1425_ = FALSE;
	}
	if (_tmp1425_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1428_;
		ValaExpression* _tmp1429_;
		ValaDataType* _tmp1430_;
		ValaDataType* _tmp1431_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1432_;
		ValaExpression* _tmp1433_;
		ValaDataType* _tmp1434_;
		ValaDataType* _tmp1435_;
		ValaPointerType* _tmp1436_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1440_;
		gboolean _tmp1441_ = FALSE;
		gboolean _tmp1442_ = FALSE;
		ValaObjectType* _tmp1443_;
		_tmp1428_ = vala_member_access_get_inner (self);
		_tmp1429_ = _tmp1428_;
		_tmp1430_ = vala_expression_get_value_type (_tmp1429_);
		_tmp1431_ = _tmp1430_;
		instance_type = _tmp1431_;
		_tmp1432_ = vala_member_access_get_inner (self);
		_tmp1433_ = _tmp1432_;
		_tmp1434_ = vala_expression_get_value_type (_tmp1433_);
		_tmp1435_ = _tmp1434_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1435_) ? ((ValaPointerType*) _tmp1435_) : NULL;
		_tmp1436_ = pointer_type;
		if (_tmp1436_ != NULL) {
			ValaPointerType* _tmp1437_;
			ValaDataType* _tmp1438_;
			ValaDataType* _tmp1439_;
			_tmp1437_ = pointer_type;
			_tmp1438_ = vala_pointer_type_get_base_type (_tmp1437_);
			_tmp1439_ = _tmp1438_;
			instance_type = _tmp1439_;
		}
		_tmp1440_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1440_) ? ((ValaObjectType*) _tmp1440_) : NULL;
		_tmp1443_ = object_type;
		if (_tmp1443_ != NULL) {
			ValaObjectType* _tmp1444_;
			ValaObjectTypeSymbol* _tmp1445_;
			ValaObjectTypeSymbol* _tmp1446_;
			_tmp1444_ = object_type;
			_tmp1445_ = vala_object_type_get_object_type_symbol (_tmp1444_);
			_tmp1446_ = _tmp1445_;
			_tmp1442_ = vala_object_type_symbol_has_type_parameters (_tmp1446_);
		} else {
			_tmp1442_ = FALSE;
		}
		if (_tmp1442_) {
			ValaDataType* _tmp1447_;
			_tmp1447_ = instance_type;
			_tmp1441_ = !vala_data_type_has_type_arguments (_tmp1447_);
		} else {
			_tmp1441_ = FALSE;
		}
		if (_tmp1441_) {
			ValaExpression* _tmp1448_;
			ValaExpression* _tmp1449_;
			ValaSourceReference* _tmp1450_;
			ValaSourceReference* _tmp1451_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1448_ = vala_member_access_get_inner (self);
			_tmp1449_ = _tmp1448_;
			_tmp1450_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1449_);
			_tmp1451_ = _tmp1450_;
			vala_report_error (_tmp1451_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1453_ = !may_access_instance_members;
	} else {
		_tmp1453_ = FALSE;
	}
	if (_tmp1453_) {
		_tmp1452_ = TRUE;
	} else {
		gboolean _tmp1454_ = FALSE;
		if (klass) {
			_tmp1454_ = !may_access_klass_members;
		} else {
			_tmp1454_ = FALSE;
		}
		_tmp1452_ = _tmp1454_;
	}
	if (_tmp1452_) {
		ValaSymbol* _tmp1455_;
		ValaSymbol* _tmp1456_;
		ValaDataType* _tmp1487_;
		ValaDataType* _tmp1488_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1455_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1456_ = _tmp1455_;
		if (VALA_IS_METHOD (_tmp1456_)) {
			ValaSemanticAnalyzer* _tmp1457_;
			ValaSemanticAnalyzer* _tmp1458_;
			ValaSymbol* _tmp1459_;
			ValaSymbol* _tmp1460_;
			gboolean _tmp1461_;
			gboolean _tmp1462_;
			ValaDataType* _tmp1463_;
			ValaDataType* _tmp1464_;
			ValaDataType* _tmp1465_;
			ValaDataType* _tmp1466_;
			ValaSourceReference* _tmp1467_;
			ValaSourceReference* _tmp1468_;
			_tmp1457_ = vala_code_context_get_analyzer (context);
			_tmp1458_ = _tmp1457_;
			_tmp1459_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1460_ = _tmp1459_;
			_tmp1461_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1462_ = _tmp1461_;
			_tmp1463_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1458_, _tmp1460_, _tmp1462_);
			_tmp1464_ = _tmp1463_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1464_);
			_vala_code_node_unref0 (_tmp1464_);
			_tmp1465_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1466_ = _tmp1465_;
			_tmp1467_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1468_ = _tmp1467_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1466_, _tmp1468_);
		} else {
			ValaSymbol* _tmp1469_;
			ValaSymbol* _tmp1470_;
			_tmp1469_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1470_ = _tmp1469_;
			if (VALA_IS_FIELD (_tmp1470_)) {
				ValaSymbol* _tmp1471_;
				ValaSymbol* _tmp1472_;
				ValaSourceReference* _tmp1473_;
				ValaSourceReference* _tmp1474_;
				ValaFieldPrototype* _tmp1475_;
				ValaFieldPrototype* _tmp1476_;
				_tmp1471_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1472_ = _tmp1471_;
				_tmp1473_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1474_ = _tmp1473_;
				_tmp1475_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1472_, VALA_TYPE_FIELD, ValaField), _tmp1474_);
				_tmp1476_ = _tmp1475_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1476_);
				_vala_code_node_unref0 (_tmp1476_);
			} else {
				ValaSymbol* _tmp1477_;
				ValaSymbol* _tmp1478_;
				_tmp1477_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1478_ = _tmp1477_;
				if (VALA_IS_PROPERTY (_tmp1478_)) {
					ValaSymbol* _tmp1479_;
					ValaSymbol* _tmp1480_;
					ValaSourceReference* _tmp1481_;
					ValaSourceReference* _tmp1482_;
					ValaPropertyPrototype* _tmp1483_;
					ValaPropertyPrototype* _tmp1484_;
					_tmp1479_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1480_ = _tmp1479_;
					_tmp1481_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1482_ = _tmp1481_;
					_tmp1483_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1480_, VALA_TYPE_PROPERTY, ValaProperty), _tmp1482_);
					_tmp1484_ = _tmp1483_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1484_);
					_vala_code_node_unref0 (_tmp1484_);
				} else {
					ValaInvalidType* _tmp1485_;
					ValaInvalidType* _tmp1486_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1485_ = vala_invalid_type_new ();
					_tmp1486_ = _tmp1485_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1486_);
					_vala_code_node_unref0 (_tmp1486_);
				}
			}
		}
		_tmp1487_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1488_ = _tmp1487_;
		if (_tmp1488_ != NULL) {
			ValaDataType* _tmp1489_;
			ValaDataType* _tmp1490_;
			ValaDataType* _tmp1491_;
			ValaDataType* _tmp1492_;
			gboolean _tmp1493_;
			gboolean _tmp1494_;
			_tmp1489_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1492_ = _tmp1491_;
			_tmp1493_ = vala_data_type_get_value_owned (_tmp1492_);
			_tmp1494_ = _tmp1493_;
			vala_data_type_set_value_owned (_tmp1490_, _tmp1494_);
		}
	} else {
		gboolean _tmp1495_ = FALSE;
		gboolean _tmp1516_ = FALSE;
		gboolean _tmp1517_ = FALSE;
		gboolean _tmp1518_ = FALSE;
		gboolean _tmp1519_ = FALSE;
		gboolean _tmp1560_ = FALSE;
		gboolean _tmp1561_ = FALSE;
		gboolean _tmp1562_ = FALSE;
		gboolean _tmp1563_ = FALSE;
		gboolean _tmp1564_ = FALSE;
		gboolean _tmp1565_;
		gboolean _tmp1566_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1591_;
		ValaSymbol* _tmp1592_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1593_;
		ValaExpression* _tmp1594_;
		gboolean _tmp1595_ = FALSE;
		gboolean _tmp1596_ = FALSE;
		gboolean _tmp1597_ = FALSE;
		gboolean _tmp1598_ = FALSE;
		gboolean _tmp1599_ = FALSE;
		ValaMethod* _tmp1600_;
		ValaSemanticAnalyzer* _tmp1640_;
		ValaSemanticAnalyzer* _tmp1641_;
		ValaSymbol* _tmp1642_;
		ValaSymbol* _tmp1643_;
		gboolean _tmp1644_;
		gboolean _tmp1645_;
		ValaDataType* _tmp1646_;
		ValaDataType* _tmp1647_;
		gboolean _tmp1648_ = FALSE;
		ValaExpression* _tmp1649_;
		ValaExpression* _tmp1650_;
		ValaSymbol* _tmp1663_;
		ValaSymbol* _tmp1664_;
		gboolean _tmp1738_ = FALSE;
		gboolean _tmp1739_ = FALSE;
		ValaExpression* _tmp1740_;
		ValaExpression* _tmp1741_;
		if (instance) {
			ValaExpression* _tmp1496_;
			ValaExpression* _tmp1497_;
			_tmp1496_ = vala_member_access_get_inner (self);
			_tmp1497_ = _tmp1496_;
			_tmp1495_ = _tmp1497_ == NULL;
		} else {
			_tmp1495_ = FALSE;
		}
		if (_tmp1495_) {
			ValaSourceReference* _tmp1498_;
			ValaSourceReference* _tmp1499_;
			ValaMemberAccess* _tmp1500_;
			ValaMemberAccess* _tmp1501_;
			ValaExpression* _tmp1502_;
			ValaExpression* _tmp1503_;
			ValaParameter* _tmp1504_;
			ValaDataType* _tmp1505_;
			ValaDataType* _tmp1506_;
			ValaDataType* _tmp1507_;
			ValaDataType* _tmp1508_;
			ValaExpression* _tmp1509_;
			ValaExpression* _tmp1510_;
			ValaDataType* _tmp1511_;
			ValaDataType* _tmp1512_;
			ValaExpression* _tmp1513_;
			ValaExpression* _tmp1514_;
			ValaParameter* _tmp1515_;
			_tmp1498_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1499_ = _tmp1498_;
			_tmp1500_ = vala_member_access_new (NULL, "this", _tmp1499_);
			_tmp1501_ = _tmp1500_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1501_);
			_vala_code_node_unref0 (_tmp1501_);
			_tmp1502_ = vala_member_access_get_inner (self);
			_tmp1503_ = _tmp1502_;
			_tmp1504_ = this_parameter;
			_tmp1505_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1504_);
			_tmp1506_ = _tmp1505_;
			_tmp1507_ = vala_data_type_copy (_tmp1506_);
			_tmp1508_ = _tmp1507_;
			vala_expression_set_value_type (_tmp1503_, _tmp1508_);
			_vala_code_node_unref0 (_tmp1508_);
			_tmp1509_ = vala_member_access_get_inner (self);
			_tmp1510_ = _tmp1509_;
			_tmp1511_ = vala_expression_get_value_type (_tmp1510_);
			_tmp1512_ = _tmp1511_;
			vala_data_type_set_value_owned (_tmp1512_, FALSE);
			_tmp1513_ = vala_member_access_get_inner (self);
			_tmp1514_ = _tmp1513_;
			_tmp1515_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1514_, (ValaSymbol*) _tmp1515_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1519_ = !klass;
		} else {
			_tmp1519_ = FALSE;
		}
		if (_tmp1519_) {
			ValaSymbol* _tmp1520_;
			ValaSymbol* _tmp1521_;
			_tmp1520_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1521_ = _tmp1520_;
			_tmp1518_ = !VALA_IS_CREATION_METHOD (_tmp1521_);
		} else {
			_tmp1518_ = FALSE;
		}
		if (_tmp1518_) {
			_tmp1517_ = may_access_instance_members;
		} else {
			_tmp1517_ = FALSE;
		}
		if (_tmp1517_) {
			ValaExpression* _tmp1522_;
			ValaExpression* _tmp1523_;
			_tmp1522_ = vala_member_access_get_inner (self);
			_tmp1523_ = _tmp1522_;
			_tmp1516_ = _tmp1523_ != NULL;
		} else {
			_tmp1516_ = FALSE;
		}
		if (_tmp1516_) {
			ValaExpression* _tmp1524_;
			ValaExpression* _tmp1525_;
			ValaSymbol* _tmp1526_;
			ValaSymbol* _tmp1527_;
			_tmp1524_ = vala_member_access_get_inner (self);
			_tmp1525_ = _tmp1524_;
			_tmp1526_ = vala_expression_get_symbol_reference (_tmp1525_);
			_tmp1527_ = _tmp1526_;
			if (VALA_IS_METHOD (_tmp1527_)) {
			} else {
				ValaSourceReference* _tmp1528_;
				ValaSourceReference* _tmp1529_;
				ValaSymbol* _tmp1530_;
				ValaSymbol* _tmp1531_;
				gchar* _tmp1532_;
				gchar* _tmp1533_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1534_;
				ValaSymbol* _tmp1535_;
				ValaSymbol* _tmp1536_;
				ValaSymbol* _tmp1537_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1557_;
				ValaExpression* _tmp1558_;
				ValaExpression* _tmp1559_;
				_tmp1528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1529_ = _tmp1528_;
				_tmp1530_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1531_ = _tmp1530_;
				_tmp1532_ = vala_symbol_get_full_name (_tmp1531_);
				_tmp1533_ = _tmp1532_;
				vala_report_warning (_tmp1529_, "Access to static member `%s' with an instance reference", _tmp1533_);
				_g_free0 (_tmp1533_);
				_tmp1534_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1535_ = _tmp1534_;
				_tmp1536_ = vala_symbol_get_parent_symbol (_tmp1535_);
				_tmp1537_ = _tmp1536_;
				inner_sym = _tmp1537_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1538_ = FALSE;
					ValaSymbol* _tmp1539_;
					ValaMemberAccess* _tmp1543_;
					ValaSymbol* _tmp1544_;
					const gchar* _tmp1545_;
					const gchar* _tmp1546_;
					ValaSourceReference* _tmp1547_;
					ValaSourceReference* _tmp1548_;
					ValaMemberAccess* _tmp1549_;
					ValaMemberAccess* _tmp1550_;
					ValaMemberAccess* _tmp1551_;
					ValaExpression* _tmp1552_;
					ValaExpression* _tmp1553_;
					ValaSymbol* _tmp1554_;
					ValaSymbol* _tmp1555_;
					ValaSymbol* _tmp1556_;
					_tmp1539_ = inner_sym;
					if (_tmp1539_ != NULL) {
						ValaSymbol* _tmp1540_;
						const gchar* _tmp1541_;
						const gchar* _tmp1542_;
						_tmp1540_ = inner_sym;
						_tmp1541_ = vala_symbol_get_name (_tmp1540_);
						_tmp1542_ = _tmp1541_;
						_tmp1538_ = _tmp1542_ != NULL;
					} else {
						_tmp1538_ = FALSE;
					}
					if (!_tmp1538_) {
						break;
					}
					_tmp1543_ = inner_ma;
					_tmp1544_ = inner_sym;
					_tmp1545_ = vala_symbol_get_name (_tmp1544_);
					_tmp1546_ = _tmp1545_;
					_tmp1547_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1548_ = _tmp1547_;
					_tmp1549_ = vala_member_access_new (NULL, _tmp1546_, _tmp1548_);
					_tmp1550_ = _tmp1549_;
					vala_member_access_set_inner (_tmp1543_, (ValaExpression*) _tmp1550_);
					_vala_code_node_unref0 (_tmp1550_);
					_tmp1551_ = inner_ma;
					_tmp1552_ = vala_member_access_get_inner (_tmp1551_);
					_tmp1553_ = _tmp1552_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1553_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1554_ = inner_sym;
					_tmp1555_ = vala_symbol_get_parent_symbol (_tmp1554_);
					_tmp1556_ = _tmp1555_;
					inner_sym = _tmp1556_;
				}
				_tmp1557_ = inner_ma;
				vala_member_access_set_qualified (_tmp1557_, TRUE);
				_tmp1558_ = vala_member_access_get_inner (self);
				_tmp1559_ = _tmp1558_;
				vala_code_node_check ((ValaCodeNode*) _tmp1559_, context);
			}
		}
		_tmp1565_ = vala_code_context_get_experimental_non_null (context);
		_tmp1566_ = _tmp1565_;
		if (_tmp1566_) {
			_tmp1564_ = instance;
		} else {
			_tmp1564_ = FALSE;
		}
		if (_tmp1564_) {
			ValaExpression* _tmp1567_;
			ValaExpression* _tmp1568_;
			ValaDataType* _tmp1569_;
			ValaDataType* _tmp1570_;
			gboolean _tmp1571_;
			gboolean _tmp1572_;
			_tmp1567_ = vala_member_access_get_inner (self);
			_tmp1568_ = _tmp1567_;
			_tmp1569_ = vala_expression_get_value_type (_tmp1568_);
			_tmp1570_ = _tmp1569_;
			_tmp1571_ = vala_data_type_get_nullable (_tmp1570_);
			_tmp1572_ = _tmp1571_;
			_tmp1563_ = _tmp1572_;
		} else {
			_tmp1563_ = FALSE;
		}
		if (_tmp1563_) {
			ValaExpression* _tmp1573_;
			ValaExpression* _tmp1574_;
			ValaDataType* _tmp1575_;
			ValaDataType* _tmp1576_;
			_tmp1573_ = vala_member_access_get_inner (self);
			_tmp1574_ = _tmp1573_;
			_tmp1575_ = vala_expression_get_value_type (_tmp1574_);
			_tmp1576_ = _tmp1575_;
			_tmp1562_ = !VALA_IS_POINTER_TYPE (_tmp1576_);
		} else {
			_tmp1562_ = FALSE;
		}
		if (_tmp1562_) {
			ValaExpression* _tmp1577_;
			ValaExpression* _tmp1578_;
			ValaDataType* _tmp1579_;
			ValaDataType* _tmp1580_;
			_tmp1577_ = vala_member_access_get_inner (self);
			_tmp1578_ = _tmp1577_;
			_tmp1579_ = vala_expression_get_value_type (_tmp1578_);
			_tmp1580_ = _tmp1579_;
			_tmp1561_ = !VALA_IS_GENERIC_TYPE (_tmp1580_);
		} else {
			_tmp1561_ = FALSE;
		}
		if (_tmp1561_) {
			ValaExpression* _tmp1581_;
			ValaExpression* _tmp1582_;
			ValaDataType* _tmp1583_;
			ValaDataType* _tmp1584_;
			_tmp1581_ = vala_member_access_get_inner (self);
			_tmp1582_ = _tmp1581_;
			_tmp1583_ = vala_expression_get_value_type (_tmp1582_);
			_tmp1584_ = _tmp1583_;
			_tmp1560_ = !VALA_IS_ARRAY_TYPE (_tmp1584_);
		} else {
			_tmp1560_ = FALSE;
		}
		if (_tmp1560_) {
			ValaSourceReference* _tmp1585_;
			ValaSourceReference* _tmp1586_;
			ValaSymbol* _tmp1587_;
			ValaSymbol* _tmp1588_;
			gchar* _tmp1589_;
			gchar* _tmp1590_;
			_tmp1585_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1586_ = _tmp1585_;
			_tmp1587_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1588_ = _tmp1587_;
			_tmp1589_ = vala_symbol_get_full_name (_tmp1588_);
			_tmp1590_ = _tmp1589_;
			vala_report_error (_tmp1586_, "Access to instance member `%s' from nullable reference denied", _tmp1590_);
			_g_free0 (_tmp1590_);
		}
		_tmp1591_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1592_ = _tmp1591_;
		m = VALA_IS_METHOD (_tmp1592_) ? ((ValaMethod*) _tmp1592_) : NULL;
		_tmp1593_ = vala_member_access_get_inner (self);
		_tmp1594_ = _tmp1593_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1594_) ? ((ValaMemberAccess*) _tmp1594_) : NULL;
		_tmp1600_ = m;
		if (_tmp1600_ != NULL) {
			ValaMethod* _tmp1601_;
			ValaMemberBinding _tmp1602_;
			ValaMemberBinding _tmp1603_;
			_tmp1601_ = m;
			_tmp1602_ = vala_method_get_binding (_tmp1601_);
			_tmp1603_ = _tmp1602_;
			_tmp1599_ = _tmp1603_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1599_ = FALSE;
		}
		if (_tmp1599_) {
			ValaMethod* _tmp1604_;
			ValaSymbol* _tmp1605_;
			ValaSymbol* _tmp1606_;
			_tmp1604_ = m;
			_tmp1605_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1604_);
			_tmp1606_ = _tmp1605_;
			_tmp1598_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1606_);
		} else {
			_tmp1598_ = FALSE;
		}
		if (_tmp1598_) {
			ValaExpression* _tmp1607_;
			ValaExpression* _tmp1608_;
			_tmp1607_ = vala_member_access_get_inner (self);
			_tmp1608_ = _tmp1607_;
			_tmp1597_ = _tmp1608_ != NULL;
		} else {
			_tmp1597_ = FALSE;
		}
		if (_tmp1597_) {
			ValaExpression* _tmp1609_;
			ValaExpression* _tmp1610_;
			ValaDataType* _tmp1611_;
			ValaDataType* _tmp1612_;
			_tmp1609_ = vala_member_access_get_inner (self);
			_tmp1610_ = _tmp1609_;
			_tmp1611_ = vala_expression_get_value_type (_tmp1610_);
			_tmp1612_ = _tmp1611_;
			_tmp1596_ = _tmp1612_ == NULL;
		} else {
			_tmp1596_ = FALSE;
		}
		if (_tmp1596_) {
			ValaMemberAccess* _tmp1613_;
			ValaList* _tmp1614_;
			gint _tmp1615_;
			gint _tmp1616_;
			_tmp1613_ = inner_ma;
			_tmp1614_ = _tmp1613_->priv->type_argument_list;
			_tmp1615_ = vala_collection_get_size ((ValaCollection*) _tmp1614_);
			_tmp1616_ = _tmp1615_;
			_tmp1595_ = _tmp1616_ > 0;
		} else {
			_tmp1595_ = FALSE;
		}
		if (_tmp1595_) {
			ValaExpression* _tmp1617_;
			ValaExpression* _tmp1618_;
			ValaMethod* _tmp1619_;
			ValaSymbol* _tmp1620_;
			ValaSymbol* _tmp1621_;
			ValaSourceReference* _tmp1622_;
			ValaSourceReference* _tmp1623_;
			ValaObjectType* _tmp1624_;
			ValaObjectType* _tmp1625_;
			_tmp1617_ = vala_member_access_get_inner (self);
			_tmp1618_ = _tmp1617_;
			_tmp1619_ = m;
			_tmp1620_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1619_);
			_tmp1621_ = _tmp1620_;
			_tmp1622_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1623_ = _tmp1622_;
			_tmp1624_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1621_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), _tmp1623_);
			_tmp1625_ = _tmp1624_;
			vala_expression_set_value_type (_tmp1618_, (ValaDataType*) _tmp1625_);
			_vala_code_node_unref0 (_tmp1625_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1626_;
				ValaList* _tmp1627_;
				gint _type_argument_size = 0;
				ValaList* _tmp1628_;
				gint _tmp1629_;
				gint _tmp1630_;
				gint _type_argument_index = 0;
				_tmp1626_ = inner_ma;
				_tmp1627_ = _tmp1626_->priv->type_argument_list;
				_type_argument_list = _tmp1627_;
				_tmp1628_ = _type_argument_list;
				_tmp1629_ = vala_collection_get_size ((ValaCollection*) _tmp1628_);
				_tmp1630_ = _tmp1629_;
				_type_argument_size = _tmp1630_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1631_;
					gint _tmp1632_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1633_;
					gpointer _tmp1634_;
					ValaExpression* _tmp1635_;
					ValaExpression* _tmp1636_;
					ValaDataType* _tmp1637_;
					ValaDataType* _tmp1638_;
					ValaDataType* _tmp1639_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1631_ = _type_argument_index;
					_tmp1632_ = _type_argument_size;
					if (!(_tmp1631_ < _tmp1632_)) {
						break;
					}
					_tmp1633_ = _type_argument_list;
					_tmp1634_ = vala_list_get (_tmp1633_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1634_;
					_tmp1635_ = vala_member_access_get_inner (self);
					_tmp1636_ = _tmp1635_;
					_tmp1637_ = vala_expression_get_value_type (_tmp1636_);
					_tmp1638_ = _tmp1637_;
					_tmp1639_ = type_argument;
					vala_data_type_add_type_argument (_tmp1638_, _tmp1639_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1640_ = vala_code_context_get_analyzer (context);
		_tmp1641_ = _tmp1640_;
		_tmp1642_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1643_ = _tmp1642_;
		_tmp1644_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1645_ = _tmp1644_;
		_tmp1646_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1641_, _tmp1643_, _tmp1645_);
		_tmp1647_ = _tmp1646_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1647_);
		_vala_code_node_unref0 (_tmp1647_);
		_tmp1649_ = vala_member_access_get_inner (self);
		_tmp1650_ = _tmp1649_;
		if (_tmp1650_ != NULL) {
			ValaDataType* _tmp1651_;
			ValaDataType* _tmp1652_;
			_tmp1651_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1652_ = _tmp1651_;
			_tmp1648_ = _tmp1652_ != NULL;
		} else {
			_tmp1648_ = FALSE;
		}
		if (_tmp1648_) {
			ValaDataType* _tmp1653_;
			ValaDataType* _tmp1654_;
			ValaExpression* _tmp1655_;
			ValaExpression* _tmp1656_;
			ValaDataType* _tmp1657_;
			ValaDataType* _tmp1658_;
			ValaDataType* _tmp1659_;
			ValaDataType* _tmp1660_;
			_tmp1653_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1654_ = _tmp1653_;
			_tmp1655_ = vala_member_access_get_inner (self);
			_tmp1656_ = _tmp1655_;
			_tmp1657_ = vala_expression_get_value_type (_tmp1656_);
			_tmp1658_ = _tmp1657_;
			_tmp1659_ = vala_data_type_get_actual_type (_tmp1654_, _tmp1658_, NULL, (ValaCodeNode*) self);
			_tmp1660_ = _tmp1659_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1660_);
			_vala_code_node_unref0 (_tmp1660_);
		} else {
			ValaDataType* _tmp1661_;
			ValaDataType* _tmp1662_;
			_tmp1661_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1662_ = _tmp1661_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1662_);
		}
		_tmp1663_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1664_ = _tmp1663_;
		if (VALA_IS_METHOD (_tmp1664_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1665_;
			ValaSymbol* _tmp1666_;
			ValaDataType* _tmp1667_;
			ValaDataType* _tmp1668_;
			gboolean _tmp1675_ = FALSE;
			_tmp1665_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1666_ = _tmp1665_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1666_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1667_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1668_ = _tmp1667_;
			if (_tmp1668_ != NULL) {
				ValaDataType* _tmp1669_;
				ValaDataType* _tmp1670_;
				ValaDataType* _tmp1671_;
				ValaDataType* _tmp1672_;
				gboolean _tmp1673_;
				gboolean _tmp1674_;
				_tmp1669_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1670_ = _tmp1669_;
				_tmp1671_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1672_ = _tmp1671_;
				_tmp1673_ = vala_data_type_get_value_owned (_tmp1672_);
				_tmp1674_ = _tmp1673_;
				vala_data_type_set_value_owned (_tmp1670_, _tmp1674_);
			}
			if (instance) {
				ValaMethod* _tmp1676_;
				ValaSymbol* _tmp1677_;
				ValaSymbol* _tmp1678_;
				_tmp1676_ = method;
				_tmp1677_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1676_);
				_tmp1678_ = _tmp1677_;
				_tmp1675_ = VALA_IS_TYPESYMBOL (_tmp1678_);
			} else {
				_tmp1675_ = FALSE;
			}
			if (_tmp1675_) {
				ValaExpression* _tmp1679_;
				ValaExpression* _tmp1680_;
				ValaMethod* _tmp1681_;
				ValaSymbol* _tmp1682_;
				ValaSymbol* _tmp1683_;
				ValaDataType* _tmp1684_;
				ValaDataType* _tmp1685_;
				ValaExpression* _tmp1686_;
				ValaExpression* _tmp1687_;
				ValaDataType* _tmp1688_;
				ValaDataType* _tmp1689_;
				ValaMethod* _tmp1690_;
				ValaParameter* _tmp1691_;
				ValaParameter* _tmp1692_;
				ValaDataType* _tmp1693_;
				ValaDataType* _tmp1694_;
				gboolean _tmp1695_;
				gboolean _tmp1696_;
				_tmp1679_ = vala_member_access_get_inner (self);
				_tmp1680_ = _tmp1679_;
				_tmp1681_ = method;
				_tmp1682_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1681_);
				_tmp1683_ = _tmp1682_;
				_tmp1684_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1683_);
				_tmp1685_ = _tmp1684_;
				vala_expression_set_target_type (_tmp1680_, _tmp1685_);
				_vala_code_node_unref0 (_tmp1685_);
				_tmp1686_ = vala_member_access_get_inner (self);
				_tmp1687_ = _tmp1686_;
				_tmp1688_ = vala_expression_get_target_type (_tmp1687_);
				_tmp1689_ = _tmp1688_;
				_tmp1690_ = method;
				_tmp1691_ = vala_method_get_this_parameter (_tmp1690_);
				_tmp1692_ = _tmp1691_;
				_tmp1693_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1692_);
				_tmp1694_ = _tmp1693_;
				_tmp1695_ = vala_data_type_get_value_owned (_tmp1694_);
				_tmp1696_ = _tmp1695_;
				vala_data_type_set_value_owned (_tmp1689_, _tmp1696_);
			}
		} else {
			gboolean _tmp1697_ = FALSE;
			gboolean _tmp1698_ = FALSE;
			ValaSymbol* _tmp1699_;
			ValaSymbol* _tmp1700_;
			_tmp1699_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1700_ = _tmp1699_;
			if (VALA_IS_PROPERTY (_tmp1700_)) {
				_tmp1698_ = instance;
			} else {
				_tmp1698_ = FALSE;
			}
			if (_tmp1698_) {
				ValaSymbol* _tmp1701_;
				ValaSymbol* _tmp1702_;
				ValaSymbol* _tmp1703_;
				ValaSymbol* _tmp1704_;
				_tmp1701_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1702_ = _tmp1701_;
				_tmp1703_ = vala_symbol_get_parent_symbol (_tmp1702_);
				_tmp1704_ = _tmp1703_;
				_tmp1697_ = _tmp1704_ != NULL;
			} else {
				_tmp1697_ = FALSE;
			}
			if (_tmp1697_) {
				ValaExpression* _tmp1705_;
				ValaExpression* _tmp1706_;
				ValaSymbol* _tmp1707_;
				ValaSymbol* _tmp1708_;
				ValaSymbol* _tmp1709_;
				ValaSymbol* _tmp1710_;
				ValaDataType* _tmp1711_;
				ValaDataType* _tmp1712_;
				_tmp1705_ = vala_member_access_get_inner (self);
				_tmp1706_ = _tmp1705_;
				_tmp1707_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1708_ = _tmp1707_;
				_tmp1709_ = vala_symbol_get_parent_symbol (_tmp1708_);
				_tmp1710_ = _tmp1709_;
				_tmp1711_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1710_);
				_tmp1712_ = _tmp1711_;
				vala_expression_set_target_type (_tmp1706_, _tmp1712_);
				_vala_code_node_unref0 (_tmp1712_);
			} else {
				gboolean _tmp1713_ = FALSE;
				gboolean _tmp1714_ = FALSE;
				gboolean _tmp1715_ = FALSE;
				ValaSymbol* _tmp1716_;
				ValaSymbol* _tmp1717_;
				_tmp1716_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1717_ = _tmp1716_;
				if (VALA_IS_FIELD (_tmp1717_)) {
					_tmp1715_ = TRUE;
				} else {
					ValaSymbol* _tmp1718_;
					ValaSymbol* _tmp1719_;
					_tmp1718_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1719_ = _tmp1718_;
					_tmp1715_ = VALA_IS_SIGNAL (_tmp1719_);
				}
				if (_tmp1715_) {
					_tmp1714_ = instance;
				} else {
					_tmp1714_ = FALSE;
				}
				if (_tmp1714_) {
					ValaSymbol* _tmp1720_;
					ValaSymbol* _tmp1721_;
					ValaSymbol* _tmp1722_;
					ValaSymbol* _tmp1723_;
					_tmp1720_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1721_ = _tmp1720_;
					_tmp1722_ = vala_symbol_get_parent_symbol (_tmp1721_);
					_tmp1723_ = _tmp1722_;
					_tmp1713_ = _tmp1723_ != NULL;
				} else {
					_tmp1713_ = FALSE;
				}
				if (_tmp1713_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1724_;
					ValaSymbol* _tmp1725_;
					ValaSymbol* _tmp1726_;
					ValaSymbol* _tmp1727_;
					ValaDataType* _tmp1728_;
					ValaExpression* _tmp1729_;
					ValaExpression* _tmp1730_;
					ValaDataType* _tmp1731_;
					ValaExpression* _tmp1732_;
					ValaExpression* _tmp1733_;
					ValaDataType* _tmp1734_;
					ValaDataType* _tmp1735_;
					ValaDataType* _tmp1736_;
					ValaDataType* _tmp1737_;
					_tmp1724_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1725_ = _tmp1724_;
					_tmp1726_ = vala_symbol_get_parent_symbol (_tmp1725_);
					_tmp1727_ = _tmp1726_;
					_tmp1728_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1727_);
					parent_type = _tmp1728_;
					_tmp1729_ = vala_member_access_get_inner (self);
					_tmp1730_ = _tmp1729_;
					_tmp1731_ = parent_type;
					_tmp1732_ = vala_member_access_get_inner (self);
					_tmp1733_ = _tmp1732_;
					_tmp1734_ = vala_expression_get_value_type (_tmp1733_);
					_tmp1735_ = _tmp1734_;
					_tmp1736_ = vala_data_type_get_actual_type (_tmp1731_, _tmp1735_, NULL, (ValaCodeNode*) self);
					_tmp1737_ = _tmp1736_;
					vala_expression_set_target_type (_tmp1730_, _tmp1737_);
					_vala_code_node_unref0 (_tmp1737_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1740_ = vala_member_access_get_inner (self);
		_tmp1741_ = _tmp1740_;
		if (_tmp1741_ == NULL) {
			ValaDataType* _tmp1742_;
			ValaDataType* _tmp1743_;
			_tmp1742_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1743_ = _tmp1742_;
			_tmp1739_ = _tmp1743_ != NULL;
		} else {
			_tmp1739_ = FALSE;
		}
		if (_tmp1739_) {
			ValaProfile _tmp1744_;
			ValaProfile _tmp1745_;
			_tmp1744_ = vala_code_context_get_profile (context);
			_tmp1745_ = _tmp1744_;
			_tmp1738_ = _tmp1745_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1738_ = FALSE;
		}
		if (_tmp1738_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1746_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1747_ = _tmp1746_;
	if (_tmp1747_ != NULL) {
		ValaDataType* _tmp1748_;
		ValaDataType* _tmp1749_;
		_tmp1748_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1749_ = _tmp1748_;
		vala_code_node_check ((ValaCodeNode*) _tmp1749_, context);
	}
	_tmp1750_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1751_ = _tmp1750_;
	if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp1751_)) {
		gboolean _tmp1752_ = FALSE;
		gboolean _tmp1753_ = FALSE;
		ValaExpression* _tmp1754_;
		ValaExpression* _tmp1755_;
		ValaDataType* _tmp1756_;
		ValaDataType* _tmp1757_;
		_tmp1754_ = vala_member_access_get_inner (self);
		_tmp1755_ = _tmp1754_;
		_tmp1756_ = vala_expression_get_value_type (_tmp1755_);
		_tmp1757_ = _tmp1756_;
		if (VALA_IS_ARRAY_TYPE (_tmp1757_)) {
			ValaExpression* _tmp1758_;
			ValaExpression* _tmp1759_;
			ValaDataType* _tmp1760_;
			ValaDataType* _tmp1761_;
			gint _tmp1762_;
			gint _tmp1763_;
			_tmp1758_ = vala_member_access_get_inner (self);
			_tmp1759_ = _tmp1758_;
			_tmp1760_ = vala_expression_get_value_type (_tmp1759_);
			_tmp1761_ = _tmp1760_;
			_tmp1762_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp1761_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp1763_ = _tmp1762_;
			_tmp1753_ = _tmp1763_ > 1;
		} else {
			_tmp1753_ = FALSE;
		}
		if (_tmp1753_) {
			ValaCodeNode* _tmp1764_;
			ValaCodeNode* _tmp1765_;
			_tmp1764_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp1765_ = _tmp1764_;
			_tmp1752_ = !VALA_IS_ELEMENT_ACCESS (_tmp1765_);
		} else {
			_tmp1752_ = FALSE;
		}
		if (_tmp1752_) {
			ValaSourceReference* _tmp1766_;
			ValaSourceReference* _tmp1767_;
			_tmp1766_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1767_ = _tmp1766_;
			vala_report_error (_tmp1767_, "unsupported use of length field of multi-dimensional array");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	} else {
		ValaSymbol* _tmp1768_;
		ValaSymbol* _tmp1769_;
		_tmp1768_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1769_ = _tmp1768_;
		if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp1769_)) {
			ValaExpression* _tmp1770_;
			ValaExpression* _tmp1771_;
			ValaDataType* _tmp1772_;
			ValaDataType* _tmp1773_;
			ValaDelegate* _tmp1774_;
			ValaDelegate* _tmp1775_;
			gboolean _tmp1776_;
			gboolean _tmp1777_;
			_tmp1770_ = vala_member_access_get_inner (self);
			_tmp1771_ = _tmp1770_;
			_tmp1772_ = vala_expression_get_value_type (_tmp1771_);
			_tmp1773_ = _tmp1772_;
			_tmp1774_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1773_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			_tmp1775_ = _tmp1774_;
			_tmp1776_ = vala_delegate_get_has_target (_tmp1775_);
			_tmp1777_ = _tmp1776_;
			if (!_tmp1777_) {
				ValaSourceReference* _tmp1778_;
				ValaSourceReference* _tmp1779_;
				_tmp1778_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1779_ = _tmp1778_;
				vala_report_error (_tmp1779_, "unsupported use of target field of delegate without target");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		} else {
			ValaSymbol* _tmp1780_;
			ValaSymbol* _tmp1781_;
			_tmp1780_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1781_ = _tmp1780_;
			if (VALA_IS_DELEGATE_DESTROY_FIELD (_tmp1781_)) {
				ValaExpression* _tmp1782_;
				ValaExpression* _tmp1783_;
				ValaDataType* _tmp1784_;
				ValaDataType* _tmp1785_;
				ValaDelegate* _tmp1786_;
				ValaDelegate* _tmp1787_;
				gboolean _tmp1788_;
				gboolean _tmp1789_;
				_tmp1782_ = vala_member_access_get_inner (self);
				_tmp1783_ = _tmp1782_;
				_tmp1784_ = vala_expression_get_value_type (_tmp1783_);
				_tmp1785_ = _tmp1784_;
				_tmp1786_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1785_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp1787_ = _tmp1786_;
				_tmp1788_ = vala_delegate_get_has_target (_tmp1787_);
				_tmp1789_ = _tmp1788_;
				if (!_tmp1789_) {
					ValaSourceReference* _tmp1790_;
					ValaSourceReference* _tmp1791_;
					_tmp1790_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1791_ = _tmp1790_;
					vala_report_error (_tmp1791_, "unsupported use of destroy field of delegate without target");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp1792_ = self->priv->_tainted_access;
	if (!_tmp1792_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1793_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1794_ = _tmp1793_;
	result = !_tmp1794_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	gboolean _tmp93_ = FALSE;
	ValaSymbol* _tmp94_;
	ValaSymbol* _tmp95_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp85_)) {
		_tmp83_ = TRUE;
	} else {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp83_ = VALA_IS_DELEGATE_DESTROY_FIELD (_tmp87_);
	}
	if (_tmp83_) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaMemberAccess* _tmp90_;
		_tmp88_ = vala_member_access_get_inner (self);
		_tmp89_ = _tmp88_;
		vala_expression_set_lvalue (_tmp89_, TRUE);
		_tmp90_ = ma;
		if (_tmp90_ != NULL) {
			ValaMemberAccess* _tmp91_;
			ValaMemberAccess* _tmp92_;
			_tmp91_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp91_, TRUE);
			_tmp92_ = ma;
			vala_member_access_check_lvalue_access (_tmp92_);
		}
	}
	_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp95_ = _tmp94_;
	if (VALA_IS_METHOD (_tmp95_)) {
		ValaSymbol* _tmp96_;
		ValaSymbol* _tmp97_;
		_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp97_ = _tmp96_;
		_tmp93_ = vala_code_node_has_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaClass* _tmp104_;
		_tmp98_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_METHOD, ValaMethod));
		_tmp101_ = _tmp100_;
		cl = VALA_IS_CLASS (_tmp101_) ? ((ValaClass*) _tmp101_) : NULL;
		_tmp104_ = cl;
		if (_tmp104_ != NULL) {
			ValaClass* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp105_ = cl;
			_tmp106_ = vala_class_get_is_compact (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp103_ = _tmp107_;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp108_;
			_tmp108_ = ma;
			_tmp102_ = _tmp108_ != NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp109_;
			ValaMemberAccess* _tmp110_;
			_tmp109_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp109_, TRUE);
			_tmp110_ = ma;
			vala_member_access_check_lvalue_access (_tmp110_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	gboolean _tmp0_ = FALSE;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp18_;
	ValaCodeNode* _tmp19_;
	ValaTraverseVisitor* _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp1_ = node;
	_tmp2_ = vala_code_node_get_parent_node (_tmp1_);
	_tmp3_ = _tmp2_;
	if (VALA_IS_ELEMENT_ACCESS (_tmp3_)) {
		_tmp0_ = TRUE;
	} else {
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		_tmp4_ = node;
		_tmp5_ = vala_code_node_get_parent_node (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = VALA_IS_MEMBER_ACCESS (_tmp6_);
	}
	if (_tmp0_) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp11_;
		ValaCodeNode* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		ValaCodeNode* _tmp15_;
		_tmp7_ = node;
		_tmp8_ = vala_code_node_get_parent_node (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!VALA_IS_EXPRESSION (_tmp9_)) {
			break;
		}
		_tmp10_ = node;
		_tmp11_ = vala_code_node_get_parent_node (_tmp10_);
		_tmp12_ = _tmp11_;
		node = _tmp12_;
		_tmp15_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp15_)) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeNode* _tmp16_;
			_tmp16_ = node;
			_tmp14_ = VALA_IS_METHOD_CALL (_tmp16_);
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			ValaCodeNode* _tmp17_;
			_tmp17_ = node;
			_tmp13_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp17_);
		}
		if (_tmp13_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp18_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp18_;
	_tmp19_ = node;
	_tmp20_ = traverse;
	vala_code_node_accept (_tmp19_, (ValaCodeVisitor*) _tmp20_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__once = 0;
	if (g_once_init_enter (&vala_member_access_type_id__once)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__once, vala_member_access_type_id);
	}
	return vala_member_access_type_id__once;
}

