/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;

public class Ref
extends Command {
    public Ref() {
        this("ref");
    }

    public Ref(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new Ref(this.getName());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = teXParser.popNextArg();
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser)) != null) {
            teXObject = teXObjectList;
        }
        return this.expandref(teXParser, teXObject);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        if (teXObject instanceof Expandable && (teXObjectList2 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObject = teXObjectList2;
        }
        return this.expandref(teXParser, teXObject);
    }

    protected TeXObjectList expandref(TeXParser teXParser, TeXObject teXObject) throws IOException {
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        TeXObject teXObject2 = laTeXParserListener.getReference(teXObject);
        if (teXObject2 == null) {
            return null;
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        if (laTeXParserListener.isStyLoaded("hyperref")) {
            Group group;
            teXObjectList.add(new TeXCsRef("hyperlink"));
            if (teXObject instanceof Group) {
                teXObjectList.add(teXObject);
            } else {
                group = laTeXParserListener.createGroup();
                if (teXObject instanceof TeXObjectList) {
                    group.addAll((TeXObjectList)teXObject);
                } else {
                    group.add(teXObject);
                }
                teXObjectList.add(group);
            }
            if (teXObject2 instanceof Group) {
                teXObjectList.add(teXObject2);
            } else {
                group = laTeXParserListener.createGroup();
                if (teXObject2 instanceof TeXObjectList) {
                    group.addAll((TeXObjectList)teXObject2);
                } else {
                    group.add(teXObject2);
                }
                teXObjectList.add(group);
            }
        } else {
            if (teXObject2 instanceof TeXObjectList) {
                return (TeXObjectList)teXObject2;
            }
            teXObjectList.add(teXObject2);
        }
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = this.expandonce(teXParser, teXObjectList);
        if (teXObjectList2 != null) {
            teXObjectList2.process(teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = this.expandonce(teXParser);
        if (teXObjectList != null) {
            teXObjectList.process(teXParser);
        }
    }
}

