.\"
.\" mime.convs man page for CUPS.
.\"
.\" Copyright 2007-2015 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH mime.convs 5 "CUPS" "26 August 2015" "Apple Inc."
.SH NAME
mime.convs \- mime type conversion file for cups
.SH DESCRIPTION
The \fBmime.convs\fR file defines the filters that are available for converting files from one format to another.
The standard filters support text, PDF, PostScript, and many types of image files.
.LP
Additional filters are specified in files with the extension \fI.convs\fR in the CUPS configuration directory.
.LP
Each line in the \fBmime.convs\fR file is a comment, blank, or filter
line.
Comment lines start with the # character.
Filter lines specify the source and destination MIME types along with a relative cost associated with the filter and the filter to run:
.nf

    source/type destination/type cost filter

.fi
The \fIsource/type\fR field specifies the source MIME media type that is consumed by the filter.
.LP
The \fIdestination/type\fR field specifies the destination MIME media type that is produced by the filter.
.LP
The \fIcost\fR field specifies the relative cost for running the filter.
A value of 100 means that the filter uses a large amount of resources while a value of 0 means that the filter uses very few resources.
.LP
The \fIfilter\fR field specifies the filter program filename.
Filenames are relative to the CUPS filter directory.
.SH FILES
\fI/etc/cups\fR - Typical CUPS configuration directory.
.br
\fI/usr/lib/cups/filter\fR - Typical CUPS filter directory.
.br
\fI/usr/libexec/cups/filter\fR - CUPS filter directory on macOS.
.SH EXAMPLES
Define a filter that converts PostScript documents to CUPS Raster format:
.nf

    application/vnd.cups\-postscript application/vnd.cups\-raster 50 pstoraster

.fi
.SH SEE ALSO
.BR cups-files.conf (5),
.BR cupsd.conf (5),
.BR cupsd (8),
.BR cupsfilter (8),
.BR mime.types (5),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2017 by Apple Inc.
