; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --no_x86_scrub_sp
; Run with --no_x86_scrub_rip because we care a lot about how globals are
; accessed in the code model.

; RUN: llc -verify-machineinstrs < %s -relocation-model=static -code-model=small  | FileCheck %s --check-prefix=CHECK --check-prefix=SMALL-STATIC
; RUN: llc -verify-machineinstrs < %s -relocation-model=static -code-model=medium | FileCheck %s --check-prefix=CHECK --check-prefix=MEDIUM-STATIC
; RUN: llc -verify-machineinstrs < %s -relocation-model=static -code-model=large  | FileCheck %s --check-prefix=CHECK --check-prefix=LARGE-STATIC
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=small  | FileCheck %s --check-prefix=CHECK --check-prefix=SMALL-PIC
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=medium -large-data-threshold=1000 | FileCheck %s --check-prefix=CHECK --check-prefix=MEDIUM-SMALL-DATA-PIC
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=medium | FileCheck %s --check-prefix=CHECK --check-prefix=MEDIUM-PIC
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=large  | FileCheck %s --check-prefix=CHECK --check-prefix=LARGE-PIC
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=large  -large-data-threshold=1000 | FileCheck %s --check-prefix=CHECK --check-prefix=LARGE-SMALL-DATA-PIC

; Check that the relocations we emit are valid.
; RUN: llc -verify-machineinstrs < %s -relocation-model=static -code-model=small  -filetype=obj -o /dev/null
; RUN: llc -verify-machineinstrs < %s -relocation-model=static -code-model=medium -filetype=obj -o /dev/null
; RUN: llc -verify-machineinstrs < %s -relocation-model=static -code-model=large  -filetype=obj -o /dev/null
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=small  -filetype=obj -o /dev/null
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=medium -large-data-threshold=1000 -filetype=obj -o /dev/null
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=medium -filetype=obj -o /dev/null
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=large  -filetype=obj -o /dev/null
; RUN: llc -verify-machineinstrs < %s -relocation-model=pic    -code-model=large  -large-data-threshold=1000 -filetype=obj -o /dev/null

; Generated from this C source:
;
; static int static_data[10];
; int global_data[10] = {1, 2};
; extern int extern_data[10];
;
; int *lea_static_data() { return &static_data[0]; }
; int *lea_global_data() { return &global_data[0]; }
; int *lea_extern_data() { return &extern_data[0]; }
;
; static void static_fn(void) {}
; void global_fn(void) {}
; void extern_fn(void);
;
; typedef void (*void_fn)(void);
; void_fn lea_static_fn() { return &static_fn; }
; void_fn lea_global_fn() { return &global_fn; }
; void_fn lea_extern_fn() { return &extern_fn; }


; ModuleID = 'model.c'
source_filename = "model.c"
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64--linux"

%t = type opaque

@global_data = dso_local global [10 x i32] [i32 1, i32 2, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0], align 16
@static_data = internal global [10 x i32] zeroinitializer, align 16
@static_data_alias = internal constant ptr getelementptr inbounds ([10 x i32], ptr @static_data, i64 0, i64 2), align 8
@extern_data = external global [10 x i32], align 16
@thread_data = external thread_local global i32, align 4
@unknown_size_data = dso_local global [0 x i32] zeroinitializer, align 16
@bool = dso_local global i1 false
@opaque = external dso_local global %t
@forced_small_data = dso_local global [10 x i32] zeroinitializer, code_model "small", align 16
@forced_large_data = dso_local global [10 x i32] zeroinitializer, code_model "large", align 16
@__ehdr_start = external dso_local global i8
@__start_foo = external dso_local global i8
@__stop_foo = external dso_local global i8

define dso_local ptr @lea_static_data() #0 {
; SMALL-STATIC-LABEL: lea_static_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $static_data, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_static_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $static_data, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_static_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $static_data, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_static_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq static_data(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_static_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq static_data(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_static_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $static_data@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_static_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L0$pb:
; LARGE-PIC-NEXT:    leaq .L0$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L0$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $static_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_static_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L0$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L0$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L0$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $static_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @static_data
}

define dso_local ptr @lea_static_data_alias() #0 {
; SMALL-STATIC-LABEL: lea_static_data_alias:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $static_data_alias, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_static_data_alias:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $static_data_alias, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_static_data_alias:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $static_data_alias, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_static_data_alias:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq static_data_alias(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_static_data_alias:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq static_data_alias(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_static_data_alias:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $static_data_alias@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_static_data_alias:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L1$pb:
; LARGE-PIC-NEXT:    leaq .L1$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L1$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $static_data_alias@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_static_data_alias:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L1$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L1$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L1$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $static_data_alias@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @static_data_alias
}

define dso_local ptr @lea_global_data() #0 {
; SMALL-STATIC-LABEL: lea_global_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $global_data, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_global_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $global_data, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_global_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $global_data, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_global_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq global_data(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_global_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq global_data(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_global_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $global_data@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_global_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L2$pb:
; LARGE-PIC-NEXT:    leaq .L2$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L2$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $global_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_global_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L2$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L2$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L2$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $global_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @global_data
}

define dso_local ptr @lea_extern_data() #0 {
; SMALL-STATIC-LABEL: lea_extern_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_extern_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_extern_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $extern_data, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_extern_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_extern_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_extern_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_extern_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L3$pb:
; LARGE-PIC-NEXT:    leaq .L3$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L3$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $extern_data@GOT, %rax
; LARGE-PIC-NEXT:    movq (%rcx,%rax), %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_extern_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L3$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L3$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L3$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $extern_data@GOT, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movq (%rcx,%rax), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @extern_data
}

define dso_local ptr @lea_unknown_size_data() #0 {
; SMALL-STATIC-LABEL: lea_unknown_size_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $unknown_size_data, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_unknown_size_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $unknown_size_data, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_unknown_size_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $unknown_size_data, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_unknown_size_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq unknown_size_data(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_unknown_size_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-SMALL-DATA-PIC-NEXT:    movabsq $unknown_size_data@GOTOFF, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_unknown_size_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $unknown_size_data@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_unknown_size_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L4$pb:
; LARGE-PIC-NEXT:    leaq .L4$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L4$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $unknown_size_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_unknown_size_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L4$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L4$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L4$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $unknown_size_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @unknown_size_data
}

define dso_local ptr @lea_forced_small_data() #0 {
; SMALL-STATIC-LABEL: lea_forced_small_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $forced_small_data, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_forced_small_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movl $forced_small_data, %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_forced_small_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $forced_small_data, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_forced_small_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq forced_small_data(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_forced_small_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq forced_small_data(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_forced_small_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq forced_small_data(%rip), %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_forced_small_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L5$pb:
; LARGE-PIC-NEXT:    leaq .L5$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L5$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $forced_small_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_forced_small_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L5$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L5$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L5$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $forced_small_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @forced_small_data
}

define dso_local i32 @load_forced_small_data() #0 {
; SMALL-STATIC-LABEL: load_forced_small_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl forced_small_data+8(%rip), %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: load_forced_small_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movl forced_small_data+8(%rip), %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: load_forced_small_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $forced_small_data+8, %rax
; LARGE-STATIC-NEXT:    movl (%rax), %eax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: load_forced_small_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    movl forced_small_data+8(%rip), %eax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: load_forced_small_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    movl forced_small_data+8(%rip), %eax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: load_forced_small_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    movl forced_small_data+8(%rip), %eax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: load_forced_small_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L6$pb:
; LARGE-PIC-NEXT:    leaq .L6$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L6$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $forced_small_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    movl 8(%rcx,%rax), %eax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: load_forced_small_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L6$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L6$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L6$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $forced_small_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movl 8(%rcx,%rax), %eax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  %rv = load i32, ptr getelementptr inbounds (i32, ptr @forced_small_data, i64 2)
  ret i32 %rv
}

define dso_local ptr @lea_forced_large_data() #0 {
; SMALL-STATIC-LABEL: lea_forced_large_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movabsq $forced_large_data, %rax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_forced_large_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $forced_large_data, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_forced_large_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $forced_large_data, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_forced_large_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; SMALL-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rax
; SMALL-PIC-NEXT:    addq %rcx, %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_forced_large_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-SMALL-DATA-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_forced_large_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_forced_large_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L7$pb:
; LARGE-PIC-NEXT:    leaq .L7$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L7$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_forced_large_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L7$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L7$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L7$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @forced_large_data
}

define dso_local i32 @load_forced_large_data() #0 {
; SMALL-STATIC-LABEL: load_forced_large_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movabsq $forced_large_data+8, %rax
; SMALL-STATIC-NEXT:    movl (%rax), %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: load_forced_large_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $forced_large_data+8, %rax
; MEDIUM-STATIC-NEXT:    movl (%rax), %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: load_forced_large_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $forced_large_data+8, %rax
; LARGE-STATIC-NEXT:    movl (%rax), %eax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: load_forced_large_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; SMALL-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rcx
; SMALL-PIC-NEXT:    movl 8(%rax,%rcx), %eax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: load_forced_large_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rcx
; MEDIUM-SMALL-DATA-PIC-NEXT:    movl 8(%rax,%rcx), %eax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: load_forced_large_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MEDIUM-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rcx
; MEDIUM-PIC-NEXT:    movl 8(%rax,%rcx), %eax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: load_forced_large_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L8$pb:
; LARGE-PIC-NEXT:    leaq .L8$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L8$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    movl 8(%rcx,%rax), %eax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: load_forced_large_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L8$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L8$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L8$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $forced_large_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movl 8(%rcx,%rax), %eax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  %rv = load i32, ptr getelementptr inbounds (i32, ptr @forced_large_data, i64 2)
  ret i32 %rv
}

define dso_local i32 @load_global_data() #0 {
; SMALL-STATIC-LABEL: load_global_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl global_data+8(%rip), %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: load_global_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $global_data+8, %rax
; MEDIUM-STATIC-NEXT:    movl (%rax), %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: load_global_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $global_data+8, %rax
; LARGE-STATIC-NEXT:    movl (%rax), %eax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: load_global_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    movl global_data+8(%rip), %eax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: load_global_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    movl global_data+8(%rip), %eax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: load_global_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MEDIUM-PIC-NEXT:    movabsq $global_data@GOTOFF, %rcx
; MEDIUM-PIC-NEXT:    movl 8(%rax,%rcx), %eax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: load_global_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L9$pb:
; LARGE-PIC-NEXT:    leaq .L9$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L9$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $global_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    movl 8(%rcx,%rax), %eax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: load_global_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L9$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L9$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L9$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $global_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movl 8(%rcx,%rax), %eax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  %rv = load i32, ptr getelementptr inbounds ([10 x i32], ptr @global_data, i64 0, i64 2)
  ret i32 %rv
}

define dso_local i32 @load_extern_data() #0 {
; SMALL-STATIC-LABEL: load_extern_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; SMALL-STATIC-NEXT:    movl 8(%rax), %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: load_extern_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; MEDIUM-STATIC-NEXT:    movl 8(%rax), %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: load_extern_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $extern_data, %rax
; LARGE-STATIC-NEXT:    movl 8(%rax), %eax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: load_extern_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; SMALL-PIC-NEXT:    movl 8(%rax), %eax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: load_extern_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    movl 8(%rax), %eax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: load_extern_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    movq extern_data@GOTPCREL(%rip), %rax
; MEDIUM-PIC-NEXT:    movl 8(%rax), %eax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: load_extern_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L10$pb:
; LARGE-PIC-NEXT:    leaq .L10$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L10$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $extern_data@GOT, %rax
; LARGE-PIC-NEXT:    movq (%rcx,%rax), %rax
; LARGE-PIC-NEXT:    movl 8(%rax), %eax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: load_extern_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L10$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L10$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L10$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $extern_data@GOT, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movq (%rcx,%rax), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movl 8(%rax), %eax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  %rv = load i32, ptr getelementptr inbounds ([10 x i32], ptr @extern_data, i64 0, i64 2)
  ret i32 %rv
}

define dso_local i32 @load_unknown_size_data() #0 {
; SMALL-STATIC-LABEL: load_unknown_size_data:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl unknown_size_data+8(%rip), %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: load_unknown_size_data:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $unknown_size_data+8, %rax
; MEDIUM-STATIC-NEXT:    movl (%rax), %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: load_unknown_size_data:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $unknown_size_data+8, %rax
; LARGE-STATIC-NEXT:    movl (%rax), %eax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: load_unknown_size_data:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    movl unknown_size_data+8(%rip), %eax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: load_unknown_size_data:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    movabsq $unknown_size_data@GOTOFF, %rcx
; MEDIUM-SMALL-DATA-PIC-NEXT:    movl 8(%rax,%rcx), %eax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: load_unknown_size_data:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MEDIUM-PIC-NEXT:    movabsq $unknown_size_data@GOTOFF, %rcx
; MEDIUM-PIC-NEXT:    movl 8(%rax,%rcx), %eax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: load_unknown_size_data:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L11$pb:
; LARGE-PIC-NEXT:    leaq .L11$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L11$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $unknown_size_data@GOTOFF, %rax
; LARGE-PIC-NEXT:    movl 8(%rcx,%rax), %eax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: load_unknown_size_data:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L11$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L11$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L11$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $unknown_size_data@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movl 8(%rcx,%rax), %eax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  %rv = load i32, ptr getelementptr inbounds (i32, ptr @unknown_size_data, i64 2)
  ret i32 %rv
}

define dso_local i1 @load_bool() #0 {
; SMALL-STATIC-LABEL: load_bool:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movzbl bool(%rip), %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: load_bool:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $bool, %rax
; MEDIUM-STATIC-NEXT:    movzbl (%rax), %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: load_bool:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $bool, %rax
; LARGE-STATIC-NEXT:    movzbl (%rax), %eax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: load_bool:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    movzbl bool(%rip), %eax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: load_bool:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    movzbl bool(%rip), %eax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: load_bool:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rax
; MEDIUM-PIC-NEXT:    movabsq $bool@GOTOFF, %rcx
; MEDIUM-PIC-NEXT:    movzbl (%rax,%rcx), %eax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: load_bool:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L12$pb:
; LARGE-PIC-NEXT:    leaq .L12$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L12$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $bool@GOTOFF, %rax
; LARGE-PIC-NEXT:    movzbl (%rcx,%rax), %eax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: load_bool:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L12$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L12$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L12$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $bool@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movzbl (%rcx,%rax), %eax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  %rv = load i1, ptr @bool
  ret i1 %rv
}

define dso_local ptr @lea_opaque() #0 {
; SMALL-STATIC-LABEL: lea_opaque:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $opaque, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_opaque:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $opaque, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_opaque:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $opaque, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_opaque:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq opaque(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_opaque:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-SMALL-DATA-PIC-NEXT:    movabsq $opaque@GOTOFF, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_opaque:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $opaque@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_opaque:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L13$pb:
; LARGE-PIC-NEXT:    leaq .L13$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L13$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $opaque@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_opaque:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L13$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L13$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L13$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $opaque@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @opaque
}

define dso_local ptr @lea_ehdr_start() #0 {
; SMALL-STATIC-LABEL: lea_ehdr_start:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $__ehdr_start, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_ehdr_start:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $__ehdr_start, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_ehdr_start:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $__ehdr_start, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_ehdr_start:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq __ehdr_start(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_ehdr_start:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-SMALL-DATA-PIC-NEXT:    movabsq $__ehdr_start@GOTOFF, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_ehdr_start:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $__ehdr_start@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_ehdr_start:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L14$pb:
; LARGE-PIC-NEXT:    leaq .L14$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L14$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $__ehdr_start@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_ehdr_start:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L14$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L14$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L14$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $__ehdr_start@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @__ehdr_start
}

define dso_local ptr @lea_start_foo() #0 {
; SMALL-STATIC-LABEL: lea_start_foo:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $__start_foo, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_start_foo:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $__start_foo, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_start_foo:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $__start_foo, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_start_foo:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq __start_foo(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_start_foo:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-SMALL-DATA-PIC-NEXT:    movabsq $__start_foo@GOTOFF, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_start_foo:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $__start_foo@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_start_foo:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L15$pb:
; LARGE-PIC-NEXT:    leaq .L15$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L15$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $__start_foo@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_start_foo:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L15$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L15$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L15$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $__start_foo@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @__start_foo
}

define dso_local ptr @lea_stop_foo() #0 {
; SMALL-STATIC-LABEL: lea_stop_foo:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $__stop_foo, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_stop_foo:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movabsq $__stop_foo, %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_stop_foo:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $__stop_foo, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_stop_foo:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq __stop_foo(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_stop_foo:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-SMALL-DATA-PIC-NEXT:    movabsq $__stop_foo@GOTOFF, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_stop_foo:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq _GLOBAL_OFFSET_TABLE_(%rip), %rcx
; MEDIUM-PIC-NEXT:    movabsq $__stop_foo@GOTOFF, %rax
; MEDIUM-PIC-NEXT:    addq %rcx, %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_stop_foo:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L16$pb:
; LARGE-PIC-NEXT:    leaq .L16$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L16$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $__stop_foo@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_stop_foo:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L16$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L16$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L16$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $__stop_foo@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @__stop_foo
}

define dso_local void @global_fn() #0 {
; CHECK-LABEL: global_fn:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  ret void
}

define internal void @static_fn() #0 {
; CHECK-LABEL: static_fn:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  ret void
}

declare void @extern_fn()

@ifunc_func = ifunc void (), ptr @resolver
@dso_local_ifunc_func = dso_local ifunc void (), ptr @resolver

define internal ptr @resolver() {
; CHECK-LABEL: resolver:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
entry:
  ret ptr null
}

define dso_local ptr @lea_static_fn() #0 {
; SMALL-STATIC-LABEL: lea_static_fn:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $static_fn, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_static_fn:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movl $static_fn, %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_static_fn:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $static_fn, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_static_fn:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq static_fn(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_static_fn:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq static_fn(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_static_fn:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq static_fn(%rip), %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_static_fn:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L20$pb:
; LARGE-PIC-NEXT:    leaq .L20$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L20$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $static_fn@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_static_fn:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L20$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L20$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L20$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $static_fn@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @static_fn
}

define dso_local ptr @lea_global_fn() #0 {
; SMALL-STATIC-LABEL: lea_global_fn:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $global_fn, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_global_fn:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movl $global_fn, %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_global_fn:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $global_fn, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_global_fn:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq global_fn(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_global_fn:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq global_fn(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_global_fn:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq global_fn(%rip), %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_global_fn:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L21$pb:
; LARGE-PIC-NEXT:    leaq .L21$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L21$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $global_fn@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_global_fn:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L21$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L21$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L21$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $global_fn@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @global_fn
}

define dso_local ptr @lea_extern_fn() #0 {
; SMALL-STATIC-LABEL: lea_extern_fn:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movq extern_fn@GOTPCREL(%rip), %rax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_extern_fn:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movq extern_fn@GOTPCREL(%rip), %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_extern_fn:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $extern_fn, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_extern_fn:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    movq extern_fn@GOTPCREL(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_extern_fn:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    movq extern_fn@GOTPCREL(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_extern_fn:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    movq extern_fn@GOTPCREL(%rip), %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_extern_fn:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L22$pb:
; LARGE-PIC-NEXT:    leaq .L22$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L22$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $extern_fn@GOT, %rax
; LARGE-PIC-NEXT:    movq (%rcx,%rax), %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_extern_fn:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L22$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L22$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L22$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $extern_fn@GOT, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movq (%rcx,%rax), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @extern_fn
}

define dso_local ptr @lea_ifunc() #0 {
; SMALL-STATIC-LABEL: lea_ifunc:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movq ifunc_func@GOTPCREL(%rip), %rax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_ifunc:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movq ifunc_func@GOTPCREL(%rip), %rax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_ifunc:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $ifunc_func, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_ifunc:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    movq ifunc_func@GOTPCREL(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_ifunc:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    movq ifunc_func@GOTPCREL(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_ifunc:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    movq ifunc_func@GOTPCREL(%rip), %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_ifunc:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L23$pb:
; LARGE-PIC-NEXT:    leaq .L23$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L23$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $ifunc_func@GOT, %rax
; LARGE-PIC-NEXT:    movq (%rcx,%rax), %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_ifunc:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L23$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L23$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L23$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $ifunc_func@GOT, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movq (%rcx,%rax), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @ifunc_func
}

define dso_local ptr @lea_dso_local_ifunc() #0 {
; SMALL-STATIC-LABEL: lea_dso_local_ifunc:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    movl $dso_local_ifunc_func, %eax
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: lea_dso_local_ifunc:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    movl $dso_local_ifunc_func, %eax
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: lea_dso_local_ifunc:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq $dso_local_ifunc_func, %rax
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: lea_dso_local_ifunc:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    leaq dso_local_ifunc_func(%rip), %rax
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: lea_dso_local_ifunc:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    leaq dso_local_ifunc_func(%rip), %rax
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: lea_dso_local_ifunc:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    leaq dso_local_ifunc_func(%rip), %rax
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: lea_dso_local_ifunc:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L24$pb:
; LARGE-PIC-NEXT:    leaq .L24$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L24$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq $dso_local_ifunc_func@GOTOFF, %rax
; LARGE-PIC-NEXT:    addq %rcx, %rax
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: lea_dso_local_ifunc:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L24$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L24$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L24$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $dso_local_ifunc_func@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rcx, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  ret ptr @dso_local_ifunc_func
}

; FIXME: The result is same for small, medium and large model, because we
; specify pie option in the test case. And the type of tls is initial exec tls.
; For pic code. The large model code for pic tls should be emitted as below.

; .L3:
; leaq	.L3(%rip), %rbx
; movabsq	$_GLOBAL_OFFSET_TABLE_-.L3, %r11
; addq	%r11, %rbx
; leaq	thread_data@TLSGD(%rip), %rdi
; movabsq	$__tls_get_addr@PLTOFF, %rax
; addq	%rbx, %rax
; call	*%rax
; movl	(%rax), %eax

; The medium and small model code for pic tls should be emitted as below.
; data16
; leaq	thread_data@TLSGD(%rip), %rdi
; data16
; data16
; rex64
; callq	__tls_get_addr@PLT
; movl	(%rax), %eax

define dso_local i32 @load_thread_data() #0 {
; CHECK-LABEL: load_thread_data:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq thread_data@GOTTPOFF(%rip), %rax
; CHECK-NEXT:    movl %fs:(%rax), %eax
; CHECK-NEXT:    retq
  %1 = load i32, ptr @thread_data, align 4
  ret i32 %1
}

define dso_local float @load_constant_pool(float %x) #0 {
; SMALL-STATIC-LABEL: load_constant_pool:
; SMALL-STATIC:       # %bb.0:
; SMALL-STATIC-NEXT:    addss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SMALL-STATIC-NEXT:    retq
;
; MEDIUM-STATIC-LABEL: load_constant_pool:
; MEDIUM-STATIC:       # %bb.0:
; MEDIUM-STATIC-NEXT:    addss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; MEDIUM-STATIC-NEXT:    retq
;
; LARGE-STATIC-LABEL: load_constant_pool:
; LARGE-STATIC:       # %bb.0:
; LARGE-STATIC-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}, %rax
; LARGE-STATIC-NEXT:    addss (%rax), %xmm0
; LARGE-STATIC-NEXT:    retq
;
; SMALL-PIC-LABEL: load_constant_pool:
; SMALL-PIC:       # %bb.0:
; SMALL-PIC-NEXT:    addss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SMALL-PIC-NEXT:    retq
;
; MEDIUM-SMALL-DATA-PIC-LABEL: load_constant_pool:
; MEDIUM-SMALL-DATA-PIC:       # %bb.0:
; MEDIUM-SMALL-DATA-PIC-NEXT:    addss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; MEDIUM-SMALL-DATA-PIC-NEXT:    retq
;
; MEDIUM-PIC-LABEL: load_constant_pool:
; MEDIUM-PIC:       # %bb.0:
; MEDIUM-PIC-NEXT:    addss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; MEDIUM-PIC-NEXT:    retq
;
; LARGE-PIC-LABEL: load_constant_pool:
; LARGE-PIC:       # %bb.0:
; LARGE-PIC-NEXT:  .L26$pb:
; LARGE-PIC-NEXT:    leaq .L26$pb(%rip), %rax
; LARGE-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L26$pb, %rcx
; LARGE-PIC-NEXT:    addq %rax, %rcx
; LARGE-PIC-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}@GOTOFF, %rax
; LARGE-PIC-NEXT:    addss (%rcx,%rax), %xmm0
; LARGE-PIC-NEXT:    retq
;
; LARGE-SMALL-DATA-PIC-LABEL: load_constant_pool:
; LARGE-SMALL-DATA-PIC:       # %bb.0:
; LARGE-SMALL-DATA-PIC-NEXT:  .L26$pb:
; LARGE-SMALL-DATA-PIC-NEXT:    leaq .L26$pb(%rip), %rax
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq $_GLOBAL_OFFSET_TABLE_-.L26$pb, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    addq %rax, %rcx
; LARGE-SMALL-DATA-PIC-NEXT:    movabsq ${{\.?LCPI[0-9]+_[0-9]+}}@GOTOFF, %rax
; LARGE-SMALL-DATA-PIC-NEXT:    addss (%rcx,%rax), %xmm0
; LARGE-SMALL-DATA-PIC-NEXT:    retq
  %a = fadd float %x, 1.0
  ret float %a
}

attributes #0 = { noinline nounwind uwtable }

!llvm.module.flags = !{!0, !1, !2}
!llvm.ident = !{!3}

!0 = !{i32 1, !"wchar_size", i32 4}
!1 = !{i32 7, !"PIC Level", i32 2}
!2 = !{i32 7, !"PIE Level", i32 2}
!3 = !{!"clang version 7.0.0 "}
