; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

;; Check that the correct ABI is chosen based on the triple given.
;; TODO: enable the S and F ABIs once support is wired up.
; RUN: llc --mtriple=loongarch32-linux-gnuf64 --mattr=+d < %s \
; RUN:   | FileCheck %s --check-prefix=ILP32D
; RUN: llc --mtriple=loongarch64-linux-gnuf64 --mattr=+d < %s \
; RUN:   | FileCheck %s --check-prefix=LP64D

define float @f(float %a) {
; ILP32D-LABEL: f:
; ILP32D:       # %bb.0:
; ILP32D-NEXT:    addi.w $a0, $zero, 1
; ILP32D-NEXT:    movgr2fr.w $fa1, $a0
; ILP32D-NEXT:    ffint.s.w $fa1, $fa1
; ILP32D-NEXT:    fadd.s $fa0, $fa0, $fa1
; ILP32D-NEXT:    ret
;
; LP64D-LABEL: f:
; LP64D:       # %bb.0:
; LP64D-NEXT:    addi.w $a0, $zero, 1
; LP64D-NEXT:    movgr2fr.w $fa1, $a0
; LP64D-NEXT:    ffint.s.w $fa1, $fa1
; LP64D-NEXT:    fadd.s $fa0, $fa0, $fa1
; LP64D-NEXT:    ret
  %1 = fadd float %a, 1.0
  ret float %1
}

define double @g(double %a) {
; ILP32D-LABEL: g:
; ILP32D:       # %bb.0:
; ILP32D-NEXT:    addi.w $a0, $zero, 1
; ILP32D-NEXT:    movgr2fr.w $fa1, $a0
; ILP32D-NEXT:    ffint.s.w $fa1, $fa1
; ILP32D-NEXT:    fcvt.d.s $fa1, $fa1
; ILP32D-NEXT:    fadd.d $fa0, $fa0, $fa1
; ILP32D-NEXT:    ret
;
; LP64D-LABEL: g:
; LP64D:       # %bb.0:
; LP64D-NEXT:    addi.d $a0, $zero, 1
; LP64D-NEXT:    movgr2fr.d $fa1, $a0
; LP64D-NEXT:    ffint.d.l $fa1, $fa1
; LP64D-NEXT:    fadd.d $fa0, $fa0, $fa1
; LP64D-NEXT:    ret
  %1 = fadd double %a, 1.0
  ret double %1
}
