; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=bonaire -amdgpu-atomic-optimizer-strategy=None -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=CI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -amdgpu-atomic-optimizer-strategy=None -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -amdgpu-atomic-optimizer-strategy=None -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -amdgpu-atomic-optimizer-strategy=None -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX12 %s

define amdgpu_kernel void @atomic_add_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_add_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_add_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_add_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_add_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_add_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile add ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_add_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_add_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_add_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_add_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_add_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_add_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile add ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_add_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_add_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_add_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_add_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_add_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_add_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_add_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_add_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile add ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_add_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_add_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_add_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_add_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_add_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_add_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_add_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile add ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_add_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_add_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_add_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_add_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_add_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_add_u64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile add ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_add_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_add_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_add_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_add_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_add_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_add_u64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile add ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_add_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_add_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_add_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_add_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_add_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_add_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_add_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_add_u64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile add ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_add_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_add_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_add_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_add_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_add_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_add_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_add_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_add_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_add_u64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile add ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_and_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_and_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_and_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_and_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_and_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_and_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_and_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_and_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile and ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_and_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_and_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_and_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_and_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_and_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_and_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_and_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_and_b64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile and ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_and_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_and_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_and_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_and_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_and_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_and_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_and_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_and_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile and ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_and_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_and_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_and_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_and_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_and_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_and_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_and_b64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile and ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_and_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_and_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_and_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_and_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_and_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_and_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_and_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_and_b64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile and ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_and_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_and_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_and_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_and_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_and_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_and_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_and_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_and_b64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile and ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_and_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_and_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_and_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_and_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_and_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_and_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_and_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_and_b64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile and ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_and_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_and_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_and_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_and_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_and_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_and_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_and_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_and_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_and_b64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile and ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_sub_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_sub_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_sub_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_sub_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_sub_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile sub ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_sub_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_sub_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_sub_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_sub_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_sub_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile sub ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_sub_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_sub_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_sub_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_sub_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_sub_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_sub_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_sub_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile sub ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_sub_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_sub_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_sub_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_sub_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_sub_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_sub_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile sub ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_sub_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_sub_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_sub_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_sub_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_sub_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_sub_u64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile sub ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_sub_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_sub_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_sub_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_sub_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_sub_u64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile sub ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_sub_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_sub_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_sub_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_sub_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_sub_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_sub_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_sub_u64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile sub ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_sub_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_sub_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_sub_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_sub_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_sub_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_sub_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_sub_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_sub_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_sub_u64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile sub ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_max_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_smax_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_smax_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_smax_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_i64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_max_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_smax_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_smax_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_smax_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_i64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_max_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_smax_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_smax_x2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_smax_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_i64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_max_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_smax_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_smax_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_i64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_max_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_smax_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_smax_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_smax_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_i64 v2, v[0:1], s[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %out, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_max_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_smax_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_smax_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_smax_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_i64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %out, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_max_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_max_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_smax_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_smax_x2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_smax_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_i64 v2, v[0:1], s[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %ptr, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_max_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_max_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_smax_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_max_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_smax_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_max_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_smax_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_max_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_i64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile max ptr addrspace(1) %ptr, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_umax_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_umax_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_umax_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_umax_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_umax_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_umax_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_umax_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_umax_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_umax_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_umax_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_umax_x2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_umax_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_umax_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_umax_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_umax_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_umax_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_umax_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_umax_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_umax_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_u64 v2, v[0:1], s[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %out, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_umax_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_umax_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_umax_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_umax_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_u64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %out, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_umax_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_umax_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_umax_x2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_umax_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_u64 v2, v[0:1], s[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %ptr, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umax_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_umax_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_umax_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umax_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_umax_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umax_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_umax_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umax_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_max_u64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile umax ptr addrspace(1) %ptr, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_min_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_smin_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_smin_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_smin_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_i64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_min_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_smin_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_smin_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_smin_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_i64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_min_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_smin_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_smin_x2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_smin_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_i64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_min_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_smin_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_smin_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_i64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_min_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_smin_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_smin_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_smin_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_i64 v2, v[0:1], s[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %out, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_min_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_smin_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_smin_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_smin_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_i64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %out, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_min_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_min_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_smin_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_smin_x2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_smin_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_i64 v2, v[0:1], s[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %ptr, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_min_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_min_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_smin_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_min_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_smin_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_min_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_smin_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_min_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_i64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile min ptr addrspace(1) %ptr, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_umin_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_umin_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_umin_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_umin_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_umin_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_umin_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_umin_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_umin_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_umin_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_umin_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_umin_x2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_umin_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_umin_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_umin_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_umin_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %gep, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_umin_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_umin_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_umin_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_umin_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_u64 v2, v[0:1], s[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %out, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_umin_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_umin_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_umin_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_umin_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_u64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %out, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_umin_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_umin_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_umin_x2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_umin_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_u64 v2, v[0:1], s[0:1] scope:SCOPE_SE
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %ptr, i64 %in syncscope("workgroup") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_umin_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_umin_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_umin_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_umin_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_umin_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_umin_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_umin_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_umin_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_SE
; GFX12-NEXT:    global_atomic_min_u64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_SE
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SE
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile umin ptr addrspace(1) %ptr, i64 %in syncscope("workgroup") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_or_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_or_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_or_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_or_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_or_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_or_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_or_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_or_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile or ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_or_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_or_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_or_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_or_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_or_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_or_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_or_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_or_b64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile or ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_or_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_or_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_or_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_or_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_or_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_or_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_or_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_or_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile or ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_or_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_or_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_or_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_or_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_or_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_or_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_or_b64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile or ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_or_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_or_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_or_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_or_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_or_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_or_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_or_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_or_b64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile or ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_or_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_or_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_or_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_or_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_or_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_or_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_or_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_or_b64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile or ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_or_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_or_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_or_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_or_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_or_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_or_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_or_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_or_b64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile or ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_or_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_or_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_or_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_or_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_or_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_or_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_or_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_or_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_or_b64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile or ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_xchg_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_swap_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xchg_f64_offset(ptr addrspace(1) %out, double %in) {
; CI-LABEL: atomic_xchg_f64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_f64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_f64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_swap_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_f64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr double, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %gep, double %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xchg_pointer_offset(ptr addrspace(1) %out, ptr %in) {
; CI-LABEL: atomic_xchg_pointer_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_pointer_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_pointer_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_swap_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_pointer_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr ptr, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %gep, ptr %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_xchg_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_swap_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_xchg_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_swap_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_xchg_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_swap_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_xchg_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_swap_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_xchg_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_swap_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_swap_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_xchg_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_swap_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_swap_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xchg_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_xchg_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_swap_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xchg_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_swap_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xchg_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_swap_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xchg_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_swap_b64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile xchg ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_xor_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_xor_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xor_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_xor_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xor_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_xor_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_xor_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile xor ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_xor_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_xor_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xor_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_xor_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xor_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_xor_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_xor_b64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile xor ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_xor_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_xor_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xor_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_xor_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xor_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_xor_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_xor_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile xor ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_xor_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_xor_x2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xor_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xor_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_xor_x2 v[0:1], v2, v[0:1], s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_xor_b64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile xor ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_xor_i64(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_xor_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    buffer_atomic_xor_x2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xor_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    buffer_atomic_xor_x2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xor_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_xor_x2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_xor_b64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile xor ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_xor_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s4
; CI-NEXT:    s_mov_b32 s1, s5
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_atomic_xor_x2 v[0:1], off, s[0:3], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xor_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s4
; VI-NEXT:    s_mov_b32 s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    buffer_atomic_xor_x2 v[0:1], off, s[0:3], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xor_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_xor_x2 v[0:1], v2, v[0:1], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_xor_b64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %tmp0 = atomicrmw volatile xor ptr addrspace(1) %out, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_xor_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_xor_x2 v[0:1], v[2:3], s[4:7], 0 addr64
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xor_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_xor_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xor_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_xor_x2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_xor_b64 v2, v[0:1], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile xor ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_xor_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index) {
; CI-LABEL: atomic_xor_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_atomic_xor_x2 v[0:1], v[2:3], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_xor_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_xor_x2 v[0:1], v[2:3], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_xor_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_xor_x2 v[0:1], v2, v[0:1], s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_xor_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[6:7], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_xor_b64 v[0:1], v2, v[0:1], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %tmp0 = atomicrmw volatile xor ptr addrspace(1) %ptr, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_offset(ptr addrspace(1) %out, i64 %in, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s8, s4
; CI-NEXT:    s_mov_b32 s9, s5
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[8:11], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s4
; VI-NEXT:    s_mov_b32 s9, s5
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[8:11], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    global_atomic_cmpswap_x2 v4, v[0:3], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v3, s1
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v4, v[0:3], s[4:5] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %val = cmpxchg volatile ptr addrspace(1) %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_soffset(ptr addrspace(1) %out, i64 %in, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64_soffset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_mov_b32 s2, 0x11940
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s8, s4
; CI-NEXT:    s_mov_b32 s9, s5
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[8:11], s2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64_soffset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_mov_b32 s2, 0x11940
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s4
; VI-NEXT:    s_mov_b32 s9, s5
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[8:11], s2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64_soffset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x11000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    global_atomic_cmpswap_x2 v4, v[0:3], s[4:5] offset:2368
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_soffset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v3, s1
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v4, v[0:3], s[4:5] offset:72000 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 9000
  %val = cmpxchg volatile ptr addrspace(1) %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    s_mov_b32 s2, s10
; CI-NEXT:    s_mov_b32 s3, s11
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    s_mov_b32 s2, s10
; VI-NEXT:    s_mov_b32 s3, s11
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[0:3], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v4, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %val = cmpxchg volatile ptr addrspace(1) %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  %extract0 = extractvalue { i64, i1 } %val, 0
  store i64 %extract0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_addr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    s_mov_b64 s[8:9], s[0:1]
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:    v_mov_b32_e32 v5, s5
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[4:5], s[8:11], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[8:9], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    global_atomic_cmpswap_x2 v4, v[0:3], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[2:3]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v4, v[0:3], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %val = cmpxchg volatile ptr addrspace(1) %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_ret_addr64_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64_ret_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x11
; CI-NEXT:    s_mov_b32 s15, 0xf000
; CI-NEXT:    s_mov_b32 s14, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[2:3], s[10:11], 3
; CI-NEXT:    v_mov_b32_e32 v5, s3
; CI-NEXT:    s_mov_b32 s12, s6
; CI-NEXT:    s_mov_b32 s13, s7
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    s_mov_b32 s7, s15
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[4:5], s[4:7], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[12:15], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64_ret_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x44
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[2:3], s[10:11], 3
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    s_add_u32 s0, s4, s2
; VI-NEXT:    s_addc_u32 s3, s5, s3
; VI-NEXT:    s_add_u32 s2, s0, 32
; VI-NEXT:    s_addc_u32 s3, s3, 0
; VI-NEXT:    v_mov_b32_e32 v5, s3
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64_ret_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x44
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[2:3], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s2, s4, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s3, s5, s3
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[2:3] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_ret_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b256 s[4:11], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x44
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s9
; GFX12-NEXT:    v_dual_mov_b32 v0, s8 :: v_dual_mov_b32 v3, s1
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v4, v[0:1], s[6:7]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %val = cmpxchg volatile ptr addrspace(1) %gep, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  %extract0 = extractvalue { i64, i1 } %val, 0
  store i64 %extract0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64(ptr addrspace(1) %out, i64 %in, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s8, s4
; CI-NEXT:    s_mov_b32 s9, s5
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[8:11], 0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s4
; VI-NEXT:    s_mov_b32 s9, s5
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[8:11], 0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    global_atomic_cmpswap_x2 v4, v[0:3], s[4:5]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v3, s1
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v4, v[0:3], s[4:5] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %val = cmpxchg volatile ptr addrspace(1) %out, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_ret(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64_ret:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s8, s0
; CI-NEXT:    s_mov_b32 s9, s1
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[8:11], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_mov_b32 s8, s2
; CI-NEXT:    s_mov_b32 s9, s3
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64_ret:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s11, 0xf000
; VI-NEXT:    s_mov_b32 s10, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s8, s0
; VI-NEXT:    s_mov_b32 s9, s1
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], off, s[8:11], 0 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s8, s2
; VI-NEXT:    s_mov_b32 s9, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64_ret:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_ret:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v4, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %val = cmpxchg volatile ptr addrspace(1) %out, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  %extract0 = extractvalue { i64, i1 } %val, 0
  store i64 %extract0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_addr64(ptr addrspace(1) %out, i64 %in, i64 %index, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b64 s[8:9], s[0:1]
; CI-NEXT:    s_lshl_b64 s[0:1], s[4:5], 3
; CI-NEXT:    v_mov_b32_e32 v5, s1
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_mov_b32_e32 v2, s6
; CI-NEXT:    v_mov_b32_e32 v3, s7
; CI-NEXT:    v_mov_b32_e32 v4, s0
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[4:5], s[8:11], 0 addr64
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    v_mov_b32_e32 v3, s7
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:3]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[8:9], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s11
; GFX9-NEXT:    global_atomic_cmpswap_x2 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b256 s[0:7], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v3, s7
; GFX12-NEXT:    v_mov_b32_e32 v2, s6
; GFX12-NEXT:    s_lshl_b64 s[2:3], s[4:5], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[2:3]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v4, v[0:3], s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %val = cmpxchg volatile ptr addrspace(1) %ptr, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  ret void
}

define amdgpu_kernel void @atomic_cmpxchg_i64_ret_addr64(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in, i64 %index, i64 %old) {
; CI-LABEL: atomic_cmpxchg_i64_ret_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x11
; CI-NEXT:    s_mov_b32 s15, 0xf000
; CI-NEXT:    s_mov_b32 s14, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b64 s[2:3], s[10:11], 3
; CI-NEXT:    v_mov_b32_e32 v5, s3
; CI-NEXT:    s_mov_b32 s12, s6
; CI-NEXT:    s_mov_b32 s13, s7
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    s_mov_b32 s7, s15
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[4:5], s[4:7], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[12:15], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_cmpxchg_i64_ret_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x44
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[2:3], s[10:11], 3
; VI-NEXT:    s_add_u32 s2, s4, s2
; VI-NEXT:    s_addc_u32 s3, s5, s3
; VI-NEXT:    v_mov_b32_e32 v5, s3
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[0:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_cmpxchg_i64_ret_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx8 s[4:11], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x44
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[2:3], s[10:11], 3
; GFX9-NEXT:    s_add_u32 s2, s4, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    v_mov_b32_e32 v1, s9
; GFX9-NEXT:    s_addc_u32 s3, s5, s3
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    global_atomic_cmpswap_x2 v[0:1], v4, v[0:3], s[2:3] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_cmpxchg_i64_ret_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b256 s[4:11], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x44
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v1, s9
; GFX12-NEXT:    v_dual_mov_b32 v0, s8 :: v_dual_mov_b32 v3, s1
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[10:11], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[0:1], v4, v[0:3], s[0:1] th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v4, v[0:1], s[6:7]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %val = cmpxchg volatile ptr addrspace(1) %ptr, i64 %old, i64 %in syncscope("agent") seq_cst seq_cst
  %extract0 = extractvalue { i64, i1 } %val, 0
  store i64 %extract0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_load_i64_offset(ptr addrspace(1) %in, ptr addrspace(1) %out) {
; CI-LABEL: atomic_load_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    s_mov_b32 s2, s6
; CI-NEXT:    s_mov_b32 s3, s7
; CI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[0:3], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_load_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_load_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %in, i64 4
  %val = load atomic i64, ptr addrspace(1) %gep  seq_cst, align 8
  store i64 %val, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @atomic_load_i64_neg_offset(ptr addrspace(1) %in, ptr addrspace(1) %out) {
; CI-LABEL: atomic_load_i64_neg_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    v_not_b32_e32 v0, 31
; CI-NEXT:    v_mov_b32_e32 v1, -1
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_mov_b32 s3, s7
; CI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[0:3], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_load_i64_neg_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_add_u32 s0, s0, 0xffffffe0
; VI-NEXT:    s_addc_u32 s1, s1, -1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_load_i64_neg_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[4:5] offset:-32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64_neg_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1] offset:-32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %in, i64 -4
  %val = load atomic i64, ptr addrspace(1) %gep  seq_cst, align 8
  store i64 %val, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @atomic_load_i64(ptr addrspace(1) %in, ptr addrspace(1) %out) {
; CI-LABEL: atomic_load_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s4, s0
; CI-NEXT:    s_mov_b32 s5, s1
; CI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[4:7], 0 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_load_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_load_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[4:5] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1] scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %val = load atomic i64, ptr addrspace(1) %in syncscope("agent") seq_cst, align 8
  store i64 %val, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @atomic_load_i64_addr64_offset(ptr addrspace(1) %in, ptr addrspace(1) %out, i64 %index) {
; CI-LABEL: atomic_load_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_lshl_b64 s[8:9], s[8:9], 3
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_load_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_load_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %in, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %val = load atomic i64, ptr addrspace(1) %gep seq_cst, align 8
  store i64 %val, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @atomic_load_i64_addr64(ptr addrspace(1) %in, ptr addrspace(1) %out, i64 %index) {
; CI-LABEL: atomic_load_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s8, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    s_mov_b32 s9, s7
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    s_mov_b32 s7, s11
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[8:11], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_load_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_load_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1] glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1] scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %in, i64 %index
  %val = load atomic i64, ptr addrspace(1) %ptr seq_cst, align 8
  store i64 %val, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @atomic_load_f64_addr64_offset(ptr addrspace(1) %in, ptr addrspace(1) %out, i64 %index) {
; CI-LABEL: atomic_load_f64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_lshl_b64 s[8:9], s[8:9], 3
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_load_f64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; VI-NEXT:    s_add_u32 s0, s0, s4
; VI-NEXT:    s_addc_u32 s1, s1, s5
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_mov_b32 s4, s2
; VI-NEXT:    s_mov_b32 s5, s3
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_load_f64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_load_f64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b64 s[4:5], s[4:5], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[0:1], s[4:5]
; GFX12-NEXT:    global_load_b64 v[0:1], v2, s[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr double, ptr addrspace(1) %in, i64 %index
  %gep = getelementptr double, ptr addrspace(1) %ptr, i64 4
  %val = load atomic double, ptr addrspace(1) %gep seq_cst, align 8
  store double %val, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @atomic_store_i64_offset(i64 %in, ptr addrspace(1) %out) {
; CI-LABEL: atomic_store_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_store_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_add_u32 s0, s2, 32
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_addc_u32 s1, s3, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_store_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  store atomic i64 %in, ptr addrspace(1) %gep  seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_store_i64(i64 %in, ptr addrspace(1) %out) {
; CI-LABEL: atomic_store_i64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_mov_b32 s4, s2
; CI-NEXT:    s_mov_b32 s5, s3
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_store_i64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_store_i64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3] scope:SCOPE_SYS
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  store atomic i64 %in, ptr addrspace(1) %out seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_store_i64_addr64_offset(i64 %in, ptr addrspace(1) %out, i64 %index) {
; CI-LABEL: atomic_store_i64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b64 s[0:1], s[6:7]
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_store_dwordx2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_store_i64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s6, s0
; VI-NEXT:    s_addc_u32 s1, s7, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_store_i64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_i64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[6:7], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  store atomic i64 %in, ptr addrspace(1) %gep seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_store_i64_addr64(i64 %in, ptr addrspace(1) %out, i64 %index) {
; CI-LABEL: atomic_store_i64_addr64:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s11, 0xf000
; CI-NEXT:    s_mov_b32 s10, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_mov_b64 s[8:9], s[6:7]
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_store_dwordx2 v[0:1], v[2:3], s[8:11], 0 addr64
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_store_i64_addr64:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s6, s0
; VI-NEXT:    s_addc_u32 s1, s7, s1
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_store_i64_addr64:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_i64_addr64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[6:7], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1] scope:SCOPE_SYS
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  store atomic i64 %in, ptr addrspace(1) %ptr seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_store_f64_addr64_offset(double %in, ptr addrspace(1) %out, i64 %index) {
; CI-LABEL: atomic_store_f64_addr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s4
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    s_lshl_b64 s[4:5], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    s_mov_b64 s[0:1], s[6:7]
; CI-NEXT:    v_mov_b32_e32 v3, s5
; CI-NEXT:    buffer_store_dwordx2 v[0:1], v[2:3], s[0:3], 0 addr64 offset:32
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_store_f64_addr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s6, s0
; VI-NEXT:    s_addc_u32 s1, s7, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_store_f64_addr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s6, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_addc_u32 s1, s7, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_store_f64_addr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[6:7], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_SYS
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr double, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr double, ptr addrspace(1) %ptr, i64 4
  store atomic double %in, ptr addrspace(1) %gep seq_cst, align 8
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_inc_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_inc_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_inc_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_inc_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_inc_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_inc_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_inc_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile uinc_wrap ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_inc_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_inc_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_inc_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_inc_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_inc_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_inc_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_inc_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile uinc_wrap ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_inc_i64_incr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_inc_i64_incr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_inc_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_inc_i64_incr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_inc_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_inc_i64_incr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_inc_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_inc_i64_incr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_inc_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile uinc_wrap ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_offset(ptr addrspace(1) %out, i64 %in) {
; CI-LABEL: atomic_dec_i64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x9
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    buffer_atomic_dec_x2 v[0:1], off, s[0:3], 0 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_dec_i64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    buffer_atomic_dec_x2 v[0:1], off, s[0:3], 0 offset:32
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_dec_i64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    global_atomic_dec_x2 v2, v[0:1], s[4:5] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX12-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_dec_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile udec_wrap ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_ret_offset(ptr addrspace(1) %out, ptr addrspace(1) %out2, i64 %in) {
; CI-LABEL: atomic_dec_i64_ret_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0xd
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_mov_b32 s0, s6
; CI-NEXT:    s_mov_b32 s1, s7
; CI-NEXT:    v_mov_b32_e32 v0, s8
; CI-NEXT:    v_mov_b32_e32 v1, s9
; CI-NEXT:    s_mov_b32 s6, s2
; CI-NEXT:    s_mov_b32 s7, s3
; CI-NEXT:    buffer_atomic_dec_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_dec_i64_ret_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x34
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_mov_b32 s0, s6
; VI-NEXT:    s_mov_b32 s1, s7
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    s_mov_b32 s6, s2
; VI-NEXT:    s_mov_b32 s7, s3
; VI-NEXT:    buffer_atomic_dec_x2 v[0:1], off, s[4:7], 0 offset:32 glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_dec_i64_ret_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_atomic_dec_x2 v[0:1], v2, v[0:1], s[4:5] offset:32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[6:7]
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_ret_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b64 s[4:5], s[2:3], 0x34
; GFX12-NEXT:    s_load_b128 s[0:3], s[2:3], 0x24
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s5
; GFX12-NEXT:    v_mov_b32_e32 v0, s4
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_dec_u64 v[0:1], v2, v[0:1], s[0:1] offset:32 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
entry:
  %gep = getelementptr i64, ptr addrspace(1) %out, i64 4
  %tmp0 = atomicrmw volatile udec_wrap ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  store i64 %tmp0, ptr addrspace(1) %out2
  ret void
}

define amdgpu_kernel void @atomic_dec_i64_decr64_offset(ptr addrspace(1) %out, i64 %in, i64 %index) {
; CI-LABEL: atomic_dec_i64_decr64_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x9
; CI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0xd
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s6
; CI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v1, s7
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, 0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    buffer_atomic_dec_x2 v[0:1], v[2:3], s[4:7], 0 addr64 offset:32
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    buffer_wbinvl1_vol
; CI-NEXT:    s_endpgm
;
; VI-LABEL: atomic_dec_i64_decr64_offset:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; VI-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s6
; VI-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; VI-NEXT:    s_add_u32 s0, s4, s0
; VI-NEXT:    s_addc_u32 s1, s5, s1
; VI-NEXT:    s_add_u32 s0, s0, 32
; VI-NEXT:    s_addc_u32 s1, s1, 0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s7
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_atomic_dec_x2 v[2:3], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    buffer_wbinvl1_vol
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: atomic_dec_i64_decr64_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x34
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX9-NEXT:    s_add_u32 s0, s4, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_addc_u32 s1, s5, s1
; GFX9-NEXT:    global_atomic_dec_x2 v2, v[0:1], s[0:1] offset:32
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:    s_endpgm
;
; GFX12-LABEL: atomic_dec_i64_decr64_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_clause 0x1
; GFX12-NEXT:    s_load_b128 s[4:7], s[2:3], 0x24
; GFX12-NEXT:    s_load_b64 s[0:1], s[2:3], 0x34
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX12-NEXT:    s_lshl_b64 s[0:1], s[0:1], 3
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_nc_u64 s[0:1], s[4:5], s[0:1]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    global_atomic_dec_u64 v2, v[0:1], s[0:1] offset:32 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_endpgm
entry:
  %ptr = getelementptr i64, ptr addrspace(1) %out, i64 %index
  %gep = getelementptr i64, ptr addrspace(1) %ptr, i64 4
  %tmp0 = atomicrmw volatile udec_wrap ptr addrspace(1) %gep, i64 %in syncscope("agent") seq_cst
  ret void
}
