/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.ThreadBarrier;
import junit.framework.Test;
import junit.framework.TestResult;

public class ThreadedTest
implements Test {
    private final Test test;
    private final ThreadGroup group;
    private final ThreadBarrier barrier;

    public ThreadedTest(Test test) {
        this(test, null, new ThreadBarrier(1));
    }

    public ThreadedTest(Test test, ThreadGroup group, ThreadBarrier barrier) {
        this.test = test;
        this.group = group;
        this.barrier = barrier;
    }

    public int countTestCases() {
        return this.test.countTestCases();
    }

    public void run(TestResult result) {
        Thread t = new Thread(this.group, new TestRunner(result));
        t.start();
    }

    public String toString() {
        return "ThreadedTest: " + this.test.toString();
    }

    class TestRunner
    implements Runnable {
        private TestResult result;

        public TestRunner(TestResult result) {
            this.result = result;
        }

        public void run() {
            ThreadedTest.this.test.run(this.result);
            ThreadedTest.this.barrier.onCompletion(Thread.currentThread());
        }
    }
}

