# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._source_control_configuration_client_enums import *


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class ClusterScopeSettings(ProxyResource):
    """Extension scope settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param allow_multiple_instances: Describes if multiple instances of the extension are allowed.
    :type allow_multiple_instances: bool
    :param default_release_namespace: Default extension release namespace.
    :type default_release_namespace: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'allow_multiple_instances': {'key': 'properties.allowMultipleInstances', 'type': 'bool'},
        'default_release_namespace': {'key': 'properties.defaultReleaseNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        allow_multiple_instances: Optional[bool] = None,
        default_release_namespace: Optional[str] = None,
        **kwargs
    ):
        super(ClusterScopeSettings, self).__init__(**kwargs)
        self.allow_multiple_instances = allow_multiple_instances
        self.default_release_namespace = default_release_namespace


class ComplianceStatus(msrest.serialization.Model):
    """Compliance Status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_state: The compliance state of the configuration. Possible values include:
     "Pending", "Compliant", "Noncompliant", "Installed", "Failed".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ComplianceStateType
    :param last_config_applied: Datetime the configuration was last applied.
    :type last_config_applied: ~datetime.datetime
    :param message: Message from when the configuration was applied.
    :type message: str
    :param message_level: Level of the message. Possible values include: "Error", "Warning",
     "Information".
    :type message_level: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.MessageLevelType
    """

    _validation = {
        'compliance_state': {'readonly': True},
    }

    _attribute_map = {
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'last_config_applied': {'key': 'lastConfigApplied', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'message_level': {'key': 'messageLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_config_applied: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        message_level: Optional[Union[str, "MessageLevelType"]] = None,
        **kwargs
    ):
        super(ComplianceStatus, self).__init__(**kwargs)
        self.compliance_state = None
        self.last_config_applied = last_config_applied
        self.message = message
        self.message_level = message_level


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details:
     list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class Extension(ProxyResource):
    """The Extension object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param identity: Identity of the Extension resource.
    :type identity: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.Identity
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.SystemData
    :param extension_type: Type of the Extension, of which this resource is an instance of.  It
     must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
     Extension publisher.
    :type extension_type: str
    :param auto_upgrade_minor_version: Flag to note if this extension participates in auto upgrade
     of minor version, or not.
    :type auto_upgrade_minor_version: bool
    :param release_train: ReleaseTrain this extension participates in for auto-upgrade (e.g.
     Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :type release_train: str
    :param version: Version of the extension for this extension, if it is 'pinned' to a specific
     version. autoUpgradeMinorVersion must be 'false'.
    :type version: str
    :param scope: Scope at which the extension is installed.
    :type scope: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.Scope
    :param configuration_settings: Configuration settings, as name-value pairs for configuring this
     extension.
    :type configuration_settings: dict[str, str]
    :param configuration_protected_settings: Configuration settings that are sensitive, as
     name-value pairs for configuring this extension.
    :type configuration_protected_settings: dict[str, str]
    :ivar provisioning_state: Status of installation of this extension. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ProvisioningState
    :param statuses: Status from this extension.
    :type statuses:
     list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ExtensionStatus]
    :ivar error_info: Error information from the Agent - e.g. errors during installation.
    :vartype error_info: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ErrorDetail
    :ivar custom_location_settings: Custom Location settings properties.
    :vartype custom_location_settings: dict[str, str]
    :ivar package_uri: Uri of the Helm package.
    :vartype package_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'error_info': {'readonly': True},
        'custom_location_settings': {'readonly': True},
        'package_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'extension_type': {'key': 'properties.extensionType', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'release_train': {'key': 'properties.releaseTrain', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'Scope'},
        'configuration_settings': {'key': 'properties.configurationSettings', 'type': '{str}'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ExtensionStatus]'},
        'error_info': {'key': 'properties.errorInfo', 'type': 'ErrorDetail'},
        'custom_location_settings': {'key': 'properties.customLocationSettings', 'type': '{str}'},
        'package_uri': {'key': 'properties.packageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["Identity"] = None,
        extension_type: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = True,
        release_train: Optional[str] = "Stable",
        version: Optional[str] = None,
        scope: Optional["Scope"] = None,
        configuration_settings: Optional[Dict[str, str]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        statuses: Optional[List["ExtensionStatus"]] = None,
        **kwargs
    ):
        super(Extension, self).__init__(**kwargs)
        self.identity = identity
        self.system_data = None
        self.extension_type = extension_type
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version
        self.scope = scope
        self.configuration_settings = configuration_settings
        self.configuration_protected_settings = configuration_protected_settings
        self.provisioning_state = None
        self.statuses = statuses
        self.error_info = None
        self.custom_location_settings = None
        self.package_uri = None


class ExtensionsList(msrest.serialization.Model):
    """Result of the request to list Extensions.  It contains a list of Extension objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Extensions within a Kubernetes cluster.
    :vartype value: list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.Extension]
    :ivar next_link: URL to get the next set of extension objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Extension]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtensionsList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExtensionStatus(msrest.serialization.Model):
    """Status from the extension.

    :param code: Status code provided by the Extension.
    :type code: str
    :param display_status: Short description of status of the extension.
    :type display_status: str
    :param level: Level of the status. Possible values include: "Error", "Warning", "Information".
     Default value: "Information".
    :type level: str or ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.LevelType
    :param message: Detailed message of the status from the Extension.
    :type message: str
    :param time: DateLiteral (per ISO8601) noting the time of installation status.
    :type time: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        level: Optional[Union[str, "LevelType"]] = "Information",
        message: Optional[str] = None,
        time: Optional[str] = None,
        **kwargs
    ):
        super(ExtensionStatus, self).__init__(**kwargs)
        self.code = code
        self.display_status = display_status
        self.level = level
        self.message = message
        self.time = time


class ExtensionType(msrest.serialization.Model):
    """Represents an Extension Type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.SystemData
    :ivar release_trains: Extension release train: preview or stable.
    :vartype release_trains: list[str]
    :ivar cluster_types: Cluster types. Possible values include: "connectedClusters",
     "managedClusters".
    :vartype cluster_types: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ClusterTypes
    :ivar supported_scopes: Extension scopes.
    :vartype supported_scopes:
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.SupportedScopes
    """

    _validation = {
        'system_data': {'readonly': True},
        'release_trains': {'readonly': True},
        'cluster_types': {'readonly': True},
        'supported_scopes': {'readonly': True},
    }

    _attribute_map = {
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'release_trains': {'key': 'properties.releaseTrains', 'type': '[str]'},
        'cluster_types': {'key': 'properties.clusterTypes', 'type': 'str'},
        'supported_scopes': {'key': 'properties.supportedScopes', 'type': 'SupportedScopes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtensionType, self).__init__(**kwargs)
        self.system_data = None
        self.release_trains = None
        self.cluster_types = None
        self.supported_scopes = None


class ExtensionTypeList(msrest.serialization.Model):
    """List Extension Types.

    :param value: The list of Extension Types.
    :type value: list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ExtensionType]
    :param next_link: The link to fetch the next page of Extension Types.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExtensionType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExtensionType"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExtensionTypeList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExtensionVersionList(msrest.serialization.Model):
    """List versions for an Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param versions: Versions available for this Extension Type.
    :type versions:
     list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ExtensionVersionListVersionsItem]
    :param next_link: The link to fetch the next page of Extension Types.
    :type next_link: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.SystemData
    """

    _validation = {
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'versions': {'key': 'versions', 'type': '[ExtensionVersionListVersionsItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        versions: Optional[List["ExtensionVersionListVersionsItem"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ExtensionVersionList, self).__init__(**kwargs)
        self.versions = versions
        self.next_link = next_link
        self.system_data = None


class ExtensionVersionListVersionsItem(msrest.serialization.Model):
    """ExtensionVersionListVersionsItem.

    :param release_train: The release train for this Extension Type.
    :type release_train: str
    :param versions: Versions available for this Extension Type and release train.
    :type versions: list[str]
    """

    _attribute_map = {
        'release_train': {'key': 'releaseTrain', 'type': 'str'},
        'versions': {'key': 'versions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        release_train: Optional[str] = None,
        versions: Optional[List[str]] = None,
        **kwargs
    ):
        super(ExtensionVersionListVersionsItem, self).__init__(**kwargs)
        self.release_train = release_train
        self.versions = versions


class HelmOperatorProperties(msrest.serialization.Model):
    """Properties for Helm operator.

    :param chart_version: Version of the operator Helm chart.
    :type chart_version: str
    :param chart_values: Values override for the operator Helm chart.
    :type chart_values: str
    """

    _attribute_map = {
        'chart_version': {'key': 'chartVersion', 'type': 'str'},
        'chart_values': {'key': 'chartValues', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        chart_version: Optional[str] = None,
        chart_values: Optional[str] = None,
        **kwargs
    ):
        super(HelmOperatorProperties, self).__init__(**kwargs)
        self.chart_version = chart_version
        self.chart_values = chart_values


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class OperationStatusList(msrest.serialization.Model):
    """The async operations in progress, in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of async operations in progress, in the cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.OperationStatusResult]
    :ivar next_link: URL to get the next set of Operation Result objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationStatusResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationStatusList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatusResult(msrest.serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Fully qualified ID for the async operation.
    :type id: str
    :param name: Name of the async operation.
    :type name: str
    :param status: Required. Operation status.
    :type status: str
    :param properties: Additional information, if available.
    :type properties: dict[str, str]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ErrorDetail
    """

    _validation = {
        'status': {'required': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,
        name: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(OperationStatusResult, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = None


class ResourceProviderOperation(msrest.serialization.Model):
    """Supported operation of this resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Operation name, in format of {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display:
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ResourceProviderOperationDisplay
    :param origin: The intended executor of the operation;governs the display of the operation in
     the RBAC UX and the audit logs UX.
    :type origin: str
    :ivar is_data_action: The flag that indicates whether the operation applies to data plane.
    :vartype is_data_action: bool
    """

    _validation = {
        'is_data_action': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ResourceProviderOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["ResourceProviderOperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs
    ):
        super(ResourceProviderOperation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.is_data_action = None


class ResourceProviderOperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Resource provider: Microsoft KubernetesConfiguration.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of this operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ResourceProviderOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceProviderOperationList(msrest.serialization.Model):
    """Result of the request to list operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by this resource provider.
    :type value:
     list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ResourceProviderOperation]
    :ivar next_link: URL to the next set of results, if any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceProviderOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ResourceProviderOperation"]] = None,
        **kwargs
    ):
        super(ResourceProviderOperationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Scope(msrest.serialization.Model):
    """Scope of the extension. It can be either Cluster or Namespace; but not both.

    :param cluster: Specifies that the scope of the extension is Cluster.
    :type cluster: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ScopeCluster
    :param namespace: Specifies that the scope of the extension is Namespace.
    :type namespace: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ScopeNamespace
    """

    _attribute_map = {
        'cluster': {'key': 'cluster', 'type': 'ScopeCluster'},
        'namespace': {'key': 'namespace', 'type': 'ScopeNamespace'},
    }

    def __init__(
        self,
        *,
        cluster: Optional["ScopeCluster"] = None,
        namespace: Optional["ScopeNamespace"] = None,
        **kwargs
    ):
        super(Scope, self).__init__(**kwargs)
        self.cluster = cluster
        self.namespace = namespace


class ScopeCluster(msrest.serialization.Model):
    """Specifies that the scope of the extension is Cluster.

    :param release_namespace: Namespace where the extension Release must be placed, for a Cluster
     scoped extension.  If this namespace does not exist, it will be created.
    :type release_namespace: str
    """

    _attribute_map = {
        'release_namespace': {'key': 'releaseNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        release_namespace: Optional[str] = None,
        **kwargs
    ):
        super(ScopeCluster, self).__init__(**kwargs)
        self.release_namespace = release_namespace


class ScopeNamespace(msrest.serialization.Model):
    """Specifies that the scope of the extension is Namespace.

    :param target_namespace: Namespace where the extension will be created for an Namespace scoped
     extension.  If this namespace does not exist, it will be created.
    :type target_namespace: str
    """

    _attribute_map = {
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_namespace: Optional[str] = None,
        **kwargs
    ):
        super(ScopeNamespace, self).__init__(**kwargs)
        self.target_namespace = target_namespace


class SourceControlConfiguration(ProxyResource):
    """The SourceControl Configuration object returned in Get & Put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.SystemData
    :param repository_url: Url of the SourceControl Repository.
    :type repository_url: str
    :param operator_namespace: The namespace to which this operator is installed to. Maximum of 253
     lower case alphanumeric characters, hyphen and period only.
    :type operator_namespace: str
    :param operator_instance_name: Instance name of the operator - identifying the specific
     configuration.
    :type operator_instance_name: str
    :param operator_type: Type of the operator. Possible values include: "Flux".
    :type operator_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.OperatorType
    :param operator_params: Any Parameters for the Operator instance in string format.
    :type operator_params: str
    :param configuration_protected_settings: Name-value pairs of protected configuration settings
     for the configuration.
    :type configuration_protected_settings: dict[str, str]
    :param operator_scope: Scope at which the operator will be installed. Possible values include:
     "cluster", "namespace". Default value: "cluster".
    :type operator_scope: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.OperatorScopeType
    :ivar repository_public_key: Public Key associated with this SourceControl configuration
     (either generated within the cluster or provided by the user).
    :vartype repository_public_key: str
    :param ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH keys
     required to access private Git instances.
    :type ssh_known_hosts_contents: str
    :param enable_helm_operator: Option to enable Helm Operator for this git configuration.
    :type enable_helm_operator: bool
    :param helm_operator_properties: Properties for Helm operator.
    :type helm_operator_properties:
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.HelmOperatorProperties
    :ivar provisioning_state: The provisioning state of the resource provider. Possible values
     include: "Accepted", "Deleting", "Running", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ProvisioningStateType
    :ivar compliance_status: Compliance Status of the Configuration.
    :vartype compliance_status:
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ComplianceStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'repository_public_key': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'compliance_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'operator_namespace': {'key': 'properties.operatorNamespace', 'type': 'str'},
        'operator_instance_name': {'key': 'properties.operatorInstanceName', 'type': 'str'},
        'operator_type': {'key': 'properties.operatorType', 'type': 'str'},
        'operator_params': {'key': 'properties.operatorParams', 'type': 'str'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
        'operator_scope': {'key': 'properties.operatorScope', 'type': 'str'},
        'repository_public_key': {'key': 'properties.repositoryPublicKey', 'type': 'str'},
        'ssh_known_hosts_contents': {'key': 'properties.sshKnownHostsContents', 'type': 'str'},
        'enable_helm_operator': {'key': 'properties.enableHelmOperator', 'type': 'bool'},
        'helm_operator_properties': {'key': 'properties.helmOperatorProperties', 'type': 'HelmOperatorProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'compliance_status': {'key': 'properties.complianceStatus', 'type': 'ComplianceStatus'},
    }

    def __init__(
        self,
        *,
        repository_url: Optional[str] = None,
        operator_namespace: Optional[str] = "default",
        operator_instance_name: Optional[str] = None,
        operator_type: Optional[Union[str, "OperatorType"]] = None,
        operator_params: Optional[str] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        operator_scope: Optional[Union[str, "OperatorScopeType"]] = "cluster",
        ssh_known_hosts_contents: Optional[str] = None,
        enable_helm_operator: Optional[bool] = None,
        helm_operator_properties: Optional["HelmOperatorProperties"] = None,
        **kwargs
    ):
        super(SourceControlConfiguration, self).__init__(**kwargs)
        self.system_data = None
        self.repository_url = repository_url
        self.operator_namespace = operator_namespace
        self.operator_instance_name = operator_instance_name
        self.operator_type = operator_type
        self.operator_params = operator_params
        self.configuration_protected_settings = configuration_protected_settings
        self.operator_scope = operator_scope
        self.repository_public_key = None
        self.ssh_known_hosts_contents = ssh_known_hosts_contents
        self.enable_helm_operator = enable_helm_operator
        self.helm_operator_properties = helm_operator_properties
        self.provisioning_state = None
        self.compliance_status = None


class SourceControlConfigurationList(msrest.serialization.Model):
    """Result of the request to list Source Control Configurations.  It contains a list of SourceControlConfiguration objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Source Control Configurations within a Kubernetes cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.SourceControlConfiguration]
    :ivar next_link: URL to get the next set of configuration objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControlConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceControlConfigurationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SupportedScopes(msrest.serialization.Model):
    """Extension scopes.

    :param default_scope: Default extension scopes: cluster or namespace.
    :type default_scope: str
    :param cluster_scope_settings: Scope settings.
    :type cluster_scope_settings:
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.ClusterScopeSettings
    """

    _attribute_map = {
        'default_scope': {'key': 'defaultScope', 'type': 'str'},
        'cluster_scope_settings': {'key': 'clusterScopeSettings', 'type': 'ClusterScopeSettings'},
    }

    def __init__(
        self,
        *,
        default_scope: Optional[str] = None,
        cluster_scope_settings: Optional["ClusterScopeSettings"] = None,
        **kwargs
    ):
        super(SupportedScopes, self).__init__(**kwargs)
        self.default_scope = default_scope
        self.cluster_scope_settings = cluster_scope_settings


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2021_05_01_preview.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
