/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class CompositeFilter
extends ImageFilterPlus {
    private ImageFilterPlus filterOne;
    private ImageFilterPlus filterTwo;
    private ImageFilter instanceOne;
    private ImageFilter instanceTwo;

    public CompositeFilter(ImageProducer imageProducer, ImageFilterPlus imageFilterPlus, ImageFilterPlus imageFilterPlus2) {
        super(imageProducer);
        this.filterOne = imageFilterPlus;
        this.filterTwo = imageFilterPlus2;
        imageFilterPlus.setSource(imageProducer);
        FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, imageFilterPlus);
        imageFilterPlus2.setSource(filteredImageSource);
    }

    public ImageFilter getFilterInstance(ImageConsumer imageConsumer) {
        ImageFilter imageFilter = this.filterOne.getFilterInstance(this.instanceTwo);
        CompositeFilter compositeFilter = (CompositeFilter)super.getFilterInstance(imageConsumer);
        compositeFilter.instanceTwo = this.filterTwo.getFilterInstance(imageConsumer);
        compositeFilter.instanceOne = this.filterOne.getFilterInstance(this.instanceTwo);
        return compositeFilter;
    }

    public void imageComplete(int n) {
        this.instanceOne.imageComplete(n);
    }

    public void setColorModel(ColorModel colorModel) {
        this.instanceOne.setColorModel(colorModel);
    }

    public void setDimensions(int n, int n2) {
        this.instanceOne.setDimensions(n, n2);
    }

    public void setHints(int n) {
        this.instanceOne.setHints(n);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        this.instanceOne.setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        this.instanceOne.setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
    }

    public void setProperties(Hashtable hashtable) {
        this.instanceOne.setProperties(hashtable);
    }
}

