/*
 *	netcf compatibility API header
 *
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 *	This header file provides a netcf interface by David Lutterkort
 *	from Red Hat Inc., compatible to the netcf version 0.1.6 published
 *	under LGPL-2.1+.
 *
 */
#ifndef NETCONTROL_NETCF_H
#define NETCONTROL_NETCF_H

struct netcf;
struct netcf_if;

typedef enum {
	NETCF_NOERROR = 0,   /* no error, everything ok */
	NETCF_EINTERNAL,     /* internal error, aka bug */
	NETCF_EOTHER,        /* other error, copout for being more specific */
	NETCF_ENOMEM,        /* allocation failed */
	NETCF_EXMLPARSER,    /* XML parser choked */
	NETCF_EXMLINVALID,   /* XML invalid in some form */
	NETCF_ENOENT,        /* Required entry in a tree is missing */
	NETCF_EEXEC,         /* external program execution failed or returned non-0 */
	NETCF_EINUSE,        /* attempt to close a netcf instance that is still in use */
	NETCF_EXSLTFAILED,   /* XSLT transformation failed */
	NETCF_EFILE,         /* Some file access failed */
	NETCF_EIOCTL,        /* An ioctl call failed */
	NETCF_ENETLINK,      /* something related to the netlink socket failed */
} netcf_errcode_t;

typedef enum {
	NETCF_IFACE_INACTIVE = 1,
	NETCF_IFACE_ACTIVE   = 2,
} netcf_if_flag_t;

int			ncf_init(struct netcf **, const char *);
int			ncf_close(struct netcf *);
int			ncf_error(struct netcf *, const char **, const char **);

int			ncf_num_of_interfaces(struct netcf *, unsigned int);
int			ncf_list_interfaces(struct netcf *, int, char **, unsigned int);

struct netcf_if *	ncf_lookup_by_name(struct netcf *, const char *);
int			ncf_lookup_by_mac_string(struct netcf *, const char *, int,
			                         struct netcf_if **);

struct netcf_if *	ncf_define(struct netcf *, const char *);

int			ncf_if_undefine(struct netcf_if *);

const char *		ncf_if_name(struct netcf_if *);
const char *		ncf_if_mac_string(struct netcf_if *);

int			ncf_if_up(struct netcf_if *);
int			ncf_if_down(struct netcf_if *);

char *			ncf_if_xml_desc(struct netcf_if *);
char *			ncf_if_xml_state(struct netcf_if *);

int			ncf_if_status(struct netcf_if *, unsigned int *);

void			ncf_if_free(struct netcf_if *);

#endif	/* NETCONTROL_NETCF_H */
