# Design {#design}

The purpose of this document is to present and explain all high-level design decisions for the HawkTracer profiler. If you are looking for a design of a specific component, you should probably be looking at one of the two documents below:

* @subpage design_library
 * @subpage design_events
 * @subpage design_timeline
 * @subpage design_timeline_features
* @subpage design_client
* @subpage design_htdump_format

## Diagram
The diagram below represents high level architecture of the %HawkTracer project.

![HawkTracer high level design diagram](hawktracer_high_level.png)

%HawkTracer Core is implemented as a library which must be linked to profiled application. User calls functions from the library in order to report events (the library provides a lot of helper macros and functions to simplify this operation). The events then are transfered to a client, which are then processed and transformed from binary to human-readable format (or to format supported by third-party profiler viewers).

## Core of the profiler as a library
%HawkTracer profiler was designed as a library that's linked to the executable.
The other approach we considered was to implement is as external executable which runs in parallel with the profiled application. We decided to not implement the profiler as external process because of a few reasons:

* %HawkTracer is targeting as many platforms as possible, including those which don't allow users execute multiple processes
* getting detailed tracing information for some platforms require administration privileges, which might not be available for the user

## Separation of Core and Client
We decided to keep the core library as lightweight as possible to not introduce extra overhead. Therefore the library should generate data as quickly as possible and transfer it to a client (either directly, or indirectly, e.g. through file system).
However, one can treat %HawkTracer library as a lightweight event system, therefore it is possible to extend the library to run any event processing.
In order to minimize the data generated by the library, but at the same time keep the data format extensible, we've designed a custom data format (HTDUMP) - both client and core library implement the format to efficiently transfer events.
