/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	forkliftv1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/forklift/v1beta1"
	versioned "kubevirt.io/containerized-data-importer/pkg/client/clientset/versioned"
	internalinterfaces "kubevirt.io/containerized-data-importer/pkg/client/informers/externalversions/internalinterfaces"
	v1beta1 "kubevirt.io/containerized-data-importer/pkg/client/listers/forklift/v1beta1"
)

// OpenstackVolumePopulatorInformer provides access to a shared informer and lister for
// OpenstackVolumePopulators.
type OpenstackVolumePopulatorInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.OpenstackVolumePopulatorLister
}

type openstackVolumePopulatorInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewOpenstackVolumePopulatorInformer constructs a new informer for OpenstackVolumePopulator type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewOpenstackVolumePopulatorInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredOpenstackVolumePopulatorInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredOpenstackVolumePopulatorInformer constructs a new informer for OpenstackVolumePopulator type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredOpenstackVolumePopulatorInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ForkliftV1beta1().OpenstackVolumePopulators(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ForkliftV1beta1().OpenstackVolumePopulators(namespace).Watch(context.TODO(), options)
			},
		},
		&forkliftv1beta1.OpenstackVolumePopulator{},
		resyncPeriod,
		indexers,
	)
}

func (f *openstackVolumePopulatorInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredOpenstackVolumePopulatorInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *openstackVolumePopulatorInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&forkliftv1beta1.OpenstackVolumePopulator{}, f.defaultInformer)
}

func (f *openstackVolumePopulatorInformer) Lister() v1beta1.OpenstackVolumePopulatorLister {
	return v1beta1.NewOpenstackVolumePopulatorLister(f.Informer().GetIndexer())
}
