/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
	scheme "kubevirt.io/containerized-data-importer/pkg/client/clientset/versioned/scheme"
)

// CDIsGetter has a method to return a CDIInterface.
// A group's client should implement this interface.
type CDIsGetter interface {
	CDIs() CDIInterface
}

// CDIInterface has methods to work with CDI resources.
type CDIInterface interface {
	Create(ctx context.Context, cDI *v1beta1.CDI, opts v1.CreateOptions) (*v1beta1.CDI, error)
	Update(ctx context.Context, cDI *v1beta1.CDI, opts v1.UpdateOptions) (*v1beta1.CDI, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, cDI *v1beta1.CDI, opts v1.UpdateOptions) (*v1beta1.CDI, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.CDI, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.CDIList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.CDI, err error)
	CDIExpansion
}

// cDIs implements CDIInterface
type cDIs struct {
	*gentype.ClientWithList[*v1beta1.CDI, *v1beta1.CDIList]
}

// newCDIs returns a CDIs
func newCDIs(c *CdiV1beta1Client) *cDIs {
	return &cDIs{
		gentype.NewClientWithList[*v1beta1.CDI, *v1beta1.CDIList](
			"cdis",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v1beta1.CDI { return &v1beta1.CDI{} },
			func() *v1beta1.CDIList { return &v1beta1.CDIList{} }),
	}
}
