// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/tauri-apps/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

#[cfg(feature = "v2_16")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
use crate::HardwareAccelerationPolicy;
use glib::{
  prelude::*,
  signal::{connect_raw, SignalHandlerId},
  translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "WebKitSettings")]
    pub struct Settings(Object<ffi::WebKitSettings, ffi::WebKitSettingsClass>);

    match fn {
        type_ => || ffi::webkit_settings_get_type(),
    }
}

impl Settings {
  pub const NONE: Option<&'static Settings> = None;

  #[doc(alias = "webkit_settings_new")]
  pub fn new() -> Settings {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::webkit_settings_new()) }
  }

  //#[doc(alias = "webkit_settings_new_with_settings")]
  //#[doc(alias = "new_with_settings")]
  //pub fn with_settings(first_setting_name: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> Settings {
  //    unsafe { TODO: call ffi:webkit_settings_new_with_settings() }
  //}

  // rustdoc-stripper-ignore-next
  /// Creates a new builder-pattern struct instance to construct [`Settings`] objects.
  ///
  /// This method returns an instance of [`SettingsBuilder`](crate::builders::SettingsBuilder) which can be used to create [`Settings`] objects.
  pub fn builder() -> SettingsBuilder {
    SettingsBuilder::new()
  }

  #[cfg(feature = "v2_20")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_20")))]
  #[doc(alias = "webkit_settings_font_size_to_pixels")]
  pub fn font_size_to_pixels(points: u32) -> u32 {
    assert_initialized_main_thread!();
    unsafe { ffi::webkit_settings_font_size_to_pixels(points) }
  }

  #[cfg(feature = "v2_20")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_20")))]
  #[doc(alias = "webkit_settings_font_size_to_points")]
  pub fn font_size_to_points(pixels: u32) -> u32 {
    assert_initialized_main_thread!();
    unsafe { ffi::webkit_settings_font_size_to_points(pixels) }
  }
}

impl Default for Settings {
  fn default() -> Self {
    Self::new()
  }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Settings`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SettingsBuilder {
  builder: glib::object::ObjectBuilder<'static, Settings>,
}

impl SettingsBuilder {
  fn new() -> Self {
    Self {
      builder: glib::object::Object::builder(),
    }
  }

  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  pub fn allow_file_access_from_file_urls(self, allow_file_access_from_file_urls: bool) -> Self {
    Self {
      builder: self.builder.property(
        "allow-file-access-from-file-urls",
        allow_file_access_from_file_urls,
      ),
    }
  }

  pub fn allow_modal_dialogs(self, allow_modal_dialogs: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("allow-modal-dialogs", allow_modal_dialogs),
    }
  }

  #[cfg(feature = "v2_28")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
  pub fn allow_top_navigation_to_data_urls(self, allow_top_navigation_to_data_urls: bool) -> Self {
    Self {
      builder: self.builder.property(
        "allow-top-navigation-to-data-urls",
        allow_top_navigation_to_data_urls,
      ),
    }
  }

  #[cfg(feature = "v2_14")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_14")))]
  pub fn allow_universal_access_from_file_urls(
    self,
    allow_universal_access_from_file_urls: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "allow-universal-access-from-file-urls",
        allow_universal_access_from_file_urls,
      ),
    }
  }

  pub fn auto_load_images(self, auto_load_images: bool) -> Self {
    Self {
      builder: self.builder.property("auto-load-images", auto_load_images),
    }
  }

  pub fn cursive_font_family(self, cursive_font_family: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("cursive-font-family", cursive_font_family.into()),
    }
  }

  pub fn default_charset(self, default_charset: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("default-charset", default_charset.into()),
    }
  }

  pub fn default_font_family(self, default_font_family: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("default-font-family", default_font_family.into()),
    }
  }

  pub fn default_font_size(self, default_font_size: u32) -> Self {
    Self {
      builder: self
        .builder
        .property("default-font-size", default_font_size),
    }
  }

  pub fn default_monospace_font_size(self, default_monospace_font_size: u32) -> Self {
    Self {
      builder: self
        .builder
        .property("default-monospace-font-size", default_monospace_font_size),
    }
  }

  #[cfg(feature = "v2_40")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_40")))]
  pub fn disable_web_security(self, disable_web_security: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("disable-web-security", disable_web_security),
    }
  }

  pub fn draw_compositing_indicators(self, draw_compositing_indicators: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("draw-compositing-indicators", draw_compositing_indicators),
    }
  }

  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  pub fn enable_accelerated_2d_canvas(self, enable_accelerated_2d_canvas: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-accelerated-2d-canvas", enable_accelerated_2d_canvas),
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  pub fn enable_back_forward_navigation_gestures(
    self,
    enable_back_forward_navigation_gestures: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "enable-back-forward-navigation-gestures",
        enable_back_forward_navigation_gestures,
      ),
    }
  }

  pub fn enable_caret_browsing(self, enable_caret_browsing: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-caret-browsing", enable_caret_browsing),
    }
  }

  pub fn enable_developer_extras(self, enable_developer_extras: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-developer-extras", enable_developer_extras),
    }
  }

  pub fn enable_dns_prefetching(self, enable_dns_prefetching: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-dns-prefetching", enable_dns_prefetching),
    }
  }

  #[cfg(feature = "v2_20")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_20")))]
  pub fn enable_encrypted_media(self, enable_encrypted_media: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-encrypted-media", enable_encrypted_media),
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  pub fn enable_frame_flattening(self, enable_frame_flattening: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-frame-flattening", enable_frame_flattening),
    }
  }

  pub fn enable_fullscreen(self, enable_fullscreen: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-fullscreen", enable_fullscreen),
    }
  }

  pub fn enable_html5_database(self, enable_html5_database: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-html5-database", enable_html5_database),
    }
  }

  pub fn enable_html5_local_storage(self, enable_html5_local_storage: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-html5-local-storage", enable_html5_local_storage),
    }
  }

  pub fn enable_hyperlink_auditing(self, enable_hyperlink_auditing: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-hyperlink-auditing", enable_hyperlink_auditing),
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  pub fn enable_java(self, enable_java: bool) -> Self {
    Self {
      builder: self.builder.property("enable-java", enable_java),
    }
  }

  pub fn enable_javascript(self, enable_javascript: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-javascript", enable_javascript),
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  pub fn enable_javascript_markup(self, enable_javascript_markup: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-javascript-markup", enable_javascript_markup),
    }
  }

  #[cfg(feature = "v2_26")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
  pub fn enable_media(self, enable_media: bool) -> Self {
    Self {
      builder: self.builder.property("enable-media", enable_media),
    }
  }

  #[cfg(feature = "v2_22")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_22")))]
  pub fn enable_media_capabilities(self, enable_media_capabilities: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-media-capabilities", enable_media_capabilities),
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  pub fn enable_media_stream(self, enable_media_stream: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-media-stream", enable_media_stream),
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  pub fn enable_mediasource(self, enable_mediasource: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-mediasource", enable_mediasource),
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  pub fn enable_mock_capture_devices(self, enable_mock_capture_devices: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-mock-capture-devices", enable_mock_capture_devices),
    }
  }

  pub fn enable_offline_web_application_cache(
    self,
    enable_offline_web_application_cache: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "enable-offline-web-application-cache",
        enable_offline_web_application_cache,
      ),
    }
  }

  pub fn enable_page_cache(self, enable_page_cache: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-page-cache", enable_page_cache),
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  pub fn enable_plugins(self, enable_plugins: bool) -> Self {
    Self {
      builder: self.builder.property("enable-plugins", enable_plugins),
    }
  }

  #[cfg_attr(feature = "v2_16", deprecated = "Since 2.16")]
  pub fn enable_private_browsing(self, enable_private_browsing: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-private-browsing", enable_private_browsing),
    }
  }

  pub fn enable_resizable_text_areas(self, enable_resizable_text_areas: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-resizable-text-areas", enable_resizable_text_areas),
    }
  }

  pub fn enable_site_specific_quirks(self, enable_site_specific_quirks: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-site-specific-quirks", enable_site_specific_quirks),
    }
  }

  pub fn enable_smooth_scrolling(self, enable_smooth_scrolling: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-smooth-scrolling", enable_smooth_scrolling),
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  pub fn enable_spatial_navigation(self, enable_spatial_navigation: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-spatial-navigation", enable_spatial_navigation),
    }
  }

  pub fn enable_tabs_to_links(self, enable_tabs_to_links: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-tabs-to-links", enable_tabs_to_links),
    }
  }

  pub fn enable_webaudio(self, enable_webaudio: bool) -> Self {
    Self {
      builder: self.builder.property("enable-webaudio", enable_webaudio),
    }
  }

  pub fn enable_webgl(self, enable_webgl: bool) -> Self {
    Self {
      builder: self.builder.property("enable-webgl", enable_webgl),
    }
  }

  #[cfg(feature = "v2_38")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_38")))]
  pub fn enable_webrtc(self, enable_webrtc: bool) -> Self {
    Self {
      builder: self.builder.property("enable-webrtc", enable_webrtc),
    }
  }

  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  pub fn enable_write_console_messages_to_stdout(
    self,
    enable_write_console_messages_to_stdout: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "enable-write-console-messages-to-stdout",
        enable_write_console_messages_to_stdout,
      ),
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  pub fn enable_xss_auditor(self, enable_xss_auditor: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("enable-xss-auditor", enable_xss_auditor),
    }
  }

  pub fn fantasy_font_family(self, fantasy_font_family: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("fantasy-font-family", fantasy_font_family.into()),
    }
  }

  #[cfg(feature = "v2_16")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
  pub fn hardware_acceleration_policy(
    self,
    hardware_acceleration_policy: HardwareAccelerationPolicy,
  ) -> Self {
    Self {
      builder: self
        .builder
        .property("hardware-acceleration-policy", hardware_acceleration_policy),
    }
  }

  pub fn javascript_can_access_clipboard(self, javascript_can_access_clipboard: bool) -> Self {
    Self {
      builder: self.builder.property(
        "javascript-can-access-clipboard",
        javascript_can_access_clipboard,
      ),
    }
  }

  pub fn javascript_can_open_windows_automatically(
    self,
    javascript_can_open_windows_automatically: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "javascript-can-open-windows-automatically",
        javascript_can_open_windows_automatically,
      ),
    }
  }

  pub fn load_icons_ignoring_image_load_setting(
    self,
    load_icons_ignoring_image_load_setting: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "load-icons-ignoring-image-load-setting",
        load_icons_ignoring_image_load_setting,
      ),
    }
  }

  #[cfg(feature = "v2_30")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
  pub fn media_content_types_requiring_hardware_support(
    self,
    media_content_types_requiring_hardware_support: impl Into<glib::GString>,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "media-content-types-requiring-hardware-support",
        media_content_types_requiring_hardware_support.into(),
      ),
    }
  }

  pub fn media_playback_allows_inline(self, media_playback_allows_inline: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("media-playback-allows-inline", media_playback_allows_inline),
    }
  }

  pub fn media_playback_requires_user_gesture(
    self,
    media_playback_requires_user_gesture: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "media-playback-requires-user-gesture",
        media_playback_requires_user_gesture,
      ),
    }
  }

  pub fn minimum_font_size(self, minimum_font_size: u32) -> Self {
    Self {
      builder: self
        .builder
        .property("minimum-font-size", minimum_font_size),
    }
  }

  pub fn monospace_font_family(self, monospace_font_family: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("monospace-font-family", monospace_font_family.into()),
    }
  }

  pub fn pictograph_font_family(self, pictograph_font_family: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("pictograph-font-family", pictograph_font_family.into()),
    }
  }

  pub fn print_backgrounds(self, print_backgrounds: bool) -> Self {
    Self {
      builder: self
        .builder
        .property("print-backgrounds", print_backgrounds),
    }
  }

  pub fn sans_serif_font_family(self, sans_serif_font_family: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("sans-serif-font-family", sans_serif_font_family.into()),
    }
  }

  pub fn serif_font_family(self, serif_font_family: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("serif-font-family", serif_font_family.into()),
    }
  }

  pub fn user_agent(self, user_agent: impl Into<glib::GString>) -> Self {
    Self {
      builder: self.builder.property("user-agent", user_agent.into()),
    }
  }

  pub fn zoom_text_only(self, zoom_text_only: bool) -> Self {
    Self {
      builder: self.builder.property("zoom-text-only", zoom_text_only),
    }
  }

  // rustdoc-stripper-ignore-next
  /// Build the [`Settings`].
  #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
  pub fn build(self) -> Settings {
    self.builder.build()
  }
}

mod sealed {
  pub trait Sealed {}
  impl<T: super::IsA<super::Settings>> Sealed for T {}
}

pub trait SettingsExt: IsA<Settings> + sealed::Sealed + 'static {
  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  #[doc(alias = "webkit_settings_get_allow_file_access_from_file_urls")]
  #[doc(alias = "get_allow_file_access_from_file_urls")]
  fn allows_file_access_from_file_urls(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_allow_file_access_from_file_urls(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_allow_modal_dialogs")]
  #[doc(alias = "get_allow_modal_dialogs")]
  fn allows_modal_dialogs(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_allow_modal_dialogs(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_28")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
  #[doc(alias = "webkit_settings_get_allow_top_navigation_to_data_urls")]
  #[doc(alias = "get_allow_top_navigation_to_data_urls")]
  fn allows_top_navigation_to_data_urls(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_allow_top_navigation_to_data_urls(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_14")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_14")))]
  #[doc(alias = "webkit_settings_get_allow_universal_access_from_file_urls")]
  #[doc(alias = "get_allow_universal_access_from_file_urls")]
  fn allows_universal_access_from_file_urls(&self) -> bool {
    unsafe {
      from_glib(
        ffi::webkit_settings_get_allow_universal_access_from_file_urls(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[doc(alias = "webkit_settings_get_auto_load_images")]
  #[doc(alias = "get_auto_load_images")]
  fn is_auto_load_images(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_auto_load_images(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_cursive_font_family")]
  #[doc(alias = "get_cursive_font_family")]
  fn cursive_font_family(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_cursive_font_family(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_default_charset")]
  #[doc(alias = "get_default_charset")]
  fn default_charset(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_default_charset(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_default_font_family")]
  #[doc(alias = "get_default_font_family")]
  fn default_font_family(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_default_font_family(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_default_font_size")]
  #[doc(alias = "get_default_font_size")]
  fn default_font_size(&self) -> u32 {
    unsafe { ffi::webkit_settings_get_default_font_size(self.as_ref().to_glib_none().0) }
  }

  #[doc(alias = "webkit_settings_get_default_monospace_font_size")]
  #[doc(alias = "get_default_monospace_font_size")]
  fn default_monospace_font_size(&self) -> u32 {
    unsafe { ffi::webkit_settings_get_default_monospace_font_size(self.as_ref().to_glib_none().0) }
  }

  #[cfg(feature = "v2_40")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_40")))]
  #[doc(alias = "webkit_settings_get_disable_web_security")]
  #[doc(alias = "get_disable_web_security")]
  fn is_disable_web_security(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_disable_web_security(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_draw_compositing_indicators")]
  #[doc(alias = "get_draw_compositing_indicators")]
  fn draws_compositing_indicators(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_draw_compositing_indicators(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_get_enable_accelerated_2d_canvas")]
  #[doc(alias = "get_enable_accelerated_2d_canvas")]
  fn enables_accelerated_2d_canvas(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_accelerated_2d_canvas(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  #[doc(alias = "webkit_settings_get_enable_back_forward_navigation_gestures")]
  #[doc(alias = "get_enable_back_forward_navigation_gestures")]
  fn enables_back_forward_navigation_gestures(&self) -> bool {
    unsafe {
      from_glib(
        ffi::webkit_settings_get_enable_back_forward_navigation_gestures(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[doc(alias = "webkit_settings_get_enable_caret_browsing")]
  #[doc(alias = "get_enable_caret_browsing")]
  fn enables_caret_browsing(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_caret_browsing(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_developer_extras")]
  #[doc(alias = "get_enable_developer_extras")]
  fn enables_developer_extras(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_developer_extras(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_dns_prefetching")]
  #[doc(alias = "get_enable_dns_prefetching")]
  fn enables_dns_prefetching(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_dns_prefetching(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_20")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_20")))]
  #[doc(alias = "webkit_settings_get_enable_encrypted_media")]
  #[doc(alias = "get_enable_encrypted_media")]
  fn enables_encrypted_media(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_encrypted_media(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_get_enable_frame_flattening")]
  #[doc(alias = "get_enable_frame_flattening")]
  fn enables_frame_flattening(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_frame_flattening(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_fullscreen")]
  #[doc(alias = "get_enable_fullscreen")]
  fn enables_fullscreen(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_fullscreen(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_html5_database")]
  #[doc(alias = "get_enable_html5_database")]
  fn enables_html5_database(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_html5_database(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_html5_local_storage")]
  #[doc(alias = "get_enable_html5_local_storage")]
  fn enables_html5_local_storage(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_html5_local_storage(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_hyperlink_auditing")]
  #[doc(alias = "get_enable_hyperlink_auditing")]
  fn enables_hyperlink_auditing(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_hyperlink_auditing(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_get_enable_java")]
  #[doc(alias = "get_enable_java")]
  fn enables_java(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_java(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_javascript")]
  #[doc(alias = "get_enable_javascript")]
  fn enables_javascript(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_javascript(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  #[doc(alias = "webkit_settings_get_enable_javascript_markup")]
  #[doc(alias = "get_enable_javascript_markup")]
  fn enables_javascript_markup(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_javascript_markup(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_26")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
  #[doc(alias = "webkit_settings_get_enable_media")]
  #[doc(alias = "get_enable_media")]
  fn enables_media(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_media(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_22")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_22")))]
  #[doc(alias = "webkit_settings_get_enable_media_capabilities")]
  #[doc(alias = "get_enable_media_capabilities")]
  fn enables_media_capabilities(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_media_capabilities(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "webkit_settings_get_enable_media_stream")]
  #[doc(alias = "get_enable_media_stream")]
  fn enables_media_stream(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_media_stream(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "webkit_settings_get_enable_mediasource")]
  #[doc(alias = "get_enable_mediasource")]
  fn enables_mediasource(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_mediasource(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  #[doc(alias = "webkit_settings_get_enable_mock_capture_devices")]
  #[doc(alias = "get_enable_mock_capture_devices")]
  fn enables_mock_capture_devices(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_mock_capture_devices(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_offline_web_application_cache")]
  #[doc(alias = "get_enable_offline_web_application_cache")]
  fn enables_offline_web_application_cache(&self) -> bool {
    unsafe {
      from_glib(
        ffi::webkit_settings_get_enable_offline_web_application_cache(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[doc(alias = "webkit_settings_get_enable_page_cache")]
  #[doc(alias = "get_enable_page_cache")]
  fn enables_page_cache(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_page_cache(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_get_enable_plugins")]
  #[doc(alias = "get_enable_plugins")]
  fn enables_plugins(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_plugins(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg_attr(feature = "v2_16", deprecated = "Since 2.16")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_get_enable_private_browsing")]
  #[doc(alias = "get_enable_private_browsing")]
  fn enables_private_browsing(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_private_browsing(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_resizable_text_areas")]
  #[doc(alias = "get_enable_resizable_text_areas")]
  fn enables_resizable_text_areas(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_resizable_text_areas(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_site_specific_quirks")]
  #[doc(alias = "get_enable_site_specific_quirks")]
  fn enables_site_specific_quirks(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_site_specific_quirks(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_smooth_scrolling")]
  #[doc(alias = "get_enable_smooth_scrolling")]
  fn enables_smooth_scrolling(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_smooth_scrolling(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[doc(alias = "webkit_settings_get_enable_spatial_navigation")]
  #[doc(alias = "get_enable_spatial_navigation")]
  fn enables_spatial_navigation(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_spatial_navigation(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_tabs_to_links")]
  #[doc(alias = "get_enable_tabs_to_links")]
  fn enables_tabs_to_links(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_tabs_to_links(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_webaudio")]
  #[doc(alias = "get_enable_webaudio")]
  fn enables_webaudio(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_webaudio(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_enable_webgl")]
  #[doc(alias = "get_enable_webgl")]
  fn enables_webgl(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_webgl(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_38")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_38")))]
  #[doc(alias = "webkit_settings_get_enable_webrtc")]
  #[doc(alias = "get_enable_webrtc")]
  fn enables_webrtc(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_webrtc(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[doc(alias = "webkit_settings_get_enable_write_console_messages_to_stdout")]
  #[doc(alias = "get_enable_write_console_messages_to_stdout")]
  fn enables_write_console_messages_to_stdout(&self) -> bool {
    unsafe {
      from_glib(
        ffi::webkit_settings_get_enable_write_console_messages_to_stdout(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_get_enable_xss_auditor")]
  #[doc(alias = "get_enable_xss_auditor")]
  fn enables_xss_auditor(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_enable_xss_auditor(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_fantasy_font_family")]
  #[doc(alias = "get_fantasy_font_family")]
  fn fantasy_font_family(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_fantasy_font_family(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_16")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
  #[doc(alias = "webkit_settings_get_hardware_acceleration_policy")]
  #[doc(alias = "get_hardware_acceleration_policy")]
  fn hardware_acceleration_policy(&self) -> HardwareAccelerationPolicy {
    unsafe {
      from_glib(ffi::webkit_settings_get_hardware_acceleration_policy(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_javascript_can_access_clipboard")]
  #[doc(alias = "get_javascript_can_access_clipboard")]
  fn is_javascript_can_access_clipboard(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_javascript_can_access_clipboard(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_javascript_can_open_windows_automatically")]
  #[doc(alias = "get_javascript_can_open_windows_automatically")]
  fn is_javascript_can_open_windows_automatically(&self) -> bool {
    unsafe {
      from_glib(
        ffi::webkit_settings_get_javascript_can_open_windows_automatically(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[doc(alias = "webkit_settings_get_load_icons_ignoring_image_load_setting")]
  #[doc(alias = "get_load_icons_ignoring_image_load_setting")]
  fn is_load_icons_ignoring_image_load_setting(&self) -> bool {
    unsafe {
      from_glib(
        ffi::webkit_settings_get_load_icons_ignoring_image_load_setting(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[cfg(feature = "v2_30")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
  #[doc(alias = "webkit_settings_get_media_content_types_requiring_hardware_support")]
  #[doc(alias = "get_media_content_types_requiring_hardware_support")]
  fn media_content_types_requiring_hardware_support(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(
        ffi::webkit_settings_get_media_content_types_requiring_hardware_support(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[doc(alias = "webkit_settings_get_media_playback_allows_inline")]
  #[doc(alias = "get_media_playback_allows_inline")]
  fn is_media_playback_allows_inline(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_media_playback_allows_inline(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_media_playback_requires_user_gesture")]
  #[doc(alias = "get_media_playback_requires_user_gesture")]
  fn is_media_playback_requires_user_gesture(&self) -> bool {
    unsafe {
      from_glib(
        ffi::webkit_settings_get_media_playback_requires_user_gesture(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[doc(alias = "webkit_settings_get_minimum_font_size")]
  #[doc(alias = "get_minimum_font_size")]
  fn minimum_font_size(&self) -> u32 {
    unsafe { ffi::webkit_settings_get_minimum_font_size(self.as_ref().to_glib_none().0) }
  }

  #[doc(alias = "webkit_settings_get_monospace_font_family")]
  #[doc(alias = "get_monospace_font_family")]
  fn monospace_font_family(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_monospace_font_family(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_pictograph_font_family")]
  #[doc(alias = "get_pictograph_font_family")]
  fn pictograph_font_family(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_pictograph_font_family(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_print_backgrounds")]
  #[doc(alias = "get_print_backgrounds")]
  fn is_print_backgrounds(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_print_backgrounds(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_sans_serif_font_family")]
  #[doc(alias = "get_sans_serif_font_family")]
  fn sans_serif_font_family(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_sans_serif_font_family(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_serif_font_family")]
  #[doc(alias = "get_serif_font_family")]
  fn serif_font_family(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_serif_font_family(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_user_agent")]
  #[doc(alias = "get_user_agent")]
  fn user_agent(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_settings_get_user_agent(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_settings_get_zoom_text_only")]
  #[doc(alias = "get_zoom_text_only")]
  fn is_zoom_text_only(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_settings_get_zoom_text_only(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  #[doc(alias = "webkit_settings_set_allow_file_access_from_file_urls")]
  fn set_allow_file_access_from_file_urls(&self, allowed: bool) {
    unsafe {
      ffi::webkit_settings_set_allow_file_access_from_file_urls(
        self.as_ref().to_glib_none().0,
        allowed.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_allow_modal_dialogs")]
  fn set_allow_modal_dialogs(&self, allowed: bool) {
    unsafe {
      ffi::webkit_settings_set_allow_modal_dialogs(
        self.as_ref().to_glib_none().0,
        allowed.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_28")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
  #[doc(alias = "webkit_settings_set_allow_top_navigation_to_data_urls")]
  fn set_allow_top_navigation_to_data_urls(&self, allowed: bool) {
    unsafe {
      ffi::webkit_settings_set_allow_top_navigation_to_data_urls(
        self.as_ref().to_glib_none().0,
        allowed.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_14")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_14")))]
  #[doc(alias = "webkit_settings_set_allow_universal_access_from_file_urls")]
  fn set_allow_universal_access_from_file_urls(&self, allowed: bool) {
    unsafe {
      ffi::webkit_settings_set_allow_universal_access_from_file_urls(
        self.as_ref().to_glib_none().0,
        allowed.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_auto_load_images")]
  fn set_auto_load_images(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_auto_load_images(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_cursive_font_family")]
  fn set_cursive_font_family(&self, cursive_font_family: &str) {
    unsafe {
      ffi::webkit_settings_set_cursive_font_family(
        self.as_ref().to_glib_none().0,
        cursive_font_family.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_default_charset")]
  fn set_default_charset(&self, default_charset: &str) {
    unsafe {
      ffi::webkit_settings_set_default_charset(
        self.as_ref().to_glib_none().0,
        default_charset.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_default_font_family")]
  fn set_default_font_family(&self, default_font_family: &str) {
    unsafe {
      ffi::webkit_settings_set_default_font_family(
        self.as_ref().to_glib_none().0,
        default_font_family.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_default_font_size")]
  fn set_default_font_size(&self, font_size: u32) {
    unsafe {
      ffi::webkit_settings_set_default_font_size(self.as_ref().to_glib_none().0, font_size);
    }
  }

  #[doc(alias = "webkit_settings_set_default_monospace_font_size")]
  fn set_default_monospace_font_size(&self, font_size: u32) {
    unsafe {
      ffi::webkit_settings_set_default_monospace_font_size(
        self.as_ref().to_glib_none().0,
        font_size,
      );
    }
  }

  #[cfg(feature = "v2_40")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_40")))]
  #[doc(alias = "webkit_settings_set_disable_web_security")]
  fn set_disable_web_security(&self, disabled: bool) {
    unsafe {
      ffi::webkit_settings_set_disable_web_security(
        self.as_ref().to_glib_none().0,
        disabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_draw_compositing_indicators")]
  fn set_draw_compositing_indicators(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_draw_compositing_indicators(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_set_enable_accelerated_2d_canvas")]
  fn set_enable_accelerated_2d_canvas(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_accelerated_2d_canvas(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  #[doc(alias = "webkit_settings_set_enable_back_forward_navigation_gestures")]
  fn set_enable_back_forward_navigation_gestures(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_back_forward_navigation_gestures(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_caret_browsing")]
  fn set_enable_caret_browsing(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_caret_browsing(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_developer_extras")]
  fn set_enable_developer_extras(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_developer_extras(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_dns_prefetching")]
  fn set_enable_dns_prefetching(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_dns_prefetching(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_20")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_20")))]
  #[doc(alias = "webkit_settings_set_enable_encrypted_media")]
  fn set_enable_encrypted_media(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_encrypted_media(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_set_enable_frame_flattening")]
  fn set_enable_frame_flattening(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_frame_flattening(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_fullscreen")]
  fn set_enable_fullscreen(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_fullscreen(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_html5_database")]
  fn set_enable_html5_database(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_html5_database(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_html5_local_storage")]
  fn set_enable_html5_local_storage(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_html5_local_storage(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_hyperlink_auditing")]
  fn set_enable_hyperlink_auditing(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_hyperlink_auditing(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_set_enable_java")]
  fn set_enable_java(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_java(self.as_ref().to_glib_none().0, enabled.into_glib());
    }
  }

  #[doc(alias = "webkit_settings_set_enable_javascript")]
  fn set_enable_javascript(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_javascript(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  #[doc(alias = "webkit_settings_set_enable_javascript_markup")]
  fn set_enable_javascript_markup(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_javascript_markup(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_26")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
  #[doc(alias = "webkit_settings_set_enable_media")]
  fn set_enable_media(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_media(self.as_ref().to_glib_none().0, enabled.into_glib());
    }
  }

  #[cfg(feature = "v2_22")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_22")))]
  #[doc(alias = "webkit_settings_set_enable_media_capabilities")]
  fn set_enable_media_capabilities(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_media_capabilities(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "webkit_settings_set_enable_media_stream")]
  fn set_enable_media_stream(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_media_stream(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "webkit_settings_set_enable_mediasource")]
  fn set_enable_mediasource(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_mediasource(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "webkit_settings_set_enable_mock_capture_devices")]
  fn set_enable_mock_capture_devices(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_mock_capture_devices(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_offline_web_application_cache")]
  fn set_enable_offline_web_application_cache(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_offline_web_application_cache(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_page_cache")]
  fn set_enable_page_cache(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_page_cache(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_set_enable_plugins")]
  fn set_enable_plugins(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_plugins(self.as_ref().to_glib_none().0, enabled.into_glib());
    }
  }

  #[cfg_attr(feature = "v2_16", deprecated = "Since 2.16")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_set_enable_private_browsing")]
  fn set_enable_private_browsing(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_private_browsing(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_resizable_text_areas")]
  fn set_enable_resizable_text_areas(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_resizable_text_areas(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_site_specific_quirks")]
  fn set_enable_site_specific_quirks(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_site_specific_quirks(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_smooth_scrolling")]
  fn set_enable_smooth_scrolling(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_smooth_scrolling(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[doc(alias = "webkit_settings_set_enable_spatial_navigation")]
  fn set_enable_spatial_navigation(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_spatial_navigation(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_tabs_to_links")]
  fn set_enable_tabs_to_links(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_tabs_to_links(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_enable_webaudio")]
  fn set_enable_webaudio(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_webaudio(self.as_ref().to_glib_none().0, enabled.into_glib());
    }
  }

  #[doc(alias = "webkit_settings_set_enable_webgl")]
  fn set_enable_webgl(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_webgl(self.as_ref().to_glib_none().0, enabled.into_glib());
    }
  }

  #[cfg(feature = "v2_38")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_38")))]
  #[doc(alias = "webkit_settings_set_enable_webrtc")]
  fn set_enable_webrtc(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_webrtc(self.as_ref().to_glib_none().0, enabled.into_glib());
    }
  }

  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[doc(alias = "webkit_settings_set_enable_write_console_messages_to_stdout")]
  fn set_enable_write_console_messages_to_stdout(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_write_console_messages_to_stdout(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_settings_set_enable_xss_auditor")]
  fn set_enable_xss_auditor(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_enable_xss_auditor(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_fantasy_font_family")]
  fn set_fantasy_font_family(&self, fantasy_font_family: &str) {
    unsafe {
      ffi::webkit_settings_set_fantasy_font_family(
        self.as_ref().to_glib_none().0,
        fantasy_font_family.to_glib_none().0,
      );
    }
  }

  #[cfg(feature = "v2_16")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
  #[doc(alias = "webkit_settings_set_hardware_acceleration_policy")]
  fn set_hardware_acceleration_policy(&self, policy: HardwareAccelerationPolicy) {
    unsafe {
      ffi::webkit_settings_set_hardware_acceleration_policy(
        self.as_ref().to_glib_none().0,
        policy.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_javascript_can_access_clipboard")]
  fn set_javascript_can_access_clipboard(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_javascript_can_access_clipboard(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_javascript_can_open_windows_automatically")]
  fn set_javascript_can_open_windows_automatically(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_javascript_can_open_windows_automatically(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_load_icons_ignoring_image_load_setting")]
  fn set_load_icons_ignoring_image_load_setting(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_load_icons_ignoring_image_load_setting(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_30")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
  #[doc(alias = "webkit_settings_set_media_content_types_requiring_hardware_support")]
  fn set_media_content_types_requiring_hardware_support(&self, content_types: Option<&str>) {
    unsafe {
      ffi::webkit_settings_set_media_content_types_requiring_hardware_support(
        self.as_ref().to_glib_none().0,
        content_types.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_media_playback_allows_inline")]
  fn set_media_playback_allows_inline(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_media_playback_allows_inline(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_media_playback_requires_user_gesture")]
  fn set_media_playback_requires_user_gesture(&self, enabled: bool) {
    unsafe {
      ffi::webkit_settings_set_media_playback_requires_user_gesture(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_minimum_font_size")]
  fn set_minimum_font_size(&self, font_size: u32) {
    unsafe {
      ffi::webkit_settings_set_minimum_font_size(self.as_ref().to_glib_none().0, font_size);
    }
  }

  #[doc(alias = "webkit_settings_set_monospace_font_family")]
  fn set_monospace_font_family(&self, monospace_font_family: &str) {
    unsafe {
      ffi::webkit_settings_set_monospace_font_family(
        self.as_ref().to_glib_none().0,
        monospace_font_family.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_pictograph_font_family")]
  fn set_pictograph_font_family(&self, pictograph_font_family: &str) {
    unsafe {
      ffi::webkit_settings_set_pictograph_font_family(
        self.as_ref().to_glib_none().0,
        pictograph_font_family.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_print_backgrounds")]
  fn set_print_backgrounds(&self, print_backgrounds: bool) {
    unsafe {
      ffi::webkit_settings_set_print_backgrounds(
        self.as_ref().to_glib_none().0,
        print_backgrounds.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_settings_set_sans_serif_font_family")]
  fn set_sans_serif_font_family(&self, sans_serif_font_family: &str) {
    unsafe {
      ffi::webkit_settings_set_sans_serif_font_family(
        self.as_ref().to_glib_none().0,
        sans_serif_font_family.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_serif_font_family")]
  fn set_serif_font_family(&self, serif_font_family: &str) {
    unsafe {
      ffi::webkit_settings_set_serif_font_family(
        self.as_ref().to_glib_none().0,
        serif_font_family.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_user_agent")]
  fn set_user_agent(&self, user_agent: Option<&str>) {
    unsafe {
      ffi::webkit_settings_set_user_agent(
        self.as_ref().to_glib_none().0,
        user_agent.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_user_agent_with_application_details")]
  fn set_user_agent_with_application_details(
    &self,
    application_name: Option<&str>,
    application_version: Option<&str>,
  ) {
    unsafe {
      ffi::webkit_settings_set_user_agent_with_application_details(
        self.as_ref().to_glib_none().0,
        application_name.to_glib_none().0,
        application_version.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_settings_set_zoom_text_only")]
  fn set_zoom_text_only(&self, zoom_text_only: bool) {
    unsafe {
      ffi::webkit_settings_set_zoom_text_only(
        self.as_ref().to_glib_none().0,
        zoom_text_only.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  #[doc(alias = "allow-file-access-from-file-urls")]
  fn connect_allow_file_access_from_file_urls_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_allow_file_access_from_file_urls_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::allow-file-access-from-file-urls\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_allow_file_access_from_file_urls_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "allow-modal-dialogs")]
  fn connect_allow_modal_dialogs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_allow_modal_dialogs_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::allow-modal-dialogs\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_allow_modal_dialogs_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_28")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
  #[doc(alias = "allow-top-navigation-to-data-urls")]
  fn connect_allow_top_navigation_to_data_urls_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_allow_top_navigation_to_data_urls_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::allow-top-navigation-to-data-urls\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_allow_top_navigation_to_data_urls_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_14")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_14")))]
  #[doc(alias = "allow-universal-access-from-file-urls")]
  fn connect_allow_universal_access_from_file_urls_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_allow_universal_access_from_file_urls_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::allow-universal-access-from-file-urls\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_allow_universal_access_from_file_urls_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "auto-load-images")]
  fn connect_auto_load_images_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_auto_load_images_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::auto-load-images\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_auto_load_images_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "cursive-font-family")]
  fn connect_cursive_font_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_cursive_font_family_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::cursive-font-family\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_cursive_font_family_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "default-charset")]
  fn connect_default_charset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_default_charset_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::default-charset\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_default_charset_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "default-font-family")]
  fn connect_default_font_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_default_font_family_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::default-font-family\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_default_font_family_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "default-font-size")]
  fn connect_default_font_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_default_font_size_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::default-font-size\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_default_font_size_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "default-monospace-font-size")]
  fn connect_default_monospace_font_size_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_default_monospace_font_size_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::default-monospace-font-size\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_default_monospace_font_size_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_40")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_40")))]
  #[doc(alias = "disable-web-security")]
  fn connect_disable_web_security_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_disable_web_security_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::disable-web-security\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_disable_web_security_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "draw-compositing-indicators")]
  fn connect_draw_compositing_indicators_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_draw_compositing_indicators_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::draw-compositing-indicators\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_draw_compositing_indicators_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[doc(alias = "enable-accelerated-2d-canvas")]
  fn connect_enable_accelerated_2d_canvas_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_accelerated_2d_canvas_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-accelerated-2d-canvas\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_accelerated_2d_canvas_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  #[doc(alias = "enable-back-forward-navigation-gestures")]
  fn connect_enable_back_forward_navigation_gestures_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_back_forward_navigation_gestures_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-back-forward-navigation-gestures\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_back_forward_navigation_gestures_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-caret-browsing")]
  fn connect_enable_caret_browsing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_caret_browsing_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-caret-browsing\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_caret_browsing_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-developer-extras")]
  fn connect_enable_developer_extras_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_developer_extras_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-developer-extras\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_developer_extras_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-dns-prefetching")]
  fn connect_enable_dns_prefetching_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_dns_prefetching_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-dns-prefetching\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_dns_prefetching_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_20")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_20")))]
  #[doc(alias = "enable-encrypted-media")]
  fn connect_enable_encrypted_media_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_encrypted_media_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-encrypted-media\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_encrypted_media_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[doc(alias = "enable-frame-flattening")]
  fn connect_enable_frame_flattening_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_frame_flattening_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-frame-flattening\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_frame_flattening_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-fullscreen")]
  fn connect_enable_fullscreen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_fullscreen_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-fullscreen\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_fullscreen_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-html5-database")]
  fn connect_enable_html5_database_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_html5_database_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-html5-database\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_html5_database_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-html5-local-storage")]
  fn connect_enable_html5_local_storage_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_html5_local_storage_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-html5-local-storage\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_html5_local_storage_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-hyperlink-auditing")]
  fn connect_enable_hyperlink_auditing_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_hyperlink_auditing_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-hyperlink-auditing\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_hyperlink_auditing_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[doc(alias = "enable-java")]
  fn connect_enable_java_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_java_trampoline<P: IsA<Settings>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-java\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_java_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-javascript")]
  fn connect_enable_javascript_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_javascript_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-javascript\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_javascript_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  #[doc(alias = "enable-javascript-markup")]
  fn connect_enable_javascript_markup_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_javascript_markup_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-javascript-markup\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_javascript_markup_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_26")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
  #[doc(alias = "enable-media")]
  fn connect_enable_media_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_media_trampoline<P: IsA<Settings>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-media\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_media_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_22")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_22")))]
  #[doc(alias = "enable-media-capabilities")]
  fn connect_enable_media_capabilities_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_media_capabilities_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-media-capabilities\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_media_capabilities_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "enable-media-stream")]
  fn connect_enable_media_stream_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_media_stream_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-media-stream\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_media_stream_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "enable-mediasource")]
  fn connect_enable_mediasource_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_mediasource_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-mediasource\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_mediasource_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_24")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_24")))]
  #[doc(alias = "enable-mock-capture-devices")]
  fn connect_enable_mock_capture_devices_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_mock_capture_devices_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-mock-capture-devices\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_mock_capture_devices_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-offline-web-application-cache")]
  fn connect_enable_offline_web_application_cache_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_offline_web_application_cache_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-offline-web-application-cache\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_offline_web_application_cache_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-page-cache")]
  fn connect_enable_page_cache_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_page_cache_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-page-cache\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_page_cache_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[doc(alias = "enable-plugins")]
  fn connect_enable_plugins_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_plugins_trampoline<P: IsA<Settings>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-plugins\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_plugins_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg_attr(feature = "v2_16", deprecated = "Since 2.16")]
  #[doc(alias = "enable-private-browsing")]
  fn connect_enable_private_browsing_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_private_browsing_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-private-browsing\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_private_browsing_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-resizable-text-areas")]
  fn connect_enable_resizable_text_areas_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_resizable_text_areas_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-resizable-text-areas\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_resizable_text_areas_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-site-specific-quirks")]
  fn connect_enable_site_specific_quirks_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_site_specific_quirks_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-site-specific-quirks\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_site_specific_quirks_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-smooth-scrolling")]
  fn connect_enable_smooth_scrolling_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_smooth_scrolling_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-smooth-scrolling\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_smooth_scrolling_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "enable-spatial-navigation")]
  fn connect_enable_spatial_navigation_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_spatial_navigation_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-spatial-navigation\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_spatial_navigation_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-tabs-to-links")]
  fn connect_enable_tabs_to_links_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_tabs_to_links_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-tabs-to-links\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_tabs_to_links_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-webaudio")]
  fn connect_enable_webaudio_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_webaudio_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-webaudio\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_webaudio_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "enable-webgl")]
  fn connect_enable_webgl_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_webgl_trampoline<P: IsA<Settings>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-webgl\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_webgl_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_38")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_38")))]
  #[doc(alias = "enable-webrtc")]
  fn connect_enable_webrtc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_webrtc_trampoline<P: IsA<Settings>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-webrtc\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_webrtc_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_2")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_2")))]
  #[doc(alias = "enable-write-console-messages-to-stdout")]
  fn connect_enable_write_console_messages_to_stdout_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_write_console_messages_to_stdout_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-write-console-messages-to-stdout\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_write_console_messages_to_stdout_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
  #[doc(alias = "enable-xss-auditor")]
  fn connect_enable_xss_auditor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_enable_xss_auditor_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::enable-xss-auditor\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_enable_xss_auditor_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "fantasy-font-family")]
  fn connect_fantasy_font_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_fantasy_font_family_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::fantasy-font-family\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_fantasy_font_family_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_16")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
  #[doc(alias = "hardware-acceleration-policy")]
  fn connect_hardware_acceleration_policy_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_hardware_acceleration_policy_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::hardware-acceleration-policy\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_hardware_acceleration_policy_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "javascript-can-access-clipboard")]
  fn connect_javascript_can_access_clipboard_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_javascript_can_access_clipboard_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::javascript-can-access-clipboard\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_javascript_can_access_clipboard_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "javascript-can-open-windows-automatically")]
  fn connect_javascript_can_open_windows_automatically_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_javascript_can_open_windows_automatically_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::javascript-can-open-windows-automatically\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_javascript_can_open_windows_automatically_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "load-icons-ignoring-image-load-setting")]
  fn connect_load_icons_ignoring_image_load_setting_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_load_icons_ignoring_image_load_setting_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::load-icons-ignoring-image-load-setting\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_load_icons_ignoring_image_load_setting_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_30")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
  #[doc(alias = "media-content-types-requiring-hardware-support")]
  fn connect_media_content_types_requiring_hardware_support_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_media_content_types_requiring_hardware_support_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::media-content-types-requiring-hardware-support\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_media_content_types_requiring_hardware_support_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "media-playback-allows-inline")]
  fn connect_media_playback_allows_inline_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_media_playback_allows_inline_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::media-playback-allows-inline\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_media_playback_allows_inline_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "media-playback-requires-user-gesture")]
  fn connect_media_playback_requires_user_gesture_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_media_playback_requires_user_gesture_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::media-playback-requires-user-gesture\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_media_playback_requires_user_gesture_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "minimum-font-size")]
  fn connect_minimum_font_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_minimum_font_size_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::minimum-font-size\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_minimum_font_size_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "monospace-font-family")]
  fn connect_monospace_font_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_monospace_font_family_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::monospace-font-family\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_monospace_font_family_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "pictograph-font-family")]
  fn connect_pictograph_font_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_pictograph_font_family_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::pictograph-font-family\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_pictograph_font_family_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "print-backgrounds")]
  fn connect_print_backgrounds_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_print_backgrounds_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::print-backgrounds\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_print_backgrounds_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "sans-serif-font-family")]
  fn connect_sans_serif_font_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_sans_serif_font_family_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::sans-serif-font-family\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_sans_serif_font_family_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "serif-font-family")]
  fn connect_serif_font_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_serif_font_family_trampoline<
      P: IsA<Settings>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::serif-font-family\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_serif_font_family_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "user-agent")]
  fn connect_user_agent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_user_agent_trampoline<P: IsA<Settings>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::user-agent\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_user_agent_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "zoom-text-only")]
  fn connect_zoom_text_only_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_zoom_text_only_trampoline<P: IsA<Settings>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitSettings,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(Settings::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::zoom-text-only\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_zoom_text_only_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }
}

impl<O: IsA<Settings>> SettingsExt for O {}
