/**********************************************************************
 * $list_prim_delays example -- C source code using ACC PLI routines
 *
 * C source to scan through a module and list the typical rise, fall
 * and turn-off delays of all primitives in a module.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $list_prim_delays(<module_instance>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_PrimDelays_checktf(),
 *              PLIbook_PrimDelays_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_PrimDelays_checktf,    /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_PrimDelays_calltf,     /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$list_prim_delays",           /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_PrimDelays_checktf()
{
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$list_prim_delays must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$list_prim_delays arg cannot be null.");
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$list_prim_delays arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_PrimDelays_calltf()
{
  handle module_h, prim_h;
  double rise, fall, toZ;
  static int three_state[7] = {accBufif0Gate,  accBufif1Gate,
                               accNotif0Gate,  accNotif1Gate, 
                               accTranif0Gate, accTranif1Gate, 0};

  acc_initialize();
  acc_configure(accDisplayWarnings, "true");

  acc_configure(accMinTypMaxDelays, "false");

  module_h = acc_handle_tfarg(1);
  io_printf("\nPrimitives in module %s:\n",
            acc_fetch_fullname(module_h));
  prim_h = null;    /* start with known value for target handle */
  while (prim_h = acc_next_primitive(module_h, prim_h)) {
    io_printf("  %-8s instance %-4s:  ",
              acc_fetch_defname(prim_h),
              acc_fetch_name(prim_h));
    if (acc_object_in_typelist(prim_h, three_state)) {
      acc_fetch_delays(prim_h, &rise, &fall, &toZ);
      io_printf("rise=%2.2f, fall=%2.2f, toZ=%2.2f\n", rise, fall, toZ);
    }
    else {
      acc_fetch_delays(prim_h, &rise, &fall);
      io_printf("rise=%2.2f, fall=%2.2f\n", rise, fall);
    }
  }
  acc_close();
  return(0);
}
/*********************************************************************/
