/**********************************************************************
 * $show_value example -- PLI application using VPI routines
 *
 * C source to print the name and current logic value of a net.
 *
 * Usage: $show_value(<signal_name>);
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

#include <stdlib.h>    /* ANSI C standard library */
#include <stdio.h>     /* ANSI C standard input/output library */
#include "vpi_user.h"  /* IEEE 1364 PLI VPI routine library  */
#include "veriuser.h"  /* IEEE 1364 PLI TF routine library    
                          (using TF routines for simulation control) */

/* prototypes of routines in this PLI application */
int PLIbook_ShowVal_compiletf(), PLIbook_ShowVal_calltf(); 

/**********************************************************************
 * $show_value Registration Data
 * (add this function name to the vlog_startup_routines array)
 *********************************************************************/
void PLIbook_ShowVal_register()
{
  s_vpi_systf_data tf_data;

  tf_data.type        = vpiSysTask;
  tf_data.tfname      = "$show_value";
  tf_data.calltf      = PLIbook_ShowVal_calltf;
  tf_data.compiletf   = PLIbook_ShowVal_compiletf;
  tf_data.sizetf      = NULL;
  vpi_register_systf(&tf_data);
  return;
}

/**********************************************************************
 * compiletf application
 *********************************************************************/
int PLIbook_ShowVal_compiletf(char *user_data)
{
  vpiHandle systf_handle, arg_iterator, arg_handle;
  int       arg_type;
  
  /* obtain a handle to the system task instance */
  systf_handle = vpi_handle(vpiSysTfCall, NULL);
  if (systf_handle == NULL) {
    vpi_printf("ERROR: $show_value failed to obtain systf handle\n");
    tf_dofinish(); /* abort simulation */
    return(0);
  }

  /* obtain handles to system task arguments */
  arg_iterator = vpi_iterate(vpiArgument, systf_handle);
  if (arg_iterator == NULL) {
    vpi_printf("ERROR: $show_value requires 1 argument\n");
    tf_dofinish(); /* abort simulation */
    return(0);
  }
  
  /* check the type of object in system task arguments */
  arg_handle = vpi_scan(arg_iterator);
  arg_type = vpi_get(vpiType, arg_handle);
  if (arg_type != vpiNet && arg_type != vpiReg) {
    vpi_printf("ERROR: $show_value arg must be a net or reg\n");
    vpi_free_object(arg_iterator); /* free iterator memory */
    tf_dofinish(); /* abort simulation */
    return(0);
  }

  /* check that there are no more system task arguments */
  arg_handle = vpi_scan(arg_iterator);
  if (arg_handle != NULL) {
    vpi_printf("ERROR: $show_value can only have 1 argument\n");
    vpi_free_object(arg_iterator); /* free iterator memory */
    tf_dofinish(); /* abort simulation */
    return(0);
  }
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_ShowVal_calltf(char *user_data)
{
  vpiHandle   systf_handle, arg_iterator, arg_handle, net_handle;
  s_vpi_value current_value;

  /* obtain a handle to the system task instance */
  systf_handle = vpi_handle(vpiSysTfCall, NULL);

  /* obtain handle to system task argument
     compiletf has already verified only 1 arg with correct type */
  arg_iterator = vpi_iterate(vpiArgument, systf_handle);
  net_handle = vpi_scan(arg_iterator);
  vpi_free_object(arg_iterator);  /* free iterator memory */

  /* read current value */
  current_value.format = vpiBinStrVal; /* read value as a string */
  vpi_get_value(net_handle, &current_value);
  vpi_printf("Signal %s has the value %s\n",
              vpi_get_str(vpiFullName, net_handle),
              current_value.value.str);
  return(0);
}
/*********************************************************************/
