# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
# pylint: disable=unused-import,ungrouped-imports
from typing import Any

from ._generated import (
    Deserializer,
    Serializer
)

from . import _models
from . import _enums

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object

client_models = {k:v for k,v in _models.__dict__.items() if isinstance(v, type)}
client_models.update({k:v for k,v in _enums.__dict__.items() if isinstance(v, type)})

_SERIALIZER = Serializer(client_models)
_DESERIALIZER = Deserializer(client_models)

def _serialize_to_json(target_obj, data_type: str) -> JSON:
    return _SERIALIZER.body(target_obj, data_type, is_xml=False)  # pylint:disable=protected-access

def _deserialize_from_json(identifier: str, json_response) -> Any:
    return _DESERIALIZER._deserialize(identifier, json_response) # pylint:disable=protected-access
