# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._web_site_management_client_enums import *


class AbnormalTimePeriod(msrest.serialization.Model):
    """Class representing Abnormal Time Period identified in diagnosis.

    :ivar start_time: Start time of the downtime.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the downtime.
    :vartype end_time: ~datetime.datetime
    :ivar events: List of Possible Cause of downtime.
    :vartype events: list[~azure.mgmt.web.v2021_01_15.models.DetectorAbnormalTimePeriod]
    :ivar solutions: List of proposed solutions.
    :vartype solutions: list[~azure.mgmt.web.v2021_01_15.models.Solution]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'events': {'key': 'events', 'type': '[DetectorAbnormalTimePeriod]'},
        'solutions': {'key': 'solutions', 'type': '[Solution]'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        events: Optional[List["DetectorAbnormalTimePeriod"]] = None,
        solutions: Optional[List["Solution"]] = None,
        **kwargs
    ):
        """
        :keyword start_time: Start time of the downtime.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the downtime.
        :paramtype end_time: ~datetime.datetime
        :keyword events: List of Possible Cause of downtime.
        :paramtype events: list[~azure.mgmt.web.v2021_01_15.models.DetectorAbnormalTimePeriod]
        :keyword solutions: List of proposed solutions.
        :paramtype solutions: list[~azure.mgmt.web.v2021_01_15.models.Solution]
        """
        super(AbnormalTimePeriod, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.events = events
        self.solutions = solutions


class Address(msrest.serialization.Model):
    """Address information for domain registration.

    All required parameters must be populated in order to send to Azure.

    :ivar address1: Required. First line of an Address.
    :vartype address1: str
    :ivar address2: The second line of the Address. Optional.
    :vartype address2: str
    :ivar city: Required. The city for the address.
    :vartype city: str
    :ivar country: Required. The country for the address.
    :vartype country: str
    :ivar postal_code: Required. The postal code for the address.
    :vartype postal_code: str
    :ivar state: Required. The state or province for the address.
    :vartype state: str
    """

    _validation = {
        'address1': {'required': True},
        'city': {'required': True},
        'country': {'required': True},
        'postal_code': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'address1': {'key': 'address1', 'type': 'str'},
        'address2': {'key': 'address2', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        address1: str,
        city: str,
        country: str,
        postal_code: str,
        state: str,
        address2: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword address1: Required. First line of an Address.
        :paramtype address1: str
        :keyword address2: The second line of the Address. Optional.
        :paramtype address2: str
        :keyword city: Required. The city for the address.
        :paramtype city: str
        :keyword country: Required. The country for the address.
        :paramtype country: str
        :keyword postal_code: Required. The postal code for the address.
        :paramtype postal_code: str
        :keyword state: Required. The state or province for the address.
        :paramtype state: str
        """
        super(Address, self).__init__(**kwargs)
        self.address1 = address1
        self.address2 = address2
        self.city = city
        self.country = country
        self.postal_code = postal_code
        self.state = state


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class AddressResponse(ProxyOnlyResource):
    """Describes main public IP address and any extra virtual IPs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_ip_address: Main public virtual IP.
    :vartype service_ip_address: str
    :ivar internal_ip_address: Virtual Network internal IP address of the App Service Environment
     if it is in internal load-balancing mode.
    :vartype internal_ip_address: str
    :ivar outbound_ip_addresses: IP addresses appearing on outbound connections.
    :vartype outbound_ip_addresses: list[str]
    :ivar vip_mappings: Additional virtual IPs.
    :vartype vip_mappings: list[~azure.mgmt.web.v2021_01_15.models.VirtualIPMapping]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_ip_address': {'key': 'properties.serviceIpAddress', 'type': 'str'},
        'internal_ip_address': {'key': 'properties.internalIpAddress', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': '[str]'},
        'vip_mappings': {'key': 'properties.vipMappings', 'type': '[VirtualIPMapping]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_ip_address: Optional[str] = None,
        internal_ip_address: Optional[str] = None,
        outbound_ip_addresses: Optional[List[str]] = None,
        vip_mappings: Optional[List["VirtualIPMapping"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_ip_address: Main public virtual IP.
        :paramtype service_ip_address: str
        :keyword internal_ip_address: Virtual Network internal IP address of the App Service
         Environment if it is in internal load-balancing mode.
        :paramtype internal_ip_address: str
        :keyword outbound_ip_addresses: IP addresses appearing on outbound connections.
        :paramtype outbound_ip_addresses: list[str]
        :keyword vip_mappings: Additional virtual IPs.
        :paramtype vip_mappings: list[~azure.mgmt.web.v2021_01_15.models.VirtualIPMapping]
        """
        super(AddressResponse, self).__init__(kind=kind, **kwargs)
        self.service_ip_address = service_ip_address
        self.internal_ip_address = internal_ip_address
        self.outbound_ip_addresses = outbound_ip_addresses
        self.vip_mappings = vip_mappings


class AllowedAudiencesValidation(msrest.serialization.Model):
    """The configuration settings of the Allowed Audiences validation flow.

    :ivar allowed_audiences: The configuration settings of the allowed list of audiences from which
     to validate the JWT token.
    :vartype allowed_audiences: list[str]
    """

    _attribute_map = {
        'allowed_audiences': {'key': 'allowedAudiences', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        allowed_audiences: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword allowed_audiences: The configuration settings of the allowed list of audiences from
         which to validate the JWT token.
        :paramtype allowed_audiences: list[str]
        """
        super(AllowedAudiencesValidation, self).__init__(**kwargs)
        self.allowed_audiences = allowed_audiences


class AnalysisData(msrest.serialization.Model):
    """Class Representing Detector Evidence used for analysis.

    :ivar source: Name of the Detector.
    :vartype source: str
    :ivar detector_definition: Detector Definition.
    :vartype detector_definition: ~azure.mgmt.web.v2021_01_15.models.DetectorDefinition
    :ivar metrics: Source Metrics.
    :vartype metrics: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticMetricSet]
    :ivar data: Additional Source Data.
    :vartype data: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
    :ivar detector_meta_data: Detector Meta Data.
    :vartype detector_meta_data: ~azure.mgmt.web.v2021_01_15.models.ResponseMetaData
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'detector_definition': {'key': 'detectorDefinition', 'type': 'DetectorDefinition'},
        'metrics': {'key': 'metrics', 'type': '[DiagnosticMetricSet]'},
        'data': {'key': 'data', 'type': '[[NameValuePair]]'},
        'detector_meta_data': {'key': 'detectorMetaData', 'type': 'ResponseMetaData'},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        detector_definition: Optional["DetectorDefinition"] = None,
        metrics: Optional[List["DiagnosticMetricSet"]] = None,
        data: Optional[List[List["NameValuePair"]]] = None,
        detector_meta_data: Optional["ResponseMetaData"] = None,
        **kwargs
    ):
        """
        :keyword source: Name of the Detector.
        :paramtype source: str
        :keyword detector_definition: Detector Definition.
        :paramtype detector_definition: ~azure.mgmt.web.v2021_01_15.models.DetectorDefinition
        :keyword metrics: Source Metrics.
        :paramtype metrics: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticMetricSet]
        :keyword data: Additional Source Data.
        :paramtype data: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
        :keyword detector_meta_data: Detector Meta Data.
        :paramtype detector_meta_data: ~azure.mgmt.web.v2021_01_15.models.ResponseMetaData
        """
        super(AnalysisData, self).__init__(**kwargs)
        self.source = source
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.data = data
        self.detector_meta_data = detector_meta_data


class AnalysisDefinition(ProxyOnlyResource):
    """Definition of Analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the Analysis.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(AnalysisDefinition, self).__init__(kind=kind, **kwargs)
        self.description = None


class ApiDefinitionInfo(msrest.serialization.Model):
    """Information about the formal API definition for the app.

    :ivar url: The URL of the API definition.
    :vartype url: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword url: The URL of the API definition.
        :paramtype url: str
        """
        super(ApiDefinitionInfo, self).__init__(**kwargs)
        self.url = url


class ApiKVReference(ProxyOnlyResource):
    """Description of site key vault references.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar reference:
    :vartype reference: str
    :ivar status: Possible values include: "Initialized", "Resolved", "InvalidSyntax",
     "MSINotEnabled", "VaultNotFound", "SecretNotFound", "SecretVersionNotFound",
     "AccessToKeyVaultDenied", "OtherReasons", "FetchTimedOut", "UnauthorizedClient".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.ResolveStatus
    :ivar vault_name:
    :vartype vault_name: str
    :ivar secret_name:
    :vartype secret_name: str
    :ivar secret_version:
    :vartype secret_version: str
    :ivar identity_type: Managed service identity.
    :vartype identity_type: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
    :ivar details:
    :vartype details: str
    :ivar source:  The only acceptable values to pass in are None and "KeyVault". The default value
     is None.
    :vartype source: str
    :ivar active_version:
    :vartype active_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'reference': {'key': 'properties.reference', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
        'secret_name': {'key': 'properties.secretName', 'type': 'str'},
        'secret_version': {'key': 'properties.secretVersion', 'type': 'str'},
        'identity_type': {'key': 'properties.identityType', 'type': 'ManagedServiceIdentity'},
        'details': {'key': 'properties.details', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'active_version': {'key': 'properties.activeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        reference: Optional[str] = None,
        status: Optional[Union[str, "ResolveStatus"]] = None,
        vault_name: Optional[str] = None,
        secret_name: Optional[str] = None,
        secret_version: Optional[str] = None,
        identity_type: Optional["ManagedServiceIdentity"] = None,
        details: Optional[str] = None,
        source: Optional[str] = None,
        active_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword reference:
        :paramtype reference: str
        :keyword status: Possible values include: "Initialized", "Resolved", "InvalidSyntax",
         "MSINotEnabled", "VaultNotFound", "SecretNotFound", "SecretVersionNotFound",
         "AccessToKeyVaultDenied", "OtherReasons", "FetchTimedOut", "UnauthorizedClient".
        :paramtype status: str or ~azure.mgmt.web.v2021_01_15.models.ResolveStatus
        :keyword vault_name:
        :paramtype vault_name: str
        :keyword secret_name:
        :paramtype secret_name: str
        :keyword secret_version:
        :paramtype secret_version: str
        :keyword identity_type: Managed service identity.
        :paramtype identity_type: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
        :keyword details:
        :paramtype details: str
        :keyword source:  The only acceptable values to pass in are None and "KeyVault". The default
         value is None.
        :paramtype source: str
        :keyword active_version:
        :paramtype active_version: str
        """
        super(ApiKVReference, self).__init__(kind=kind, **kwargs)
        self.reference = reference
        self.status = status
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.identity_type = identity_type
        self.details = details
        self.source = source
        self.active_version = active_version


class ApiKVReferenceCollection(msrest.serialization.Model):
    """ApiKVReferenceCollection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.ApiKVReference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiKVReference]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ApiKVReference"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.ApiKVReference]
        """
        super(ApiKVReferenceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApiManagementConfig(msrest.serialization.Model):
    """Azure API management (APIM) configuration linked to the app.

    :ivar id: APIM-Api Identifier.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: APIM-Api Identifier.
        :paramtype id: str
        """
        super(ApiManagementConfig, self).__init__(**kwargs)
        self.id = id


class AppInsightsWebAppStackSettings(msrest.serialization.Model):
    """App Insights Web App stack settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_supported: :code:`<code>true</code>` if remote Application Insights is supported for
     the stack; otherwise, :code:`<code>false</code>`.
    :vartype is_supported: bool
    :ivar is_default_off: :code:`<code>true</code>` if Application Insights is disabled by default
     for the stack; otherwise, :code:`<code>false</code>`.
    :vartype is_default_off: bool
    """

    _validation = {
        'is_supported': {'readonly': True},
        'is_default_off': {'readonly': True},
    }

    _attribute_map = {
        'is_supported': {'key': 'isSupported', 'type': 'bool'},
        'is_default_off': {'key': 'isDefaultOff', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AppInsightsWebAppStackSettings, self).__init__(**kwargs)
        self.is_supported = None
        self.is_default_off = None


class Apple(msrest.serialization.Model):
    """The configuration settings of the Apple provider.

    :ivar enabled: :code:`<code>false</code>` if the Apple provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Apple registration.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.AppleRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AppleRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["AppleRegistration"] = None,
        login: Optional["LoginScopes"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Apple provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Apple registration.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.AppleRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
        """
        super(Apple, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class AppleRegistration(msrest.serialization.Model):
    """The configuration settings of the registration for the Apple provider.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret.
        :paramtype client_secret_setting_name: str
        """
        super(AppleRegistration, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name


class ApplicationLogsConfig(msrest.serialization.Model):
    """Application logs configuration.

    :ivar file_system: Application logs to file system configuration.
    :vartype file_system: ~azure.mgmt.web.v2021_01_15.models.FileSystemApplicationLogsConfig
    :ivar azure_table_storage: Application logs to azure table storage configuration.
    :vartype azure_table_storage:
     ~azure.mgmt.web.v2021_01_15.models.AzureTableStorageApplicationLogsConfig
    :ivar azure_blob_storage: Application logs to blob storage configuration.
    :vartype azure_blob_storage:
     ~azure.mgmt.web.v2021_01_15.models.AzureBlobStorageApplicationLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemApplicationLogsConfig'},
        'azure_table_storage': {'key': 'azureTableStorage', 'type': 'AzureTableStorageApplicationLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageApplicationLogsConfig'},
    }

    def __init__(
        self,
        *,
        file_system: Optional["FileSystemApplicationLogsConfig"] = None,
        azure_table_storage: Optional["AzureTableStorageApplicationLogsConfig"] = None,
        azure_blob_storage: Optional["AzureBlobStorageApplicationLogsConfig"] = None,
        **kwargs
    ):
        """
        :keyword file_system: Application logs to file system configuration.
        :paramtype file_system: ~azure.mgmt.web.v2021_01_15.models.FileSystemApplicationLogsConfig
        :keyword azure_table_storage: Application logs to azure table storage configuration.
        :paramtype azure_table_storage:
         ~azure.mgmt.web.v2021_01_15.models.AzureTableStorageApplicationLogsConfig
        :keyword azure_blob_storage: Application logs to blob storage configuration.
        :paramtype azure_blob_storage:
         ~azure.mgmt.web.v2021_01_15.models.AzureBlobStorageApplicationLogsConfig
        """
        super(ApplicationLogsConfig, self).__init__(**kwargs)
        self.file_system = file_system
        self.azure_table_storage = azure_table_storage
        self.azure_blob_storage = azure_blob_storage


class ApplicationStack(msrest.serialization.Model):
    """Application stack.

    :ivar name: Application stack name.
    :vartype name: str
    :ivar display: Application stack display name.
    :vartype display: str
    :ivar dependency: Application stack dependency.
    :vartype dependency: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2021_01_15.models.StackMajorVersion]
    :ivar frameworks: List of frameworks associated with application stack.
    :vartype frameworks: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStack]
    :ivar is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStack]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'str'},
        'dependency': {'key': 'dependency', 'type': 'str'},
        'major_versions': {'key': 'majorVersions', 'type': '[StackMajorVersion]'},
        'frameworks': {'key': 'frameworks', 'type': '[ApplicationStack]'},
        'is_deprecated': {'key': 'isDeprecated', 'type': '[ApplicationStack]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional[str] = None,
        dependency: Optional[str] = None,
        major_versions: Optional[List["StackMajorVersion"]] = None,
        frameworks: Optional[List["ApplicationStack"]] = None,
        is_deprecated: Optional[List["ApplicationStack"]] = None,
        **kwargs
    ):
        """
        :keyword name: Application stack name.
        :paramtype name: str
        :keyword display: Application stack display name.
        :paramtype display: str
        :keyword dependency: Application stack dependency.
        :paramtype dependency: str
        :keyword major_versions: List of major versions available.
        :paramtype major_versions: list[~azure.mgmt.web.v2021_01_15.models.StackMajorVersion]
        :keyword frameworks: List of frameworks associated with application stack.
        :paramtype frameworks: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStack]
        :keyword is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated;
         otherwise, :code:`<code>false</code>`.
        :paramtype is_deprecated: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStack]
        """
        super(ApplicationStack, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.dependency = dependency
        self.major_versions = major_versions
        self.frameworks = frameworks
        self.is_deprecated = is_deprecated


class ApplicationStackCollection(msrest.serialization.Model):
    """Collection of Application Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStackResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationStackResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ApplicationStackResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStackResource]
        """
        super(ApplicationStackCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationStackResource(ProxyOnlyResource):
    """ARM resource for a ApplicationStack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Application stack name.
    :vartype name_properties_name: str
    :ivar display: Application stack display name.
    :vartype display: str
    :ivar dependency: Application stack dependency.
    :vartype dependency: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2021_01_15.models.StackMajorVersion]
    :ivar frameworks: List of frameworks associated with application stack.
    :vartype frameworks: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStack]
    :ivar is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStack]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'display': {'key': 'properties.display', 'type': 'str'},
        'dependency': {'key': 'properties.dependency', 'type': 'str'},
        'major_versions': {'key': 'properties.majorVersions', 'type': '[StackMajorVersion]'},
        'frameworks': {'key': 'properties.frameworks', 'type': '[ApplicationStack]'},
        'is_deprecated': {'key': 'properties.isDeprecated', 'type': '[ApplicationStack]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        display: Optional[str] = None,
        dependency: Optional[str] = None,
        major_versions: Optional[List["StackMajorVersion"]] = None,
        frameworks: Optional[List["ApplicationStack"]] = None,
        is_deprecated: Optional[List["ApplicationStack"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword name_properties_name: Application stack name.
        :paramtype name_properties_name: str
        :keyword display: Application stack display name.
        :paramtype display: str
        :keyword dependency: Application stack dependency.
        :paramtype dependency: str
        :keyword major_versions: List of major versions available.
        :paramtype major_versions: list[~azure.mgmt.web.v2021_01_15.models.StackMajorVersion]
        :keyword frameworks: List of frameworks associated with application stack.
        :paramtype frameworks: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStack]
        :keyword is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated;
         otherwise, :code:`<code>false</code>`.
        :paramtype is_deprecated: list[~azure.mgmt.web.v2021_01_15.models.ApplicationStack]
        """
        super(ApplicationStackResource, self).__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.display = display
        self.dependency = dependency
        self.major_versions = major_versions
        self.frameworks = frameworks
        self.is_deprecated = is_deprecated


class AppLogsConfiguration(msrest.serialization.Model):
    """AppLogsConfiguration.

    :ivar destination:
    :vartype destination: str
    :ivar log_analytics_configuration:
    :vartype log_analytics_configuration:
     ~azure.mgmt.web.v2021_01_15.models.LogAnalyticsConfiguration
    """

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'str'},
        'log_analytics_configuration': {'key': 'logAnalyticsConfiguration', 'type': 'LogAnalyticsConfiguration'},
    }

    def __init__(
        self,
        *,
        destination: Optional[str] = None,
        log_analytics_configuration: Optional["LogAnalyticsConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword destination:
        :paramtype destination: str
        :keyword log_analytics_configuration:
        :paramtype log_analytics_configuration:
         ~azure.mgmt.web.v2021_01_15.models.LogAnalyticsConfiguration
        """
        super(AppLogsConfiguration, self).__init__(**kwargs)
        self.destination = destination
        self.log_analytics_configuration = log_analytics_configuration


class AppRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for providers that have app ids and app secrets.

    :ivar app_id: The App ID of the app used for login.
    :vartype app_id: str
    :ivar app_secret_setting_name: The app setting name that contains the app secret.
    :vartype app_secret_setting_name: str
    """

    _attribute_map = {
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_secret_setting_name': {'key': 'appSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_id: Optional[str] = None,
        app_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword app_id: The App ID of the app used for login.
        :paramtype app_id: str
        :keyword app_secret_setting_name: The app setting name that contains the app secret.
        :paramtype app_secret_setting_name: str
        """
        super(AppRegistration, self).__init__(**kwargs)
        self.app_id = app_id
        self.app_secret_setting_name = app_secret_setting_name


class AppServiceCertificate(msrest.serialization.Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.KeyVaultSecretStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super(AppServiceCertificate, self).__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateCollection(msrest.serialization.Model):
    """Collection of certificate order certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.AppServiceCertificateResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceCertificateResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceCertificateResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.AppServiceCertificateResource]
        """
        super(AppServiceCertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class AppServiceCertificateOrder(Resource):
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str, ~azure.mgmt.web.v2021_01_15.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be 1).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Possible values include:
     "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.web.v2021_01_15.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar status: Current order status. Possible values include: "Pendingissuance", "Issued",
     "Revoked", "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired",
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2021_01_15.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2021_01_15.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2021_01_15.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2021_01_15.models.AppServiceCertificateOrderPropertiesAppServiceCertificateNotRenewableReasonsItem]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    :ivar contact: Contact info.
    :vartype contact: ~azure.mgmt.web.v2021_01_15.models.CertificateOrderContact
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
        'contact': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
        'contact': {'key': 'properties.contact', 'type': 'CertificateOrderContact'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        certificates: Optional[Dict[str, "AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: Optional[int] = 1,
        key_size: Optional[int] = 2048,
        product_type: Optional[Union[str, "CertificateProductType"]] = None,
        auto_renew: Optional[bool] = True,
        csr: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str, ~azure.mgmt.web.v2021_01_15.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be 1).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Possible values include:
         "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or ~azure.mgmt.web.v2021_01_15.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super(AppServiceCertificateOrder, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None
        self.contact = None


class AppServiceCertificateOrderCollection(msrest.serialization.Model):
    """Collection of certificate orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.AppServiceCertificateOrder]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceCertificateOrder]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceCertificateOrder"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.AppServiceCertificateOrder]
        """
        super(AppServiceCertificateOrderCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str, ~azure.mgmt.web.v2021_01_15.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be 1).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Possible values include:
     "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.web.v2021_01_15.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar status: Current order status. Possible values include: "Pendingissuance", "Issued",
     "Revoked", "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired",
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2021_01_15.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2021_01_15.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2021_01_15.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2021_01_15.models.AppServiceCertificateOrderPatchResourcePropertiesAppServiceCertificateNotRenewableReasonsItem]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    :ivar contact: Contact info.
    :vartype contact: ~azure.mgmt.web.v2021_01_15.models.CertificateOrderContact
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
        'contact': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
        'contact': {'key': 'properties.contact', 'type': 'CertificateOrderContact'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        certificates: Optional[Dict[str, "AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: Optional[int] = 1,
        key_size: Optional[int] = 2048,
        product_type: Optional[Union[str, "CertificateProductType"]] = None,
        auto_renew: Optional[bool] = True,
        csr: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str, ~azure.mgmt.web.v2021_01_15.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be 1).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Possible values include:
         "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or ~azure.mgmt.web.v2021_01_15.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super(AppServiceCertificateOrderPatchResource, self).__init__(kind=kind, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None
        self.contact = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super(AppServiceCertificatePatchResource, self).__init__(kind=kind, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super(AppServiceCertificateResource, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceEnvironment(msrest.serialization.Model):
    """Description of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentStatus
    :ivar virtual_network: Required. Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2021_01_15.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing", "Web, Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2021_01_15.models.LoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'virtual_network': {'required': True},
        'multi_role_count': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'suspended': {'readonly': True},
        'has_linux_workers': {'readonly': True},
        'dedicated_host_count': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'virtual_network': {'key': 'virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'multiRoleCount', 'type': 'int'},
        'ipssl_address_count': {'key': 'ipsslAddressCount', 'type': 'int'},
        'dns_suffix': {'key': 'dnsSuffix', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'maximumNumberOfMachines', 'type': 'int'},
        'front_end_scale_factor': {'key': 'frontEndScaleFactor', 'type': 'int'},
        'suspended': {'key': 'suspended', 'type': 'bool'},
        'cluster_settings': {'key': 'clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'hasLinuxWorkers', 'type': 'bool'},
        'dedicated_host_count': {'key': 'dedicatedHostCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        virtual_network: "VirtualNetworkProfile",
        internal_load_balancing_mode: Optional[Union[str, "LoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        front_end_scale_factor: Optional[int] = None,
        cluster_settings: Optional[List["NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword virtual_network: Required. Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2021_01_15.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Possible values include: "None", "Web",
         "Publishing", "Web, Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2021_01_15.models.LoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        """
        super(AppServiceEnvironment, self).__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = None
        self.ipssl_address_count = ipssl_address_count
        self.dns_suffix = dns_suffix
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = front_end_scale_factor
        self.suspended = None
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = None
        self.dedicated_host_count = None


class AppServiceEnvironmentCollection(msrest.serialization.Model):
    """Collection of App Service Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.AppServiceEnvironmentResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceEnvironmentResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServiceEnvironmentResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.AppServiceEnvironmentResource]
        """
        super(AppServiceEnvironmentCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServiceEnvironmentPatchResource(ProxyOnlyResource):
    """ARM resource for a app service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentStatus
    :ivar virtual_network: Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2021_01_15.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing", "Web, Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2021_01_15.models.LoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'multi_role_count': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'suspended': {'readonly': True},
        'has_linux_workers': {'readonly': True},
        'dedicated_host_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'properties.internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'properties.multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'properties.multiRoleCount', 'type': 'int'},
        'ipssl_address_count': {'key': 'properties.ipsslAddressCount', 'type': 'int'},
        'dns_suffix': {'key': 'properties.dnsSuffix', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'properties.maximumNumberOfMachines', 'type': 'int'},
        'front_end_scale_factor': {'key': 'properties.frontEndScaleFactor', 'type': 'int'},
        'suspended': {'key': 'properties.suspended', 'type': 'bool'},
        'cluster_settings': {'key': 'properties.clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'properties.userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'properties.hasLinuxWorkers', 'type': 'bool'},
        'dedicated_host_count': {'key': 'properties.dedicatedHostCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        virtual_network: Optional["VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "LoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        front_end_scale_factor: Optional[int] = None,
        cluster_settings: Optional[List["NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword virtual_network: Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2021_01_15.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Possible values include: "None", "Web",
         "Publishing", "Web, Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2021_01_15.models.LoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        """
        super(AppServiceEnvironmentPatchResource, self).__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = None
        self.ipssl_address_count = ipssl_address_count
        self.dns_suffix = dns_suffix
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = front_end_scale_factor
        self.suspended = None
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = None
        self.dedicated_host_count = None


class AppServiceEnvironmentResource(Resource):
    """App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentStatus
    :ivar virtual_network: Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2021_01_15.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing", "Web, Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2021_01_15.models.LoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'multi_role_count': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'suspended': {'readonly': True},
        'has_linux_workers': {'readonly': True},
        'dedicated_host_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'properties.internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'properties.multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'properties.multiRoleCount', 'type': 'int'},
        'ipssl_address_count': {'key': 'properties.ipsslAddressCount', 'type': 'int'},
        'dns_suffix': {'key': 'properties.dnsSuffix', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'properties.maximumNumberOfMachines', 'type': 'int'},
        'front_end_scale_factor': {'key': 'properties.frontEndScaleFactor', 'type': 'int'},
        'suspended': {'key': 'properties.suspended', 'type': 'bool'},
        'cluster_settings': {'key': 'properties.clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'properties.userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'properties.hasLinuxWorkers', 'type': 'bool'},
        'dedicated_host_count': {'key': 'properties.dedicatedHostCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        virtual_network: Optional["VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "LoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        front_end_scale_factor: Optional[int] = None,
        cluster_settings: Optional[List["NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword virtual_network: Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2021_01_15.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Possible values include: "None", "Web",
         "Publishing", "Web, Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2021_01_15.models.LoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        """
        super(AppServiceEnvironmentResource, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = None
        self.ipssl_address_count = ipssl_address_count
        self.dns_suffix = dns_suffix
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = front_end_scale_factor
        self.suspended = None
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers = None
        self.dedicated_host_count = None


class AppserviceGithubToken(msrest.serialization.Model):
    """Github access token for Appservice CLI github integration.

    :ivar access_token: Github access token for Appservice CLI github integration.
    :vartype access_token: str
    :ivar scope: Scope of the github access token.
    :vartype scope: str
    :ivar token_type: token type.
    :vartype token_type: str
    :ivar got_token: True if valid github token received, False otherwise.
    :vartype got_token: bool
    :ivar error_message: Error message if unable to get token.
    :vartype error_message: str
    """

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'got_token': {'key': 'gotToken', 'type': 'bool'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
        scope: Optional[str] = None,
        token_type: Optional[str] = None,
        got_token: Optional[bool] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword access_token: Github access token for Appservice CLI github integration.
        :paramtype access_token: str
        :keyword scope: Scope of the github access token.
        :paramtype scope: str
        :keyword token_type: token type.
        :paramtype token_type: str
        :keyword got_token: True if valid github token received, False otherwise.
        :paramtype got_token: bool
        :keyword error_message: Error message if unable to get token.
        :paramtype error_message: str
        """
        super(AppserviceGithubToken, self).__init__(**kwargs)
        self.access_token = access_token
        self.scope = scope
        self.token_type = token_type
        self.got_token = got_token
        self.error_message = error_message


class AppserviceGithubTokenRequest(msrest.serialization.Model):
    """Appservice Github token request content.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Code string to exchange for Github Access token.
    :vartype code: str
    :ivar state: Required. State string used for verification.
    :vartype state: str
    """

    _validation = {
        'code': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        state: str,
        **kwargs
    ):
        """
        :keyword code: Required. Code string to exchange for Github Access token.
        :paramtype code: str
        :keyword state: Required. State string used for verification.
        :paramtype state: str
        """
        super(AppserviceGithubTokenRequest, self).__init__(**kwargs)
        self.code = code
        self.state = state


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.web.v2021_01_15.models.SkuDescription
    :ivar extended_location: Extended Location.
    :vartype extended_location: ~azure.mgmt.web.v2021_01_15.models.ExtendedLocation
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: "Ready", "Pending", "Creating".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale as
     if the ServerFarm was ElasticPremium sku.
    :vartype elastic_scale_enabled: bool
    :ivar maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :vartype maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar free_offer_expiration_time: The time when the server farm free offer expires.
    :vartype free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype is_xenon: bool
    :ivar hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype hyper_v: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Plan. Possible values include:
     "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar kube_environment_profile: Specification for the Kubernetes Environment to use for the App
     Service plan.
    :vartype kube_environment_profile: ~azure.mgmt.web.v2021_01_15.models.KubeEnvironmentProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'elastic_scale_enabled': {'key': 'properties.elasticScaleEnabled', 'type': 'bool'},
        'maximum_elastic_worker_count': {'key': 'properties.maximumElasticWorkerCount', 'type': 'int'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'free_offer_expiration_time': {'key': 'properties.freeOfferExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'kube_environment_profile': {'key': 'properties.kubeEnvironmentProfile', 'type': 'KubeEnvironmentProfile'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["SkuDescription"] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["HostingEnvironmentProfile"] = None,
        per_site_scaling: Optional[bool] = False,
        elastic_scale_enabled: Optional[bool] = None,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: Optional[bool] = False,
        is_xenon: Optional[bool] = False,
        hyper_v: Optional[bool] = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        kube_environment_profile: Optional["KubeEnvironmentProfile"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.web.v2021_01_15.models.SkuDescription
        :keyword extended_location: Extended Location.
        :paramtype extended_location: ~azure.mgmt.web.v2021_01_15.models.ExtendedLocation
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale
         as if the ServerFarm was ElasticPremium sku.
        :paramtype elastic_scale_enabled: bool
        :keyword maximum_elastic_worker_count: Maximum number of total workers allowed for this
         ElasticScaleEnabled App Service Plan.
        :paramtype maximum_elastic_worker_count: int
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword free_offer_expiration_time: The time when the server farm free offer expires.
        :paramtype free_offer_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype is_xenon: bool
        :keyword hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype hyper_v: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        :keyword kube_environment_profile: Specification for the Kubernetes Environment to use for the
         App Service plan.
        :paramtype kube_environment_profile: ~azure.mgmt.web.v2021_01_15.models.KubeEnvironmentProfile
        """
        super(AppServicePlan, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.extended_location = extended_location
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.elastic_scale_enabled = elastic_scale_enabled
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None
        self.kube_environment_profile = kube_environment_profile


class AppServicePlanCollection(msrest.serialization.Model):
    """Collection of App Service plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.AppServicePlan]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServicePlan]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AppServicePlan"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.AppServicePlan]
        """
        super(AppServicePlanCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AppServicePlanPatchResource(ProxyOnlyResource):
    """ARM resource for a app service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: "Ready", "Pending", "Creating".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale as
     if the ServerFarm was ElasticPremium sku.
    :vartype elastic_scale_enabled: bool
    :ivar maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :vartype maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar free_offer_expiration_time: The time when the server farm free offer expires.
    :vartype free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype is_xenon: bool
    :ivar hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype hyper_v: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Plan. Possible values include:
     "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar kube_environment_profile: Specification for the Kubernetes Environment to use for the App
     Service plan.
    :vartype kube_environment_profile: ~azure.mgmt.web.v2021_01_15.models.KubeEnvironmentProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'elastic_scale_enabled': {'key': 'properties.elasticScaleEnabled', 'type': 'bool'},
        'maximum_elastic_worker_count': {'key': 'properties.maximumElasticWorkerCount', 'type': 'int'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'free_offer_expiration_time': {'key': 'properties.freeOfferExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'kube_environment_profile': {'key': 'properties.kubeEnvironmentProfile', 'type': 'KubeEnvironmentProfile'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["HostingEnvironmentProfile"] = None,
        per_site_scaling: Optional[bool] = False,
        elastic_scale_enabled: Optional[bool] = None,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: Optional[bool] = False,
        is_xenon: Optional[bool] = False,
        hyper_v: Optional[bool] = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        kube_environment_profile: Optional["KubeEnvironmentProfile"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale
         as if the ServerFarm was ElasticPremium sku.
        :paramtype elastic_scale_enabled: bool
        :keyword maximum_elastic_worker_count: Maximum number of total workers allowed for this
         ElasticScaleEnabled App Service Plan.
        :paramtype maximum_elastic_worker_count: int
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword free_offer_expiration_time: The time when the server farm free offer expires.
        :paramtype free_offer_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype is_xenon: bool
        :keyword hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype hyper_v: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        :keyword kube_environment_profile: Specification for the Kubernetes Environment to use for the
         App Service plan.
        :paramtype kube_environment_profile: ~azure.mgmt.web.v2021_01_15.models.KubeEnvironmentProfile
        """
        super(AppServicePlanPatchResource, self).__init__(kind=kind, **kwargs)
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.elastic_scale_enabled = elastic_scale_enabled
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None
        self.kube_environment_profile = kube_environment_profile


class ArcConfiguration(msrest.serialization.Model):
    """ArcConfiguration.

    :ivar artifacts_storage_type: Possible values include: "LocalNode", "NetworkFileSystem".
    :vartype artifacts_storage_type: str or ~azure.mgmt.web.v2021_01_15.models.StorageType
    :ivar artifact_storage_class_name:
    :vartype artifact_storage_class_name: str
    :ivar artifact_storage_mount_path:
    :vartype artifact_storage_mount_path: str
    :ivar artifact_storage_node_name:
    :vartype artifact_storage_node_name: str
    :ivar artifact_storage_access_mode:
    :vartype artifact_storage_access_mode: str
    :ivar front_end_service_configuration:
    :vartype front_end_service_configuration:
     ~azure.mgmt.web.v2021_01_15.models.FrontEndConfiguration
    :ivar kube_config:
    :vartype kube_config: str
    """

    _attribute_map = {
        'artifacts_storage_type': {'key': 'artifactsStorageType', 'type': 'str'},
        'artifact_storage_class_name': {'key': 'artifactStorageClassName', 'type': 'str'},
        'artifact_storage_mount_path': {'key': 'artifactStorageMountPath', 'type': 'str'},
        'artifact_storage_node_name': {'key': 'artifactStorageNodeName', 'type': 'str'},
        'artifact_storage_access_mode': {'key': 'artifactStorageAccessMode', 'type': 'str'},
        'front_end_service_configuration': {'key': 'frontEndServiceConfiguration', 'type': 'FrontEndConfiguration'},
        'kube_config': {'key': 'kubeConfig', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        artifacts_storage_type: Optional[Union[str, "StorageType"]] = None,
        artifact_storage_class_name: Optional[str] = None,
        artifact_storage_mount_path: Optional[str] = None,
        artifact_storage_node_name: Optional[str] = None,
        artifact_storage_access_mode: Optional[str] = None,
        front_end_service_configuration: Optional["FrontEndConfiguration"] = None,
        kube_config: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword artifacts_storage_type: Possible values include: "LocalNode", "NetworkFileSystem".
        :paramtype artifacts_storage_type: str or ~azure.mgmt.web.v2021_01_15.models.StorageType
        :keyword artifact_storage_class_name:
        :paramtype artifact_storage_class_name: str
        :keyword artifact_storage_mount_path:
        :paramtype artifact_storage_mount_path: str
        :keyword artifact_storage_node_name:
        :paramtype artifact_storage_node_name: str
        :keyword artifact_storage_access_mode:
        :paramtype artifact_storage_access_mode: str
        :keyword front_end_service_configuration:
        :paramtype front_end_service_configuration:
         ~azure.mgmt.web.v2021_01_15.models.FrontEndConfiguration
        :keyword kube_config:
        :paramtype kube_config: str
        """
        super(ArcConfiguration, self).__init__(**kwargs)
        self.artifacts_storage_type = artifacts_storage_type
        self.artifact_storage_class_name = artifact_storage_class_name
        self.artifact_storage_mount_path = artifact_storage_mount_path
        self.artifact_storage_node_name = artifact_storage_node_name
        self.artifact_storage_access_mode = artifact_storage_access_mode
        self.front_end_service_configuration = front_end_service_configuration
        self.kube_config = kube_config


class ArmIdWrapper(msrest.serialization.Model):
    """A wrapper for an ARM resource id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ArmIdWrapper, self).__init__(**kwargs)
        self.id = None


class ArmPlan(msrest.serialization.Model):
    """The plan object in Azure Resource Manager, represents a marketplace plan.

    :ivar name: The name.
    :vartype name: str
    :ivar publisher: The publisher.
    :vartype publisher: str
    :ivar product: The product.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar version: Version of product.
    :vartype version: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name.
        :paramtype name: str
        :keyword publisher: The publisher.
        :paramtype publisher: str
        :keyword product: The product.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        :keyword version: Version of product.
        :paramtype version: str
        """
        super(ArmPlan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class AseV3NetworkingConfiguration(ProxyOnlyResource):
    """Full view of networking configuration for an ASE.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar windows_outbound_ip_addresses:
    :vartype windows_outbound_ip_addresses: list[str]
    :ivar linux_outbound_ip_addresses:
    :vartype linux_outbound_ip_addresses: list[str]
    :ivar allow_new_private_endpoint_connections: Property to enable and disable new private
     endpoint connection creation on ASE.
    :vartype allow_new_private_endpoint_connections: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'windows_outbound_ip_addresses': {'readonly': True},
        'linux_outbound_ip_addresses': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'windows_outbound_ip_addresses': {'key': 'properties.windowsOutboundIpAddresses', 'type': '[str]'},
        'linux_outbound_ip_addresses': {'key': 'properties.linuxOutboundIpAddresses', 'type': '[str]'},
        'allow_new_private_endpoint_connections': {'key': 'properties.allowNewPrivateEndpointConnections', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        allow_new_private_endpoint_connections: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword allow_new_private_endpoint_connections: Property to enable and disable new private
         endpoint connection creation on ASE.
        :paramtype allow_new_private_endpoint_connections: bool
        """
        super(AseV3NetworkingConfiguration, self).__init__(kind=kind, **kwargs)
        self.windows_outbound_ip_addresses = None
        self.linux_outbound_ip_addresses = None
        self.allow_new_private_endpoint_connections = allow_new_private_endpoint_connections


class AuthPlatform(msrest.serialization.Model):
    """The configuration settings of the platform of App Service Authentication/Authorization.

    :ivar enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :vartype runtime_version: str
    :ivar config_file_path: The path of the config file containing auth settings if they come from
     a file.
     If the path is relative, base will the site's root directory.
    :vartype config_file_path: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'config_file_path': {'key': 'configFilePath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        runtime_version: Optional[str] = None,
        config_file_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
         enabled for the current app; otherwise, :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword runtime_version: The RuntimeVersion of the Authentication / Authorization feature in
         use for the current app.
         The setting in this value can control the behavior of certain features in the Authentication /
         Authorization module.
        :paramtype runtime_version: str
        :keyword config_file_path: The path of the config file containing auth settings if they come
         from a file.
         If the path is relative, base will the site's root directory.
        :paramtype config_file_path: str
        """
        super(AuthPlatform, self).__init__(**kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version
        self.config_file_path = config_file_path


class AutoHealActions(msrest.serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :ivar action_type: Predefined action to be taken. Possible values include: "Recycle",
     "LogEvent", "CustomAction".
    :vartype action_type: str or ~azure.mgmt.web.v2021_01_15.models.AutoHealActionType
    :ivar custom_action: Custom action to be taken.
    :vartype custom_action: ~azure.mgmt.web.v2021_01_15.models.AutoHealCustomAction
    :ivar min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :vartype min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "AutoHealActionType"]] = None,
        custom_action: Optional["AutoHealCustomAction"] = None,
        min_process_execution_time: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action_type: Predefined action to be taken. Possible values include: "Recycle",
         "LogEvent", "CustomAction".
        :paramtype action_type: str or ~azure.mgmt.web.v2021_01_15.models.AutoHealActionType
        :keyword custom_action: Custom action to be taken.
        :paramtype custom_action: ~azure.mgmt.web.v2021_01_15.models.AutoHealCustomAction
        :keyword min_process_execution_time: Minimum time the process must execute
         before taking the action.
        :paramtype min_process_execution_time: str
        """
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(msrest.serialization.Model):
    """Custom action to be executed
when an auto heal rule is triggered.

    :ivar exe: Executable to be run.
    :vartype exe: str
    :ivar parameters: Parameters for the executable.
    :vartype parameters: str
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exe: Optional[str] = None,
        parameters: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword exe: Executable to be run.
        :paramtype exe: str
        :keyword parameters: Parameters for the executable.
        :paramtype parameters: str
        """
        super(AutoHealCustomAction, self).__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(msrest.serialization.Model):
    """Rules that can be defined for auto-heal.

    :ivar triggers: Conditions that describe when to execute the auto-heal actions.
    :vartype triggers: ~azure.mgmt.web.v2021_01_15.models.AutoHealTriggers
    :ivar actions: Actions to be executed when a rule is triggered.
    :vartype actions: ~azure.mgmt.web.v2021_01_15.models.AutoHealActions
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'AutoHealTriggers'},
        'actions': {'key': 'actions', 'type': 'AutoHealActions'},
    }

    def __init__(
        self,
        *,
        triggers: Optional["AutoHealTriggers"] = None,
        actions: Optional["AutoHealActions"] = None,
        **kwargs
    ):
        """
        :keyword triggers: Conditions that describe when to execute the auto-heal actions.
        :paramtype triggers: ~azure.mgmt.web.v2021_01_15.models.AutoHealTriggers
        :keyword actions: Actions to be executed when a rule is triggered.
        :paramtype actions: ~azure.mgmt.web.v2021_01_15.models.AutoHealActions
        """
        super(AutoHealRules, self).__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(msrest.serialization.Model):
    """Triggers for auto-heal.

    :ivar requests: A rule based on total requests.
    :vartype requests: ~azure.mgmt.web.v2021_01_15.models.RequestsBasedTrigger
    :ivar private_bytes_in_kb: A rule based on private bytes.
    :vartype private_bytes_in_kb: int
    :ivar status_codes: A rule based on status codes.
    :vartype status_codes: list[~azure.mgmt.web.v2021_01_15.models.StatusCodesBasedTrigger]
    :ivar slow_requests: A rule based on request execution time.
    :vartype slow_requests: ~azure.mgmt.web.v2021_01_15.models.SlowRequestsBasedTrigger
    :ivar slow_requests_with_path: A rule based on multiple Slow Requests Rule with path.
    :vartype slow_requests_with_path:
     list[~azure.mgmt.web.v2021_01_15.models.SlowRequestsBasedTrigger]
    :ivar status_codes_range: A rule based on status codes ranges.
    :vartype status_codes_range:
     list[~azure.mgmt.web.v2021_01_15.models.StatusCodesRangeBasedTrigger]
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
        'slow_requests_with_path': {'key': 'slowRequestsWithPath', 'type': '[SlowRequestsBasedTrigger]'},
        'status_codes_range': {'key': 'statusCodesRange', 'type': '[StatusCodesRangeBasedTrigger]'},
    }

    def __init__(
        self,
        *,
        requests: Optional["RequestsBasedTrigger"] = None,
        private_bytes_in_kb: Optional[int] = None,
        status_codes: Optional[List["StatusCodesBasedTrigger"]] = None,
        slow_requests: Optional["SlowRequestsBasedTrigger"] = None,
        slow_requests_with_path: Optional[List["SlowRequestsBasedTrigger"]] = None,
        status_codes_range: Optional[List["StatusCodesRangeBasedTrigger"]] = None,
        **kwargs
    ):
        """
        :keyword requests: A rule based on total requests.
        :paramtype requests: ~azure.mgmt.web.v2021_01_15.models.RequestsBasedTrigger
        :keyword private_bytes_in_kb: A rule based on private bytes.
        :paramtype private_bytes_in_kb: int
        :keyword status_codes: A rule based on status codes.
        :paramtype status_codes: list[~azure.mgmt.web.v2021_01_15.models.StatusCodesBasedTrigger]
        :keyword slow_requests: A rule based on request execution time.
        :paramtype slow_requests: ~azure.mgmt.web.v2021_01_15.models.SlowRequestsBasedTrigger
        :keyword slow_requests_with_path: A rule based on multiple Slow Requests Rule with path.
        :paramtype slow_requests_with_path:
         list[~azure.mgmt.web.v2021_01_15.models.SlowRequestsBasedTrigger]
        :keyword status_codes_range: A rule based on status codes ranges.
        :paramtype status_codes_range:
         list[~azure.mgmt.web.v2021_01_15.models.StatusCodesRangeBasedTrigger]
        """
        super(AutoHealTriggers, self).__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests
        self.slow_requests_with_path = slow_requests_with_path
        self.status_codes_range = status_codes_range


class AzureActiveDirectory(msrest.serialization.Model):
    """The configuration settings of the Azure Active directory provider.

    :ivar enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Azure Active Directory app registration.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.AzureActiveDirectoryRegistration
    :ivar login: The configuration settings of the Azure Active Directory login flow.
    :vartype login: ~azure.mgmt.web.v2021_01_15.models.AzureActiveDirectoryLogin
    :ivar validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :vartype validation: ~azure.mgmt.web.v2021_01_15.models.AzureActiveDirectoryValidation
    :ivar is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
     auto-provisioned using 1st party tooling.
     This is an internal flag primarily intended to support the Azure Management Portal. Users
     should not
     read or write to this property.
    :vartype is_auto_provisioned: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AzureActiveDirectoryRegistration'},
        'login': {'key': 'login', 'type': 'AzureActiveDirectoryLogin'},
        'validation': {'key': 'validation', 'type': 'AzureActiveDirectoryValidation'},
        'is_auto_provisioned': {'key': 'isAutoProvisioned', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["AzureActiveDirectoryRegistration"] = None,
        login: Optional["AzureActiveDirectoryLogin"] = None,
        validation: Optional["AzureActiveDirectoryValidation"] = None,
        is_auto_provisioned: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not
         be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Azure Active Directory app
         registration.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.AzureActiveDirectoryRegistration
        :keyword login: The configuration settings of the Azure Active Directory login flow.
        :paramtype login: ~azure.mgmt.web.v2021_01_15.models.AzureActiveDirectoryLogin
        :keyword validation: The configuration settings of the Azure Active Directory token validation
         flow.
        :paramtype validation: ~azure.mgmt.web.v2021_01_15.models.AzureActiveDirectoryValidation
        :keyword is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
         auto-provisioned using 1st party tooling.
         This is an internal flag primarily intended to support the Azure Management Portal. Users
         should not
         read or write to this property.
        :paramtype is_auto_provisioned: bool
        """
        super(AzureActiveDirectory, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation
        self.is_auto_provisioned = is_auto_provisioned


class AzureActiveDirectoryLogin(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory login flow.

    :ivar login_parameters: Login parameters to send to the OpenID Connect authorization endpoint
     when
     a user logs in. Each parameter must be in the form "key=value".
    :vartype login_parameters: list[str]
    :ivar disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
     should be omitted from the request; otherwise, :code:`<code>false</code>`.
    :vartype disable_www_authenticate: bool
    """

    _attribute_map = {
        'login_parameters': {'key': 'loginParameters', 'type': '[str]'},
        'disable_www_authenticate': {'key': 'disableWWWAuthenticate', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        login_parameters: Optional[List[str]] = None,
        disable_www_authenticate: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword login_parameters: Login parameters to send to the OpenID Connect authorization
         endpoint when
         a user logs in. Each parameter must be in the form "key=value".
        :paramtype login_parameters: list[str]
        :keyword disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
         should be omitted from the request; otherwise, :code:`<code>false</code>`.
        :paramtype disable_www_authenticate: bool
        """
        super(AzureActiveDirectoryLogin, self).__init__(**kwargs)
        self.login_parameters = login_parameters
        self.disable_www_authenticate = disable_www_authenticate


class AzureActiveDirectoryRegistration(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory app registration.

    :ivar open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
     access tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://login.microsoftonline.com/v2.0/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :vartype open_id_issuer: str
    :ivar client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret of the
     relying party application.
    :vartype client_secret_setting_name: str
    :ivar client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :vartype client_secret_certificate_thumbprint: str
    :ivar client_secret_certificate_subject_alternative_name: An alternative to the client secret
     thumbprint, that is the subject alternative name of a certificate used for signing purposes.
     This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :vartype client_secret_certificate_subject_alternative_name: str
    :ivar client_secret_certificate_issuer: An alternative to the client secret thumbprint, that is
     the issuer of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :vartype client_secret_certificate_issuer: str
    """

    _attribute_map = {
        'open_id_issuer': {'key': 'openIdIssuer', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
        'client_secret_certificate_thumbprint': {'key': 'clientSecretCertificateThumbprint', 'type': 'str'},
        'client_secret_certificate_subject_alternative_name': {'key': 'clientSecretCertificateSubjectAlternativeName', 'type': 'str'},
        'client_secret_certificate_issuer': {'key': 'clientSecretCertificateIssuer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        open_id_issuer: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        client_secret_certificate_thumbprint: Optional[str] = None,
        client_secret_certificate_subject_alternative_name: Optional[str] = None,
        client_secret_certificate_issuer: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
         access tokens for this application.
         When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
         https://login.microsoftonline.com/v2.0/{tenant-guid}/.
         This URI is a case-sensitive identifier for the token issuer.
         More information on OpenID Connect Discovery:
         http://openid.net/specs/openid-connect-discovery-1_0.html.
        :paramtype open_id_issuer: str
        :keyword client_id: The Client ID of this relying party application, known as the client_id.
         This setting is required for enabling OpenID Connection authentication with Azure Active
         Directory or
         other 3rd party OpenID Connect providers.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret of
         the relying party application.
        :paramtype client_secret_setting_name: str
        :keyword client_secret_certificate_thumbprint: An alternative to the client secret, that is the
         thumbprint of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret. It is also optional.
        :paramtype client_secret_certificate_thumbprint: str
        :keyword client_secret_certificate_subject_alternative_name: An alternative to the client
         secret thumbprint, that is the subject alternative name of a certificate used for signing
         purposes. This property acts as
         a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :paramtype client_secret_certificate_subject_alternative_name: str
        :keyword client_secret_certificate_issuer: An alternative to the client secret thumbprint, that
         is the issuer of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :paramtype client_secret_certificate_issuer: str
        """
        super(AzureActiveDirectoryRegistration, self).__init__(**kwargs)
        self.open_id_issuer = open_id_issuer
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name
        self.client_secret_certificate_thumbprint = client_secret_certificate_thumbprint
        self.client_secret_certificate_subject_alternative_name = client_secret_certificate_subject_alternative_name
        self.client_secret_certificate_issuer = client_secret_certificate_issuer


class AzureActiveDirectoryValidation(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory token validation flow.

    :ivar jwt_claim_checks: The configuration settings of the checks that should be made while
     validating the JWT Claims.
    :vartype jwt_claim_checks: ~azure.mgmt.web.v2021_01_15.models.JwtClaimChecks
    :ivar allowed_audiences: The list of audiences that can make successful
     authentication/authorization requests.
    :vartype allowed_audiences: list[str]
    """

    _attribute_map = {
        'jwt_claim_checks': {'key': 'jwtClaimChecks', 'type': 'JwtClaimChecks'},
        'allowed_audiences': {'key': 'allowedAudiences', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        jwt_claim_checks: Optional["JwtClaimChecks"] = None,
        allowed_audiences: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword jwt_claim_checks: The configuration settings of the checks that should be made while
         validating the JWT Claims.
        :paramtype jwt_claim_checks: ~azure.mgmt.web.v2021_01_15.models.JwtClaimChecks
        :keyword allowed_audiences: The list of audiences that can make successful
         authentication/authorization requests.
        :paramtype allowed_audiences: list[str]
        """
        super(AzureActiveDirectoryValidation, self).__init__(**kwargs)
        self.jwt_claim_checks = jwt_claim_checks
        self.allowed_audiences = allowed_audiences


class AzureBlobStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs azure blob storage configuration.

    :ivar level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2021_01_15.models.LogLevel
    :ivar sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :vartype sas_url: str
    :ivar retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "LogLevel"]] = None,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2021_01_15.models.LogLevel
        :keyword sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        :paramtype sas_url: str
        :keyword retention_in_days: Retention in days.
         Remove blobs older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        """
        super(AzureBlobStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days


class AzureBlobStorageHttpLogsConfig(msrest.serialization.Model):
    """Http logs to azure blob storage configuration.

    :ivar sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :vartype sas_url: str
    :ivar retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        :paramtype sas_url: str
        :keyword retention_in_days: Retention in days.
         Remove blobs older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super(AzureBlobStorageHttpLogsConfig, self).__init__(**kwargs)
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class AzureStaticWebApps(msrest.serialization.Model):
    """The configuration settings of the Azure Static Web Apps provider.

    :ivar enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Azure Static Web Apps registration.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.AzureStaticWebAppsRegistration
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AzureStaticWebAppsRegistration'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["AzureStaticWebAppsRegistration"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not
         be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Azure Static Web Apps registration.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.AzureStaticWebAppsRegistration
        """
        super(AzureStaticWebApps, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration


class AzureStaticWebAppsRegistration(msrest.serialization.Model):
    """The configuration settings of the registration for the Azure Static Web Apps provider.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        """
        super(AzureStaticWebAppsRegistration, self).__init__(**kwargs)
        self.client_id = client_id


class AzureStorageInfoValue(msrest.serialization.Model):
    """Azure Files or Blob Storage access information value for dictionary storage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of storage. Possible values include: "AzureFiles", "AzureBlob".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.AzureStorageType
    :ivar account_name: Name of the storage account.
    :vartype account_name: str
    :ivar share_name: Name of the file share (container name, for Blob storage).
    :vartype share_name: str
    :ivar access_key: Access key for the storage account.
    :vartype access_key: str
    :ivar mount_path: Path to mount the storage within the site's runtime environment.
    :vartype mount_path: str
    :ivar state: State of the storage account. Possible values include: "Ok", "InvalidCredentials",
     "InvalidShare", "NotValidated".
    :vartype state: str or ~azure.mgmt.web.v2021_01_15.models.AzureStorageState
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'share_name': {'key': 'shareName', 'type': 'str'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "AzureStorageType"]] = None,
        account_name: Optional[str] = None,
        share_name: Optional[str] = None,
        access_key: Optional[str] = None,
        mount_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Type of storage. Possible values include: "AzureFiles", "AzureBlob".
        :paramtype type: str or ~azure.mgmt.web.v2021_01_15.models.AzureStorageType
        :keyword account_name: Name of the storage account.
        :paramtype account_name: str
        :keyword share_name: Name of the file share (container name, for Blob storage).
        :paramtype share_name: str
        :keyword access_key: Access key for the storage account.
        :paramtype access_key: str
        :keyword mount_path: Path to mount the storage within the site's runtime environment.
        :paramtype mount_path: str
        """
        super(AzureStorageInfoValue, self).__init__(**kwargs)
        self.type = type
        self.account_name = account_name
        self.share_name = share_name
        self.access_key = access_key
        self.mount_path = mount_path
        self.state = None


class AzureStoragePropertyDictionaryResource(ProxyOnlyResource):
    """AzureStorageInfo dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Azure storage accounts.
    :vartype properties: dict[str, ~azure.mgmt.web.v2021_01_15.models.AzureStorageInfoValue]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{AzureStorageInfoValue}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "AzureStorageInfoValue"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Azure storage accounts.
        :paramtype properties: dict[str, ~azure.mgmt.web.v2021_01_15.models.AzureStorageInfoValue]
        """
        super(AzureStoragePropertyDictionaryResource, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class AzureTableStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to Azure table storage configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2021_01_15.models.LogLevel
    :ivar sas_url: Required. SAS URL to an Azure table with add/query/delete permissions.
    :vartype sas_url: str
    """

    _validation = {
        'sas_url': {'required': True},
    }

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sas_url: str,
        level: Optional[Union[str, "LogLevel"]] = None,
        **kwargs
    ):
        """
        :keyword level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2021_01_15.models.LogLevel
        :keyword sas_url: Required. SAS URL to an Azure table with add/query/delete permissions.
        :paramtype sas_url: str
        """
        super(AzureTableStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url


class BackupItem(ProxyOnlyResource):
    """Backup description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: Id of the backup.
    :vartype backup_id: int
    :ivar storage_account_url: SAS URL for the storage account container which contains this
     backup.
    :vartype storage_account_url: str
    :ivar blob_name: Name of the blob which contains data for this backup.
    :vartype blob_name: str
    :ivar name_properties_name: Name of this backup.
    :vartype name_properties_name: str
    :ivar status: Backup status. Possible values include: "InProgress", "Failed", "Succeeded",
     "TimedOut", "Created", "Skipped", "PartiallySucceeded", "DeleteInProgress", "DeleteFailed",
     "Deleted".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.BackupItemStatus
    :ivar size_in_bytes: Size of the backup in bytes.
    :vartype size_in_bytes: long
    :ivar created: Timestamp of the backup creation.
    :vartype created: ~datetime.datetime
    :ivar log: Details regarding this backup. Might contain an error message.
    :vartype log: str
    :ivar databases: List of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2021_01_15.models.DatabaseBackupSetting]
    :ivar scheduled: True if this backup has been created due to a schedule being triggered.
    :vartype scheduled: bool
    :ivar last_restore_time_stamp: Timestamp of a last restore operation which used this backup.
    :vartype last_restore_time_stamp: ~datetime.datetime
    :ivar finished_time_stamp: Timestamp when this backup finished.
    :vartype finished_time_stamp: ~datetime.datetime
    :ivar correlation_id: Unique correlation identifier. Please use this along with the timestamp
     while communicating with Azure support.
    :vartype correlation_id: str
    :ivar website_size_in_bytes: Size of the original web app which has been backed up.
    :vartype website_size_in_bytes: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_id': {'readonly': True},
        'storage_account_url': {'readonly': True},
        'blob_name': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'status': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'created': {'readonly': True},
        'log': {'readonly': True},
        'databases': {'readonly': True},
        'scheduled': {'readonly': True},
        'last_restore_time_stamp': {'readonly': True},
        'finished_time_stamp': {'readonly': True},
        'correlation_id': {'readonly': True},
        'website_size_in_bytes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_id': {'key': 'properties.id', 'type': 'int'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'log': {'key': 'properties.log', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'scheduled': {'key': 'properties.scheduled', 'type': 'bool'},
        'last_restore_time_stamp': {'key': 'properties.lastRestoreTimeStamp', 'type': 'iso-8601'},
        'finished_time_stamp': {'key': 'properties.finishedTimeStamp', 'type': 'iso-8601'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'website_size_in_bytes': {'key': 'properties.websiteSizeInBytes', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(BackupItem, self).__init__(kind=kind, **kwargs)
        self.backup_id = None
        self.storage_account_url = None
        self.blob_name = None
        self.name_properties_name = None
        self.status = None
        self.size_in_bytes = None
        self.created = None
        self.log = None
        self.databases = None
        self.scheduled = None
        self.last_restore_time_stamp = None
        self.finished_time_stamp = None
        self.correlation_id = None
        self.website_size_in_bytes = None


class BackupItemCollection(msrest.serialization.Model):
    """Collection of backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.BackupItem]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackupItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["BackupItem"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.BackupItem]
        """
        super(BackupItemCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class BackupRequest(ProxyOnlyResource):
    """Description of a backup which will be performed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_name: Name of the backup.
    :vartype backup_name: str
    :ivar enabled: True if the backup schedule is enabled (must be included in that case), false if
     the backup schedule should be disabled.
    :vartype enabled: bool
    :ivar storage_account_url: SAS URL to the container.
    :vartype storage_account_url: str
    :ivar backup_schedule: Schedule for the backup if it is executed periodically.
    :vartype backup_schedule: ~azure.mgmt.web.v2021_01_15.models.BackupSchedule
    :ivar databases: Databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2021_01_15.models.DatabaseBackupSetting]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_name': {'key': 'properties.backupName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'backup_schedule': {'key': 'properties.backupSchedule', 'type': 'BackupSchedule'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        backup_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        storage_account_url: Optional[str] = None,
        backup_schedule: Optional["BackupSchedule"] = None,
        databases: Optional[List["DatabaseBackupSetting"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword backup_name: Name of the backup.
        :paramtype backup_name: str
        :keyword enabled: True if the backup schedule is enabled (must be included in that case), false
         if the backup schedule should be disabled.
        :paramtype enabled: bool
        :keyword storage_account_url: SAS URL to the container.
        :paramtype storage_account_url: str
        :keyword backup_schedule: Schedule for the backup if it is executed periodically.
        :paramtype backup_schedule: ~azure.mgmt.web.v2021_01_15.models.BackupSchedule
        :keyword databases: Databases included in the backup.
        :paramtype databases: list[~azure.mgmt.web.v2021_01_15.models.DatabaseBackupSetting]
        """
        super(BackupRequest, self).__init__(kind=kind, **kwargs)
        self.backup_name = backup_name
        self.enabled = enabled
        self.storage_account_url = storage_account_url
        self.backup_schedule = backup_schedule
        self.databases = databases


class BackupSchedule(msrest.serialization.Model):
    """Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar frequency_interval: Required. How often the backup should be executed (e.g. for weekly
     backup, this should be set to 7 and FrequencyUnit should be set to Day).
    :vartype frequency_interval: int
    :ivar frequency_unit: Required. The unit of time for how often the backup should be executed
     (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7).
     Possible values include: "Day", "Hour". Default value: "Day".
    :vartype frequency_unit: str or ~azure.mgmt.web.v2021_01_15.models.FrequencyUnit
    :ivar keep_at_least_one_backup: Required. True if the retention policy should always keep at
     least one backup in the storage account, regardless how old it is; false otherwise.
    :vartype keep_at_least_one_backup: bool
    :ivar retention_period_in_days: Required. After how many days backups should be deleted.
    :vartype retention_period_in_days: int
    :ivar start_time: When the schedule should start working.
    :vartype start_time: ~datetime.datetime
    :ivar last_execution_time: Last time when this schedule was triggered.
    :vartype last_execution_time: ~datetime.datetime
    """

    _validation = {
        'frequency_interval': {'required': True},
        'frequency_unit': {'required': True},
        'keep_at_least_one_backup': {'required': True},
        'retention_period_in_days': {'required': True},
        'last_execution_time': {'readonly': True},
    }

    _attribute_map = {
        'frequency_interval': {'key': 'frequencyInterval', 'type': 'int'},
        'frequency_unit': {'key': 'frequencyUnit', 'type': 'str'},
        'keep_at_least_one_backup': {'key': 'keepAtLeastOneBackup', 'type': 'bool'},
        'retention_period_in_days': {'key': 'retentionPeriodInDays', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_execution_time': {'key': 'lastExecutionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        frequency_interval: int = 7,
        frequency_unit: Union[str, "FrequencyUnit"] = "Day",
        keep_at_least_one_backup: bool = True,
        retention_period_in_days: int = 30,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword frequency_interval: Required. How often the backup should be executed (e.g. for weekly
         backup, this should be set to 7 and FrequencyUnit should be set to Day).
        :paramtype frequency_interval: int
        :keyword frequency_unit: Required. The unit of time for how often the backup should be executed
         (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7).
         Possible values include: "Day", "Hour". Default value: "Day".
        :paramtype frequency_unit: str or ~azure.mgmt.web.v2021_01_15.models.FrequencyUnit
        :keyword keep_at_least_one_backup: Required. True if the retention policy should always keep at
         least one backup in the storage account, regardless how old it is; false otherwise.
        :paramtype keep_at_least_one_backup: bool
        :keyword retention_period_in_days: Required. After how many days backups should be deleted.
        :paramtype retention_period_in_days: int
        :keyword start_time: When the schedule should start working.
        :paramtype start_time: ~datetime.datetime
        """
        super(BackupSchedule, self).__init__(**kwargs)
        self.frequency_interval = frequency_interval
        self.frequency_unit = frequency_unit
        self.keep_at_least_one_backup = keep_at_least_one_backup
        self.retention_period_in_days = retention_period_in_days
        self.start_time = start_time
        self.last_execution_time = None


class BillingMeter(ProxyOnlyResource):
    """App Service billing entity that contains information about meter which the Azure billing system utilizes to charge users for services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar meter_id: Meter GUID onboarded in Commerce.
    :vartype meter_id: str
    :ivar billing_location: Azure Location of billable resource.
    :vartype billing_location: str
    :ivar short_name: Short Name from App Service Azure pricing Page.
    :vartype short_name: str
    :ivar friendly_name: Friendly name of the meter.
    :vartype friendly_name: str
    :ivar resource_type: App Service ResourceType meter used for.
    :vartype resource_type: str
    :ivar os_type: App Service OS type meter used for.
    :vartype os_type: str
    :ivar multiplier: Meter Multiplier.
    :vartype multiplier: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'billing_location': {'key': 'properties.billingLocation', 'type': 'str'},
        'short_name': {'key': 'properties.shortName', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'multiplier': {'key': 'properties.multiplier', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        meter_id: Optional[str] = None,
        billing_location: Optional[str] = None,
        short_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        os_type: Optional[str] = None,
        multiplier: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword meter_id: Meter GUID onboarded in Commerce.
        :paramtype meter_id: str
        :keyword billing_location: Azure Location of billable resource.
        :paramtype billing_location: str
        :keyword short_name: Short Name from App Service Azure pricing Page.
        :paramtype short_name: str
        :keyword friendly_name: Friendly name of the meter.
        :paramtype friendly_name: str
        :keyword resource_type: App Service ResourceType meter used for.
        :paramtype resource_type: str
        :keyword os_type: App Service OS type meter used for.
        :paramtype os_type: str
        :keyword multiplier: Meter Multiplier.
        :paramtype multiplier: float
        """
        super(BillingMeter, self).__init__(kind=kind, **kwargs)
        self.meter_id = meter_id
        self.billing_location = billing_location
        self.short_name = short_name
        self.friendly_name = friendly_name
        self.resource_type = resource_type
        self.os_type = os_type
        self.multiplier = multiplier


class BillingMeterCollection(msrest.serialization.Model):
    """Collection of Billing Meters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.BillingMeter]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingMeter]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["BillingMeter"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.BillingMeter]
        """
        super(BillingMeterCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class BlobStorageTokenStore(msrest.serialization.Model):
    """The configuration settings of the storage of the tokens if blob storage is used.

    :ivar sas_url_setting_name: The name of the app setting containing the SAS URL of the blob
     storage containing the tokens.
    :vartype sas_url_setting_name: str
    """

    _attribute_map = {
        'sas_url_setting_name': {'key': 'sasUrlSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sas_url_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword sas_url_setting_name: The name of the app setting containing the SAS URL of the blob
         storage containing the tokens.
        :paramtype sas_url_setting_name: str
        """
        super(BlobStorageTokenStore, self).__init__(**kwargs)
        self.sas_url_setting_name = sas_url_setting_name


class Capability(msrest.serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :ivar name: Name of the SKU capability.
    :vartype name: str
    :ivar value: Value of the SKU capability.
    :vartype value: str
    :ivar reason: Reason of the SKU capability.
    :vartype reason: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        reason: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the SKU capability.
        :paramtype name: str
        :keyword value: Value of the SKU capability.
        :paramtype value: str
        :keyword reason: Reason of the SKU capability.
        :paramtype reason: str
        """
        super(Capability, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.reason = reason


class Certificate(Resource):
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar password: Certificate password.
    :vartype password: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2021_01_15.models.KeyVaultSecretStatus
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar canonical_name: CNAME of the certificate to be issued via free certificate.
    :vartype canonical_name: str
    :ivar domain_validation_method: Method of domain validation for free cert.
    :vartype domain_validation_method: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'canonical_name': {'key': 'properties.canonicalName', 'type': 'str'},
        'domain_validation_method': {'key': 'properties.domainValidationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        password: Optional[str] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytearray] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        canonical_name: Optional[str] = None,
        domain_validation_method: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytearray
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword canonical_name: CNAME of the certificate to be issued via free certificate.
        :paramtype canonical_name: str
        :keyword domain_validation_method: Method of domain validation for free cert.
        :paramtype domain_validation_method: str
        """
        super(Certificate, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.password = password
        self.friendly_name = None
        self.subject_name = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status = None
        self.server_farm_id = server_farm_id
        self.canonical_name = canonical_name
        self.domain_validation_method = domain_validation_method


class CertificateCollection(msrest.serialization.Model):
    """Collection of certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Certificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Certificate"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.Certificate]
        """
        super(CertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CertificateDetails(msrest.serialization.Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: ~datetime.datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: ~datetime.datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        'version': {'readonly': True},
        'serial_number': {'readonly': True},
        'thumbprint': {'readonly': True},
        'subject': {'readonly': True},
        'not_before': {'readonly': True},
        'not_after': {'readonly': True},
        'signature_algorithm': {'readonly': True},
        'issuer': {'readonly': True},
        'raw_data': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'not_before': {'key': 'notBefore', 'type': 'iso-8601'},
        'not_after': {'key': 'notAfter', 'type': 'iso-8601'},
        'signature_algorithm': {'key': 'signatureAlgorithm', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'raw_data': {'key': 'rawData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CertificateDetails, self).__init__(**kwargs)
        self.version = None
        self.serial_number = None
        self.thumbprint = None
        self.subject = None
        self.not_before = None
        self.not_after = None
        self.signature_algorithm = None
        self.issuer = None
        self.raw_data = None


class CertificateEmail(ProxyOnlyResource):
    """SSL certificate email.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar email_id: Email id.
    :vartype email_id: str
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email_id': {'key': 'properties.emailId', 'type': 'str'},
        'time_stamp': {'key': 'properties.timeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        email_id: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword email_id: Email id.
        :paramtype email_id: str
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        """
        super(CertificateEmail, self).__init__(kind=kind, **kwargs)
        self.email_id = email_id
        self.time_stamp = time_stamp


class CertificateOrderAction(ProxyOnlyResource):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar action_type: Action type. Possible values include: "CertificateIssued",
     "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
     "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
     "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
     "FraudDocumentationRequired", "Unknown".
    :vartype action_type: str or ~azure.mgmt.web.v2021_01_15.models.CertificateOrderActionType
    :ivar created_at: Time at which the certificate action was performed.
    :vartype created_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'action_type': {'readonly': True},
        'created_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'action_type': {'key': 'properties.actionType', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(CertificateOrderAction, self).__init__(kind=kind, **kwargs)
        self.action_type = None
        self.created_at = None


class CertificateOrderContact(msrest.serialization.Model):
    """CertificateOrderContact.

    :ivar email:
    :vartype email: str
    :ivar name_first:
    :vartype name_first: str
    :ivar name_last:
    :vartype name_last: str
    :ivar phone:
    :vartype phone: str
    """

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
        'name_first': {'key': 'nameFirst', 'type': 'str'},
        'name_last': {'key': 'nameLast', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        name_first: Optional[str] = None,
        name_last: Optional[str] = None,
        phone: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword email:
        :paramtype email: str
        :keyword name_first:
        :paramtype name_first: str
        :keyword name_last:
        :paramtype name_last: str
        :keyword phone:
        :paramtype phone: str
        """
        super(CertificateOrderContact, self).__init__(**kwargs)
        self.email = email
        self.name_first = name_first
        self.name_last = name_last
        self.phone = phone


class CertificatePatchResource(ProxyOnlyResource):
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar password: Certificate password.
    :vartype password: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2021_01_15.models.KeyVaultSecretStatus
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar canonical_name: CNAME of the certificate to be issued via free certificate.
    :vartype canonical_name: str
    :ivar domain_validation_method: Method of domain validation for free cert.
    :vartype domain_validation_method: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'canonical_name': {'key': 'properties.canonicalName', 'type': 'str'},
        'domain_validation_method': {'key': 'properties.domainValidationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        password: Optional[str] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytearray] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        canonical_name: Optional[str] = None,
        domain_validation_method: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytearray
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword canonical_name: CNAME of the certificate to be issued via free certificate.
        :paramtype canonical_name: str
        :keyword domain_validation_method: Method of domain validation for free cert.
        :paramtype domain_validation_method: str
        """
        super(CertificatePatchResource, self).__init__(kind=kind, **kwargs)
        self.password = password
        self.friendly_name = None
        self.subject_name = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status = None
        self.server_farm_id = server_farm_id
        self.canonical_name = canonical_name
        self.domain_validation_method = domain_validation_method


class ClientRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for providers that have client ids and client secrets.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret.
        :paramtype client_secret_setting_name: str
        """
        super(ClientRegistration, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name


class CloningInfo(msrest.serialization.Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :ivar correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :vartype correlation_id: str
    :ivar overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :vartype clone_custom_host_names: bool
    :ivar clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :vartype clone_source_control: bool
    :ivar source_web_app_id: Required. ARM resource ID of the source app. App resource ID is of the
     form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :vartype source_web_app_id: str
    :ivar source_web_app_location: Location of source app ex: West US or North Europe.
    :vartype source_web_app_location: str
    :ivar hosting_environment: App Service Environment.
    :vartype hosting_environment: str
    :ivar app_settings_overrides: Application setting overrides for cloned app. If specified, these
     settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :vartype app_settings_overrides: dict[str, str]
    :ivar configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :vartype configure_load_balancing: bool
    :ivar traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :vartype traffic_manager_profile_id: str
    :ivar traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :vartype traffic_manager_profile_name: str
    """

    _validation = {
        'source_web_app_id': {'required': True},
    }

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'overwrite': {'key': 'overwrite', 'type': 'bool'},
        'clone_custom_host_names': {'key': 'cloneCustomHostNames', 'type': 'bool'},
        'clone_source_control': {'key': 'cloneSourceControl', 'type': 'bool'},
        'source_web_app_id': {'key': 'sourceWebAppId', 'type': 'str'},
        'source_web_app_location': {'key': 'sourceWebAppLocation', 'type': 'str'},
        'hosting_environment': {'key': 'hostingEnvironment', 'type': 'str'},
        'app_settings_overrides': {'key': 'appSettingsOverrides', 'type': '{str}'},
        'configure_load_balancing': {'key': 'configureLoadBalancing', 'type': 'bool'},
        'traffic_manager_profile_id': {'key': 'trafficManagerProfileId', 'type': 'str'},
        'traffic_manager_profile_name': {'key': 'trafficManagerProfileName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_web_app_id: str,
        correlation_id: Optional[str] = None,
        overwrite: Optional[bool] = None,
        clone_custom_host_names: Optional[bool] = None,
        clone_source_control: Optional[bool] = None,
        source_web_app_location: Optional[str] = None,
        hosting_environment: Optional[str] = None,
        app_settings_overrides: Optional[Dict[str, str]] = None,
        configure_load_balancing: Optional[bool] = None,
        traffic_manager_profile_id: Optional[str] = None,
        traffic_manager_profile_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
         operations
         together to use the same snapshot.
        :paramtype correlation_id: str
        :keyword overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
         :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from
         source app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_custom_host_names: bool
        :keyword clone_source_control: :code:`<code>true</code>` to clone source control from source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_source_control: bool
        :keyword source_web_app_id: Required. ARM resource ID of the source app. App resource ID is of
         the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots.
        :paramtype source_web_app_id: str
        :keyword source_web_app_location: Location of source app ex: West US or North Europe.
        :paramtype source_web_app_location: str
        :keyword hosting_environment: App Service Environment.
        :paramtype hosting_environment: str
        :keyword app_settings_overrides: Application setting overrides for cloned app. If specified,
         these settings override the settings cloned
         from source app. Otherwise, application settings from source app are retained.
        :paramtype app_settings_overrides: dict[str, str]
        :keyword configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
         source and destination app.
        :paramtype configure_load_balancing: bool
        :keyword traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if
         it exists. Traffic Manager resource ID is of the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
        :paramtype traffic_manager_profile_id: str
        :keyword traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
         needed if Traffic Manager profile does not already exist.
        :paramtype traffic_manager_profile_name: str
        """
        super(CloningInfo, self).__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.source_web_app_location = source_web_app_location
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name


class ConnectionStringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Connection strings.
    :vartype properties: dict[str, ~azure.mgmt.web.v2021_01_15.models.ConnStringValueTypePair]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{ConnStringValueTypePair}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "ConnStringValueTypePair"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Connection strings.
        :paramtype properties: dict[str, ~azure.mgmt.web.v2021_01_15.models.ConnStringValueTypePair]
        """
        super(ConnectionStringDictionary, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class ConnStringInfo(msrest.serialization.Model):
    """Database connection string information.

    :ivar name: Name of connection string.
    :vartype name: str
    :ivar connection_string: Connection string value.
    :vartype connection_string: str
    :ivar type: Type of database. Possible values include: "MySql", "SQLServer", "SQLAzure",
     "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache",
     "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_string: Optional[str] = None,
        type: Optional[Union[str, "ConnectionStringType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of connection string.
        :paramtype name: str
        :keyword connection_string: Connection string value.
        :paramtype connection_string: str
        :keyword type: Type of database. Possible values include: "MySql", "SQLServer", "SQLAzure",
         "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache",
         "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2021_01_15.models.ConnectionStringType
        """
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class ConnStringValueTypePair(msrest.serialization.Model):
    """Database connection string value to type pair.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Value of pair.
    :vartype value: str
    :ivar type: Required. Type of database. Possible values include: "MySql", "SQLServer",
     "SQLAzure", "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb",
     "RedisCache", "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.ConnectionStringType
    """

    _validation = {
        'value': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        type: Union[str, "ConnectionStringType"],
        **kwargs
    ):
        """
        :keyword value: Required. Value of pair.
        :paramtype value: str
        :keyword type: Required. Type of database. Possible values include: "MySql", "SQLServer",
         "SQLAzure", "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb",
         "RedisCache", "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2021_01_15.models.ConnectionStringType
        """
        super(ConnStringValueTypePair, self).__init__(**kwargs)
        self.value = value
        self.type = type


class Contact(msrest.serialization.Model):
    """Contact information for domain registration. If 'Domain Privacy' option is not selected then the contact information is made publicly available through the Whois 
directories as per ICANN requirements.

    All required parameters must be populated in order to send to Azure.

    :ivar address_mailing: Mailing address.
    :vartype address_mailing: ~azure.mgmt.web.v2021_01_15.models.Address
    :ivar email: Required. Email address.
    :vartype email: str
    :ivar fax: Fax number.
    :vartype fax: str
    :ivar job_title: Job title.
    :vartype job_title: str
    :ivar name_first: Required. First name.
    :vartype name_first: str
    :ivar name_last: Required. Last name.
    :vartype name_last: str
    :ivar name_middle: Middle name.
    :vartype name_middle: str
    :ivar organization: Organization contact belongs to.
    :vartype organization: str
    :ivar phone: Required. Phone number.
    :vartype phone: str
    """

    _validation = {
        'email': {'required': True},
        'name_first': {'required': True},
        'name_last': {'required': True},
        'phone': {'required': True},
    }

    _attribute_map = {
        'address_mailing': {'key': 'addressMailing', 'type': 'Address'},
        'email': {'key': 'email', 'type': 'str'},
        'fax': {'key': 'fax', 'type': 'str'},
        'job_title': {'key': 'jobTitle', 'type': 'str'},
        'name_first': {'key': 'nameFirst', 'type': 'str'},
        'name_last': {'key': 'nameLast', 'type': 'str'},
        'name_middle': {'key': 'nameMiddle', 'type': 'str'},
        'organization': {'key': 'organization', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: str,
        name_first: str,
        name_last: str,
        phone: str,
        address_mailing: Optional["Address"] = None,
        fax: Optional[str] = None,
        job_title: Optional[str] = None,
        name_middle: Optional[str] = None,
        organization: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword address_mailing: Mailing address.
        :paramtype address_mailing: ~azure.mgmt.web.v2021_01_15.models.Address
        :keyword email: Required. Email address.
        :paramtype email: str
        :keyword fax: Fax number.
        :paramtype fax: str
        :keyword job_title: Job title.
        :paramtype job_title: str
        :keyword name_first: Required. First name.
        :paramtype name_first: str
        :keyword name_last: Required. Last name.
        :paramtype name_last: str
        :keyword name_middle: Middle name.
        :paramtype name_middle: str
        :keyword organization: Organization contact belongs to.
        :paramtype organization: str
        :keyword phone: Required. Phone number.
        :paramtype phone: str
        """
        super(Contact, self).__init__(**kwargs)
        self.address_mailing = address_mailing
        self.email = email
        self.fax = fax
        self.job_title = job_title
        self.name_first = name_first
        self.name_last = name_last
        self.name_middle = name_middle
        self.organization = organization
        self.phone = phone


class ContainerCpuStatistics(msrest.serialization.Model):
    """ContainerCpuStatistics.

    :ivar cpu_usage:
    :vartype cpu_usage: ~azure.mgmt.web.v2021_01_15.models.ContainerCpuUsage
    :ivar system_cpu_usage:
    :vartype system_cpu_usage: long
    :ivar online_cpu_count:
    :vartype online_cpu_count: int
    :ivar throttling_data:
    :vartype throttling_data: ~azure.mgmt.web.v2021_01_15.models.ContainerThrottlingData
    """

    _attribute_map = {
        'cpu_usage': {'key': 'cpuUsage', 'type': 'ContainerCpuUsage'},
        'system_cpu_usage': {'key': 'systemCpuUsage', 'type': 'long'},
        'online_cpu_count': {'key': 'onlineCpuCount', 'type': 'int'},
        'throttling_data': {'key': 'throttlingData', 'type': 'ContainerThrottlingData'},
    }

    def __init__(
        self,
        *,
        cpu_usage: Optional["ContainerCpuUsage"] = None,
        system_cpu_usage: Optional[int] = None,
        online_cpu_count: Optional[int] = None,
        throttling_data: Optional["ContainerThrottlingData"] = None,
        **kwargs
    ):
        """
        :keyword cpu_usage:
        :paramtype cpu_usage: ~azure.mgmt.web.v2021_01_15.models.ContainerCpuUsage
        :keyword system_cpu_usage:
        :paramtype system_cpu_usage: long
        :keyword online_cpu_count:
        :paramtype online_cpu_count: int
        :keyword throttling_data:
        :paramtype throttling_data: ~azure.mgmt.web.v2021_01_15.models.ContainerThrottlingData
        """
        super(ContainerCpuStatistics, self).__init__(**kwargs)
        self.cpu_usage = cpu_usage
        self.system_cpu_usage = system_cpu_usage
        self.online_cpu_count = online_cpu_count
        self.throttling_data = throttling_data


class ContainerCpuUsage(msrest.serialization.Model):
    """ContainerCpuUsage.

    :ivar total_usage:
    :vartype total_usage: long
    :ivar per_cpu_usage:
    :vartype per_cpu_usage: list[long]
    :ivar kernel_mode_usage:
    :vartype kernel_mode_usage: long
    :ivar user_mode_usage:
    :vartype user_mode_usage: long
    """

    _attribute_map = {
        'total_usage': {'key': 'totalUsage', 'type': 'long'},
        'per_cpu_usage': {'key': 'perCpuUsage', 'type': '[long]'},
        'kernel_mode_usage': {'key': 'kernelModeUsage', 'type': 'long'},
        'user_mode_usage': {'key': 'userModeUsage', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        total_usage: Optional[int] = None,
        per_cpu_usage: Optional[List[int]] = None,
        kernel_mode_usage: Optional[int] = None,
        user_mode_usage: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword total_usage:
        :paramtype total_usage: long
        :keyword per_cpu_usage:
        :paramtype per_cpu_usage: list[long]
        :keyword kernel_mode_usage:
        :paramtype kernel_mode_usage: long
        :keyword user_mode_usage:
        :paramtype user_mode_usage: long
        """
        super(ContainerCpuUsage, self).__init__(**kwargs)
        self.total_usage = total_usage
        self.per_cpu_usage = per_cpu_usage
        self.kernel_mode_usage = kernel_mode_usage
        self.user_mode_usage = user_mode_usage


class ContainerInfo(msrest.serialization.Model):
    """ContainerInfo.

    :ivar current_time_stamp:
    :vartype current_time_stamp: ~datetime.datetime
    :ivar previous_time_stamp:
    :vartype previous_time_stamp: ~datetime.datetime
    :ivar current_cpu_stats:
    :vartype current_cpu_stats: ~azure.mgmt.web.v2021_01_15.models.ContainerCpuStatistics
    :ivar previous_cpu_stats:
    :vartype previous_cpu_stats: ~azure.mgmt.web.v2021_01_15.models.ContainerCpuStatistics
    :ivar memory_stats:
    :vartype memory_stats: ~azure.mgmt.web.v2021_01_15.models.ContainerMemoryStatistics
    :ivar name:
    :vartype name: str
    :ivar id:
    :vartype id: str
    :ivar eth0:
    :vartype eth0: ~azure.mgmt.web.v2021_01_15.models.ContainerNetworkInterfaceStatistics
    """

    _attribute_map = {
        'current_time_stamp': {'key': 'currentTimeStamp', 'type': 'iso-8601'},
        'previous_time_stamp': {'key': 'previousTimeStamp', 'type': 'iso-8601'},
        'current_cpu_stats': {'key': 'currentCpuStats', 'type': 'ContainerCpuStatistics'},
        'previous_cpu_stats': {'key': 'previousCpuStats', 'type': 'ContainerCpuStatistics'},
        'memory_stats': {'key': 'memoryStats', 'type': 'ContainerMemoryStatistics'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'eth0': {'key': 'eth0', 'type': 'ContainerNetworkInterfaceStatistics'},
    }

    def __init__(
        self,
        *,
        current_time_stamp: Optional[datetime.datetime] = None,
        previous_time_stamp: Optional[datetime.datetime] = None,
        current_cpu_stats: Optional["ContainerCpuStatistics"] = None,
        previous_cpu_stats: Optional["ContainerCpuStatistics"] = None,
        memory_stats: Optional["ContainerMemoryStatistics"] = None,
        name: Optional[str] = None,
        id: Optional[str] = None,
        eth0: Optional["ContainerNetworkInterfaceStatistics"] = None,
        **kwargs
    ):
        """
        :keyword current_time_stamp:
        :paramtype current_time_stamp: ~datetime.datetime
        :keyword previous_time_stamp:
        :paramtype previous_time_stamp: ~datetime.datetime
        :keyword current_cpu_stats:
        :paramtype current_cpu_stats: ~azure.mgmt.web.v2021_01_15.models.ContainerCpuStatistics
        :keyword previous_cpu_stats:
        :paramtype previous_cpu_stats: ~azure.mgmt.web.v2021_01_15.models.ContainerCpuStatistics
        :keyword memory_stats:
        :paramtype memory_stats: ~azure.mgmt.web.v2021_01_15.models.ContainerMemoryStatistics
        :keyword name:
        :paramtype name: str
        :keyword id:
        :paramtype id: str
        :keyword eth0:
        :paramtype eth0: ~azure.mgmt.web.v2021_01_15.models.ContainerNetworkInterfaceStatistics
        """
        super(ContainerInfo, self).__init__(**kwargs)
        self.current_time_stamp = current_time_stamp
        self.previous_time_stamp = previous_time_stamp
        self.current_cpu_stats = current_cpu_stats
        self.previous_cpu_stats = previous_cpu_stats
        self.memory_stats = memory_stats
        self.name = name
        self.id = id
        self.eth0 = eth0


class ContainerMemoryStatistics(msrest.serialization.Model):
    """ContainerMemoryStatistics.

    :ivar usage:
    :vartype usage: long
    :ivar max_usage:
    :vartype max_usage: long
    :ivar limit:
    :vartype limit: long
    """

    _attribute_map = {
        'usage': {'key': 'usage', 'type': 'long'},
        'max_usage': {'key': 'maxUsage', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        usage: Optional[int] = None,
        max_usage: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword usage:
        :paramtype usage: long
        :keyword max_usage:
        :paramtype max_usage: long
        :keyword limit:
        :paramtype limit: long
        """
        super(ContainerMemoryStatistics, self).__init__(**kwargs)
        self.usage = usage
        self.max_usage = max_usage
        self.limit = limit


class ContainerNetworkInterfaceStatistics(msrest.serialization.Model):
    """ContainerNetworkInterfaceStatistics.

    :ivar rx_bytes:
    :vartype rx_bytes: long
    :ivar rx_packets:
    :vartype rx_packets: long
    :ivar rx_errors:
    :vartype rx_errors: long
    :ivar rx_dropped:
    :vartype rx_dropped: long
    :ivar tx_bytes:
    :vartype tx_bytes: long
    :ivar tx_packets:
    :vartype tx_packets: long
    :ivar tx_errors:
    :vartype tx_errors: long
    :ivar tx_dropped:
    :vartype tx_dropped: long
    """

    _attribute_map = {
        'rx_bytes': {'key': 'rxBytes', 'type': 'long'},
        'rx_packets': {'key': 'rxPackets', 'type': 'long'},
        'rx_errors': {'key': 'rxErrors', 'type': 'long'},
        'rx_dropped': {'key': 'rxDropped', 'type': 'long'},
        'tx_bytes': {'key': 'txBytes', 'type': 'long'},
        'tx_packets': {'key': 'txPackets', 'type': 'long'},
        'tx_errors': {'key': 'txErrors', 'type': 'long'},
        'tx_dropped': {'key': 'txDropped', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        rx_bytes: Optional[int] = None,
        rx_packets: Optional[int] = None,
        rx_errors: Optional[int] = None,
        rx_dropped: Optional[int] = None,
        tx_bytes: Optional[int] = None,
        tx_packets: Optional[int] = None,
        tx_errors: Optional[int] = None,
        tx_dropped: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword rx_bytes:
        :paramtype rx_bytes: long
        :keyword rx_packets:
        :paramtype rx_packets: long
        :keyword rx_errors:
        :paramtype rx_errors: long
        :keyword rx_dropped:
        :paramtype rx_dropped: long
        :keyword tx_bytes:
        :paramtype tx_bytes: long
        :keyword tx_packets:
        :paramtype tx_packets: long
        :keyword tx_errors:
        :paramtype tx_errors: long
        :keyword tx_dropped:
        :paramtype tx_dropped: long
        """
        super(ContainerNetworkInterfaceStatistics, self).__init__(**kwargs)
        self.rx_bytes = rx_bytes
        self.rx_packets = rx_packets
        self.rx_errors = rx_errors
        self.rx_dropped = rx_dropped
        self.tx_bytes = tx_bytes
        self.tx_packets = tx_packets
        self.tx_errors = tx_errors
        self.tx_dropped = tx_dropped


class ContainerThrottlingData(msrest.serialization.Model):
    """ContainerThrottlingData.

    :ivar periods:
    :vartype periods: int
    :ivar throttled_periods:
    :vartype throttled_periods: int
    :ivar throttled_time:
    :vartype throttled_time: int
    """

    _attribute_map = {
        'periods': {'key': 'periods', 'type': 'int'},
        'throttled_periods': {'key': 'throttledPeriods', 'type': 'int'},
        'throttled_time': {'key': 'throttledTime', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        periods: Optional[int] = None,
        throttled_periods: Optional[int] = None,
        throttled_time: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword periods:
        :paramtype periods: int
        :keyword throttled_periods:
        :paramtype throttled_periods: int
        :keyword throttled_time:
        :paramtype throttled_time: int
        """
        super(ContainerThrottlingData, self).__init__(**kwargs)
        self.periods = periods
        self.throttled_periods = throttled_periods
        self.throttled_time = throttled_time


class ContinuousWebJob(ProxyOnlyResource):
    """Continuous Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Job status. Possible values include: "Initializing", "Starting", "Running",
     "PendingRestart", "Stopped".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.ContinuousWebJobStatus
    :ivar detailed_status: Detailed status.
    :vartype detailed_status: str
    :ivar log_url: Log URL.
    :vartype log_url: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar web_job_type: Job type. Possible values include: "Continuous", "Triggered".
    :vartype web_job_type: str or ~azure.mgmt.web.v2021_01_15.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'detailed_status': {'key': 'properties.detailed_status', 'type': 'str'},
        'log_url': {'key': 'properties.log_url', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[Union[str, "ContinuousWebJobStatus"]] = None,
        detailed_status: Optional[str] = None,
        log_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword status: Job status. Possible values include: "Initializing", "Starting", "Running",
         "PendingRestart", "Stopped".
        :paramtype status: str or ~azure.mgmt.web.v2021_01_15.models.ContinuousWebJobStatus
        :keyword detailed_status: Detailed status.
        :paramtype detailed_status: str
        :keyword log_url: Log URL.
        :paramtype log_url: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword web_job_type: Job type. Possible values include: "Continuous", "Triggered".
        :paramtype web_job_type: str or ~azure.mgmt.web.v2021_01_15.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, any]
        """
        super(ContinuousWebJob, self).__init__(kind=kind, **kwargs)
        self.status = status
        self.detailed_status = detailed_status
        self.log_url = log_url
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class ContinuousWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.ContinuousWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContinuousWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ContinuousWebJob"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.ContinuousWebJob]
        """
        super(ContinuousWebJobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CookieExpiration(msrest.serialization.Model):
    """The configuration settings of the session cookie's expiration.

    :ivar convention: The convention used when determining the session cookie's expiration.
     Possible values include: "FixedTime", "IdentityProviderDerived".
    :vartype convention: str or ~azure.mgmt.web.v2021_01_15.models.CookieExpirationConvention
    :ivar time_to_expiration: The time after the request is made when the session cookie should
     expire.
    :vartype time_to_expiration: str
    """

    _attribute_map = {
        'convention': {'key': 'convention', 'type': 'str'},
        'time_to_expiration': {'key': 'timeToExpiration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        convention: Optional[Union[str, "CookieExpirationConvention"]] = None,
        time_to_expiration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword convention: The convention used when determining the session cookie's expiration.
         Possible values include: "FixedTime", "IdentityProviderDerived".
        :paramtype convention: str or ~azure.mgmt.web.v2021_01_15.models.CookieExpirationConvention
        :keyword time_to_expiration: The time after the request is made when the session cookie should
         expire.
        :paramtype time_to_expiration: str
        """
        super(CookieExpiration, self).__init__(**kwargs)
        self.convention = convention
        self.time_to_expiration = time_to_expiration


class CorsSettings(msrest.serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :ivar allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :vartype allowed_origins: list[str]
    :ivar support_credentials: Gets or sets whether CORS requests with credentials are allowed. See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
    :vartype support_credentials: bool
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'support_credentials': {'key': 'supportCredentials', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        allowed_origins: Optional[List[str]] = None,
        support_credentials: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword allowed_origins: Gets or sets the list of origins that should be allowed to make
         cross-origin
         calls (for example: http://example.com:12345). Use "*" to allow all.
        :paramtype allowed_origins: list[str]
        :keyword support_credentials: Gets or sets whether CORS requests with credentials are allowed.
         See
         https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
         for more details.
        :paramtype support_credentials: bool
        """
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.support_credentials = support_credentials


class CsmMoveResourceEnvelope(msrest.serialization.Model):
    """Object with a list of the resources that need to be moved and the resource group they should be moved to.

    :ivar target_resource_group:
    :vartype target_resource_group: str
    :ivar resources:
    :vartype resources: list[str]
    """

    _validation = {
        'target_resource_group': {'max_length': 90, 'min_length': 1, 'pattern': r' ^[-\w\._\(\)]+[^\.]$'},
    }

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'resources': {'key': 'resources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        target_resource_group: Optional[str] = None,
        resources: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword target_resource_group:
        :paramtype target_resource_group: str
        :keyword resources:
        :paramtype resources: list[str]
        """
        super(CsmMoveResourceEnvelope, self).__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class CsmOperationCollection(msrest.serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmOperationDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CsmOperationDescription"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.CsmOperationDescription]
        """
        super(CsmOperationCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CsmOperationDescription(msrest.serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :ivar name:
    :vartype name: str
    :ivar is_data_action:
    :vartype is_data_action: bool
    :ivar display: Meta data about operation used for display in portal.
    :vartype display: ~azure.mgmt.web.v2021_01_15.models.CsmOperationDisplay
    :ivar origin:
    :vartype origin: str
    :ivar properties: Properties available for a Microsoft.Web resource provider operation.
    :vartype properties: ~azure.mgmt.web.v2021_01_15.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'CsmOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CsmOperationDescriptionProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["CsmOperationDescriptionProperties"] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword is_data_action:
        :paramtype is_data_action: bool
        :keyword display: Meta data about operation used for display in portal.
        :paramtype display: ~azure.mgmt.web.v2021_01_15.models.CsmOperationDisplay
        :keyword origin:
        :paramtype origin: str
        :keyword properties: Properties available for a Microsoft.Web resource provider operation.
        :paramtype properties: ~azure.mgmt.web.v2021_01_15.models.CsmOperationDescriptionProperties
        """
        super(CsmOperationDescription, self).__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(msrest.serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :ivar service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :vartype service_specification: ~azure.mgmt.web.v2021_01_15.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword service_specification: Resource metrics service provided by Microsoft.Insights
         resource provider.
        :paramtype service_specification: ~azure.mgmt.web.v2021_01_15.models.ServiceSpecification
        """
        super(CsmOperationDescriptionProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(msrest.serialization.Model):
    """Meta data about operation used for display in portal.

    :ivar provider:
    :vartype provider: str
    :ivar resource:
    :vartype resource: str
    :ivar operation:
    :vartype operation: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider:
        :paramtype provider: str
        :keyword resource:
        :paramtype resource: str
        :keyword operation:
        :paramtype operation: str
        :keyword description:
        :paramtype description: str
        """
        super(CsmOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class CsmPublishingCredentialsPoliciesEntity(ProxyOnlyResource):
    """Publishing Credentials Policies parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar allow: :code:`<code>true</code>` to allow access to a publishing method; otherwise,
     :code:`<code>false</code>`.
    :vartype allow: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'allow': {'key': 'properties.allow', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        allow: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword allow: :code:`<code>true</code>` to allow access to a publishing method; otherwise,
         :code:`<code>false</code>`.
        :paramtype allow: bool
        """
        super(CsmPublishingCredentialsPoliciesEntity, self).__init__(kind=kind, **kwargs)
        self.allow = allow


class CsmPublishingProfileOptions(msrest.serialization.Model):
    """Publishing options for requested profile.

    :ivar format: Name of the format. Valid values are:
     FileZilla3
     WebDeploy -- default
     Ftp. Possible values include: "FileZilla3", "WebDeploy", "Ftp".
    :vartype format: str or ~azure.mgmt.web.v2021_01_15.models.PublishingProfileFormat
    :ivar include_disaster_recovery_endpoints: Include the DisasterRecover endpoint if true.
    :vartype include_disaster_recovery_endpoints: bool
    """

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'include_disaster_recovery_endpoints': {'key': 'includeDisasterRecoveryEndpoints', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        format: Optional[Union[str, "PublishingProfileFormat"]] = None,
        include_disaster_recovery_endpoints: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword format: Name of the format. Valid values are:
         FileZilla3
         WebDeploy -- default
         Ftp. Possible values include: "FileZilla3", "WebDeploy", "Ftp".
        :paramtype format: str or ~azure.mgmt.web.v2021_01_15.models.PublishingProfileFormat
        :keyword include_disaster_recovery_endpoints: Include the DisasterRecover endpoint if true.
        :paramtype include_disaster_recovery_endpoints: bool
        """
        super(CsmPublishingProfileOptions, self).__init__(**kwargs)
        self.format = format
        self.include_disaster_recovery_endpoints = include_disaster_recovery_endpoints


class CsmSlotEntity(msrest.serialization.Model):
    """Deployment slot parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar target_slot: Required. Destination deployment slot during swap operation.
    :vartype target_slot: str
    :ivar preserve_vnet: Required. :code:`<code>true</code>` to preserve Virtual Network to the
     slot during swap; otherwise, :code:`<code>false</code>`.
    :vartype preserve_vnet: bool
    """

    _validation = {
        'target_slot': {'required': True},
        'preserve_vnet': {'required': True},
    }

    _attribute_map = {
        'target_slot': {'key': 'targetSlot', 'type': 'str'},
        'preserve_vnet': {'key': 'preserveVnet', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        target_slot: str,
        preserve_vnet: bool,
        **kwargs
    ):
        """
        :keyword target_slot: Required. Destination deployment slot during swap operation.
        :paramtype target_slot: str
        :keyword preserve_vnet: Required. :code:`<code>true</code>` to preserve Virtual Network to the
         slot during swap; otherwise, :code:`<code>false</code>`.
        :paramtype preserve_vnet: bool
        """
        super(CsmSlotEntity, self).__init__(**kwargs)
        self.target_slot = target_slot
        self.preserve_vnet = preserve_vnet


class CsmUsageQuota(msrest.serialization.Model):
    """Usage of the quota resource.

    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: long
    :ivar limit: The resource limit.
    :vartype limit: long
    :ivar name: Quota name.
    :vartype name: ~azure.mgmt.web.v2021_01_15.models.LocalizableString
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
    }

    def __init__(
        self,
        *,
        unit: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["LocalizableString"] = None,
        **kwargs
    ):
        """
        :keyword unit: Units of measurement for the quota resource.
        :paramtype unit: str
        :keyword next_reset_time: Next reset time for the resource counter.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: The current value of the resource counter.
        :paramtype current_value: long
        :keyword limit: The resource limit.
        :paramtype limit: long
        :keyword name: Quota name.
        :paramtype name: ~azure.mgmt.web.v2021_01_15.models.LocalizableString
        """
        super(CsmUsageQuota, self).__init__(**kwargs)
        self.unit = unit
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class CsmUsageQuotaCollection(msrest.serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmUsageQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CsmUsageQuota"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.CsmUsageQuota]
        """
        super(CsmUsageQuotaCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CustomHostnameAnalysisResult(ProxyOnlyResource):
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Possible values include:
     "Passed", "Failed", "Skipped".
    :vartype custom_domain_verification_test: str or
     ~azure.mgmt.web.v2021_01_15.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~azure.mgmt.web.v2021_01_15.models.ErrorEntity
    :ivar has_conflict_on_scale_unit: :code:`<code>true</code>` if there is a conflict on a scale
     unit; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_scale_unit: bool
    :ivar has_conflict_across_subscription: :code:`<code>true</code>` if there is a conflict across
     subscriptions; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_across_subscription: bool
    :ivar conflicting_app_resource_id: Name of the conflicting app on scale unit if it's within the
     same subscription.
    :vartype conflicting_app_resource_id: str
    :ivar c_name_records: CName records controller can see for this hostname.
    :vartype c_name_records: list[str]
    :ivar txt_records: TXT records controller can see for this hostname.
    :vartype txt_records: list[str]
    :ivar a_records: A records controller can see for this hostname.
    :vartype a_records: list[str]
    :ivar alternate_c_name_records: Alternate CName records controller can see for this hostname.
    :vartype alternate_c_name_records: list[str]
    :ivar alternate_txt_records: Alternate TXT records controller can see for this hostname.
    :vartype alternate_txt_records: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_hostname_already_verified': {'readonly': True},
        'custom_domain_verification_test': {'readonly': True},
        'custom_domain_verification_failure_info': {'readonly': True},
        'has_conflict_on_scale_unit': {'readonly': True},
        'has_conflict_across_subscription': {'readonly': True},
        'conflicting_app_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_hostname_already_verified': {'key': 'properties.isHostnameAlreadyVerified', 'type': 'bool'},
        'custom_domain_verification_test': {'key': 'properties.customDomainVerificationTest', 'type': 'str'},
        'custom_domain_verification_failure_info': {'key': 'properties.customDomainVerificationFailureInfo', 'type': 'ErrorEntity'},
        'has_conflict_on_scale_unit': {'key': 'properties.hasConflictOnScaleUnit', 'type': 'bool'},
        'has_conflict_across_subscription': {'key': 'properties.hasConflictAcrossSubscription', 'type': 'bool'},
        'conflicting_app_resource_id': {'key': 'properties.conflictingAppResourceId', 'type': 'str'},
        'c_name_records': {'key': 'properties.cNameRecords', 'type': '[str]'},
        'txt_records': {'key': 'properties.txtRecords', 'type': '[str]'},
        'a_records': {'key': 'properties.aRecords', 'type': '[str]'},
        'alternate_c_name_records': {'key': 'properties.alternateCNameRecords', 'type': '[str]'},
        'alternate_txt_records': {'key': 'properties.alternateTxtRecords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        c_name_records: Optional[List[str]] = None,
        txt_records: Optional[List[str]] = None,
        a_records: Optional[List[str]] = None,
        alternate_c_name_records: Optional[List[str]] = None,
        alternate_txt_records: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword c_name_records: CName records controller can see for this hostname.
        :paramtype c_name_records: list[str]
        :keyword txt_records: TXT records controller can see for this hostname.
        :paramtype txt_records: list[str]
        :keyword a_records: A records controller can see for this hostname.
        :paramtype a_records: list[str]
        :keyword alternate_c_name_records: Alternate CName records controller can see for this
         hostname.
        :paramtype alternate_c_name_records: list[str]
        :keyword alternate_txt_records: Alternate TXT records controller can see for this hostname.
        :paramtype alternate_txt_records: list[str]
        """
        super(CustomHostnameAnalysisResult, self).__init__(kind=kind, **kwargs)
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_scale_unit = None
        self.has_conflict_across_subscription = None
        self.conflicting_app_resource_id = None
        self.c_name_records = c_name_records
        self.txt_records = txt_records
        self.a_records = a_records
        self.alternate_c_name_records = alternate_c_name_records
        self.alternate_txt_records = alternate_txt_records


class CustomOpenIdConnectProvider(msrest.serialization.Model):
    """The configuration settings of the custom Open ID Connect provider.

    :ivar enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not be
     enabled; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the custom Open ID
     Connect provider.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.OpenIdConnectRegistration
    :ivar login: The configuration settings of the login flow of the custom Open ID Connect
     provider.
    :vartype login: ~azure.mgmt.web.v2021_01_15.models.OpenIdConnectLogin
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'OpenIdConnectRegistration'},
        'login': {'key': 'login', 'type': 'OpenIdConnectLogin'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["OpenIdConnectRegistration"] = None,
        login: Optional["OpenIdConnectLogin"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not
         be enabled; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the custom Open
         ID Connect provider.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.OpenIdConnectRegistration
        :keyword login: The configuration settings of the login flow of the custom Open ID Connect
         provider.
        :paramtype login: ~azure.mgmt.web.v2021_01_15.models.OpenIdConnectLogin
        """
        super(CustomOpenIdConnectProvider, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class DatabaseBackupSetting(msrest.serialization.Model):
    """Database backup settings.

    All required parameters must be populated in order to send to Azure.

    :ivar database_type: Required. Database type (e.g. SqlAzure / MySql). Possible values include:
     "SqlAzure", "MySql", "LocalMySql", "PostgreSql".
    :vartype database_type: str or ~azure.mgmt.web.v2021_01_15.models.DatabaseType
    :ivar name:
    :vartype name: str
    :ivar connection_string_name: Contains a connection string name that is linked to the
     SiteConfig.ConnectionStrings.
     This is used during restore with overwrite connection strings options.
    :vartype connection_string_name: str
    :ivar connection_string: Contains a connection string to a database which is being backed up or
     restored. If the restore should happen to a new database, the database name inside is the new
     one.
    :vartype connection_string: str
    """

    _validation = {
        'database_type': {'required': True},
    }

    _attribute_map = {
        'database_type': {'key': 'databaseType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'connection_string_name': {'key': 'connectionStringName', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        database_type: Union[str, "DatabaseType"],
        name: Optional[str] = None,
        connection_string_name: Optional[str] = None,
        connection_string: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword database_type: Required. Database type (e.g. SqlAzure / MySql). Possible values
         include: "SqlAzure", "MySql", "LocalMySql", "PostgreSql".
        :paramtype database_type: str or ~azure.mgmt.web.v2021_01_15.models.DatabaseType
        :keyword name:
        :paramtype name: str
        :keyword connection_string_name: Contains a connection string name that is linked to the
         SiteConfig.ConnectionStrings.
         This is used during restore with overwrite connection strings options.
        :paramtype connection_string_name: str
        :keyword connection_string: Contains a connection string to a database which is being backed up
         or restored. If the restore should happen to a new database, the database name inside is the
         new one.
        :paramtype connection_string: str
        """
        super(DatabaseBackupSetting, self).__init__(**kwargs)
        self.database_type = database_type
        self.name = name
        self.connection_string_name = connection_string_name
        self.connection_string = connection_string


class DataProviderMetadata(msrest.serialization.Model):
    """Additional configuration for a data providers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider_name:
    :vartype provider_name: str
    :ivar property_bag: Settings for the data provider.
    :vartype property_bag: list[~azure.mgmt.web.v2021_01_15.models.KeyValuePairStringObject]
    """

    _validation = {
        'property_bag': {'readonly': True},
    }

    _attribute_map = {
        'provider_name': {'key': 'providerName', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '[KeyValuePairStringObject]'},
    }

    def __init__(
        self,
        *,
        provider_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider_name:
        :paramtype provider_name: str
        """
        super(DataProviderMetadata, self).__init__(**kwargs)
        self.provider_name = provider_name
        self.property_bag = None


class DataSource(msrest.serialization.Model):
    """Class representing data source used by the detectors.

    :ivar instructions: Instructions if any for the data source.
    :vartype instructions: list[str]
    :ivar data_source_uri: Datasource Uri Links.
    :vartype data_source_uri: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
    """

    _attribute_map = {
        'instructions': {'key': 'instructions', 'type': '[str]'},
        'data_source_uri': {'key': 'dataSourceUri', 'type': '[NameValuePair]'},
    }

    def __init__(
        self,
        *,
        instructions: Optional[List[str]] = None,
        data_source_uri: Optional[List["NameValuePair"]] = None,
        **kwargs
    ):
        """
        :keyword instructions: Instructions if any for the data source.
        :paramtype instructions: list[str]
        :keyword data_source_uri: Datasource Uri Links.
        :paramtype data_source_uri: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
        """
        super(DataSource, self).__init__(**kwargs)
        self.instructions = instructions
        self.data_source_uri = data_source_uri


class DataTableResponseColumn(msrest.serialization.Model):
    """Column definition.

    :ivar column_name: Name of the column.
    :vartype column_name: str
    :ivar data_type: Data type which looks like 'String' or 'Int32'.
    :vartype data_type: str
    :ivar column_type: Column Type.
    :vartype column_type: str
    """

    _attribute_map = {
        'column_name': {'key': 'columnName', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'column_type': {'key': 'columnType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[str] = None,
        column_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword column_name: Name of the column.
        :paramtype column_name: str
        :keyword data_type: Data type which looks like 'String' or 'Int32'.
        :paramtype data_type: str
        :keyword column_type: Column Type.
        :paramtype column_type: str
        """
        super(DataTableResponseColumn, self).__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type
        self.column_type = column_type


class DataTableResponseObject(msrest.serialization.Model):
    """Data Table which defines columns and raw row values.

    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar columns: List of columns with data types.
    :vartype columns: list[~azure.mgmt.web.v2021_01_15.models.DataTableResponseColumn]
    :ivar rows: Raw row values.
    :vartype rows: list[list[str]]
    """

    _attribute_map = {
        'table_name': {'key': 'tableName', 'type': 'str'},
        'columns': {'key': 'columns', 'type': '[DataTableResponseColumn]'},
        'rows': {'key': 'rows', 'type': '[[str]]'},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        columns: Optional[List["DataTableResponseColumn"]] = None,
        rows: Optional[List[List[str]]] = None,
        **kwargs
    ):
        """
        :keyword table_name: Name of the table.
        :paramtype table_name: str
        :keyword columns: List of columns with data types.
        :paramtype columns: list[~azure.mgmt.web.v2021_01_15.models.DataTableResponseColumn]
        :keyword rows: Raw row values.
        :paramtype rows: list[list[str]]
        """
        super(DataTableResponseObject, self).__init__(**kwargs)
        self.table_name = table_name
        self.columns = columns
        self.rows = rows


class DefaultErrorResponse(msrest.serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.web.v2021_01_15.models.DefaultErrorResponseError
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'DefaultErrorResponseError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DefaultErrorResponse, self).__init__(**kwargs)
        self.error = None


class DefaultErrorResponseError(msrest.serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.web.v2021_01_15.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'innererror': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DefaultErrorResponseErrorDetailsItem]'},
        'innererror': {'key': 'innererror', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["DefaultErrorResponseErrorDetailsItem"]] = None,
        **kwargs
    ):
        """
        :keyword details:
        :paramtype details:
         list[~azure.mgmt.web.v2021_01_15.models.DefaultErrorResponseErrorDetailsItem]
        """
        super(DefaultErrorResponseError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = details
        self.innererror = None


class DefaultErrorResponseErrorDetailsItem(msrest.serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DefaultErrorResponseErrorDetailsItem, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class DeletedAppRestoreRequest(ProxyOnlyResource):
    """Details about restoring a deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: ARM resource ID of the deleted app. Example:
     /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
    :vartype deleted_site_id: str
    :ivar recover_configuration: If true, deleted site configuration, in addition to content, will
     be restored.
    :vartype recover_configuration: bool
    :ivar snapshot_time: Point in time to restore the deleted app from, formatted as a DateTime
     string.
     If unspecified, default value is the time that the app was deleted.
    :vartype snapshot_time: str
    :ivar use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :vartype use_dr_secondary: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deleted_site_id': {'key': 'properties.deletedSiteId', 'type': 'str'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'use_dr_secondary': {'key': 'properties.useDRSecondary', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        deleted_site_id: Optional[str] = None,
        recover_configuration: Optional[bool] = None,
        snapshot_time: Optional[str] = None,
        use_dr_secondary: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword deleted_site_id: ARM resource ID of the deleted app. Example:
         /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
        :paramtype deleted_site_id: str
        :keyword recover_configuration: If true, deleted site configuration, in addition to content,
         will be restored.
        :paramtype recover_configuration: bool
        :keyword snapshot_time: Point in time to restore the deleted app from, formatted as a DateTime
         string.
         If unspecified, default value is the time that the app was deleted.
        :paramtype snapshot_time: str
        :keyword use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
        :paramtype use_dr_secondary: bool
        """
        super(DeletedAppRestoreRequest, self).__init__(kind=kind, **kwargs)
        self.deleted_site_id = deleted_site_id
        self.recover_configuration = recover_configuration
        self.snapshot_time = snapshot_time
        self.use_dr_secondary = use_dr_secondary


class DeletedSite(ProxyOnlyResource):
    """A deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: Numeric id for the deleted site.
    :vartype deleted_site_id: int
    :ivar deleted_timestamp: Time in UTC when the app was deleted.
    :vartype deleted_timestamp: str
    :ivar subscription: Subscription containing the deleted site.
    :vartype subscription: str
    :ivar resource_group: ResourceGroup that contained the deleted site.
    :vartype resource_group: str
    :ivar deleted_site_name: Name of the deleted site.
    :vartype deleted_site_name: str
    :ivar slot: Slot of the deleted site.
    :vartype slot: str
    :ivar kind_properties_kind: Kind of site that was deleted.
    :vartype kind_properties_kind: str
    :ivar geo_region_name: Geo Region of the deleted site.
    :vartype geo_region_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deleted_site_id': {'readonly': True},
        'deleted_timestamp': {'readonly': True},
        'subscription': {'readonly': True},
        'resource_group': {'readonly': True},
        'deleted_site_name': {'readonly': True},
        'slot': {'readonly': True},
        'kind_properties_kind': {'readonly': True},
        'geo_region_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deleted_site_id': {'key': 'properties.deletedSiteId', 'type': 'int'},
        'deleted_timestamp': {'key': 'properties.deletedTimestamp', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'deleted_site_name': {'key': 'properties.deletedSiteName', 'type': 'str'},
        'slot': {'key': 'properties.slot', 'type': 'str'},
        'kind_properties_kind': {'key': 'properties.kind', 'type': 'str'},
        'geo_region_name': {'key': 'properties.geoRegionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(DeletedSite, self).__init__(kind=kind, **kwargs)
        self.deleted_site_id = None
        self.deleted_timestamp = None
        self.subscription = None
        self.resource_group = None
        self.deleted_site_name = None
        self.slot = None
        self.kind_properties_kind = None
        self.geo_region_name = None


class DeletedWebAppCollection(msrest.serialization.Model):
    """Collection of deleted apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.DeletedSite]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedSite]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DeletedSite"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.DeletedSite]
        """
        super(DeletedWebAppCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Deployment(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Deployment status.
    :vartype status: int
    :ivar message: Details about deployment status.
    :vartype message: str
    :ivar author: Who authored the deployment.
    :vartype author: str
    :ivar deployer: Who performed the deployment.
    :vartype deployer: str
    :ivar author_email: Author email.
    :vartype author_email: str
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time.
    :vartype end_time: ~datetime.datetime
    :ivar active: True if deployment is currently active, false if completed and null if not
     started.
    :vartype active: bool
    :ivar details: Details on deployment.
    :vartype details: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'int'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'author_email': {'key': 'properties.author_email', 'type': 'str'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.end_time', 'type': 'iso-8601'},
        'active': {'key': 'properties.active', 'type': 'bool'},
        'details': {'key': 'properties.details', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[int] = None,
        message: Optional[str] = None,
        author: Optional[str] = None,
        deployer: Optional[str] = None,
        author_email: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        active: Optional[bool] = None,
        details: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword status: Deployment status.
        :paramtype status: int
        :keyword message: Details about deployment status.
        :paramtype message: str
        :keyword author: Who authored the deployment.
        :paramtype author: str
        :keyword deployer: Who performed the deployment.
        :paramtype deployer: str
        :keyword author_email: Author email.
        :paramtype author_email: str
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time.
        :paramtype end_time: ~datetime.datetime
        :keyword active: True if deployment is currently active, false if completed and null if not
         started.
        :paramtype active: bool
        :keyword details: Details on deployment.
        :paramtype details: str
        """
        super(Deployment, self).__init__(kind=kind, **kwargs)
        self.status = status
        self.message = message
        self.author = author
        self.deployer = deployer
        self.author_email = author_email
        self.start_time = start_time
        self.end_time = end_time
        self.active = active
        self.details = details


class DeploymentCollection(msrest.serialization.Model):
    """Collection of app deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.Deployment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Deployment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Deployment"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.Deployment]
        """
        super(DeploymentCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DeploymentLocations(msrest.serialization.Model):
    """List of available locations (regions or App Service Environments) for
deployment of App Service resources.

    :ivar locations: Available regions.
    :vartype locations: list[~azure.mgmt.web.v2021_01_15.models.GeoRegion]
    :ivar hosting_environments: Available App Service Environments with full descriptions of the
     environments.
    :vartype hosting_environments: list[~azure.mgmt.web.v2021_01_15.models.AppServiceEnvironment]
    :ivar hosting_environment_deployment_infos: Available App Service Environments with basic
     information.
    :vartype hosting_environment_deployment_infos:
     list[~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentDeploymentInfo]
    """

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[GeoRegion]'},
        'hosting_environments': {'key': 'hostingEnvironments', 'type': '[AppServiceEnvironment]'},
        'hosting_environment_deployment_infos': {'key': 'hostingEnvironmentDeploymentInfos', 'type': '[HostingEnvironmentDeploymentInfo]'},
    }

    def __init__(
        self,
        *,
        locations: Optional[List["GeoRegion"]] = None,
        hosting_environments: Optional[List["AppServiceEnvironment"]] = None,
        hosting_environment_deployment_infos: Optional[List["HostingEnvironmentDeploymentInfo"]] = None,
        **kwargs
    ):
        """
        :keyword locations: Available regions.
        :paramtype locations: list[~azure.mgmt.web.v2021_01_15.models.GeoRegion]
        :keyword hosting_environments: Available App Service Environments with full descriptions of the
         environments.
        :paramtype hosting_environments: list[~azure.mgmt.web.v2021_01_15.models.AppServiceEnvironment]
        :keyword hosting_environment_deployment_infos: Available App Service Environments with basic
         information.
        :paramtype hosting_environment_deployment_infos:
         list[~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentDeploymentInfo]
        """
        super(DeploymentLocations, self).__init__(**kwargs)
        self.locations = locations
        self.hosting_environments = hosting_environments
        self.hosting_environment_deployment_infos = hosting_environment_deployment_infos


class DetectorAbnormalTimePeriod(msrest.serialization.Model):
    """Class representing Abnormal Time Period detected.

    :ivar start_time: Start time of the correlated event.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the correlated event.
    :vartype end_time: ~datetime.datetime
    :ivar message: Message describing the event.
    :vartype message: str
    :ivar source: Represents the name of the Detector.
    :vartype source: str
    :ivar priority: Represents the rank of the Detector.
    :vartype priority: float
    :ivar meta_data: Downtime metadata.
    :vartype meta_data: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
    :ivar type: Represents the type of the Detector. Possible values include: "ServiceIncident",
     "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
     "PlatformIssue", "Other".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.IssueType
    :ivar solutions: List of proposed solutions.
    :vartype solutions: list[~azure.mgmt.web.v2021_01_15.models.Solution]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'float'},
        'meta_data': {'key': 'metaData', 'type': '[[NameValuePair]]'},
        'type': {'key': 'type', 'type': 'str'},
        'solutions': {'key': 'solutions', 'type': '[Solution]'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        source: Optional[str] = None,
        priority: Optional[float] = None,
        meta_data: Optional[List[List["NameValuePair"]]] = None,
        type: Optional[Union[str, "IssueType"]] = None,
        solutions: Optional[List["Solution"]] = None,
        **kwargs
    ):
        """
        :keyword start_time: Start time of the correlated event.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the correlated event.
        :paramtype end_time: ~datetime.datetime
        :keyword message: Message describing the event.
        :paramtype message: str
        :keyword source: Represents the name of the Detector.
        :paramtype source: str
        :keyword priority: Represents the rank of the Detector.
        :paramtype priority: float
        :keyword meta_data: Downtime metadata.
        :paramtype meta_data: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
        :keyword type: Represents the type of the Detector. Possible values include: "ServiceIncident",
         "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
         "PlatformIssue", "Other".
        :paramtype type: str or ~azure.mgmt.web.v2021_01_15.models.IssueType
        :keyword solutions: List of proposed solutions.
        :paramtype solutions: list[~azure.mgmt.web.v2021_01_15.models.Solution]
        """
        super(DetectorAbnormalTimePeriod, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.message = message
        self.source = source
        self.priority = priority
        self.meta_data = meta_data
        self.type = type
        self.solutions = solutions


class DetectorDefinition(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the detector.
    :vartype display_name: str
    :ivar description: Description of the detector.
    :vartype description: str
    :ivar rank: Detector Rank.
    :vartype rank: float
    :ivar is_enabled: Flag representing whether detector is enabled or not.
    :vartype is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'rank': {'readonly': True},
        'is_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'rank': {'key': 'properties.rank', 'type': 'float'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(DetectorDefinition, self).__init__(kind=kind, **kwargs)
        self.display_name = None
        self.description = None
        self.rank = None
        self.is_enabled = None


class DetectorInfo(msrest.serialization.Model):
    """Definition of Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of detector.
    :vartype id: str
    :ivar name: Name of detector.
    :vartype name: str
    :ivar description: Short description of the detector and its purpose.
    :vartype description: str
    :ivar author: Author of the detector.
    :vartype author: str
    :ivar category: Problem category. This serves for organizing group for detectors.
    :vartype category: str
    :ivar support_topic_list: List of Support Topics for which this detector is enabled.
    :vartype support_topic_list: list[~azure.mgmt.web.v2021_01_15.models.SupportTopic]
    :ivar analysis_type: Analysis Types for which this detector should apply to.
    :vartype analysis_type: list[str]
    :ivar type: Whether this detector is an Analysis Detector or not. Possible values include:
     "Detector", "Analysis", "CategoryOverview".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.DetectorType
    :ivar score: Defines score of a detector to power ML based matching.
    :vartype score: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'description': {'readonly': True},
        'author': {'readonly': True},
        'category': {'readonly': True},
        'support_topic_list': {'readonly': True},
        'analysis_type': {'readonly': True},
        'type': {'readonly': True},
        'score': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'author': {'key': 'author', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'support_topic_list': {'key': 'supportTopicList', 'type': '[SupportTopic]'},
        'analysis_type': {'key': 'analysisType', 'type': '[str]'},
        'type': {'key': 'type', 'type': 'str'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DetectorInfo, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.description = None
        self.author = None
        self.category = None
        self.support_topic_list = None
        self.analysis_type = None
        self.type = None
        self.score = None


class DetectorResponse(ProxyOnlyResource):
    """Class representing Response from Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar metadata: metadata for the detector.
    :vartype metadata: ~azure.mgmt.web.v2021_01_15.models.DetectorInfo
    :ivar dataset: Data Set.
    :vartype dataset: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticData]
    :ivar status: Indicates status of the most severe insight.
    :vartype status: ~azure.mgmt.web.v2021_01_15.models.Status
    :ivar data_providers_metadata: Additional configuration for different data providers to be used
     by the UI.
    :vartype data_providers_metadata: list[~azure.mgmt.web.v2021_01_15.models.DataProviderMetadata]
    :ivar suggested_utterances: Suggested utterances where the detector can be applicable.
    :vartype suggested_utterances: ~azure.mgmt.web.v2021_01_15.models.QueryUtterancesResults
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'DetectorInfo'},
        'dataset': {'key': 'properties.dataset', 'type': '[DiagnosticData]'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'data_providers_metadata': {'key': 'properties.dataProvidersMetadata', 'type': '[DataProviderMetadata]'},
        'suggested_utterances': {'key': 'properties.suggestedUtterances', 'type': 'QueryUtterancesResults'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["DetectorInfo"] = None,
        dataset: Optional[List["DiagnosticData"]] = None,
        status: Optional["Status"] = None,
        data_providers_metadata: Optional[List["DataProviderMetadata"]] = None,
        suggested_utterances: Optional["QueryUtterancesResults"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword metadata: metadata for the detector.
        :paramtype metadata: ~azure.mgmt.web.v2021_01_15.models.DetectorInfo
        :keyword dataset: Data Set.
        :paramtype dataset: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticData]
        :keyword status: Indicates status of the most severe insight.
        :paramtype status: ~azure.mgmt.web.v2021_01_15.models.Status
        :keyword data_providers_metadata: Additional configuration for different data providers to be
         used by the UI.
        :paramtype data_providers_metadata:
         list[~azure.mgmt.web.v2021_01_15.models.DataProviderMetadata]
        :keyword suggested_utterances: Suggested utterances where the detector can be applicable.
        :paramtype suggested_utterances: ~azure.mgmt.web.v2021_01_15.models.QueryUtterancesResults
        """
        super(DetectorResponse, self).__init__(kind=kind, **kwargs)
        self.metadata = metadata
        self.dataset = dataset
        self.status = status
        self.data_providers_metadata = data_providers_metadata
        self.suggested_utterances = suggested_utterances


class DetectorResponseCollection(msrest.serialization.Model):
    """Collection of detector responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.DetectorResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DetectorResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DetectorResponse"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.DetectorResponse]
        """
        super(DetectorResponseCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticAnalysis(ProxyOnlyResource):
    """Class representing a diagnostic analysis done on an application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar abnormal_time_periods: List of time periods.
    :vartype abnormal_time_periods: list[~azure.mgmt.web.v2021_01_15.models.AbnormalTimePeriod]
    :ivar payload: Data by each detector.
    :vartype payload: list[~azure.mgmt.web.v2021_01_15.models.AnalysisData]
    :ivar non_correlated_detectors: Data by each detector for detectors that did not corelate.
    :vartype non_correlated_detectors: list[~azure.mgmt.web.v2021_01_15.models.DetectorDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'abnormal_time_periods': {'key': 'properties.abnormalTimePeriods', 'type': '[AbnormalTimePeriod]'},
        'payload': {'key': 'properties.payload', 'type': '[AnalysisData]'},
        'non_correlated_detectors': {'key': 'properties.nonCorrelatedDetectors', 'type': '[DetectorDefinition]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        abnormal_time_periods: Optional[List["AbnormalTimePeriod"]] = None,
        payload: Optional[List["AnalysisData"]] = None,
        non_correlated_detectors: Optional[List["DetectorDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword abnormal_time_periods: List of time periods.
        :paramtype abnormal_time_periods: list[~azure.mgmt.web.v2021_01_15.models.AbnormalTimePeriod]
        :keyword payload: Data by each detector.
        :paramtype payload: list[~azure.mgmt.web.v2021_01_15.models.AnalysisData]
        :keyword non_correlated_detectors: Data by each detector for detectors that did not corelate.
        :paramtype non_correlated_detectors:
         list[~azure.mgmt.web.v2021_01_15.models.DetectorDefinition]
        """
        super(DiagnosticAnalysis, self).__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.abnormal_time_periods = abnormal_time_periods
        self.payload = payload
        self.non_correlated_detectors = non_correlated_detectors


class DiagnosticAnalysisCollection(msrest.serialization.Model):
    """Collection of Diagnostic Analyses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.AnalysisDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AnalysisDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AnalysisDefinition"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.AnalysisDefinition]
        """
        super(DiagnosticAnalysisCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticCategory(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the diagnostic category.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(DiagnosticCategory, self).__init__(kind=kind, **kwargs)
        self.description = None


class DiagnosticCategoryCollection(msrest.serialization.Model):
    """Collection of Diagnostic Categories.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticCategory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticCategory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DiagnosticCategory"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticCategory]
        """
        super(DiagnosticCategoryCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticData(msrest.serialization.Model):
    """Set of data with rendering instructions.

    :ivar table: Data in table form.
    :vartype table: ~azure.mgmt.web.v2021_01_15.models.DataTableResponseObject
    :ivar rendering_properties: Properties that describe how the table should be rendered.
    :vartype rendering_properties: ~azure.mgmt.web.v2021_01_15.models.Rendering
    """

    _attribute_map = {
        'table': {'key': 'table', 'type': 'DataTableResponseObject'},
        'rendering_properties': {'key': 'renderingProperties', 'type': 'Rendering'},
    }

    def __init__(
        self,
        *,
        table: Optional["DataTableResponseObject"] = None,
        rendering_properties: Optional["Rendering"] = None,
        **kwargs
    ):
        """
        :keyword table: Data in table form.
        :paramtype table: ~azure.mgmt.web.v2021_01_15.models.DataTableResponseObject
        :keyword rendering_properties: Properties that describe how the table should be rendered.
        :paramtype rendering_properties: ~azure.mgmt.web.v2021_01_15.models.Rendering
        """
        super(DiagnosticData, self).__init__(**kwargs)
        self.table = table
        self.rendering_properties = rendering_properties


class DiagnosticDetectorCollection(msrest.serialization.Model):
    """Collection of Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.DetectorDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DetectorDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DetectorDefinition"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.DetectorDefinition]
        """
        super(DiagnosticDetectorCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticDetectorResponse(ProxyOnlyResource):
    """Class representing Response from Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar issue_detected: Flag representing Issue was detected.
    :vartype issue_detected: bool
    :ivar detector_definition: Detector's definition.
    :vartype detector_definition: ~azure.mgmt.web.v2021_01_15.models.DetectorDefinition
    :ivar metrics: Metrics provided by the detector.
    :vartype metrics: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticMetricSet]
    :ivar abnormal_time_periods: List of Correlated events found by the detector.
    :vartype abnormal_time_periods:
     list[~azure.mgmt.web.v2021_01_15.models.DetectorAbnormalTimePeriod]
    :ivar data: Additional Data that detector wants to send.
    :vartype data: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
    :ivar response_meta_data: Meta Data.
    :vartype response_meta_data: ~azure.mgmt.web.v2021_01_15.models.ResponseMetaData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'issue_detected': {'key': 'properties.issueDetected', 'type': 'bool'},
        'detector_definition': {'key': 'properties.detectorDefinition', 'type': 'DetectorDefinition'},
        'metrics': {'key': 'properties.metrics', 'type': '[DiagnosticMetricSet]'},
        'abnormal_time_periods': {'key': 'properties.abnormalTimePeriods', 'type': '[DetectorAbnormalTimePeriod]'},
        'data': {'key': 'properties.data', 'type': '[[NameValuePair]]'},
        'response_meta_data': {'key': 'properties.responseMetaData', 'type': 'ResponseMetaData'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        issue_detected: Optional[bool] = None,
        detector_definition: Optional["DetectorDefinition"] = None,
        metrics: Optional[List["DiagnosticMetricSet"]] = None,
        abnormal_time_periods: Optional[List["DetectorAbnormalTimePeriod"]] = None,
        data: Optional[List[List["NameValuePair"]]] = None,
        response_meta_data: Optional["ResponseMetaData"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword issue_detected: Flag representing Issue was detected.
        :paramtype issue_detected: bool
        :keyword detector_definition: Detector's definition.
        :paramtype detector_definition: ~azure.mgmt.web.v2021_01_15.models.DetectorDefinition
        :keyword metrics: Metrics provided by the detector.
        :paramtype metrics: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticMetricSet]
        :keyword abnormal_time_periods: List of Correlated events found by the detector.
        :paramtype abnormal_time_periods:
         list[~azure.mgmt.web.v2021_01_15.models.DetectorAbnormalTimePeriod]
        :keyword data: Additional Data that detector wants to send.
        :paramtype data: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
        :keyword response_meta_data: Meta Data.
        :paramtype response_meta_data: ~azure.mgmt.web.v2021_01_15.models.ResponseMetaData
        """
        super(DiagnosticDetectorResponse, self).__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.issue_detected = issue_detected
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.abnormal_time_periods = abnormal_time_periods
        self.data = data
        self.response_meta_data = response_meta_data


class DiagnosticMetricSample(msrest.serialization.Model):
    """Class representing Diagnostic Metric.

    :ivar timestamp: Time at which metric is measured.
    :vartype timestamp: ~datetime.datetime
    :ivar role_instance: Role Instance. Null if this counter is not per instance
     This is returned and should be whichever instance name we desire to be returned
     i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
    :vartype role_instance: str
    :ivar total: Total value of the metric. If multiple measurements are made this will have sum of
     all.
    :vartype total: float
    :ivar maximum: Maximum of the metric sampled during the time period.
    :vartype maximum: float
    :ivar minimum: Minimum of the metric sampled during the time period.
    :vartype minimum: float
    :ivar is_aggregated: Whether the values are aggregates across all workers or not.
    :vartype is_aggregated: bool
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'role_instance': {'key': 'roleInstance', 'type': 'str'},
        'total': {'key': 'total', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'is_aggregated': {'key': 'isAggregated', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        role_instance: Optional[str] = None,
        total: Optional[float] = None,
        maximum: Optional[float] = None,
        minimum: Optional[float] = None,
        is_aggregated: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword timestamp: Time at which metric is measured.
        :paramtype timestamp: ~datetime.datetime
        :keyword role_instance: Role Instance. Null if this counter is not per instance
         This is returned and should be whichever instance name we desire to be returned
         i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
         where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
        :paramtype role_instance: str
        :keyword total: Total value of the metric. If multiple measurements are made this will have sum
         of all.
        :paramtype total: float
        :keyword maximum: Maximum of the metric sampled during the time period.
        :paramtype maximum: float
        :keyword minimum: Minimum of the metric sampled during the time period.
        :paramtype minimum: float
        :keyword is_aggregated: Whether the values are aggregates across all workers or not.
        :paramtype is_aggregated: bool
        """
        super(DiagnosticMetricSample, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.role_instance = role_instance
        self.total = total
        self.maximum = maximum
        self.minimum = minimum
        self.is_aggregated = is_aggregated


class DiagnosticMetricSet(msrest.serialization.Model):
    """Class representing Diagnostic Metric information.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar unit: Metric's unit.
    :vartype unit: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
    :vartype time_grain: str
    :ivar values: Collection of metric values for the selected period based on the
     {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
    :vartype values: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticMetricSample]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'values': {'key': 'values', 'type': '[DiagnosticMetricSample]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        unit: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["DiagnosticMetricSample"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword unit: Metric's unit.
        :paramtype unit: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
        :paramtype time_grain: str
        :keyword values: Collection of metric values for the selected period based on the
         {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
        :paramtype values: list[~azure.mgmt.web.v2021_01_15.models.DiagnosticMetricSample]
        """
        super(DiagnosticMetricSet, self).__init__(**kwargs)
        self.name = name
        self.unit = unit
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class Dimension(msrest.serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app, 
where instance name is dimension of the metric HTTP request.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar internal_name:
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox:
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword internal_name:
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox:
        :paramtype to_be_exported_for_shoebox: bool
        """
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class Domain(Resource):
    """Information about a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar contact_admin: Administrative contact.
    :vartype contact_admin: ~azure.mgmt.web.v2021_01_15.models.Contact
    :ivar contact_billing: Billing contact.
    :vartype contact_billing: ~azure.mgmt.web.v2021_01_15.models.Contact
    :ivar contact_registrant: Registrant contact.
    :vartype contact_registrant: ~azure.mgmt.web.v2021_01_15.models.Contact
    :ivar contact_tech: Technical contact.
    :vartype contact_tech: ~azure.mgmt.web.v2021_01_15.models.Contact
    :ivar registration_status: Domain registration status. Possible values include: "Active",
     "Awaiting", "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held",
     "Locked", "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown",
     "Unlocked", "Unparked", "Updated", "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2021_01_15.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :ivar privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :ivar auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2021_01_15.models.HostName]
    :ivar consent: Legal agreement consent.
    :vartype consent: ~azure.mgmt.web.v2021_01_15.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2021_01_15.models.DomainPropertiesDomainNotRenewableReasonsItem]
    :ivar dns_type: Current DNS type. Possible values include: "AzureDns",
     "DefaultDomainRegistrarDns".
    :vartype dns_type: str or ~azure.mgmt.web.v2021_01_15.models.DnsType
    :ivar dns_zone_id: Azure DNS Zone to use.
    :vartype dns_zone_id: str
    :ivar target_dns_type: Target DNS type (would be used for migration). Possible values include:
     "AzureDns", "DefaultDomainRegistrarDns".
    :vartype target_dns_type: str or ~azure.mgmt.web.v2021_01_15.models.DnsType
    :ivar auth_code:
    :vartype auth_code: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name_servers': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
        'managed_host_names': {'readonly': True},
        'domain_not_renewable_reasons': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
        'dns_type': {'key': 'properties.dnsType', 'type': 'str'},
        'dns_zone_id': {'key': 'properties.dnsZoneId', 'type': 'str'},
        'target_dns_type': {'key': 'properties.targetDnsType', 'type': 'str'},
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        contact_admin: Optional["Contact"] = None,
        contact_billing: Optional["Contact"] = None,
        contact_registrant: Optional["Contact"] = None,
        contact_tech: Optional["Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: Optional[bool] = True,
        consent: Optional["DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword contact_admin: Administrative contact.
        :paramtype contact_admin: ~azure.mgmt.web.v2021_01_15.models.Contact
        :keyword contact_billing: Billing contact.
        :paramtype contact_billing: ~azure.mgmt.web.v2021_01_15.models.Contact
        :keyword contact_registrant: Registrant contact.
        :paramtype contact_registrant: ~azure.mgmt.web.v2021_01_15.models.Contact
        :keyword contact_tech: Technical contact.
        :paramtype contact_tech: ~azure.mgmt.web.v2021_01_15.models.Contact
        :keyword privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
         otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        :keyword auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
         otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword consent: Legal agreement consent.
        :paramtype consent: ~azure.mgmt.web.v2021_01_15.models.DomainPurchaseConsent
        :keyword dns_type: Current DNS type. Possible values include: "AzureDns",
         "DefaultDomainRegistrarDns".
        :paramtype dns_type: str or ~azure.mgmt.web.v2021_01_15.models.DnsType
        :keyword dns_zone_id: Azure DNS Zone to use.
        :paramtype dns_zone_id: str
        :keyword target_dns_type: Target DNS type (would be used for migration). Possible values
         include: "AzureDns", "DefaultDomainRegistrarDns".
        :paramtype target_dns_type: str or ~azure.mgmt.web.v2021_01_15.models.DnsType
        :keyword auth_code:
        :paramtype auth_code: str
        """
        super(Domain, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainAvailabilityCheckResult(msrest.serialization.Model):
    """Domain availability check result.

    :ivar name: Name of the domain.
    :vartype name: str
    :ivar available: :code:`<code>true</code>` if domain can be purchased using CreateDomain API;
     otherwise, :code:`<code>false</code>`.
    :vartype available: bool
    :ivar domain_type: Valid values are Regular domain: Azure will charge the full price of domain
     registration, SoftDeleted: Purchasing this domain will simply restore it and this operation
     will not cost anything. Possible values include: "Regular", "SoftDeleted".
    :vartype domain_type: str or ~azure.mgmt.web.v2021_01_15.models.DomainType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'domain_type': {'key': 'domainType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available: Optional[bool] = None,
        domain_type: Optional[Union[str, "DomainType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the domain.
        :paramtype name: str
        :keyword available: :code:`<code>true</code>` if domain can be purchased using CreateDomain
         API; otherwise, :code:`<code>false</code>`.
        :paramtype available: bool
        :keyword domain_type: Valid values are Regular domain: Azure will charge the full price of
         domain registration, SoftDeleted: Purchasing this domain will simply restore it and this
         operation will not cost anything. Possible values include: "Regular", "SoftDeleted".
        :paramtype domain_type: str or ~azure.mgmt.web.v2021_01_15.models.DomainType
        """
        super(DomainAvailabilityCheckResult, self).__init__(**kwargs)
        self.name = name
        self.available = available
        self.domain_type = domain_type


class DomainCollection(msrest.serialization.Model):
    """Collection of domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.Domain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Domain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Domain"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.Domain]
        """
        super(DomainCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainControlCenterSsoRequest(msrest.serialization.Model):
    """Single sign-on request information for domain management.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar url: URL where the single sign-on request is to be made.
    :vartype url: str
    :ivar post_parameter_key: Post parameter key.
    :vartype post_parameter_key: str
    :ivar post_parameter_value: Post parameter value. Client should use
     'application/x-www-form-urlencoded' encoding for this value.
    :vartype post_parameter_value: str
    """

    _validation = {
        'url': {'readonly': True},
        'post_parameter_key': {'readonly': True},
        'post_parameter_value': {'readonly': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'post_parameter_key': {'key': 'postParameterKey', 'type': 'str'},
        'post_parameter_value': {'key': 'postParameterValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DomainControlCenterSsoRequest, self).__init__(**kwargs)
        self.url = None
        self.post_parameter_key = None
        self.post_parameter_value = None


class DomainOwnershipIdentifier(ProxyOnlyResource):
    """Domain ownership Identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar ownership_id: Ownership Id.
    :vartype ownership_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ownership_id': {'key': 'properties.ownershipId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        ownership_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword ownership_id: Ownership Id.
        :paramtype ownership_id: str
        """
        super(DomainOwnershipIdentifier, self).__init__(kind=kind, **kwargs)
        self.ownership_id = ownership_id


class DomainOwnershipIdentifierCollection(msrest.serialization.Model):
    """Collection of domain ownership identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DomainOwnershipIdentifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DomainOwnershipIdentifier"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier]
        """
        super(DomainOwnershipIdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DomainPatchResource(ProxyOnlyResource):
    """ARM resource for a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar contact_admin: Administrative contact.
    :vartype contact_admin: ~azure.mgmt.web.v2021_01_15.models.Contact
    :ivar contact_billing: Billing contact.
    :vartype contact_billing: ~azure.mgmt.web.v2021_01_15.models.Contact
    :ivar contact_registrant: Registrant contact.
    :vartype contact_registrant: ~azure.mgmt.web.v2021_01_15.models.Contact
    :ivar contact_tech: Technical contact.
    :vartype contact_tech: ~azure.mgmt.web.v2021_01_15.models.Contact
    :ivar registration_status: Domain registration status. Possible values include: "Active",
     "Awaiting", "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held",
     "Locked", "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown",
     "Unlocked", "Unparked", "Updated", "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2021_01_15.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_15.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :ivar privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :ivar auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2021_01_15.models.HostName]
    :ivar consent: Legal agreement consent.
    :vartype consent: ~azure.mgmt.web.v2021_01_15.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2021_01_15.models.DomainPatchResourcePropertiesDomainNotRenewableReasonsItem]
    :ivar dns_type: Current DNS type. Possible values include: "AzureDns",
     "DefaultDomainRegistrarDns".
    :vartype dns_type: str or ~azure.mgmt.web.v2021_01_15.models.DnsType
    :ivar dns_zone_id: Azure DNS Zone to use.
    :vartype dns_zone_id: str
    :ivar target_dns_type: Target DNS type (would be used for migration). Possible values include:
     "AzureDns", "DefaultDomainRegistrarDns".
    :vartype target_dns_type: str or ~azure.mgmt.web.v2021_01_15.models.DnsType
    :ivar auth_code:
    :vartype auth_code: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name_servers': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
        'managed_host_names': {'readonly': True},
        'domain_not_renewable_reasons': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
        'dns_type': {'key': 'properties.dnsType', 'type': 'str'},
        'dns_zone_id': {'key': 'properties.dnsZoneId', 'type': 'str'},
        'target_dns_type': {'key': 'properties.targetDnsType', 'type': 'str'},
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        contact_admin: Optional["Contact"] = None,
        contact_billing: Optional["Contact"] = None,
        contact_registrant: Optional["Contact"] = None,
        contact_tech: Optional["Contact"] = None,
        privacy: Optional[bool] = None,
        auto_renew: Optional[bool] = True,
        consent: Optional["DomainPurchaseConsent"] = None,
        dns_type: Optional[Union[str, "DnsType"]] = None,
        dns_zone_id: Optional[str] = None,
        target_dns_type: Optional[Union[str, "DnsType"]] = None,
        auth_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword contact_admin: Administrative contact.
        :paramtype contact_admin: ~azure.mgmt.web.v2021_01_15.models.Contact
        :keyword contact_billing: Billing contact.
        :paramtype contact_billing: ~azure.mgmt.web.v2021_01_15.models.Contact
        :keyword contact_registrant: Registrant contact.
        :paramtype contact_registrant: ~azure.mgmt.web.v2021_01_15.models.Contact
        :keyword contact_tech: Technical contact.
        :paramtype contact_tech: ~azure.mgmt.web.v2021_01_15.models.Contact
        :keyword privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
         otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        :keyword auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
         otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword consent: Legal agreement consent.
        :paramtype consent: ~azure.mgmt.web.v2021_01_15.models.DomainPurchaseConsent
        :keyword dns_type: Current DNS type. Possible values include: "AzureDns",
         "DefaultDomainRegistrarDns".
        :paramtype dns_type: str or ~azure.mgmt.web.v2021_01_15.models.DnsType
        :keyword dns_zone_id: Azure DNS Zone to use.
        :paramtype dns_zone_id: str
        :keyword target_dns_type: Target DNS type (would be used for migration). Possible values
         include: "AzureDns", "DefaultDomainRegistrarDns".
        :paramtype target_dns_type: str or ~azure.mgmt.web.v2021_01_15.models.DnsType
        :keyword auth_code:
        :paramtype auth_code: str
        """
        super(DomainPatchResource, self).__init__(kind=kind, **kwargs)
        self.contact_admin = contact_admin
        self.contact_billing = contact_billing
        self.contact_registrant = contact_registrant
        self.contact_tech = contact_tech
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = privacy
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = auto_renew
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = consent
        self.domain_not_renewable_reasons = None
        self.dns_type = dns_type
        self.dns_zone_id = dns_zone_id
        self.target_dns_type = target_dns_type
        self.auth_code = auth_code


class DomainPurchaseConsent(msrest.serialization.Model):
    """Domain purchase consent object, representing acceptance of applicable legal agreements.

    :ivar agreement_keys: List of applicable legal agreement keys. This list can be retrieved using
     ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
    :vartype agreement_keys: list[str]
    :ivar agreed_by: Client IP address.
    :vartype agreed_by: str
    :ivar agreed_at: Timestamp when the agreements were accepted.
    :vartype agreed_at: ~datetime.datetime
    """

    _attribute_map = {
        'agreement_keys': {'key': 'agreementKeys', 'type': '[str]'},
        'agreed_by': {'key': 'agreedBy', 'type': 'str'},
        'agreed_at': {'key': 'agreedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        agreement_keys: Optional[List[str]] = None,
        agreed_by: Optional[str] = None,
        agreed_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword agreement_keys: List of applicable legal agreement keys. This list can be retrieved
         using ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
        :paramtype agreement_keys: list[str]
        :keyword agreed_by: Client IP address.
        :paramtype agreed_by: str
        :keyword agreed_at: Timestamp when the agreements were accepted.
        :paramtype agreed_at: ~datetime.datetime
        """
        super(DomainPurchaseConsent, self).__init__(**kwargs)
        self.agreement_keys = agreement_keys
        self.agreed_by = agreed_by
        self.agreed_at = agreed_at


class DomainRecommendationSearchParameters(msrest.serialization.Model):
    """Domain recommendation search parameters.

    :ivar keywords: Keywords to be used for generating domain recommendations.
    :vartype keywords: str
    :ivar max_domain_recommendations: Maximum number of recommendations.
    :vartype max_domain_recommendations: int
    """

    _attribute_map = {
        'keywords': {'key': 'keywords', 'type': 'str'},
        'max_domain_recommendations': {'key': 'maxDomainRecommendations', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        keywords: Optional[str] = None,
        max_domain_recommendations: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword keywords: Keywords to be used for generating domain recommendations.
        :paramtype keywords: str
        :keyword max_domain_recommendations: Maximum number of recommendations.
        :paramtype max_domain_recommendations: int
        """
        super(DomainRecommendationSearchParameters, self).__init__(**kwargs)
        self.keywords = keywords
        self.max_domain_recommendations = max_domain_recommendations


class EnabledConfig(msrest.serialization.Model):
    """Enabled configuration.

    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super(EnabledConfig, self).__init__(**kwargs)
        self.enabled = enabled


class EndpointDependency(msrest.serialization.Model):
    """A domain name that a service is reached at, including details of the current connection status.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
    :vartype endpoint_details: list[~azure.mgmt.web.v2021_01_15.models.EndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["EndpointDetail"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name: The domain name of the dependency.
        :paramtype domain_name: str
        :keyword endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
        :paramtype endpoint_details: list[~azure.mgmt.web.v2021_01_15.models.EndpointDetail]
        """
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(msrest.serialization.Model):
    """Current TCP connectivity information from the App Service Environment to a single endpoint.

    :ivar ip_address: An IP Address that Domain Name currently resolves to.
    :vartype ip_address: str
    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar latency: The time in milliseconds it takes for a TCP connection to be created from the
     App Service Environment to this IpAddress at this Port.
    :vartype latency: float
    :ivar is_accessible: Whether it is possible to create a TCP connection from the App Service
     Environment to this IpAddress at this Port.
    :vartype is_accessible: bool
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'latency': {'key': 'latency', 'type': 'float'},
        'is_accessible': {'key': 'isAccessible', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        latency: Optional[float] = None,
        is_accessible: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword ip_address: An IP Address that Domain Name currently resolves to.
        :paramtype ip_address: str
        :keyword port: The port an endpoint is connected to.
        :paramtype port: int
        :keyword latency: The time in milliseconds it takes for a TCP connection to be created from the
         App Service Environment to this IpAddress at this Port.
        :paramtype latency: float
        :keyword is_accessible: Whether it is possible to create a TCP connection from the App Service
         Environment to this IpAddress at this Port.
        :paramtype is_accessible: bool
        """
        super(EndpointDetail, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.latency = latency
        self.is_accessible = is_accessible


class ErrorEntity(msrest.serialization.Model):
    """Body of the error response returned from the API.

    :ivar extended_code: Type of error.
    :vartype extended_code: str
    :ivar message_template: Message template.
    :vartype message_template: str
    :ivar parameters: Parameters for the template.
    :vartype parameters: list[str]
    :ivar inner_errors: Inner errors.
    :vartype inner_errors: list[~azure.mgmt.web.v2021_01_15.models.ErrorEntity]
    :ivar code: Basic error code.
    :vartype code: str
    :ivar message: Any details of the error.
    :vartype message: str
    """

    _attribute_map = {
        'extended_code': {'key': 'extendedCode', 'type': 'str'},
        'message_template': {'key': 'messageTemplate', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'inner_errors': {'key': 'innerErrors', 'type': '[ErrorEntity]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[List[str]] = None,
        inner_errors: Optional[List["ErrorEntity"]] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword extended_code: Type of error.
        :paramtype extended_code: str
        :keyword message_template: Message template.
        :paramtype message_template: str
        :keyword parameters: Parameters for the template.
        :paramtype parameters: list[str]
        :keyword inner_errors: Inner errors.
        :paramtype inner_errors: list[~azure.mgmt.web.v2021_01_15.models.ErrorEntity]
        :keyword code: Basic error code.
        :paramtype code: str
        :keyword message: Any details of the error.
        :paramtype message: str
        """
        super(ErrorEntity, self).__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.code = code
        self.message = message


class Experiments(msrest.serialization.Model):
    """Routing rules in production experiments.

    :ivar ramp_up_rules: List of ramp-up rules.
    :vartype ramp_up_rules: list[~azure.mgmt.web.v2021_01_15.models.RampUpRule]
    """

    _attribute_map = {
        'ramp_up_rules': {'key': 'rampUpRules', 'type': '[RampUpRule]'},
    }

    def __init__(
        self,
        *,
        ramp_up_rules: Optional[List["RampUpRule"]] = None,
        **kwargs
    ):
        """
        :keyword ramp_up_rules: List of ramp-up rules.
        :paramtype ramp_up_rules: list[~azure.mgmt.web.v2021_01_15.models.RampUpRule]
        """
        super(Experiments, self).__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class ExtendedLocation(msrest.serialization.Model):
    """Extended Location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of extended location.
    :vartype name: str
    :ivar type: Type of extended location.
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of extended location.
        :paramtype name: str
        """
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = name
        self.type = None


class Facebook(msrest.serialization.Model):
    """The configuration settings of the Facebook provider.

    :ivar enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
     despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Facebook
     provider.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.AppRegistration
    :ivar graph_api_version: The version of the Facebook api to be used while logging in.
    :vartype graph_api_version: str
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AppRegistration'},
        'graph_api_version': {'key': 'graphApiVersion', 'type': 'str'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["AppRegistration"] = None,
        graph_api_version: Optional[str] = None,
        login: Optional["LoginScopes"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Facebook
         provider.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.AppRegistration
        :keyword graph_api_version: The version of the Facebook api to be used while logging in.
        :paramtype graph_api_version: str
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
        """
        super(Facebook, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.graph_api_version = graph_api_version
        self.login = login


class FileSystemApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to file system configuration.

    :ivar level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :vartype level: str or ~azure.mgmt.web.v2021_01_15.models.LogLevel
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "LogLevel"]] = None,
        **kwargs
    ):
        """
        :keyword level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2021_01_15.models.LogLevel
        """
        super(FileSystemApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level


class FileSystemHttpLogsConfig(msrest.serialization.Model):
    """Http logs to file system configuration.

    :ivar retention_in_mb: Maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
    :vartype retention_in_mb: int
    :ivar retention_in_days: Retention in days.
     Remove files older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _validation = {
        'retention_in_mb': {'maximum': 100, 'minimum': 25},
    }

    _attribute_map = {
        'retention_in_mb': {'key': 'retentionInMb', 'type': 'int'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        retention_in_mb: Optional[int] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword retention_in_mb: Maximum size in megabytes that http log files can use.
         When reached old log files will be removed to make space for new ones.
         Value can range between 25 and 100.
        :paramtype retention_in_mb: int
        :keyword retention_in_days: Retention in days.
         Remove files older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super(FileSystemHttpLogsConfig, self).__init__(**kwargs)
        self.retention_in_mb = retention_in_mb
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class FileSystemTokenStore(msrest.serialization.Model):
    """The configuration settings of the storage of the tokens if a file system is used.

    :ivar directory: The directory in which the tokens will be stored.
    :vartype directory: str
    """

    _attribute_map = {
        'directory': {'key': 'directory', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        directory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword directory: The directory in which the tokens will be stored.
        :paramtype directory: str
        """
        super(FileSystemTokenStore, self).__init__(**kwargs)
        self.directory = directory


class ForwardProxy(msrest.serialization.Model):
    """The configuration settings of a forward proxy used to make the requests.

    :ivar convention: The convention used to determine the url of the request made. Possible values
     include: "NoProxy", "Standard", "Custom".
    :vartype convention: str or ~azure.mgmt.web.v2021_01_15.models.ForwardProxyConvention
    :ivar custom_host_header_name: The name of the header containing the host of the request.
    :vartype custom_host_header_name: str
    :ivar custom_proto_header_name: The name of the header containing the scheme of the request.
    :vartype custom_proto_header_name: str
    """

    _attribute_map = {
        'convention': {'key': 'convention', 'type': 'str'},
        'custom_host_header_name': {'key': 'customHostHeaderName', 'type': 'str'},
        'custom_proto_header_name': {'key': 'customProtoHeaderName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        convention: Optional[Union[str, "ForwardProxyConvention"]] = None,
        custom_host_header_name: Optional[str] = None,
        custom_proto_header_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword convention: The convention used to determine the url of the request made. Possible
         values include: "NoProxy", "Standard", "Custom".
        :paramtype convention: str or ~azure.mgmt.web.v2021_01_15.models.ForwardProxyConvention
        :keyword custom_host_header_name: The name of the header containing the host of the request.
        :paramtype custom_host_header_name: str
        :keyword custom_proto_header_name: The name of the header containing the scheme of the request.
        :paramtype custom_proto_header_name: str
        """
        super(ForwardProxy, self).__init__(**kwargs)
        self.convention = convention
        self.custom_host_header_name = custom_host_header_name
        self.custom_proto_header_name = custom_proto_header_name


class FrontEndConfiguration(msrest.serialization.Model):
    """FrontEndConfiguration.

    :ivar kind: Possible values include: "NodePort", "LoadBalancer".
    :vartype kind: str or ~azure.mgmt.web.v2021_01_15.models.FrontEndServiceType
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "FrontEndServiceType"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Possible values include: "NodePort", "LoadBalancer".
        :paramtype kind: str or ~azure.mgmt.web.v2021_01_15.models.FrontEndServiceType
        """
        super(FrontEndConfiguration, self).__init__(**kwargs)
        self.kind = kind


class FunctionAppMajorVersion(msrest.serialization.Model):
    """Function App stack major version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_text: Function App stack major version (display only).
    :vartype display_text: str
    :ivar value: Function App stack major version name.
    :vartype value: str
    :ivar minor_versions: Minor versions associated with the major version.
    :vartype minor_versions: list[~azure.mgmt.web.v2021_01_15.models.FunctionAppMinorVersion]
    """

    _validation = {
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'minor_versions': {'readonly': True},
    }

    _attribute_map = {
        'display_text': {'key': 'displayText', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'minor_versions': {'key': 'minorVersions', 'type': '[FunctionAppMinorVersion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FunctionAppMajorVersion, self).__init__(**kwargs)
        self.display_text = None
        self.value = None
        self.minor_versions = None


class FunctionAppMinorVersion(msrest.serialization.Model):
    """Function App stack minor version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_text: Function App stack (display only).
    :vartype display_text: str
    :ivar value: Function App stack name.
    :vartype value: str
    :ivar stack_settings: Settings associated with the minor version.
    :vartype stack_settings: ~azure.mgmt.web.v2021_01_15.models.FunctionAppRuntimes
    """

    _validation = {
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'stack_settings': {'readonly': True},
    }

    _attribute_map = {
        'display_text': {'key': 'displayText', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'stack_settings': {'key': 'stackSettings', 'type': 'FunctionAppRuntimes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FunctionAppMinorVersion, self).__init__(**kwargs)
        self.display_text = None
        self.value = None
        self.stack_settings = None


class FunctionAppRuntimes(msrest.serialization.Model):
    """Function App stack runtimes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar linux_runtime_settings: Linux-specific settings associated with the minor version.
    :vartype linux_runtime_settings: ~azure.mgmt.web.v2021_01_15.models.FunctionAppRuntimeSettings
    :ivar windows_runtime_settings: Windows-specific settings associated with the minor version.
    :vartype windows_runtime_settings:
     ~azure.mgmt.web.v2021_01_15.models.FunctionAppRuntimeSettings
    """

    _validation = {
        'linux_runtime_settings': {'readonly': True},
        'windows_runtime_settings': {'readonly': True},
    }

    _attribute_map = {
        'linux_runtime_settings': {'key': 'linuxRuntimeSettings', 'type': 'FunctionAppRuntimeSettings'},
        'windows_runtime_settings': {'key': 'windowsRuntimeSettings', 'type': 'FunctionAppRuntimeSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FunctionAppRuntimes, self).__init__(**kwargs)
        self.linux_runtime_settings = None
        self.windows_runtime_settings = None


class FunctionAppRuntimeSettings(msrest.serialization.Model):
    """Function App runtime settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar runtime_version: Function App stack minor version (runtime only).
    :vartype runtime_version: str
    :ivar remote_debugging_supported: :code:`<code>true</code>` if remote debugging is supported
     for the stack; otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_supported: bool
    :ivar app_insights_settings: Application Insights settings associated with the minor version.
    :vartype app_insights_settings:
     ~azure.mgmt.web.v2021_01_15.models.AppInsightsWebAppStackSettings
    :ivar git_hub_action_settings: GitHub Actions settings associated with the minor version.
    :vartype git_hub_action_settings:
     ~azure.mgmt.web.v2021_01_15.models.GitHubActionWebAppStackSettings
    :ivar app_settings_dictionary: Application settings associated with the minor version.
    :vartype app_settings_dictionary: dict[str, str]
    :ivar site_config_properties_dictionary: Configuration settings associated with the minor
     version.
    :vartype site_config_properties_dictionary:
     ~azure.mgmt.web.v2021_01_15.models.SiteConfigPropertiesDictionary
    :ivar supported_functions_extension_versions: List of supported Functions extension versions.
    :vartype supported_functions_extension_versions: list[str]
    :ivar is_preview: :code:`<code>true</code>` if the stack is in preview; otherwise,
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if the stack should be hidden; otherwise,
     :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar end_of_life_date: End-of-life date for the minor version.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar is_auto_update: :code:`<code>true</code>` if the stack version is auto-updated;
     otherwise, :code:`<code>false</code>`.
    :vartype is_auto_update: bool
    :ivar is_early_access: :code:`<code>true</code>` if the minor version is early-access;
     otherwise, :code:`<code>false</code>`.
    :vartype is_early_access: bool
    :ivar is_default: :code:`<code>true</code>` if the minor version the default; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    """

    _validation = {
        'runtime_version': {'readonly': True},
        'remote_debugging_supported': {'readonly': True},
        'app_insights_settings': {'readonly': True},
        'git_hub_action_settings': {'readonly': True},
        'app_settings_dictionary': {'readonly': True},
        'site_config_properties_dictionary': {'readonly': True},
        'supported_functions_extension_versions': {'readonly': True},
        'is_preview': {'readonly': True},
        'is_deprecated': {'readonly': True},
        'is_hidden': {'readonly': True},
        'end_of_life_date': {'readonly': True},
        'is_auto_update': {'readonly': True},
        'is_early_access': {'readonly': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'remote_debugging_supported': {'key': 'remoteDebuggingSupported', 'type': 'bool'},
        'app_insights_settings': {'key': 'appInsightsSettings', 'type': 'AppInsightsWebAppStackSettings'},
        'git_hub_action_settings': {'key': 'gitHubActionSettings', 'type': 'GitHubActionWebAppStackSettings'},
        'app_settings_dictionary': {'key': 'appSettingsDictionary', 'type': '{str}'},
        'site_config_properties_dictionary': {'key': 'siteConfigPropertiesDictionary', 'type': 'SiteConfigPropertiesDictionary'},
        'supported_functions_extension_versions': {'key': 'supportedFunctionsExtensionVersions', 'type': '[str]'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'is_auto_update': {'key': 'isAutoUpdate', 'type': 'bool'},
        'is_early_access': {'key': 'isEarlyAccess', 'type': 'bool'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(FunctionAppRuntimeSettings, self).__init__(**kwargs)
        self.runtime_version = None
        self.remote_debugging_supported = None
        self.app_insights_settings = None
        self.git_hub_action_settings = None
        self.app_settings_dictionary = None
        self.site_config_properties_dictionary = None
        self.supported_functions_extension_versions = None
        self.is_preview = None
        self.is_deprecated = None
        self.is_hidden = None
        self.end_of_life_date = None
        self.is_auto_update = None
        self.is_early_access = None
        self.is_default = None


class FunctionAppStack(ProxyOnlyResource):
    """Function App Stack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Function App stack location.
    :vartype location: str
    :ivar display_text: Function App stack (display only).
    :vartype display_text: str
    :ivar value: Function App stack name.
    :vartype value: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2021_01_15.models.FunctionAppMajorVersion]
    :ivar preferred_os: Function App stack preferred OS. Possible values include: "Windows",
     "Linux".
    :vartype preferred_os: str or ~azure.mgmt.web.v2021_01_15.models.StackPreferredOs
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'major_versions': {'readonly': True},
        'preferred_os': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'display_text': {'key': 'properties.displayText', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'major_versions': {'key': 'properties.majorVersions', 'type': '[FunctionAppMajorVersion]'},
        'preferred_os': {'key': 'properties.preferredOs', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(FunctionAppStack, self).__init__(kind=kind, **kwargs)
        self.location = None
        self.display_text = None
        self.value = None
        self.major_versions = None
        self.preferred_os = None


class FunctionAppStackCollection(msrest.serialization.Model):
    """Collection of Function app Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.FunctionAppStack]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FunctionAppStack]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["FunctionAppStack"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.FunctionAppStack]
        """
        super(FunctionAppStackCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class FunctionEnvelope(ProxyOnlyResource):
    """Function information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar function_app_id: Function App ID.
    :vartype function_app_id: str
    :ivar script_root_path_href: Script root path URI.
    :vartype script_root_path_href: str
    :ivar script_href: Script URI.
    :vartype script_href: str
    :ivar config_href: Config URI.
    :vartype config_href: str
    :ivar test_data_href: Test data URI.
    :vartype test_data_href: str
    :ivar secrets_file_href: Secrets file URI.
    :vartype secrets_file_href: str
    :ivar href: Function URI.
    :vartype href: str
    :ivar config: Config information.
    :vartype config: any
    :ivar files: File list.
    :vartype files: dict[str, str]
    :ivar test_data: Test data used when testing via the Azure Portal.
    :vartype test_data: str
    :ivar invoke_url_template: The invocation URL.
    :vartype invoke_url_template: str
    :ivar language: The function language.
    :vartype language: str
    :ivar is_disabled: Gets or sets a value indicating whether the function is disabled.
    :vartype is_disabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_app_id': {'key': 'properties.function_app_id', 'type': 'str'},
        'script_root_path_href': {'key': 'properties.script_root_path_href', 'type': 'str'},
        'script_href': {'key': 'properties.script_href', 'type': 'str'},
        'config_href': {'key': 'properties.config_href', 'type': 'str'},
        'test_data_href': {'key': 'properties.test_data_href', 'type': 'str'},
        'secrets_file_href': {'key': 'properties.secrets_file_href', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'config': {'key': 'properties.config', 'type': 'object'},
        'files': {'key': 'properties.files', 'type': '{str}'},
        'test_data': {'key': 'properties.test_data', 'type': 'str'},
        'invoke_url_template': {'key': 'properties.invoke_url_template', 'type': 'str'},
        'language': {'key': 'properties.language', 'type': 'str'},
        'is_disabled': {'key': 'properties.isDisabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        function_app_id: Optional[str] = None,
        script_root_path_href: Optional[str] = None,
        script_href: Optional[str] = None,
        config_href: Optional[str] = None,
        test_data_href: Optional[str] = None,
        secrets_file_href: Optional[str] = None,
        href: Optional[str] = None,
        config: Optional[Any] = None,
        files: Optional[Dict[str, str]] = None,
        test_data: Optional[str] = None,
        invoke_url_template: Optional[str] = None,
        language: Optional[str] = None,
        is_disabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword function_app_id: Function App ID.
        :paramtype function_app_id: str
        :keyword script_root_path_href: Script root path URI.
        :paramtype script_root_path_href: str
        :keyword script_href: Script URI.
        :paramtype script_href: str
        :keyword config_href: Config URI.
        :paramtype config_href: str
        :keyword test_data_href: Test data URI.
        :paramtype test_data_href: str
        :keyword secrets_file_href: Secrets file URI.
        :paramtype secrets_file_href: str
        :keyword href: Function URI.
        :paramtype href: str
        :keyword config: Config information.
        :paramtype config: any
        :keyword files: File list.
        :paramtype files: dict[str, str]
        :keyword test_data: Test data used when testing via the Azure Portal.
        :paramtype test_data: str
        :keyword invoke_url_template: The invocation URL.
        :paramtype invoke_url_template: str
        :keyword language: The function language.
        :paramtype language: str
        :keyword is_disabled: Gets or sets a value indicating whether the function is disabled.
        :paramtype is_disabled: bool
        """
        super(FunctionEnvelope, self).__init__(kind=kind, **kwargs)
        self.function_app_id = function_app_id
        self.script_root_path_href = script_root_path_href
        self.script_href = script_href
        self.config_href = config_href
        self.test_data_href = test_data_href
        self.secrets_file_href = secrets_file_href
        self.href = href
        self.config = config
        self.files = files
        self.test_data = test_data
        self.invoke_url_template = invoke_url_template
        self.language = language
        self.is_disabled = is_disabled


class FunctionEnvelopeCollection(msrest.serialization.Model):
    """Collection of Kudu function information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FunctionEnvelope]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["FunctionEnvelope"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope]
        """
        super(FunctionEnvelopeCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class FunctionSecrets(msrest.serialization.Model):
    """Function secrets.

    :ivar key: Secret key.
    :vartype key: str
    :ivar trigger_url: Trigger URL.
    :vartype trigger_url: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'trigger_url': {'key': 'trigger_url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        trigger_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key: Secret key.
        :paramtype key: str
        :keyword trigger_url: Trigger URL.
        :paramtype trigger_url: str
        """
        super(FunctionSecrets, self).__init__(**kwargs)
        self.key = key
        self.trigger_url = trigger_url


class GeoRegion(ProxyOnlyResource):
    """Geographical region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Region description.
    :vartype description: str
    :ivar display_name: Display name for region.
    :vartype display_name: str
    :ivar org_domain: Display name for region.
    :vartype org_domain: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'display_name': {'readonly': True},
        'org_domain': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'org_domain': {'key': 'properties.orgDomain', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(GeoRegion, self).__init__(kind=kind, **kwargs)
        self.description = None
        self.display_name = None
        self.org_domain = None


class GeoRegionCollection(msrest.serialization.Model):
    """Collection of geographical regions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.GeoRegion]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GeoRegion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["GeoRegion"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.GeoRegion]
        """
        super(GeoRegionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class GitHub(msrest.serialization.Model):
    """The configuration settings of the GitHub provider.

    :ivar enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the GitHub provider.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'ClientRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["ClientRegistration"] = None,
        login: Optional["LoginScopes"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the GitHub
         provider.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
        """
        super(GitHub, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class GitHubActionCodeConfiguration(msrest.serialization.Model):
    """The GitHub action code configuration.

    :ivar runtime_stack: Runtime stack is used to determine the workflow file content for code base
     apps.
    :vartype runtime_stack: str
    :ivar runtime_version: Runtime version is used to determine what build version to set in the
     workflow file.
    :vartype runtime_version: str
    """

    _attribute_map = {
        'runtime_stack': {'key': 'runtimeStack', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        runtime_stack: Optional[str] = None,
        runtime_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword runtime_stack: Runtime stack is used to determine the workflow file content for code
         base apps.
        :paramtype runtime_stack: str
        :keyword runtime_version: Runtime version is used to determine what build version to set in the
         workflow file.
        :paramtype runtime_version: str
        """
        super(GitHubActionCodeConfiguration, self).__init__(**kwargs)
        self.runtime_stack = runtime_stack
        self.runtime_version = runtime_version


class GitHubActionConfiguration(msrest.serialization.Model):
    """The GitHub action configuration.

    :ivar code_configuration: GitHub Action code configuration.
    :vartype code_configuration: ~azure.mgmt.web.v2021_01_15.models.GitHubActionCodeConfiguration
    :ivar container_configuration: GitHub Action container configuration.
    :vartype container_configuration:
     ~azure.mgmt.web.v2021_01_15.models.GitHubActionContainerConfiguration
    :ivar is_linux: This will help determine the workflow configuration to select.
    :vartype is_linux: bool
    :ivar generate_workflow_file: Workflow option to determine whether the workflow file should be
     generated and written to the repository.
    :vartype generate_workflow_file: bool
    """

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'GitHubActionCodeConfiguration'},
        'container_configuration': {'key': 'containerConfiguration', 'type': 'GitHubActionContainerConfiguration'},
        'is_linux': {'key': 'isLinux', 'type': 'bool'},
        'generate_workflow_file': {'key': 'generateWorkflowFile', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["GitHubActionCodeConfiguration"] = None,
        container_configuration: Optional["GitHubActionContainerConfiguration"] = None,
        is_linux: Optional[bool] = None,
        generate_workflow_file: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword code_configuration: GitHub Action code configuration.
        :paramtype code_configuration: ~azure.mgmt.web.v2021_01_15.models.GitHubActionCodeConfiguration
        :keyword container_configuration: GitHub Action container configuration.
        :paramtype container_configuration:
         ~azure.mgmt.web.v2021_01_15.models.GitHubActionContainerConfiguration
        :keyword is_linux: This will help determine the workflow configuration to select.
        :paramtype is_linux: bool
        :keyword generate_workflow_file: Workflow option to determine whether the workflow file should
         be generated and written to the repository.
        :paramtype generate_workflow_file: bool
        """
        super(GitHubActionConfiguration, self).__init__(**kwargs)
        self.code_configuration = code_configuration
        self.container_configuration = container_configuration
        self.is_linux = is_linux
        self.generate_workflow_file = generate_workflow_file


class GitHubActionContainerConfiguration(msrest.serialization.Model):
    """The GitHub action container configuration.

    :ivar server_url: The server URL for the container registry where the build will be hosted.
    :vartype server_url: str
    :ivar image_name: The image name for the build.
    :vartype image_name: str
    :ivar username: The username used to upload the image to the container registry.
    :vartype username: str
    :ivar password: The password used to upload the image to the container registry.
    :vartype password: str
    """

    _attribute_map = {
        'server_url': {'key': 'serverUrl', 'type': 'str'},
        'image_name': {'key': 'imageName', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_url: Optional[str] = None,
        image_name: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword server_url: The server URL for the container registry where the build will be hosted.
        :paramtype server_url: str
        :keyword image_name: The image name for the build.
        :paramtype image_name: str
        :keyword username: The username used to upload the image to the container registry.
        :paramtype username: str
        :keyword password: The password used to upload the image to the container registry.
        :paramtype password: str
        """
        super(GitHubActionContainerConfiguration, self).__init__(**kwargs)
        self.server_url = server_url
        self.image_name = image_name
        self.username = username
        self.password = password


class GitHubActionWebAppStackSettings(msrest.serialization.Model):
    """GitHub Actions Web App stack settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_supported: :code:`<code>true</code>` if GitHub Actions is supported for the stack;
     otherwise, :code:`<code>false</code>`.
    :vartype is_supported: bool
    :ivar supported_version: The minor version that is supported for GitHub Actions.
    :vartype supported_version: str
    """

    _validation = {
        'is_supported': {'readonly': True},
        'supported_version': {'readonly': True},
    }

    _attribute_map = {
        'is_supported': {'key': 'isSupported', 'type': 'bool'},
        'supported_version': {'key': 'supportedVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GitHubActionWebAppStackSettings, self).__init__(**kwargs)
        self.is_supported = None
        self.supported_version = None


class GlobalCsmSkuDescription(msrest.serialization.Model):
    """A Global SKU Description.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service Tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Min, max, and default scale values of the SKU.
    :vartype capacity: ~azure.mgmt.web.v2021_01_15.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.web.v2021_01_15.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional["SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["Capability"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service Tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Min, max, and default scale values of the SKU.
        :paramtype capacity: ~azure.mgmt.web.v2021_01_15.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.web.v2021_01_15.models.Capability]
        """
        super(GlobalCsmSkuDescription, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.locations = locations
        self.capabilities = capabilities


class GlobalValidation(msrest.serialization.Model):
    """The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.

    :ivar require_authentication: :code:`<code>true</code>` if the authentication flow is required
     any request is made; otherwise, :code:`<code>false</code>`.
    :vartype require_authentication: bool
    :ivar unauthenticated_client_action: The action to take when an unauthenticated client attempts
     to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous",
     "Return401", "Return403".
    :vartype unauthenticated_client_action: str or
     ~azure.mgmt.web.v2021_01_15.models.UnauthenticatedClientActionV2
    :ivar redirect_to_provider: The default authentication provider to use when multiple providers
     are configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage".
    :vartype redirect_to_provider: str
    :ivar excluded_paths: The paths for which unauthenticated flow would not be redirected to the
     login page.
    :vartype excluded_paths: list[str]
    """

    _attribute_map = {
        'require_authentication': {'key': 'requireAuthentication', 'type': 'bool'},
        'unauthenticated_client_action': {'key': 'unauthenticatedClientAction', 'type': 'str'},
        'redirect_to_provider': {'key': 'redirectToProvider', 'type': 'str'},
        'excluded_paths': {'key': 'excludedPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        require_authentication: Optional[bool] = None,
        unauthenticated_client_action: Optional[Union[str, "UnauthenticatedClientActionV2"]] = None,
        redirect_to_provider: Optional[str] = None,
        excluded_paths: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword require_authentication: :code:`<code>true</code>` if the authentication flow is
         required any request is made; otherwise, :code:`<code>false</code>`.
        :paramtype require_authentication: bool
        :keyword unauthenticated_client_action: The action to take when an unauthenticated client
         attempts to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous",
         "Return401", "Return403".
        :paramtype unauthenticated_client_action: str or
         ~azure.mgmt.web.v2021_01_15.models.UnauthenticatedClientActionV2
        :keyword redirect_to_provider: The default authentication provider to use when multiple
         providers are configured.
         This setting is only needed if multiple providers are configured and the unauthenticated
         client
         action is set to "RedirectToLoginPage".
        :paramtype redirect_to_provider: str
        :keyword excluded_paths: The paths for which unauthenticated flow would not be redirected to
         the login page.
        :paramtype excluded_paths: list[str]
        """
        super(GlobalValidation, self).__init__(**kwargs)
        self.require_authentication = require_authentication
        self.unauthenticated_client_action = unauthenticated_client_action
        self.redirect_to_provider = redirect_to_provider
        self.excluded_paths = excluded_paths


class Google(msrest.serialization.Model):
    """The configuration settings of the Google provider.

    :ivar enabled: :code:`<code>false</code>` if the Google provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Google provider.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
    :ivar validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :vartype validation: ~azure.mgmt.web.v2021_01_15.models.AllowedAudiencesValidation
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'ClientRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
        'validation': {'key': 'validation', 'type': 'AllowedAudiencesValidation'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["ClientRegistration"] = None,
        login: Optional["LoginScopes"] = None,
        validation: Optional["AllowedAudiencesValidation"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Google provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Google
         provider.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
        :keyword validation: The configuration settings of the Azure Active Directory token validation
         flow.
        :paramtype validation: ~azure.mgmt.web.v2021_01_15.models.AllowedAudiencesValidation
        """
        super(Google, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation


class HandlerMapping(msrest.serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.

    :ivar extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :vartype extension: str
    :ivar script_processor: The absolute path to the FastCGI application.
    :vartype script_processor: str
    :ivar arguments: Command-line arguments to be passed to the script processor.
    :vartype arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        script_processor: Optional[str] = None,
        arguments: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword extension: Requests with this extension will be handled using the specified FastCGI
         application.
        :paramtype extension: str
        :keyword script_processor: The absolute path to the FastCGI application.
        :paramtype script_processor: str
        :keyword arguments: Command-line arguments to be passed to the script processor.
        :paramtype arguments: str
        """
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentDeploymentInfo(msrest.serialization.Model):
    """Information needed to create resources on an App Service Environment.

    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar location: Location of the App Service Environment.
    :vartype location: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the App Service Environment.
        :paramtype name: str
        :keyword location: Location of the App Service Environment.
        :paramtype location: str
        """
        super(HostingEnvironmentDeploymentInfo, self).__init__(**kwargs)
        self.name = name
        self.location = location


class HostingEnvironmentDiagnostics(msrest.serialization.Model):
    """Diagnostics for an App Service Environment.

    :ivar name: Name/identifier of the diagnostics.
    :vartype name: str
    :ivar diagnostics_output: Diagnostics output.
    :vartype diagnostics_output: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'diagnostics_output': {'key': 'diagnosticsOutput', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        diagnostics_output: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name/identifier of the diagnostics.
        :paramtype name: str
        :keyword diagnostics_output: Diagnostics output.
        :paramtype diagnostics_output: str
        """
        super(HostingEnvironmentDiagnostics, self).__init__(**kwargs)
        self.name = name
        self.diagnostics_output = diagnostics_output


class HostingEnvironmentProfile(msrest.serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the App Service Environment.
    :vartype id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID of the App Service Environment.
        :paramtype id: str
        """
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class HostKeys(msrest.serialization.Model):
    """Functions host level keys.

    :ivar master_key: Secret key.
    :vartype master_key: str
    :ivar function_keys: Host level function keys.
    :vartype function_keys: dict[str, str]
    :ivar system_keys: System keys.
    :vartype system_keys: dict[str, str]
    """

    _attribute_map = {
        'master_key': {'key': 'masterKey', 'type': 'str'},
        'function_keys': {'key': 'functionKeys', 'type': '{str}'},
        'system_keys': {'key': 'systemKeys', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        master_key: Optional[str] = None,
        function_keys: Optional[Dict[str, str]] = None,
        system_keys: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword master_key: Secret key.
        :paramtype master_key: str
        :keyword function_keys: Host level function keys.
        :paramtype function_keys: dict[str, str]
        :keyword system_keys: System keys.
        :paramtype system_keys: dict[str, str]
        """
        super(HostKeys, self).__init__(**kwargs)
        self.master_key = master_key
        self.function_keys = function_keys
        self.system_keys = system_keys


class HostName(msrest.serialization.Model):
    """Details of a hostname derived from a domain.

    :ivar name: Name of the hostname.
    :vartype name: str
    :ivar site_names: List of apps the hostname is assigned to. This list will have more than one
     app only if the hostname is pointing to a Traffic Manager.
    :vartype site_names: list[str]
    :ivar azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
     assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
     app name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Type of the Azure resource the hostname is assigned to. Possible
     values include: "Website", "TrafficManager".
    :vartype azure_resource_type: str or ~azure.mgmt.web.v2021_01_15.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Type of the DNS record. Possible values include:
     "CName", "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2021_01_15.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Type of the hostname. Possible values include: "Verified", "Managed".
    :vartype host_name_type: str or ~azure.mgmt.web.v2021_01_15.models.HostNameType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'site_names': {'key': 'siteNames', 'type': '[str]'},
        'azure_resource_name': {'key': 'azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'hostNameType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        site_names: Optional[List[str]] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "HostNameType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the hostname.
        :paramtype name: str
        :keyword site_names: List of apps the hostname is assigned to. This list will have more than
         one app only if the hostname is pointing to a Traffic Manager.
        :paramtype site_names: list[str]
        :keyword azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
         assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
         app name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Type of the Azure resource the hostname is assigned to. Possible
         values include: "Website", "TrafficManager".
        :paramtype azure_resource_type: str or ~azure.mgmt.web.v2021_01_15.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Type of the DNS record. Possible values include:
         "CName", "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.web.v2021_01_15.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Type of the hostname. Possible values include: "Verified", "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.web.v2021_01_15.models.HostNameType
        """
        super(HostName, self).__init__(**kwargs)
        self.name = name
        self.site_names = site_names
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type


class HostNameBinding(ProxyOnlyResource):
    """A hostname binding object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar site_name: App Service app name.
    :vartype site_name: str
    :ivar domain_id: Fully qualified ARM domain resource URI.
    :vartype domain_id: str
    :ivar azure_resource_name: Azure resource name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Azure resource type. Possible values include: "Website",
     "TrafficManager".
    :vartype azure_resource_type: str or ~azure.mgmt.web.v2021_01_15.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Custom DNS record type. Possible values include:
     "CName", "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2021_01_15.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Hostname type. Possible values include: "Verified", "Managed".
    :vartype host_name_type: str or ~azure.mgmt.web.v2021_01_15.models.HostNameType
    :ivar ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled", "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2021_01_15.models.SslState
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_ip': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'domain_id': {'key': 'properties.domainId', 'type': 'str'},
        'azure_resource_name': {'key': 'properties.azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'properties.azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'properties.customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'properties.hostNameType', 'type': 'str'},
        'ssl_state': {'key': 'properties.sslState', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'virtual_ip': {'key': 'properties.virtualIP', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        site_name: Optional[str] = None,
        domain_id: Optional[str] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "HostNameType"]] = None,
        ssl_state: Optional[Union[str, "SslState"]] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword site_name: App Service app name.
        :paramtype site_name: str
        :keyword domain_id: Fully qualified ARM domain resource URI.
        :paramtype domain_id: str
        :keyword azure_resource_name: Azure resource name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Azure resource type. Possible values include: "Website",
         "TrafficManager".
        :paramtype azure_resource_type: str or ~azure.mgmt.web.v2021_01_15.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Custom DNS record type. Possible values include:
         "CName", "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.web.v2021_01_15.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Hostname type. Possible values include: "Verified", "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.web.v2021_01_15.models.HostNameType
        :keyword ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
         "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2021_01_15.models.SslState
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        """
        super(HostNameBinding, self).__init__(kind=kind, **kwargs)
        self.site_name = site_name
        self.domain_id = domain_id
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type
        self.ssl_state = ssl_state
        self.thumbprint = thumbprint
        self.virtual_ip = None


class HostNameBindingCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.HostNameBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HostNameBinding]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["HostNameBinding"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.HostNameBinding]
        """
        super(HostNameBindingCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class HostNameSslState(msrest.serialization.Model):
    """SSL-enabled hostname.

    :ivar name: Hostname.
    :vartype name: str
    :ivar ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled", "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2021_01_15.models.SslState
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :vartype to_update: bool
    :ivar host_type: Indicates whether the hostname is a standard or repository hostname. Possible
     values include: "Standard", "Repository".
    :vartype host_type: str or ~azure.mgmt.web.v2021_01_15.models.HostType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ssl_state': {'key': 'sslState', 'type': 'str'},
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'to_update': {'key': 'toUpdate', 'type': 'bool'},
        'host_type': {'key': 'hostType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ssl_state: Optional[Union[str, "SslState"]] = None,
        virtual_ip: Optional[str] = None,
        thumbprint: Optional[str] = None,
        to_update: Optional[bool] = None,
        host_type: Optional[Union[str, "HostType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Hostname.
        :paramtype name: str
        :keyword ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
         "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2021_01_15.models.SslState
        :keyword virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        :paramtype virtual_ip: str
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        :keyword to_update: Set to :code:`<code>true</code>` to update existing hostname.
        :paramtype to_update: bool
        :keyword host_type: Indicates whether the hostname is a standard or repository hostname.
         Possible values include: "Standard", "Repository".
        :paramtype host_type: str or ~azure.mgmt.web.v2021_01_15.models.HostType
        """
        super(HostNameSslState, self).__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HttpLogsConfig(msrest.serialization.Model):
    """Http logs configuration.

    :ivar file_system: Http logs to file system configuration.
    :vartype file_system: ~azure.mgmt.web.v2021_01_15.models.FileSystemHttpLogsConfig
    :ivar azure_blob_storage: Http logs to azure blob storage configuration.
    :vartype azure_blob_storage: ~azure.mgmt.web.v2021_01_15.models.AzureBlobStorageHttpLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemHttpLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageHttpLogsConfig'},
    }

    def __init__(
        self,
        *,
        file_system: Optional["FileSystemHttpLogsConfig"] = None,
        azure_blob_storage: Optional["AzureBlobStorageHttpLogsConfig"] = None,
        **kwargs
    ):
        """
        :keyword file_system: Http logs to file system configuration.
        :paramtype file_system: ~azure.mgmt.web.v2021_01_15.models.FileSystemHttpLogsConfig
        :keyword azure_blob_storage: Http logs to azure blob storage configuration.
        :paramtype azure_blob_storage:
         ~azure.mgmt.web.v2021_01_15.models.AzureBlobStorageHttpLogsConfig
        """
        super(HttpLogsConfig, self).__init__(**kwargs)
        self.file_system = file_system
        self.azure_blob_storage = azure_blob_storage


class HttpSettings(msrest.serialization.Model):
    """The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.

    :ivar require_https: :code:`<code>false</code>` if the authentication/authorization responses
     not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
    :vartype require_https: bool
    :ivar routes: The configuration settings of the paths HTTP requests.
    :vartype routes: ~azure.mgmt.web.v2021_01_15.models.HttpSettingsRoutes
    :ivar forward_proxy: The configuration settings of a forward proxy used to make the requests.
    :vartype forward_proxy: ~azure.mgmt.web.v2021_01_15.models.ForwardProxy
    """

    _attribute_map = {
        'require_https': {'key': 'requireHttps', 'type': 'bool'},
        'routes': {'key': 'routes', 'type': 'HttpSettingsRoutes'},
        'forward_proxy': {'key': 'forwardProxy', 'type': 'ForwardProxy'},
    }

    def __init__(
        self,
        *,
        require_https: Optional[bool] = None,
        routes: Optional["HttpSettingsRoutes"] = None,
        forward_proxy: Optional["ForwardProxy"] = None,
        **kwargs
    ):
        """
        :keyword require_https: :code:`<code>false</code>` if the authentication/authorization
         responses not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
        :paramtype require_https: bool
        :keyword routes: The configuration settings of the paths HTTP requests.
        :paramtype routes: ~azure.mgmt.web.v2021_01_15.models.HttpSettingsRoutes
        :keyword forward_proxy: The configuration settings of a forward proxy used to make the
         requests.
        :paramtype forward_proxy: ~azure.mgmt.web.v2021_01_15.models.ForwardProxy
        """
        super(HttpSettings, self).__init__(**kwargs)
        self.require_https = require_https
        self.routes = routes
        self.forward_proxy = forward_proxy


class HttpSettingsRoutes(msrest.serialization.Model):
    """The configuration settings of the paths HTTP requests.

    :ivar api_prefix: The prefix that should precede all the authentication/authorization paths.
    :vartype api_prefix: str
    """

    _attribute_map = {
        'api_prefix': {'key': 'apiPrefix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        api_prefix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword api_prefix: The prefix that should precede all the authentication/authorization paths.
        :paramtype api_prefix: str
        """
        super(HttpSettingsRoutes, self).__init__(**kwargs)
        self.api_prefix = api_prefix


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_bus_namespace: The name of the Service Bus namespace.
    :vartype service_bus_namespace: str
    :ivar relay_name: The name of the Service Bus relay.
    :vartype relay_name: str
    :ivar relay_arm_uri: The ARM URI to the Service Bus relay.
    :vartype relay_arm_uri: str
    :ivar hostname: The hostname of the endpoint.
    :vartype hostname: str
    :ivar port: The port of the endpoint.
    :vartype port: int
    :ivar send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the Service Bus key. This is used to authenticate to Service
     Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :vartype send_key_value: str
    :ivar service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :vartype service_bus_suffix: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'relay_name': {'key': 'properties.relayName', 'type': 'str'},
        'relay_arm_uri': {'key': 'properties.relayArmUri', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
        'service_bus_suffix': {'key': 'properties.serviceBusSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_bus_namespace: Optional[str] = None,
        relay_name: Optional[str] = None,
        relay_arm_uri: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        send_key_name: Optional[str] = None,
        send_key_value: Optional[str] = None,
        service_bus_suffix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_bus_namespace: The name of the Service Bus namespace.
        :paramtype service_bus_namespace: str
        :keyword relay_name: The name of the Service Bus relay.
        :paramtype relay_name: str
        :keyword relay_arm_uri: The ARM URI to the Service Bus relay.
        :paramtype relay_arm_uri: str
        :keyword hostname: The hostname of the endpoint.
        :paramtype hostname: str
        :keyword port: The port of the endpoint.
        :paramtype port: int
        :keyword send_key_name: The name of the Service Bus key which has Send permissions. This is
         used to authenticate to Service Bus.
        :paramtype send_key_name: str
        :keyword send_key_value: The value of the Service Bus key. This is used to authenticate to
         Service Bus. In ARM this key will not be returned
         normally, use the POST /listKeys API instead.
        :paramtype send_key_value: str
        :keyword service_bus_suffix: The suffix for the service bus endpoint. By default this is
         .servicebus.windows.net.
        :paramtype service_bus_suffix: str
        """
        super(HybridConnection, self).__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class HybridConnectionCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.HybridConnection]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HybridConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["HybridConnection"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.HybridConnection]
        """
        super(HybridConnectionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'send_key_name': {'readonly': True},
        'send_key_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(HybridConnectionKey, self).__init__(kind=kind, **kwargs)
        self.send_key_name = None
        self.send_key_value = None


class HybridConnectionLimits(ProxyOnlyResource):
    """Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar current: The current number of Hybrid Connections.
    :vartype current: int
    :ivar maximum: The maximum number of Hybrid Connections allowed.
    :vartype maximum: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'current': {'readonly': True},
        'maximum': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'current': {'key': 'properties.current', 'type': 'int'},
        'maximum': {'key': 'properties.maximum', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(HybridConnectionLimits, self).__init__(kind=kind, **kwargs)
        self.current = None
        self.maximum = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar value: String representation of the identity.
    :vartype value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword value: String representation of the identity.
        :paramtype value: str
        """
        super(Identifier, self).__init__(kind=kind, **kwargs)
        self.value = value


class IdentifierCollection(msrest.serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Identifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Identifier"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.Identifier]
        """
        super(IdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IdentityProviders(msrest.serialization.Model):
    """The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.

    :ivar azure_active_directory: The configuration settings of the Azure Active directory
     provider.
    :vartype azure_active_directory: ~azure.mgmt.web.v2021_01_15.models.AzureActiveDirectory
    :ivar facebook: The configuration settings of the Facebook provider.
    :vartype facebook: ~azure.mgmt.web.v2021_01_15.models.Facebook
    :ivar git_hub: The configuration settings of the GitHub provider.
    :vartype git_hub: ~azure.mgmt.web.v2021_01_15.models.GitHub
    :ivar google: The configuration settings of the Google provider.
    :vartype google: ~azure.mgmt.web.v2021_01_15.models.Google
    :ivar legacy_microsoft_account: The configuration settings of the legacy Microsoft Account
     provider.
    :vartype legacy_microsoft_account: ~azure.mgmt.web.v2021_01_15.models.LegacyMicrosoftAccount
    :ivar twitter: The configuration settings of the Twitter provider.
    :vartype twitter: ~azure.mgmt.web.v2021_01_15.models.Twitter
    :ivar apple: The configuration settings of the Apple provider.
    :vartype apple: ~azure.mgmt.web.v2021_01_15.models.Apple
    :ivar azure_static_web_apps: The configuration settings of the Azure Static Web Apps provider.
    :vartype azure_static_web_apps: ~azure.mgmt.web.v2021_01_15.models.AzureStaticWebApps
    :ivar custom_open_id_connect_providers: The map of the name of the alias of each custom Open ID
     Connect provider to the
     configuration settings of the custom Open ID Connect provider.
    :vartype custom_open_id_connect_providers: dict[str,
     ~azure.mgmt.web.v2021_01_15.models.CustomOpenIdConnectProvider]
    """

    _attribute_map = {
        'azure_active_directory': {'key': 'azureActiveDirectory', 'type': 'AzureActiveDirectory'},
        'facebook': {'key': 'facebook', 'type': 'Facebook'},
        'git_hub': {'key': 'gitHub', 'type': 'GitHub'},
        'google': {'key': 'google', 'type': 'Google'},
        'legacy_microsoft_account': {'key': 'legacyMicrosoftAccount', 'type': 'LegacyMicrosoftAccount'},
        'twitter': {'key': 'twitter', 'type': 'Twitter'},
        'apple': {'key': 'apple', 'type': 'Apple'},
        'azure_static_web_apps': {'key': 'azureStaticWebApps', 'type': 'AzureStaticWebApps'},
        'custom_open_id_connect_providers': {'key': 'customOpenIdConnectProviders', 'type': '{CustomOpenIdConnectProvider}'},
    }

    def __init__(
        self,
        *,
        azure_active_directory: Optional["AzureActiveDirectory"] = None,
        facebook: Optional["Facebook"] = None,
        git_hub: Optional["GitHub"] = None,
        google: Optional["Google"] = None,
        legacy_microsoft_account: Optional["LegacyMicrosoftAccount"] = None,
        twitter: Optional["Twitter"] = None,
        apple: Optional["Apple"] = None,
        azure_static_web_apps: Optional["AzureStaticWebApps"] = None,
        custom_open_id_connect_providers: Optional[Dict[str, "CustomOpenIdConnectProvider"]] = None,
        **kwargs
    ):
        """
        :keyword azure_active_directory: The configuration settings of the Azure Active directory
         provider.
        :paramtype azure_active_directory: ~azure.mgmt.web.v2021_01_15.models.AzureActiveDirectory
        :keyword facebook: The configuration settings of the Facebook provider.
        :paramtype facebook: ~azure.mgmt.web.v2021_01_15.models.Facebook
        :keyword git_hub: The configuration settings of the GitHub provider.
        :paramtype git_hub: ~azure.mgmt.web.v2021_01_15.models.GitHub
        :keyword google: The configuration settings of the Google provider.
        :paramtype google: ~azure.mgmt.web.v2021_01_15.models.Google
        :keyword legacy_microsoft_account: The configuration settings of the legacy Microsoft Account
         provider.
        :paramtype legacy_microsoft_account: ~azure.mgmt.web.v2021_01_15.models.LegacyMicrosoftAccount
        :keyword twitter: The configuration settings of the Twitter provider.
        :paramtype twitter: ~azure.mgmt.web.v2021_01_15.models.Twitter
        :keyword apple: The configuration settings of the Apple provider.
        :paramtype apple: ~azure.mgmt.web.v2021_01_15.models.Apple
        :keyword azure_static_web_apps: The configuration settings of the Azure Static Web Apps
         provider.
        :paramtype azure_static_web_apps: ~azure.mgmt.web.v2021_01_15.models.AzureStaticWebApps
        :keyword custom_open_id_connect_providers: The map of the name of the alias of each custom Open
         ID Connect provider to the
         configuration settings of the custom Open ID Connect provider.
        :paramtype custom_open_id_connect_providers: dict[str,
         ~azure.mgmt.web.v2021_01_15.models.CustomOpenIdConnectProvider]
        """
        super(IdentityProviders, self).__init__(**kwargs)
        self.azure_active_directory = azure_active_directory
        self.facebook = facebook
        self.git_hub = git_hub
        self.google = google
        self.legacy_microsoft_account = legacy_microsoft_account
        self.twitter = twitter
        self.apple = apple
        self.azure_static_web_apps = azure_static_web_apps
        self.custom_open_id_connect_providers = custom_open_id_connect_providers


class InboundEnvironmentEndpoint(msrest.serialization.Model):
    """The IP Addresses and Ports that require inbound network access to and within the subnet of the App Service Environment.

    :ivar description: Short text describing the purpose of the network traffic.
    :vartype description: str
    :ivar endpoints: The IP addresses that network traffic will originate from in cidr notation.
    :vartype endpoints: list[str]
    :ivar ports: The ports that network traffic will arrive to the App Service Environment at.
    :vartype ports: list[str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[str]'},
        'ports': {'key': 'ports', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        endpoints: Optional[List[str]] = None,
        ports: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword description: Short text describing the purpose of the network traffic.
        :paramtype description: str
        :keyword endpoints: The IP addresses that network traffic will originate from in cidr notation.
        :paramtype endpoints: list[str]
        :keyword ports: The ports that network traffic will arrive to the App Service Environment at.
        :paramtype ports: list[str]
        """
        super(InboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.description = description
        self.endpoints = endpoints
        self.ports = ports


class InboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Collection of Inbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.InboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["InboundEnvironmentEndpoint"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.InboundEnvironmentEndpoint]
        """
        super(InboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IpSecurityRestriction(msrest.serialization.Model):
    """IP security restriction on an app.

    :ivar ip_address: IP address the security restriction is valid for.
     It can be in form of pure ipv4 address (required SubnetMask property) or
     CIDR notation such as ipv4/mask (leading bit match). For CIDR,
     SubnetMask property must not be specified.
    :vartype ip_address: str
    :ivar subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :vartype subnet_mask: str
    :ivar vnet_subnet_resource_id: Virtual network resource id.
    :vartype vnet_subnet_resource_id: str
    :ivar vnet_traffic_tag: (internal) Vnet traffic tag.
    :vartype vnet_traffic_tag: int
    :ivar subnet_traffic_tag: (internal) Subnet traffic tag.
    :vartype subnet_traffic_tag: int
    :ivar action: Allow or Deny access for this IP range.
    :vartype action: str
    :ivar tag: Defines what this IP filter will be used for. This is to support IP filtering on
     proxies. Possible values include: "Default", "XffProxy", "ServiceTag".
    :vartype tag: str or ~azure.mgmt.web.v2021_01_15.models.IpFilterTag
    :ivar priority: Priority of IP restriction rule.
    :vartype priority: int
    :ivar name: IP restriction rule name.
    :vartype name: str
    :ivar description: IP restriction rule description.
    :vartype description: str
    :ivar headers: IP restriction rule headers.
     X-Forwarded-Host
     (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
     The matching logic is ..
    
    
     * If the property is null or empty (default), all hosts(or lack of) are allowed.
     * A value is compared using ordinal-ignore-case (excluding port number).
     * Subdomain wildcards are permitted but don't match the root domain. For example,
     *.contoso.com matches the subdomain foo.contoso.com
       but not the root domain contoso.com or multi-level foo.bar.contoso.com
     * Unicode host names are allowed but are converted to Punycode for matching.
    
     X-Forwarded-For
     (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
     The matching logic is ..
    
    
     * If the property is null or empty (default), any forwarded-for chains (or lack of) are
     allowed.
     * If any address (excluding port number) in the chain (comma separated) matches the CIDR
     defined by the property.
    
     X-Azure-FDID and X-FD-HealthProbe.
     The matching logic is exact match.
    :vartype headers: dict[str, list[str]]
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
        'vnet_subnet_resource_id': {'key': 'vnetSubnetResourceId', 'type': 'str'},
        'vnet_traffic_tag': {'key': 'vnetTrafficTag', 'type': 'int'},
        'subnet_traffic_tag': {'key': 'subnetTrafficTag', 'type': 'int'},
        'action': {'key': 'action', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{[str]}'},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        subnet_mask: Optional[str] = None,
        vnet_subnet_resource_id: Optional[str] = None,
        vnet_traffic_tag: Optional[int] = None,
        subnet_traffic_tag: Optional[int] = None,
        action: Optional[str] = None,
        tag: Optional[Union[str, "IpFilterTag"]] = None,
        priority: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        headers: Optional[Dict[str, List[str]]] = None,
        **kwargs
    ):
        """
        :keyword ip_address: IP address the security restriction is valid for.
         It can be in form of pure ipv4 address (required SubnetMask property) or
         CIDR notation such as ipv4/mask (leading bit match). For CIDR,
         SubnetMask property must not be specified.
        :paramtype ip_address: str
        :keyword subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :paramtype subnet_mask: str
        :keyword vnet_subnet_resource_id: Virtual network resource id.
        :paramtype vnet_subnet_resource_id: str
        :keyword vnet_traffic_tag: (internal) Vnet traffic tag.
        :paramtype vnet_traffic_tag: int
        :keyword subnet_traffic_tag: (internal) Subnet traffic tag.
        :paramtype subnet_traffic_tag: int
        :keyword action: Allow or Deny access for this IP range.
        :paramtype action: str
        :keyword tag: Defines what this IP filter will be used for. This is to support IP filtering on
         proxies. Possible values include: "Default", "XffProxy", "ServiceTag".
        :paramtype tag: str or ~azure.mgmt.web.v2021_01_15.models.IpFilterTag
        :keyword priority: Priority of IP restriction rule.
        :paramtype priority: int
        :keyword name: IP restriction rule name.
        :paramtype name: str
        :keyword description: IP restriction rule description.
        :paramtype description: str
        :keyword headers: IP restriction rule headers.
         X-Forwarded-Host
         (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
         The matching logic is ..
        
        
         * If the property is null or empty (default), all hosts(or lack of) are allowed.
         * A value is compared using ordinal-ignore-case (excluding port number).
         * Subdomain wildcards are permitted but don't match the root domain. For example,
         *.contoso.com matches the subdomain foo.contoso.com
           but not the root domain contoso.com or multi-level foo.bar.contoso.com
         * Unicode host names are allowed but are converted to Punycode for matching.
        
         X-Forwarded-For
         (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
         The matching logic is ..
        
        
         * If the property is null or empty (default), any forwarded-for chains (or lack of) are
         allowed.
         * If any address (excluding port number) in the chain (comma separated) matches the CIDR
         defined by the property.
        
         X-Azure-FDID and X-FD-HealthProbe.
         The matching logic is exact match.
        :paramtype headers: dict[str, list[str]]
        """
        super(IpSecurityRestriction, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask
        self.vnet_subnet_resource_id = vnet_subnet_resource_id
        self.vnet_traffic_tag = vnet_traffic_tag
        self.subnet_traffic_tag = subnet_traffic_tag
        self.action = action
        self.tag = tag
        self.priority = priority
        self.name = name
        self.description = description
        self.headers = headers


class JwtClaimChecks(msrest.serialization.Model):
    """The configuration settings of the checks that should be made while validating the JWT Claims.

    :ivar allowed_groups: The list of the allowed groups.
    :vartype allowed_groups: list[str]
    :ivar allowed_client_applications: The list of the allowed client applications.
    :vartype allowed_client_applications: list[str]
    """

    _attribute_map = {
        'allowed_groups': {'key': 'allowedGroups', 'type': '[str]'},
        'allowed_client_applications': {'key': 'allowedClientApplications', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        allowed_groups: Optional[List[str]] = None,
        allowed_client_applications: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword allowed_groups: The list of the allowed groups.
        :paramtype allowed_groups: list[str]
        :keyword allowed_client_applications: The list of the allowed client applications.
        :paramtype allowed_client_applications: list[str]
        """
        super(JwtClaimChecks, self).__init__(**kwargs)
        self.allowed_groups = allowed_groups
        self.allowed_client_applications = allowed_client_applications


class KeyInfo(msrest.serialization.Model):
    """Function key info.

    :ivar name: Key name.
    :vartype name: str
    :ivar value: Key value.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Key name.
        :paramtype name: str
        :keyword value: Key value.
        :paramtype value: str
        """
        super(KeyInfo, self).__init__(**kwargs)
        self.name = name
        self.value = value


class KeyValuePairStringObject(msrest.serialization.Model):
    """KeyValuePairStringObject.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key:
    :vartype key: str
    :ivar value: Any object.
    :vartype value: any
    """

    _validation = {
        'key': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(KeyValuePairStringObject, self).__init__(**kwargs)
        self.key = None
        self.value = None


class KubeEnvironment(Resource):
    """A Kubernetes cluster specialized for web workloads by Azure App Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: Extended Location.
    :vartype extended_location: ~azure.mgmt.web.v2021_01_15.models.ExtendedLocation
    :ivar provisioning_state: Provisioning state of the Kubernetes Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "Waiting", "InitializationInProgress",
     "InfrastructureSetupInProgress", "InfrastructureSetupComplete", "ScheduledForDelete",
     "UpgradeRequested", "UpgradeFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2021_01_15.models.KubeEnvironmentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar internal_load_balancer_enabled: Only visible within Vnet/Subnet.
    :vartype internal_load_balancer_enabled: bool
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :ivar static_ip: Static IP of the KubeEnvironment.
    :vartype static_ip: str
    :ivar arc_configuration: Cluster configuration which determines the ARC cluster
     components types. Eg: Choosing between BuildService kind,
     FrontEnd Service ArtifactsStorageType etc.
    :vartype arc_configuration: ~azure.mgmt.web.v2021_01_15.models.ArcConfiguration
    :ivar app_logs_configuration: Cluster configuration which enables the log daemon to export
     app logs to a destination. Currently only "log-analytics" is
     supported.
    :vartype app_logs_configuration: ~azure.mgmt.web.v2021_01_15.models.AppLogsConfiguration
    :ivar aks_resource_id:
    :vartype aks_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_errors': {'readonly': True},
        'default_domain': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_errors': {'key': 'properties.deploymentErrors', 'type': 'str'},
        'internal_load_balancer_enabled': {'key': 'properties.internalLoadBalancerEnabled', 'type': 'bool'},
        'default_domain': {'key': 'properties.defaultDomain', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIp', 'type': 'str'},
        'arc_configuration': {'key': 'properties.arcConfiguration', 'type': 'ArcConfiguration'},
        'app_logs_configuration': {'key': 'properties.appLogsConfiguration', 'type': 'AppLogsConfiguration'},
        'aks_resource_id': {'key': 'properties.aksResourceID', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        internal_load_balancer_enabled: Optional[bool] = None,
        static_ip: Optional[str] = None,
        arc_configuration: Optional["ArcConfiguration"] = None,
        app_logs_configuration: Optional["AppLogsConfiguration"] = None,
        aks_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: Extended Location.
        :paramtype extended_location: ~azure.mgmt.web.v2021_01_15.models.ExtendedLocation
        :keyword internal_load_balancer_enabled: Only visible within Vnet/Subnet.
        :paramtype internal_load_balancer_enabled: bool
        :keyword static_ip: Static IP of the KubeEnvironment.
        :paramtype static_ip: str
        :keyword arc_configuration: Cluster configuration which determines the ARC cluster
         components types. Eg: Choosing between BuildService kind,
         FrontEnd Service ArtifactsStorageType etc.
        :paramtype arc_configuration: ~azure.mgmt.web.v2021_01_15.models.ArcConfiguration
        :keyword app_logs_configuration: Cluster configuration which enables the log daemon to export
         app logs to a destination. Currently only "log-analytics" is
         supported.
        :paramtype app_logs_configuration: ~azure.mgmt.web.v2021_01_15.models.AppLogsConfiguration
        :keyword aks_resource_id:
        :paramtype aks_resource_id: str
        """
        super(KubeEnvironment, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.provisioning_state = None
        self.deployment_errors = None
        self.internal_load_balancer_enabled = internal_load_balancer_enabled
        self.default_domain = None
        self.static_ip = static_ip
        self.arc_configuration = arc_configuration
        self.app_logs_configuration = app_logs_configuration
        self.aks_resource_id = aks_resource_id


class KubeEnvironmentCollection(msrest.serialization.Model):
    """Collection of Kubernetes Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.KubeEnvironment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[KubeEnvironment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["KubeEnvironment"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.KubeEnvironment]
        """
        super(KubeEnvironmentCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class KubeEnvironmentPatchResource(ProxyOnlyResource):
    """ARM resource for a KubeEnvironment when patching.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the Kubernetes Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "Waiting", "InitializationInProgress",
     "InfrastructureSetupInProgress", "InfrastructureSetupComplete", "ScheduledForDelete",
     "UpgradeRequested", "UpgradeFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2021_01_15.models.KubeEnvironmentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar internal_load_balancer_enabled: Only visible within Vnet/Subnet.
    :vartype internal_load_balancer_enabled: bool
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :ivar static_ip: Static IP of the KubeEnvironment.
    :vartype static_ip: str
    :ivar arc_configuration: Cluster configuration which determines the ARC cluster
     components types. Eg: Choosing between BuildService kind,
     FrontEnd Service ArtifactsStorageType etc.
    :vartype arc_configuration: ~azure.mgmt.web.v2021_01_15.models.ArcConfiguration
    :ivar app_logs_configuration: Cluster configuration which enables the log daemon to export
     app logs to a destination. Currently only "log-analytics" is
     supported.
    :vartype app_logs_configuration: ~azure.mgmt.web.v2021_01_15.models.AppLogsConfiguration
    :ivar aks_resource_id:
    :vartype aks_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_errors': {'readonly': True},
        'default_domain': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_errors': {'key': 'properties.deploymentErrors', 'type': 'str'},
        'internal_load_balancer_enabled': {'key': 'properties.internalLoadBalancerEnabled', 'type': 'bool'},
        'default_domain': {'key': 'properties.defaultDomain', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIp', 'type': 'str'},
        'arc_configuration': {'key': 'properties.arcConfiguration', 'type': 'ArcConfiguration'},
        'app_logs_configuration': {'key': 'properties.appLogsConfiguration', 'type': 'AppLogsConfiguration'},
        'aks_resource_id': {'key': 'properties.aksResourceID', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        internal_load_balancer_enabled: Optional[bool] = None,
        static_ip: Optional[str] = None,
        arc_configuration: Optional["ArcConfiguration"] = None,
        app_logs_configuration: Optional["AppLogsConfiguration"] = None,
        aks_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword internal_load_balancer_enabled: Only visible within Vnet/Subnet.
        :paramtype internal_load_balancer_enabled: bool
        :keyword static_ip: Static IP of the KubeEnvironment.
        :paramtype static_ip: str
        :keyword arc_configuration: Cluster configuration which determines the ARC cluster
         components types. Eg: Choosing between BuildService kind,
         FrontEnd Service ArtifactsStorageType etc.
        :paramtype arc_configuration: ~azure.mgmt.web.v2021_01_15.models.ArcConfiguration
        :keyword app_logs_configuration: Cluster configuration which enables the log daemon to export
         app logs to a destination. Currently only "log-analytics" is
         supported.
        :paramtype app_logs_configuration: ~azure.mgmt.web.v2021_01_15.models.AppLogsConfiguration
        :keyword aks_resource_id:
        :paramtype aks_resource_id: str
        """
        super(KubeEnvironmentPatchResource, self).__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.deployment_errors = None
        self.internal_load_balancer_enabled = internal_load_balancer_enabled
        self.default_domain = None
        self.static_ip = static_ip
        self.arc_configuration = arc_configuration
        self.app_logs_configuration = app_logs_configuration
        self.aks_resource_id = aks_resource_id


class KubeEnvironmentProfile(msrest.serialization.Model):
    """Specification for a Kubernetes Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the Kubernetes Environment.
    :vartype id: str
    :ivar name: Name of the Kubernetes Environment.
    :vartype name: str
    :ivar type: Resource type of the Kubernetes Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID of the Kubernetes Environment.
        :paramtype id: str
        """
        super(KubeEnvironmentProfile, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class LegacyMicrosoftAccount(msrest.serialization.Model):
    """The configuration settings of the legacy Microsoft Account provider.

    :ivar enabled: :code:`<code>false</code>` if the legacy Microsoft Account provider should not
     be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the legacy Microsoft
     Account provider.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
    :ivar validation: The configuration settings of the legacy Microsoft Account provider token
     validation flow.
    :vartype validation: ~azure.mgmt.web.v2021_01_15.models.AllowedAudiencesValidation
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'ClientRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
        'validation': {'key': 'validation', 'type': 'AllowedAudiencesValidation'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["ClientRegistration"] = None,
        login: Optional["LoginScopes"] = None,
        validation: Optional["AllowedAudiencesValidation"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the legacy Microsoft Account provider should
         not be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the legacy
         Microsoft Account provider.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.web.v2021_01_15.models.LoginScopes
        :keyword validation: The configuration settings of the legacy Microsoft Account provider token
         validation flow.
        :paramtype validation: ~azure.mgmt.web.v2021_01_15.models.AllowedAudiencesValidation
        """
        super(LegacyMicrosoftAccount, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation


class LinuxJavaContainerSettings(msrest.serialization.Model):
    """Linux Java Container settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar java11_runtime: Java 11 version (runtime only).
    :vartype java11_runtime: str
    :ivar java8_runtime: Java 8 version (runtime only).
    :vartype java8_runtime: str
    :ivar is_preview: :code:`<code>true</code>` if the stack is in preview; otherwise,
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if the stack should be hidden; otherwise,
     :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar end_of_life_date: End-of-life date for the minor version.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar is_auto_update: :code:`<code>true</code>` if the stack version is auto-updated;
     otherwise, :code:`<code>false</code>`.
    :vartype is_auto_update: bool
    :ivar is_early_access: :code:`<code>true</code>` if the minor version is early-access;
     otherwise, :code:`<code>false</code>`.
    :vartype is_early_access: bool
    """

    _validation = {
        'java11_runtime': {'readonly': True},
        'java8_runtime': {'readonly': True},
        'is_preview': {'readonly': True},
        'is_deprecated': {'readonly': True},
        'is_hidden': {'readonly': True},
        'end_of_life_date': {'readonly': True},
        'is_auto_update': {'readonly': True},
        'is_early_access': {'readonly': True},
    }

    _attribute_map = {
        'java11_runtime': {'key': 'java11Runtime', 'type': 'str'},
        'java8_runtime': {'key': 'java8Runtime', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'is_auto_update': {'key': 'isAutoUpdate', 'type': 'bool'},
        'is_early_access': {'key': 'isEarlyAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(LinuxJavaContainerSettings, self).__init__(**kwargs)
        self.java11_runtime = None
        self.java8_runtime = None
        self.is_preview = None
        self.is_deprecated = None
        self.is_hidden = None
        self.end_of_life_date = None
        self.is_auto_update = None
        self.is_early_access = None


class LocalizableString(msrest.serialization.Model):
    """Localizable string object containing the name and a localized value.

    :ivar value: Non-localized name.
    :vartype value: str
    :ivar localized_value: Localized name.
    :vartype localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Non-localized name.
        :paramtype value: str
        :keyword localized_value: Localized name.
        :paramtype localized_value: str
        """
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LogAnalyticsConfiguration(msrest.serialization.Model):
    """LogAnalyticsConfiguration.

    :ivar customer_id:
    :vartype customer_id: str
    :ivar shared_key:
    :vartype shared_key: str
    """

    _attribute_map = {
        'customer_id': {'key': 'customerId', 'type': 'str'},
        'shared_key': {'key': 'sharedKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        customer_id: Optional[str] = None,
        shared_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword customer_id:
        :paramtype customer_id: str
        :keyword shared_key:
        :paramtype shared_key: str
        """
        super(LogAnalyticsConfiguration, self).__init__(**kwargs)
        self.customer_id = customer_id
        self.shared_key = shared_key


class Login(msrest.serialization.Model):
    """The configuration settings of the login flow of users using App Service Authentication/Authorization.

    :ivar routes: The routes that specify the endpoints used for login and logout requests.
    :vartype routes: ~azure.mgmt.web.v2021_01_15.models.LoginRoutes
    :ivar token_store: The configuration settings of the token store.
    :vartype token_store: ~azure.mgmt.web.v2021_01_15.models.TokenStore
    :ivar preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
     request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
    :vartype preserve_url_fragments_for_logins: bool
    :ivar allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :vartype allowed_external_redirect_urls: list[str]
    :ivar cookie_expiration: The configuration settings of the session cookie's expiration.
    :vartype cookie_expiration: ~azure.mgmt.web.v2021_01_15.models.CookieExpiration
    :ivar nonce: The configuration settings of the nonce used in the login flow.
    :vartype nonce: ~azure.mgmt.web.v2021_01_15.models.Nonce
    """

    _attribute_map = {
        'routes': {'key': 'routes', 'type': 'LoginRoutes'},
        'token_store': {'key': 'tokenStore', 'type': 'TokenStore'},
        'preserve_url_fragments_for_logins': {'key': 'preserveUrlFragmentsForLogins', 'type': 'bool'},
        'allowed_external_redirect_urls': {'key': 'allowedExternalRedirectUrls', 'type': '[str]'},
        'cookie_expiration': {'key': 'cookieExpiration', 'type': 'CookieExpiration'},
        'nonce': {'key': 'nonce', 'type': 'Nonce'},
    }

    def __init__(
        self,
        *,
        routes: Optional["LoginRoutes"] = None,
        token_store: Optional["TokenStore"] = None,
        preserve_url_fragments_for_logins: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        cookie_expiration: Optional["CookieExpiration"] = None,
        nonce: Optional["Nonce"] = None,
        **kwargs
    ):
        """
        :keyword routes: The routes that specify the endpoints used for login and logout requests.
        :paramtype routes: ~azure.mgmt.web.v2021_01_15.models.LoginRoutes
        :keyword token_store: The configuration settings of the token store.
        :paramtype token_store: ~azure.mgmt.web.v2021_01_15.models.TokenStore
        :keyword preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
         request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
        :paramtype preserve_url_fragments_for_logins: bool
        :keyword allowed_external_redirect_urls: External URLs that can be redirected to as part of
         logging in or logging out of the app. Note that the query string part of the URL is ignored.
         This is an advanced setting typically only needed by Windows Store application backends.
         Note that URLs within the current domain are always implicitly allowed.
        :paramtype allowed_external_redirect_urls: list[str]
        :keyword cookie_expiration: The configuration settings of the session cookie's expiration.
        :paramtype cookie_expiration: ~azure.mgmt.web.v2021_01_15.models.CookieExpiration
        :keyword nonce: The configuration settings of the nonce used in the login flow.
        :paramtype nonce: ~azure.mgmt.web.v2021_01_15.models.Nonce
        """
        super(Login, self).__init__(**kwargs)
        self.routes = routes
        self.token_store = token_store
        self.preserve_url_fragments_for_logins = preserve_url_fragments_for_logins
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.cookie_expiration = cookie_expiration
        self.nonce = nonce


class LoginRoutes(msrest.serialization.Model):
    """The routes that specify the endpoints used for login and logout requests.

    :ivar logout_endpoint: The endpoint at which a logout request should be made.
    :vartype logout_endpoint: str
    """

    _attribute_map = {
        'logout_endpoint': {'key': 'logoutEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logout_endpoint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword logout_endpoint: The endpoint at which a logout request should be made.
        :paramtype logout_endpoint: str
        """
        super(LoginRoutes, self).__init__(**kwargs)
        self.logout_endpoint = logout_endpoint


class LoginScopes(msrest.serialization.Model):
    """The configuration settings of the login flow, including the scopes that should be requested.

    :ivar scopes: A list of the scopes that should be requested while authenticating.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        scopes: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword scopes: A list of the scopes that should be requested while authenticating.
        :paramtype scopes: list[str]
        """
        super(LoginScopes, self).__init__(**kwargs)
        self.scopes = scopes


class LogSpecification(msrest.serialization.Model):
    """Log Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar blob_duration:
    :vartype blob_duration: str
    :ivar log_filter_pattern:
    :vartype log_filter_pattern: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'log_filter_pattern': {'key': 'logFilterPattern', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        log_filter_pattern: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        :keyword log_filter_pattern:
        :paramtype log_filter_pattern: str
        """
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration
        self.log_filter_pattern = log_filter_pattern


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of managed service identity. Possible values include: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    :ivar user_assigned_identities: The list of user assigned identities associated with the
     resource. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.web.v2021_01_15.models.UserAssignedIdentity]
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: Type of managed service identity. Possible values include: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", "None".
        :paramtype type: str or ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The list of user assigned identities associated with the
         resource. The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.web.v2021_01_15.models.UserAssignedIdentity]
        """
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None
        self.user_assigned_identities = user_assigned_identities


class MetricAvailability(msrest.serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(msrest.serialization.Model):
    """Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar display_description:
    :vartype display_description: str
    :ivar unit:
    :vartype unit: str
    :ivar aggregation_type:
    :vartype aggregation_type: str
    :ivar supports_instance_level_aggregation:
    :vartype supports_instance_level_aggregation: bool
    :ivar enable_regional_mdm_account:
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account:
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace:
    :vartype source_mdm_namespace: str
    :ivar metric_filter_pattern:
    :vartype metric_filter_pattern: str
    :ivar fill_gap_with_zero:
    :vartype fill_gap_with_zero: bool
    :ivar is_internal:
    :vartype is_internal: bool
    :ivar dimensions:
    :vartype dimensions: list[~azure.mgmt.web.v2021_01_15.models.Dimension]
    :ivar category:
    :vartype category: str
    :ivar availabilities:
    :vartype availabilities: list[~azure.mgmt.web.v2021_01_15.models.MetricAvailability]
    :ivar supported_time_grain_types:
    :vartype supported_time_grain_types: list[str]
    :ivar supported_aggregation_types:
    :vartype supported_aggregation_types: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'category': {'key': 'category', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[MetricAvailability]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[List["Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[List["MetricAvailability"]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword display_description:
        :paramtype display_description: str
        :keyword unit:
        :paramtype unit: str
        :keyword aggregation_type:
        :paramtype aggregation_type: str
        :keyword supports_instance_level_aggregation:
        :paramtype supports_instance_level_aggregation: bool
        :keyword enable_regional_mdm_account:
        :paramtype enable_regional_mdm_account: bool
        :keyword source_mdm_account:
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace:
        :paramtype source_mdm_namespace: str
        :keyword metric_filter_pattern:
        :paramtype metric_filter_pattern: str
        :keyword fill_gap_with_zero:
        :paramtype fill_gap_with_zero: bool
        :keyword is_internal:
        :paramtype is_internal: bool
        :keyword dimensions:
        :paramtype dimensions: list[~azure.mgmt.web.v2021_01_15.models.Dimension]
        :keyword category:
        :paramtype category: str
        :keyword availabilities:
        :paramtype availabilities: list[~azure.mgmt.web.v2021_01_15.models.MetricAvailability]
        :keyword supported_time_grain_types:
        :paramtype supported_time_grain_types: list[str]
        :keyword supported_aggregation_types:
        :paramtype supported_aggregation_types: list[str]
        """
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities
        self.supported_time_grain_types = supported_time_grain_types
        self.supported_aggregation_types = supported_aggregation_types


class MigrateMySqlRequest(ProxyOnlyResource):
    """MySQL migration request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar connection_string: Connection string to the remote MySQL database.
    :vartype connection_string: str
    :ivar migration_type: The type of migration operation to be done. Possible values include:
     "LocalToRemote", "RemoteToLocal".
    :vartype migration_type: str or ~azure.mgmt.web.v2021_01_15.models.MySqlMigrationType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'migration_type': {'key': 'properties.migrationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string: Optional[str] = None,
        migration_type: Optional[Union[str, "MySqlMigrationType"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword connection_string: Connection string to the remote MySQL database.
        :paramtype connection_string: str
        :keyword migration_type: The type of migration operation to be done. Possible values include:
         "LocalToRemote", "RemoteToLocal".
        :paramtype migration_type: str or ~azure.mgmt.web.v2021_01_15.models.MySqlMigrationType
        """
        super(MigrateMySqlRequest, self).__init__(kind=kind, **kwargs)
        self.connection_string = connection_string
        self.migration_type = migration_type


class MigrateMySqlStatus(ProxyOnlyResource):
    """MySQL migration status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar migration_operation_status: Status of the migration task. Possible values include:
     "InProgress", "Failed", "Succeeded", "TimedOut", "Created".
    :vartype migration_operation_status: str or ~azure.mgmt.web.v2021_01_15.models.OperationStatus
    :ivar operation_id: Operation ID for the migration task.
    :vartype operation_id: str
    :ivar local_my_sql_enabled: True if the web app has in app MySql enabled.
    :vartype local_my_sql_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'migration_operation_status': {'readonly': True},
        'operation_id': {'readonly': True},
        'local_my_sql_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'migration_operation_status': {'key': 'properties.migrationOperationStatus', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(MigrateMySqlStatus, self).__init__(kind=kind, **kwargs)
        self.migration_operation_status = None
        self.operation_id = None
        self.local_my_sql_enabled = None


class MSDeploy(ProxyOnlyResource):
    """MSDeploy ARM PUT information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar package_uri: Package URI.
    :vartype package_uri: str
    :ivar connection_string: SQL Connection String.
    :vartype connection_string: str
    :ivar db_type: Database Type.
    :vartype db_type: str
    :ivar set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
     SetParameters is used.
    :vartype set_parameters_xml_file_uri: str
    :ivar set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
    :vartype set_parameters: dict[str, str]
    :ivar skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
     If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
     will not be deleted, and any App_Data directory in the source will be ignored.
     Setting is :code:`<code>false</code>` by default.
    :vartype skip_app_data: bool
    :ivar app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
     Setting is :code:`<code>false</code>` by default.
    :vartype app_offline: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'package_uri': {'key': 'properties.packageUri', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'db_type': {'key': 'properties.dbType', 'type': 'str'},
        'set_parameters_xml_file_uri': {'key': 'properties.setParametersXmlFileUri', 'type': 'str'},
        'set_parameters': {'key': 'properties.setParameters', 'type': '{str}'},
        'skip_app_data': {'key': 'properties.skipAppData', 'type': 'bool'},
        'app_offline': {'key': 'properties.appOffline', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        package_uri: Optional[str] = None,
        connection_string: Optional[str] = None,
        db_type: Optional[str] = None,
        set_parameters_xml_file_uri: Optional[str] = None,
        set_parameters: Optional[Dict[str, str]] = None,
        skip_app_data: Optional[bool] = None,
        app_offline: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword package_uri: Package URI.
        :paramtype package_uri: str
        :keyword connection_string: SQL Connection String.
        :paramtype connection_string: str
        :keyword db_type: Database Type.
        :paramtype db_type: str
        :keyword set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
         SetParameters is used.
        :paramtype set_parameters_xml_file_uri: str
        :keyword set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is
         used.
        :paramtype set_parameters: dict[str, str]
        :keyword skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
         If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
         will not be deleted, and any App_Data directory in the source will be ignored.
         Setting is :code:`<code>false</code>` by default.
        :paramtype skip_app_data: bool
        :keyword app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
         Setting is :code:`<code>false</code>` by default.
        :paramtype app_offline: bool
        """
        super(MSDeploy, self).__init__(kind=kind, **kwargs)
        self.package_uri = package_uri
        self.connection_string = connection_string
        self.db_type = db_type
        self.set_parameters_xml_file_uri = set_parameters_xml_file_uri
        self.set_parameters = set_parameters
        self.skip_app_data = skip_app_data
        self.app_offline = app_offline


class MSDeployLog(ProxyOnlyResource):
    """MSDeploy log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entries: List of log entry messages.
    :vartype entries: list[~azure.mgmt.web.v2021_01_15.models.MSDeployLogEntry]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'entries': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entries': {'key': 'properties.entries', 'type': '[MSDeployLogEntry]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(MSDeployLog, self).__init__(kind=kind, **kwargs)
        self.entries = None


class MSDeployLogEntry(msrest.serialization.Model):
    """MSDeploy log entry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: Timestamp of log entry.
    :vartype time: ~datetime.datetime
    :ivar type: Log entry type. Possible values include: "Message", "Warning", "Error".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.MSDeployLogEntryType
    :ivar message: Log entry message.
    :vartype message: str
    """

    _validation = {
        'time': {'readonly': True},
        'type': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MSDeployLogEntry, self).__init__(**kwargs)
        self.time = None
        self.type = None
        self.message = None


class MSDeployStatus(ProxyOnlyResource):
    """MSDeploy ARM response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deployer: Username of deployer.
    :vartype deployer: str
    :ivar provisioning_state: Provisioning state. Possible values include: "accepted", "running",
     "succeeded", "failed", "canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2021_01_15.models.MSDeployProvisioningState
    :ivar start_time: Start time of deploy operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of deploy operation.
    :vartype end_time: ~datetime.datetime
    :ivar complete: Whether the deployment operation has completed.
    :vartype complete: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deployer': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'complete': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'complete': {'key': 'properties.complete', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(MSDeployStatus, self).__init__(kind=kind, **kwargs)
        self.deployer = None
        self.provisioning_state = None
        self.start_time = None
        self.end_time = None
        self.complete = None


class NameIdentifier(msrest.serialization.Model):
    """Identifies an object.

    :ivar name: Name of the object.
    :vartype name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the object.
        :paramtype name: str
        """
        super(NameIdentifier, self).__init__(**kwargs)
        self.name = name


class NameIdentifierCollection(msrest.serialization.Model):
    """Collection of domain name identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.NameIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NameIdentifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["NameIdentifier"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.NameIdentifier]
        """
        super(NameIdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class NameValuePair(msrest.serialization.Model):
    """Name value pair.

    :ivar name: Pair name.
    :vartype name: str
    :ivar value: Pair value.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Pair name.
        :paramtype name: str
        :keyword value: Pair value.
        :paramtype value: str
        """
        super(NameValuePair, self).__init__(**kwargs)
        self.name = name
        self.value = value


class NetworkFeatures(ProxyOnlyResource):
    """Full view of network features for an app (presently VNET integration and Hybrid Connections).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_network_name: The Virtual Network name.
    :vartype virtual_network_name: str
    :ivar virtual_network_connection: The Virtual Network summary view.
    :vartype virtual_network_connection: ~azure.mgmt.web.v2021_01_15.models.VnetInfo
    :ivar hybrid_connections: The Hybrid Connections summary view.
    :vartype hybrid_connections:
     list[~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity]
    :ivar hybrid_connections_v2: The Hybrid Connection V2 (Service Bus) view.
    :vartype hybrid_connections_v2: list[~azure.mgmt.web.v2021_01_15.models.HybridConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_name': {'readonly': True},
        'virtual_network_connection': {'readonly': True},
        'hybrid_connections': {'readonly': True},
        'hybrid_connections_v2': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_name': {'key': 'properties.virtualNetworkName', 'type': 'str'},
        'virtual_network_connection': {'key': 'properties.virtualNetworkConnection', 'type': 'VnetInfo'},
        'hybrid_connections': {'key': 'properties.hybridConnections', 'type': '[RelayServiceConnectionEntity]'},
        'hybrid_connections_v2': {'key': 'properties.hybridConnectionsV2', 'type': '[HybridConnection]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(NetworkFeatures, self).__init__(kind=kind, **kwargs)
        self.virtual_network_name = None
        self.virtual_network_connection = None
        self.hybrid_connections = None
        self.hybrid_connections_v2 = None


class NetworkTrace(msrest.serialization.Model):
    """Network trace.

    :ivar path: Local file path for the captured network trace file.
    :vartype path: str
    :ivar status: Current status of the network trace operation, same as Operation.Status
     (InProgress/Succeeded/Failed).
    :vartype status: str
    :ivar message: Detailed message of a network trace operation, e.g. error message in case of
     failure.
    :vartype message: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        status: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword path: Local file path for the captured network trace file.
        :paramtype path: str
        :keyword status: Current status of the network trace operation, same as Operation.Status
         (InProgress/Succeeded/Failed).
        :paramtype status: str
        :keyword message: Detailed message of a network trace operation, e.g. error message in case of
         failure.
        :paramtype message: str
        """
        super(NetworkTrace, self).__init__(**kwargs)
        self.path = path
        self.status = status
        self.message = message


class Nonce(msrest.serialization.Model):
    """The configuration settings of the nonce used in the login flow.

    :ivar validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
     completing the login flow; otherwise, :code:`<code>true</code>`.
    :vartype validate_nonce: bool
    :ivar nonce_expiration_interval: The time after the request is made when the nonce should
     expire.
    :vartype nonce_expiration_interval: str
    """

    _attribute_map = {
        'validate_nonce': {'key': 'validateNonce', 'type': 'bool'},
        'nonce_expiration_interval': {'key': 'nonceExpirationInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validate_nonce: Optional[bool] = None,
        nonce_expiration_interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
         completing the login flow; otherwise, :code:`<code>true</code>`.
        :paramtype validate_nonce: bool
        :keyword nonce_expiration_interval: The time after the request is made when the nonce should
         expire.
        :paramtype nonce_expiration_interval: str
        """
        super(Nonce, self).__init__(**kwargs)
        self.validate_nonce = validate_nonce
        self.nonce_expiration_interval = nonce_expiration_interval


class OpenIdConnectClientCredential(msrest.serialization.Model):
    """The authentication client credentials of the custom Open ID Connect provider.

    :ivar method: The method that should be used to authenticate the user. The only acceptable
     values to pass in are None and "ClientSecretPost". The default value is None.
    :vartype method: str
    :ivar client_secret_setting_name: The app setting that contains the client secret for the
     custom Open ID Connect provider.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        method: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword method: The method that should be used to authenticate the user. The only acceptable
         values to pass in are None and "ClientSecretPost". The default value is None.
        :paramtype method: str
        :keyword client_secret_setting_name: The app setting that contains the client secret for the
         custom Open ID Connect provider.
        :paramtype client_secret_setting_name: str
        """
        super(OpenIdConnectClientCredential, self).__init__(**kwargs)
        self.method = method
        self.client_secret_setting_name = client_secret_setting_name


class OpenIdConnectConfig(msrest.serialization.Model):
    """The configuration settings of the endpoints used for the custom Open ID Connect provider.

    :ivar authorization_endpoint: The endpoint to be used to make an authorization request.
    :vartype authorization_endpoint: str
    :ivar token_endpoint: The endpoint to be used to request a token.
    :vartype token_endpoint: str
    :ivar issuer: The endpoint that issues the token.
    :vartype issuer: str
    :ivar certification_uri: The endpoint that provides the keys necessary to validate the token.
    :vartype certification_uri: str
    :ivar well_known_open_id_configuration: The endpoint that contains all the configuration
     endpoints for the provider.
    :vartype well_known_open_id_configuration: str
    """

    _attribute_map = {
        'authorization_endpoint': {'key': 'authorizationEndpoint', 'type': 'str'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'certification_uri': {'key': 'certificationUri', 'type': 'str'},
        'well_known_open_id_configuration': {'key': 'wellKnownOpenIdConfiguration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authorization_endpoint: Optional[str] = None,
        token_endpoint: Optional[str] = None,
        issuer: Optional[str] = None,
        certification_uri: Optional[str] = None,
        well_known_open_id_configuration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword authorization_endpoint: The endpoint to be used to make an authorization request.
        :paramtype authorization_endpoint: str
        :keyword token_endpoint: The endpoint to be used to request a token.
        :paramtype token_endpoint: str
        :keyword issuer: The endpoint that issues the token.
        :paramtype issuer: str
        :keyword certification_uri: The endpoint that provides the keys necessary to validate the
         token.
        :paramtype certification_uri: str
        :keyword well_known_open_id_configuration: The endpoint that contains all the configuration
         endpoints for the provider.
        :paramtype well_known_open_id_configuration: str
        """
        super(OpenIdConnectConfig, self).__init__(**kwargs)
        self.authorization_endpoint = authorization_endpoint
        self.token_endpoint = token_endpoint
        self.issuer = issuer
        self.certification_uri = certification_uri
        self.well_known_open_id_configuration = well_known_open_id_configuration


class OpenIdConnectLogin(msrest.serialization.Model):
    """The configuration settings of the login flow of the custom Open ID Connect provider.

    :ivar name_claim_type: The name of the claim that contains the users name.
    :vartype name_claim_type: str
    :ivar scopes: A list of the scopes that should be requested while authenticating.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        'name_claim_type': {'key': 'nameClaimType', 'type': 'str'},
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name_claim_type: Optional[str] = None,
        scopes: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name_claim_type: The name of the claim that contains the users name.
        :paramtype name_claim_type: str
        :keyword scopes: A list of the scopes that should be requested while authenticating.
        :paramtype scopes: list[str]
        """
        super(OpenIdConnectLogin, self).__init__(**kwargs)
        self.name_claim_type = name_claim_type
        self.scopes = scopes


class OpenIdConnectRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for the custom Open ID Connect provider.

    :ivar client_id: The client id of the custom Open ID Connect provider.
    :vartype client_id: str
    :ivar client_credential: The authentication credentials of the custom Open ID Connect provider.
    :vartype client_credential: ~azure.mgmt.web.v2021_01_15.models.OpenIdConnectClientCredential
    :ivar open_id_connect_configuration: The configuration settings of the endpoints used for the
     custom Open ID Connect provider.
    :vartype open_id_connect_configuration: ~azure.mgmt.web.v2021_01_15.models.OpenIdConnectConfig
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_credential': {'key': 'clientCredential', 'type': 'OpenIdConnectClientCredential'},
        'open_id_connect_configuration': {'key': 'openIdConnectConfiguration', 'type': 'OpenIdConnectConfig'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_credential: Optional["OpenIdConnectClientCredential"] = None,
        open_id_connect_configuration: Optional["OpenIdConnectConfig"] = None,
        **kwargs
    ):
        """
        :keyword client_id: The client id of the custom Open ID Connect provider.
        :paramtype client_id: str
        :keyword client_credential: The authentication credentials of the custom Open ID Connect
         provider.
        :paramtype client_credential: ~azure.mgmt.web.v2021_01_15.models.OpenIdConnectClientCredential
        :keyword open_id_connect_configuration: The configuration settings of the endpoints used for
         the custom Open ID Connect provider.
        :paramtype open_id_connect_configuration:
         ~azure.mgmt.web.v2021_01_15.models.OpenIdConnectConfig
        """
        super(OpenIdConnectRegistration, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_credential = client_credential
        self.open_id_connect_configuration = open_id_connect_configuration


class Operation(msrest.serialization.Model):
    """An operation on a resource.

    :ivar id: Operation ID.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar status: The current status of the operation. Possible values include: "InProgress",
     "Failed", "Succeeded", "TimedOut", "Created".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.OperationStatus
    :ivar errors: Any errors associate with the operation.
    :vartype errors: list[~azure.mgmt.web.v2021_01_15.models.ErrorEntity]
    :ivar created_time: Time when operation has started.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: Time when operation has been updated.
    :vartype modified_time: ~datetime.datetime
    :ivar expiration_time: Time when operation will expire.
    :vartype expiration_time: ~datetime.datetime
    :ivar geo_master_operation_id: Applicable only for stamp operation ids.
    :vartype geo_master_operation_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorEntity]'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'geo_master_operation_id': {'key': 'geoMasterOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "OperationStatus"]] = None,
        errors: Optional[List["ErrorEntity"]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        geo_master_operation_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Operation ID.
        :paramtype id: str
        :keyword name: Operation name.
        :paramtype name: str
        :keyword status: The current status of the operation. Possible values include: "InProgress",
         "Failed", "Succeeded", "TimedOut", "Created".
        :paramtype status: str or ~azure.mgmt.web.v2021_01_15.models.OperationStatus
        :keyword errors: Any errors associate with the operation.
        :paramtype errors: list[~azure.mgmt.web.v2021_01_15.models.ErrorEntity]
        :keyword created_time: Time when operation has started.
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time: Time when operation has been updated.
        :paramtype modified_time: ~datetime.datetime
        :keyword expiration_time: Time when operation will expire.
        :paramtype expiration_time: ~datetime.datetime
        :keyword geo_master_operation_id: Applicable only for stamp operation ids.
        :paramtype geo_master_operation_id: str
        """
        super(Operation, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.errors = errors
        self.created_time = created_time
        self.modified_time = modified_time
        self.expiration_time = expiration_time
        self.geo_master_operation_id = geo_master_operation_id


class OutboundEnvironmentEndpoint(msrest.serialization.Model):
    """Endpoints accessed for a common purpose that the App Service Environment requires outbound network access to.

    :ivar category: The type of service accessed by the App Service Environment, e.g., Azure
     Storage, Azure SQL Database, and Azure Active Directory.
    :vartype category: str
    :ivar endpoints: The endpoints that the App Service Environment reaches the service at.
    :vartype endpoints: list[~azure.mgmt.web.v2021_01_15.models.EndpointDependency]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["EndpointDependency"]] = None,
        **kwargs
    ):
        """
        :keyword category: The type of service accessed by the App Service Environment, e.g., Azure
         Storage, Azure SQL Database, and Azure Active Directory.
        :paramtype category: str
        :keyword endpoints: The endpoints that the App Service Environment reaches the service at.
        :paramtype endpoints: list[~azure.mgmt.web.v2021_01_15.models.EndpointDependency]
        """
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Collection of Outbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["OutboundEnvironmentEndpoint"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.OutboundEnvironmentEndpoint]
        """
        super(OutboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonCounterCollection(msrest.serialization.Model):
    """Collection of performance monitor counters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.PerfMonResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerfMonResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PerfMonResponse"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.PerfMonResponse]
        """
        super(PerfMonCounterCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonResponse(msrest.serialization.Model):
    """Performance monitor API response.

    :ivar code: The response code.
    :vartype code: str
    :ivar message: The message.
    :vartype message: str
    :ivar data: The performance monitor counters.
    :vartype data: ~azure.mgmt.web.v2021_01_15.models.PerfMonSet
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'data': {'key': 'data', 'type': 'PerfMonSet'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        data: Optional["PerfMonSet"] = None,
        **kwargs
    ):
        """
        :keyword code: The response code.
        :paramtype code: str
        :keyword message: The message.
        :paramtype message: str
        :keyword data: The performance monitor counters.
        :paramtype data: ~azure.mgmt.web.v2021_01_15.models.PerfMonSet
        """
        super(PerfMonResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.data = data


class PerfMonSample(msrest.serialization.Model):
    """Performance monitor sample in a set.

    :ivar time: Point in time for which counter was measured.
    :vartype time: ~datetime.datetime
    :ivar instance_name: Name of the server on which the measurement is made.
    :vartype instance_name: str
    :ivar value: Value of counter at a certain time.
    :vartype value: float
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'instance_name': {'key': 'instanceName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        time: Optional[datetime.datetime] = None,
        instance_name: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword time: Point in time for which counter was measured.
        :paramtype time: ~datetime.datetime
        :keyword instance_name: Name of the server on which the measurement is made.
        :paramtype instance_name: str
        :keyword value: Value of counter at a certain time.
        :paramtype value: float
        """
        super(PerfMonSample, self).__init__(**kwargs)
        self.time = time
        self.instance_name = instance_name
        self.value = value


class PerfMonSet(msrest.serialization.Model):
    """Metric information.

    :ivar name: Unique key name of the counter.
    :vartype name: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: Presented time grain.
    :vartype time_grain: str
    :ivar values: Collection of workers that are active during this time.
    :vartype values: list[~azure.mgmt.web.v2021_01_15.models.PerfMonSample]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'values': {'key': 'values', 'type': '[PerfMonSample]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["PerfMonSample"]] = None,
        **kwargs
    ):
        """
        :keyword name: Unique key name of the counter.
        :paramtype name: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword time_grain: Presented time grain.
        :paramtype time_grain: str
        :keyword values: Collection of workers that are active during this time.
        :paramtype values: list[~azure.mgmt.web.v2021_01_15.models.PerfMonSample]
        """
        super(PerfMonSet, self).__init__(**kwargs)
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class PremierAddOn(Resource):
    """Premier add-on.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on Product.
    :vartype product: str
    :ivar vendor: Premier add on Vendor.
    :vartype vendor: str
    :ivar marketplace_publisher: Premier add on Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Premier add on Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on Product.
        :paramtype product: str
        :keyword vendor: Premier add on Vendor.
        :paramtype vendor: str
        :keyword marketplace_publisher: Premier add on Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Premier add on Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super(PremierAddOn, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOffer(ProxyOnlyResource):
    """Premier add-on offer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on offer Product.
    :vartype product: str
    :ivar vendor: Premier add on offer Vendor.
    :vartype vendor: str
    :ivar promo_code_required: :code:`<code>true</code>` if promotion code is required; otherwise,
     :code:`<code>false</code>`.
    :vartype promo_code_required: bool
    :ivar quota: Premier add on offer Quota.
    :vartype quota: int
    :ivar web_hosting_plan_restrictions: App Service plans this offer is restricted to. Possible
     values include: "None", "Free", "Shared", "Basic", "Standard", "Premium".
    :vartype web_hosting_plan_restrictions: str or
     ~azure.mgmt.web.v2021_01_15.models.AppServicePlanRestrictions
    :ivar privacy_policy_url: Privacy policy URL.
    :vartype privacy_policy_url: str
    :ivar legal_terms_url: Legal terms URL.
    :vartype legal_terms_url: str
    :ivar marketplace_publisher: Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'promo_code_required': {'key': 'properties.promoCodeRequired', 'type': 'bool'},
        'quota': {'key': 'properties.quota', 'type': 'int'},
        'web_hosting_plan_restrictions': {'key': 'properties.webHostingPlanRestrictions', 'type': 'str'},
        'privacy_policy_url': {'key': 'properties.privacyPolicyUrl', 'type': 'str'},
        'legal_terms_url': {'key': 'properties.legalTermsUrl', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        promo_code_required: Optional[bool] = None,
        quota: Optional[int] = None,
        web_hosting_plan_restrictions: Optional[Union[str, "AppServicePlanRestrictions"]] = None,
        privacy_policy_url: Optional[str] = None,
        legal_terms_url: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on offer Product.
        :paramtype product: str
        :keyword vendor: Premier add on offer Vendor.
        :paramtype vendor: str
        :keyword promo_code_required: :code:`<code>true</code>` if promotion code is required;
         otherwise, :code:`<code>false</code>`.
        :paramtype promo_code_required: bool
        :keyword quota: Premier add on offer Quota.
        :paramtype quota: int
        :keyword web_hosting_plan_restrictions: App Service plans this offer is restricted to. Possible
         values include: "None", "Free", "Shared", "Basic", "Standard", "Premium".
        :paramtype web_hosting_plan_restrictions: str or
         ~azure.mgmt.web.v2021_01_15.models.AppServicePlanRestrictions
        :keyword privacy_policy_url: Privacy policy URL.
        :paramtype privacy_policy_url: str
        :keyword legal_terms_url: Legal terms URL.
        :paramtype legal_terms_url: str
        :keyword marketplace_publisher: Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super(PremierAddOnOffer, self).__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.promo_code_required = promo_code_required
        self.quota = quota
        self.web_hosting_plan_restrictions = web_hosting_plan_restrictions
        self.privacy_policy_url = privacy_policy_url
        self.legal_terms_url = legal_terms_url
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOfferCollection(msrest.serialization.Model):
    """Collection of premier add-on offers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.PremierAddOnOffer]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PremierAddOnOffer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PremierAddOnOffer"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.PremierAddOnOffer]
        """
        super(PremierAddOnOfferCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PremierAddOnPatchResource(ProxyOnlyResource):
    """ARM resource for a PremierAddOn.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on Product.
    :vartype product: str
    :ivar vendor: Premier add on Vendor.
    :vartype vendor: str
    :ivar marketplace_publisher: Premier add on Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Premier add on Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on Product.
        :paramtype product: str
        :keyword vendor: Premier add on Vendor.
        :paramtype vendor: str
        :keyword marketplace_publisher: Premier add on Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Premier add on Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super(PremierAddOnPatchResource, self).__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PrivateAccess(ProxyOnlyResource):
    """Description of the parameters of Private Access for a Web Site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar enabled: Whether private access is enabled or not.
    :vartype enabled: bool
    :ivar virtual_networks: The Virtual Networks (and subnets) allowed to access the site
     privately.
    :vartype virtual_networks: list[~azure.mgmt.web.v2021_01_15.models.PrivateAccessVirtualNetwork]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'virtual_networks': {'key': 'properties.virtualNetworks', 'type': '[PrivateAccessVirtualNetwork]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        virtual_networks: Optional[List["PrivateAccessVirtualNetwork"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword enabled: Whether private access is enabled or not.
        :paramtype enabled: bool
        :keyword virtual_networks: The Virtual Networks (and subnets) allowed to access the site
         privately.
        :paramtype virtual_networks:
         list[~azure.mgmt.web.v2021_01_15.models.PrivateAccessVirtualNetwork]
        """
        super(PrivateAccess, self).__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.virtual_networks = virtual_networks


class PrivateAccessSubnet(msrest.serialization.Model):
    """Description of a Virtual Network subnet that is useable for private site access.

    :ivar name: The name of the subnet.
    :vartype name: str
    :ivar key: The key (ID) of the subnet.
    :vartype key: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'key': {'key': 'key', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        key: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the subnet.
        :paramtype name: str
        :keyword key: The key (ID) of the subnet.
        :paramtype key: int
        """
        super(PrivateAccessSubnet, self).__init__(**kwargs)
        self.name = name
        self.key = key


class PrivateAccessVirtualNetwork(msrest.serialization.Model):
    """Description of a Virtual Network that is useable for private site access.

    :ivar name: The name of the Virtual Network.
    :vartype name: str
    :ivar key: The key (ID) of the Virtual Network.
    :vartype key: int
    :ivar resource_id: The ARM uri of the Virtual Network.
    :vartype resource_id: str
    :ivar subnets: A List of subnets that access is allowed to on this Virtual Network. An empty
     array (but not null) is interpreted to mean that all subnets are allowed within this Virtual
     Network.
    :vartype subnets: list[~azure.mgmt.web.v2021_01_15.models.PrivateAccessSubnet]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'key': {'key': 'key', 'type': 'int'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'subnets': {'key': 'subnets', 'type': '[PrivateAccessSubnet]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        key: Optional[int] = None,
        resource_id: Optional[str] = None,
        subnets: Optional[List["PrivateAccessSubnet"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the Virtual Network.
        :paramtype name: str
        :keyword key: The key (ID) of the Virtual Network.
        :paramtype key: int
        :keyword resource_id: The ARM uri of the Virtual Network.
        :paramtype resource_id: str
        :keyword subnets: A List of subnets that access is allowed to on this Virtual Network. An empty
         array (but not null) is interpreted to mean that all subnets are allowed within this Virtual
         Network.
        :paramtype subnets: list[~azure.mgmt.web.v2021_01_15.models.PrivateAccessSubnet]
        """
        super(PrivateAccessVirtualNetwork, self).__init__(**kwargs)
        self.name = name
        self.key = key
        self.resource_id = resource_id
        self.subnets = subnets


class PrivateEndpointConnectionCollection(msrest.serialization.Model):
    """PrivateEndpointConnectionCollection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value:
     list[~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnectionARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RemotePrivateEndpointConnectionARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["RemotePrivateEndpointConnectionARMResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value:
         list[~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnectionARMResource]
        """
        super(PrivateEndpointConnectionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateLinkConnectionApprovalRequestResource(ProxyOnlyResource):
    """Private Endpoint Connection Approval ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar private_link_service_connection_state: The state of a private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.web.v2021_01_15.models.PrivateLinkConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_link_service_connection_state: Optional["PrivateLinkConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword private_link_service_connection_state: The state of a private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.web.v2021_01_15.models.PrivateLinkConnectionState
        """
        super(PrivateLinkConnectionApprovalRequestResource, self).__init__(kind=kind, **kwargs)
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkConnectionState(msrest.serialization.Model):
    """The state of a private link connection.

    :ivar status: Status of a private link connection.
    :vartype status: str
    :ivar description: Description of a private link connection.
    :vartype description: str
    :ivar actions_required: ActionsRequired for a private link connection.
    :vartype actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Status of a private link connection.
        :paramtype status: str
        :keyword description: Description of a private link connection.
        :paramtype description: str
        :keyword actions_required: ActionsRequired for a private link connection.
        :paramtype actions_required: str
        """
        super(PrivateLinkConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PrivateLinkResource(msrest.serialization.Model):
    """A private link resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar name: Required. Name of a private link resource.
    :vartype name: str
    :ivar type: Required.
    :vartype type: str
    :ivar properties: Required. Properties of a private link resource.
    :vartype properties: ~azure.mgmt.web.v2021_01_15.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'type': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        type: str,
        properties: "PrivateLinkResourceProperties",
        **kwargs
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword name: Required. Name of a private link resource.
        :paramtype name: str
        :keyword type: Required.
        :paramtype type: str
        :keyword properties: Required. Properties of a private link resource.
        :paramtype properties: ~azure.mgmt.web.v2021_01_15.models.PrivateLinkResourceProperties
        """
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.properties = properties


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: GroupId of a private link resource.
    :vartype group_id: str
    :ivar required_members: RequiredMembers of a private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: RequiredZoneNames of a private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkResourcesWrapper(msrest.serialization.Model):
    """Wrapper for a collection of private link resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.PrivateLinkResource]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: List["PrivateLinkResource"],
        **kwargs
    ):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.PrivateLinkResource]
        """
        super(PrivateLinkResourcesWrapper, self).__init__(**kwargs)
        self.value = value


class ProcessInfo(ProxyOnlyResource):
    """Process Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: ARM Identifier for deployment.
    :vartype identifier: int
    :ivar deployment_name: Deployment name.
    :vartype deployment_name: str
    :ivar href: HRef URI.
    :vartype href: str
    :ivar minidump: Minidump URI.
    :vartype minidump: str
    :ivar is_profile_running: Is profile running?.
    :vartype is_profile_running: bool
    :ivar is_iis_profile_running: Is the IIS Profile running?.
    :vartype is_iis_profile_running: bool
    :ivar iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :vartype iis_profile_timeout_in_seconds: float
    :ivar parent: Parent process.
    :vartype parent: str
    :ivar children: Child process list.
    :vartype children: list[str]
    :ivar threads: Thread list.
    :vartype threads: list[~azure.mgmt.web.v2021_01_15.models.ProcessThreadInfo]
    :ivar open_file_handles: List of open files.
    :vartype open_file_handles: list[str]
    :ivar modules: List of modules.
    :vartype modules: list[~azure.mgmt.web.v2021_01_15.models.ProcessModuleInfo]
    :ivar file_name: File name of this process.
    :vartype file_name: str
    :ivar command_line: Command line.
    :vartype command_line: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar handle_count: Handle count.
    :vartype handle_count: int
    :ivar module_count: Module count.
    :vartype module_count: int
    :ivar thread_count: Thread count.
    :vartype thread_count: int
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar total_cpu_time: Total CPU time.
    :vartype total_cpu_time: str
    :ivar user_cpu_time: User CPU time.
    :vartype user_cpu_time: str
    :ivar privileged_cpu_time: Privileged CPU time.
    :vartype privileged_cpu_time: str
    :ivar working_set: Working set.
    :vartype working_set: long
    :ivar peak_working_set: Peak working set.
    :vartype peak_working_set: long
    :ivar private_memory: Private memory size.
    :vartype private_memory: long
    :ivar virtual_memory: Virtual memory size.
    :vartype virtual_memory: long
    :ivar peak_virtual_memory: Peak virtual memory usage.
    :vartype peak_virtual_memory: long
    :ivar paged_system_memory: Paged system memory.
    :vartype paged_system_memory: long
    :ivar non_paged_system_memory: Non-paged system memory.
    :vartype non_paged_system_memory: long
    :ivar paged_memory: Paged memory.
    :vartype paged_memory: long
    :ivar peak_paged_memory: Peak paged memory.
    :vartype peak_paged_memory: long
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    :ivar environment_variables: List of environment variables.
    :vartype environment_variables: dict[str, str]
    :ivar is_scm_site: Is this the SCM site?.
    :vartype is_scm_site: bool
    :ivar is_webjob: Is this a Web Job?.
    :vartype is_webjob: bool
    :ivar description: Description of process.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'int'},
        'deployment_name': {'key': 'properties.deployment_name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'minidump': {'key': 'properties.minidump', 'type': 'str'},
        'is_profile_running': {'key': 'properties.is_profile_running', 'type': 'bool'},
        'is_iis_profile_running': {'key': 'properties.is_iis_profile_running', 'type': 'bool'},
        'iis_profile_timeout_in_seconds': {'key': 'properties.iis_profile_timeout_in_seconds', 'type': 'float'},
        'parent': {'key': 'properties.parent', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[str]'},
        'threads': {'key': 'properties.threads', 'type': '[ProcessThreadInfo]'},
        'open_file_handles': {'key': 'properties.open_file_handles', 'type': '[str]'},
        'modules': {'key': 'properties.modules', 'type': '[ProcessModuleInfo]'},
        'file_name': {'key': 'properties.file_name', 'type': 'str'},
        'command_line': {'key': 'properties.command_line', 'type': 'str'},
        'user_name': {'key': 'properties.user_name', 'type': 'str'},
        'handle_count': {'key': 'properties.handle_count', 'type': 'int'},
        'module_count': {'key': 'properties.module_count', 'type': 'int'},
        'thread_count': {'key': 'properties.thread_count', 'type': 'int'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'total_cpu_time': {'key': 'properties.total_cpu_time', 'type': 'str'},
        'user_cpu_time': {'key': 'properties.user_cpu_time', 'type': 'str'},
        'privileged_cpu_time': {'key': 'properties.privileged_cpu_time', 'type': 'str'},
        'working_set': {'key': 'properties.working_set', 'type': 'long'},
        'peak_working_set': {'key': 'properties.peak_working_set', 'type': 'long'},
        'private_memory': {'key': 'properties.private_memory', 'type': 'long'},
        'virtual_memory': {'key': 'properties.virtual_memory', 'type': 'long'},
        'peak_virtual_memory': {'key': 'properties.peak_virtual_memory', 'type': 'long'},
        'paged_system_memory': {'key': 'properties.paged_system_memory', 'type': 'long'},
        'non_paged_system_memory': {'key': 'properties.non_paged_system_memory', 'type': 'long'},
        'paged_memory': {'key': 'properties.paged_memory', 'type': 'long'},
        'peak_paged_memory': {'key': 'properties.peak_paged_memory', 'type': 'long'},
        'time_stamp': {'key': 'properties.time_stamp', 'type': 'iso-8601'},
        'environment_variables': {'key': 'properties.environment_variables', 'type': '{str}'},
        'is_scm_site': {'key': 'properties.is_scm_site', 'type': 'bool'},
        'is_webjob': {'key': 'properties.is_webjob', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        deployment_name: Optional[str] = None,
        href: Optional[str] = None,
        minidump: Optional[str] = None,
        is_profile_running: Optional[bool] = None,
        is_iis_profile_running: Optional[bool] = None,
        iis_profile_timeout_in_seconds: Optional[float] = None,
        parent: Optional[str] = None,
        children: Optional[List[str]] = None,
        threads: Optional[List["ProcessThreadInfo"]] = None,
        open_file_handles: Optional[List[str]] = None,
        modules: Optional[List["ProcessModuleInfo"]] = None,
        file_name: Optional[str] = None,
        command_line: Optional[str] = None,
        user_name: Optional[str] = None,
        handle_count: Optional[int] = None,
        module_count: Optional[int] = None,
        thread_count: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_cpu_time: Optional[str] = None,
        user_cpu_time: Optional[str] = None,
        privileged_cpu_time: Optional[str] = None,
        working_set: Optional[int] = None,
        peak_working_set: Optional[int] = None,
        private_memory: Optional[int] = None,
        virtual_memory: Optional[int] = None,
        peak_virtual_memory: Optional[int] = None,
        paged_system_memory: Optional[int] = None,
        non_paged_system_memory: Optional[int] = None,
        paged_memory: Optional[int] = None,
        peak_paged_memory: Optional[int] = None,
        time_stamp: Optional[datetime.datetime] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        is_scm_site: Optional[bool] = None,
        is_webjob: Optional[bool] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword deployment_name: Deployment name.
        :paramtype deployment_name: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword minidump: Minidump URI.
        :paramtype minidump: str
        :keyword is_profile_running: Is profile running?.
        :paramtype is_profile_running: bool
        :keyword is_iis_profile_running: Is the IIS Profile running?.
        :paramtype is_iis_profile_running: bool
        :keyword iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
        :paramtype iis_profile_timeout_in_seconds: float
        :keyword parent: Parent process.
        :paramtype parent: str
        :keyword children: Child process list.
        :paramtype children: list[str]
        :keyword threads: Thread list.
        :paramtype threads: list[~azure.mgmt.web.v2021_01_15.models.ProcessThreadInfo]
        :keyword open_file_handles: List of open files.
        :paramtype open_file_handles: list[str]
        :keyword modules: List of modules.
        :paramtype modules: list[~azure.mgmt.web.v2021_01_15.models.ProcessModuleInfo]
        :keyword file_name: File name of this process.
        :paramtype file_name: str
        :keyword command_line: Command line.
        :paramtype command_line: str
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword handle_count: Handle count.
        :paramtype handle_count: int
        :keyword module_count: Module count.
        :paramtype module_count: int
        :keyword thread_count: Thread count.
        :paramtype thread_count: int
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword total_cpu_time: Total CPU time.
        :paramtype total_cpu_time: str
        :keyword user_cpu_time: User CPU time.
        :paramtype user_cpu_time: str
        :keyword privileged_cpu_time: Privileged CPU time.
        :paramtype privileged_cpu_time: str
        :keyword working_set: Working set.
        :paramtype working_set: long
        :keyword peak_working_set: Peak working set.
        :paramtype peak_working_set: long
        :keyword private_memory: Private memory size.
        :paramtype private_memory: long
        :keyword virtual_memory: Virtual memory size.
        :paramtype virtual_memory: long
        :keyword peak_virtual_memory: Peak virtual memory usage.
        :paramtype peak_virtual_memory: long
        :keyword paged_system_memory: Paged system memory.
        :paramtype paged_system_memory: long
        :keyword non_paged_system_memory: Non-paged system memory.
        :paramtype non_paged_system_memory: long
        :keyword paged_memory: Paged memory.
        :paramtype paged_memory: long
        :keyword peak_paged_memory: Peak paged memory.
        :paramtype peak_paged_memory: long
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        :keyword environment_variables: List of environment variables.
        :paramtype environment_variables: dict[str, str]
        :keyword is_scm_site: Is this the SCM site?.
        :paramtype is_scm_site: bool
        :keyword is_webjob: Is this a Web Job?.
        :paramtype is_webjob: bool
        :keyword description: Description of process.
        :paramtype description: str
        """
        super(ProcessInfo, self).__init__(kind=kind, **kwargs)
        self.identifier = None
        self.deployment_name = deployment_name
        self.href = href
        self.minidump = minidump
        self.is_profile_running = is_profile_running
        self.is_iis_profile_running = is_iis_profile_running
        self.iis_profile_timeout_in_seconds = iis_profile_timeout_in_seconds
        self.parent = parent
        self.children = children
        self.threads = threads
        self.open_file_handles = open_file_handles
        self.modules = modules
        self.file_name = file_name
        self.command_line = command_line
        self.user_name = user_name
        self.handle_count = handle_count
        self.module_count = module_count
        self.thread_count = thread_count
        self.start_time = start_time
        self.total_cpu_time = total_cpu_time
        self.user_cpu_time = user_cpu_time
        self.privileged_cpu_time = privileged_cpu_time
        self.working_set = working_set
        self.peak_working_set = peak_working_set
        self.private_memory = private_memory
        self.virtual_memory = virtual_memory
        self.peak_virtual_memory = peak_virtual_memory
        self.paged_system_memory = paged_system_memory
        self.non_paged_system_memory = non_paged_system_memory
        self.paged_memory = paged_memory
        self.peak_paged_memory = peak_paged_memory
        self.time_stamp = time_stamp
        self.environment_variables = environment_variables
        self.is_scm_site = is_scm_site
        self.is_webjob = is_webjob
        self.description = description


class ProcessInfoCollection(msrest.serialization.Model):
    """Collection of Kudu process information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.ProcessInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ProcessInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.ProcessInfo]
        """
        super(ProcessInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessModuleInfo(ProxyOnlyResource):
    """Process Module Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar base_address: Base address. Used as module identifier in ARM resource URI.
    :vartype base_address: str
    :ivar file_name: File name.
    :vartype file_name: str
    :ivar href: HRef URI.
    :vartype href: str
    :ivar file_path: File path.
    :vartype file_path: str
    :ivar module_memory_size: Module memory size.
    :vartype module_memory_size: int
    :ivar file_version: File version.
    :vartype file_version: str
    :ivar file_description: File description.
    :vartype file_description: str
    :ivar product: Product name.
    :vartype product: str
    :ivar product_version: Product version.
    :vartype product_version: str
    :ivar is_debug: Is debug?.
    :vartype is_debug: bool
    :ivar language: Module language (locale).
    :vartype language: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'base_address': {'key': 'properties.base_address', 'type': 'str'},
        'file_name': {'key': 'properties.file_name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'file_path': {'key': 'properties.file_path', 'type': 'str'},
        'module_memory_size': {'key': 'properties.module_memory_size', 'type': 'int'},
        'file_version': {'key': 'properties.file_version', 'type': 'str'},
        'file_description': {'key': 'properties.file_description', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'product_version': {'key': 'properties.product_version', 'type': 'str'},
        'is_debug': {'key': 'properties.is_debug', 'type': 'bool'},
        'language': {'key': 'properties.language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        base_address: Optional[str] = None,
        file_name: Optional[str] = None,
        href: Optional[str] = None,
        file_path: Optional[str] = None,
        module_memory_size: Optional[int] = None,
        file_version: Optional[str] = None,
        file_description: Optional[str] = None,
        product: Optional[str] = None,
        product_version: Optional[str] = None,
        is_debug: Optional[bool] = None,
        language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword base_address: Base address. Used as module identifier in ARM resource URI.
        :paramtype base_address: str
        :keyword file_name: File name.
        :paramtype file_name: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword file_path: File path.
        :paramtype file_path: str
        :keyword module_memory_size: Module memory size.
        :paramtype module_memory_size: int
        :keyword file_version: File version.
        :paramtype file_version: str
        :keyword file_description: File description.
        :paramtype file_description: str
        :keyword product: Product name.
        :paramtype product: str
        :keyword product_version: Product version.
        :paramtype product_version: str
        :keyword is_debug: Is debug?.
        :paramtype is_debug: bool
        :keyword language: Module language (locale).
        :paramtype language: str
        """
        super(ProcessModuleInfo, self).__init__(kind=kind, **kwargs)
        self.base_address = base_address
        self.file_name = file_name
        self.href = href
        self.file_path = file_path
        self.module_memory_size = module_memory_size
        self.file_version = file_version
        self.file_description = file_description
        self.product = product
        self.product_version = product_version
        self.is_debug = is_debug
        self.language = language


class ProcessModuleInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.ProcessModuleInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessModuleInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ProcessModuleInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.ProcessModuleInfo]
        """
        super(ProcessModuleInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessThreadInfo(ProxyOnlyResource):
    """Process Thread Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: Site extension ID.
    :vartype identifier: int
    :ivar href: HRef URI.
    :vartype href: str
    :ivar process: Process URI.
    :vartype process: str
    :ivar start_address: Start address.
    :vartype start_address: str
    :ivar current_priority: Current thread priority.
    :vartype current_priority: int
    :ivar priority_level: Thread priority level.
    :vartype priority_level: str
    :ivar base_priority: Base priority.
    :vartype base_priority: int
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar total_processor_time: Total processor time.
    :vartype total_processor_time: str
    :ivar user_processor_time: User processor time.
    :vartype user_processor_time: str
    :ivar state: Thread state.
    :vartype state: str
    :ivar wait_reason: Wait reason.
    :vartype wait_reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'int'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'process': {'key': 'properties.process', 'type': 'str'},
        'start_address': {'key': 'properties.start_address', 'type': 'str'},
        'current_priority': {'key': 'properties.current_priority', 'type': 'int'},
        'priority_level': {'key': 'properties.priority_level', 'type': 'str'},
        'base_priority': {'key': 'properties.base_priority', 'type': 'int'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'total_processor_time': {'key': 'properties.total_processor_time', 'type': 'str'},
        'user_processor_time': {'key': 'properties.user_processor_time', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'wait_reason': {'key': 'properties.wait_reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        href: Optional[str] = None,
        process: Optional[str] = None,
        start_address: Optional[str] = None,
        current_priority: Optional[int] = None,
        priority_level: Optional[str] = None,
        base_priority: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_processor_time: Optional[str] = None,
        user_processor_time: Optional[str] = None,
        state: Optional[str] = None,
        wait_reason: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword process: Process URI.
        :paramtype process: str
        :keyword start_address: Start address.
        :paramtype start_address: str
        :keyword current_priority: Current thread priority.
        :paramtype current_priority: int
        :keyword priority_level: Thread priority level.
        :paramtype priority_level: str
        :keyword base_priority: Base priority.
        :paramtype base_priority: int
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword total_processor_time: Total processor time.
        :paramtype total_processor_time: str
        :keyword user_processor_time: User processor time.
        :paramtype user_processor_time: str
        :keyword state: Thread state.
        :paramtype state: str
        :keyword wait_reason: Wait reason.
        :paramtype wait_reason: str
        """
        super(ProcessThreadInfo, self).__init__(kind=kind, **kwargs)
        self.identifier = None
        self.href = href
        self.process = process
        self.start_address = start_address
        self.current_priority = current_priority
        self.priority_level = priority_level
        self.base_priority = base_priority
        self.start_time = start_time
        self.total_processor_time = total_processor_time
        self.user_processor_time = user_processor_time
        self.state = state
        self.wait_reason = wait_reason


class ProcessThreadInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.ProcessThreadInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessThreadInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ProcessThreadInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.ProcessThreadInfo]
        """
        super(ProcessThreadInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PublicCertificate(ProxyOnlyResource):
    """Public certificate object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar blob: Public Certificate byte array.
    :vartype blob: bytearray
    :ivar public_certificate_location: Public Certificate Location. Possible values include:
     "CurrentUserMy", "LocalMachineMy", "Unknown".
    :vartype public_certificate_location: str or
     ~azure.mgmt.web.v2021_01_15.models.PublicCertificateLocation
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'blob': {'key': 'properties.blob', 'type': 'bytearray'},
        'public_certificate_location': {'key': 'properties.publicCertificateLocation', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        blob: Optional[bytearray] = None,
        public_certificate_location: Optional[Union[str, "PublicCertificateLocation"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword blob: Public Certificate byte array.
        :paramtype blob: bytearray
        :keyword public_certificate_location: Public Certificate Location. Possible values include:
         "CurrentUserMy", "LocalMachineMy", "Unknown".
        :paramtype public_certificate_location: str or
         ~azure.mgmt.web.v2021_01_15.models.PublicCertificateLocation
        """
        super(PublicCertificate, self).__init__(kind=kind, **kwargs)
        self.blob = blob
        self.public_certificate_location = public_certificate_location
        self.thumbprint = None


class PublicCertificateCollection(msrest.serialization.Model):
    """Collection of public certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.PublicCertificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicCertificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PublicCertificate"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.PublicCertificate]
        """
        super(PublicCertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PublishingCredentialsPoliciesCollection(msrest.serialization.Model):
    """Publishing Credentials Policies entity collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmPublishingCredentialsPoliciesEntity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CsmPublishingCredentialsPoliciesEntity"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value:
         list[~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity]
        """
        super(PublishingCredentialsPoliciesCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :vartype is_push_enabled: bool
    :ivar tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
     whitelisted for use by the push registration endpoint.
    :vartype tag_whitelist_json: str
    :ivar tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :vartype tags_requiring_auth: str
    :ivar dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will
     be evaluated from user claims in the push registration endpoint.
    :vartype dynamic_tags_json: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_push_enabled': {'key': 'properties.isPushEnabled', 'type': 'bool'},
        'tag_whitelist_json': {'key': 'properties.tagWhitelistJson', 'type': 'str'},
        'tags_requiring_auth': {'key': 'properties.tagsRequiringAuth', 'type': 'str'},
        'dynamic_tags_json': {'key': 'properties.dynamicTagsJson', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        is_push_enabled: Optional[bool] = None,
        tag_whitelist_json: Optional[str] = None,
        tags_requiring_auth: Optional[str] = None,
        dynamic_tags_json: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :paramtype is_push_enabled: bool
        :keyword tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
         whitelisted for use by the push registration endpoint.
        :paramtype tag_whitelist_json: str
        :keyword tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
         user authentication to be used in the push registration endpoint.
         Tags can consist of alphanumeric characters and the following:
         '_', '@', '#', '.', ':', '-'.
         Validation should be performed at the PushRequestHandler.
        :paramtype tags_requiring_auth: str
        :keyword dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
         will be evaluated from user claims in the push registration endpoint.
        :paramtype dynamic_tags_json: str
        """
        super(PushSettings, self).__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class QueryUtterancesResult(msrest.serialization.Model):
    """Result for utterances query.

    :ivar sample_utterance: A sample utterance.
    :vartype sample_utterance: ~azure.mgmt.web.v2021_01_15.models.SampleUtterance
    :ivar score: Score of a sample utterance.
    :vartype score: float
    """

    _attribute_map = {
        'sample_utterance': {'key': 'sampleUtterance', 'type': 'SampleUtterance'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        sample_utterance: Optional["SampleUtterance"] = None,
        score: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword sample_utterance: A sample utterance.
        :paramtype sample_utterance: ~azure.mgmt.web.v2021_01_15.models.SampleUtterance
        :keyword score: Score of a sample utterance.
        :paramtype score: float
        """
        super(QueryUtterancesResult, self).__init__(**kwargs)
        self.sample_utterance = sample_utterance
        self.score = score


class QueryUtterancesResults(msrest.serialization.Model):
    """Suggested utterances where the detector can be applicable.

    :ivar query: Search Query.
    :vartype query: str
    :ivar results: Array of utterance results for search query.
    :vartype results: list[~azure.mgmt.web.v2021_01_15.models.QueryUtterancesResult]
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'results': {'key': 'results', 'type': '[QueryUtterancesResult]'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        results: Optional[List["QueryUtterancesResult"]] = None,
        **kwargs
    ):
        """
        :keyword query: Search Query.
        :paramtype query: str
        :keyword results: Array of utterance results for search query.
        :paramtype results: list[~azure.mgmt.web.v2021_01_15.models.QueryUtterancesResult]
        """
        super(QueryUtterancesResults, self).__init__(**kwargs)
        self.query = query
        self.results = results


class RampUpRule(msrest.serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.

    :ivar action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :vartype action_host_name: str
    :ivar reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :vartype reroute_percentage: float
    :ivar change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     \n:code:`<code>MinReroutePercentage</code>` or
     :code:`<code>MaxReroutePercentage</code>`. Site metrics are checked every N minutes specified
     in :code:`<code>ChangeIntervalInMinutes</code>`.\nCustom decision algorithm
     can be provided in TiPCallback site extension which URL can be specified in
     :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :vartype change_step: float
    :ivar change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :vartype change_interval_in_minutes: int
    :ivar min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
    :vartype min_reroute_percentage: float
    :ivar max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
    :vartype max_reroute_percentage: float
    :ivar change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :vartype change_decision_callback_url: str
    :ivar name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :vartype name: str
    """

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action_host_name: Optional[str] = None,
        reroute_percentage: Optional[float] = None,
        change_step: Optional[float] = None,
        change_interval_in_minutes: Optional[int] = None,
        min_reroute_percentage: Optional[float] = None,
        max_reroute_percentage: Optional[float] = None,
        change_decision_callback_url: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action_host_name: Hostname of a slot to which the traffic will be redirected if
         decided to. E.g. myapp-stage.azurewebsites.net.
        :paramtype action_host_name: str
        :keyword reroute_percentage: Percentage of the traffic which will be redirected to
         :code:`<code>ActionHostName</code>`.
        :paramtype reroute_percentage: float
        :keyword change_step: In auto ramp up scenario this is the step to add/remove from
         :code:`<code>ReroutePercentage</code>` until it reaches
         \n:code:`<code>MinReroutePercentage</code>` or
         :code:`<code>MaxReroutePercentage</code>`. Site metrics are checked every N minutes specified
         in :code:`<code>ChangeIntervalInMinutes</code>`.\nCustom decision algorithm
         can be provided in TiPCallback site extension which URL can be specified in
         :code:`<code>ChangeDecisionCallbackUrl</code>`.
        :paramtype change_step: float
        :keyword change_interval_in_minutes: Specifies interval in minutes to reevaluate
         ReroutePercentage.
        :paramtype change_interval_in_minutes: int
        :keyword min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
         stay.
        :paramtype min_reroute_percentage: float
        :keyword max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
         stay.
        :paramtype max_reroute_percentage: float
        :keyword change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
         site extension which URL can be specified. See TiPCallback site extension for the scaffold and
         contracts.
         https://www.siteextensions.net/packages/TiPCallback/.
        :paramtype change_decision_callback_url: str
        :keyword name: Name of the routing rule. The recommended name would be to point to the slot
         which will receive the traffic in the experiment.
        :paramtype name: str
        """
        super(RampUpRule, self).__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class Recommendation(ProxyOnlyResource):
    """Represents a recommendation result generated by the recommendation engine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar creation_time: Timestamp when this instance was created.
    :vartype creation_time: ~datetime.datetime
    :ivar recommendation_id: A GUID value that each recommendation object is associated with.
    :vartype recommendation_id: str
    :ivar resource_id: Full ARM resource ID string that this recommendation object is associated
     with.
    :vartype resource_id: str
    :ivar resource_scope: Name of a resource type this recommendation applies, e.g. Subscription,
     ServerFarm, Site. Possible values include: "ServerFarm", "Subscription", "WebSite".
    :vartype resource_scope: str or ~azure.mgmt.web.v2021_01_15.models.ResourceScopeType
    :ivar rule_name: Unique name of the rule.
    :vartype rule_name: str
    :ivar display_name: UI friendly name of the rule (may not be unique).
    :vartype display_name: str
    :ivar message: Recommendation text.
    :vartype message: str
    :ivar level: Level indicating how critical this recommendation can impact. Possible values
     include: "Critical", "Warning", "Information", "NonUrgentSuggestion".
    :vartype level: str or ~azure.mgmt.web.v2021_01_15.models.NotificationLevel
    :ivar channels: List of channels that this recommendation can apply. Possible values include:
     "Notification", "Api", "Email", "Webhook", "All".
    :vartype channels: str or ~azure.mgmt.web.v2021_01_15.models.Channels
    :ivar category_tags: The list of category tags that this recommendation belongs to.
    :vartype category_tags: list[str]
    :ivar action_name: Name of action recommended by this object.
    :vartype action_name: str
    :ivar enabled: True if this recommendation is still valid (i.e. "actionable"). False if it is
     invalid.
    :vartype enabled: int
    :ivar states: The list of states of this recommendation. If it's null then it should be
     considered "Active".
    :vartype states: list[str]
    :ivar start_time: The beginning time in UTC of a range that the recommendation refers to.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time in UTC of a range that the recommendation refers to.
    :vartype end_time: ~datetime.datetime
    :ivar next_notification_time: When to notify this recommendation next in UTC. Null means that
     this will never be notified anymore.
    :vartype next_notification_time: ~datetime.datetime
    :ivar notification_expiration_time: Date and time in UTC when this notification expires.
    :vartype notification_expiration_time: ~datetime.datetime
    :ivar notified_time: Last timestamp in UTC this instance was actually notified. Null means that
     this recommendation hasn't been notified yet.
    :vartype notified_time: ~datetime.datetime
    :ivar score: A metric value measured by the rule.
    :vartype score: float
    :ivar is_dynamic: True if this is associated with a dynamically added rule.
    :vartype is_dynamic: bool
    :ivar extension_name: Extension name of the portal if exists.
    :vartype extension_name: str
    :ivar blade_name: Deep link to a blade on the portal.
    :vartype blade_name: str
    :ivar forward_link: Forward link to an external document associated with the rule.
    :vartype forward_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category_tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'recommendation_id': {'key': 'properties.recommendationId', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'resource_scope': {'key': 'properties.resourceScope', 'type': 'str'},
        'rule_name': {'key': 'properties.ruleName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'channels': {'key': 'properties.channels', 'type': 'str'},
        'category_tags': {'key': 'properties.categoryTags', 'type': '[str]'},
        'action_name': {'key': 'properties.actionName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'int'},
        'states': {'key': 'properties.states', 'type': '[str]'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'next_notification_time': {'key': 'properties.nextNotificationTime', 'type': 'iso-8601'},
        'notification_expiration_time': {'key': 'properties.notificationExpirationTime', 'type': 'iso-8601'},
        'notified_time': {'key': 'properties.notifiedTime', 'type': 'iso-8601'},
        'score': {'key': 'properties.score', 'type': 'float'},
        'is_dynamic': {'key': 'properties.isDynamic', 'type': 'bool'},
        'extension_name': {'key': 'properties.extensionName', 'type': 'str'},
        'blade_name': {'key': 'properties.bladeName', 'type': 'str'},
        'forward_link': {'key': 'properties.forwardLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        recommendation_id: Optional[str] = None,
        resource_id: Optional[str] = None,
        resource_scope: Optional[Union[str, "ResourceScopeType"]] = None,
        rule_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        level: Optional[Union[str, "NotificationLevel"]] = None,
        channels: Optional[Union[str, "Channels"]] = None,
        action_name: Optional[str] = None,
        enabled: Optional[int] = None,
        states: Optional[List[str]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        next_notification_time: Optional[datetime.datetime] = None,
        notification_expiration_time: Optional[datetime.datetime] = None,
        notified_time: Optional[datetime.datetime] = None,
        score: Optional[float] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword creation_time: Timestamp when this instance was created.
        :paramtype creation_time: ~datetime.datetime
        :keyword recommendation_id: A GUID value that each recommendation object is associated with.
        :paramtype recommendation_id: str
        :keyword resource_id: Full ARM resource ID string that this recommendation object is associated
         with.
        :paramtype resource_id: str
        :keyword resource_scope: Name of a resource type this recommendation applies, e.g.
         Subscription, ServerFarm, Site. Possible values include: "ServerFarm", "Subscription",
         "WebSite".
        :paramtype resource_scope: str or ~azure.mgmt.web.v2021_01_15.models.ResourceScopeType
        :keyword rule_name: Unique name of the rule.
        :paramtype rule_name: str
        :keyword display_name: UI friendly name of the rule (may not be unique).
        :paramtype display_name: str
        :keyword message: Recommendation text.
        :paramtype message: str
        :keyword level: Level indicating how critical this recommendation can impact. Possible values
         include: "Critical", "Warning", "Information", "NonUrgentSuggestion".
        :paramtype level: str or ~azure.mgmt.web.v2021_01_15.models.NotificationLevel
        :keyword channels: List of channels that this recommendation can apply. Possible values
         include: "Notification", "Api", "Email", "Webhook", "All".
        :paramtype channels: str or ~azure.mgmt.web.v2021_01_15.models.Channels
        :keyword action_name: Name of action recommended by this object.
        :paramtype action_name: str
        :keyword enabled: True if this recommendation is still valid (i.e. "actionable"). False if it
         is invalid.
        :paramtype enabled: int
        :keyword states: The list of states of this recommendation. If it's null then it should be
         considered "Active".
        :paramtype states: list[str]
        :keyword start_time: The beginning time in UTC of a range that the recommendation refers to.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time in UTC of a range that the recommendation refers to.
        :paramtype end_time: ~datetime.datetime
        :keyword next_notification_time: When to notify this recommendation next in UTC. Null means
         that this will never be notified anymore.
        :paramtype next_notification_time: ~datetime.datetime
        :keyword notification_expiration_time: Date and time in UTC when this notification expires.
        :paramtype notification_expiration_time: ~datetime.datetime
        :keyword notified_time: Last timestamp in UTC this instance was actually notified. Null means
         that this recommendation hasn't been notified yet.
        :paramtype notified_time: ~datetime.datetime
        :keyword score: A metric value measured by the rule.
        :paramtype score: float
        :keyword is_dynamic: True if this is associated with a dynamically added rule.
        :paramtype is_dynamic: bool
        :keyword extension_name: Extension name of the portal if exists.
        :paramtype extension_name: str
        :keyword blade_name: Deep link to a blade on the portal.
        :paramtype blade_name: str
        :keyword forward_link: Forward link to an external document associated with the rule.
        :paramtype forward_link: str
        """
        super(Recommendation, self).__init__(kind=kind, **kwargs)
        self.creation_time = creation_time
        self.recommendation_id = recommendation_id
        self.resource_id = resource_id
        self.resource_scope = resource_scope
        self.rule_name = rule_name
        self.display_name = display_name
        self.message = message
        self.level = level
        self.channels = channels
        self.category_tags = None
        self.action_name = action_name
        self.enabled = enabled
        self.states = states
        self.start_time = start_time
        self.end_time = end_time
        self.next_notification_time = next_notification_time
        self.notification_expiration_time = notification_expiration_time
        self.notified_time = notified_time
        self.score = score
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class RecommendationCollection(msrest.serialization.Model):
    """Collection of recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.Recommendation]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Recommendation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Recommendation"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.Recommendation]
        """
        super(RecommendationCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class RecommendationRule(ProxyOnlyResource):
    """Represents a recommendation rule that the recommendation engine can perform.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar recommendation_name: Unique name of the rule.
    :vartype recommendation_name: str
    :ivar display_name: UI friendly name of the rule.
    :vartype display_name: str
    :ivar message: Localized name of the rule (Good for UI).
    :vartype message: str
    :ivar recommendation_id: Recommendation ID of an associated recommendation object tied to the
     rule, if exists.
     If such an object doesn't exist, it is set to null.
    :vartype recommendation_id: str
    :ivar description: Localized detailed description of the rule.
    :vartype description: str
    :ivar action_name: Name of action that is recommended by this rule in string.
    :vartype action_name: str
    :ivar level: Level of impact indicating how critical this rule is. Possible values include:
     "Critical", "Warning", "Information", "NonUrgentSuggestion".
    :vartype level: str or ~azure.mgmt.web.v2021_01_15.models.NotificationLevel
    :ivar channels: List of available channels that this rule applies. Possible values include:
     "Notification", "Api", "Email", "Webhook", "All".
    :vartype channels: str or ~azure.mgmt.web.v2021_01_15.models.Channels
    :ivar category_tags: The list of category tags that this recommendation rule belongs to.
    :vartype category_tags: list[str]
    :ivar is_dynamic: True if this is associated with a dynamically added rule.
    :vartype is_dynamic: bool
    :ivar extension_name: Extension name of the portal if exists. Applicable to dynamic rule only.
    :vartype extension_name: str
    :ivar blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
    :vartype blade_name: str
    :ivar forward_link: Forward link to an external document associated with the rule. Applicable
     to dynamic rule only.
    :vartype forward_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category_tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'recommendation_name': {'key': 'properties.recommendationName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'recommendation_id': {'key': 'properties.recommendationId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'action_name': {'key': 'properties.actionName', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'channels': {'key': 'properties.channels', 'type': 'str'},
        'category_tags': {'key': 'properties.categoryTags', 'type': '[str]'},
        'is_dynamic': {'key': 'properties.isDynamic', 'type': 'bool'},
        'extension_name': {'key': 'properties.extensionName', 'type': 'str'},
        'blade_name': {'key': 'properties.bladeName', 'type': 'str'},
        'forward_link': {'key': 'properties.forwardLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        recommendation_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        recommendation_id: Optional[str] = None,
        description: Optional[str] = None,
        action_name: Optional[str] = None,
        level: Optional[Union[str, "NotificationLevel"]] = None,
        channels: Optional[Union[str, "Channels"]] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword recommendation_name: Unique name of the rule.
        :paramtype recommendation_name: str
        :keyword display_name: UI friendly name of the rule.
        :paramtype display_name: str
        :keyword message: Localized name of the rule (Good for UI).
        :paramtype message: str
        :keyword recommendation_id: Recommendation ID of an associated recommendation object tied to
         the rule, if exists.
         If such an object doesn't exist, it is set to null.
        :paramtype recommendation_id: str
        :keyword description: Localized detailed description of the rule.
        :paramtype description: str
        :keyword action_name: Name of action that is recommended by this rule in string.
        :paramtype action_name: str
        :keyword level: Level of impact indicating how critical this rule is. Possible values include:
         "Critical", "Warning", "Information", "NonUrgentSuggestion".
        :paramtype level: str or ~azure.mgmt.web.v2021_01_15.models.NotificationLevel
        :keyword channels: List of available channels that this rule applies. Possible values include:
         "Notification", "Api", "Email", "Webhook", "All".
        :paramtype channels: str or ~azure.mgmt.web.v2021_01_15.models.Channels
        :keyword is_dynamic: True if this is associated with a dynamically added rule.
        :paramtype is_dynamic: bool
        :keyword extension_name: Extension name of the portal if exists. Applicable to dynamic rule
         only.
        :paramtype extension_name: str
        :keyword blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
        :paramtype blade_name: str
        :keyword forward_link: Forward link to an external document associated with the rule.
         Applicable to dynamic rule only.
        :paramtype forward_link: str
        """
        super(RecommendationRule, self).__init__(kind=kind, **kwargs)
        self.recommendation_name = recommendation_name
        self.display_name = display_name
        self.message = message
        self.recommendation_id = recommendation_id
        self.description = description
        self.action_name = action_name
        self.level = level
        self.channels = channels
        self.category_tags = None
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after the
     new certificate is issued.
    :vartype delay_existing_revoke_in_hours: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'delay_existing_revoke_in_hours': {'key': 'properties.delayExistingRevokeInHours', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        delay_existing_revoke_in_hours: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after
         the new certificate is issued.
        :paramtype delay_existing_revoke_in_hours: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super(ReissueCertificateOrderRequest, self).__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.delay_existing_revoke_in_hours = delay_existing_revoke_in_hours
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RelayServiceConnectionEntity(ProxyOnlyResource):
    """Hybrid Connection for an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entity_name:
    :vartype entity_name: str
    :ivar entity_connection_string:
    :vartype entity_connection_string: str
    :ivar resource_type:
    :vartype resource_type: str
    :ivar resource_connection_string:
    :vartype resource_connection_string: str
    :ivar hostname:
    :vartype hostname: str
    :ivar port:
    :vartype port: int
    :ivar biztalk_uri:
    :vartype biztalk_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entity_name': {'key': 'properties.entityName', 'type': 'str'},
        'entity_connection_string': {'key': 'properties.entityConnectionString', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'resource_connection_string': {'key': 'properties.resourceConnectionString', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'biztalk_uri': {'key': 'properties.biztalkUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        entity_name: Optional[str] = None,
        entity_connection_string: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_connection_string: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        biztalk_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword entity_name:
        :paramtype entity_name: str
        :keyword entity_connection_string:
        :paramtype entity_connection_string: str
        :keyword resource_type:
        :paramtype resource_type: str
        :keyword resource_connection_string:
        :paramtype resource_connection_string: str
        :keyword hostname:
        :paramtype hostname: str
        :keyword port:
        :paramtype port: int
        :keyword biztalk_uri:
        :paramtype biztalk_uri: str
        """
        super(RelayServiceConnectionEntity, self).__init__(kind=kind, **kwargs)
        self.entity_name = entity_name
        self.entity_connection_string = entity_connection_string
        self.resource_type = resource_type
        self.resource_connection_string = resource_connection_string
        self.hostname = hostname
        self.port = port
        self.biztalk_uri = biztalk_uri


class RemotePrivateEndpointConnection(ProxyOnlyResource):
    """A remote private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :ivar private_endpoint: PrivateEndpoint of a remote private endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.web.v2021_01_15.models.ArmIdWrapper
    :ivar private_link_service_connection_state: The state of a private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.web.v2021_01_15.models.PrivateLinkConnectionState
    :ivar ip_addresses: Private IPAddresses mapped to the remote private endpoint.
    :vartype ip_addresses: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'ArmIdWrapper'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
        'ip_addresses': {'key': 'properties.ipAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_endpoint: Optional["ArmIdWrapper"] = None,
        private_link_service_connection_state: Optional["PrivateLinkConnectionState"] = None,
        ip_addresses: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword private_endpoint: PrivateEndpoint of a remote private endpoint connection.
        :paramtype private_endpoint: ~azure.mgmt.web.v2021_01_15.models.ArmIdWrapper
        :keyword private_link_service_connection_state: The state of a private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.web.v2021_01_15.models.PrivateLinkConnectionState
        :keyword ip_addresses: Private IPAddresses mapped to the remote private endpoint.
        :paramtype ip_addresses: list[str]
        """
        super(RemotePrivateEndpointConnection, self).__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.ip_addresses = ip_addresses


class RemotePrivateEndpointConnectionARMResource(ProxyOnlyResource):
    """Remote Private Endpoint Connection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :ivar private_endpoint: PrivateEndpoint of a remote private endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.web.v2021_01_15.models.ArmIdWrapper
    :ivar private_link_service_connection_state: The state of a private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.web.v2021_01_15.models.PrivateLinkConnectionState
    :ivar ip_addresses: Private IPAddresses mapped to the remote private endpoint.
    :vartype ip_addresses: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'ArmIdWrapper'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
        'ip_addresses': {'key': 'properties.ipAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_endpoint: Optional["ArmIdWrapper"] = None,
        private_link_service_connection_state: Optional["PrivateLinkConnectionState"] = None,
        ip_addresses: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword private_endpoint: PrivateEndpoint of a remote private endpoint connection.
        :paramtype private_endpoint: ~azure.mgmt.web.v2021_01_15.models.ArmIdWrapper
        :keyword private_link_service_connection_state: The state of a private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.web.v2021_01_15.models.PrivateLinkConnectionState
        :keyword ip_addresses: Private IPAddresses mapped to the remote private endpoint.
        :paramtype ip_addresses: list[str]
        """
        super(RemotePrivateEndpointConnectionARMResource, self).__init__(kind=kind, **kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.ip_addresses = ip_addresses


class Rendering(msrest.serialization.Model):
    """Instructions for rendering the data.

    :ivar type: Rendering Type. Possible values include: "NoGraph", "Table", "TimeSeries",
     "TimeSeriesPerInstance", "PieChart", "DataSummary", "Email", "Insights", "DynamicInsight",
     "Markdown", "Detector", "DropDown", "Card", "Solution", "Guage", "Form", "ChangeSets",
     "ChangeAnalysisOnboarding", "ChangesView", "AppInsight", "DependencyGraph", "DownTime",
     "SummaryCard", "SearchComponent", "AppInsightEnablement".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.RenderingType
    :ivar title: Title of data.
    :vartype title: str
    :ivar description: Description of the data that will help it be interpreted.
    :vartype description: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "RenderingType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Rendering Type. Possible values include: "NoGraph", "Table", "TimeSeries",
         "TimeSeriesPerInstance", "PieChart", "DataSummary", "Email", "Insights", "DynamicInsight",
         "Markdown", "Detector", "DropDown", "Card", "Solution", "Guage", "Form", "ChangeSets",
         "ChangeAnalysisOnboarding", "ChangesView", "AppInsight", "DependencyGraph", "DownTime",
         "SummaryCard", "SearchComponent", "AppInsightEnablement".
        :paramtype type: str or ~azure.mgmt.web.v2021_01_15.models.RenderingType
        :keyword title: Title of data.
        :paramtype title: str
        :keyword description: Description of the data that will help it be interpreted.
        :paramtype description: str
        """
        super(Rendering, self).__init__(**kwargs)
        self.type = type
        self.title = title
        self.description = description


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super(RenewCertificateOrderRequest, self).__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on total requests.

    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super(RequestsBasedTrigger, self).__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceCollection(msrest.serialization.Model):
    """Collection of resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[str]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List[str],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[str]
        """
        super(ResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceHealthMetadata(ProxyOnlyResource):
    """Used for getting ResourceHealthCheck settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar category: The category that the resource matches in the RHC Policy File.
    :vartype category: str
    :ivar signal_availability: Is there a health signal for the resource.
    :vartype signal_availability: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'signal_availability': {'key': 'properties.signalAvailability', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        category: Optional[str] = None,
        signal_availability: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword category: The category that the resource matches in the RHC Policy File.
        :paramtype category: str
        :keyword signal_availability: Is there a health signal for the resource.
        :paramtype signal_availability: bool
        """
        super(ResourceHealthMetadata, self).__init__(kind=kind, **kwargs)
        self.category = category
        self.signal_availability = signal_availability


class ResourceHealthMetadataCollection(msrest.serialization.Model):
    """Collection of resource health metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.ResourceHealthMetadata]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceHealthMetadata]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ResourceHealthMetadata"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.ResourceHealthMetadata]
        """
        super(ResourceHealthMetadataCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricAvailability(msrest.serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceMetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2021_01_15.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'resource_uri': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[ResourceMetricAvailability]'},
        'resource_uri': {'key': 'properties.resourceUri', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(ResourceMetricDefinition, self).__init__(kind=kind, **kwargs)
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.properties = None


class ResourceMetricDefinitionCollection(msrest.serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetricDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ResourceMetricDefinition"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.ResourceMetricDefinition]
        """
        super(ResourceMetricDefinitionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceNameAvailability(msrest.serialization.Model):
    """Information regarding availability of a resource name.

    :ivar name_available: :code:`<code>true</code>` indicates name is valid and available.
     :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
    :vartype name_available: bool
    :ivar reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure App
     Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
     already in use and is therefore unavailable. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.web.v2021_01_15.models.InAvailabilityReasonType
    :ivar message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :vartype message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "InAvailabilityReasonType"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name_available: :code:`<code>true</code>` indicates name is valid and available.
         :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
        :paramtype name_available: bool
        :keyword reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure
         App Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
         already in use and is therefore unavailable. Possible values include: "Invalid",
         "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.web.v2021_01_15.models.InAvailabilityReasonType
        :keyword message: If reason == invalid, provide the user with the reason why the given name is
         invalid, and provide the resource naming requirements so that the user can select a valid name.
         If reason == AlreadyExists, explain that resource name is already in use, and direct them to
         select a different name.
        :paramtype message: str
        """
        super(ResourceNameAvailability, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class ResourceNameAvailabilityRequest(msrest.serialization.Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Resource name to verify.
    :vartype name: str
    :ivar type: Required. Resource type used for verification. Possible values include: "Site",
     "Slot", "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites",
     "Microsoft.Web/sites/slots", "Microsoft.Web/hostingEnvironments",
     "Microsoft.Web/publishingUsers".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.CheckNameResourceTypes
    :ivar is_fqdn: Is fully qualified domain name.
    :vartype is_fqdn: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_fqdn': {'key': 'isFqdn', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "CheckNameResourceTypes"],
        is_fqdn: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Required. Resource name to verify.
        :paramtype name: str
        :keyword type: Required. Resource type used for verification. Possible values include: "Site",
         "Slot", "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites",
         "Microsoft.Web/sites/slots", "Microsoft.Web/hostingEnvironments",
         "Microsoft.Web/publishingUsers".
        :paramtype type: str or ~azure.mgmt.web.v2021_01_15.models.CheckNameResourceTypes
        :keyword is_fqdn: Is fully qualified domain name.
        :paramtype is_fqdn: bool
        """
        super(ResourceNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.is_fqdn = is_fqdn


class ResponseMessageEnvelopeRemotePrivateEndpointConnection(msrest.serialization.Model):
    """Message envelope that contains the common Azure resource manager properties and the resource provider specific content.

    :ivar id: Resource Id. Typically ID is populated only for responses to GET requests. Caller is
     responsible for passing in this
     value for GET requests only.
     For example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}.
    :vartype id: str
    :ivar name: Name of resource.
    :vartype name: str
    :ivar type: Type of resource e.g "Microsoft.Web/sites".
    :vartype type: str
    :ivar location: Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
    :vartype location: str
    :ivar tags: A set of tags. Tags associated with resource.
    :vartype tags: dict[str, str]
    :ivar plan: Azure resource manager plan.
    :vartype plan: ~azure.mgmt.web.v2021_01_15.models.ArmPlan
    :ivar properties: Resource specific properties.
    :vartype properties: ~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnection
    :ivar sku: SKU description of the resource.
    :vartype sku: ~azure.mgmt.web.v2021_01_15.models.SkuDescription
    :ivar status: Azure-AsyncOperation Status info.
    :vartype status: str
    :ivar error: Azure-AsyncOperation Error info.
    :vartype error: ~azure.mgmt.web.v2021_01_15.models.ErrorEntity
    :ivar identity: MSI resource.
    :vartype identity: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
    :ivar zones: Logical Availability Zones the service is hosted in.
    :vartype zones: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'ArmPlan'},
        'properties': {'key': 'properties', 'type': 'RemotePrivateEndpointConnection'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorEntity'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["ArmPlan"] = None,
        properties: Optional["RemotePrivateEndpointConnection"] = None,
        sku: Optional["SkuDescription"] = None,
        status: Optional[str] = None,
        error: Optional["ErrorEntity"] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        zones: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource Id. Typically ID is populated only for responses to GET requests. Caller
         is responsible for passing in this
         value for GET requests only.
         For example:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}.
        :paramtype id: str
        :keyword name: Name of resource.
        :paramtype name: str
        :keyword type: Type of resource e.g "Microsoft.Web/sites".
        :paramtype type: str
        :keyword location: Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
        :paramtype location: str
        :keyword tags: A set of tags. Tags associated with resource.
        :paramtype tags: dict[str, str]
        :keyword plan: Azure resource manager plan.
        :paramtype plan: ~azure.mgmt.web.v2021_01_15.models.ArmPlan
        :keyword properties: Resource specific properties.
        :paramtype properties: ~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnection
        :keyword sku: SKU description of the resource.
        :paramtype sku: ~azure.mgmt.web.v2021_01_15.models.SkuDescription
        :keyword status: Azure-AsyncOperation Status info.
        :paramtype status: str
        :keyword error: Azure-AsyncOperation Error info.
        :paramtype error: ~azure.mgmt.web.v2021_01_15.models.ErrorEntity
        :keyword identity: MSI resource.
        :paramtype identity: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
        :keyword zones: Logical Availability Zones the service is hosted in.
        :paramtype zones: list[str]
        """
        super(ResponseMessageEnvelopeRemotePrivateEndpointConnection, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.tags = tags
        self.plan = plan
        self.properties = properties
        self.sku = sku
        self.status = status
        self.error = error
        self.identity = identity
        self.zones = zones


class ResponseMetaData(msrest.serialization.Model):
    """ResponseMetaData.

    :ivar data_source: Source of the Data.
    :vartype data_source: ~azure.mgmt.web.v2021_01_15.models.DataSource
    """

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'DataSource'},
    }

    def __init__(
        self,
        *,
        data_source: Optional["DataSource"] = None,
        **kwargs
    ):
        """
        :keyword data_source: Source of the Data.
        :paramtype data_source: ~azure.mgmt.web.v2021_01_15.models.DataSource
        """
        super(ResponseMetaData, self).__init__(**kwargs)
        self.data_source = data_source


class RestoreRequest(ProxyOnlyResource):
    """Description of a restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar storage_account_url: SAS URL to the container.
    :vartype storage_account_url: str
    :ivar blob_name: Name of a blob which contains the backup.
    :vartype blob_name: str
    :ivar overwrite: :code:`<code>true</code>` if the restore operation can overwrite target app;
     otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to restore
     over an existing app.
    :vartype overwrite: bool
    :ivar site_name: Name of an app.
    :vartype site_name: str
    :ivar databases: Collection of databases which should be restored. This list has to match the
     list of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2021_01_15.models.DatabaseBackupSetting]
    :ivar ignore_conflicting_host_names: Changes a logic when restoring an app with custom domains.
     :code:`<code>true</code>` to remove custom domains automatically. If
     :code:`<code>false</code>`, custom domains are added to
     the app's object when it is being restored, but that might fail due to conflicts during the
     operation.
    :vartype ignore_conflicting_host_names: bool
    :ivar ignore_databases: Ignore the databases and only restore the site content.
    :vartype ignore_databases: bool
    :ivar app_service_plan: Specify app service plan that will own restored site.
    :vartype app_service_plan: str
    :ivar operation_type: Operation type. Possible values include: "Default", "Clone",
     "Relocation", "Snapshot", "CloudFS". Default value: "Default".
    :vartype operation_type: str or ~azure.mgmt.web.v2021_01_15.models.BackupRestoreOperationType
    :ivar adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
     should be set in new app; otherwise, :code:`<code>false</code>`.
    :vartype adjust_connection_strings: bool
    :ivar hosting_environment: App Service Environment name, if needed (only when restoring an app
     to an App Service Environment).
    :vartype hosting_environment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'ignore_databases': {'key': 'properties.ignoreDatabases', 'type': 'bool'},
        'app_service_plan': {'key': 'properties.appServicePlan', 'type': 'str'},
        'operation_type': {'key': 'properties.operationType', 'type': 'str'},
        'adjust_connection_strings': {'key': 'properties.adjustConnectionStrings', 'type': 'bool'},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        storage_account_url: Optional[str] = None,
        blob_name: Optional[str] = None,
        overwrite: Optional[bool] = None,
        site_name: Optional[str] = None,
        databases: Optional[List["DatabaseBackupSetting"]] = None,
        ignore_conflicting_host_names: Optional[bool] = False,
        ignore_databases: Optional[bool] = False,
        app_service_plan: Optional[str] = None,
        operation_type: Optional[Union[str, "BackupRestoreOperationType"]] = "Default",
        adjust_connection_strings: Optional[bool] = None,
        hosting_environment: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword storage_account_url: SAS URL to the container.
        :paramtype storage_account_url: str
        :keyword blob_name: Name of a blob which contains the backup.
        :paramtype blob_name: str
        :keyword overwrite: :code:`<code>true</code>` if the restore operation can overwrite target
         app; otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to
         restore over an existing app.
        :paramtype overwrite: bool
        :keyword site_name: Name of an app.
        :paramtype site_name: str
        :keyword databases: Collection of databases which should be restored. This list has to match
         the list of databases included in the backup.
        :paramtype databases: list[~azure.mgmt.web.v2021_01_15.models.DatabaseBackupSetting]
        :keyword ignore_conflicting_host_names: Changes a logic when restoring an app with custom
         domains. :code:`<code>true</code>` to remove custom domains automatically. If
         :code:`<code>false</code>`, custom domains are added to
         the app's object when it is being restored, but that might fail due to conflicts during the
         operation.
        :paramtype ignore_conflicting_host_names: bool
        :keyword ignore_databases: Ignore the databases and only restore the site content.
        :paramtype ignore_databases: bool
        :keyword app_service_plan: Specify app service plan that will own restored site.
        :paramtype app_service_plan: str
        :keyword operation_type: Operation type. Possible values include: "Default", "Clone",
         "Relocation", "Snapshot", "CloudFS". Default value: "Default".
        :paramtype operation_type: str or ~azure.mgmt.web.v2021_01_15.models.BackupRestoreOperationType
        :keyword adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
         should be set in new app; otherwise, :code:`<code>false</code>`.
        :paramtype adjust_connection_strings: bool
        :keyword hosting_environment: App Service Environment name, if needed (only when restoring an
         app to an App Service Environment).
        :paramtype hosting_environment: str
        """
        super(RestoreRequest, self).__init__(kind=kind, **kwargs)
        self.storage_account_url = storage_account_url
        self.blob_name = blob_name
        self.overwrite = overwrite
        self.site_name = site_name
        self.databases = databases
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.ignore_databases = ignore_databases
        self.app_service_plan = app_service_plan
        self.operation_type = operation_type
        self.adjust_connection_strings = adjust_connection_strings
        self.hosting_environment = hosting_environment


class SampleUtterance(msrest.serialization.Model):
    """Sample utterance.

    :ivar text: Text attribute of sample utterance.
    :vartype text: str
    :ivar links: Links attribute of sample utterance.
    :vartype links: list[str]
    :ivar qid: Question id of sample utterance (for stackoverflow questions titles).
    :vartype qid: str
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'links': {'key': 'links', 'type': '[str]'},
        'qid': {'key': 'qid', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        links: Optional[List[str]] = None,
        qid: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword text: Text attribute of sample utterance.
        :paramtype text: str
        :keyword links: Links attribute of sample utterance.
        :paramtype links: list[str]
        :keyword qid: Question id of sample utterance (for stackoverflow questions titles).
        :paramtype qid: str
        """
        super(SampleUtterance, self).__init__(**kwargs)
        self.text = text
        self.links = links
        self.qid = qid


class ServiceSpecification(msrest.serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :ivar metric_specifications:
    :vartype metric_specifications: list[~azure.mgmt.web.v2021_01_15.models.MetricSpecification]
    :ivar log_specifications:
    :vartype log_specifications: list[~azure.mgmt.web.v2021_01_15.models.LogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["MetricSpecification"]] = None,
        log_specifications: Optional[List["LogSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword metric_specifications:
        :paramtype metric_specifications: list[~azure.mgmt.web.v2021_01_15.models.MetricSpecification]
        :keyword log_specifications:
        :paramtype log_specifications: list[~azure.mgmt.web.v2021_01_15.models.LogSpecification]
        """
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
    :ivar extended_location: Extended Location.
    :vartype extended_location: ~azure.mgmt.web.v2021_01_15.models.ExtendedLocation
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2021_01_15.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2021_01_15.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2021_01_15.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: Hyper-V sandbox.
    :vartype is_xenon: bool
    :ivar hyper_v: Hyper-V sandbox.
    :vartype hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2021_01_15.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar client_cert_mode: This composes with ClientCertEnabled setting.
    
    
     * ClientCertEnabled: false means ClientCert is ignored.
     * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
     accepted. Possible values include: "Required", "Optional", "OptionalInteractiveUser".
    :vartype client_cert_mode: str or ~azure.mgmt.web.v2021_01_15.models.ClientCertMode
    :ivar client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :vartype client_cert_exclusion_paths: str
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar custom_domain_verification_id: Unique identifier that verifies the custom domains
     assigned to the app. Customer will add this id to a txt record for verification.
    :vartype custom_domain_verification_id: str
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2021_01_15.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2021_01_15.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    :ivar redundancy_mode: Site redundancy mode. Possible values include: "None", "Manual",
     "Failover", "ActiveActive", "GeoRedundant".
    :vartype redundancy_mode: str or ~azure.mgmt.web.v2021_01_15.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :ivar storage_account_required: Checks if Customer provided storage account is required.
    :vartype storage_account_required: bool
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet to
     be joined by Regional VNET Integration.
     This must be of the form
     /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :vartype virtual_network_subnet_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
        'in_progress_operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'client_cert_mode': {'key': 'properties.clientCertMode', 'type': 'str'},
        'client_cert_exclusion_paths': {'key': 'properties.clientCertExclusionPaths', 'type': 'str'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'custom_domain_verification_id': {'key': 'properties.customDomainVerificationId', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
        'redundancy_mode': {'key': 'properties.redundancyMode', 'type': 'str'},
        'in_progress_operation_id': {'key': 'properties.inProgressOperationId', 'type': 'str'},
        'storage_account_required': {'key': 'properties.storageAccountRequired', 'type': 'bool'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: Optional[bool] = False,
        is_xenon: Optional[bool] = False,
        hyper_v: Optional[bool] = False,
        site_config: Optional["SiteConfig"] = None,
        scm_site_also_stopped: Optional[bool] = False,
        hosting_environment_profile: Optional["HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_mode: Optional[Union[str, "ClientCertMode"]] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        host_names_disabled: Optional[bool] = None,
        custom_domain_verification_id: Optional[str] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "RedundancyMode"]] = None,
        storage_account_required: Optional[bool] = None,
        key_vault_reference_identity: Optional[str] = None,
        virtual_network_subnet_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
        :keyword extended_location: Extended Location.
        :paramtype extended_location: ~azure.mgmt.web.v2021_01_15.models.ExtendedLocation
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2021_01_15.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: Hyper-V sandbox.
        :paramtype is_xenon: bool
        :keyword hyper_v: Hyper-V sandbox.
        :paramtype hyper_v: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2021_01_15.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword client_cert_mode: This composes with ClientCertEnabled setting.
        
        
         * ClientCertEnabled: false means ClientCert is ignored.
         * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
         * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
         accepted. Possible values include: "Required", "Optional", "OptionalInteractiveUser".
        :paramtype client_cert_mode: str or ~azure.mgmt.web.v2021_01_15.models.ClientCertMode
        :keyword client_cert_exclusion_paths: client certificate authentication comma-separated
         exclusion paths.
        :paramtype client_cert_exclusion_paths: str
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword custom_domain_verification_id: Unique identifier that verifies the custom domains
         assigned to the app. Customer will add this id to a txt record for verification.
        :paramtype custom_domain_verification_id: str
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2021_01_15.models.CloningInfo
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        :keyword redundancy_mode: Site redundancy mode. Possible values include: "None", "Manual",
         "Failover", "ActiveActive", "GeoRedundant".
        :paramtype redundancy_mode: str or ~azure.mgmt.web.v2021_01_15.models.RedundancyMode
        :keyword storage_account_required: Checks if Customer provided storage account is required.
        :paramtype storage_account_required: bool
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet
         to be joined by Regional VNET Integration.
         This must be of the form
         /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :paramtype virtual_network_subnet_id: str
        """
        super(Site, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.extended_location = extended_location
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_mode = client_cert_mode
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.host_names_disabled = host_names_disabled
        self.custom_domain_verification_id = custom_domain_verification_id
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id = None
        self.storage_account_required = storage_account_required
        self.key_vault_reference_identity = key_vault_reference_identity
        self.virtual_network_subnet_id = virtual_network_subnet_id


class SiteAuthSettings(ProxyOnlyResource):
    """Configuration settings for the Azure App Service Authentication / Authorization feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :vartype runtime_version: str
    :ivar unauthenticated_client_action: The action to take when an unauthenticated client attempts
     to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous".
    :vartype unauthenticated_client_action: str or
     ~azure.mgmt.web.v2021_01_15.models.UnauthenticatedClientAction
    :ivar token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
     security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :vartype token_store_enabled: bool
    :ivar allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :vartype allowed_external_redirect_urls: list[str]
    :ivar default_provider: The default authentication provider to use when multiple providers are
     configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage". Possible values include: "AzureActiveDirectory",
     "Facebook", "Google", "MicrosoftAccount", "Twitter", "Github".
    :vartype default_provider: str or
     ~azure.mgmt.web.v2021_01_15.models.BuiltInAuthenticationProvider
    :ivar token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :vartype token_refresh_extension_hours: float
    :ivar client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_id: str
    :ivar client_secret: The Client Secret of this relying party application (in Azure Active
     Directory, this is also referred to as the Key).
     This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
     flow is used to authenticate end users.
     Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_secret: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret of the
     relying party application.
    :vartype client_secret_setting_name: str
    :ivar client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :vartype client_secret_certificate_thumbprint: str
    :ivar issuer: The OpenID Connect Issuer URI that represents the entity which issues access
     tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://sts.windows.net/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :vartype issuer: str
    :ivar validate_issuer: Gets a value indicating whether the issuer should be a valid HTTPS url
     and be validated as such.
    :vartype validate_issuer: bool
    :ivar allowed_audiences: Allowed audience values to consider when validating JWTs issued by
     Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
     an
     allowed audience, regardless of this setting.
    :vartype allowed_audiences: list[str]
    :ivar additional_login_params: Login parameters to send to the OpenID Connect authorization
     endpoint when
     a user logs in. Each parameter must be in the form "key=value".
    :vartype additional_login_params: list[str]
    :ivar aad_claims_authorization: Gets a JSON string containing the Azure AD Acl settings.
    :vartype aad_claims_authorization: str
    :ivar google_client_id: The OpenID Connect Client ID for the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_client_id: str
    :ivar google_client_secret: The client secret associated with the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_client_secret: str
    :ivar google_client_secret_setting_name: The app setting name that contains the client secret
     associated with
     the Google web application.
    :vartype google_client_secret_setting_name: str
    :ivar google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
     Sign-In authentication.
     This setting is optional. If not specified, "openid", "profile", and "email" are used as
     default scopes.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_o_auth_scopes: list[str]
    :ivar facebook_app_id: The App ID of the Facebook app used for login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_app_id: str
    :ivar facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_app_secret: str
    :ivar facebook_app_secret_setting_name: The app setting name that contains the app secret used
     for Facebook Login.
    :vartype facebook_app_secret_setting_name: str
    :ivar facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Facebook
     Login authentication.
     This setting is optional.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_o_auth_scopes: list[str]
    :ivar git_hub_client_id: The Client Id of the GitHub app used for login.
     This setting is required for enabling Github login.
    :vartype git_hub_client_id: str
    :ivar git_hub_client_secret: The Client Secret of the GitHub app used for Github Login.
     This setting is required for enabling Github login.
    :vartype git_hub_client_secret: str
    :ivar git_hub_client_secret_setting_name: The app setting name that contains the client secret
     of the Github
     app used for GitHub Login.
    :vartype git_hub_client_secret_setting_name: str
    :ivar git_hub_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of GitHub
     Login authentication.
     This setting is optional.
    :vartype git_hub_o_auth_scopes: list[str]
    :ivar twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
     sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype twitter_consumer_key: str
    :ivar twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application used
     for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype twitter_consumer_secret: str
    :ivar twitter_consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a
     consumer secret of the Twitter
     application used for sign-in.
    :vartype twitter_consumer_secret_setting_name: str
    :ivar microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
     for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :vartype microsoft_account_client_id: str
    :ivar microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the app
     used for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :vartype microsoft_account_client_secret: str
    :ivar microsoft_account_client_secret_setting_name: The app setting name containing the OAuth
     2.0 client secret that was created for the
     app used for authentication.
    :vartype microsoft_account_client_secret_setting_name: str
    :ivar microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
     Microsoft Account authentication.
     This setting is optional. If not specified, "wl.basic" is used as the default scope.
     Microsoft Account Scopes and permissions documentation:
     https://msdn.microsoft.com/en-us/library/dn631845.aspx.
    :vartype microsoft_account_o_auth_scopes: list[str]
    :ivar is_auth_from_file: "true" if the auth config settings should be read from a file,
     "false" otherwise.
    :vartype is_auth_from_file: str
    :ivar auth_file_path: The path of the config file containing auth settings.
     If the path is relative, base will the site's root directory.
    :vartype auth_file_path: str
    :ivar config_version: The ConfigVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of the control plane for Authentication /
     Authorization.
    :vartype config_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'runtime_version': {'key': 'properties.runtimeVersion', 'type': 'str'},
        'unauthenticated_client_action': {'key': 'properties.unauthenticatedClientAction', 'type': 'str'},
        'token_store_enabled': {'key': 'properties.tokenStoreEnabled', 'type': 'bool'},
        'allowed_external_redirect_urls': {'key': 'properties.allowedExternalRedirectUrls', 'type': '[str]'},
        'default_provider': {'key': 'properties.defaultProvider', 'type': 'str'},
        'token_refresh_extension_hours': {'key': 'properties.tokenRefreshExtensionHours', 'type': 'float'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
        'client_secret_setting_name': {'key': 'properties.clientSecretSettingName', 'type': 'str'},
        'client_secret_certificate_thumbprint': {'key': 'properties.clientSecretCertificateThumbprint', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'validate_issuer': {'key': 'properties.validateIssuer', 'type': 'bool'},
        'allowed_audiences': {'key': 'properties.allowedAudiences', 'type': '[str]'},
        'additional_login_params': {'key': 'properties.additionalLoginParams', 'type': '[str]'},
        'aad_claims_authorization': {'key': 'properties.aadClaimsAuthorization', 'type': 'str'},
        'google_client_id': {'key': 'properties.googleClientId', 'type': 'str'},
        'google_client_secret': {'key': 'properties.googleClientSecret', 'type': 'str'},
        'google_client_secret_setting_name': {'key': 'properties.googleClientSecretSettingName', 'type': 'str'},
        'google_o_auth_scopes': {'key': 'properties.googleOAuthScopes', 'type': '[str]'},
        'facebook_app_id': {'key': 'properties.facebookAppId', 'type': 'str'},
        'facebook_app_secret': {'key': 'properties.facebookAppSecret', 'type': 'str'},
        'facebook_app_secret_setting_name': {'key': 'properties.facebookAppSecretSettingName', 'type': 'str'},
        'facebook_o_auth_scopes': {'key': 'properties.facebookOAuthScopes', 'type': '[str]'},
        'git_hub_client_id': {'key': 'properties.gitHubClientId', 'type': 'str'},
        'git_hub_client_secret': {'key': 'properties.gitHubClientSecret', 'type': 'str'},
        'git_hub_client_secret_setting_name': {'key': 'properties.gitHubClientSecretSettingName', 'type': 'str'},
        'git_hub_o_auth_scopes': {'key': 'properties.gitHubOAuthScopes', 'type': '[str]'},
        'twitter_consumer_key': {'key': 'properties.twitterConsumerKey', 'type': 'str'},
        'twitter_consumer_secret': {'key': 'properties.twitterConsumerSecret', 'type': 'str'},
        'twitter_consumer_secret_setting_name': {'key': 'properties.twitterConsumerSecretSettingName', 'type': 'str'},
        'microsoft_account_client_id': {'key': 'properties.microsoftAccountClientId', 'type': 'str'},
        'microsoft_account_client_secret': {'key': 'properties.microsoftAccountClientSecret', 'type': 'str'},
        'microsoft_account_client_secret_setting_name': {'key': 'properties.microsoftAccountClientSecretSettingName', 'type': 'str'},
        'microsoft_account_o_auth_scopes': {'key': 'properties.microsoftAccountOAuthScopes', 'type': '[str]'},
        'is_auth_from_file': {'key': 'properties.isAuthFromFile', 'type': 'str'},
        'auth_file_path': {'key': 'properties.authFilePath', 'type': 'str'},
        'config_version': {'key': 'properties.configVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        runtime_version: Optional[str] = None,
        unauthenticated_client_action: Optional[Union[str, "UnauthenticatedClientAction"]] = None,
        token_store_enabled: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        default_provider: Optional[Union[str, "BuiltInAuthenticationProvider"]] = None,
        token_refresh_extension_hours: Optional[float] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        client_secret_certificate_thumbprint: Optional[str] = None,
        issuer: Optional[str] = None,
        validate_issuer: Optional[bool] = None,
        allowed_audiences: Optional[List[str]] = None,
        additional_login_params: Optional[List[str]] = None,
        aad_claims_authorization: Optional[str] = None,
        google_client_id: Optional[str] = None,
        google_client_secret: Optional[str] = None,
        google_client_secret_setting_name: Optional[str] = None,
        google_o_auth_scopes: Optional[List[str]] = None,
        facebook_app_id: Optional[str] = None,
        facebook_app_secret: Optional[str] = None,
        facebook_app_secret_setting_name: Optional[str] = None,
        facebook_o_auth_scopes: Optional[List[str]] = None,
        git_hub_client_id: Optional[str] = None,
        git_hub_client_secret: Optional[str] = None,
        git_hub_client_secret_setting_name: Optional[str] = None,
        git_hub_o_auth_scopes: Optional[List[str]] = None,
        twitter_consumer_key: Optional[str] = None,
        twitter_consumer_secret: Optional[str] = None,
        twitter_consumer_secret_setting_name: Optional[str] = None,
        microsoft_account_client_id: Optional[str] = None,
        microsoft_account_client_secret: Optional[str] = None,
        microsoft_account_client_secret_setting_name: Optional[str] = None,
        microsoft_account_o_auth_scopes: Optional[List[str]] = None,
        is_auth_from_file: Optional[str] = None,
        auth_file_path: Optional[str] = None,
        config_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
         enabled for the current app; otherwise, :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword runtime_version: The RuntimeVersion of the Authentication / Authorization feature in
         use for the current app.
         The setting in this value can control the behavior of certain features in the Authentication /
         Authorization module.
        :paramtype runtime_version: str
        :keyword unauthenticated_client_action: The action to take when an unauthenticated client
         attempts to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous".
        :paramtype unauthenticated_client_action: str or
         ~azure.mgmt.web.v2021_01_15.models.UnauthenticatedClientAction
        :keyword token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
         security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
          The default is :code:`<code>false</code>`.
        :paramtype token_store_enabled: bool
        :keyword allowed_external_redirect_urls: External URLs that can be redirected to as part of
         logging in or logging out of the app. Note that the query string part of the URL is ignored.
         This is an advanced setting typically only needed by Windows Store application backends.
         Note that URLs within the current domain are always implicitly allowed.
        :paramtype allowed_external_redirect_urls: list[str]
        :keyword default_provider: The default authentication provider to use when multiple providers
         are configured.
         This setting is only needed if multiple providers are configured and the unauthenticated
         client
         action is set to "RedirectToLoginPage". Possible values include: "AzureActiveDirectory",
         "Facebook", "Google", "MicrosoftAccount", "Twitter", "Github".
        :paramtype default_provider: str or
         ~azure.mgmt.web.v2021_01_15.models.BuiltInAuthenticationProvider
        :keyword token_refresh_extension_hours: The number of hours after session token expiration that
         a session token can be used to
         call the token refresh API. The default is 72 hours.
        :paramtype token_refresh_extension_hours: float
        :keyword client_id: The Client ID of this relying party application, known as the client_id.
         This setting is required for enabling OpenID Connection authentication with Azure Active
         Directory or
         other 3rd party OpenID Connect providers.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_id: str
        :keyword client_secret: The Client Secret of this relying party application (in Azure Active
         Directory, this is also referred to as the Key).
         This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
         flow is used to authenticate end users.
         Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_secret: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret of
         the relying party application.
        :paramtype client_secret_setting_name: str
        :keyword client_secret_certificate_thumbprint: An alternative to the client secret, that is the
         thumbprint of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret. It is also optional.
        :paramtype client_secret_certificate_thumbprint: str
        :keyword issuer: The OpenID Connect Issuer URI that represents the entity which issues access
         tokens for this application.
         When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
         https://sts.windows.net/{tenant-guid}/.
         This URI is a case-sensitive identifier for the token issuer.
         More information on OpenID Connect Discovery:
         http://openid.net/specs/openid-connect-discovery-1_0.html.
        :paramtype issuer: str
        :keyword validate_issuer: Gets a value indicating whether the issuer should be a valid HTTPS
         url and be validated as such.
        :paramtype validate_issuer: bool
        :keyword allowed_audiences: Allowed audience values to consider when validating JWTs issued by
         Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
         an
         allowed audience, regardless of this setting.
        :paramtype allowed_audiences: list[str]
        :keyword additional_login_params: Login parameters to send to the OpenID Connect authorization
         endpoint when
         a user logs in. Each parameter must be in the form "key=value".
        :paramtype additional_login_params: list[str]
        :keyword aad_claims_authorization: Gets a JSON string containing the Azure AD Acl settings.
        :paramtype aad_claims_authorization: str
        :keyword google_client_id: The OpenID Connect Client ID for the Google web application.
         This setting is required for enabling Google Sign-In.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_client_id: str
        :keyword google_client_secret: The client secret associated with the Google web application.
         This setting is required for enabling Google Sign-In.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_client_secret: str
        :keyword google_client_secret_setting_name: The app setting name that contains the client
         secret associated with
         the Google web application.
        :paramtype google_client_secret_setting_name: str
        :keyword google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
         Sign-In authentication.
         This setting is optional. If not specified, "openid", "profile", and "email" are used as
         default scopes.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_o_auth_scopes: list[str]
        :keyword facebook_app_id: The App ID of the Facebook app used for login.
         This setting is required for enabling Facebook Login.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_app_id: str
        :keyword facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
         This setting is required for enabling Facebook Login.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_app_secret: str
        :keyword facebook_app_secret_setting_name: The app setting name that contains the app secret
         used for Facebook Login.
        :paramtype facebook_app_secret_setting_name: str
        :keyword facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
         Facebook Login authentication.
         This setting is optional.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_o_auth_scopes: list[str]
        :keyword git_hub_client_id: The Client Id of the GitHub app used for login.
         This setting is required for enabling Github login.
        :paramtype git_hub_client_id: str
        :keyword git_hub_client_secret: The Client Secret of the GitHub app used for Github Login.
         This setting is required for enabling Github login.
        :paramtype git_hub_client_secret: str
        :keyword git_hub_client_secret_setting_name: The app setting name that contains the client
         secret of the Github
         app used for GitHub Login.
        :paramtype git_hub_client_secret_setting_name: str
        :keyword git_hub_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of GitHub
         Login authentication.
         This setting is optional.
        :paramtype git_hub_o_auth_scopes: list[str]
        :keyword twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
         sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype twitter_consumer_key: str
        :keyword twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application
         used for sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype twitter_consumer_secret: str
        :keyword twitter_consumer_secret_setting_name: The app setting name that contains the OAuth
         1.0a consumer secret of the Twitter
         application used for sign-in.
        :paramtype twitter_consumer_secret_setting_name: str
        :keyword microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
         for authentication.
         This setting is required for enabling Microsoft Account authentication.
         Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
        :paramtype microsoft_account_client_id: str
        :keyword microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the
         app used for authentication.
         This setting is required for enabling Microsoft Account authentication.
         Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
        :paramtype microsoft_account_client_secret: str
        :keyword microsoft_account_client_secret_setting_name: The app setting name containing the
         OAuth 2.0 client secret that was created for the
         app used for authentication.
        :paramtype microsoft_account_client_secret_setting_name: str
        :keyword microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part
         of Microsoft Account authentication.
         This setting is optional. If not specified, "wl.basic" is used as the default scope.
         Microsoft Account Scopes and permissions documentation:
         https://msdn.microsoft.com/en-us/library/dn631845.aspx.
        :paramtype microsoft_account_o_auth_scopes: list[str]
        :keyword is_auth_from_file: "true" if the auth config settings should be read from a file,
         "false" otherwise.
        :paramtype is_auth_from_file: str
        :keyword auth_file_path: The path of the config file containing auth settings.
         If the path is relative, base will the site's root directory.
        :paramtype auth_file_path: str
        :keyword config_version: The ConfigVersion of the Authentication / Authorization feature in use
         for the current app.
         The setting in this value can control the behavior of the control plane for Authentication /
         Authorization.
        :paramtype config_version: str
        """
        super(SiteAuthSettings, self).__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version
        self.unauthenticated_client_action = unauthenticated_client_action
        self.token_store_enabled = token_store_enabled
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.default_provider = default_provider
        self.token_refresh_extension_hours = token_refresh_extension_hours
        self.client_id = client_id
        self.client_secret = client_secret
        self.client_secret_setting_name = client_secret_setting_name
        self.client_secret_certificate_thumbprint = client_secret_certificate_thumbprint
        self.issuer = issuer
        self.validate_issuer = validate_issuer
        self.allowed_audiences = allowed_audiences
        self.additional_login_params = additional_login_params
        self.aad_claims_authorization = aad_claims_authorization
        self.google_client_id = google_client_id
        self.google_client_secret = google_client_secret
        self.google_client_secret_setting_name = google_client_secret_setting_name
        self.google_o_auth_scopes = google_o_auth_scopes
        self.facebook_app_id = facebook_app_id
        self.facebook_app_secret = facebook_app_secret
        self.facebook_app_secret_setting_name = facebook_app_secret_setting_name
        self.facebook_o_auth_scopes = facebook_o_auth_scopes
        self.git_hub_client_id = git_hub_client_id
        self.git_hub_client_secret = git_hub_client_secret
        self.git_hub_client_secret_setting_name = git_hub_client_secret_setting_name
        self.git_hub_o_auth_scopes = git_hub_o_auth_scopes
        self.twitter_consumer_key = twitter_consumer_key
        self.twitter_consumer_secret = twitter_consumer_secret
        self.twitter_consumer_secret_setting_name = twitter_consumer_secret_setting_name
        self.microsoft_account_client_id = microsoft_account_client_id
        self.microsoft_account_client_secret = microsoft_account_client_secret
        self.microsoft_account_client_secret_setting_name = microsoft_account_client_secret_setting_name
        self.microsoft_account_o_auth_scopes = microsoft_account_o_auth_scopes
        self.is_auth_from_file = is_auth_from_file
        self.auth_file_path = auth_file_path
        self.config_version = config_version


class SiteAuthSettingsV2(ProxyOnlyResource):
    """Configuration settings for the Azure App Service Authentication / Authorization V2 feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar platform: The configuration settings of the platform of App Service
     Authentication/Authorization.
    :vartype platform: ~azure.mgmt.web.v2021_01_15.models.AuthPlatform
    :ivar global_validation: The configuration settings that determines the validation flow of
     users using App Service Authentication/Authorization.
    :vartype global_validation: ~azure.mgmt.web.v2021_01_15.models.GlobalValidation
    :ivar identity_providers: The configuration settings of each of the identity providers used to
     configure App Service Authentication/Authorization.
    :vartype identity_providers: ~azure.mgmt.web.v2021_01_15.models.IdentityProviders
    :ivar login: The configuration settings of the login flow of users using App Service
     Authentication/Authorization.
    :vartype login: ~azure.mgmt.web.v2021_01_15.models.Login
    :ivar http_settings: The configuration settings of the HTTP requests for authentication and
     authorization requests made against App Service Authentication/Authorization.
    :vartype http_settings: ~azure.mgmt.web.v2021_01_15.models.HttpSettings
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'AuthPlatform'},
        'global_validation': {'key': 'properties.globalValidation', 'type': 'GlobalValidation'},
        'identity_providers': {'key': 'properties.identityProviders', 'type': 'IdentityProviders'},
        'login': {'key': 'properties.login', 'type': 'Login'},
        'http_settings': {'key': 'properties.httpSettings', 'type': 'HttpSettings'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        platform: Optional["AuthPlatform"] = None,
        global_validation: Optional["GlobalValidation"] = None,
        identity_providers: Optional["IdentityProviders"] = None,
        login: Optional["Login"] = None,
        http_settings: Optional["HttpSettings"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword platform: The configuration settings of the platform of App Service
         Authentication/Authorization.
        :paramtype platform: ~azure.mgmt.web.v2021_01_15.models.AuthPlatform
        :keyword global_validation: The configuration settings that determines the validation flow of
         users using App Service Authentication/Authorization.
        :paramtype global_validation: ~azure.mgmt.web.v2021_01_15.models.GlobalValidation
        :keyword identity_providers: The configuration settings of each of the identity providers used
         to configure App Service Authentication/Authorization.
        :paramtype identity_providers: ~azure.mgmt.web.v2021_01_15.models.IdentityProviders
        :keyword login: The configuration settings of the login flow of users using App Service
         Authentication/Authorization.
        :paramtype login: ~azure.mgmt.web.v2021_01_15.models.Login
        :keyword http_settings: The configuration settings of the HTTP requests for authentication and
         authorization requests made against App Service Authentication/Authorization.
        :paramtype http_settings: ~azure.mgmt.web.v2021_01_15.models.HttpSettings
        """
        super(SiteAuthSettingsV2, self).__init__(kind=kind, **kwargs)
        self.platform = platform
        self.global_validation = global_validation
        self.identity_providers = identity_providers
        self.login = login
        self.http_settings = http_settings


class SiteCloneability(msrest.serialization.Model):
    """Represents whether or not an app is cloneable.

    :ivar result: Name of app. Possible values include: "Cloneable", "PartiallyCloneable",
     "NotCloneable".
    :vartype result: str or ~azure.mgmt.web.v2021_01_15.models.CloneAbilityResult
    :ivar blocking_features: List of features enabled on app that prevent cloning.
    :vartype blocking_features: list[~azure.mgmt.web.v2021_01_15.models.SiteCloneabilityCriterion]
    :ivar unsupported_features: List of features enabled on app that are non-blocking but cannot be
     cloned. The app can still be cloned
     but the features in this list will not be set up on cloned app.
    :vartype unsupported_features:
     list[~azure.mgmt.web.v2021_01_15.models.SiteCloneabilityCriterion]
    :ivar blocking_characteristics: List of blocking application characteristics.
    :vartype blocking_characteristics:
     list[~azure.mgmt.web.v2021_01_15.models.SiteCloneabilityCriterion]
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'blocking_features': {'key': 'blockingFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'unsupported_features': {'key': 'unsupportedFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'blocking_characteristics': {'key': 'blockingCharacteristics', 'type': '[SiteCloneabilityCriterion]'},
    }

    def __init__(
        self,
        *,
        result: Optional[Union[str, "CloneAbilityResult"]] = None,
        blocking_features: Optional[List["SiteCloneabilityCriterion"]] = None,
        unsupported_features: Optional[List["SiteCloneabilityCriterion"]] = None,
        blocking_characteristics: Optional[List["SiteCloneabilityCriterion"]] = None,
        **kwargs
    ):
        """
        :keyword result: Name of app. Possible values include: "Cloneable", "PartiallyCloneable",
         "NotCloneable".
        :paramtype result: str or ~azure.mgmt.web.v2021_01_15.models.CloneAbilityResult
        :keyword blocking_features: List of features enabled on app that prevent cloning.
        :paramtype blocking_features:
         list[~azure.mgmt.web.v2021_01_15.models.SiteCloneabilityCriterion]
        :keyword unsupported_features: List of features enabled on app that are non-blocking but cannot
         be cloned. The app can still be cloned
         but the features in this list will not be set up on cloned app.
        :paramtype unsupported_features:
         list[~azure.mgmt.web.v2021_01_15.models.SiteCloneabilityCriterion]
        :keyword blocking_characteristics: List of blocking application characteristics.
        :paramtype blocking_characteristics:
         list[~azure.mgmt.web.v2021_01_15.models.SiteCloneabilityCriterion]
        """
        super(SiteCloneability, self).__init__(**kwargs)
        self.result = result
        self.blocking_features = blocking_features
        self.unsupported_features = unsupported_features
        self.blocking_characteristics = blocking_characteristics


class SiteCloneabilityCriterion(msrest.serialization.Model):
    """An app cloneability criterion.

    :ivar name: Name of criterion.
    :vartype name: str
    :ivar description: Description of criterion.
    :vartype description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of criterion.
        :paramtype name: str
        :keyword description: Description of criterion.
        :paramtype description: str
        """
        super(SiteCloneabilityCriterion, self).__init__(**kwargs)
        self.name = name
        self.description = description


class SiteConfig(msrest.serialization.Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar power_shell_version: Version of PowerShell.
    :vartype power_shell_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar windows_fx_version: Xenon App Framework and version.
    :vartype windows_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :vartype acr_use_managed_identity_creds: bool
    :ivar acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :vartype acr_user_managed_identity_id: str
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2021_01_15.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2021_01_15.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2021_01_15.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO", "VSTSRM".
    :vartype scm_type: str or ~azure.mgmt.web.v2021_01_15.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2021_01_15.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2021_01_15.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash",
     "PerSiteRoundRobin".
    :vartype load_balancing: str or ~azure.mgmt.web.v2021_01_15.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2021_01_15.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2021_01_15.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2021_01_15.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
     traffic to have Virtual Network Security Groups and User Defined Routes applied.
    :vartype vnet_route_all_enabled: bool
    :ivar vnet_private_ports_count: The number of private ports assigned to this app. These will be
     assigned dynamically on runtime.
    :vartype vnet_private_ports_count: int
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2021_01_15.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2021_01_15.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2021_01_15.models.ApiDefinitionInfo
    :ivar api_management_config: Azure API management settings linked to the app.
    :vartype api_management_config: ~azure.mgmt.web.v2021_01_15.models.ApiManagementConfig
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar managed_service_identity_id: Managed Service Identity Id.
    :vartype managed_service_identity_id: int
    :ivar x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :vartype x_managed_service_identity_id: int
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar ip_security_restrictions: IP security restrictions for main.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2021_01_15.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions: IP security restrictions for scm.
    :vartype scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2021_01_15.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :vartype scm_ip_security_restrictions_use_main: bool
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2021_01_15.models.SupportedTlsVersions
    :ivar scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required for
     SSL requests for SCM site. Possible values include: "1.0", "1.1", "1.2".
    :vartype scm_min_tls_version: str or ~azure.mgmt.web.v2021_01_15.models.SupportedTlsVersions
    :ivar ftps_state: State of FTP / FTPS service. Possible values include: "AllAllowed",
     "FtpsOnly", "Disabled".
    :vartype ftps_state: str or ~azure.mgmt.web.v2021_01_15.models.FtpsState
    :ivar pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :vartype pre_warmed_instance_count: int
    :ivar function_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to the Consumption and Elastic Premium Plans.
    :vartype function_app_scale_limit: int
    :ivar health_check_path: Health check path.
    :vartype health_check_path: str
    :ivar functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
     functions runtime scale monitoring is enabled. When enabled,
     the ScaleController will not monitor event sources directly, but will instead call to the
     runtime to get scale status.
    :vartype functions_runtime_scale_monitoring_enabled: bool
    :ivar website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible
     with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence
     over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a
     quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows,
     expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
     NT\CurrentVersion\Time Zones.
    :vartype website_time_zone: str
    :ivar minimum_elastic_instance_count: Number of minimum instance count for a site
     This setting only applies to the Elastic Plans.
    :vartype minimum_elastic_instance_count: int
    :ivar azure_storage_accounts: List of Azure Storage Accounts.
    :vartype azure_storage_accounts: dict[str,
     ~azure.mgmt.web.v2021_01_15.models.AzureStorageInfoValue]
    :ivar public_network_access: Property to allow or block all public traffic.
    :vartype public_network_access: str
    """

    _validation = {
        'machine_key': {'readonly': True},
        'pre_warmed_instance_count': {'maximum': 10, 'minimum': 0},
        'function_app_scale_limit': {'minimum': 0},
        'minimum_elastic_instance_count': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'phpVersion', 'type': 'str'},
        'python_version': {'key': 'pythonVersion', 'type': 'str'},
        'node_version': {'key': 'nodeVersion', 'type': 'str'},
        'power_shell_version': {'key': 'powerShellVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'windows_fx_version': {'key': 'windowsFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'httpLoggingEnabled', 'type': 'bool'},
        'acr_use_managed_identity_creds': {'key': 'acrUseManagedIdentityCreds', 'type': 'bool'},
        'acr_user_managed_identity_id': {'key': 'acrUserManagedIdentityID', 'type': 'str'},
        'logs_directory_size_limit': {'key': 'logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'scm_type': {'key': 'scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'loadBalancing', 'type': 'str'},
        'experiments': {'key': 'experiments', 'type': 'Experiments'},
        'limits': {'key': 'limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'vnet_route_all_enabled': {'key': 'vnetRouteAllEnabled', 'type': 'bool'},
        'vnet_private_ports_count': {'key': 'vnetPrivatePortsCount', 'type': 'int'},
        'cors': {'key': 'cors', 'type': 'CorsSettings'},
        'push': {'key': 'push', 'type': 'PushSettings'},
        'api_definition': {'key': 'apiDefinition', 'type': 'ApiDefinitionInfo'},
        'api_management_config': {'key': 'apiManagementConfig', 'type': 'ApiManagementConfig'},
        'auto_swap_slot_name': {'key': 'autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'localMySqlEnabled', 'type': 'bool'},
        'managed_service_identity_id': {'key': 'managedServiceIdentityId', 'type': 'int'},
        'x_managed_service_identity_id': {'key': 'xManagedServiceIdentityId', 'type': 'int'},
        'key_vault_reference_identity': {'key': 'keyVaultReferenceIdentity', 'type': 'str'},
        'ip_security_restrictions': {'key': 'ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions': {'key': 'scmIpSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions_use_main': {'key': 'scmIpSecurityRestrictionsUseMain', 'type': 'bool'},
        'http20_enabled': {'key': 'http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
        'scm_min_tls_version': {'key': 'scmMinTlsVersion', 'type': 'str'},
        'ftps_state': {'key': 'ftpsState', 'type': 'str'},
        'pre_warmed_instance_count': {'key': 'preWarmedInstanceCount', 'type': 'int'},
        'function_app_scale_limit': {'key': 'functionAppScaleLimit', 'type': 'int'},
        'health_check_path': {'key': 'healthCheckPath', 'type': 'str'},
        'functions_runtime_scale_monitoring_enabled': {'key': 'functionsRuntimeScaleMonitoringEnabled', 'type': 'bool'},
        'website_time_zone': {'key': 'websiteTimeZone', 'type': 'str'},
        'minimum_elastic_instance_count': {'key': 'minimumElasticInstanceCount', 'type': 'int'},
        'azure_storage_accounts': {'key': 'azureStorageAccounts', 'type': '{AzureStorageInfoValue}'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: Optional[str] = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        power_shell_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        acr_use_managed_identity_creds: Optional[bool] = None,
        acr_user_managed_identity_id: Optional[str] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["NameValuePair"]] = None,
        connection_strings: Optional[List["ConnStringInfo"]] = None,
        handler_mappings: Optional[List["HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "SiteLoadBalancing"]] = None,
        experiments: Optional["Experiments"] = None,
        limits: Optional["SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_route_all_enabled: Optional[bool] = None,
        vnet_private_ports_count: Optional[int] = None,
        cors: Optional["CorsSettings"] = None,
        push: Optional["PushSettings"] = None,
        api_definition: Optional["ApiDefinitionInfo"] = None,
        api_management_config: Optional["ApiManagementConfig"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: Optional[bool] = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        key_vault_reference_identity: Optional[str] = None,
        ip_security_restrictions: Optional[List["IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions: Optional[List["IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: Optional[bool] = True,
        min_tls_version: Optional[Union[str, "SupportedTlsVersions"]] = None,
        scm_min_tls_version: Optional[Union[str, "SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "FtpsState"]] = None,
        pre_warmed_instance_count: Optional[int] = None,
        function_app_scale_limit: Optional[int] = None,
        health_check_path: Optional[str] = None,
        functions_runtime_scale_monitoring_enabled: Optional[bool] = None,
        website_time_zone: Optional[str] = None,
        minimum_elastic_instance_count: Optional[int] = None,
        azure_storage_accounts: Optional[Dict[str, "AzureStorageInfoValue"]] = None,
        public_network_access: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword power_shell_version: Version of PowerShell.
        :paramtype power_shell_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword windows_fx_version: Xenon App Framework and version.
        :paramtype windows_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
        :paramtype acr_use_managed_identity_creds: bool
        :keyword acr_user_managed_identity_id: If using user managed identity, the user managed
         identity ClientId.
        :paramtype acr_user_managed_identity_id: str
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2021_01_15.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2021_01_15.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
         "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
         "ExternalHg", "OneDrive", "VSO", "VSTSRM".
        :paramtype scm_type: str or ~azure.mgmt.web.v2021_01_15.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2021_01_15.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2021_01_15.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash",
         "PerSiteRoundRobin".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2021_01_15.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2021_01_15.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2021_01_15.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2021_01_15.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
         traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :paramtype vnet_route_all_enabled: bool
        :keyword vnet_private_ports_count: The number of private ports assigned to this app. These will
         be assigned dynamically on runtime.
        :paramtype vnet_private_ports_count: int
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2021_01_15.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2021_01_15.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2021_01_15.models.ApiDefinitionInfo
        :keyword api_management_config: Azure API management settings linked to the app.
        :paramtype api_management_config: ~azure.mgmt.web.v2021_01_15.models.ApiManagementConfig
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword managed_service_identity_id: Managed Service Identity Id.
        :paramtype managed_service_identity_id: int
        :keyword x_managed_service_identity_id: Explicit Managed Service Identity Id.
        :paramtype x_managed_service_identity_id: int
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword ip_security_restrictions: IP security restrictions for main.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2021_01_15.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions: IP security restrictions for scm.
        :paramtype scm_ip_security_restrictions:
         list[~azure.mgmt.web.v2021_01_15.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :paramtype scm_ip_security_restrictions_use_main: bool
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Possible values include: "1.0", "1.1", "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2021_01_15.models.SupportedTlsVersions
        :keyword scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required
         for SSL requests for SCM site. Possible values include: "1.0", "1.1", "1.2".
        :paramtype scm_min_tls_version: str or ~azure.mgmt.web.v2021_01_15.models.SupportedTlsVersions
        :keyword ftps_state: State of FTP / FTPS service. Possible values include: "AllAllowed",
         "FtpsOnly", "Disabled".
        :paramtype ftps_state: str or ~azure.mgmt.web.v2021_01_15.models.FtpsState
        :keyword pre_warmed_instance_count: Number of preWarmed instances.
         This setting only applies to the Consumption and Elastic Plans.
        :paramtype pre_warmed_instance_count: int
        :keyword function_app_scale_limit: Maximum number of workers that a site can scale out to.
         This setting only applies to the Consumption and Elastic Premium Plans.
        :paramtype function_app_scale_limit: int
        :keyword health_check_path: Health check path.
        :paramtype health_check_path: str
        :keyword functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
         functions runtime scale monitoring is enabled. When enabled,
         the ScaleController will not monitor event sources directly, but will instead call to the
         runtime to get scale status.
        :paramtype functions_runtime_scale_monitoring_enabled: bool
        :keyword website_time_zone: Sets the time zone a site uses for generating timestamps.
         Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes
         precedence over this config. For Linux, expects tz database values
         https://www.iana.org/time-zones (for a quick reference see
         https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the
         time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time
         Zones.
        :paramtype website_time_zone: str
        :keyword minimum_elastic_instance_count: Number of minimum instance count for a site
         This setting only applies to the Elastic Plans.
        :paramtype minimum_elastic_instance_count: int
        :keyword azure_storage_accounts: List of Azure Storage Accounts.
        :paramtype azure_storage_accounts: dict[str,
         ~azure.mgmt.web.v2021_01_15.models.AzureStorageInfoValue]
        :keyword public_network_access: Property to allow or block all public traffic.
        :paramtype public_network_access: str
        """
        super(SiteConfig, self).__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.power_shell_version = power_shell_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.acr_use_managed_identity_creds = acr_use_managed_identity_creds
        self.acr_user_managed_identity_id = acr_user_managed_identity_id
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.vnet_route_all_enabled = vnet_route_all_enabled
        self.vnet_private_ports_count = vnet_private_ports_count
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.api_management_config = api_management_config
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.key_vault_reference_identity = key_vault_reference_identity
        self.ip_security_restrictions = ip_security_restrictions
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version
        self.scm_min_tls_version = scm_min_tls_version
        self.ftps_state = ftps_state
        self.pre_warmed_instance_count = pre_warmed_instance_count
        self.function_app_scale_limit = function_app_scale_limit
        self.health_check_path = health_check_path
        self.functions_runtime_scale_monitoring_enabled = functions_runtime_scale_monitoring_enabled
        self.website_time_zone = website_time_zone
        self.minimum_elastic_instance_count = minimum_elastic_instance_count
        self.azure_storage_accounts = azure_storage_accounts
        self.public_network_access = public_network_access


class SiteConfigPropertiesDictionary(msrest.serialization.Model):
    """Site config properties dictionary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar use32_bit_worker_process: :code:`<code>true</code>` if use32BitWorkerProcess should be
     set to true for the stack; otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar linux_fx_version: LinuxFxVersion configuration setting.
    :vartype linux_fx_version: str
    :ivar java_version: JavaVersion configuration setting.
    :vartype java_version: str
    :ivar power_shell_version: PowerShellVersion configuration setting.
    :vartype power_shell_version: str
    """

    _validation = {
        'use32_bit_worker_process': {'readonly': True},
        'linux_fx_version': {'readonly': True},
        'java_version': {'readonly': True},
        'power_shell_version': {'readonly': True},
    }

    _attribute_map = {
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'power_shell_version': {'key': 'powerShellVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SiteConfigPropertiesDictionary, self).__init__(**kwargs)
        self.use32_bit_worker_process = None
        self.linux_fx_version = None
        self.java_version = None
        self.power_shell_version = None


class SiteConfigResource(ProxyOnlyResource):
    """Web app configuration ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar power_shell_version: Version of PowerShell.
    :vartype power_shell_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar windows_fx_version: Xenon App Framework and version.
    :vartype windows_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :vartype acr_use_managed_identity_creds: bool
    :ivar acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :vartype acr_user_managed_identity_id: str
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2021_01_15.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2021_01_15.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2021_01_15.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO", "VSTSRM".
    :vartype scm_type: str or ~azure.mgmt.web.v2021_01_15.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2021_01_15.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2021_01_15.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash",
     "PerSiteRoundRobin".
    :vartype load_balancing: str or ~azure.mgmt.web.v2021_01_15.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2021_01_15.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2021_01_15.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2021_01_15.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
     traffic to have Virtual Network Security Groups and User Defined Routes applied.
    :vartype vnet_route_all_enabled: bool
    :ivar vnet_private_ports_count: The number of private ports assigned to this app. These will be
     assigned dynamically on runtime.
    :vartype vnet_private_ports_count: int
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2021_01_15.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2021_01_15.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2021_01_15.models.ApiDefinitionInfo
    :ivar api_management_config: Azure API management settings linked to the app.
    :vartype api_management_config: ~azure.mgmt.web.v2021_01_15.models.ApiManagementConfig
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar managed_service_identity_id: Managed Service Identity Id.
    :vartype managed_service_identity_id: int
    :ivar x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :vartype x_managed_service_identity_id: int
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar ip_security_restrictions: IP security restrictions for main.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2021_01_15.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions: IP security restrictions for scm.
    :vartype scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2021_01_15.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :vartype scm_ip_security_restrictions_use_main: bool
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2021_01_15.models.SupportedTlsVersions
    :ivar scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required for
     SSL requests for SCM site. Possible values include: "1.0", "1.1", "1.2".
    :vartype scm_min_tls_version: str or ~azure.mgmt.web.v2021_01_15.models.SupportedTlsVersions
    :ivar ftps_state: State of FTP / FTPS service. Possible values include: "AllAllowed",
     "FtpsOnly", "Disabled".
    :vartype ftps_state: str or ~azure.mgmt.web.v2021_01_15.models.FtpsState
    :ivar pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :vartype pre_warmed_instance_count: int
    :ivar function_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to the Consumption and Elastic Premium Plans.
    :vartype function_app_scale_limit: int
    :ivar health_check_path: Health check path.
    :vartype health_check_path: str
    :ivar functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
     functions runtime scale monitoring is enabled. When enabled,
     the ScaleController will not monitor event sources directly, but will instead call to the
     runtime to get scale status.
    :vartype functions_runtime_scale_monitoring_enabled: bool
    :ivar website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible
     with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence
     over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a
     quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows,
     expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
     NT\CurrentVersion\Time Zones.
    :vartype website_time_zone: str
    :ivar minimum_elastic_instance_count: Number of minimum instance count for a site
     This setting only applies to the Elastic Plans.
    :vartype minimum_elastic_instance_count: int
    :ivar azure_storage_accounts: List of Azure Storage Accounts.
    :vartype azure_storage_accounts: dict[str,
     ~azure.mgmt.web.v2021_01_15.models.AzureStorageInfoValue]
    :ivar public_network_access: Property to allow or block all public traffic.
    :vartype public_network_access: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'machine_key': {'readonly': True},
        'pre_warmed_instance_count': {'maximum': 10, 'minimum': 0},
        'function_app_scale_limit': {'minimum': 0},
        'minimum_elastic_instance_count': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'number_of_workers': {'key': 'properties.numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'properties.defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'properties.netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'properties.phpVersion', 'type': 'str'},
        'python_version': {'key': 'properties.pythonVersion', 'type': 'str'},
        'node_version': {'key': 'properties.nodeVersion', 'type': 'str'},
        'power_shell_version': {'key': 'properties.powerShellVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'properties.linuxFxVersion', 'type': 'str'},
        'windows_fx_version': {'key': 'properties.windowsFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'properties.requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'properties.requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'properties.remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'properties.remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'properties.httpLoggingEnabled', 'type': 'bool'},
        'acr_use_managed_identity_creds': {'key': 'properties.acrUseManagedIdentityCreds', 'type': 'bool'},
        'acr_user_managed_identity_id': {'key': 'properties.acrUserManagedIdentityID', 'type': 'str'},
        'logs_directory_size_limit': {'key': 'properties.logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'properties.detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'properties.publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'properties.appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'properties.connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'properties.machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'properties.handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'properties.documentRoot', 'type': 'str'},
        'scm_type': {'key': 'properties.scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'properties.use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'properties.webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'properties.alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'properties.javaVersion', 'type': 'str'},
        'java_container': {'key': 'properties.javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'properties.javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'properties.appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'properties.managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'properties.virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'properties.loadBalancing', 'type': 'str'},
        'experiments': {'key': 'properties.experiments', 'type': 'Experiments'},
        'limits': {'key': 'properties.limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'properties.autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'properties.autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'properties.tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vnet_route_all_enabled': {'key': 'properties.vnetRouteAllEnabled', 'type': 'bool'},
        'vnet_private_ports_count': {'key': 'properties.vnetPrivatePortsCount', 'type': 'int'},
        'cors': {'key': 'properties.cors', 'type': 'CorsSettings'},
        'push': {'key': 'properties.push', 'type': 'PushSettings'},
        'api_definition': {'key': 'properties.apiDefinition', 'type': 'ApiDefinitionInfo'},
        'api_management_config': {'key': 'properties.apiManagementConfig', 'type': 'ApiManagementConfig'},
        'auto_swap_slot_name': {'key': 'properties.autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
        'managed_service_identity_id': {'key': 'properties.managedServiceIdentityId', 'type': 'int'},
        'x_managed_service_identity_id': {'key': 'properties.xManagedServiceIdentityId', 'type': 'int'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'ip_security_restrictions': {'key': 'properties.ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions': {'key': 'properties.scmIpSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions_use_main': {'key': 'properties.scmIpSecurityRestrictionsUseMain', 'type': 'bool'},
        'http20_enabled': {'key': 'properties.http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'properties.minTlsVersion', 'type': 'str'},
        'scm_min_tls_version': {'key': 'properties.scmMinTlsVersion', 'type': 'str'},
        'ftps_state': {'key': 'properties.ftpsState', 'type': 'str'},
        'pre_warmed_instance_count': {'key': 'properties.preWarmedInstanceCount', 'type': 'int'},
        'function_app_scale_limit': {'key': 'properties.functionAppScaleLimit', 'type': 'int'},
        'health_check_path': {'key': 'properties.healthCheckPath', 'type': 'str'},
        'functions_runtime_scale_monitoring_enabled': {'key': 'properties.functionsRuntimeScaleMonitoringEnabled', 'type': 'bool'},
        'website_time_zone': {'key': 'properties.websiteTimeZone', 'type': 'str'},
        'minimum_elastic_instance_count': {'key': 'properties.minimumElasticInstanceCount', 'type': 'int'},
        'azure_storage_accounts': {'key': 'properties.azureStorageAccounts', 'type': '{AzureStorageInfoValue}'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: Optional[str] = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        power_shell_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        acr_use_managed_identity_creds: Optional[bool] = None,
        acr_user_managed_identity_id: Optional[str] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["NameValuePair"]] = None,
        connection_strings: Optional[List["ConnStringInfo"]] = None,
        handler_mappings: Optional[List["HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "SiteLoadBalancing"]] = None,
        experiments: Optional["Experiments"] = None,
        limits: Optional["SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_route_all_enabled: Optional[bool] = None,
        vnet_private_ports_count: Optional[int] = None,
        cors: Optional["CorsSettings"] = None,
        push: Optional["PushSettings"] = None,
        api_definition: Optional["ApiDefinitionInfo"] = None,
        api_management_config: Optional["ApiManagementConfig"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: Optional[bool] = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        key_vault_reference_identity: Optional[str] = None,
        ip_security_restrictions: Optional[List["IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions: Optional[List["IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: Optional[bool] = True,
        min_tls_version: Optional[Union[str, "SupportedTlsVersions"]] = None,
        scm_min_tls_version: Optional[Union[str, "SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "FtpsState"]] = None,
        pre_warmed_instance_count: Optional[int] = None,
        function_app_scale_limit: Optional[int] = None,
        health_check_path: Optional[str] = None,
        functions_runtime_scale_monitoring_enabled: Optional[bool] = None,
        website_time_zone: Optional[str] = None,
        minimum_elastic_instance_count: Optional[int] = None,
        azure_storage_accounts: Optional[Dict[str, "AzureStorageInfoValue"]] = None,
        public_network_access: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword power_shell_version: Version of PowerShell.
        :paramtype power_shell_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword windows_fx_version: Xenon App Framework and version.
        :paramtype windows_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
        :paramtype acr_use_managed_identity_creds: bool
        :keyword acr_user_managed_identity_id: If using user managed identity, the user managed
         identity ClientId.
        :paramtype acr_user_managed_identity_id: str
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2021_01_15.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2021_01_15.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
         "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
         "ExternalHg", "OneDrive", "VSO", "VSTSRM".
        :paramtype scm_type: str or ~azure.mgmt.web.v2021_01_15.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2021_01_15.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2021_01_15.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash",
         "PerSiteRoundRobin".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2021_01_15.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2021_01_15.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2021_01_15.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2021_01_15.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
         traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :paramtype vnet_route_all_enabled: bool
        :keyword vnet_private_ports_count: The number of private ports assigned to this app. These will
         be assigned dynamically on runtime.
        :paramtype vnet_private_ports_count: int
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2021_01_15.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2021_01_15.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2021_01_15.models.ApiDefinitionInfo
        :keyword api_management_config: Azure API management settings linked to the app.
        :paramtype api_management_config: ~azure.mgmt.web.v2021_01_15.models.ApiManagementConfig
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword managed_service_identity_id: Managed Service Identity Id.
        :paramtype managed_service_identity_id: int
        :keyword x_managed_service_identity_id: Explicit Managed Service Identity Id.
        :paramtype x_managed_service_identity_id: int
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword ip_security_restrictions: IP security restrictions for main.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2021_01_15.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions: IP security restrictions for scm.
        :paramtype scm_ip_security_restrictions:
         list[~azure.mgmt.web.v2021_01_15.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :paramtype scm_ip_security_restrictions_use_main: bool
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Possible values include: "1.0", "1.1", "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2021_01_15.models.SupportedTlsVersions
        :keyword scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required
         for SSL requests for SCM site. Possible values include: "1.0", "1.1", "1.2".
        :paramtype scm_min_tls_version: str or ~azure.mgmt.web.v2021_01_15.models.SupportedTlsVersions
        :keyword ftps_state: State of FTP / FTPS service. Possible values include: "AllAllowed",
         "FtpsOnly", "Disabled".
        :paramtype ftps_state: str or ~azure.mgmt.web.v2021_01_15.models.FtpsState
        :keyword pre_warmed_instance_count: Number of preWarmed instances.
         This setting only applies to the Consumption and Elastic Plans.
        :paramtype pre_warmed_instance_count: int
        :keyword function_app_scale_limit: Maximum number of workers that a site can scale out to.
         This setting only applies to the Consumption and Elastic Premium Plans.
        :paramtype function_app_scale_limit: int
        :keyword health_check_path: Health check path.
        :paramtype health_check_path: str
        :keyword functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
         functions runtime scale monitoring is enabled. When enabled,
         the ScaleController will not monitor event sources directly, but will instead call to the
         runtime to get scale status.
        :paramtype functions_runtime_scale_monitoring_enabled: bool
        :keyword website_time_zone: Sets the time zone a site uses for generating timestamps.
         Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes
         precedence over this config. For Linux, expects tz database values
         https://www.iana.org/time-zones (for a quick reference see
         https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the
         time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time
         Zones.
        :paramtype website_time_zone: str
        :keyword minimum_elastic_instance_count: Number of minimum instance count for a site
         This setting only applies to the Elastic Plans.
        :paramtype minimum_elastic_instance_count: int
        :keyword azure_storage_accounts: List of Azure Storage Accounts.
        :paramtype azure_storage_accounts: dict[str,
         ~azure.mgmt.web.v2021_01_15.models.AzureStorageInfoValue]
        :keyword public_network_access: Property to allow or block all public traffic.
        :paramtype public_network_access: str
        """
        super(SiteConfigResource, self).__init__(kind=kind, **kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.power_shell_version = power_shell_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.acr_use_managed_identity_creds = acr_use_managed_identity_creds
        self.acr_user_managed_identity_id = acr_user_managed_identity_id
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.vnet_route_all_enabled = vnet_route_all_enabled
        self.vnet_private_ports_count = vnet_private_ports_count
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.api_management_config = api_management_config
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.key_vault_reference_identity = key_vault_reference_identity
        self.ip_security_restrictions = ip_security_restrictions
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version
        self.scm_min_tls_version = scm_min_tls_version
        self.ftps_state = ftps_state
        self.pre_warmed_instance_count = pre_warmed_instance_count
        self.function_app_scale_limit = function_app_scale_limit
        self.health_check_path = health_check_path
        self.functions_runtime_scale_monitoring_enabled = functions_runtime_scale_monitoring_enabled
        self.website_time_zone = website_time_zone
        self.minimum_elastic_instance_count = minimum_elastic_instance_count
        self.azure_storage_accounts = azure_storage_accounts
        self.public_network_access = public_network_access


class SiteConfigResourceCollection(msrest.serialization.Model):
    """Collection of site configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.SiteConfigResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SiteConfigResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.SiteConfigResource]
        """
        super(SiteConfigResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteConfigurationSnapshotInfo(ProxyOnlyResource):
    """A snapshot of a web app configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: ~datetime.datetime
    :ivar snapshot_id: The id of the snapshot.
    :vartype snapshot_id: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
        'snapshot_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(SiteConfigurationSnapshotInfo, self).__init__(kind=kind, **kwargs)
        self.time = None
        self.snapshot_id = None


class SiteConfigurationSnapshotInfoCollection(msrest.serialization.Model):
    """Collection of metadata for the app configuration snapshots that can be restored.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.SiteConfigurationSnapshotInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigurationSnapshotInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SiteConfigurationSnapshotInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.SiteConfigurationSnapshotInfo]
        """
        super(SiteConfigurationSnapshotInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteExtensionInfo(ProxyOnlyResource):
    """Site Extension Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar extension_id: Site extension ID.
    :vartype extension_id: str
    :ivar title:
    :vartype title: str
    :ivar extension_type: Site extension type. Possible values include: "Gallery", "WebRoot".
    :vartype extension_type: str or ~azure.mgmt.web.v2021_01_15.models.SiteExtensionType
    :ivar summary: Summary description.
    :vartype summary: str
    :ivar description: Detailed description.
    :vartype description: str
    :ivar version: Version information.
    :vartype version: str
    :ivar extension_url: Extension URL.
    :vartype extension_url: str
    :ivar project_url: Project URL.
    :vartype project_url: str
    :ivar icon_url: Icon URL.
    :vartype icon_url: str
    :ivar license_url: License URL.
    :vartype license_url: str
    :ivar feed_url: Feed URL.
    :vartype feed_url: str
    :ivar authors: List of authors.
    :vartype authors: list[str]
    :ivar installer_command_line_params: Installer command line parameters.
    :vartype installer_command_line_params: str
    :ivar published_date_time: Published timestamp.
    :vartype published_date_time: ~datetime.datetime
    :ivar download_count: Count of downloads.
    :vartype download_count: int
    :ivar local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
     version; :code:`<code>false</code>` otherwise.
    :vartype local_is_latest_version: bool
    :ivar local_path: Local path.
    :vartype local_path: str
    :ivar installed_date_time: Installed timestamp.
    :vartype installed_date_time: ~datetime.datetime
    :ivar provisioning_state: Provisioning state.
    :vartype provisioning_state: str
    :ivar comment: Site Extension comment.
    :vartype comment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'extension_id': {'key': 'properties.extension_id', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'extension_type': {'key': 'properties.extension_type', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'extension_url': {'key': 'properties.extension_url', 'type': 'str'},
        'project_url': {'key': 'properties.project_url', 'type': 'str'},
        'icon_url': {'key': 'properties.icon_url', 'type': 'str'},
        'license_url': {'key': 'properties.license_url', 'type': 'str'},
        'feed_url': {'key': 'properties.feed_url', 'type': 'str'},
        'authors': {'key': 'properties.authors', 'type': '[str]'},
        'installer_command_line_params': {'key': 'properties.installer_command_line_params', 'type': 'str'},
        'published_date_time': {'key': 'properties.published_date_time', 'type': 'iso-8601'},
        'download_count': {'key': 'properties.download_count', 'type': 'int'},
        'local_is_latest_version': {'key': 'properties.local_is_latest_version', 'type': 'bool'},
        'local_path': {'key': 'properties.local_path', 'type': 'str'},
        'installed_date_time': {'key': 'properties.installed_date_time', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'comment': {'key': 'properties.comment', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        extension_id: Optional[str] = None,
        title: Optional[str] = None,
        extension_type: Optional[Union[str, "SiteExtensionType"]] = None,
        summary: Optional[str] = None,
        description: Optional[str] = None,
        version: Optional[str] = None,
        extension_url: Optional[str] = None,
        project_url: Optional[str] = None,
        icon_url: Optional[str] = None,
        license_url: Optional[str] = None,
        feed_url: Optional[str] = None,
        authors: Optional[List[str]] = None,
        installer_command_line_params: Optional[str] = None,
        published_date_time: Optional[datetime.datetime] = None,
        download_count: Optional[int] = None,
        local_is_latest_version: Optional[bool] = None,
        local_path: Optional[str] = None,
        installed_date_time: Optional[datetime.datetime] = None,
        provisioning_state: Optional[str] = None,
        comment: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword extension_id: Site extension ID.
        :paramtype extension_id: str
        :keyword title:
        :paramtype title: str
        :keyword extension_type: Site extension type. Possible values include: "Gallery", "WebRoot".
        :paramtype extension_type: str or ~azure.mgmt.web.v2021_01_15.models.SiteExtensionType
        :keyword summary: Summary description.
        :paramtype summary: str
        :keyword description: Detailed description.
        :paramtype description: str
        :keyword version: Version information.
        :paramtype version: str
        :keyword extension_url: Extension URL.
        :paramtype extension_url: str
        :keyword project_url: Project URL.
        :paramtype project_url: str
        :keyword icon_url: Icon URL.
        :paramtype icon_url: str
        :keyword license_url: License URL.
        :paramtype license_url: str
        :keyword feed_url: Feed URL.
        :paramtype feed_url: str
        :keyword authors: List of authors.
        :paramtype authors: list[str]
        :keyword installer_command_line_params: Installer command line parameters.
        :paramtype installer_command_line_params: str
        :keyword published_date_time: Published timestamp.
        :paramtype published_date_time: ~datetime.datetime
        :keyword download_count: Count of downloads.
        :paramtype download_count: int
        :keyword local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
         version; :code:`<code>false</code>` otherwise.
        :paramtype local_is_latest_version: bool
        :keyword local_path: Local path.
        :paramtype local_path: str
        :keyword installed_date_time: Installed timestamp.
        :paramtype installed_date_time: ~datetime.datetime
        :keyword provisioning_state: Provisioning state.
        :paramtype provisioning_state: str
        :keyword comment: Site Extension comment.
        :paramtype comment: str
        """
        super(SiteExtensionInfo, self).__init__(kind=kind, **kwargs)
        self.extension_id = extension_id
        self.title = title
        self.extension_type = extension_type
        self.summary = summary
        self.description = description
        self.version = version
        self.extension_url = extension_url
        self.project_url = project_url
        self.icon_url = icon_url
        self.license_url = license_url
        self.feed_url = feed_url
        self.authors = authors
        self.installer_command_line_params = installer_command_line_params
        self.published_date_time = published_date_time
        self.download_count = download_count
        self.local_is_latest_version = local_is_latest_version
        self.local_path = local_path
        self.installed_date_time = installed_date_time
        self.provisioning_state = provisioning_state
        self.comment = comment


class SiteExtensionInfoCollection(msrest.serialization.Model):
    """Collection of Kudu site extension information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.SiteExtensionInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteExtensionInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SiteExtensionInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.SiteExtensionInfo]
        """
        super(SiteExtensionInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteLimits(msrest.serialization.Model):
    """Metric limits set on an app.

    :ivar max_percentage_cpu: Maximum allowed CPU usage percentage.
    :vartype max_percentage_cpu: float
    :ivar max_memory_in_mb: Maximum allowed memory usage in MB.
    :vartype max_memory_in_mb: long
    :ivar max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :vartype max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        max_percentage_cpu: Optional[float] = None,
        max_memory_in_mb: Optional[int] = None,
        max_disk_size_in_mb: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword max_percentage_cpu: Maximum allowed CPU usage percentage.
        :paramtype max_percentage_cpu: float
        :keyword max_memory_in_mb: Maximum allowed memory usage in MB.
        :paramtype max_memory_in_mb: long
        :keyword max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :paramtype max_disk_size_in_mb: long
        """
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteLogsConfig(ProxyOnlyResource):
    """Configuration of App Service site logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar application_logs: Application logs configuration.
    :vartype application_logs: ~azure.mgmt.web.v2021_01_15.models.ApplicationLogsConfig
    :ivar http_logs: HTTP logs configuration.
    :vartype http_logs: ~azure.mgmt.web.v2021_01_15.models.HttpLogsConfig
    :ivar failed_requests_tracing: Failed requests tracing configuration.
    :vartype failed_requests_tracing: ~azure.mgmt.web.v2021_01_15.models.EnabledConfig
    :ivar detailed_error_messages: Detailed error messages configuration.
    :vartype detailed_error_messages: ~azure.mgmt.web.v2021_01_15.models.EnabledConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'application_logs': {'key': 'properties.applicationLogs', 'type': 'ApplicationLogsConfig'},
        'http_logs': {'key': 'properties.httpLogs', 'type': 'HttpLogsConfig'},
        'failed_requests_tracing': {'key': 'properties.failedRequestsTracing', 'type': 'EnabledConfig'},
        'detailed_error_messages': {'key': 'properties.detailedErrorMessages', 'type': 'EnabledConfig'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        application_logs: Optional["ApplicationLogsConfig"] = None,
        http_logs: Optional["HttpLogsConfig"] = None,
        failed_requests_tracing: Optional["EnabledConfig"] = None,
        detailed_error_messages: Optional["EnabledConfig"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword application_logs: Application logs configuration.
        :paramtype application_logs: ~azure.mgmt.web.v2021_01_15.models.ApplicationLogsConfig
        :keyword http_logs: HTTP logs configuration.
        :paramtype http_logs: ~azure.mgmt.web.v2021_01_15.models.HttpLogsConfig
        :keyword failed_requests_tracing: Failed requests tracing configuration.
        :paramtype failed_requests_tracing: ~azure.mgmt.web.v2021_01_15.models.EnabledConfig
        :keyword detailed_error_messages: Detailed error messages configuration.
        :paramtype detailed_error_messages: ~azure.mgmt.web.v2021_01_15.models.EnabledConfig
        """
        super(SiteLogsConfig, self).__init__(kind=kind, **kwargs)
        self.application_logs = application_logs
        self.http_logs = http_logs
        self.failed_requests_tracing = failed_requests_tracing
        self.detailed_error_messages = detailed_error_messages


class SiteMachineKey(msrest.serialization.Model):
    """MachineKey of an app.

    :ivar validation: MachineKey validation.
    :vartype validation: str
    :ivar validation_key: Validation key.
    :vartype validation_key: str
    :ivar decryption: Algorithm used for decryption.
    :vartype decryption: str
    :ivar decryption_key: Decryption key.
    :vartype decryption_key: str
    """

    _attribute_map = {
        'validation': {'key': 'validation', 'type': 'str'},
        'validation_key': {'key': 'validationKey', 'type': 'str'},
        'decryption': {'key': 'decryption', 'type': 'str'},
        'decryption_key': {'key': 'decryptionKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validation: Optional[str] = None,
        validation_key: Optional[str] = None,
        decryption: Optional[str] = None,
        decryption_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword validation: MachineKey validation.
        :paramtype validation: str
        :keyword validation_key: Validation key.
        :paramtype validation_key: str
        :keyword decryption: Algorithm used for decryption.
        :paramtype decryption: str
        :keyword decryption_key: Decryption key.
        :paramtype decryption_key: str
        """
        super(SiteMachineKey, self).__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SitePatchResource(ProxyOnlyResource):
    """ARM resource for a site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2021_01_15.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2021_01_15.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2021_01_15.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: Hyper-V sandbox.
    :vartype is_xenon: bool
    :ivar hyper_v: Hyper-V sandbox.
    :vartype hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2021_01_15.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar client_cert_mode: This composes with ClientCertEnabled setting.
    
    
     * ClientCertEnabled: false means ClientCert is ignored.
     * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
     accepted. Possible values include: "Required", "Optional", "OptionalInteractiveUser".
    :vartype client_cert_mode: str or ~azure.mgmt.web.v2021_01_15.models.ClientCertMode
    :ivar client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :vartype client_cert_exclusion_paths: str
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar custom_domain_verification_id: Unique identifier that verifies the custom domains
     assigned to the app. Customer will add this id to a txt record for verification.
    :vartype custom_domain_verification_id: str
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2021_01_15.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2021_01_15.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    :ivar redundancy_mode: Site redundancy mode. Possible values include: "None", "Manual",
     "Failover", "ActiveActive", "GeoRedundant".
    :vartype redundancy_mode: str or ~azure.mgmt.web.v2021_01_15.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :ivar storage_account_required: Checks if Customer provided storage account is required.
    :vartype storage_account_required: bool
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet to
     be joined by Regional VNET Integration.
     This must be of the form
     /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :vartype virtual_network_subnet_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
        'in_progress_operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'client_cert_mode': {'key': 'properties.clientCertMode', 'type': 'str'},
        'client_cert_exclusion_paths': {'key': 'properties.clientCertExclusionPaths', 'type': 'str'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'custom_domain_verification_id': {'key': 'properties.customDomainVerificationId', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
        'redundancy_mode': {'key': 'properties.redundancyMode', 'type': 'str'},
        'in_progress_operation_id': {'key': 'properties.inProgressOperationId', 'type': 'str'},
        'storage_account_required': {'key': 'properties.storageAccountRequired', 'type': 'bool'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: Optional[bool] = False,
        is_xenon: Optional[bool] = False,
        hyper_v: Optional[bool] = False,
        site_config: Optional["SiteConfig"] = None,
        scm_site_also_stopped: Optional[bool] = False,
        hosting_environment_profile: Optional["HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_mode: Optional[Union[str, "ClientCertMode"]] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        host_names_disabled: Optional[bool] = None,
        custom_domain_verification_id: Optional[str] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "RedundancyMode"]] = None,
        storage_account_required: Optional[bool] = None,
        key_vault_reference_identity: Optional[str] = None,
        virtual_network_subnet_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2021_01_15.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: Hyper-V sandbox.
        :paramtype is_xenon: bool
        :keyword hyper_v: Hyper-V sandbox.
        :paramtype hyper_v: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2021_01_15.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2021_01_15.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword client_cert_mode: This composes with ClientCertEnabled setting.
        
        
         * ClientCertEnabled: false means ClientCert is ignored.
         * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
         * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
         accepted. Possible values include: "Required", "Optional", "OptionalInteractiveUser".
        :paramtype client_cert_mode: str or ~azure.mgmt.web.v2021_01_15.models.ClientCertMode
        :keyword client_cert_exclusion_paths: client certificate authentication comma-separated
         exclusion paths.
        :paramtype client_cert_exclusion_paths: str
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword custom_domain_verification_id: Unique identifier that verifies the custom domains
         assigned to the app. Customer will add this id to a txt record for verification.
        :paramtype custom_domain_verification_id: str
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2021_01_15.models.CloningInfo
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        :keyword redundancy_mode: Site redundancy mode. Possible values include: "None", "Manual",
         "Failover", "ActiveActive", "GeoRedundant".
        :paramtype redundancy_mode: str or ~azure.mgmt.web.v2021_01_15.models.RedundancyMode
        :keyword storage_account_required: Checks if Customer provided storage account is required.
        :paramtype storage_account_required: bool
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet
         to be joined by Regional VNET Integration.
         This must be of the form
         /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :paramtype virtual_network_subnet_id: str
        """
        super(SitePatchResource, self).__init__(kind=kind, **kwargs)
        self.identity = identity
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_mode = client_cert_mode
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.host_names_disabled = host_names_disabled
        self.custom_domain_verification_id = custom_domain_verification_id
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id = None
        self.storage_account_required = storage_account_required
        self.key_vault_reference_identity = key_vault_reference_identity
        self.virtual_network_subnet_id = virtual_network_subnet_id


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar local_log_errors: Local log_errors setting.
    :vartype local_log_errors: str
    :ivar master_log_errors: Master log_errors setting.
    :vartype master_log_errors: str
    :ivar local_log_errors_max_length: Local log_errors_max_len setting.
    :vartype local_log_errors_max_length: str
    :ivar master_log_errors_max_length: Master log_errors_max_len setting.
    :vartype master_log_errors_max_length: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'local_log_errors': {'key': 'properties.localLogErrors', 'type': 'str'},
        'master_log_errors': {'key': 'properties.masterLogErrors', 'type': 'str'},
        'local_log_errors_max_length': {'key': 'properties.localLogErrorsMaxLength', 'type': 'str'},
        'master_log_errors_max_length': {'key': 'properties.masterLogErrorsMaxLength', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        local_log_errors: Optional[str] = None,
        master_log_errors: Optional[str] = None,
        local_log_errors_max_length: Optional[str] = None,
        master_log_errors_max_length: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword local_log_errors: Local log_errors setting.
        :paramtype local_log_errors: str
        :keyword master_log_errors: Master log_errors setting.
        :paramtype master_log_errors: str
        :keyword local_log_errors_max_length: Local log_errors_max_len setting.
        :paramtype local_log_errors_max_length: str
        :keyword master_log_errors_max_length: Master log_errors_max_len setting.
        :paramtype master_log_errors_max_length: str
        """
        super(SitePhpErrorLogFlag, self).__init__(kind=kind, **kwargs)
        self.local_log_errors = local_log_errors
        self.master_log_errors = master_log_errors
        self.local_log_errors_max_length = local_log_errors_max_length
        self.master_log_errors_max_length = master_log_errors_max_length


class SiteSeal(msrest.serialization.Model):
    """Site seal.

    All required parameters must be populated in order to send to Azure.

    :ivar html: Required. HTML snippet.
    :vartype html: str
    """

    _validation = {
        'html': {'required': True},
    }

    _attribute_map = {
        'html': {'key': 'html', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        html: str,
        **kwargs
    ):
        """
        :keyword html: Required. HTML snippet.
        :paramtype html: str
        """
        super(SiteSeal, self).__init__(**kwargs)
        self.html = html


class SiteSealRequest(msrest.serialization.Model):
    """Site seal request.

    :ivar light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
     otherwise, use the default color theme.
    :vartype light_theme: bool
    :ivar locale: Locale of site seal.
    :vartype locale: str
    """

    _attribute_map = {
        'light_theme': {'key': 'lightTheme', 'type': 'bool'},
        'locale': {'key': 'locale', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        light_theme: Optional[bool] = None,
        locale: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
         otherwise, use the default color theme.
        :paramtype light_theme: bool
        :keyword locale: Locale of site seal.
        :paramtype locale: str
        """
        super(SiteSealRequest, self).__init__(**kwargs)
        self.light_theme = light_theme
        self.locale = locale


class SiteSourceControl(ProxyOnlyResource):
    """Source control configuration for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar repo_url: Repository or source control URL.
    :vartype repo_url: str
    :ivar branch: Name of branch to use for deployment.
    :vartype branch: str
    :ivar is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
     :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
     online repos like GitHub).
    :vartype is_manual_integration: bool
    :ivar is_git_hub_action: :code:`<code>true</code>` if this is deployed via GitHub action.
    :vartype is_git_hub_action: bool
    :ivar deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
     otherwise, :code:`<code>false</code>`.
    :vartype deployment_rollback_enabled: bool
    :ivar is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
     :code:`<code>false</code>` for a Git repository.
    :vartype is_mercurial: bool
    :ivar git_hub_action_configuration: If GitHub Action is selected, than the associated
     configuration.
    :vartype git_hub_action_configuration:
     ~azure.mgmt.web.v2021_01_15.models.GitHubActionConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repo_url': {'key': 'properties.repoUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'is_manual_integration': {'key': 'properties.isManualIntegration', 'type': 'bool'},
        'is_git_hub_action': {'key': 'properties.isGitHubAction', 'type': 'bool'},
        'deployment_rollback_enabled': {'key': 'properties.deploymentRollbackEnabled', 'type': 'bool'},
        'is_mercurial': {'key': 'properties.isMercurial', 'type': 'bool'},
        'git_hub_action_configuration': {'key': 'properties.gitHubActionConfiguration', 'type': 'GitHubActionConfiguration'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        is_manual_integration: Optional[bool] = None,
        is_git_hub_action: Optional[bool] = None,
        deployment_rollback_enabled: Optional[bool] = None,
        is_mercurial: Optional[bool] = None,
        git_hub_action_configuration: Optional["GitHubActionConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword repo_url: Repository or source control URL.
        :paramtype repo_url: str
        :keyword branch: Name of branch to use for deployment.
        :paramtype branch: str
        :keyword is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
         :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
         online repos like GitHub).
        :paramtype is_manual_integration: bool
        :keyword is_git_hub_action: :code:`<code>true</code>` if this is deployed via GitHub action.
        :paramtype is_git_hub_action: bool
        :keyword deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
         otherwise, :code:`<code>false</code>`.
        :paramtype deployment_rollback_enabled: bool
        :keyword is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
         :code:`<code>false</code>` for a Git repository.
        :paramtype is_mercurial: bool
        :keyword git_hub_action_configuration: If GitHub Action is selected, than the associated
         configuration.
        :paramtype git_hub_action_configuration:
         ~azure.mgmt.web.v2021_01_15.models.GitHubActionConfiguration
        """
        super(SiteSourceControl, self).__init__(kind=kind, **kwargs)
        self.repo_url = repo_url
        self.branch = branch
        self.is_manual_integration = is_manual_integration
        self.is_git_hub_action = is_git_hub_action
        self.deployment_rollback_enabled = deployment_rollback_enabled
        self.is_mercurial = is_mercurial
        self.git_hub_action_configuration = git_hub_action_configuration


class SkuCapacity(msrest.serialization.Model):
    """Description of the App Service plan scale options.

    :ivar minimum: Minimum number of workers for this App Service plan SKU.
    :vartype minimum: int
    :ivar maximum: Maximum number of workers for this App Service plan SKU.
    :vartype maximum: int
    :ivar elastic_maximum: Maximum number of Elastic workers for this App Service plan SKU.
    :vartype elastic_maximum: int
    :ivar default: Default number of workers for this App Service plan SKU.
    :vartype default: int
    :ivar scale_type: Available scale configurations for an App Service plan.
    :vartype scale_type: str
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'elastic_maximum': {'key': 'elasticMaximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        elastic_maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword minimum: Minimum number of workers for this App Service plan SKU.
        :paramtype minimum: int
        :keyword maximum: Maximum number of workers for this App Service plan SKU.
        :paramtype maximum: int
        :keyword elastic_maximum: Maximum number of Elastic workers for this App Service plan SKU.
        :paramtype elastic_maximum: int
        :keyword default: Default number of workers for this App Service plan SKU.
        :paramtype default: int
        :keyword scale_type: Available scale configurations for an App Service plan.
        :paramtype scale_type: str
        """
        super(SkuCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.elastic_maximum = elastic_maximum
        self.default = default
        self.scale_type = scale_type


class SkuDescription(msrest.serialization.Model):
    """Description of a SKU for a scalable resource.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Current number of instances assigned to the resource.
    :vartype capacity: int
    :ivar sku_capacity: Min, max, and default scale values of the SKU.
    :vartype sku_capacity: ~azure.mgmt.web.v2021_01_15.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.web.v2021_01_15.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'sku_capacity': {'key': 'skuCapacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        sku_capacity: Optional["SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["Capability"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Current number of instances assigned to the resource.
        :paramtype capacity: int
        :keyword sku_capacity: Min, max, and default scale values of the SKU.
        :paramtype sku_capacity: ~azure.mgmt.web.v2021_01_15.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.web.v2021_01_15.models.Capability]
        """
        super(SkuDescription, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.sku_capacity = sku_capacity
        self.locations = locations
        self.capabilities = capabilities


class SkuInfo(msrest.serialization.Model):
    """SKU discovery information.

    :ivar resource_type: Resource type that this SKU applies to.
    :vartype resource_type: str
    :ivar sku: Name and tier of the SKU.
    :vartype sku: ~azure.mgmt.web.v2021_01_15.models.SkuDescription
    :ivar capacity: Min, max, and default scale values of the SKU.
    :vartype capacity: ~azure.mgmt.web.v2021_01_15.models.SkuCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        sku: Optional["SkuDescription"] = None,
        capacity: Optional["SkuCapacity"] = None,
        **kwargs
    ):
        """
        :keyword resource_type: Resource type that this SKU applies to.
        :paramtype resource_type: str
        :keyword sku: Name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.web.v2021_01_15.models.SkuDescription
        :keyword capacity: Min, max, and default scale values of the SKU.
        :paramtype capacity: ~azure.mgmt.web.v2021_01_15.models.SkuCapacity
        """
        super(SkuInfo, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku
        self.capacity = capacity


class SkuInfoCollection(msrest.serialization.Model):
    """Collection of SKU information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.SkuInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SkuInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.SkuInfo]
        """
        super(SkuInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SkuInfos(msrest.serialization.Model):
    """Collection of SKU information.

    :ivar resource_type: Resource type that this SKU applies to.
    :vartype resource_type: str
    :ivar skus: List of SKUs the subscription is able to use.
    :vartype skus: list[~azure.mgmt.web.v2021_01_15.models.GlobalCsmSkuDescription]
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'skus': {'key': 'skus', 'type': '[GlobalCsmSkuDescription]'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        skus: Optional[List["GlobalCsmSkuDescription"]] = None,
        **kwargs
    ):
        """
        :keyword resource_type: Resource type that this SKU applies to.
        :paramtype resource_type: str
        :keyword skus: List of SKUs the subscription is able to use.
        :paramtype skus: list[~azure.mgmt.web.v2021_01_15.models.GlobalCsmSkuDescription]
        """
        super(SkuInfos, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.skus = skus


class SlotConfigNamesResource(ProxyOnlyResource):
    """Slot Config names azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar connection_string_names: List of connection string names.
    :vartype connection_string_names: list[str]
    :ivar app_setting_names: List of application settings names.
    :vartype app_setting_names: list[str]
    :ivar azure_storage_config_names: List of external Azure storage account identifiers.
    :vartype azure_storage_config_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string_names': {'key': 'properties.connectionStringNames', 'type': '[str]'},
        'app_setting_names': {'key': 'properties.appSettingNames', 'type': '[str]'},
        'azure_storage_config_names': {'key': 'properties.azureStorageConfigNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string_names: Optional[List[str]] = None,
        app_setting_names: Optional[List[str]] = None,
        azure_storage_config_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword connection_string_names: List of connection string names.
        :paramtype connection_string_names: list[str]
        :keyword app_setting_names: List of application settings names.
        :paramtype app_setting_names: list[str]
        :keyword azure_storage_config_names: List of external Azure storage account identifiers.
        :paramtype azure_storage_config_names: list[str]
        """
        super(SlotConfigNamesResource, self).__init__(kind=kind, **kwargs)
        self.connection_string_names = connection_string_names
        self.app_setting_names = app_setting_names
        self.azure_storage_config_names = azure_storage_config_names


class SlotDifference(ProxyOnlyResource):
    """A setting difference between two deployment slots of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar level: Level of the difference: Information, Warning or Error.
    :vartype level: str
    :ivar setting_type: The type of the setting: General, AppSetting or ConnectionString.
    :vartype setting_type: str
    :ivar diff_rule: Rule that describes how to process the setting difference during a slot swap.
    :vartype diff_rule: str
    :ivar setting_name: Name of the setting.
    :vartype setting_name: str
    :ivar value_in_current_slot: Value of the setting in the current slot.
    :vartype value_in_current_slot: str
    :ivar value_in_target_slot: Value of the setting in the target slot.
    :vartype value_in_target_slot: str
    :ivar description: Description of the setting difference.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'level': {'readonly': True},
        'setting_type': {'readonly': True},
        'diff_rule': {'readonly': True},
        'setting_name': {'readonly': True},
        'value_in_current_slot': {'readonly': True},
        'value_in_target_slot': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'setting_type': {'key': 'properties.settingType', 'type': 'str'},
        'diff_rule': {'key': 'properties.diffRule', 'type': 'str'},
        'setting_name': {'key': 'properties.settingName', 'type': 'str'},
        'value_in_current_slot': {'key': 'properties.valueInCurrentSlot', 'type': 'str'},
        'value_in_target_slot': {'key': 'properties.valueInTargetSlot', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(SlotDifference, self).__init__(kind=kind, **kwargs)
        self.level = None
        self.setting_type = None
        self.diff_rule = None
        self.setting_name = None
        self.value_in_current_slot = None
        self.value_in_target_slot = None
        self.description = None


class SlotDifferenceCollection(msrest.serialization.Model):
    """Collection of slot differences.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.SlotDifference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SlotDifference]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SlotDifference"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.SlotDifference]
        """
        super(SlotDifferenceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SlotSwapStatus(msrest.serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        'timestamp_utc': {'readonly': True},
        'source_slot_name': {'readonly': True},
        'destination_slot_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_utc': {'key': 'timestampUtc', 'type': 'iso-8601'},
        'source_slot_name': {'key': 'sourceSlotName', 'type': 'str'},
        'destination_slot_name': {'key': 'destinationSlotName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SlotSwapStatus, self).__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on request execution time.

    :ivar time_taken: Time taken.
    :vartype time_taken: str
    :ivar path: Request Path.
    :vartype path: str
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        'time_taken': {'key': 'timeTaken', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_taken: Optional[str] = None,
        path: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword time_taken: Time taken.
        :paramtype time_taken: str
        :keyword path: Request Path.
        :paramtype path: str
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super(SlowRequestsBasedTrigger, self).__init__(**kwargs)
        self.time_taken = time_taken
        self.path = path
        self.count = count
        self.time_interval = time_interval


class Snapshot(ProxyOnlyResource):
    """A snapshot of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(Snapshot, self).__init__(kind=kind, **kwargs)
        self.time = None


class SnapshotCollection(msrest.serialization.Model):
    """Collection of snapshots which can be used to revert an app to a previous time.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.Snapshot]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Snapshot"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.Snapshot]
        """
        super(SnapshotCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SnapshotRecoverySource(msrest.serialization.Model):
    """Specifies the web app that snapshot contents will be retrieved from.

    :ivar location: Geographical location of the source web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :vartype location: str
    :ivar id: ARM resource ID of the source app.
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :vartype id: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Geographical location of the source web app, e.g. SouthEastAsia,
         SouthCentralUS.
        :paramtype location: str
        :keyword id: ARM resource ID of the source app.
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots.
        :paramtype id: str
        """
        super(SnapshotRecoverySource, self).__init__(**kwargs)
        self.location = location
        self.id = id


class SnapshotRestoreRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar snapshot_time: Point in time in which the app restore should be done, formatted as a
     DateTime string.
    :vartype snapshot_time: str
    :ivar recovery_source: Optional. Specifies the web app that snapshot contents will be retrieved
     from.
     If empty, the targeted web app will be used as the source.
    :vartype recovery_source: ~azure.mgmt.web.v2021_01_15.models.SnapshotRecoverySource
    :ivar overwrite: If :code:`<code>true</code>` the restore operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :vartype recover_configuration: bool
    :ivar ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :vartype ignore_conflicting_host_names: bool
    :ivar use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :vartype use_dr_secondary: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'recovery_source': {'key': 'properties.recoverySource', 'type': 'SnapshotRecoverySource'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'use_dr_secondary': {'key': 'properties.useDRSecondary', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        snapshot_time: Optional[str] = None,
        recovery_source: Optional["SnapshotRecoverySource"] = None,
        overwrite: Optional[bool] = None,
        recover_configuration: Optional[bool] = None,
        ignore_conflicting_host_names: Optional[bool] = None,
        use_dr_secondary: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword snapshot_time: Point in time in which the app restore should be done, formatted as a
         DateTime string.
        :paramtype snapshot_time: str
        :keyword recovery_source: Optional. Specifies the web app that snapshot contents will be
         retrieved from.
         If empty, the targeted web app will be used as the source.
        :paramtype recovery_source: ~azure.mgmt.web.v2021_01_15.models.SnapshotRecoverySource
        :keyword overwrite: If :code:`<code>true</code>` the restore operation can overwrite source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword recover_configuration: If true, site configuration, in addition to content, will be
         reverted.
        :paramtype recover_configuration: bool
        :keyword ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
         recovering to a target web app.
         This setting is only necessary when RecoverConfiguration is enabled.
        :paramtype ignore_conflicting_host_names: bool
        :keyword use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
        :paramtype use_dr_secondary: bool
        """
        super(SnapshotRestoreRequest, self).__init__(kind=kind, **kwargs)
        self.snapshot_time = snapshot_time
        self.recovery_source = recovery_source
        self.overwrite = overwrite
        self.recover_configuration = recover_configuration
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.use_dr_secondary = use_dr_secondary


class Solution(msrest.serialization.Model):
    """Class Representing Solution for problems detected.

    :ivar id: Solution Id.
    :vartype id: float
    :ivar display_name: Display Name of the solution.
    :vartype display_name: str
    :ivar order: Order of the solution.
    :vartype order: float
    :ivar description: Description of the solution.
    :vartype description: str
    :ivar type: Type of Solution. Possible values include: "QuickSolution", "DeepInvestigation",
     "BestPractices".
    :vartype type: str or ~azure.mgmt.web.v2021_01_15.models.SolutionType
    :ivar data: Solution Data.
    :vartype data: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
    :ivar metadata: Solution Metadata.
    :vartype metadata: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'float'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'order': {'key': 'order', 'type': 'float'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data': {'key': 'data', 'type': '[[NameValuePair]]'},
        'metadata': {'key': 'metadata', 'type': '[[NameValuePair]]'},
    }

    def __init__(
        self,
        *,
        id: Optional[float] = None,
        display_name: Optional[str] = None,
        order: Optional[float] = None,
        description: Optional[str] = None,
        type: Optional[Union[str, "SolutionType"]] = None,
        data: Optional[List[List["NameValuePair"]]] = None,
        metadata: Optional[List[List["NameValuePair"]]] = None,
        **kwargs
    ):
        """
        :keyword id: Solution Id.
        :paramtype id: float
        :keyword display_name: Display Name of the solution.
        :paramtype display_name: str
        :keyword order: Order of the solution.
        :paramtype order: float
        :keyword description: Description of the solution.
        :paramtype description: str
        :keyword type: Type of Solution. Possible values include: "QuickSolution", "DeepInvestigation",
         "BestPractices".
        :paramtype type: str or ~azure.mgmt.web.v2021_01_15.models.SolutionType
        :keyword data: Solution Data.
        :paramtype data: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
        :keyword metadata: Solution Metadata.
        :paramtype metadata: list[list[~azure.mgmt.web.v2021_01_15.models.NameValuePair]]
        """
        super(Solution, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.order = order
        self.description = description
        self.type = type
        self.data = data
        self.metadata = metadata


class SourceControl(ProxyOnlyResource):
    """The source control OAuth token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar token: OAuth access token.
    :vartype token: str
    :ivar token_secret: OAuth access token secret.
    :vartype token_secret: str
    :ivar refresh_token: OAuth refresh token.
    :vartype refresh_token: str
    :ivar expiration_time: OAuth token expiration.
    :vartype expiration_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'token': {'key': 'properties.token', 'type': 'str'},
        'token_secret': {'key': 'properties.tokenSecret', 'type': 'str'},
        'refresh_token': {'key': 'properties.refreshToken', 'type': 'str'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        token: Optional[str] = None,
        token_secret: Optional[str] = None,
        refresh_token: Optional[str] = None,
        expiration_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword token: OAuth access token.
        :paramtype token: str
        :keyword token_secret: OAuth access token secret.
        :paramtype token_secret: str
        :keyword refresh_token: OAuth refresh token.
        :paramtype refresh_token: str
        :keyword expiration_time: OAuth token expiration.
        :paramtype expiration_time: ~datetime.datetime
        """
        super(SourceControl, self).__init__(kind=kind, **kwargs)
        self.token = token
        self.token_secret = token_secret
        self.refresh_token = refresh_token
        self.expiration_time = expiration_time


class SourceControlCollection(msrest.serialization.Model):
    """Collection of source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.SourceControl]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControl]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SourceControl"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.SourceControl]
        """
        super(SourceControlCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StackMajorVersion(msrest.serialization.Model):
    """Application stack major version.

    :ivar display_version: Application stack major version (display only).
    :vartype display_version: str
    :ivar runtime_version: Application stack major version (runtime only).
    :vartype runtime_version: str
    :ivar is_default: :code:`<code>true</code>` if this is the default major version; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    :ivar minor_versions: Minor versions associated with the major version.
    :vartype minor_versions: list[~azure.mgmt.web.v2021_01_15.models.StackMinorVersion]
    :ivar application_insights: :code:`<code>true</code>` if this supports Application Insights;
     otherwise, :code:`<code>false</code>`.
    :vartype application_insights: bool
    :ivar is_preview: :code:`<code>true</code>` if this stack is in Preview, otherwise
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if this stack has been deprecated, otherwise
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if this stack should be hidden for new customers on
     portal, otherwise :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar app_settings_dictionary: :code:`<appSettings>
      <appSetting name="FUNCTIONS_WORKER_RUNTIME" value="dotnet" />
     </appSettings>`
      Example: All the function apps need AppSetting: "FUNCTIONS_WORKER_RUNTIME" to be set stack
     name.
    :vartype app_settings_dictionary: dict[str, any]
    :ivar site_config_properties_dictionary: :code:`<siteConfigProperties>
      <siteConfigProperty name="Use32BitWorkerProcess" value="false" />
     </siteConfigProperties>`
      Example: All Linux Function Apps, need Use32BitWorkerProcess to be set to 0.
    :vartype site_config_properties_dictionary: dict[str, any]
    """

    _attribute_map = {
        'display_version': {'key': 'displayVersion', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'minor_versions': {'key': 'minorVersions', 'type': '[StackMinorVersion]'},
        'application_insights': {'key': 'applicationInsights', 'type': 'bool'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'app_settings_dictionary': {'key': 'appSettingsDictionary', 'type': '{object}'},
        'site_config_properties_dictionary': {'key': 'siteConfigPropertiesDictionary', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        display_version: Optional[str] = None,
        runtime_version: Optional[str] = None,
        is_default: Optional[bool] = None,
        minor_versions: Optional[List["StackMinorVersion"]] = None,
        application_insights: Optional[bool] = None,
        is_preview: Optional[bool] = None,
        is_deprecated: Optional[bool] = None,
        is_hidden: Optional[bool] = None,
        app_settings_dictionary: Optional[Dict[str, Any]] = None,
        site_config_properties_dictionary: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword display_version: Application stack major version (display only).
        :paramtype display_version: str
        :keyword runtime_version: Application stack major version (runtime only).
        :paramtype runtime_version: str
        :keyword is_default: :code:`<code>true</code>` if this is the default major version; otherwise,
         :code:`<code>false</code>`.
        :paramtype is_default: bool
        :keyword minor_versions: Minor versions associated with the major version.
        :paramtype minor_versions: list[~azure.mgmt.web.v2021_01_15.models.StackMinorVersion]
        :keyword application_insights: :code:`<code>true</code>` if this supports Application Insights;
         otherwise, :code:`<code>false</code>`.
        :paramtype application_insights: bool
        :keyword is_preview: :code:`<code>true</code>` if this stack is in Preview, otherwise
         :code:`<code>false</code>`.
        :paramtype is_preview: bool
        :keyword is_deprecated: :code:`<code>true</code>` if this stack has been deprecated, otherwise
         :code:`<code>false</code>`.
        :paramtype is_deprecated: bool
        :keyword is_hidden: :code:`<code>true</code>` if this stack should be hidden for new customers
         on portal, otherwise :code:`<code>false</code>`.
        :paramtype is_hidden: bool
        :keyword app_settings_dictionary: :code:`<appSettings>
          <appSetting name="FUNCTIONS_WORKER_RUNTIME" value="dotnet" />
         </appSettings>`
          Example: All the function apps need AppSetting: "FUNCTIONS_WORKER_RUNTIME" to be set stack
         name.
        :paramtype app_settings_dictionary: dict[str, any]
        :keyword site_config_properties_dictionary: :code:`<siteConfigProperties>
          <siteConfigProperty name="Use32BitWorkerProcess" value="false" />
         </siteConfigProperties>`
          Example: All Linux Function Apps, need Use32BitWorkerProcess to be set to 0.
        :paramtype site_config_properties_dictionary: dict[str, any]
        """
        super(StackMajorVersion, self).__init__(**kwargs)
        self.display_version = display_version
        self.runtime_version = runtime_version
        self.is_default = is_default
        self.minor_versions = minor_versions
        self.application_insights = application_insights
        self.is_preview = is_preview
        self.is_deprecated = is_deprecated
        self.is_hidden = is_hidden
        self.app_settings_dictionary = app_settings_dictionary
        self.site_config_properties_dictionary = site_config_properties_dictionary


class StackMinorVersion(msrest.serialization.Model):
    """Application stack minor version.

    :ivar display_version: Application stack minor version (display only).
    :vartype display_version: str
    :ivar runtime_version: Application stack minor version (runtime only).
    :vartype runtime_version: str
    :ivar is_default: :code:`<code>true</code>` if this is the default minor version; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    :ivar is_remote_debugging_enabled: :code:`<code>true</code>` if this supports Remote Debugging,
     otherwise :code:`<code>false</code>`.
    :vartype is_remote_debugging_enabled: bool
    """

    _attribute_map = {
        'display_version': {'key': 'displayVersion', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'is_remote_debugging_enabled': {'key': 'isRemoteDebuggingEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        display_version: Optional[str] = None,
        runtime_version: Optional[str] = None,
        is_default: Optional[bool] = None,
        is_remote_debugging_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword display_version: Application stack minor version (display only).
        :paramtype display_version: str
        :keyword runtime_version: Application stack minor version (runtime only).
        :paramtype runtime_version: str
        :keyword is_default: :code:`<code>true</code>` if this is the default minor version; otherwise,
         :code:`<code>false</code>`.
        :paramtype is_default: bool
        :keyword is_remote_debugging_enabled: :code:`<code>true</code>` if this supports Remote
         Debugging, otherwise :code:`<code>false</code>`.
        :paramtype is_remote_debugging_enabled: bool
        """
        super(StackMinorVersion, self).__init__(**kwargs)
        self.display_version = display_version
        self.runtime_version = runtime_version
        self.is_default = is_default
        self.is_remote_debugging_enabled = is_remote_debugging_enabled


class StampCapacity(msrest.serialization.Model):
    """Stamp capacity information.

    :ivar name: Name of the stamp.
    :vartype name: str
    :ivar available_capacity: Available capacity (# of machines, bytes of storage etc...).
    :vartype available_capacity: long
    :ivar total_capacity: Total capacity (# of machines, bytes of storage etc...).
    :vartype total_capacity: long
    :ivar unit: Name of the unit.
    :vartype unit: str
    :ivar compute_mode: Shared/dedicated workers. Possible values include: "Shared", "Dedicated",
     "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2021_01_15.models.ComputeModeOptions
    :ivar worker_size: Size of the machines. Possible values include: "Small", "Medium", "Large",
     "D1", "D2", "D3", "SmallV3", "MediumV3", "LargeV3", "NestedSmall", "NestedSmallLinux",
     "Default".
    :vartype worker_size: str or ~azure.mgmt.web.v2021_01_15.models.WorkerSizeOptions
    :ivar worker_size_id: Size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
    :vartype worker_size_id: int
    :ivar exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic apps.
     Basic apps are not used for capacity allocation.
    :vartype exclude_from_capacity_allocation: bool
    :ivar is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is applicable
     for all apps; otherwise, :code:`<code>false</code>`.
    :vartype is_applicable_for_all_compute_modes: bool
    :ivar site_mode: Shared or Dedicated.
    :vartype site_mode: str
    :ivar is_linux: Is this a linux stamp capacity.
    :vartype is_linux: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'long'},
        'total_capacity': {'key': 'totalCapacity', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
        'compute_mode': {'key': 'computeMode', 'type': 'str'},
        'worker_size': {'key': 'workerSize', 'type': 'str'},
        'worker_size_id': {'key': 'workerSizeId', 'type': 'int'},
        'exclude_from_capacity_allocation': {'key': 'excludeFromCapacityAllocation', 'type': 'bool'},
        'is_applicable_for_all_compute_modes': {'key': 'isApplicableForAllComputeModes', 'type': 'bool'},
        'site_mode': {'key': 'siteMode', 'type': 'str'},
        'is_linux': {'key': 'isLinux', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available_capacity: Optional[int] = None,
        total_capacity: Optional[int] = None,
        unit: Optional[str] = None,
        compute_mode: Optional[Union[str, "ComputeModeOptions"]] = None,
        worker_size: Optional[Union[str, "WorkerSizeOptions"]] = None,
        worker_size_id: Optional[int] = None,
        exclude_from_capacity_allocation: Optional[bool] = None,
        is_applicable_for_all_compute_modes: Optional[bool] = None,
        site_mode: Optional[str] = None,
        is_linux: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the stamp.
        :paramtype name: str
        :keyword available_capacity: Available capacity (# of machines, bytes of storage etc...).
        :paramtype available_capacity: long
        :keyword total_capacity: Total capacity (# of machines, bytes of storage etc...).
        :paramtype total_capacity: long
        :keyword unit: Name of the unit.
        :paramtype unit: str
        :keyword compute_mode: Shared/dedicated workers. Possible values include: "Shared",
         "Dedicated", "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2021_01_15.models.ComputeModeOptions
        :keyword worker_size: Size of the machines. Possible values include: "Small", "Medium",
         "Large", "D1", "D2", "D3", "SmallV3", "MediumV3", "LargeV3", "NestedSmall", "NestedSmallLinux",
         "Default".
        :paramtype worker_size: str or ~azure.mgmt.web.v2021_01_15.models.WorkerSizeOptions
        :keyword worker_size_id: Size ID of machines:
         0 - Small
         1 - Medium
         2 - Large.
        :paramtype worker_size_id: int
        :keyword exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic
         apps.
         Basic apps are not used for capacity allocation.
        :paramtype exclude_from_capacity_allocation: bool
        :keyword is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is
         applicable for all apps; otherwise, :code:`<code>false</code>`.
        :paramtype is_applicable_for_all_compute_modes: bool
        :keyword site_mode: Shared or Dedicated.
        :paramtype site_mode: str
        :keyword is_linux: Is this a linux stamp capacity.
        :paramtype is_linux: bool
        """
        super(StampCapacity, self).__init__(**kwargs)
        self.name = name
        self.available_capacity = available_capacity
        self.total_capacity = total_capacity
        self.unit = unit
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_size_id = worker_size_id
        self.exclude_from_capacity_allocation = exclude_from_capacity_allocation
        self.is_applicable_for_all_compute_modes = is_applicable_for_all_compute_modes
        self.site_mode = site_mode
        self.is_linux = is_linux


class StampCapacityCollection(msrest.serialization.Model):
    """Collection of stamp capacities.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.StampCapacity]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StampCapacity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StampCapacity"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.StampCapacity]
        """
        super(StampCapacityCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteARMResource(Resource):
    """Static Site ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.web.v2021_01_15.models.SkuDescription
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
    :ivar default_hostname: The default autogenerated hostname for the static site.
    :vartype default_hostname: str
    :ivar repository_url: URL for the repository of the static site.
    :vartype repository_url: str
    :ivar branch: The target branch in the repository.
    :vartype branch: str
    :ivar custom_domains: The custom domains associated with this static site.
    :vartype custom_domains: list[str]
    :ivar repository_token: A user's github repository token. This is used to setup the Github
     Actions workflow file and API secrets.
    :vartype repository_token: str
    :ivar build_properties: Build properties to configure on the repository.
    :vartype build_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteBuildProperties
    :ivar private_endpoint_connections: Private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.web.v2021_01_15.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection]
    :ivar staging_environment_policy: State indicating whether staging environments are allowed or
     not allowed for a static web app. Possible values include: "Enabled", "Disabled".
    :vartype staging_environment_policy: str or
     ~azure.mgmt.web.v2021_01_15.models.StagingEnvironmentPolicy
    :ivar allow_config_file_updates: :code:`<code>false</code>` if config file is locked for this
     static web app; otherwise, :code:`<code>true</code>`.
    :vartype allow_config_file_updates: bool
    :ivar template_properties: Template options for generating a new repository.
    :vartype template_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteTemplateOptions
    :ivar content_distribution_endpoint: The content distribution endpoint for the static site.
    :vartype content_distribution_endpoint: str
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar user_provided_function_apps: User provided function apps registered with the static site.
    :vartype user_provided_function_apps:
     list[~azure.mgmt.web.v2021_01_15.models.StaticSiteUserProvidedFunctionApp]
    :ivar provider: The provider that submitted the last deployment to the primary environment of
     the static site.
    :vartype provider: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'default_hostname': {'readonly': True},
        'custom_domains': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'content_distribution_endpoint': {'readonly': True},
        'key_vault_reference_identity': {'readonly': True},
        'user_provided_function_apps': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'default_hostname': {'key': 'properties.defaultHostname', 'type': 'str'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[str]'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'build_properties': {'key': 'properties.buildProperties', 'type': 'StaticSiteBuildProperties'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ResponseMessageEnvelopeRemotePrivateEndpointConnection]'},
        'staging_environment_policy': {'key': 'properties.stagingEnvironmentPolicy', 'type': 'str'},
        'allow_config_file_updates': {'key': 'properties.allowConfigFileUpdates', 'type': 'bool'},
        'template_properties': {'key': 'properties.templateProperties', 'type': 'StaticSiteTemplateOptions'},
        'content_distribution_endpoint': {'key': 'properties.contentDistributionEndpoint', 'type': 'str'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'user_provided_function_apps': {'key': 'properties.userProvidedFunctionApps', 'type': '[StaticSiteUserProvidedFunctionApp]'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["SkuDescription"] = None,
        identity: Optional["ManagedServiceIdentity"] = None,
        repository_url: Optional[str] = None,
        branch: Optional[str] = None,
        repository_token: Optional[str] = None,
        build_properties: Optional["StaticSiteBuildProperties"] = None,
        staging_environment_policy: Optional[Union[str, "StagingEnvironmentPolicy"]] = None,
        allow_config_file_updates: Optional[bool] = None,
        template_properties: Optional["StaticSiteTemplateOptions"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.web.v2021_01_15.models.SkuDescription
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2021_01_15.models.ManagedServiceIdentity
        :keyword repository_url: URL for the repository of the static site.
        :paramtype repository_url: str
        :keyword branch: The target branch in the repository.
        :paramtype branch: str
        :keyword repository_token: A user's github repository token. This is used to setup the Github
         Actions workflow file and API secrets.
        :paramtype repository_token: str
        :keyword build_properties: Build properties to configure on the repository.
        :paramtype build_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteBuildProperties
        :keyword staging_environment_policy: State indicating whether staging environments are allowed
         or not allowed for a static web app. Possible values include: "Enabled", "Disabled".
        :paramtype staging_environment_policy: str or
         ~azure.mgmt.web.v2021_01_15.models.StagingEnvironmentPolicy
        :keyword allow_config_file_updates: :code:`<code>false</code>` if config file is locked for
         this static web app; otherwise, :code:`<code>true</code>`.
        :paramtype allow_config_file_updates: bool
        :keyword template_properties: Template options for generating a new repository.
        :paramtype template_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteTemplateOptions
        """
        super(StaticSiteARMResource, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.default_hostname = None
        self.repository_url = repository_url
        self.branch = branch
        self.custom_domains = None
        self.repository_token = repository_token
        self.build_properties = build_properties
        self.private_endpoint_connections = None
        self.staging_environment_policy = staging_environment_policy
        self.allow_config_file_updates = allow_config_file_updates
        self.template_properties = template_properties
        self.content_distribution_endpoint = None
        self.key_vault_reference_identity = None
        self.user_provided_function_apps = None
        self.provider = None


class StaticSiteBuildARMResource(ProxyOnlyResource):
    """Static Site Build ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar build_id: An identifier for the static site build.
    :vartype build_id: str
    :ivar source_branch: The source branch.
    :vartype source_branch: str
    :ivar pull_request_title: The title of a pull request that a static site build is related to.
    :vartype pull_request_title: str
    :ivar hostname: The hostname for a static site build.
    :vartype hostname: str
    :ivar created_time_utc: When this build was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_updated_on: When this build was updated.
    :vartype last_updated_on: ~datetime.datetime
    :ivar status: The status of the static site build. Possible values include:
     "WaitingForDeployment", "Uploading", "Deploying", "Ready", "Failed", "Deleting", "Detached".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.BuildStatus
    :ivar user_provided_function_apps: User provided function apps registered with the static site
     build.
    :vartype user_provided_function_apps:
     list[~azure.mgmt.web.v2021_01_15.models.StaticSiteUserProvidedFunctionApp]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'build_id': {'readonly': True},
        'source_branch': {'readonly': True},
        'pull_request_title': {'readonly': True},
        'hostname': {'readonly': True},
        'created_time_utc': {'readonly': True},
        'last_updated_on': {'readonly': True},
        'status': {'readonly': True},
        'user_provided_function_apps': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'build_id': {'key': 'properties.buildId', 'type': 'str'},
        'source_branch': {'key': 'properties.sourceBranch', 'type': 'str'},
        'pull_request_title': {'key': 'properties.pullRequestTitle', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'properties.lastUpdatedOn', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'user_provided_function_apps': {'key': 'properties.userProvidedFunctionApps', 'type': '[StaticSiteUserProvidedFunctionApp]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(StaticSiteBuildARMResource, self).__init__(kind=kind, **kwargs)
        self.build_id = None
        self.source_branch = None
        self.pull_request_title = None
        self.hostname = None
        self.created_time_utc = None
        self.last_updated_on = None
        self.status = None
        self.user_provided_function_apps = None


class StaticSiteBuildCollection(msrest.serialization.Model):
    """Collection of static site builds.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.StaticSiteBuildARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteBuildARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteBuildARMResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.StaticSiteBuildARMResource]
        """
        super(StaticSiteBuildCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteBuildProperties(msrest.serialization.Model):
    """Build properties for the static site.

    :ivar app_location: The path to the app code within the repository.
    :vartype app_location: str
    :ivar api_location: The path to the api code within the repository.
    :vartype api_location: str
    :ivar app_artifact_location: Deprecated: The path of the app artifacts after building
     (deprecated in favor of OutputLocation).
    :vartype app_artifact_location: str
    :ivar output_location: The output path of the app after building.
    :vartype output_location: str
    :ivar app_build_command: A custom command to run during deployment of the static content
     application.
    :vartype app_build_command: str
    :ivar api_build_command: A custom command to run during deployment of the Azure Functions API
     application.
    :vartype api_build_command: str
    :ivar skip_github_action_workflow_generation: Skip Github Action workflow generation.
    :vartype skip_github_action_workflow_generation: bool
    :ivar github_action_secret_name_override: Github Action secret name override.
    :vartype github_action_secret_name_override: str
    """

    _attribute_map = {
        'app_location': {'key': 'appLocation', 'type': 'str'},
        'api_location': {'key': 'apiLocation', 'type': 'str'},
        'app_artifact_location': {'key': 'appArtifactLocation', 'type': 'str'},
        'output_location': {'key': 'outputLocation', 'type': 'str'},
        'app_build_command': {'key': 'appBuildCommand', 'type': 'str'},
        'api_build_command': {'key': 'apiBuildCommand', 'type': 'str'},
        'skip_github_action_workflow_generation': {'key': 'skipGithubActionWorkflowGeneration', 'type': 'bool'},
        'github_action_secret_name_override': {'key': 'githubActionSecretNameOverride', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        app_location: Optional[str] = None,
        api_location: Optional[str] = None,
        app_artifact_location: Optional[str] = None,
        output_location: Optional[str] = None,
        app_build_command: Optional[str] = None,
        api_build_command: Optional[str] = None,
        skip_github_action_workflow_generation: Optional[bool] = None,
        github_action_secret_name_override: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword app_location: The path to the app code within the repository.
        :paramtype app_location: str
        :keyword api_location: The path to the api code within the repository.
        :paramtype api_location: str
        :keyword app_artifact_location: Deprecated: The path of the app artifacts after building
         (deprecated in favor of OutputLocation).
        :paramtype app_artifact_location: str
        :keyword output_location: The output path of the app after building.
        :paramtype output_location: str
        :keyword app_build_command: A custom command to run during deployment of the static content
         application.
        :paramtype app_build_command: str
        :keyword api_build_command: A custom command to run during deployment of the Azure Functions
         API application.
        :paramtype api_build_command: str
        :keyword skip_github_action_workflow_generation: Skip Github Action workflow generation.
        :paramtype skip_github_action_workflow_generation: bool
        :keyword github_action_secret_name_override: Github Action secret name override.
        :paramtype github_action_secret_name_override: str
        """
        super(StaticSiteBuildProperties, self).__init__(**kwargs)
        self.app_location = app_location
        self.api_location = api_location
        self.app_artifact_location = app_artifact_location
        self.output_location = output_location
        self.app_build_command = app_build_command
        self.api_build_command = api_build_command
        self.skip_github_action_workflow_generation = skip_github_action_workflow_generation
        self.github_action_secret_name_override = github_action_secret_name_override


class StaticSiteCollection(msrest.serialization.Model):
    """Collection of static sites.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.StaticSiteARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteARMResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.StaticSiteARMResource]
        """
        super(StaticSiteCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteCustomDomainOverviewARMResource(ProxyOnlyResource):
    """Static Site Custom Domain Overview ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar domain_name: The domain name for the static site custom domain.
    :vartype domain_name: str
    :ivar created_on: The date and time on which the custom domain was created for the static site.
    :vartype created_on: ~datetime.datetime
    :ivar status: The status of the custom domain. Possible values include:
     "RetrievingValidationToken", "Validating", "Adding", "Ready", "Failed", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.CustomDomainStatus
    :ivar validation_token: The TXT record validation token.
    :vartype validation_token: str
    :ivar error_message:
    :vartype error_message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_name': {'readonly': True},
        'created_on': {'readonly': True},
        'status': {'readonly': True},
        'validation_token': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'properties.domainName', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'validation_token': {'key': 'properties.validationToken', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(StaticSiteCustomDomainOverviewARMResource, self).__init__(kind=kind, **kwargs)
        self.domain_name = None
        self.created_on = None
        self.status = None
        self.validation_token = None
        self.error_message = None


class StaticSiteCustomDomainOverviewCollection(msrest.serialization.Model):
    """Collection of static site custom domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value:
     list[~azure.mgmt.web.v2021_01_15.models.StaticSiteCustomDomainOverviewARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteCustomDomainOverviewARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteCustomDomainOverviewARMResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value:
         list[~azure.mgmt.web.v2021_01_15.models.StaticSiteCustomDomainOverviewARMResource]
        """
        super(StaticSiteCustomDomainOverviewCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteCustomDomainRequestPropertiesARMResource(ProxyOnlyResource):
    """Static Site Custom Domain Request Properties ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar validation_method: Validation method for adding a custom domain.
    :vartype validation_method: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'validation_method': {'key': 'properties.validationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        validation_method: Optional[str] = "cname-delegation",
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword validation_method: Validation method for adding a custom domain.
        :paramtype validation_method: str
        """
        super(StaticSiteCustomDomainRequestPropertiesARMResource, self).__init__(kind=kind, **kwargs)
        self.validation_method = validation_method


class StaticSiteFunctionOverviewARMResource(ProxyOnlyResource):
    """Static Site Function Overview ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar function_name: The name for the function.
    :vartype function_name: str
    :ivar trigger_type: The trigger type of the function. Possible values include: "HttpTrigger",
     "Unknown".
    :vartype trigger_type: str or ~azure.mgmt.web.v2021_01_15.models.TriggerTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'function_name': {'readonly': True},
        'trigger_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_name': {'key': 'properties.functionName', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(StaticSiteFunctionOverviewARMResource, self).__init__(kind=kind, **kwargs)
        self.function_name = None
        self.trigger_type = None


class StaticSiteFunctionOverviewCollection(msrest.serialization.Model):
    """Collection of static site functions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.StaticSiteFunctionOverviewARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteFunctionOverviewARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteFunctionOverviewARMResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value:
         list[~azure.mgmt.web.v2021_01_15.models.StaticSiteFunctionOverviewARMResource]
        """
        super(StaticSiteFunctionOverviewCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSitePatchResource(ProxyOnlyResource):
    """ARM resource for a static site when patching.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar default_hostname: The default autogenerated hostname for the static site.
    :vartype default_hostname: str
    :ivar repository_url: URL for the repository of the static site.
    :vartype repository_url: str
    :ivar branch: The target branch in the repository.
    :vartype branch: str
    :ivar custom_domains: The custom domains associated with this static site.
    :vartype custom_domains: list[str]
    :ivar repository_token: A user's github repository token. This is used to setup the Github
     Actions workflow file and API secrets.
    :vartype repository_token: str
    :ivar build_properties: Build properties to configure on the repository.
    :vartype build_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteBuildProperties
    :ivar private_endpoint_connections: Private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.web.v2021_01_15.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection]
    :ivar staging_environment_policy: State indicating whether staging environments are allowed or
     not allowed for a static web app. Possible values include: "Enabled", "Disabled".
    :vartype staging_environment_policy: str or
     ~azure.mgmt.web.v2021_01_15.models.StagingEnvironmentPolicy
    :ivar allow_config_file_updates: :code:`<code>false</code>` if config file is locked for this
     static web app; otherwise, :code:`<code>true</code>`.
    :vartype allow_config_file_updates: bool
    :ivar template_properties: Template options for generating a new repository.
    :vartype template_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteTemplateOptions
    :ivar content_distribution_endpoint: The content distribution endpoint for the static site.
    :vartype content_distribution_endpoint: str
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar user_provided_function_apps: User provided function apps registered with the static site.
    :vartype user_provided_function_apps:
     list[~azure.mgmt.web.v2021_01_15.models.StaticSiteUserProvidedFunctionApp]
    :ivar provider: The provider that submitted the last deployment to the primary environment of
     the static site.
    :vartype provider: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'default_hostname': {'readonly': True},
        'custom_domains': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'content_distribution_endpoint': {'readonly': True},
        'key_vault_reference_identity': {'readonly': True},
        'user_provided_function_apps': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_hostname': {'key': 'properties.defaultHostname', 'type': 'str'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[str]'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'build_properties': {'key': 'properties.buildProperties', 'type': 'StaticSiteBuildProperties'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ResponseMessageEnvelopeRemotePrivateEndpointConnection]'},
        'staging_environment_policy': {'key': 'properties.stagingEnvironmentPolicy', 'type': 'str'},
        'allow_config_file_updates': {'key': 'properties.allowConfigFileUpdates', 'type': 'bool'},
        'template_properties': {'key': 'properties.templateProperties', 'type': 'StaticSiteTemplateOptions'},
        'content_distribution_endpoint': {'key': 'properties.contentDistributionEndpoint', 'type': 'str'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'user_provided_function_apps': {'key': 'properties.userProvidedFunctionApps', 'type': '[StaticSiteUserProvidedFunctionApp]'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repository_url: Optional[str] = None,
        branch: Optional[str] = None,
        repository_token: Optional[str] = None,
        build_properties: Optional["StaticSiteBuildProperties"] = None,
        staging_environment_policy: Optional[Union[str, "StagingEnvironmentPolicy"]] = None,
        allow_config_file_updates: Optional[bool] = None,
        template_properties: Optional["StaticSiteTemplateOptions"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword repository_url: URL for the repository of the static site.
        :paramtype repository_url: str
        :keyword branch: The target branch in the repository.
        :paramtype branch: str
        :keyword repository_token: A user's github repository token. This is used to setup the Github
         Actions workflow file and API secrets.
        :paramtype repository_token: str
        :keyword build_properties: Build properties to configure on the repository.
        :paramtype build_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteBuildProperties
        :keyword staging_environment_policy: State indicating whether staging environments are allowed
         or not allowed for a static web app. Possible values include: "Enabled", "Disabled".
        :paramtype staging_environment_policy: str or
         ~azure.mgmt.web.v2021_01_15.models.StagingEnvironmentPolicy
        :keyword allow_config_file_updates: :code:`<code>false</code>` if config file is locked for
         this static web app; otherwise, :code:`<code>true</code>`.
        :paramtype allow_config_file_updates: bool
        :keyword template_properties: Template options for generating a new repository.
        :paramtype template_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteTemplateOptions
        """
        super(StaticSitePatchResource, self).__init__(kind=kind, **kwargs)
        self.default_hostname = None
        self.repository_url = repository_url
        self.branch = branch
        self.custom_domains = None
        self.repository_token = repository_token
        self.build_properties = build_properties
        self.private_endpoint_connections = None
        self.staging_environment_policy = staging_environment_policy
        self.allow_config_file_updates = allow_config_file_updates
        self.template_properties = template_properties
        self.content_distribution_endpoint = None
        self.key_vault_reference_identity = None
        self.user_provided_function_apps = None
        self.provider = None


class StaticSiteResetPropertiesARMResource(ProxyOnlyResource):
    """Static Site Reset Properties ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar repository_token: The token which proves admin privileges to the repository.
    :vartype repository_token: str
    :ivar should_update_repository: Determines whether the repository should be updated with the
     new properties.
    :vartype should_update_repository: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'should_update_repository': {'key': 'properties.shouldUpdateRepository', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repository_token: Optional[str] = None,
        should_update_repository: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword repository_token: The token which proves admin privileges to the repository.
        :paramtype repository_token: str
        :keyword should_update_repository: Determines whether the repository should be updated with the
         new properties.
        :paramtype should_update_repository: bool
        """
        super(StaticSiteResetPropertiesARMResource, self).__init__(kind=kind, **kwargs)
        self.repository_token = repository_token
        self.should_update_repository = should_update_repository


class StaticSitesWorkflowPreview(ProxyOnlyResource):
    """Preview for the Static Site Workflow to be generated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar path: The path for the workflow file to be generated.
    :vartype path: str
    :ivar contents: The contents for the workflow file to be generated.
    :vartype contents: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'path': {'readonly': True},
        'contents': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'contents': {'key': 'properties.contents', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(StaticSitesWorkflowPreview, self).__init__(kind=kind, **kwargs)
        self.path = None
        self.contents = None


class StaticSitesWorkflowPreviewRequest(ProxyOnlyResource):
    """Request entity for previewing the Static Site workflow.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar repository_url: URL for the repository of the static site.
    :vartype repository_url: str
    :ivar branch: The target branch in the repository.
    :vartype branch: str
    :ivar build_properties: Build properties to configure on the repository.
    :vartype build_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteBuildProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'build_properties': {'key': 'properties.buildProperties', 'type': 'StaticSiteBuildProperties'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repository_url: Optional[str] = None,
        branch: Optional[str] = None,
        build_properties: Optional["StaticSiteBuildProperties"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword repository_url: URL for the repository of the static site.
        :paramtype repository_url: str
        :keyword branch: The target branch in the repository.
        :paramtype branch: str
        :keyword build_properties: Build properties to configure on the repository.
        :paramtype build_properties: ~azure.mgmt.web.v2021_01_15.models.StaticSiteBuildProperties
        """
        super(StaticSitesWorkflowPreviewRequest, self).__init__(kind=kind, **kwargs)
        self.repository_url = repository_url
        self.branch = branch
        self.build_properties = build_properties


class StaticSiteTemplateOptions(msrest.serialization.Model):
    """Template Options for the static site.

    :ivar template_repository_url: URL of the template repository. The newly generated repository
     will be based on this one.
    :vartype template_repository_url: str
    :ivar owner: Owner of the newly generated repository.
    :vartype owner: str
    :ivar repository_name: Name of the newly generated repository.
    :vartype repository_name: str
    :ivar description: Description of the newly generated repository.
    :vartype description: str
    :ivar is_private: Whether or not the newly generated repository is a private repository.
     Defaults to false (i.e. public).
    :vartype is_private: bool
    """

    _attribute_map = {
        'template_repository_url': {'key': 'templateRepositoryUrl', 'type': 'str'},
        'owner': {'key': 'owner', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_private': {'key': 'isPrivate', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        template_repository_url: Optional[str] = None,
        owner: Optional[str] = None,
        repository_name: Optional[str] = None,
        description: Optional[str] = None,
        is_private: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword template_repository_url: URL of the template repository. The newly generated
         repository will be based on this one.
        :paramtype template_repository_url: str
        :keyword owner: Owner of the newly generated repository.
        :paramtype owner: str
        :keyword repository_name: Name of the newly generated repository.
        :paramtype repository_name: str
        :keyword description: Description of the newly generated repository.
        :paramtype description: str
        :keyword is_private: Whether or not the newly generated repository is a private repository.
         Defaults to false (i.e. public).
        :paramtype is_private: bool
        """
        super(StaticSiteTemplateOptions, self).__init__(**kwargs)
        self.template_repository_url = template_repository_url
        self.owner = owner
        self.repository_name = repository_name
        self.description = description
        self.is_private = is_private


class StaticSiteUserARMResource(ProxyOnlyResource):
    """Static Site User ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provider: The identity provider for the static site user.
    :vartype provider: str
    :ivar user_id: The user id for the static site user.
    :vartype user_id: str
    :ivar display_name: The display name for the static site user.
    :vartype display_name: str
    :ivar roles: The roles for the static site user, in free-form string format.
    :vartype roles: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provider': {'readonly': True},
        'user_id': {'readonly': True},
        'display_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        roles: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword roles: The roles for the static site user, in free-form string format.
        :paramtype roles: str
        """
        super(StaticSiteUserARMResource, self).__init__(kind=kind, **kwargs)
        self.provider = None
        self.user_id = None
        self.display_name = None
        self.roles = roles


class StaticSiteUserCollection(msrest.serialization.Model):
    """Collection of static site custom users.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.StaticSiteUserARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteUserARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteUserARMResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.StaticSiteUserARMResource]
        """
        super(StaticSiteUserCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteUserInvitationRequestResource(ProxyOnlyResource):
    """Static sites user roles invitation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar domain: The domain name for the static site custom domain.
    :vartype domain: str
    :ivar provider: The identity provider for the static site user.
    :vartype provider: str
    :ivar user_details: The user id for the static site user.
    :vartype user_details: str
    :ivar roles: The roles for the static site user, in free-form string format.
    :vartype roles: str
    :ivar num_hours_to_expiration: The number of hours the sas token stays valid.
    :vartype num_hours_to_expiration: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'domain': {'key': 'properties.domain', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'user_details': {'key': 'properties.userDetails', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': 'str'},
        'num_hours_to_expiration': {'key': 'properties.numHoursToExpiration', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        domain: Optional[str] = None,
        provider: Optional[str] = None,
        user_details: Optional[str] = None,
        roles: Optional[str] = None,
        num_hours_to_expiration: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword domain: The domain name for the static site custom domain.
        :paramtype domain: str
        :keyword provider: The identity provider for the static site user.
        :paramtype provider: str
        :keyword user_details: The user id for the static site user.
        :paramtype user_details: str
        :keyword roles: The roles for the static site user, in free-form string format.
        :paramtype roles: str
        :keyword num_hours_to_expiration: The number of hours the sas token stays valid.
        :paramtype num_hours_to_expiration: int
        """
        super(StaticSiteUserInvitationRequestResource, self).__init__(kind=kind, **kwargs)
        self.domain = domain
        self.provider = provider
        self.user_details = user_details
        self.roles = roles
        self.num_hours_to_expiration = num_hours_to_expiration


class StaticSiteUserInvitationResponseResource(ProxyOnlyResource):
    """Static sites user roles invitation link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar expires_on: The expiration time of the invitation.
    :vartype expires_on: ~datetime.datetime
    :ivar invitation_url: The url for the invitation link.
    :vartype invitation_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'expires_on': {'readonly': True},
        'invitation_url': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'expires_on': {'key': 'properties.expiresOn', 'type': 'iso-8601'},
        'invitation_url': {'key': 'properties.invitationUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(StaticSiteUserInvitationResponseResource, self).__init__(kind=kind, **kwargs)
        self.expires_on = None
        self.invitation_url = None


class StaticSiteUserProvidedFunctionApp(ProxyOnlyResource):
    """A static site user provided function.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar function_app_resource_id: The resource id of the function app registered with the static
     site.
    :vartype function_app_resource_id: str
    :ivar function_app_region: The region of the function app registered with the static site.
    :vartype function_app_region: str
    :ivar created_on: The date and time on which the function app was registered with the static
     site.
    :vartype created_on: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_on': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_app_resource_id': {'key': 'properties.functionAppResourceId', 'type': 'str'},
        'function_app_region': {'key': 'properties.functionAppRegion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        function_app_resource_id: Optional[str] = None,
        function_app_region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword function_app_resource_id: The resource id of the function app registered with the
         static site.
        :paramtype function_app_resource_id: str
        :keyword function_app_region: The region of the function app registered with the static site.
        :paramtype function_app_region: str
        """
        super(StaticSiteUserProvidedFunctionApp, self).__init__(kind=kind, **kwargs)
        self.function_app_resource_id = function_app_resource_id
        self.function_app_region = function_app_region
        self.created_on = None


class StaticSiteUserProvidedFunctionAppARMResource(ProxyOnlyResource):
    """Static Site User Provided Function App ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar function_app_resource_id: The resource id of the function app registered with the static
     site.
    :vartype function_app_resource_id: str
    :ivar function_app_region: The region of the function app registered with the static site.
    :vartype function_app_region: str
    :ivar created_on: The date and time on which the function app was registered with the static
     site.
    :vartype created_on: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_on': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_app_resource_id': {'key': 'properties.functionAppResourceId', 'type': 'str'},
        'function_app_region': {'key': 'properties.functionAppRegion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        function_app_resource_id: Optional[str] = None,
        function_app_region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword function_app_resource_id: The resource id of the function app registered with the
         static site.
        :paramtype function_app_resource_id: str
        :keyword function_app_region: The region of the function app registered with the static site.
        :paramtype function_app_region: str
        """
        super(StaticSiteUserProvidedFunctionAppARMResource, self).__init__(kind=kind, **kwargs)
        self.function_app_resource_id = function_app_resource_id
        self.function_app_region = function_app_region
        self.created_on = None


class StaticSiteUserProvidedFunctionAppsCollection(msrest.serialization.Model):
    """Collection of static site user provided function apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value:
     list[~azure.mgmt.web.v2021_01_15.models.StaticSiteUserProvidedFunctionAppARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteUserProvidedFunctionAppARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["StaticSiteUserProvidedFunctionAppARMResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value:
         list[~azure.mgmt.web.v2021_01_15.models.StaticSiteUserProvidedFunctionAppARMResource]
        """
        super(StaticSiteUserProvidedFunctionAppsCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StaticSiteZipDeploymentARMResource(ProxyOnlyResource):
    """Static site zip deployment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar app_zip_url: URL for the zipped app content.
    :vartype app_zip_url: str
    :ivar api_zip_url: URL for the zipped api content.
    :vartype api_zip_url: str
    :ivar deployment_title: A title to label the deployment.
    :vartype deployment_title: str
    :ivar provider: The provider submitting this deployment.
    :vartype provider: str
    :ivar function_language: The language of the api content, if it exists.
    :vartype function_language: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'app_zip_url': {'key': 'properties.appZipUrl', 'type': 'str'},
        'api_zip_url': {'key': 'properties.apiZipUrl', 'type': 'str'},
        'deployment_title': {'key': 'properties.deploymentTitle', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'function_language': {'key': 'properties.functionLanguage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        app_zip_url: Optional[str] = None,
        api_zip_url: Optional[str] = None,
        deployment_title: Optional[str] = None,
        provider: Optional[str] = None,
        function_language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword app_zip_url: URL for the zipped app content.
        :paramtype app_zip_url: str
        :keyword api_zip_url: URL for the zipped api content.
        :paramtype api_zip_url: str
        :keyword deployment_title: A title to label the deployment.
        :paramtype deployment_title: str
        :keyword provider: The provider submitting this deployment.
        :paramtype provider: str
        :keyword function_language: The language of the api content, if it exists.
        :paramtype function_language: str
        """
        super(StaticSiteZipDeploymentARMResource, self).__init__(kind=kind, **kwargs)
        self.app_zip_url = app_zip_url
        self.api_zip_url = api_zip_url
        self.deployment_title = deployment_title
        self.provider = provider
        self.function_language = function_language


class Status(msrest.serialization.Model):
    """Identify the status of the most severe insight generated by the detector.

    :ivar message: Descriptive message.
    :vartype message: str
    :ivar status_id: Level of the most severe insight generated by the detector. Possible values
     include: "Critical", "Warning", "Info", "Success", "None".
    :vartype status_id: str or ~azure.mgmt.web.v2021_01_15.models.InsightStatus
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'status_id': {'key': 'statusId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        status_id: Optional[Union[str, "InsightStatus"]] = None,
        **kwargs
    ):
        """
        :keyword message: Descriptive message.
        :paramtype message: str
        :keyword status_id: Level of the most severe insight generated by the detector. Possible values
         include: "Critical", "Warning", "Info", "Success", "None".
        :paramtype status_id: str or ~azure.mgmt.web.v2021_01_15.models.InsightStatus
        """
        super(Status, self).__init__(**kwargs)
        self.message = message
        self.status_id = status_id


class StatusCodesBasedTrigger(msrest.serialization.Model):
    """Trigger based on status code.

    :ivar status: HTTP status code.
    :vartype status: int
    :ivar sub_status: Request Sub Status.
    :vartype sub_status: int
    :ivar win32_status: Win32 error code.
    :vartype win32_status: int
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    :ivar path: Request Path.
    :vartype path: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'sub_status': {'key': 'subStatus', 'type': 'int'},
        'win32_status': {'key': 'win32Status', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[int] = None,
        sub_status: Optional[int] = None,
        win32_status: Optional[int] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: HTTP status code.
        :paramtype status: int
        :keyword sub_status: Request Sub Status.
        :paramtype sub_status: int
        :keyword win32_status: Win32 error code.
        :paramtype win32_status: int
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        :keyword path: Request Path.
        :paramtype path: str
        """
        super(StatusCodesBasedTrigger, self).__init__(**kwargs)
        self.status = status
        self.sub_status = sub_status
        self.win32_status = win32_status
        self.count = count
        self.time_interval = time_interval
        self.path = path


class StatusCodesRangeBasedTrigger(msrest.serialization.Model):
    """Trigger based on range of status codes.

    :ivar status_codes: HTTP status code.
    :vartype status_codes: str
    :ivar path:
    :vartype path: str
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        'status_codes': {'key': 'statusCodes', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status_codes: Optional[str] = None,
        path: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status_codes: HTTP status code.
        :paramtype status_codes: str
        :keyword path:
        :paramtype path: str
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super(StatusCodesRangeBasedTrigger, self).__init__(**kwargs)
        self.status_codes = status_codes
        self.path = path
        self.count = count
        self.time_interval = time_interval


class StorageMigrationOptions(ProxyOnlyResource):
    """Options for app content migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azurefiles_connection_string: AzureFiles connection string.
    :vartype azurefiles_connection_string: str
    :ivar azurefiles_share: AzureFiles share.
    :vartype azurefiles_share: str
    :ivar switch_site_after_migration: :code:`<code>true</code>`if the app should be switched over;
     otherwise, :code:`<code>false</code>`.
    :vartype switch_site_after_migration: bool
    :ivar block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
     during copy operation; otherwise, :code:`<code>false</code>`.
    :vartype block_write_access_to_site: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azurefiles_connection_string': {'key': 'properties.azurefilesConnectionString', 'type': 'str'},
        'azurefiles_share': {'key': 'properties.azurefilesShare', 'type': 'str'},
        'switch_site_after_migration': {'key': 'properties.switchSiteAfterMigration', 'type': 'bool'},
        'block_write_access_to_site': {'key': 'properties.blockWriteAccessToSite', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        azurefiles_connection_string: Optional[str] = None,
        azurefiles_share: Optional[str] = None,
        switch_site_after_migration: Optional[bool] = False,
        block_write_access_to_site: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword azurefiles_connection_string: AzureFiles connection string.
        :paramtype azurefiles_connection_string: str
        :keyword azurefiles_share: AzureFiles share.
        :paramtype azurefiles_share: str
        :keyword switch_site_after_migration: :code:`<code>true</code>`if the app should be switched
         over; otherwise, :code:`<code>false</code>`.
        :paramtype switch_site_after_migration: bool
        :keyword block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
         during copy operation; otherwise, :code:`<code>false</code>`.
        :paramtype block_write_access_to_site: bool
        """
        super(StorageMigrationOptions, self).__init__(kind=kind, **kwargs)
        self.azurefiles_connection_string = azurefiles_connection_string
        self.azurefiles_share = azurefiles_share
        self.switch_site_after_migration = switch_site_after_migration
        self.block_write_access_to_site = block_write_access_to_site


class StorageMigrationResponse(ProxyOnlyResource):
    """Response for a migration of app content request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_id: When server starts the migration process, it will return an operation ID
     identifying that particular migration operation.
    :vartype operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(StorageMigrationResponse, self).__init__(kind=kind, **kwargs)
        self.operation_id = None


class StringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Settings.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Settings.
        :paramtype properties: dict[str, str]
        """
        super(StringDictionary, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class StringList(ProxyOnlyResource):
    """String list resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: List of string resources.
    :vartype properties: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: List of string resources.
        :paramtype properties: list[str]
        """
        super(StringList, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class SupportTopic(msrest.serialization.Model):
    """Defines a unique Support Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Support Topic Id.
    :vartype id: str
    :ivar pes_id: Unique resource Id.
    :vartype pes_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'pes_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'pes_id': {'key': 'pesId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SupportTopic, self).__init__(**kwargs)
        self.id = None
        self.pes_id = None


class SwiftVirtualNetwork(ProxyOnlyResource):
    """Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar subnet_resource_id: The Virtual Network subnet's resource ID. This is the subnet that
     this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined
     first.
    :vartype subnet_resource_id: str
    :ivar swift_supported: A flag that specifies if the scale unit this Web App is on supports
     Swift integration.
    :vartype swift_supported: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet_resource_id': {'key': 'properties.subnetResourceId', 'type': 'str'},
        'swift_supported': {'key': 'properties.swiftSupported', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        subnet_resource_id: Optional[str] = None,
        swift_supported: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword subnet_resource_id: The Virtual Network subnet's resource ID. This is the subnet that
         this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined
         first.
        :paramtype subnet_resource_id: str
        :keyword swift_supported: A flag that specifies if the scale unit this Web App is on supports
         Swift integration.
        :paramtype swift_supported: bool
        """
        super(SwiftVirtualNetwork, self).__init__(kind=kind, **kwargs)
        self.subnet_resource_id = subnet_resource_id
        self.swift_supported = swift_supported


class TldLegalAgreement(msrest.serialization.Model):
    """Legal agreement for a top level domain.

    All required parameters must be populated in order to send to Azure.

    :ivar agreement_key: Required. Unique identifier for the agreement.
    :vartype agreement_key: str
    :ivar title: Required. Agreement title.
    :vartype title: str
    :ivar content: Required. Agreement details.
    :vartype content: str
    :ivar url: URL where a copy of the agreement details is hosted.
    :vartype url: str
    """

    _validation = {
        'agreement_key': {'required': True},
        'title': {'required': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'agreement_key': {'key': 'agreementKey', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        agreement_key: str,
        title: str,
        content: str,
        url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword agreement_key: Required. Unique identifier for the agreement.
        :paramtype agreement_key: str
        :keyword title: Required. Agreement title.
        :paramtype title: str
        :keyword content: Required. Agreement details.
        :paramtype content: str
        :keyword url: URL where a copy of the agreement details is hosted.
        :paramtype url: str
        """
        super(TldLegalAgreement, self).__init__(**kwargs)
        self.agreement_key = agreement_key
        self.title = title
        self.content = content
        self.url = url


class TldLegalAgreementCollection(msrest.serialization.Model):
    """Collection of top-level domain legal agreements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.TldLegalAgreement]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TldLegalAgreement]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TldLegalAgreement"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.TldLegalAgreement]
        """
        super(TldLegalAgreementCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TokenStore(msrest.serialization.Model):
    """The configuration settings of the token store.

    :ivar enabled: :code:`<code>true</code>` to durably store platform-specific security tokens
     that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :vartype token_refresh_extension_hours: float
    :ivar file_system: The configuration settings of the storage of the tokens if a file system is
     used.
    :vartype file_system: ~azure.mgmt.web.v2021_01_15.models.FileSystemTokenStore
    :ivar azure_blob_storage: The configuration settings of the storage of the tokens if blob
     storage is used.
    :vartype azure_blob_storage: ~azure.mgmt.web.v2021_01_15.models.BlobStorageTokenStore
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'token_refresh_extension_hours': {'key': 'tokenRefreshExtensionHours', 'type': 'float'},
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemTokenStore'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'BlobStorageTokenStore'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        token_refresh_extension_hours: Optional[float] = None,
        file_system: Optional["FileSystemTokenStore"] = None,
        azure_blob_storage: Optional["BlobStorageTokenStore"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>true</code>` to durably store platform-specific security tokens
         that are obtained during login flows; otherwise, :code:`<code>false</code>`.
          The default is :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword token_refresh_extension_hours: The number of hours after session token expiration that
         a session token can be used to
         call the token refresh API. The default is 72 hours.
        :paramtype token_refresh_extension_hours: float
        :keyword file_system: The configuration settings of the storage of the tokens if a file system
         is used.
        :paramtype file_system: ~azure.mgmt.web.v2021_01_15.models.FileSystemTokenStore
        :keyword azure_blob_storage: The configuration settings of the storage of the tokens if blob
         storage is used.
        :paramtype azure_blob_storage: ~azure.mgmt.web.v2021_01_15.models.BlobStorageTokenStore
        """
        super(TokenStore, self).__init__(**kwargs)
        self.enabled = enabled
        self.token_refresh_extension_hours = token_refresh_extension_hours
        self.file_system = file_system
        self.azure_blob_storage = azure_blob_storage


class TopLevelDomain(ProxyOnlyResource):
    """A top level domain object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar privacy: If :code:`<code>true</code>`, then the top level domain supports domain privacy;
     otherwise, :code:`<code>false</code>`.
    :vartype privacy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        privacy: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword privacy: If :code:`<code>true</code>`, then the top level domain supports domain
         privacy; otherwise, :code:`<code>false</code>`.
        :paramtype privacy: bool
        """
        super(TopLevelDomain, self).__init__(kind=kind, **kwargs)
        self.privacy = privacy


class TopLevelDomainAgreementOption(msrest.serialization.Model):
    """Options for retrieving the list of top level domain legal agreements.

    :ivar include_privacy: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain privacy as well; otherwise, :code:`<code>false</code>`.
    :vartype include_privacy: bool
    :ivar for_transfer: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain transfer as well; otherwise, :code:`<code>false</code>`.
    :vartype for_transfer: bool
    """

    _attribute_map = {
        'include_privacy': {'key': 'includePrivacy', 'type': 'bool'},
        'for_transfer': {'key': 'forTransfer', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        include_privacy: Optional[bool] = None,
        for_transfer: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword include_privacy: If :code:`<code>true</code>`, then the list of agreements will
         include agreements for domain privacy as well; otherwise, :code:`<code>false</code>`.
        :paramtype include_privacy: bool
        :keyword for_transfer: If :code:`<code>true</code>`, then the list of agreements will include
         agreements for domain transfer as well; otherwise, :code:`<code>false</code>`.
        :paramtype for_transfer: bool
        """
        super(TopLevelDomainAgreementOption, self).__init__(**kwargs)
        self.include_privacy = include_privacy
        self.for_transfer = for_transfer


class TopLevelDomainCollection(msrest.serialization.Model):
    """Collection of Top-level domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.TopLevelDomain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopLevelDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TopLevelDomain"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.TopLevelDomain]
        """
        super(TopLevelDomainCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TriggeredJobHistory(ProxyOnlyResource):
    """Triggered Web Job History. List of Triggered Web Job Run Information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar runs: List of triggered web job runs.
    :vartype runs: list[~azure.mgmt.web.v2021_01_15.models.TriggeredJobRun]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'runs': {'key': 'properties.runs', 'type': '[TriggeredJobRun]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        runs: Optional[List["TriggeredJobRun"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword runs: List of triggered web job runs.
        :paramtype runs: list[~azure.mgmt.web.v2021_01_15.models.TriggeredJobRun]
        """
        super(TriggeredJobHistory, self).__init__(kind=kind, **kwargs)
        self.runs = runs


class TriggeredJobHistoryCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.TriggeredJobHistory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredJobHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TriggeredJobHistory"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.TriggeredJobHistory]
        """
        super(TriggeredJobHistoryCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TriggeredJobRun(ProxyOnlyResource):
    """Triggered Web Job Run Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar web_job_id: Job ID.
    :vartype web_job_id: str
    :ivar web_job_name: Job name.
    :vartype web_job_name: str
    :ivar status: Job status. Possible values include: "Success", "Failed", "Error".
    :vartype status: str or ~azure.mgmt.web.v2021_01_15.models.TriggeredWebJobStatus
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time.
    :vartype end_time: ~datetime.datetime
    :ivar duration: Job duration.
    :vartype duration: str
    :ivar output_url: Output URL.
    :vartype output_url: str
    :ivar error_url: Error URL.
    :vartype error_url: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar job_name: Job name.
    :vartype job_name: str
    :ivar trigger: Job trigger.
    :vartype trigger: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'web_job_id': {'key': 'properties.web_job_id', 'type': 'str'},
        'web_job_name': {'key': 'properties.web_job_name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.end_time', 'type': 'iso-8601'},
        'duration': {'key': 'properties.duration', 'type': 'str'},
        'output_url': {'key': 'properties.output_url', 'type': 'str'},
        'error_url': {'key': 'properties.error_url', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'job_name': {'key': 'properties.job_name', 'type': 'str'},
        'trigger': {'key': 'properties.trigger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        web_job_id: Optional[str] = None,
        web_job_name: Optional[str] = None,
        status: Optional[Union[str, "TriggeredWebJobStatus"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        duration: Optional[str] = None,
        output_url: Optional[str] = None,
        error_url: Optional[str] = None,
        url: Optional[str] = None,
        job_name: Optional[str] = None,
        trigger: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword web_job_id: Job ID.
        :paramtype web_job_id: str
        :keyword web_job_name: Job name.
        :paramtype web_job_name: str
        :keyword status: Job status. Possible values include: "Success", "Failed", "Error".
        :paramtype status: str or ~azure.mgmt.web.v2021_01_15.models.TriggeredWebJobStatus
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time.
        :paramtype end_time: ~datetime.datetime
        :keyword duration: Job duration.
        :paramtype duration: str
        :keyword output_url: Output URL.
        :paramtype output_url: str
        :keyword error_url: Error URL.
        :paramtype error_url: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword job_name: Job name.
        :paramtype job_name: str
        :keyword trigger: Job trigger.
        :paramtype trigger: str
        """
        super(TriggeredJobRun, self).__init__(kind=kind, **kwargs)
        self.web_job_id = web_job_id
        self.web_job_name = web_job_name
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.output_url = output_url
        self.error_url = error_url
        self.url = url
        self.job_name = job_name
        self.trigger = trigger


class TriggeredWebJob(ProxyOnlyResource):
    """Triggered Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar latest_run: Latest job run information.
    :vartype latest_run: ~azure.mgmt.web.v2021_01_15.models.TriggeredJobRun
    :ivar history_url: History URL.
    :vartype history_url: str
    :ivar scheduler_logs_url: Scheduler Logs URL.
    :vartype scheduler_logs_url: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar web_job_type: Job type. Possible values include: "Continuous", "Triggered".
    :vartype web_job_type: str or ~azure.mgmt.web.v2021_01_15.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'latest_run': {'key': 'properties.latest_run', 'type': 'TriggeredJobRun'},
        'history_url': {'key': 'properties.history_url', 'type': 'str'},
        'scheduler_logs_url': {'key': 'properties.scheduler_logs_url', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        latest_run: Optional["TriggeredJobRun"] = None,
        history_url: Optional[str] = None,
        scheduler_logs_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        web_job_type: Optional[Union[str, "WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword latest_run: Latest job run information.
        :paramtype latest_run: ~azure.mgmt.web.v2021_01_15.models.TriggeredJobRun
        :keyword history_url: History URL.
        :paramtype history_url: str
        :keyword scheduler_logs_url: Scheduler Logs URL.
        :paramtype scheduler_logs_url: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword web_job_type: Job type. Possible values include: "Continuous", "Triggered".
        :paramtype web_job_type: str or ~azure.mgmt.web.v2021_01_15.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, any]
        """
        super(TriggeredWebJob, self).__init__(kind=kind, **kwargs)
        self.latest_run = latest_run
        self.history_url = history_url
        self.scheduler_logs_url = scheduler_logs_url
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.web_job_type = web_job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class TriggeredWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.TriggeredWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["TriggeredWebJob"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2021_01_15.models.TriggeredWebJob]
        """
        super(TriggeredWebJobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Twitter(msrest.serialization.Model):
    """The configuration settings of the Twitter provider.

    :ivar enabled: :code:`<code>false</code>` if the Twitter provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Twitter
     provider.
    :vartype registration: ~azure.mgmt.web.v2021_01_15.models.TwitterRegistration
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'TwitterRegistration'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["TwitterRegistration"] = None,
        **kwargs
    ):
        """
        :keyword enabled: :code:`<code>false</code>` if the Twitter provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Twitter
         provider.
        :paramtype registration: ~azure.mgmt.web.v2021_01_15.models.TwitterRegistration
        """
        super(Twitter, self).__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration


class TwitterRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for the Twitter provider.

    :ivar consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype consumer_key: str
    :ivar consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a consumer
     secret of the Twitter
     application used for sign-in.
    :vartype consumer_secret_setting_name: str
    """

    _attribute_map = {
        'consumer_key': {'key': 'consumerKey', 'type': 'str'},
        'consumer_secret_setting_name': {'key': 'consumerSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        consumer_key: Optional[str] = None,
        consumer_secret_setting_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype consumer_key: str
        :keyword consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a
         consumer secret of the Twitter
         application used for sign-in.
        :paramtype consumer_secret_setting_name: str
        """
        super(TwitterRegistration, self).__init__(**kwargs)
        self.consumer_key = consumer_key
        self.consumer_secret_setting_name = consumer_secret_setting_name


class Usage(ProxyOnlyResource):
    """Usage of the quota resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    :ivar resource_name: Name of the quota resource.
    :vartype resource_name: str
    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: long
    :ivar limit: The resource limit.
    :vartype limit: long
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar compute_mode: Compute mode used for this usage. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2021_01_15.models.ComputeModeOptions
    :ivar site_mode: Site mode used for this usage.
    :vartype site_mode: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'resource_name': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'next_reset_time': {'readonly': True},
        'compute_mode': {'readonly': True},
        'site_mode': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'resource_name': {'key': 'properties.resourceName', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'current_value': {'key': 'properties.currentValue', 'type': 'long'},
        'limit': {'key': 'properties.limit', 'type': 'long'},
        'next_reset_time': {'key': 'properties.nextResetTime', 'type': 'iso-8601'},
        'compute_mode': {'key': 'properties.computeMode', 'type': 'str'},
        'site_mode': {'key': 'properties.siteMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(Usage, self).__init__(kind=kind, **kwargs)
        self.display_name = None
        self.resource_name = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.next_reset_time = None
        self.compute_mode = None
        self.site_mode = None


class UsageCollection(msrest.serialization.Model):
    """Collection of usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2021_01_15.models.Usage]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'re