/* automatically generated by rust-bindgen 0.65.1 */


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0


#![allow(unused_imports, non_camel_case_types)]

use libc::{iovec, FILE, off_t};

use crate::api::*;


extern "C" {
    #[doc = " Enables sending using kTLS on a given connection.\n\n See above for the limitations on when kTLS can be enabled. Additionally,\n s2n_connection_ktls_enable_send must be called after the handshake completes.\n It may be called after some application data is sent and received without kTLS,\n but there must be no pending application data that requires flushing. If these\n requirements are not met, enabling kTLS will fail with an error.\n\n After kTLS is enabled for sending, s2n_send, s2n_sendv, and s2n_sendv_with_offset\n will use kTLS. kTLS should result in memory and CPU savings. s2n_sendfile will\n also become available.\n\n For applications using kTLS to avoid copying or allocating memory, s2n_sendv\n should be preferred over s2n_sendv_with_offset. For s2n_sendv_with_offset,\n s2n-tls may need to copy the provided iovec array to apply the offset, and may\n need to allocate memory to copy large (>16) iovec arrays.\n\n If kTLS is enabled for sending, s2n_connection_get_wire_bytes_out will always\n return 0 instead of an accurate count.\n\n @warning Due to the uncertainty around kTLS support, the signature of this\n method is likely to change before kTLS is marked as stable.\n\n @param conn A pointer to the connection.\n @returns S2N_SUCCESS if kTLS is successfully enabled. If kTlS is not successfully\n enabled, returns S2N_FAILURE but the connection may proceed without kTLS."]
    pub fn s2n_connection_ktls_enable_send(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Enables receiving using kTLS on a given connection.\n\n See above for the limitations on when kTLS can be enabled. Additionally,\n s2n_connection_ktls_enable_recv must be called after the handshake completes.\n It may be called after some application data is sent and received without kTLS,\n but there must be no buffered application data that requires draining. If these\n requirements are not met, enabling kTLS will fail with an error.\n\n After kTLS is enabled for receiving, s2n_recv will use kTLS. This may result\n in memory and CPU savings, but currently will still buffer and copy application data.\n We will further optimize s2n_recv for kTLS in the future.\n\n If kTLS is enabled for receiving, s2n_connection_get_wire_bytes_in will always\n return 0 instead of an accurate count.\n\n @warning Due to the uncertainty around kTLS support, the signature of this\n method is likely to change before kTLS is marked as stable.\n\n @param conn A pointer to the connection.\n @returns S2N_SUCCESS if kTLS is successfully enabled. If kTlS is not successfully\n enabled, returns S2N_FAILURE but the connection may proceed without kTLS."]
    pub fn s2n_connection_ktls_enable_recv(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sends the contents of a file as application data.\n\n s2n_sendfile should be more efficient than s2n_send because the copy between\n the file and the write socket happens inside the kernel.\n\n This method is only supported if kTLS is enabled for sending.\n\n @param conn A pointer to the connection.\n @param fd The file descriptor to read from. It must be opened for reading and\n support mmap-like operations (i.e., it cannot be a socket).\n @param offset The offset in the file to begin reading at.\n @param count The maximum number of bytes to read from the file.\n @param bytes_written Will be set to the number of bytes written if successful.\n @param blocked Will be set to the blocked status if an `S2N_ERR_T_BLOCKED` error is returned.\n @returns S2N_SUCCESS if any bytes are successfully written, S2N_FAILURE otherwise."]
    pub fn s2n_sendfile(
        conn: *mut s2n_connection,
        fd: ::libc::c_int,
        offset: off_t,
        count: usize,
        bytes_written: *mut usize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
