.\" @(#)nfsmount.conf.5"
.TH NFSMOUNT.CONF 5 "16 December 2020"
.SH NAME
nfsmount.conf - Configuration file for NFS mounts
.SH SYNOPSIS
Configuration file for NFS mounts that allows options
to be set globally, per server or per mount point.
.SH DESCRIPTION
The configuration file is made up of multiple section headers
followed by variable assignments associated with that section.
A section header is defined by a string enclosed by
.BR [
and
.BR ]
brackets.
Variable assignments are assignment statements that assign values
to particular variables using the
.BR =
operator, as in
.BR Proto=Tcp .
The variables that can be assigned are the set of NFS specific
mount options listed in
.BR nfs (5)
together with the filesystem-independant mount options listed in
.BR mount (8)
and three additions:
.B Sloppy=True
has the same effect as the
.B -s
option to
.IR mount ,
and
.B Foreground=True
and
.B Background=True
have the same effect as
.B bg
and
.BR fg .
.PP
Options in the config file may be given in upper, lower, or mixed case
and will be shifted to lower case before being passed to the filesystem.
.PP
Boolean mount options which do not need an equals sign must be given as
.RI \[dq] option =True".
Instead of preceeding such an option with
.RB \[dq] no \[dq]
its negation must be given as
.RI \[dq] option =False".
.PP
Sections are broken up into three basic categories:
Global options, Server options and Mount Point options.
.HP
.B [ NFSMount_Global_Options ]
- This statically named section
defines all of the global mount options that can be
applied to every NFS mount.
.HP
.B [ Server \[dq]Server_Name\[dq] ]
- This section defines all the mount options that should
be used on mounts to a particular NFS server. The
.I \[dq]Server_Name\[dq]
strings needs to be surrounded by '\[dq]' and be an exact match
(ignoring case) of the server name used in the
.B mount
command.
.HP
.B [ MountPoint \[dq]Mount_Point\[dq] ]
- This section defines all the mount options that
should be used on a particular mount point.
The
.I \[dq]Mount_Point\[dq]
string needs to be surrounded by '\[dq]' and be an
exact match of the mount point used in the
.BR mount
command.  Though path names are usually case-sensitive, the Mount_Point
name is matched insensitive to case.
.PP
The sections are processed in the reverse of the order listed above, and
any options already seen, either in a previous section or on the
command line, will be ignored when seen again.
.SH EXAMPLES
.PP
These are some example lines of how sections and variables
are defined in the configuration file.
.PP
[ NFSMount_Global_Options ]
.br
    Proto=Tcp
.RS
.PP
The TCP/IPv4 protocol will be used on every NFS mount.
.RE
.PP
[ Server \[dq]nfsserver.foo.com\[dq] ]
.br
    rsize=32k
.br
    wsize=32k
.br
    proto=udp6
.RS
.PP
A 32k (32768 bytes) block size will be used as the read and write
size on all mounts to the 'nfsserver.foo.com' server.  UDP/IPv6
is the protocol to be used.
.RE
.PP
[ MountPoint \[dq]/export/home\[dq] ]
.br
    Background=True
.RS
.PP
All mounts to the '/export/home' export will be performed in
the background (i.e. done asynchronously).
.RE
.SH FILES
.TP 10n
.I /etc/nfsmount.conf
Default NFS mount configuration file
.TP 10n
.I /etc/nfsmount.conf.d
When this directory exists and files ending
with ".conf" exist, those files will be
used to set configuration variables. These
files will override variables set
in /etc/nfsmount.conf
.PD
.SH SEE ALSO
.BR nfs (5),
.BR mount (8),
