/**********************************************************************
 * $port_info example -- C source code using VPI PLI routines
 *
 * For the book, "The Verilog PLI Handbook", Chapter 5
 * Copyright 1998, Sutherland HDL Inc, Tualatin Oregon.
 *
 * Verilog test bench to test the $port_info() PLI application.
 *
 *********************************************************************/
`timescale 1ns / 1ns
module test;
  reg  a, b, ci, clk;
  wire sum, co;

  addbit i1 (a, b, ci, sum, co);

  initial
    begin
      #1 $port_info(i1);
      #1 $finish;
    end
endmodule

/*** A gate level 1 bit adder model ***/
`timescale 1ns / 1ns
module addbit (a, b, ci, sum, co);
  input  a, b, ci;
  output sum, co;

  wire  a, b, ci, sum, co,
        n1, n2, n3;

  xor    (n1, a, b);
  xor #2 (sum, n1, ci);
  and    (n2, a, b);
  and    (n3, n1, ci);
  or  #2 (co, n2, n3);
  
  specify
    (a *> sum) = 5;
    (b *> sum, co) = 5;
  endspecify

endmodule
/*********************************************************************/
