# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._file_operations import build_abort_copy_request, build_acquire_lease_request, build_break_lease_request, build_change_lease_request, build_create_request, build_delete_request, build_download_request, build_force_close_handles_request, build_get_properties_request, build_get_range_list_request, build_list_handles_request, build_release_lease_request, build_rename_request, build_set_http_headers_request, build_set_metadata_request, build_start_copy_request, build_upload_range_from_url_request, build_upload_range_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class FileOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.storage.fileshare.aio.AzureFileStorage`'s
        :attr:`file` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        args = list(args)
        self._client = args.pop(0) if args else kwargs.pop("client")
        self._config = args.pop(0) if args else kwargs.pop("config")
        self._serialize = args.pop(0) if args else kwargs.pop("serializer")
        self._deserialize = args.pop(0) if args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def create(  # pylint: disable=inconsistent-return-statements
        self,
        file_content_length: int,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        file_permission: Optional[str] = "inherit",
        file_permission_key: Optional[str] = None,
        file_attributes: str = "none",
        file_creation_time: Optional[str] = "now",
        file_last_write_time: Optional[str] = "now",
        file_change_time: Optional[str] = None,
        file_http_headers: Optional["_models.FileHTTPHeaders"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """Creates a new file or replaces a file. Note it only initializes the file with no content.

        :param file_content_length: Specifies the maximum size for the file, up to 4 TB.
        :type file_content_length: long
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param file_attributes: If specified, the provided file attributes shall be set. Default value:
         ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
         Default value is "none".
        :type file_attributes: str
        :param file_creation_time: Creation time for the file/directory. Default value: Now. Default
         value is "now".
        :type file_creation_time: str
        :param file_last_write_time: Last write time for the file/directory. Default value: Now.
         Default value is "now".
        :type file_last_write_time: str
        :param file_change_time: Change time for the file/directory. Default value: Now. Default value
         is None.
        :type file_change_time: str
        :param file_http_headers: Parameter group. Default value is None.
        :type file_http_headers: ~azure.storage.fileshare.models.FileHTTPHeaders
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword file_type_constant: Dummy constant parameter, file type can only be file. Default
         value is "file". Note that overriding this default value may result in unsupported behavior.
        :paramtype file_type_constant: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        file_type_constant = kwargs.pop('file_type_constant', "file")  # type: str

        _file_content_type = None
        _file_content_encoding = None
        _file_content_language = None
        _file_cache_control = None
        _file_content_md5 = None
        _file_content_disposition = None
        _lease_id = None
        if file_http_headers is not None:
            _file_content_type = file_http_headers.file_content_type
            _file_content_encoding = file_http_headers.file_content_encoding
            _file_content_language = file_http_headers.file_content_language
            _file_cache_control = file_http_headers.file_cache_control
            _file_content_md5 = file_http_headers.file_content_md5
            _file_content_disposition = file_http_headers.file_content_disposition
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_create_request(
            url=self._config.url,
            version=self._config.version,
            file_type_constant=file_type_constant,
            file_content_length=file_content_length,
            timeout=timeout,
            file_content_type=_file_content_type,
            file_content_encoding=_file_content_encoding,
            file_content_language=_file_content_language,
            file_cache_control=_file_cache_control,
            file_content_md5=_file_content_md5,
            file_content_disposition=_file_content_disposition,
            metadata=metadata,
            file_permission=file_permission,
            file_permission_key=file_permission_key,
            file_attributes=file_attributes,
            file_creation_time=file_creation_time,
            file_last_write_time=file_last_write_time,
            file_change_time=file_change_time,
            lease_id=_lease_id,
            template_url=self.create.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
        response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
        response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
        response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
        response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
        response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    create.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def download(
        self,
        timeout: Optional[int] = None,
        range: Optional[str] = None,
        range_get_content_md5: Optional[bool] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> IO:
        """Reads or downloads a file from the system, including its metadata and properties.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param range: Return file data only from the specified byte range. Default value is None.
        :type range: str
        :param range_get_content_md5: When this header is set to true and specified together with the
         Range header, the service returns the MD5 hash for the range, as long as the range is less than
         or equal to 4 MB in size. Default value is None.
        :type range_get_content_md5: bool
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IO, or the result of cls(response)
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[IO]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_download_request(
            url=self._config.url,
            version=self._config.version,
            timeout=timeout,
            range=range,
            range_get_content_md5=range_get_content_md5,
            lease_id=_lease_id,
            template_url=self.download.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=True,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-meta']=self._deserialize('{str}', response.headers.get('x-ms-meta'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
            response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
            response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
            response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
            response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
            response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
            response_headers['x-ms-content-md5']=self._deserialize('bytearray', response.headers.get('x-ms-content-md5'))
            response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
            response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
            response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
            response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
            response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
            response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
            response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
            response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            
            deserialized = response.stream_download(self._client._pipeline)

        if response.status_code == 206:
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-meta']=self._deserialize('{str}', response.headers.get('x-ms-meta'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
            response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
            response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
            response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
            response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
            response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
            response_headers['x-ms-content-md5']=self._deserialize('bytearray', response.headers.get('x-ms-content-md5'))
            response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
            response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
            response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
            response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
            response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
            response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
            response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
            response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            
            deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    download.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def get_properties(  # pylint: disable=inconsistent-return-statements
        self,
        sharesnapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """Returns all user-defined metadata, standard HTTP properties, and system properties for the
        file. It does not return the content of the file.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_properties_request(
            url=self._config.url,
            version=self._config.version,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            lease_id=_lease_id,
            template_url=self.get_properties.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-meta']=self._deserialize('{str}', response.headers.get('x-ms-meta'))
        response_headers['x-ms-type']=self._deserialize('str', response.headers.get('x-ms-type'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
        response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
        response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
        response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
        response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
        response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
        response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
        response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
        response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
        response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
        response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
        response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
        response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
        response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
        response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
        response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))
        response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
        response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
        response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    get_properties.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """removes the file from the storage account.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_delete_request(
            url=self._config.url,
            version=self._config.version,
            timeout=timeout,
            lease_id=_lease_id,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    delete.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def set_http_headers(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        file_content_length: Optional[int] = None,
        file_permission: Optional[str] = "inherit",
        file_permission_key: Optional[str] = None,
        file_attributes: str = "none",
        file_creation_time: Optional[str] = "now",
        file_last_write_time: Optional[str] = "now",
        file_change_time: Optional[str] = None,
        file_http_headers: Optional["_models.FileHTTPHeaders"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """Sets HTTP headers on the file.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param file_content_length: Resizes a file to the specified size. If the specified byte value
         is less than the current size of the file, then all ranges above the specified byte value are
         cleared. Default value is None.
        :type file_content_length: long
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param file_attributes: If specified, the provided file attributes shall be set. Default value:
         ‘Archive’ for file and ‘Directory’ for directory. ‘None’ can also be specified as default.
         Default value is "none".
        :type file_attributes: str
        :param file_creation_time: Creation time for the file/directory. Default value: Now. Default
         value is "now".
        :type file_creation_time: str
        :param file_last_write_time: Last write time for the file/directory. Default value: Now.
         Default value is "now".
        :type file_last_write_time: str
        :param file_change_time: Change time for the file/directory. Default value: Now. Default value
         is None.
        :type file_change_time: str
        :param file_http_headers: Parameter group. Default value is None.
        :type file_http_headers: ~azure.storage.fileshare.models.FileHTTPHeaders
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "properties". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "properties")  # type: str

        _file_content_type = None
        _file_content_encoding = None
        _file_content_language = None
        _file_cache_control = None
        _file_content_md5 = None
        _file_content_disposition = None
        _lease_id = None
        if file_http_headers is not None:
            _file_content_type = file_http_headers.file_content_type
            _file_content_encoding = file_http_headers.file_content_encoding
            _file_content_language = file_http_headers.file_content_language
            _file_cache_control = file_http_headers.file_cache_control
            _file_content_md5 = file_http_headers.file_content_md5
            _file_content_disposition = file_http_headers.file_content_disposition
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_set_http_headers_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            timeout=timeout,
            file_content_length=file_content_length,
            file_content_type=_file_content_type,
            file_content_encoding=_file_content_encoding,
            file_content_language=_file_content_language,
            file_cache_control=_file_cache_control,
            file_content_md5=_file_content_md5,
            file_content_disposition=_file_content_disposition,
            file_permission=file_permission,
            file_permission_key=file_permission_key,
            file_attributes=file_attributes,
            file_creation_time=file_creation_time,
            file_last_write_time=file_last_write_time,
            file_change_time=file_change_time,
            lease_id=_lease_id,
            template_url=self.set_http_headers.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
        response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
        response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
        response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
        response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
        response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    set_http_headers.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def set_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """Updates user-defined metadata for the specified file.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "metadata". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "metadata")  # type: str

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_set_metadata_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            timeout=timeout,
            metadata=metadata,
            lease_id=_lease_id,
            template_url=self.set_metadata.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    set_metadata.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def acquire_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """[Update] The Lease File operation establishes and manages a lock on a file for write and delete
        operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param duration: Specifies the duration of the lease, in seconds, or negative one (-1) for a
         lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease
         duration cannot be changed using renew or change. Default value is None.
        :type duration: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "acquire". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "lease")  # type: str
        action = kwargs.pop('action', "acquire")  # type: str

        
        request = build_acquire_lease_request(
            url=self._config.url,
            comp=comp,
            action=action,
            version=self._config.version,
            timeout=timeout,
            duration=duration,
            proposed_lease_id=proposed_lease_id,
            request_id_parameter=request_id_parameter,
            template_url=self.acquire_lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    acquire_lease.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def release_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """[Update] The Lease File operation establishes and manages a lock on a file for write and delete
        operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "release". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "lease")  # type: str
        action = kwargs.pop('action', "release")  # type: str

        
        request = build_release_lease_request(
            url=self._config.url,
            comp=comp,
            action=action,
            version=self._config.version,
            lease_id=lease_id,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            template_url=self.release_lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    release_lease.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def change_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """[Update] The Lease File operation establishes and manages a lock on a file for write and delete
        operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "change". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "lease")  # type: str
        action = kwargs.pop('action', "change")  # type: str

        
        request = build_change_lease_request(
            url=self._config.url,
            comp=comp,
            action=action,
            version=self._config.version,
            lease_id=lease_id,
            timeout=timeout,
            proposed_lease_id=proposed_lease_id,
            request_id_parameter=request_id_parameter,
            template_url=self.change_lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    change_lease.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def break_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """[Update] The Lease File operation establishes and manages a lock on a file for write and delete
        operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "break". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "lease")  # type: str
        action = kwargs.pop('action', "break")  # type: str

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_break_lease_request(
            url=self._config.url,
            comp=comp,
            action=action,
            version=self._config.version,
            timeout=timeout,
            lease_id=_lease_id,
            request_id_parameter=request_id_parameter,
            template_url=self.break_lease.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    break_lease.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def upload_range(  # pylint: disable=inconsistent-return-statements
        self,
        range: str,
        content_length: int,
        timeout: Optional[int] = None,
        file_range_write: Union[str, "_models.FileRangeWriteType"] = "update",
        content_md5: Optional[bytearray] = None,
        file_last_written_mode: Optional[Union[str, "_models.FileLastWrittenMode"]] = None,
        optionalbody: Optional[IO] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """Upload a range of bytes to a file.

        :param range: Specifies the range of bytes to be written. Both the start and end of the range
         must be specified. For an update operation, the range can be up to 4 MB in size. For a clear
         operation, the range can be up to the value of the file's full size. The File service accepts
         only a single byte range for the Range and 'x-ms-range' headers, and the byte range must be
         specified in the following format: bytes=startByte-endByte.
        :type range: str
        :param content_length: Specifies the number of bytes being transmitted in the request body.
         When the x-ms-write header is set to clear, the value of this header must be set to zero.
        :type content_length: long
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param file_range_write: Specify one of the following options: - Update: Writes the bytes
         specified by the request body into the specified range. The Range and Content-Length headers
         must match to perform the update. - Clear: Clears the specified range and releases the space
         used in storage for that range. To clear a range, set the Content-Length header to zero, and
         set the Range header to a value that indicates the range to clear, up to maximum file size.
         Default value is "update".
        :type file_range_write: str or ~azure.storage.fileshare.models.FileRangeWriteType
        :param content_md5: An MD5 hash of the content. This hash is used to verify the integrity of
         the data during transport. When the Content-MD5 header is specified, the File service compares
         the hash of the content that has arrived with the header value that was sent. If the two hashes
         do not match, the operation will fail with error code 400 (Bad Request). Default value is None.
        :type content_md5: bytearray
        :param file_last_written_mode: If the file last write time should be preserved or overwritten.
         Default value is None.
        :type file_last_written_mode: str or ~azure.storage.fileshare.models.FileLastWrittenMode
        :param optionalbody: Initial data. Default value is None.
        :type optionalbody: IO
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "range". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "range")  # type: str
        content_type = kwargs.pop('content_type', "application/octet-stream")  # type: Optional[str]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        _content = optionalbody

        request = build_upload_range_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            content_type=content_type,
            range=range,
            content_length=content_length,
            content=_content,
            timeout=timeout,
            file_range_write=file_range_write,
            content_md5=content_md5,
            lease_id=_lease_id,
            file_last_written_mode=file_last_written_mode,
            template_url=self.upload_range.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    upload_range.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def upload_range_from_url(  # pylint: disable=inconsistent-return-statements
        self,
        range: str,
        copy_source: str,
        content_length: int,
        timeout: Optional[int] = None,
        source_range: Optional[str] = None,
        source_content_crc64: Optional[bytearray] = None,
        copy_source_authorization: Optional[str] = None,
        file_last_written_mode: Optional[Union[str, "_models.FileLastWrittenMode"]] = None,
        source_modified_access_conditions: Optional["_models.SourceModifiedAccessConditions"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """Upload a range of bytes to a file where the contents are read from a URL.

        :param range: Writes data to the specified byte range in the file.
        :type range: str
        :param copy_source: Specifies the URL of the source file or blob, up to 2 KB in length. To copy
         a file to another file within the same storage account, you may use Shared Key to authenticate
         the source file. If you are copying a file from another storage account, or if you are copying
         a blob from the same storage account or another storage account, then you must authenticate the
         source file or blob using a shared access signature. If the source is a public blob, no
         authentication is required to perform the copy operation. A file in a share snapshot can also
         be specified as a copy source.
        :type copy_source: str
        :param content_length: Specifies the number of bytes being transmitted in the request body.
         When the x-ms-write header is set to clear, the value of this header must be set to zero.
        :type content_length: long
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param source_range: Bytes of source data in the specified range. Default value is None.
        :type source_range: str
        :param source_content_crc64: Specify the crc64 calculated for the range of bytes that must be
         read from the copy source. Default value is None.
        :type source_content_crc64: bytearray
        :param copy_source_authorization: Only Bearer type is supported. Credentials should be a valid
         OAuth access token to copy source. Default value is None.
        :type copy_source_authorization: str
        :param file_last_written_mode: If the file last write time should be preserved or overwritten.
         Default value is None.
        :type file_last_written_mode: str or ~azure.storage.fileshare.models.FileLastWrittenMode
        :param source_modified_access_conditions: Parameter group. Default value is None.
        :type source_modified_access_conditions:
         ~azure.storage.fileshare.models.SourceModifiedAccessConditions
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "range". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "range")  # type: str

        _source_if_match_crc64 = None
        _source_if_none_match_crc64 = None
        _lease_id = None
        if source_modified_access_conditions is not None:
            _source_if_match_crc64 = source_modified_access_conditions.source_if_match_crc64
            _source_if_none_match_crc64 = source_modified_access_conditions.source_if_none_match_crc64
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_upload_range_from_url_request(
            url=self._config.url,
            comp=comp,
            file_range_write_from_url=self._config.file_range_write_from_url,
            version=self._config.version,
            range=range,
            copy_source=copy_source,
            content_length=content_length,
            timeout=timeout,
            source_range=source_range,
            source_content_crc64=source_content_crc64,
            source_if_match_crc64=_source_if_match_crc64,
            source_if_none_match_crc64=_source_if_none_match_crc64,
            lease_id=_lease_id,
            copy_source_authorization=copy_source_authorization,
            file_last_written_mode=file_last_written_mode,
            template_url=self.upload_range_from_url.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    upload_range_from_url.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def get_range_list(
        self,
        sharesnapshot: Optional[str] = None,
        prevsharesnapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        range: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> "_models.ShareFileRangeList":
        """Returns the list of valid ranges for a file.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param prevsharesnapshot: The previous snapshot parameter is an opaque DateTime value that,
         when present, specifies the previous snapshot. Default value is None.
        :type prevsharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param range: Specifies the range of bytes over which to list ranges, inclusively. Default
         value is None.
        :type range: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "rangelist". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ShareFileRangeList, or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ShareFileRangeList
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ShareFileRangeList"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "rangelist")  # type: str

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_range_list_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            sharesnapshot=sharesnapshot,
            prevsharesnapshot=prevsharesnapshot,
            timeout=timeout,
            range=range,
            lease_id=_lease_id,
            template_url=self.get_range_list.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['x-ms-content-length']=self._deserialize('long', response.headers.get('x-ms-content-length'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('ShareFileRangeList', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_range_list.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def start_copy(  # pylint: disable=inconsistent-return-statements
        self,
        copy_source: str,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        file_permission: Optional[str] = "inherit",
        file_permission_key: Optional[str] = None,
        copy_file_smb_info: Optional["_models.CopyFileSmbInfo"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """Copies a blob or file to a destination file within the storage account.

        :param copy_source: Specifies the URL of the source file or blob, up to 2 KB in length. To copy
         a file to another file within the same storage account, you may use Shared Key to authenticate
         the source file. If you are copying a file from another storage account, or if you are copying
         a blob from the same storage account or another storage account, then you must authenticate the
         source file or blob using a shared access signature. If the source is a public blob, no
         authentication is required to perform the copy operation. A file in a share snapshot can also
         be specified as a copy source.
        :type copy_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param copy_file_smb_info: Parameter group. Default value is None.
        :type copy_file_smb_info: ~azure.storage.fileshare.models.CopyFileSmbInfo
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _file_permission_copy_mode = None
        _ignore_read_only = None
        _file_attributes = None
        _file_creation_time = None
        _file_last_write_time = None
        _file_change_time = None
        _set_archive_attribute = None
        _lease_id = None
        if copy_file_smb_info is not None:
            _file_permission_copy_mode = copy_file_smb_info.file_permission_copy_mode
            _ignore_read_only = copy_file_smb_info.ignore_read_only
            _file_attributes = copy_file_smb_info.file_attributes
            _file_creation_time = copy_file_smb_info.file_creation_time
            _file_last_write_time = copy_file_smb_info.file_last_write_time
            _file_change_time = copy_file_smb_info.file_change_time
            _set_archive_attribute = copy_file_smb_info.set_archive_attribute
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_start_copy_request(
            url=self._config.url,
            version=self._config.version,
            copy_source=copy_source,
            timeout=timeout,
            metadata=metadata,
            file_permission=file_permission,
            file_permission_key=file_permission_key,
            file_permission_copy_mode=_file_permission_copy_mode,
            ignore_read_only=_ignore_read_only,
            file_attributes=_file_attributes,
            file_creation_time=_file_creation_time,
            file_last_write_time=_file_last_write_time,
            file_change_time=_file_change_time,
            set_archive_attribute=_set_archive_attribute,
            lease_id=_lease_id,
            template_url=self.start_copy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
        response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    start_copy.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def abort_copy(  # pylint: disable=inconsistent-return-statements
        self,
        copy_id: str,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs: Any
    ) -> None:
        """Aborts a pending Copy File operation, and leaves a destination file with zero length and full
        metadata.

        :param copy_id: The copy identifier provided in the x-ms-copy-id header of the original Copy
         File operation.
        :type copy_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "copy". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword copy_action_abort_constant: Abort. Default value is "abort". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype copy_action_abort_constant: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "copy")  # type: str
        copy_action_abort_constant = kwargs.pop('copy_action_abort_constant', "abort")  # type: str

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_abort_copy_request(
            url=self._config.url,
            comp=comp,
            copy_action_abort_constant=copy_action_abort_constant,
            version=self._config.version,
            copy_id=copy_id,
            timeout=timeout,
            lease_id=_lease_id,
            template_url=self.abort_copy.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    abort_copy.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def list_handles(
        self,
        marker: Optional[str] = None,
        maxresults: Optional[int] = None,
        timeout: Optional[int] = None,
        sharesnapshot: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.ListHandlesResponse":
        """Lists handles for file.

        :param marker: A string value that identifies the portion of the list to be returned with the
         next list operation. The operation returns a marker value within the response body if the list
         returned was not complete. The marker value may then be used in a subsequent call to request
         the next set of list items. The marker value is opaque to the client. Default value is None.
        :type marker: str
        :param maxresults: Specifies the maximum number of entries to return. If the request does not
         specify maxresults, or specifies a value greater than 5,000, the server will return up to 5,000
         items. Default value is None.
        :type maxresults: int
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :keyword comp: comp. Default value is "listhandles". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ListHandlesResponse, or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ListHandlesResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ListHandlesResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "listhandles")  # type: str

        
        request = build_list_handles_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            marker=marker,
            maxresults=maxresults,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            template_url=self.list_handles.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        deserialized = self._deserialize('ListHandlesResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    list_handles.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def force_close_handles(  # pylint: disable=inconsistent-return-statements
        self,
        handle_id: str,
        timeout: Optional[int] = None,
        marker: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Closes all handles open for given file.

        :param handle_id: Specifies handle ID opened on the file or directory to be closed. Asterisk
         (‘*’) is a wildcard that specifies all handles.
        :type handle_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param marker: A string value that identifies the portion of the list to be returned with the
         next list operation. The operation returns a marker value within the response body if the list
         returned was not complete. The marker value may then be used in a subsequent call to request
         the next set of list items. The marker value is opaque to the client. Default value is None.
        :type marker: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :keyword comp: comp. Default value is "forceclosehandles". Note that overriding this default
         value may result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "forceclosehandles")  # type: str

        
        request = build_force_close_handles_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            handle_id=handle_id,
            timeout=timeout,
            marker=marker,
            sharesnapshot=sharesnapshot,
            template_url=self.force_close_handles.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-marker']=self._deserialize('str', response.headers.get('x-ms-marker'))
        response_headers['x-ms-number-of-handles-closed']=self._deserialize('int', response.headers.get('x-ms-number-of-handles-closed'))
        response_headers['x-ms-number-of-handles-failed']=self._deserialize('int', response.headers.get('x-ms-number-of-handles-failed'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    force_close_handles.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore


    @distributed_trace_async
    async def rename(  # pylint: disable=inconsistent-return-statements
        self,
        rename_source: str,
        timeout: Optional[int] = None,
        replace_if_exists: Optional[bool] = None,
        ignore_read_only: Optional[bool] = None,
        file_permission: Optional[str] = "inherit",
        file_permission_key: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        source_lease_access_conditions: Optional["_models.SourceLeaseAccessConditions"] = None,
        destination_lease_access_conditions: Optional["_models.DestinationLeaseAccessConditions"] = None,
        copy_file_smb_info: Optional["_models.CopyFileSmbInfo"] = None,
        file_http_headers: Optional["_models.FileHTTPHeaders"] = None,
        **kwargs: Any
    ) -> None:
        """Renames a file.

        :param rename_source: Required. Specifies the URI-style path of the source file, up to 2 KB in
         length.
        :type rename_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param replace_if_exists: Optional. A boolean value for if the destination file already exists,
         whether this request will overwrite the file or not. If true, the rename will succeed and will
         overwrite the destination file. If not provided or if false and the destination file does
         exist, the request will not overwrite the destination file. If provided and the destination
         file doesn’t exist, the rename will succeed. Note: This value does not override the
         x-ms-file-copy-ignore-read-only header value. Default value is None.
        :type replace_if_exists: bool
        :param ignore_read_only: Optional. A boolean value that specifies whether the ReadOnly
         attribute on a preexisting destination file should be respected. If true, the rename will
         succeed, otherwise, a previous file at the destination with the ReadOnly attribute set will
         cause the rename to fail. Default value is None.
        :type ignore_read_only: bool
        :param file_permission: If specified the permission (security descriptor) shall be set for the
         directory/file. This header can be used if Permission size is <= 8KB, else
         x-ms-file-permission-key header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified. Default value is "inherit".
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the directory/file. Note: Only
         one of the x-ms-file-permission or x-ms-file-permission-key should be specified. Default value
         is None.
        :type file_permission_key: str
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param source_lease_access_conditions: Parameter group. Default value is None.
        :type source_lease_access_conditions:
         ~azure.storage.fileshare.models.SourceLeaseAccessConditions
        :param destination_lease_access_conditions: Parameter group. Default value is None.
        :type destination_lease_access_conditions:
         ~azure.storage.fileshare.models.DestinationLeaseAccessConditions
        :param copy_file_smb_info: Parameter group. Default value is None.
        :type copy_file_smb_info: ~azure.storage.fileshare.models.CopyFileSmbInfo
        :param file_http_headers: Parameter group. Default value is None.
        :type file_http_headers: ~azure.storage.fileshare.models.FileHTTPHeaders
        :keyword comp: comp. Default value is "rename". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        comp = kwargs.pop('comp', "rename")  # type: str

        _source_lease_id = None
        _destination_lease_id = None
        _file_attributes = None
        _file_creation_time = None
        _file_last_write_time = None
        _file_change_time = None
        _file_content_type = None
        if source_lease_access_conditions is not None:
            _source_lease_id = source_lease_access_conditions.source_lease_id
        if destination_lease_access_conditions is not None:
            _destination_lease_id = destination_lease_access_conditions.destination_lease_id
        if copy_file_smb_info is not None:
            _file_attributes = copy_file_smb_info.file_attributes
            _file_creation_time = copy_file_smb_info.file_creation_time
            _file_last_write_time = copy_file_smb_info.file_last_write_time
            _file_change_time = copy_file_smb_info.file_change_time
        if file_http_headers is not None:
            _file_content_type = file_http_headers.file_content_type

        request = build_rename_request(
            url=self._config.url,
            comp=comp,
            version=self._config.version,
            rename_source=rename_source,
            timeout=timeout,
            replace_if_exists=replace_if_exists,
            ignore_read_only=ignore_read_only,
            source_lease_id=_source_lease_id,
            destination_lease_id=_destination_lease_id,
            file_attributes=_file_attributes,
            file_creation_time=_file_creation_time,
            file_last_write_time=_file_last_write_time,
            file_change_time=_file_change_time,
            file_permission=file_permission,
            file_permission_key=file_permission_key,
            metadata=metadata,
            file_content_type=_file_content_type,
            template_url=self.rename.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-file-permission-key']=self._deserialize('str', response.headers.get('x-ms-file-permission-key'))
        response_headers['x-ms-file-attributes']=self._deserialize('str', response.headers.get('x-ms-file-attributes'))
        response_headers['x-ms-file-creation-time']=self._deserialize('str', response.headers.get('x-ms-file-creation-time'))
        response_headers['x-ms-file-last-write-time']=self._deserialize('str', response.headers.get('x-ms-file-last-write-time'))
        response_headers['x-ms-file-change-time']=self._deserialize('str', response.headers.get('x-ms-file-change-time'))
        response_headers['x-ms-file-id']=self._deserialize('str', response.headers.get('x-ms-file-id'))
        response_headers['x-ms-file-parent-id']=self._deserialize('str', response.headers.get('x-ms-file-parent-id'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    rename.metadata = {'url': "{url}/{shareName}/{directory}/{fileName}"}  # type: ignore

