# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._policy_client_enums import *


class Alias(msrest.serialization.Model):
    """The alias type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The alias name.
    :vartype name: str
    :ivar paths: The paths for an alias.
    :vartype paths: list[~azure.mgmt.resource.policy.v2021_06_01.models.AliasPath]
    :ivar type: The type of the alias. Possible values include: "NotSpecified", "PlainText",
     "Mask".
    :vartype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.AliasType
    :ivar default_path: The default path for an alias.
    :vartype default_path: str
    :ivar default_pattern: The default pattern for an alias.
    :vartype default_pattern: ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPattern
    :ivar default_metadata: The default alias path metadata. Applies to the default path and to any
     alias path that doesn't have metadata.
    :vartype default_metadata: ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPathMetadata
    """

    _validation = {
        'default_metadata': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'paths': {'key': 'paths', 'type': '[AliasPath]'},
        'type': {'key': 'type', 'type': 'str'},
        'default_path': {'key': 'defaultPath', 'type': 'str'},
        'default_pattern': {'key': 'defaultPattern', 'type': 'AliasPattern'},
        'default_metadata': {'key': 'defaultMetadata', 'type': 'AliasPathMetadata'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        paths: Optional[List["AliasPath"]] = None,
        type: Optional[Union[str, "AliasType"]] = None,
        default_path: Optional[str] = None,
        default_pattern: Optional["AliasPattern"] = None,
        **kwargs
    ):
        """
        :keyword name: The alias name.
        :paramtype name: str
        :keyword paths: The paths for an alias.
        :paramtype paths: list[~azure.mgmt.resource.policy.v2021_06_01.models.AliasPath]
        :keyword type: The type of the alias. Possible values include: "NotSpecified", "PlainText",
         "Mask".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.AliasType
        :keyword default_path: The default path for an alias.
        :paramtype default_path: str
        :keyword default_pattern: The default pattern for an alias.
        :paramtype default_pattern: ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPattern
        """
        super(Alias, self).__init__(**kwargs)
        self.name = name
        self.paths = paths
        self.type = type
        self.default_path = default_path
        self.default_pattern = default_pattern
        self.default_metadata = None


class AliasPath(msrest.serialization.Model):
    """The type of the paths for alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar path: The path of an alias.
    :vartype path: str
    :ivar api_versions: The API versions.
    :vartype api_versions: list[str]
    :ivar pattern: The pattern for an alias path.
    :vartype pattern: ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPattern
    :ivar metadata: The metadata of the alias path. If missing, fall back to the default metadata
     of the alias.
    :vartype metadata: ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPathMetadata
    """

    _validation = {
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'pattern': {'key': 'pattern', 'type': 'AliasPattern'},
        'metadata': {'key': 'metadata', 'type': 'AliasPathMetadata'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        api_versions: Optional[List[str]] = None,
        pattern: Optional["AliasPattern"] = None,
        **kwargs
    ):
        """
        :keyword path: The path of an alias.
        :paramtype path: str
        :keyword api_versions: The API versions.
        :paramtype api_versions: list[str]
        :keyword pattern: The pattern for an alias path.
        :paramtype pattern: ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPattern
        """
        super(AliasPath, self).__init__(**kwargs)
        self.path = path
        self.api_versions = api_versions
        self.pattern = pattern
        self.metadata = None


class AliasPathMetadata(msrest.serialization.Model):
    """AliasPathMetadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the token that the alias path is referring to. Possible values include:
     "NotSpecified", "Any", "String", "Object", "Array", "Integer", "Number", "Boolean".
    :vartype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPathTokenType
    :ivar attributes: The attributes of the token that the alias path is referring to. Possible
     values include: "None", "Modifiable".
    :vartype attributes: str or ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPathAttributes
    """

    _validation = {
        'type': {'readonly': True},
        'attributes': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AliasPathMetadata, self).__init__(**kwargs)
        self.type = None
        self.attributes = None


class AliasPattern(msrest.serialization.Model):
    """The type of the pattern for an alias path.

    :ivar phrase: The alias pattern phrase.
    :vartype phrase: str
    :ivar variable: The alias pattern variable.
    :vartype variable: str
    :ivar type: The type of alias pattern. Possible values include: "NotSpecified", "Extract".
    :vartype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPatternType
    """

    _attribute_map = {
        'phrase': {'key': 'phrase', 'type': 'str'},
        'variable': {'key': 'variable', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        phrase: Optional[str] = None,
        variable: Optional[str] = None,
        type: Optional[Union[str, "AliasPatternType"]] = None,
        **kwargs
    ):
        """
        :keyword phrase: The alias pattern phrase.
        :paramtype phrase: str
        :keyword variable: The alias pattern variable.
        :paramtype variable: str
        :keyword type: The type of alias pattern. Possible values include: "NotSpecified", "Extract".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.AliasPatternType
        """
        super(AliasPattern, self).__init__(**kwargs)
        self.phrase = phrase
        self.variable = variable
        self.type = type


class DataEffect(msrest.serialization.Model):
    """The data effect definition.

    :ivar name: The data effect name.
    :vartype name: str
    :ivar details_schema: The data effect details schema.
    :vartype details_schema: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'details_schema': {'key': 'detailsSchema', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        details_schema: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword name: The data effect name.
        :paramtype name: str
        :keyword details_schema: The data effect details schema.
        :paramtype details_schema: any
        """
        super(DataEffect, self).__init__(**kwargs)
        self.name = name
        self.details_schema = details_schema


class DataManifestCustomResourceFunctionDefinition(msrest.serialization.Model):
    """The custom resource function definition.

    :ivar name: The function name as it will appear in the policy rule. eg - 'vault'.
    :vartype name: str
    :ivar fully_qualified_resource_type: The fully qualified control plane resource type that this
     function represents. eg - 'Microsoft.KeyVault/vaults'.
    :vartype fully_qualified_resource_type: str
    :ivar default_properties: The top-level properties that can be selected on the function's
     output. eg - [ "name", "location" ] if vault().name and vault().location are supported.
    :vartype default_properties: list[str]
    :ivar allow_custom_properties: A value indicating whether the custom properties within the
     property bag are allowed. Needs api-version to be specified in the policy rule eg -
     vault('2019-06-01').
    :vartype allow_custom_properties: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'fully_qualified_resource_type': {'key': 'fullyQualifiedResourceType', 'type': 'str'},
        'default_properties': {'key': 'defaultProperties', 'type': '[str]'},
        'allow_custom_properties': {'key': 'allowCustomProperties', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        fully_qualified_resource_type: Optional[str] = None,
        default_properties: Optional[List[str]] = None,
        allow_custom_properties: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: The function name as it will appear in the policy rule. eg - 'vault'.
        :paramtype name: str
        :keyword fully_qualified_resource_type: The fully qualified control plane resource type that
         this function represents. eg - 'Microsoft.KeyVault/vaults'.
        :paramtype fully_qualified_resource_type: str
        :keyword default_properties: The top-level properties that can be selected on the function's
         output. eg - [ "name", "location" ] if vault().name and vault().location are supported.
        :paramtype default_properties: list[str]
        :keyword allow_custom_properties: A value indicating whether the custom properties within the
         property bag are allowed. Needs api-version to be specified in the policy rule eg -
         vault('2019-06-01').
        :paramtype allow_custom_properties: bool
        """
        super(DataManifestCustomResourceFunctionDefinition, self).__init__(**kwargs)
        self.name = name
        self.fully_qualified_resource_type = fully_qualified_resource_type
        self.default_properties = default_properties
        self.allow_custom_properties = allow_custom_properties


class DataPolicyManifest(msrest.serialization.Model):
    """The data policy manifest.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the data policy manifest.
    :vartype id: str
    :ivar name: The name of the data policy manifest (it's the same as the Policy Mode).
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/dataPolicyManifests).
    :vartype type: str
    :ivar namespaces: The list of namespaces for the data policy manifest.
    :vartype namespaces: list[str]
    :ivar policy_mode: The policy mode of the data policy manifest.
    :vartype policy_mode: str
    :ivar is_built_in_only: A value indicating whether policy mode is allowed only in built-in
     definitions.
    :vartype is_built_in_only: bool
    :ivar resource_type_aliases: An array of resource type aliases.
    :vartype resource_type_aliases:
     list[~azure.mgmt.resource.policy.v2021_06_01.models.ResourceTypeAliases]
    :ivar effects: The effect definition.
    :vartype effects: list[~azure.mgmt.resource.policy.v2021_06_01.models.DataEffect]
    :ivar field_values: The non-alias field accessor values that can be used in the policy rule.
    :vartype field_values: list[str]
    :ivar standard: The standard resource functions (subscription and/or resourceGroup).
    :vartype standard: list[str]
    :ivar custom: An array of data manifest custom resource definition.
    :vartype custom:
     list[~azure.mgmt.resource.policy.v2021_06_01.models.DataManifestCustomResourceFunctionDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'namespaces': {'key': 'properties.namespaces', 'type': '[str]'},
        'policy_mode': {'key': 'properties.policyMode', 'type': 'str'},
        'is_built_in_only': {'key': 'properties.isBuiltInOnly', 'type': 'bool'},
        'resource_type_aliases': {'key': 'properties.resourceTypeAliases', 'type': '[ResourceTypeAliases]'},
        'effects': {'key': 'properties.effects', 'type': '[DataEffect]'},
        'field_values': {'key': 'properties.fieldValues', 'type': '[str]'},
        'standard': {'key': 'properties.resourceFunctions.standard', 'type': '[str]'},
        'custom': {'key': 'properties.resourceFunctions.custom', 'type': '[DataManifestCustomResourceFunctionDefinition]'},
    }

    def __init__(
        self,
        *,
        namespaces: Optional[List[str]] = None,
        policy_mode: Optional[str] = None,
        is_built_in_only: Optional[bool] = None,
        resource_type_aliases: Optional[List["ResourceTypeAliases"]] = None,
        effects: Optional[List["DataEffect"]] = None,
        field_values: Optional[List[str]] = None,
        standard: Optional[List[str]] = None,
        custom: Optional[List["DataManifestCustomResourceFunctionDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword namespaces: The list of namespaces for the data policy manifest.
        :paramtype namespaces: list[str]
        :keyword policy_mode: The policy mode of the data policy manifest.
        :paramtype policy_mode: str
        :keyword is_built_in_only: A value indicating whether policy mode is allowed only in built-in
         definitions.
        :paramtype is_built_in_only: bool
        :keyword resource_type_aliases: An array of resource type aliases.
        :paramtype resource_type_aliases:
         list[~azure.mgmt.resource.policy.v2021_06_01.models.ResourceTypeAliases]
        :keyword effects: The effect definition.
        :paramtype effects: list[~azure.mgmt.resource.policy.v2021_06_01.models.DataEffect]
        :keyword field_values: The non-alias field accessor values that can be used in the policy rule.
        :paramtype field_values: list[str]
        :keyword standard: The standard resource functions (subscription and/or resourceGroup).
        :paramtype standard: list[str]
        :keyword custom: An array of data manifest custom resource definition.
        :paramtype custom:
         list[~azure.mgmt.resource.policy.v2021_06_01.models.DataManifestCustomResourceFunctionDefinition]
        """
        super(DataPolicyManifest, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.namespaces = namespaces
        self.policy_mode = policy_mode
        self.is_built_in_only = is_built_in_only
        self.resource_type_aliases = resource_type_aliases
        self.effects = effects
        self.field_values = field_values
        self.standard = standard
        self.custom = custom


class DataPolicyManifestListResult(msrest.serialization.Model):
    """List of data policy manifests.

    :ivar value: An array of data policy manifests.
    :vartype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.DataPolicyManifest]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataPolicyManifest]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataPolicyManifest"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: An array of data policy manifests.
        :paramtype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.DataPolicyManifest]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super(DataPolicyManifestListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.policy.v2021_06_01.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.policy.v2021_06_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Identity(msrest.serialization.Model):
    """Identity for the resource.  Policy assignments support a maximum of one identity.  That is either a system assigned identity or a single user assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the resource identity.  This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the resource identity.  This property will only be provided
     for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The identity type. This is the only required field when adding a system or user
     assigned identity to a resource. Possible values include: "SystemAssigned", "UserAssigned",
     "None".
    :vartype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The user identity associated with the policy. The user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.resource.policy.v2021_06_01.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentitiesValue}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentitiesValue"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. This is the only required field when adding a system or user
         assigned identity to a resource. Possible values include: "SystemAssigned", "UserAssigned",
         "None".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The user identity associated with the policy. The user
         identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.resource.policy.v2021_06_01.models.UserAssignedIdentitiesValue]
        """
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NonComplianceMessage(msrest.serialization.Model):
    """A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.

    All required parameters must be populated in order to send to Azure.

    :ivar message: Required. A message that describes why a resource is non-compliant with the
     policy. This is shown in 'deny' error messages and on resource's non-compliant compliance
     results.
    :vartype message: str
    :ivar policy_definition_reference_id: The policy definition reference ID within a policy set
     definition the message is intended for. This is only applicable if the policy assignment
     assigns a policy set definition. If this is not provided the message applies to all policies
     assigned by this policy assignment.
    :vartype policy_definition_reference_id: str
    """

    _validation = {
        'message': {'required': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: str,
        policy_definition_reference_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message: Required. A message that describes why a resource is non-compliant with the
         policy. This is shown in 'deny' error messages and on resource's non-compliant compliance
         results.
        :paramtype message: str
        :keyword policy_definition_reference_id: The policy definition reference ID within a policy set
         definition the message is intended for. This is only applicable if the policy assignment
         assigns a policy set definition. If this is not provided the message applies to all policies
         assigned by this policy assignment.
        :paramtype policy_definition_reference_id: str
        """
        super(NonComplianceMessage, self).__init__(**kwargs)
        self.message = message
        self.policy_definition_reference_id = policy_definition_reference_id


class ParameterDefinitionsValue(msrest.serialization.Model):
    """The definition of a parameter that can be provided to the policy.

    :ivar type: The data type of the parameter. Possible values include: "String", "Array",
     "Object", "Boolean", "Integer", "Float", "DateTime".
    :vartype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterType
    :ivar allowed_values: The allowed values for the parameter.
    :vartype allowed_values: list[any]
    :ivar default_value: The default value for the parameter if no value is provided.
    :vartype default_value: any
    :ivar metadata: General metadata for the parameter.
    :vartype metadata:
     ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterDefinitionsValueMetadata
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'allowed_values': {'key': 'allowedValues', 'type': '[object]'},
        'default_value': {'key': 'defaultValue', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': 'ParameterDefinitionsValueMetadata'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ParameterType"]] = None,
        allowed_values: Optional[List[Any]] = None,
        default_value: Optional[Any] = None,
        metadata: Optional["ParameterDefinitionsValueMetadata"] = None,
        **kwargs
    ):
        """
        :keyword type: The data type of the parameter. Possible values include: "String", "Array",
         "Object", "Boolean", "Integer", "Float", "DateTime".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterType
        :keyword allowed_values: The allowed values for the parameter.
        :paramtype allowed_values: list[any]
        :keyword default_value: The default value for the parameter if no value is provided.
        :paramtype default_value: any
        :keyword metadata: General metadata for the parameter.
        :paramtype metadata:
         ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterDefinitionsValueMetadata
        """
        super(ParameterDefinitionsValue, self).__init__(**kwargs)
        self.type = type
        self.allowed_values = allowed_values
        self.default_value = default_value
        self.metadata = metadata


class ParameterDefinitionsValueMetadata(msrest.serialization.Model):
    """General metadata for the parameter.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar display_name: The display name for the parameter.
    :vartype display_name: str
    :ivar description: The description of the parameter.
    :vartype description: str
    :ivar strong_type: Used when assigning the policy definition through the portal. Provides a
     context aware list of values for the user to choose from.
    :vartype strong_type: str
    :ivar assign_permissions: Set to true to have Azure portal create role assignments on the
     resource ID or resource scope value of this parameter during policy assignment. This property
     is useful in case you wish to assign permissions outside the assignment scope.
    :vartype assign_permissions: bool
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'strong_type': {'key': 'strongType', 'type': 'str'},
        'assign_permissions': {'key': 'assignPermissions', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        strong_type: Optional[str] = None,
        assign_permissions: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword display_name: The display name for the parameter.
        :paramtype display_name: str
        :keyword description: The description of the parameter.
        :paramtype description: str
        :keyword strong_type: Used when assigning the policy definition through the portal. Provides a
         context aware list of values for the user to choose from.
        :paramtype strong_type: str
        :keyword assign_permissions: Set to true to have Azure portal create role assignments on the
         resource ID or resource scope value of this parameter during policy assignment. This property
         is useful in case you wish to assign permissions outside the assignment scope.
        :paramtype assign_permissions: bool
        """
        super(ParameterDefinitionsValueMetadata, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.display_name = display_name
        self.description = description
        self.strong_type = strong_type
        self.assign_permissions = assign_permissions


class ParameterValuesValue(msrest.serialization.Model):
    """The value of a parameter.

    :ivar value: The value of the parameter.
    :vartype value: any
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        value: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword value: The value of the parameter.
        :paramtype value: any
        """
        super(ParameterValuesValue, self).__init__(**kwargs)
        self.value = value


class PolicyAssignment(msrest.serialization.Model):
    """The policy assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy assignment.
    :vartype id: str
    :ivar type: The type of the policy assignment.
    :vartype type: str
    :ivar name: The name of the policy assignment.
    :vartype name: str
    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.v2021_06_01.models.Identity
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2021_06_01.models.SystemData
    :ivar display_name: The display name of the policy assignment.
    :vartype display_name: str
    :ivar policy_definition_id: The ID of the policy definition or policy set definition being
     assigned.
    :vartype policy_definition_id: str
    :ivar scope: The scope for the policy assignment.
    :vartype scope: str
    :ivar not_scopes: The policy's excluded scopes.
    :vartype not_scopes: list[str]
    :ivar parameters: The parameter values for the assigned policy rule. The keys are the parameter
     names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterValuesValue]
    :ivar description: This message will be part of response in case of policy violation.
    :vartype description: str
    :ivar metadata: The policy assignment metadata. Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: any
    :ivar enforcement_mode: The policy assignment enforcement mode. Possible values are Default and
     DoNotEnforce. Possible values include: "Default", "DoNotEnforce". Default value: "Default".
    :vartype enforcement_mode: str or
     ~azure.mgmt.resource.policy.v2021_06_01.models.EnforcementMode
    :ivar non_compliance_messages: The messages that describe why a resource is non-compliant with
     the policy.
    :vartype non_compliance_messages:
     list[~azure.mgmt.resource.policy.v2021_06_01.models.NonComplianceMessage]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'system_data': {'readonly': True},
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'policy_definition_id': {'key': 'properties.policyDefinitionId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'not_scopes': {'key': 'properties.notScopes', 'type': '[str]'},
        'parameters': {'key': 'properties.parameters', 'type': '{ParameterValuesValue}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'enforcement_mode': {'key': 'properties.enforcementMode', 'type': 'str'},
        'non_compliance_messages': {'key': 'properties.nonComplianceMessages', 'type': '[NonComplianceMessage]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["Identity"] = None,
        display_name: Optional[str] = None,
        policy_definition_id: Optional[str] = None,
        not_scopes: Optional[List[str]] = None,
        parameters: Optional[Dict[str, "ParameterValuesValue"]] = None,
        description: Optional[str] = None,
        metadata: Optional[Any] = None,
        enforcement_mode: Optional[Union[str, "EnforcementMode"]] = "Default",
        non_compliance_messages: Optional[List["NonComplianceMessage"]] = None,
        **kwargs
    ):
        """
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.v2021_06_01.models.Identity
        :keyword display_name: The display name of the policy assignment.
        :paramtype display_name: str
        :keyword policy_definition_id: The ID of the policy definition or policy set definition being
         assigned.
        :paramtype policy_definition_id: str
        :keyword not_scopes: The policy's excluded scopes.
        :paramtype not_scopes: list[str]
        :keyword parameters: The parameter values for the assigned policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterValuesValue]
        :keyword description: This message will be part of response in case of policy violation.
        :paramtype description: str
        :keyword metadata: The policy assignment metadata. Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: any
        :keyword enforcement_mode: The policy assignment enforcement mode. Possible values are Default
         and DoNotEnforce. Possible values include: "Default", "DoNotEnforce". Default value: "Default".
        :paramtype enforcement_mode: str or
         ~azure.mgmt.resource.policy.v2021_06_01.models.EnforcementMode
        :keyword non_compliance_messages: The messages that describe why a resource is non-compliant
         with the policy.
        :paramtype non_compliance_messages:
         list[~azure.mgmt.resource.policy.v2021_06_01.models.NonComplianceMessage]
        """
        super(PolicyAssignment, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.location = location
        self.identity = identity
        self.system_data = None
        self.display_name = display_name
        self.policy_definition_id = policy_definition_id
        self.scope = None
        self.not_scopes = not_scopes
        self.parameters = parameters
        self.description = description
        self.metadata = metadata
        self.enforcement_mode = enforcement_mode
        self.non_compliance_messages = non_compliance_messages


class PolicyAssignmentListResult(msrest.serialization.Model):
    """List of policy assignments.

    :ivar value: An array of policy assignments.
    :vartype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicyAssignment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PolicyAssignment"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: An array of policy assignments.
        :paramtype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyAssignment]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super(PolicyAssignmentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyAssignmentUpdate(msrest.serialization.Model):
    """PolicyAssignmentUpdate.

    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.v2021_06_01.models.Identity
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["Identity"] = None,
        **kwargs
    ):
        """
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.v2021_06_01.models.Identity
        """
        super(PolicyAssignmentUpdate, self).__init__(**kwargs)
        self.location = location
        self.identity = identity


class PolicyDefinition(msrest.serialization.Model):
    """The policy definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy definition.
    :vartype id: str
    :ivar name: The name of the policy definition.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policyDefinitions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2021_06_01.models.SystemData
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Possible values include: "NotSpecified", "BuiltIn", "Custom", "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.PolicyType
    :ivar mode: The policy definition mode. Some examples are All, Indexed,
     Microsoft.KeyVault.Data.
    :vartype mode: str
    :ivar display_name: The display name of the policy definition.
    :vartype display_name: str
    :ivar description: The policy definition description.
    :vartype description: str
    :ivar policy_rule: The policy rule.
    :vartype policy_rule: any
    :ivar metadata: The policy definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: any
    :ivar parameters: The parameter definitions for parameters used in the policy rule. The keys
     are the parameter names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterDefinitionsValue]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'policy_type': {'key': 'properties.policyType', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'policy_rule': {'key': 'properties.policyRule', 'type': 'object'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'parameters': {'key': 'properties.parameters', 'type': '{ParameterDefinitionsValue}'},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "PolicyType"]] = None,
        mode: Optional[str] = "Indexed",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        policy_rule: Optional[Any] = None,
        metadata: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterDefinitionsValue"]] = None,
        **kwargs
    ):
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Possible values include: "NotSpecified", "BuiltIn", "Custom", "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.PolicyType
        :keyword mode: The policy definition mode. Some examples are All, Indexed,
         Microsoft.KeyVault.Data.
        :paramtype mode: str
        :keyword display_name: The display name of the policy definition.
        :paramtype display_name: str
        :keyword description: The policy definition description.
        :paramtype description: str
        :keyword policy_rule: The policy rule.
        :paramtype policy_rule: any
        :keyword metadata: The policy definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: any
        :keyword parameters: The parameter definitions for parameters used in the policy rule. The keys
         are the parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterDefinitionsValue]
        """
        super(PolicyDefinition, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.policy_type = policy_type
        self.mode = mode
        self.display_name = display_name
        self.description = description
        self.policy_rule = policy_rule
        self.metadata = metadata
        self.parameters = parameters


class PolicyDefinitionGroup(msrest.serialization.Model):
    """The policy definition group.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the group.
    :vartype name: str
    :ivar display_name: The group's display name.
    :vartype display_name: str
    :ivar category: The group's category.
    :vartype category: str
    :ivar description: The group's description.
    :vartype description: str
    :ivar additional_metadata_id: A resource ID of a resource that contains additional metadata
     about the group.
    :vartype additional_metadata_id: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'additional_metadata_id': {'key': 'additionalMetadataId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        display_name: Optional[str] = None,
        category: Optional[str] = None,
        description: Optional[str] = None,
        additional_metadata_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the group.
        :paramtype name: str
        :keyword display_name: The group's display name.
        :paramtype display_name: str
        :keyword category: The group's category.
        :paramtype category: str
        :keyword description: The group's description.
        :paramtype description: str
        :keyword additional_metadata_id: A resource ID of a resource that contains additional metadata
         about the group.
        :paramtype additional_metadata_id: str
        """
        super(PolicyDefinitionGroup, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.category = category
        self.description = description
        self.additional_metadata_id = additional_metadata_id


class PolicyDefinitionListResult(msrest.serialization.Model):
    """List of policy definitions.

    :ivar value: An array of policy definitions.
    :vartype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicyDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PolicyDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: An array of policy definitions.
        :paramtype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super(PolicyDefinitionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyDefinitionReference(msrest.serialization.Model):
    """The policy definition reference.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_definition_id: Required. The ID of the policy definition or policy set definition.
    :vartype policy_definition_id: str
    :ivar parameters: The parameter values for the referenced policy rule. The keys are the
     parameter names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterValuesValue]
    :ivar policy_definition_reference_id: A unique id (within the policy set definition) for this
     policy definition reference.
    :vartype policy_definition_reference_id: str
    :ivar group_names: The name of the groups that this policy definition reference belongs to.
    :vartype group_names: list[str]
    """

    _validation = {
        'policy_definition_id': {'required': True},
    }

    _attribute_map = {
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterValuesValue}'},
        'policy_definition_reference_id': {'key': 'policyDefinitionReferenceId', 'type': 'str'},
        'group_names': {'key': 'groupNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        policy_definition_id: str,
        parameters: Optional[Dict[str, "ParameterValuesValue"]] = None,
        policy_definition_reference_id: Optional[str] = None,
        group_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword policy_definition_id: Required. The ID of the policy definition or policy set
         definition.
        :paramtype policy_definition_id: str
        :keyword parameters: The parameter values for the referenced policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterValuesValue]
        :keyword policy_definition_reference_id: A unique id (within the policy set definition) for
         this policy definition reference.
        :paramtype policy_definition_reference_id: str
        :keyword group_names: The name of the groups that this policy definition reference belongs to.
        :paramtype group_names: list[str]
        """
        super(PolicyDefinitionReference, self).__init__(**kwargs)
        self.policy_definition_id = policy_definition_id
        self.parameters = parameters
        self.policy_definition_reference_id = policy_definition_reference_id
        self.group_names = group_names


class PolicyExemption(msrest.serialization.Model):
    """The policy exemption.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.policy.v2021_06_01.models.SystemData
    :ivar id: The ID of the policy exemption.
    :vartype id: str
    :ivar name: The name of the policy exemption.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policyExemptions).
    :vartype type: str
    :ivar policy_assignment_id: Required. The ID of the policy assignment that is being exempted.
    :vartype policy_assignment_id: str
    :ivar policy_definition_reference_ids: The policy definition reference ID list when the
     associated policy assignment is an assignment of a policy set definition.
    :vartype policy_definition_reference_ids: list[str]
    :ivar exemption_category: Required. The policy exemption category. Possible values are Waiver
     and Mitigated. Possible values include: "Waiver", "Mitigated".
    :vartype exemption_category: str or
     ~azure.mgmt.resource.policy.v2021_06_01.models.ExemptionCategory
    :ivar expires_on: The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of
     the policy exemption.
    :vartype expires_on: ~datetime.datetime
    :ivar display_name: The display name of the policy exemption.
    :vartype display_name: str
    :ivar description: The description of the policy exemption.
    :vartype description: str
    :ivar metadata: The policy exemption metadata. Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: any
    """

    _validation = {
        'system_data': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'policy_assignment_id': {'required': True},
        'exemption_category': {'required': True},
    }

    _attribute_map = {
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'policy_assignment_id': {'key': 'properties.policyAssignmentId', 'type': 'str'},
        'policy_definition_reference_ids': {'key': 'properties.policyDefinitionReferenceIds', 'type': '[str]'},
        'exemption_category': {'key': 'properties.exemptionCategory', 'type': 'str'},
        'expires_on': {'key': 'properties.expiresOn', 'type': 'iso-8601'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        policy_assignment_id: str,
        exemption_category: Union[str, "ExemptionCategory"],
        policy_definition_reference_ids: Optional[List[str]] = None,
        expires_on: Optional[datetime.datetime] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword policy_assignment_id: Required. The ID of the policy assignment that is being
         exempted.
        :paramtype policy_assignment_id: str
        :keyword policy_definition_reference_ids: The policy definition reference ID list when the
         associated policy assignment is an assignment of a policy set definition.
        :paramtype policy_definition_reference_ids: list[str]
        :keyword exemption_category: Required. The policy exemption category. Possible values are
         Waiver and Mitigated. Possible values include: "Waiver", "Mitigated".
        :paramtype exemption_category: str or
         ~azure.mgmt.resource.policy.v2021_06_01.models.ExemptionCategory
        :keyword expires_on: The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ)
         of the policy exemption.
        :paramtype expires_on: ~datetime.datetime
        :keyword display_name: The display name of the policy exemption.
        :paramtype display_name: str
        :keyword description: The description of the policy exemption.
        :paramtype description: str
        :keyword metadata: The policy exemption metadata. Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: any
        """
        super(PolicyExemption, self).__init__(**kwargs)
        self.system_data = None
        self.id = None
        self.name = None
        self.type = None
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_reference_ids = policy_definition_reference_ids
        self.exemption_category = exemption_category
        self.expires_on = expires_on
        self.display_name = display_name
        self.description = description
        self.metadata = metadata


class PolicyExemptionListResult(msrest.serialization.Model):
    """List of policy exemptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of policy exemptions.
    :vartype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyExemption]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicyExemption]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PolicyExemption"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of policy exemptions.
        :paramtype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyExemption]
        """
        super(PolicyExemptionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PolicySetDefinition(msrest.serialization.Model):
    """The policy set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy set definition.
    :vartype id: str
    :ivar name: The name of the policy set definition.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policySetDefinitions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2021_06_01.models.SystemData
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Possible values include: "NotSpecified", "BuiltIn", "Custom", "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.PolicyType
    :ivar display_name: The display name of the policy set definition.
    :vartype display_name: str
    :ivar description: The policy set definition description.
    :vartype description: str
    :ivar metadata: The policy set definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: any
    :ivar parameters: The policy set definition parameters that can be used in policy definition
     references.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterDefinitionsValue]
    :ivar policy_definitions: An array of policy definition references.
    :vartype policy_definitions:
     list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyDefinitionReference]
    :ivar policy_definition_groups: The metadata describing groups of policy definition references
     within the policy set definition.
    :vartype policy_definition_groups:
     list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyDefinitionGroup]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'policy_type': {'key': 'properties.policyType', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'object'},
        'parameters': {'key': 'properties.parameters', 'type': '{ParameterDefinitionsValue}'},
        'policy_definitions': {'key': 'properties.policyDefinitions', 'type': '[PolicyDefinitionReference]'},
        'policy_definition_groups': {'key': 'properties.policyDefinitionGroups', 'type': '[PolicyDefinitionGroup]'},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "PolicyType"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata: Optional[Any] = None,
        parameters: Optional[Dict[str, "ParameterDefinitionsValue"]] = None,
        policy_definitions: Optional[List["PolicyDefinitionReference"]] = None,
        policy_definition_groups: Optional[List["PolicyDefinitionGroup"]] = None,
        **kwargs
    ):
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Possible values include: "NotSpecified", "BuiltIn", "Custom", "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.PolicyType
        :keyword display_name: The display name of the policy set definition.
        :paramtype display_name: str
        :keyword description: The policy set definition description.
        :paramtype description: str
        :keyword metadata: The policy set definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: any
        :keyword parameters: The policy set definition parameters that can be used in policy definition
         references.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2021_06_01.models.ParameterDefinitionsValue]
        :keyword policy_definitions: An array of policy definition references.
        :paramtype policy_definitions:
         list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyDefinitionReference]
        :keyword policy_definition_groups: The metadata describing groups of policy definition
         references within the policy set definition.
        :paramtype policy_definition_groups:
         list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicyDefinitionGroup]
        """
        super(PolicySetDefinition, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.policy_type = policy_type
        self.display_name = display_name
        self.description = description
        self.metadata = metadata
        self.parameters = parameters
        self.policy_definitions = policy_definitions
        self.policy_definition_groups = policy_definition_groups


class PolicySetDefinitionListResult(msrest.serialization.Model):
    """List of policy set definitions.

    :ivar value: An array of policy set definitions.
    :vartype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicySetDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicySetDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PolicySetDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: An array of policy set definitions.
        :paramtype value: list[~azure.mgmt.resource.policy.v2021_06_01.models.PolicySetDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super(PolicySetDefinitionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceTypeAliases(msrest.serialization.Model):
    """The resource type aliases definition.

    :ivar resource_type: The resource type name.
    :vartype resource_type: str
    :ivar aliases: The aliases for property names.
    :vartype aliases: list[~azure.mgmt.resource.policy.v2021_06_01.models.Alias]
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'aliases': {'key': 'aliases', 'type': '[Alias]'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        aliases: Optional[List["Alias"]] = None,
        **kwargs
    ):
        """
        :keyword resource_type: The resource type name.
        :paramtype resource_type: str
        :keyword aliases: The aliases for property names.
        :paramtype aliases: list[~azure.mgmt.resource.policy.v2021_06_01.models.Alias]
        """
        super(ResourceTypeAliases, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.aliases = aliases


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.resource.policy.v2021_06_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.resource.policy.v2021_06_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.resource.policy.v2021_06_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentitiesValue(msrest.serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
