# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class CleanupOptions(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The clean up preference when the script execution gets in a terminal state. Default setting is
    'Always'.
    """

    ALWAYS = "Always"
    ON_SUCCESS = "OnSuccess"
    ON_EXPIRATION = "OnExpiration"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class ManagedServiceIdentityType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the managed identity.
    """

    USER_ASSIGNED = "UserAssigned"

class ScriptProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """State of the script execution. This only appears in the response.
    """

    CREATING = "Creating"
    PROVISIONING_RESOURCES = "ProvisioningResources"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class ScriptType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the script.
    """

    AZURE_POWER_SHELL = "AzurePowerShell"
    AZURE_CLI = "AzureCLI"
