/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Vector;

public class QueuedImageProducerProxy
implements ImageProducer {
    protected Vector queuedConsumers = new Vector();
    protected ImageProducer realProducer;

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (this.realProducer == null) {
            this.queuedConsumers.addElement(imageConsumer);
        } else {
            this.realProducer.addConsumer(imageConsumer);
        }
    }

    public synchronized ImageConsumer[] getConsumers() {
        Object[] objectArray = new ImageConsumer[this.queuedConsumers.size()];
        this.queuedConsumers.copyInto(objectArray);
        return objectArray;
    }

    public ImageProducer getImageProducer() {
        return this.realProducer;
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        if (this.realProducer == null) {
            return this.queuedConsumers.contains(imageConsumer);
        }
        return this.realProducer.isConsumer(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.realProducer == null) {
            this.queuedConsumers.removeElement(imageConsumer);
        } else {
            this.realProducer.removeConsumer(imageConsumer);
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.removeConsumer(imageConsumer);
        this.addConsumer(imageConsumer);
    }

    public synchronized void setImageProducer(ImageProducer imageProducer) {
        this.realProducer = imageProducer;
        Enumeration enumeration = this.queuedConsumers.elements();
        while (enumeration.hasMoreElements()) {
            this.realProducer.addConsumer((ImageConsumer)enumeration.nextElement());
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }
}

