/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.util;

import fr.jayasoft.ivy.url.URLHandlerRegistry;
import fr.jayasoft.ivy.util.CopyProgressEvent;
import fr.jayasoft.ivy.util.CopyProgressListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileUtil {
    private static final int BUFFER_SIZE = 8192;

    public static void copy(File src, File dest, CopyProgressListener l) throws IOException {
        FileUtil.copy(src, dest, l, false);
    }

    public static void copy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        if (dest.exists() && !dest.canWrite()) {
            if (overwrite && dest.isFile()) {
                dest.delete();
            } else {
                throw new IOException("impossible to copy: destination is not writable: " + dest);
            }
        }
        FileUtil.copy((InputStream)new FileInputStream(src), dest, l);
        dest.setLastModified(src.lastModified());
    }

    public static void copy(URL src, File dest, CopyProgressListener l) throws IOException {
        URLHandlerRegistry.getDefault().download(src, dest, l);
    }

    public static void copy(InputStream src, File dest, CopyProgressListener l) throws IOException {
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        FileUtil.copy(src, new FileOutputStream(dest), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l) throws IOException {
        try {
            int c;
            CopyProgressEvent evt = null;
            if (l != null) {
                evt = new CopyProgressEvent();
            }
            byte[] buffer = new byte[8192];
            long total = 0L;
            if (l != null) {
                l.start(evt);
            }
            while ((c = src.read(buffer)) != -1) {
                dest.write(buffer, 0, c);
                total += (long)c;
                if (l == null) continue;
                l.progress(evt.update(buffer, c, total));
            }
            if (l != null) {
                l.end(evt.update(buffer, 0, total));
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                src.close();
            }
            catch (IOException ex) {
                dest.close();
                throw ex;
            }
            dest.close();
            throw throwable;
        }
        try {
            src.close();
        }
        catch (IOException ex) {
            dest.close();
            throw ex;
        }
        dest.close();
    }

    public static String readEntirely(BufferedReader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        String line = in.readLine();
        while (line != null) {
            buf.append(line + "\n");
            line = in.readLine();
        }
        in.close();
        return buf.toString();
    }
}

