/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.ULogger;
import org.apache.log4j.rolling.helper.ActionBase;

public final class ZipCompressAction
extends ActionBase {
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final ULogger logger;

    public ZipCompressAction(File source, File destination, boolean deleteSource, ULogger logger) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        this.source = source;
        this.destination = destination;
        this.deleteSource = deleteSource;
        this.logger = logger;
    }

    public boolean execute() throws IOException {
        return ZipCompressAction.execute(this.source, this.destination, this.deleteSource, this.logger);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean execute(File source, File destination, boolean deleteSource, ULogger logger) throws IOException {
        if (source.exists()) {
            int n;
            FileInputStream fis = new FileInputStream(source);
            FileOutputStream fos = new FileOutputStream(destination);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry zipEntry = new ZipEntry(source.getName());
            zos.putNextEntry(zipEntry);
            byte[] inbuf = new byte[8102];
            while ((n = fis.read(inbuf)) != -1) {
                void var9_9;
                zos.write(inbuf, 0, (int)var9_9);
            }
            zos.close();
            fis.close();
            if (deleteSource && !source.delete() && logger != null) {
                logger.info((Object)"Unable to delete {}.", source.toString());
            }
            return true;
        }
        return false;
    }

    protected void reportException(Exception ex) {
        if (this.logger != null) {
            this.logger.info((Object)("Exception during compression of '" + this.source.toString() + "'."), ex);
        }
    }
}

