/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.helpers.Transform;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableInformation;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.html.IThrowableRenderer;

public class DefaultThrowableRenderer
implements IThrowableRenderer {
    static final String TRACE_PREFIX = "<br />&nbsp;&nbsp;&nbsp;&nbsp;";
    Throwable throwable;

    public void setThrowable(Throwable t) {
        this.throwable = t;
    }

    public void render(StringBuffer sbuf, String[] s) {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            sbuf.append("<tr><td class=\"Exception\" colspan=\"6\">");
            sbuf.append(Transform.escapeTags(s[0]));
            sbuf.append(Layout.LINE_SEP);
            int i = 1;
            while (i < len) {
                sbuf.append(TRACE_PREFIX);
                sbuf.append(Transform.escapeTags(s[i]));
                sbuf.append(Layout.LINE_SEP);
                ++i;
            }
            sbuf.append("</td></tr>");
        }
    }

    public void render(StringBuffer sbuf, Object eventObject) {
        LoggingEvent event = (LoggingEvent)eventObject;
        ThrowableInformation ti = event.getThrowableInformation();
        if (ti != null) {
            this.render(sbuf, ti.getThrowableStrRep());
        }
    }
}

