/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/forklift/v1beta1"
)

// FakeOpenstackVolumePopulators implements OpenstackVolumePopulatorInterface
type FakeOpenstackVolumePopulators struct {
	Fake *FakeForkliftV1beta1
	ns   string
}

var openstackvolumepopulatorsResource = v1beta1.SchemeGroupVersion.WithResource("openstackvolumepopulators")

var openstackvolumepopulatorsKind = v1beta1.SchemeGroupVersion.WithKind("OpenstackVolumePopulator")

// Get takes name of the openstackVolumePopulator, and returns the corresponding openstackVolumePopulator object, and an error if there is any.
func (c *FakeOpenstackVolumePopulators) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.OpenstackVolumePopulator, err error) {
	emptyResult := &v1beta1.OpenstackVolumePopulator{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(openstackvolumepopulatorsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1beta1.OpenstackVolumePopulator), err
}

// List takes label and field selectors, and returns the list of OpenstackVolumePopulators that match those selectors.
func (c *FakeOpenstackVolumePopulators) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.OpenstackVolumePopulatorList, err error) {
	emptyResult := &v1beta1.OpenstackVolumePopulatorList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(openstackvolumepopulatorsResource, openstackvolumepopulatorsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.OpenstackVolumePopulatorList{ListMeta: obj.(*v1beta1.OpenstackVolumePopulatorList).ListMeta}
	for _, item := range obj.(*v1beta1.OpenstackVolumePopulatorList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested openstackVolumePopulators.
func (c *FakeOpenstackVolumePopulators) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(openstackvolumepopulatorsResource, c.ns, opts))

}

// Create takes the representation of a openstackVolumePopulator and creates it.  Returns the server's representation of the openstackVolumePopulator, and an error, if there is any.
func (c *FakeOpenstackVolumePopulators) Create(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.CreateOptions) (result *v1beta1.OpenstackVolumePopulator, err error) {
	emptyResult := &v1beta1.OpenstackVolumePopulator{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(openstackvolumepopulatorsResource, c.ns, openstackVolumePopulator, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1beta1.OpenstackVolumePopulator), err
}

// Update takes the representation of a openstackVolumePopulator and updates it. Returns the server's representation of the openstackVolumePopulator, and an error, if there is any.
func (c *FakeOpenstackVolumePopulators) Update(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.UpdateOptions) (result *v1beta1.OpenstackVolumePopulator, err error) {
	emptyResult := &v1beta1.OpenstackVolumePopulator{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(openstackvolumepopulatorsResource, c.ns, openstackVolumePopulator, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1beta1.OpenstackVolumePopulator), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeOpenstackVolumePopulators) UpdateStatus(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.UpdateOptions) (result *v1beta1.OpenstackVolumePopulator, err error) {
	emptyResult := &v1beta1.OpenstackVolumePopulator{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(openstackvolumepopulatorsResource, "status", c.ns, openstackVolumePopulator, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1beta1.OpenstackVolumePopulator), err
}

// Delete takes name of the openstackVolumePopulator and deletes it. Returns an error if one occurs.
func (c *FakeOpenstackVolumePopulators) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(openstackvolumepopulatorsResource, c.ns, name, opts), &v1beta1.OpenstackVolumePopulator{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeOpenstackVolumePopulators) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(openstackvolumepopulatorsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.OpenstackVolumePopulatorList{})
	return err
}

// Patch applies the patch and returns the patched openstackVolumePopulator.
func (c *FakeOpenstackVolumePopulators) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OpenstackVolumePopulator, err error) {
	emptyResult := &v1beta1.OpenstackVolumePopulator{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(openstackvolumepopulatorsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1beta1.OpenstackVolumePopulator), err
}
