# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin

from ._configuration import NetworkManagementClientConfiguration
from ._serialization import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


from .operations import (
    ApplicationGatewaysOperations,
    ExpressRouteCircuitAuthorizationsOperations,
    ExpressRouteCircuitPeeringsOperations,
    ExpressRouteCircuitsOperations,
    ExpressRouteServiceProvidersOperations,
    LoadBalancersOperations,
    LocalNetworkGatewaysOperations,
    NetworkInterfacesOperations,
    NetworkSecurityGroupsOperations,
    PublicIPAddressesOperations,
    RouteTablesOperations,
    RoutesOperations,
    SecurityRulesOperations,
    SubnetsOperations,
    UsagesOperations,
    VirtualNetworkGatewayConnectionsOperations,
    VirtualNetworkGatewaysOperations,
    VirtualNetworksOperations,
    ApplicationSecurityGroupsOperations,
    AvailableEndpointServicesOperations,
    BgpServiceCommunitiesOperations,
    ConnectionMonitorsOperations,
    DefaultSecurityRulesOperations,
    InboundNatRulesOperations,
    LoadBalancerBackendAddressPoolsOperations,
    LoadBalancerFrontendIPConfigurationsOperations,
    LoadBalancerLoadBalancingRulesOperations,
    LoadBalancerNetworkInterfacesOperations,
    LoadBalancerProbesOperations,
    NetworkInterfaceIPConfigurationsOperations,
    NetworkInterfaceLoadBalancersOperations,
    NetworkWatchersOperations,
    Operations,
    PacketCapturesOperations,
    RouteFilterRulesOperations,
    RouteFiltersOperations,
    VirtualNetworkPeeringsOperations,
    AzureFirewallsOperations,
    DdosProtectionPlansOperations,
    ExpressRouteCircuitConnectionsOperations,
    ExpressRouteCrossConnectionPeeringsOperations,
    ExpressRouteCrossConnectionsOperations,
    HubVirtualNetworkConnectionsOperations,
    VirtualHubsOperations,
    VirtualWANsOperations,
    VpnConnectionsOperations,
    VpnGatewaysOperations,
    VpnSitesConfigurationOperations,
    VpnSitesOperations,
    AvailableDelegationsOperations,
    AvailableResourceGroupDelegationsOperations,
    AzureFirewallFqdnTagsOperations,
    DdosCustomPoliciesOperations,
    ExpressRouteConnectionsOperations,
    ExpressRouteGatewaysOperations,
    ExpressRouteLinksOperations,
    ExpressRoutePortsLocationsOperations,
    ExpressRoutePortsOperations,
    InterfaceEndpointsOperations,
    LoadBalancerOutboundRulesOperations,
    NetworkInterfaceTapConfigurationsOperations,
    NetworkProfilesOperations,
    P2SVpnGatewaysOperations,
    P2SVpnServerConfigurationsOperations,
    PublicIPPrefixesOperations,
    ServiceEndpointPoliciesOperations,
    ServiceEndpointPolicyDefinitionsOperations,
    VirtualNetworkTapsOperations,
    VirtualWansOperations,
    PeerExpressRouteCircuitConnectionsOperations,
    WebApplicationFirewallPoliciesOperations,
    NatGatewaysOperations,
    ResourceNavigationLinksOperations,
    ServiceAssociationLinksOperations,
    AvailablePrivateEndpointTypesOperations,
    BastionHostsOperations,
    PrivateEndpointsOperations,
    PrivateLinkServicesOperations,
    ServiceTagsOperations,
    FirewallPoliciesOperations,
    FirewallPolicyRuleGroupsOperations,
    VpnLinkConnectionsOperations,
    VpnSiteLinkConnectionsOperations,
    VpnSiteLinksOperations,
    VirtualRouterPeeringsOperations,
    VirtualRoutersOperations,
    AvailableServiceAliasesOperations,
    VpnServerConfigurationsAssociatedWithVirtualWanOperations,
    VpnServerConfigurationsOperations,
    IpGroupsOperations,
    VirtualHubRouteTableV2SOperations,
    FlowLogsOperations,
    NetworkVirtualAppliancesOperations,
    IpAllocationsOperations,
    PrivateDnsZoneGroupsOperations,
    SecurityPartnerProvidersOperations,
    HubRouteTablesOperations,
    ApplicationGatewayPrivateEndpointConnectionsOperations,
    ApplicationGatewayPrivateLinkResourcesOperations,
    FirewallPolicyRuleCollectionGroupsOperations,
    VirtualApplianceSitesOperations,
    VirtualApplianceSkusOperations,
    VirtualHubBgpConnectionOperations,
    VirtualHubBgpConnectionsOperations,
    VirtualHubIpConfigurationOperations,
    CustomIPPrefixesOperations,
    DscpConfigurationOperations,
    InboundSecurityRuleOperations,
    WebCategoriesOperations,
    NatRulesOperations,
    VirtualNetworkGatewayNatRulesOperations,
    ActiveConnectivityConfigurationsOperations,
    ActiveSecurityAdminRulesOperations,
    ActiveSecurityUserRulesOperations,
    AdminRuleCollectionsOperations,
    AdminRulesOperations,
    ConnectivityConfigurationsOperations,
    EffectiveConnectivityConfigurationsOperations,
    EffectiveVirtualNetworksOperations,
    NetworkGroupsOperations,
    NetworkManagerCommitsOperations,
    NetworkManagerDeploymentStatusOperations,
    NetworkManagerEffectiveSecurityAdminRulesOperations,
    NetworkManagersOperations,
    NetworkSecurityPerimetersOperations,
    NspAccessRulesOperations,
    NspAccessRulesReconcileOperations,
    NspAssociationReconcileOperations,
    NspAssociationsOperations,
    NspLinkReferencesOperations,
    NspLinksOperations,
    NspProfilesOperations,
    PerimeterAssociableResourceTypesOperations,
    SecurityAdminConfigurationsOperations,
    SecurityUserConfigurationsOperations,
    UserRuleCollectionsOperations,
    UserRulesOperations,
    ApplicationGatewayWafDynamicManifestsDefaultOperations,
    ApplicationGatewayWafDynamicManifestsOperations,
    ConfigurationPolicyGroupsOperations,
    ExpressRoutePortAuthorizationsOperations,
    ExpressRouteProviderPortsLocationOperations,
    FirewallPolicyIdpsSignaturesFilterValuesOperations,
    FirewallPolicyIdpsSignaturesOperations,
    FirewallPolicyIdpsSignaturesOverridesOperations,
    ManagementGroupNetworkManagerConnectionsOperations,
    RouteMapsOperations,
    RoutingIntentOperations,
    ScopeConnectionsOperations,
    ServiceTagInformationOperations,
    StaticMembersOperations,
    SubscriptionNetworkManagerConnectionsOperations,
    VipSwapOperations,
    NetworkVirtualApplianceConnectionsOperations,
    NetworkManagementClientOperationsMixin,
)
from ._validation import api_version_validation
from . import models
class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implemetation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class NetworkManagementClient(NetworkManagementClientOperationsMixin, MultiApiClientMixin, _SDKClient):
    """Network Client.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call. Required.
    :type subscription_id: str
    :param api_version: API version to use if no profile is provided, or if missing in profile.
    :type api_version: str
    :param base_url: Service URL
    :type base_url: str
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2023-09-01'
    _PROFILE_TAG = "azure.mgmt.network.NetworkManagementClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'active_connectivity_configurations': '2021-02-01-preview',
            'active_security_admin_rules': '2021-02-01-preview',
            'active_security_user_rules': '2021-02-01-preview',
            'effective_connectivity_configurations': '2021-02-01-preview',
            'effective_virtual_networks': '2021-02-01-preview',
            'firewall_policy_rule_groups': '2020-04-01',
            'interface_endpoints': '2019-02-01',
            'network_manager_effective_security_admin_rules': '2021-02-01-preview',
            'network_security_perimeters': '2021-02-01-preview',
            'nsp_access_rules': '2021-02-01-preview',
            'nsp_access_rules_reconcile': '2021-02-01-preview',
            'nsp_association_reconcile': '2021-02-01-preview',
            'nsp_associations': '2021-02-01-preview',
            'nsp_link_references': '2021-02-01-preview',
            'nsp_links': '2021-02-01-preview',
            'nsp_profiles': '2021-02-01-preview',
            'p2_svpn_server_configurations': '2019-07-01',
            'perimeter_associable_resource_types': '2021-02-01-preview',
            'security_user_configurations': '2021-02-01-preview',
            'user_rule_collections': '2021-02-01-preview',
            'user_rules': '2021-02-01-preview',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        api_version: Optional[str]=None,
        base_url: str = "https://management.azure.com",
        profile: KnownProfiles=KnownProfiles.default,
        **kwargs: Any
    ):
        if api_version:
            kwargs.setdefault('api_version', api_version)
        self._config = NetworkManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)
        super(NetworkManagementClient, self).__init__(
            api_version=api_version,
            profile=profile
        )

        self._serialize = Serializer(self._models_dict())
        self._deserialize = Deserializer(self._models_dict())
        self._serialize.client_side_validation = False


    @classmethod
    def _models_dict(cls):
        return {k: v for k, v in models.__dict__.items() if isinstance(v, type)}


    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def application_gateways(self):
        api_version = self._get_api_version("application_gateways")
        return ApplicationGatewaysOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_circuit_authorizations(self):
        api_version = self._get_api_version("express_route_circuit_authorizations")
        return ExpressRouteCircuitAuthorizationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_circuit_peerings(self):
        api_version = self._get_api_version("express_route_circuit_peerings")
        return ExpressRouteCircuitPeeringsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_circuits(self):
        api_version = self._get_api_version("express_route_circuits")
        return ExpressRouteCircuitsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_service_providers(self):
        api_version = self._get_api_version("express_route_service_providers")
        return ExpressRouteServiceProvidersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def load_balancers(self):
        api_version = self._get_api_version("load_balancers")
        return LoadBalancersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def local_network_gateways(self):
        api_version = self._get_api_version("local_network_gateways")
        return LocalNetworkGatewaysOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_interfaces(self):
        api_version = self._get_api_version("network_interfaces")
        return NetworkInterfacesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_security_groups(self):
        api_version = self._get_api_version("network_security_groups")
        return NetworkSecurityGroupsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def public_ip_addresses(self):
        api_version = self._get_api_version("public_ip_addresses")
        return PublicIPAddressesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def route_tables(self):
        api_version = self._get_api_version("route_tables")
        return RouteTablesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def routes(self):
        api_version = self._get_api_version("routes")
        return RoutesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def security_rules(self):
        api_version = self._get_api_version("security_rules")
        return SecurityRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def subnets(self):
        api_version = self._get_api_version("subnets")
        return SubnetsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def usages(self):
        api_version = self._get_api_version("usages")
        return UsagesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_network_gateway_connections(self):
        api_version = self._get_api_version("virtual_network_gateway_connections")
        return VirtualNetworkGatewayConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_network_gateways(self):
        api_version = self._get_api_version("virtual_network_gateways")
        return VirtualNetworkGatewaysOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2015-06-15', '2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_networks(self):
        api_version = self._get_api_version("virtual_networks")
        return VirtualNetworksOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def application_security_groups(self):
        api_version = self._get_api_version("application_security_groups")
        return ApplicationSecurityGroupsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def available_endpoint_services(self):
        api_version = self._get_api_version("available_endpoint_services")
        return AvailableEndpointServicesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def bgp_service_communities(self):
        api_version = self._get_api_version("bgp_service_communities")
        return BgpServiceCommunitiesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def connection_monitors(self):
        api_version = self._get_api_version("connection_monitors")
        return ConnectionMonitorsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def default_security_rules(self):
        api_version = self._get_api_version("default_security_rules")
        return DefaultSecurityRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def inbound_nat_rules(self):
        api_version = self._get_api_version("inbound_nat_rules")
        return InboundNatRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def load_balancer_backend_address_pools(self):
        api_version = self._get_api_version("load_balancer_backend_address_pools")
        return LoadBalancerBackendAddressPoolsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def load_balancer_frontend_ip_configurations(self):
        api_version = self._get_api_version("load_balancer_frontend_ip_configurations")
        return LoadBalancerFrontendIPConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def load_balancer_load_balancing_rules(self):
        api_version = self._get_api_version("load_balancer_load_balancing_rules")
        return LoadBalancerLoadBalancingRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def load_balancer_network_interfaces(self):
        api_version = self._get_api_version("load_balancer_network_interfaces")
        return LoadBalancerNetworkInterfacesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def load_balancer_probes(self):
        api_version = self._get_api_version("load_balancer_probes")
        return LoadBalancerProbesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_interface_ip_configurations(self):
        api_version = self._get_api_version("network_interface_ip_configurations")
        return NetworkInterfaceIPConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_interface_load_balancers(self):
        api_version = self._get_api_version("network_interface_load_balancers")
        return NetworkInterfaceLoadBalancersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_watchers(self):
        api_version = self._get_api_version("network_watchers")
        return NetworkWatchersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def operations(self):
        api_version = self._get_api_version("operations")
        return Operations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def packet_captures(self):
        api_version = self._get_api_version("packet_captures")
        return PacketCapturesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def route_filter_rules(self):
        api_version = self._get_api_version("route_filter_rules")
        return RouteFilterRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def route_filters(self):
        api_version = self._get_api_version("route_filters")
        return RouteFiltersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2017-10-01', '2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_network_peerings(self):
        api_version = self._get_api_version("virtual_network_peerings")
        return VirtualNetworkPeeringsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def azure_firewalls(self):
        api_version = self._get_api_version("azure_firewalls")
        return AzureFirewallsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def ddos_protection_plans(self):
        api_version = self._get_api_version("ddos_protection_plans")
        return DdosProtectionPlansOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_circuit_connections(self):
        api_version = self._get_api_version("express_route_circuit_connections")
        return ExpressRouteCircuitConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_cross_connection_peerings(self):
        api_version = self._get_api_version("express_route_cross_connection_peerings")
        return ExpressRouteCrossConnectionPeeringsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_cross_connections(self):
        api_version = self._get_api_version("express_route_cross_connections")
        return ExpressRouteCrossConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def hub_virtual_network_connections(self):
        api_version = self._get_api_version("hub_virtual_network_connections")
        return HubVirtualNetworkConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_hubs(self):
        api_version = self._get_api_version("virtual_hubs")
        return VirtualHubsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_wans(self):
        api_version = self._get_api_version("virtual_wans")
        return VirtualWansOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_connections(self):
        api_version = self._get_api_version("vpn_connections")
        return VpnConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_gateways(self):
        api_version = self._get_api_version("vpn_gateways")
        return VpnGatewaysOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_sites_configuration(self):
        api_version = self._get_api_version("vpn_sites_configuration")
        return VpnSitesConfigurationOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-04-01', '2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_sites(self):
        api_version = self._get_api_version("vpn_sites")
        return VpnSitesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def available_delegations(self):
        api_version = self._get_api_version("available_delegations")
        return AvailableDelegationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def available_resource_group_delegations(self):
        api_version = self._get_api_version("available_resource_group_delegations")
        return AvailableResourceGroupDelegationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def azure_firewall_fqdn_tags(self):
        api_version = self._get_api_version("azure_firewall_fqdn_tags")
        return AzureFirewallFqdnTagsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def ddos_custom_policies(self):
        api_version = self._get_api_version("ddos_custom_policies")
        return DdosCustomPoliciesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_connections(self):
        api_version = self._get_api_version("express_route_connections")
        return ExpressRouteConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_gateways(self):
        api_version = self._get_api_version("express_route_gateways")
        return ExpressRouteGatewaysOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_links(self):
        api_version = self._get_api_version("express_route_links")
        return ExpressRouteLinksOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_ports_locations(self):
        api_version = self._get_api_version("express_route_ports_locations")
        return ExpressRoutePortsLocationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_ports(self):
        api_version = self._get_api_version("express_route_ports")
        return ExpressRoutePortsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01']
    )
    def interface_endpoints(self):
        api_version = self._get_api_version("interface_endpoints")
        return InterfaceEndpointsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def load_balancer_outbound_rules(self):
        api_version = self._get_api_version("load_balancer_outbound_rules")
        return LoadBalancerOutboundRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_interface_tap_configurations(self):
        api_version = self._get_api_version("network_interface_tap_configurations")
        return NetworkInterfaceTapConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_profiles(self):
        api_version = self._get_api_version("network_profiles")
        return NetworkProfilesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def p2_svpn_gateways(self):
        api_version = self._get_api_version("p2_svpn_gateways")
        return P2SVpnGatewaysOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01']
    )
    def p2_svpn_server_configurations(self):
        api_version = self._get_api_version("p2_svpn_server_configurations")
        return P2SVpnServerConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def public_ip_prefixes(self):
        api_version = self._get_api_version("public_ip_prefixes")
        return PublicIPPrefixesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def service_endpoint_policies(self):
        api_version = self._get_api_version("service_endpoint_policies")
        return ServiceEndpointPoliciesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def service_endpoint_policy_definitions(self):
        api_version = self._get_api_version("service_endpoint_policy_definitions")
        return ServiceEndpointPolicyDefinitionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-11-01', '2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_network_taps(self):
        api_version = self._get_api_version("virtual_network_taps")
        return VirtualNetworkTapsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def peer_express_route_circuit_connections(self):
        api_version = self._get_api_version("peer_express_route_circuit_connections")
        return PeerExpressRouteCircuitConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2018-12-01', '2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def web_application_firewall_policies(self):
        api_version = self._get_api_version("web_application_firewall_policies")
        return WebApplicationFirewallPoliciesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def nat_gateways(self):
        api_version = self._get_api_version("nat_gateways")
        return NatGatewaysOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def resource_navigation_links(self):
        api_version = self._get_api_version("resource_navigation_links")
        return ResourceNavigationLinksOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-02-01', '2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def service_association_links(self):
        api_version = self._get_api_version("service_association_links")
        return ServiceAssociationLinksOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def available_private_endpoint_types(self):
        api_version = self._get_api_version("available_private_endpoint_types")
        return AvailablePrivateEndpointTypesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def bastion_hosts(self):
        api_version = self._get_api_version("bastion_hosts")
        return BastionHostsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def private_endpoints(self):
        api_version = self._get_api_version("private_endpoints")
        return PrivateEndpointsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def private_link_services(self):
        api_version = self._get_api_version("private_link_services")
        return PrivateLinkServicesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-04-01', '2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def service_tags(self):
        api_version = self._get_api_version("service_tags")
        return ServiceTagsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def firewall_policies(self):
        api_version = self._get_api_version("firewall_policies")
        return FirewallPoliciesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01']
    )
    def firewall_policy_rule_groups(self):
        api_version = self._get_api_version("firewall_policy_rule_groups")
        return FirewallPolicyRuleGroupsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_link_connections(self):
        api_version = self._get_api_version("vpn_link_connections")
        return VpnLinkConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_site_link_connections(self):
        api_version = self._get_api_version("vpn_site_link_connections")
        return VpnSiteLinkConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-06-01', '2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_site_links(self):
        api_version = self._get_api_version("vpn_site_links")
        return VpnSiteLinksOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_router_peerings(self):
        api_version = self._get_api_version("virtual_router_peerings")
        return VirtualRouterPeeringsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-07-01', '2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_routers(self):
        api_version = self._get_api_version("virtual_routers")
        return VirtualRoutersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def available_service_aliases(self):
        api_version = self._get_api_version("available_service_aliases")
        return AvailableServiceAliasesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_server_configurations_associated_with_virtual_wan(self):
        api_version = self._get_api_version("vpn_server_configurations_associated_with_virtual_wan")
        return VpnServerConfigurationsAssociatedWithVirtualWanOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-08-01', '2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vpn_server_configurations(self):
        api_version = self._get_api_version("vpn_server_configurations")
        return VpnServerConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def ip_groups(self):
        api_version = self._get_api_version("ip_groups")
        return IpGroupsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-09-01', '2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_hub_route_table_v2_s(self):
        api_version = self._get_api_version("virtual_hub_route_table_v2_s")
        return VirtualHubRouteTableV2SOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-11-01', '2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def flow_logs(self):
        api_version = self._get_api_version("flow_logs")
        return FlowLogsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2019-12-01', '2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_virtual_appliances(self):
        api_version = self._get_api_version("network_virtual_appliances")
        return NetworkVirtualAppliancesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def ip_allocations(self):
        api_version = self._get_api_version("ip_allocations")
        return IpAllocationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def private_dns_zone_groups(self):
        api_version = self._get_api_version("private_dns_zone_groups")
        return PrivateDnsZoneGroupsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-03-01', '2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def security_partner_providers(self):
        api_version = self._get_api_version("security_partner_providers")
        return SecurityPartnerProvidersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-04-01', '2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def hub_route_tables(self):
        api_version = self._get_api_version("hub_route_tables")
        return HubRouteTablesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def application_gateway_private_endpoint_connections(self):
        api_version = self._get_api_version("application_gateway_private_endpoint_connections")
        return ApplicationGatewayPrivateEndpointConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def application_gateway_private_link_resources(self):
        api_version = self._get_api_version("application_gateway_private_link_resources")
        return ApplicationGatewayPrivateLinkResourcesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def firewall_policy_rule_collection_groups(self):
        api_version = self._get_api_version("firewall_policy_rule_collection_groups")
        return FirewallPolicyRuleCollectionGroupsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_appliance_sites(self):
        api_version = self._get_api_version("virtual_appliance_sites")
        return VirtualApplianceSitesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_appliance_skus(self):
        api_version = self._get_api_version("virtual_appliance_skus")
        return VirtualApplianceSkusOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_hub_bgp_connection(self):
        api_version = self._get_api_version("virtual_hub_bgp_connection")
        return VirtualHubBgpConnectionOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_hub_bgp_connections(self):
        api_version = self._get_api_version("virtual_hub_bgp_connections")
        return VirtualHubBgpConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-05-01', '2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_hub_ip_configuration(self):
        api_version = self._get_api_version("virtual_hub_ip_configuration")
        return VirtualHubIpConfigurationOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def custom_ip_prefixes(self):
        api_version = self._get_api_version("custom_ip_prefixes")
        return CustomIPPrefixesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def dscp_configuration(self):
        api_version = self._get_api_version("dscp_configuration")
        return DscpConfigurationOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-06-01', '2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def inbound_security_rule(self):
        api_version = self._get_api_version("inbound_security_rule")
        return InboundSecurityRuleOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-07-01', '2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def web_categories(self):
        api_version = self._get_api_version("web_categories")
        return WebCategoriesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2020-08-01', '2020-11-01', '2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def nat_rules(self):
        api_version = self._get_api_version("nat_rules")
        return NatRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def virtual_network_gateway_nat_rules(self):
        api_version = self._get_api_version("virtual_network_gateway_nat_rules")
        return VirtualNetworkGatewayNatRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def active_connectivity_configurations(self):
        api_version = self._get_api_version("active_connectivity_configurations")
        return ActiveConnectivityConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def active_security_admin_rules(self):
        api_version = self._get_api_version("active_security_admin_rules")
        return ActiveSecurityAdminRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def active_security_user_rules(self):
        api_version = self._get_api_version("active_security_user_rules")
        return ActiveSecurityUserRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def admin_rule_collections(self):
        api_version = self._get_api_version("admin_rule_collections")
        return AdminRuleCollectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def admin_rules(self):
        api_version = self._get_api_version("admin_rules")
        return AdminRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def connectivity_configurations(self):
        api_version = self._get_api_version("connectivity_configurations")
        return ConnectivityConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def effective_connectivity_configurations(self):
        api_version = self._get_api_version("effective_connectivity_configurations")
        return EffectiveConnectivityConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def effective_virtual_networks(self):
        api_version = self._get_api_version("effective_virtual_networks")
        return EffectiveVirtualNetworksOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_groups(self):
        api_version = self._get_api_version("network_groups")
        return NetworkGroupsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_manager_commits(self):
        api_version = self._get_api_version("network_manager_commits")
        return NetworkManagerCommitsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_manager_deployment_status(self):
        api_version = self._get_api_version("network_manager_deployment_status")
        return NetworkManagerDeploymentStatusOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def network_manager_effective_security_admin_rules(self):
        api_version = self._get_api_version("network_manager_effective_security_admin_rules")
        return NetworkManagerEffectiveSecurityAdminRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def network_managers(self):
        api_version = self._get_api_version("network_managers")
        return NetworkManagersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def network_security_perimeters(self):
        api_version = self._get_api_version("network_security_perimeters")
        return NetworkSecurityPerimetersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def nsp_access_rules(self):
        api_version = self._get_api_version("nsp_access_rules")
        return NspAccessRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def nsp_access_rules_reconcile(self):
        api_version = self._get_api_version("nsp_access_rules_reconcile")
        return NspAccessRulesReconcileOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def nsp_association_reconcile(self):
        api_version = self._get_api_version("nsp_association_reconcile")
        return NspAssociationReconcileOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def nsp_associations(self):
        api_version = self._get_api_version("nsp_associations")
        return NspAssociationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def nsp_link_references(self):
        api_version = self._get_api_version("nsp_link_references")
        return NspLinkReferencesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def nsp_links(self):
        api_version = self._get_api_version("nsp_links")
        return NspLinksOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def nsp_profiles(self):
        api_version = self._get_api_version("nsp_profiles")
        return NspProfilesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def perimeter_associable_resource_types(self):
        api_version = self._get_api_version("perimeter_associable_resource_types")
        return PerimeterAssociableResourceTypesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview', '2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def security_admin_configurations(self):
        api_version = self._get_api_version("security_admin_configurations")
        return SecurityAdminConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def security_user_configurations(self):
        api_version = self._get_api_version("security_user_configurations")
        return SecurityUserConfigurationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def user_rule_collections(self):
        api_version = self._get_api_version("user_rule_collections")
        return UserRuleCollectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2021-02-01-preview']
    )
    def user_rules(self):
        api_version = self._get_api_version("user_rules")
        return UserRulesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def application_gateway_waf_dynamic_manifests_default(self):
        api_version = self._get_api_version("application_gateway_waf_dynamic_manifests_default")
        return ApplicationGatewayWafDynamicManifestsDefaultOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def application_gateway_waf_dynamic_manifests(self):
        api_version = self._get_api_version("application_gateway_waf_dynamic_manifests")
        return ApplicationGatewayWafDynamicManifestsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def configuration_policy_groups(self):
        api_version = self._get_api_version("configuration_policy_groups")
        return ConfigurationPolicyGroupsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_port_authorizations(self):
        api_version = self._get_api_version("express_route_port_authorizations")
        return ExpressRoutePortAuthorizationsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def express_route_provider_ports_location(self):
        api_version = self._get_api_version("express_route_provider_ports_location")
        return ExpressRouteProviderPortsLocationOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def firewall_policy_idps_signatures_filter_values(self):
        api_version = self._get_api_version("firewall_policy_idps_signatures_filter_values")
        return FirewallPolicyIdpsSignaturesFilterValuesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def firewall_policy_idps_signatures(self):
        api_version = self._get_api_version("firewall_policy_idps_signatures")
        return FirewallPolicyIdpsSignaturesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def firewall_policy_idps_signatures_overrides(self):
        api_version = self._get_api_version("firewall_policy_idps_signatures_overrides")
        return FirewallPolicyIdpsSignaturesOverridesOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def management_group_network_manager_connections(self):
        api_version = self._get_api_version("management_group_network_manager_connections")
        return ManagementGroupNetworkManagerConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def route_maps(self):
        api_version = self._get_api_version("route_maps")
        return RouteMapsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def routing_intent(self):
        api_version = self._get_api_version("routing_intent")
        return RoutingIntentOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def scope_connections(self):
        api_version = self._get_api_version("scope_connections")
        return ScopeConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def service_tag_information(self):
        api_version = self._get_api_version("service_tag_information")
        return ServiceTagInformationOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def static_members(self):
        api_version = self._get_api_version("static_members")
        return StaticMembersOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def subscription_network_manager_connections(self):
        api_version = self._get_api_version("subscription_network_manager_connections")
        return SubscriptionNetworkManagerConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-02-01', '2023-04-01', '2023-05-01', '2023-06-01', '2023-09-01']
    )
    def vip_swap(self):
        api_version = self._get_api_version("vip_swap")
        return VipSwapOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    @property
    @api_version_validation(
        method_valid_on=['2023-06-01', '2023-09-01']
    )
    def network_virtual_appliance_connections(self):
        api_version = self._get_api_version("network_virtual_appliance_connections")
        return NetworkVirtualApplianceConnectionsOperations(
            self._client,
            self._config,
            Serializer(self._models_dict()),
            Deserializer(self._models_dict()),
            api_version=api_version,
        )

    def close(self):
        self._client.close()
    def __enter__(self):
        self._client.__enter__()
        return self
    def __exit__(self, *exc_details):
        self._client.__exit__(*exc_details)
