# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._test_base_enums import *


class AnalysisResultListResult(msrest.serialization.Model):
    """A list of Analysis Results. It will only contain one element as all the data will be nested in a singleton object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Analysis Results.
    :type value: list[~test_base.models.AnalysisResultSingletonResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AnalysisResultSingletonResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AnalysisResultSingletonResource"]] = None,
        **kwargs
    ):
        super(AnalysisResultListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(msrest.serialization.Model):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for an ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class AnalysisResultSingletonResource(ProxyResource):
    """The Analysis Result Singleton Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Type of the Analysis Result.Constant filled by server.  Possible
     values include: "ScriptExecution", "Reliability", "CPUUtilization", "MemoryUtilization",
     "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'grade': {'key': 'properties.grade', 'type': 'str'},
        'analysis_result_type': {'key': 'properties.analysisResultType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        **kwargs
    ):
        super(AnalysisResultSingletonResource, self).__init__(**kwargs)
        self.system_data = None
        self.grade = grade
        self.analysis_result_type = None  # type: Optional[str]


class AnalysisResultSingletonResourceProperties(msrest.serialization.Model):
    """The properties of Analysis Result resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CPURegressionResultSingletonResourceProperties, CPUUtilizationResultSingletonResourceProperties, MemoryRegressionResultSingletonResourceProperties, MemoryUtilizationResultSingletonResourceProperties, ReliabilityResultSingletonResourceProperties, ScriptExecutionResultSingletonResourceProperties, TestAnalysisResultSingletonResourceProperties.

    All required parameters must be populated in order to send to Azure.

    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Required. Type of the Analysis Result.Constant filled by server.
     Possible values include: "ScriptExecution", "Reliability", "CPUUtilization",
     "MemoryUtilization", "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    """

    _validation = {
        'analysis_result_type': {'required': True},
    }

    _attribute_map = {
        'grade': {'key': 'grade', 'type': 'str'},
        'analysis_result_type': {'key': 'analysisResultType', 'type': 'str'},
    }

    _subtype_map = {
        'analysis_result_type': {'CPURegression': 'CPURegressionResultSingletonResourceProperties', 'CPUUtilization': 'CPUUtilizationResultSingletonResourceProperties', 'MemoryRegression': 'MemoryRegressionResultSingletonResourceProperties', 'MemoryUtilization': 'MemoryUtilizationResultSingletonResourceProperties', 'Reliability': 'ReliabilityResultSingletonResourceProperties', 'ScriptExecution': 'ScriptExecutionResultSingletonResourceProperties', 'TestAnalysis': 'TestAnalysisResultSingletonResourceProperties'}
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        **kwargs
    ):
        super(AnalysisResultSingletonResourceProperties, self).__init__(**kwargs)
        self.grade = grade
        self.analysis_result_type = None  # type: Optional[str]


class AvailableOSListResult(msrest.serialization.Model):
    """A list of available OSs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of available OSs.
    :type value: list[~test_base.models.AvailableOSResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailableOSResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["AvailableOSResource"]] = None,
        **kwargs
    ):
        super(AvailableOSListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class AvailableOSResource(ProxyResource):
    """The Available OS resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param os_id: The Id of an Available OS of a Test Base Account.
    :type os_id: str
    :param os_name: The name of an Available OS of a Test Base Account.
    :type os_name: str
    :param os_version: The version of an Available OS of a Test Base Account.
    :type os_version: str
    :param insider_channel: The insider channel of an Available OS of a Test Base Account.
    :type insider_channel: str
    :param os_update_type: The OS update type of an Available OS of a Test Base Account.
    :type os_update_type: str
    :param os_platform: The Platform of an Available OS of a Test Base Account.
    :type os_platform: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'os_id': {'key': 'properties.osId', 'type': 'str'},
        'os_name': {'key': 'properties.osName', 'type': 'str'},
        'os_version': {'key': 'properties.osVersion', 'type': 'str'},
        'insider_channel': {'key': 'properties.insiderChannel', 'type': 'str'},
        'os_update_type': {'key': 'properties.osUpdateType', 'type': 'str'},
        'os_platform': {'key': 'properties.osPlatform', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_id: Optional[str] = None,
        os_name: Optional[str] = None,
        os_version: Optional[str] = None,
        insider_channel: Optional[str] = None,
        os_update_type: Optional[str] = None,
        os_platform: Optional[str] = None,
        **kwargs
    ):
        super(AvailableOSResource, self).__init__(**kwargs)
        self.system_data = None
        self.os_id = os_id
        self.os_name = os_name
        self.os_version = os_version
        self.insider_channel = insider_channel
        self.os_update_type = os_update_type
        self.os_platform = os_platform


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """Description of a Check Name availability response properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name_available: Value indicating the availability of the name: true if the name is
     available; otherwise, false.
    :type name_available: bool
    :param reason: The reason for unavailability of a name. Required if nameAvailable == false.
     Possible values include: "Invalid", "AlreadyExists".
    :type reason: str or ~test_base.models.Reason
    :ivar message: The detailed info regarding the reason associated with the name. Required if
     nameAvailable == false.
    :vartype message: str
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "Reason"]] = None,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = None


class Command(msrest.serialization.Model):
    """The command used in the test.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the command.
    :type name: str
    :param action: Required. The action of the command. Possible values include: "Install",
     "Launch", "Close", "Uninstall", "Custom".
    :type action: str or ~test_base.models.Action
    :param content_type: Required. The type of command content. Possible values include: "Inline",
     "File", "Path".
    :type content_type: str or ~test_base.models.ContentType
    :param content: Required. The content of the command. The content depends on source type.
    :type content: str
    :param run_elevated: Specifies whether to run the command as administrator.
    :type run_elevated: bool
    :param restart_after: Specifies whether to restart the VM after the command executed.
    :type restart_after: bool
    :param max_run_time: Specifies the max run time of the command.
    :type max_run_time: int
    :param run_as_interactive: Specifies whether to run the command in interactive mode.
    :type run_as_interactive: bool
    :param always_run: Specifies whether to run the command even if a previous command is failed.
    :type always_run: bool
    :param apply_update_before: Specifies whether to apply update before the command.
    :type apply_update_before: bool
    """

    _validation = {
        'name': {'required': True},
        'action': {'required': True},
        'content_type': {'required': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'run_elevated': {'key': 'runElevated', 'type': 'bool'},
        'restart_after': {'key': 'restartAfter', 'type': 'bool'},
        'max_run_time': {'key': 'maxRunTime', 'type': 'int'},
        'run_as_interactive': {'key': 'runAsInteractive', 'type': 'bool'},
        'always_run': {'key': 'alwaysRun', 'type': 'bool'},
        'apply_update_before': {'key': 'applyUpdateBefore', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        action: Union[str, "Action"],
        content_type: Union[str, "ContentType"],
        content: str,
        run_elevated: Optional[bool] = None,
        restart_after: Optional[bool] = None,
        max_run_time: Optional[int] = None,
        run_as_interactive: Optional[bool] = None,
        always_run: Optional[bool] = None,
        apply_update_before: Optional[bool] = None,
        **kwargs
    ):
        super(Command, self).__init__(**kwargs)
        self.name = name
        self.action = action
        self.content_type = content_type
        self.content = content
        self.run_elevated = run_elevated
        self.restart_after = restart_after
        self.max_run_time = max_run_time
        self.run_as_interactive = run_as_interactive
        self.always_run = always_run
        self.apply_update_before = apply_update_before


class CPURegressionResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of CPU Regression Result.

    All required parameters must be populated in order to send to Azure.

    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Required. Type of the Analysis Result.Constant filled by server.
     Possible values include: "ScriptExecution", "Reliability", "CPUUtilization",
     "MemoryUtilization", "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    :param cpu_regression_results: The result array data.
    :type cpu_regression_results: list[~test_base.models.RegressionResult]
    """

    _validation = {
        'analysis_result_type': {'required': True},
    }

    _attribute_map = {
        'grade': {'key': 'grade', 'type': 'str'},
        'analysis_result_type': {'key': 'analysisResultType', 'type': 'str'},
        'cpu_regression_results': {'key': 'cpuRegressionResults', 'type': '[RegressionResult]'},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        cpu_regression_results: Optional[List["RegressionResult"]] = None,
        **kwargs
    ):
        super(CPURegressionResultSingletonResourceProperties, self).__init__(grade=grade, **kwargs)
        self.analysis_result_type = 'CPURegression'  # type: str
        self.cpu_regression_results = cpu_regression_results


class CPUUtilizationResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of CPU Utilization Result.

    All required parameters must be populated in order to send to Azure.

    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Required. Type of the Analysis Result.Constant filled by server.
     Possible values include: "ScriptExecution", "Reliability", "CPUUtilization",
     "MemoryUtilization", "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    :param cpu_utilization_results: The result array data.
    :type cpu_utilization_results: list[~test_base.models.UtilizationResult]
    """

    _validation = {
        'analysis_result_type': {'required': True},
    }

    _attribute_map = {
        'grade': {'key': 'grade', 'type': 'str'},
        'analysis_result_type': {'key': 'analysisResultType', 'type': 'str'},
        'cpu_utilization_results': {'key': 'cpuUtilizationResults', 'type': '[UtilizationResult]'},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        cpu_utilization_results: Optional[List["UtilizationResult"]] = None,
        **kwargs
    ):
        super(CPUUtilizationResultSingletonResourceProperties, self).__init__(grade=grade, **kwargs)
        self.analysis_result_type = 'CPUUtilization'  # type: str
        self.cpu_utilization_results = cpu_utilization_results


class CustomerEventListResult(msrest.serialization.Model):
    """A list of Test Base Customer Events.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Test Base Customer Events.
    :type value: list[~test_base.models.CustomerEventResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CustomerEventResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CustomerEventResource"]] = None,
        **kwargs
    ):
        super(CustomerEventListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CustomerEventResource(ProxyResource):
    """The Customer Notification Event resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param event_name: The name of the event subscribed to.
    :type event_name: str
    :param receivers: The notification event receivers.
    :type receivers: list[~test_base.models.NotificationEventReceiver]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'event_name': {'key': 'properties.eventName', 'type': 'str'},
        'receivers': {'key': 'properties.receivers', 'type': '[NotificationEventReceiver]'},
    }

    def __init__(
        self,
        *,
        event_name: Optional[str] = None,
        receivers: Optional[List["NotificationEventReceiver"]] = None,
        **kwargs
    ):
        super(CustomerEventResource, self).__init__(**kwargs)
        self.system_data = None
        self.event_name = event_name
        self.receivers = receivers


class DistributionGroupListReceiverValue(msrest.serialization.Model):
    """The user object receiver value.

    :param distribution_groups: The list of distribution groups.
    :type distribution_groups: list[str]
    """

    _attribute_map = {
        'distribution_groups': {'key': 'distributionGroups', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        distribution_groups: Optional[List[str]] = None,
        **kwargs
    ):
        super(DistributionGroupListReceiverValue, self).__init__(**kwargs)
        self.distribution_groups = distribution_groups


class DownloadURLResponse(msrest.serialization.Model):
    """The response of getting a download URL.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar download_url: The download URL.
    :vartype download_url: str
    :ivar expiration_time: Expiry date of the download URL.
    :vartype expiration_time: ~datetime.datetime
    """

    _validation = {
        'download_url': {'readonly': True},
        'expiration_time': {'readonly': True},
    }

    _attribute_map = {
        'download_url': {'key': 'downloadUrl', 'type': 'str'},
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DownloadURLResponse, self).__init__(**kwargs)
        self.download_url = None
        self.expiration_time = None


class EmailEventListResult(msrest.serialization.Model):
    """A list of email events.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of email events.
    :type value: list[~test_base.models.EmailEventResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EmailEventResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EmailEventResource"]] = None,
        **kwargs
    ):
        super(EmailEventListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class EmailEventResource(ProxyResource):
    """The email event resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param event_id: The identifier of the email event.
    :type event_id: str
    :param event_name: The name of the email event.
    :type event_name: str
    :param display_name: The display name of the email event.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'event_id': {'key': 'properties.eventId', 'type': 'str'},
        'event_name': {'key': 'properties.eventName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        event_name: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(EmailEventResource, self).__init__(**kwargs)
        self.system_data = None
        self.event_id = event_id
        self.event_name = event_name
        self.display_name = display_name


class ErrorDefinition(msrest.serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~test_base.models.ErrorDefinition]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDefinition, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None


class ErrorResponse(msrest.serialization.Model):
    """The error response send when an operation fails.

    :param error: The error details.
    :type error: ~test_base.models.ErrorDefinition
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDefinition"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class FavoriteProcessListResult(msrest.serialization.Model):
    """A list of favorite processes for a package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of favorite processes for a package.
    :type value: list[~test_base.models.FavoriteProcessResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FavoriteProcessResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["FavoriteProcessResource"]] = None,
        **kwargs
    ):
        super(FavoriteProcessListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class FavoriteProcessResource(ProxyResource):
    """A favorite process identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param actual_process_name: The actual name of the favorite process. It will be equal to
     resource name except for the scenario that the process name contains characters that are not
     allowed in the resource name.
    :type actual_process_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'actual_process_name': {'key': 'properties.actualProcessName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        actual_process_name: Optional[str] = None,
        **kwargs
    ):
        super(FavoriteProcessResource, self).__init__(**kwargs)
        self.system_data = None
        self.actual_process_name = actual_process_name


class FileUploadURLResponse(msrest.serialization.Model):
    """The URL response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar upload_url: The URL used for uploading the package.
    :vartype upload_url: str
    :ivar blob_path: The blob path of the uploaded package. It will be used as the 'blobPath'
     property of PackageResource.
    :vartype blob_path: str
    """

    _validation = {
        'upload_url': {'readonly': True},
        'blob_path': {'readonly': True},
    }

    _attribute_map = {
        'upload_url': {'key': 'uploadUrl', 'type': 'str'},
        'blob_path': {'key': 'blobPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileUploadURLResponse, self).__init__(**kwargs)
        self.upload_url = None
        self.blob_path = None


class FlightingRingListResult(msrest.serialization.Model):
    """A list of flighting rings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of flighting rings.
    :type value: list[~test_base.models.FlightingRingResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FlightingRingResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["FlightingRingResource"]] = None,
        **kwargs
    ):
        super(FlightingRingListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class FlightingRingResource(ProxyResource):
    """The flighting ring resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param actual_flighting_ring_name: The actual name of a flighting ring of a Test Base Account.
    :type actual_flighting_ring_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'actual_flighting_ring_name': {'key': 'properties.actualFlightingRingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        actual_flighting_ring_name: Optional[str] = None,
        **kwargs
    ):
        super(FlightingRingResource, self).__init__(**kwargs)
        self.system_data = None
        self.actual_flighting_ring_name = actual_flighting_ring_name


class GetFileUploadURLParameters(msrest.serialization.Model):
    """The parameters supplied to the Test Base Account GetFileUploadURL action.

    :param blob_name: The custom file name of the uploaded blob.
    :type blob_name: str
    """

    _attribute_map = {
        'blob_name': {'key': 'blobName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_name: Optional[str] = None,
        **kwargs
    ):
        super(GetFileUploadURLParameters, self).__init__(**kwargs)
        self.blob_name = blob_name


class IdentifiedFailure(msrest.serialization.Model):
    """The failure identified.

    :param failure_id: The Failure Id.
    :type failure_id: str
    :param category: The category of the failure. Possible values include: "None", "Unidentified",
     "Package", "OSUpdate", "Infrastructure".
    :type category: str or ~test_base.models.Category
    :param error_message: Message that shows information about the failure.
    :type error_message: str
    :param guidance: Guidance that shows what the customer needs to do for this failure.
    :type guidance: str
    """

    _attribute_map = {
        'failure_id': {'key': 'failureId', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'guidance': {'key': 'guidance', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        failure_id: Optional[str] = None,
        category: Optional[Union[str, "Category"]] = None,
        error_message: Optional[str] = None,
        guidance: Optional[str] = None,
        **kwargs
    ):
        super(IdentifiedFailure, self).__init__(**kwargs)
        self.failure_id = failure_id
        self.category = category
        self.error_message = error_message
        self.guidance = guidance


class MemoryRegressionResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Memory Regression Result.

    All required parameters must be populated in order to send to Azure.

    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Required. Type of the Analysis Result.Constant filled by server.
     Possible values include: "ScriptExecution", "Reliability", "CPUUtilization",
     "MemoryUtilization", "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    :param memory_regression_results: The result array data.
    :type memory_regression_results: list[~test_base.models.RegressionResult]
    """

    _validation = {
        'analysis_result_type': {'required': True},
    }

    _attribute_map = {
        'grade': {'key': 'grade', 'type': 'str'},
        'analysis_result_type': {'key': 'analysisResultType', 'type': 'str'},
        'memory_regression_results': {'key': 'memoryRegressionResults', 'type': '[RegressionResult]'},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        memory_regression_results: Optional[List["RegressionResult"]] = None,
        **kwargs
    ):
        super(MemoryRegressionResultSingletonResourceProperties, self).__init__(grade=grade, **kwargs)
        self.analysis_result_type = 'MemoryRegression'  # type: str
        self.memory_regression_results = memory_regression_results


class MemoryUtilizationResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Memory Utilization Result.

    All required parameters must be populated in order to send to Azure.

    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Required. Type of the Analysis Result.Constant filled by server.
     Possible values include: "ScriptExecution", "Reliability", "CPUUtilization",
     "MemoryUtilization", "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    :param memory_utilization_results: The result array data.
    :type memory_utilization_results: list[~test_base.models.UtilizationResult]
    """

    _validation = {
        'analysis_result_type': {'required': True},
    }

    _attribute_map = {
        'grade': {'key': 'grade', 'type': 'str'},
        'analysis_result_type': {'key': 'analysisResultType', 'type': 'str'},
        'memory_utilization_results': {'key': 'memoryUtilizationResults', 'type': '[UtilizationResult]'},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        memory_utilization_results: Optional[List["UtilizationResult"]] = None,
        **kwargs
    ):
        super(MemoryUtilizationResultSingletonResourceProperties, self).__init__(grade=grade, **kwargs)
        self.analysis_result_type = 'MemoryUtilization'  # type: str
        self.memory_utilization_results = memory_utilization_results


class NotificationEventReceiver(msrest.serialization.Model):
    """A notification event receivers.

    :param receiver_type: The type of the notification event receiver.
    :type receiver_type: str
    :param receiver_value: The notification event receiver value.
    :type receiver_value: ~test_base.models.NotificationReceiverValue
    """

    _attribute_map = {
        'receiver_type': {'key': 'receiverType', 'type': 'str'},
        'receiver_value': {'key': 'receiverValue', 'type': 'NotificationReceiverValue'},
    }

    def __init__(
        self,
        *,
        receiver_type: Optional[str] = None,
        receiver_value: Optional["NotificationReceiverValue"] = None,
        **kwargs
    ):
        super(NotificationEventReceiver, self).__init__(**kwargs)
        self.receiver_type = receiver_type
        self.receiver_value = receiver_value


class NotificationReceiverValue(msrest.serialization.Model):
    """A notification event receiver value.

    :param user_object_receiver_value: The user object receiver value.
    :type user_object_receiver_value: ~test_base.models.UserObjectReceiverValue
    :param subscription_receiver_value: The user object receiver value.
    :type subscription_receiver_value: ~test_base.models.SubscriptionReceiverValue
    :param distribution_group_list_receiver_value: The user object receiver value.
    :type distribution_group_list_receiver_value:
     ~test_base.models.DistributionGroupListReceiverValue
    """

    _attribute_map = {
        'user_object_receiver_value': {'key': 'userObjectReceiverValue', 'type': 'UserObjectReceiverValue'},
        'subscription_receiver_value': {'key': 'subscriptionReceiverValue', 'type': 'SubscriptionReceiverValue'},
        'distribution_group_list_receiver_value': {'key': 'distributionGroupListReceiverValue', 'type': 'DistributionGroupListReceiverValue'},
    }

    def __init__(
        self,
        *,
        user_object_receiver_value: Optional["UserObjectReceiverValue"] = None,
        subscription_receiver_value: Optional["SubscriptionReceiverValue"] = None,
        distribution_group_list_receiver_value: Optional["DistributionGroupListReceiverValue"] = None,
        **kwargs
    ):
        super(NotificationReceiverValue, self).__init__(**kwargs)
        self.user_object_receiver_value = user_object_receiver_value
        self.subscription_receiver_value = subscription_receiver_value
        self.distribution_group_list_receiver_value = distribution_group_list_receiver_value


class Operation(msrest.serialization.Model):
    """REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :param display: The object that describes the operation.
    :type display: ~test_base.models.OperationDisplay
    :param properties: Extra properties of the operation.
    :type properties: any
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'origin': {'key': 'origin', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.origin = None
        self.display = display
        self.properties = properties


class OperationDisplay(msrest.serialization.Model):
    """The object that describes the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The resource provider name: Microsoft.TestBase.
    :vartype provider: str
    :ivar operation: Operation type: read, write, delete, listPackages, etc.
    :vartype operation: str
    :ivar resource: Resource type on which the operation is performed.
    :vartype resource: str
    :ivar description: Friendly name of the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.operation = None
        self.resource = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of operations supported by the resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by the Test Base resource provider.
    :type value: list[~test_base.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class OSUpdateListResult(msrest.serialization.Model):
    """A list of OS Updates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of OS Updates.
    :type value: list[~test_base.models.OSUpdateResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OSUpdateResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OSUpdateResource"]] = None,
        **kwargs
    ):
        super(OSUpdateListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class OSUpdateResource(ProxyResource):
    """An OS Update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param os_name: The name of the OS.
    :type os_name: str
    :param release: The name of tested release.
    :type release: str
    :param flighting_ring: The flighting ring, only for release of feature updates.
    :type flighting_ring: str
    :param build_version: The build version of the tested release (OS update).
    :type build_version: str
    :param build_revision: The build revision of the tested release (OS update).
    :type build_revision: str
    :param type_properties_type: The type of this release (OS update). Possible values include:
     "SecurityUpdate", "FeatureUpdate".
    :type type_properties_type: str or ~test_base.models.Type
    :param release_version_date: The release version date the tested release (OS update).
    :type release_version_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'os_name': {'key': 'properties.osName', 'type': 'str'},
        'release': {'key': 'properties.release', 'type': 'str'},
        'flighting_ring': {'key': 'properties.flightingRing', 'type': 'str'},
        'build_version': {'key': 'properties.buildVersion', 'type': 'str'},
        'build_revision': {'key': 'properties.buildRevision', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'release_version_date': {'key': 'properties.releaseVersionDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        os_name: Optional[str] = None,
        release: Optional[str] = None,
        flighting_ring: Optional[str] = None,
        build_version: Optional[str] = None,
        build_revision: Optional[str] = None,
        type_properties_type: Optional[Union[str, "Type"]] = None,
        release_version_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(OSUpdateResource, self).__init__(**kwargs)
        self.system_data = None
        self.os_name = os_name
        self.release = release
        self.flighting_ring = flighting_ring
        self.build_version = build_version
        self.build_revision = build_revision
        self.type_properties_type = type_properties_type
        self.release_version_date = release_version_date


class OSUpdatesTestSummary(msrest.serialization.Model):
    """The summary of some tests.

    :param execution_status: The status of the last test. Possible values include: "None",
     "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", "Succeeded".
    :type execution_status: str or ~test_base.models.ExecutionStatus
    :param test_status: The status of last test. Possible values include: "None",
     "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
     "TestAndUpdateFailure", "InfrastructureFailure", "Completed".
    :type test_status: str or ~test_base.models.TestStatus
    :param grade: The grade of last test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param test_run_time: The run time of the last test.
    :type test_run_time: str
    :param os_update_test_summaries: Detailed summary for each OS update.
    :type os_update_test_summaries: list[~test_base.models.OSUpdateTestSummary]
    """

    _attribute_map = {
        'execution_status': {'key': 'executionStatus', 'type': 'str'},
        'test_status': {'key': 'testStatus', 'type': 'str'},
        'grade': {'key': 'grade', 'type': 'str'},
        'test_run_time': {'key': 'testRunTime', 'type': 'str'},
        'os_update_test_summaries': {'key': 'osUpdateTestSummaries', 'type': '[OSUpdateTestSummary]'},
    }

    def __init__(
        self,
        *,
        execution_status: Optional[Union[str, "ExecutionStatus"]] = None,
        test_status: Optional[Union[str, "TestStatus"]] = None,
        grade: Optional[Union[str, "Grade"]] = None,
        test_run_time: Optional[str] = None,
        os_update_test_summaries: Optional[List["OSUpdateTestSummary"]] = None,
        **kwargs
    ):
        super(OSUpdatesTestSummary, self).__init__(**kwargs)
        self.execution_status = execution_status
        self.test_status = test_status
        self.grade = grade
        self.test_run_time = test_run_time
        self.os_update_test_summaries = os_update_test_summaries


class OSUpdateTestSummary(msrest.serialization.Model):
    """The summary of a test.

    :param os_name: The operating system name. e.g. Windows 10 1809.
    :type os_name: str
    :param release_name: The name of the tested release (OS update).
    :type release_name: str
    :param build_version: The build version of the tested release (OS update).
    :type build_version: str
    :param build_revision: The build revision of the tested release (OS update).
    :type build_revision: str
    :param release_version_date: The release version date.
    :type release_version_date: ~datetime.datetime
    :param flighting_ring: The flighting ring, only for release of feature updates.
    :type flighting_ring: str
    :param execution_status: The execution status of the test. Possible values include: "None",
     "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", "Succeeded".
    :type execution_status: str or ~test_base.models.ExecutionStatus
    :param test_status: The status of the test. Possible values include: "None",
     "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
     "TestAndUpdateFailure", "InfrastructureFailure", "Completed".
    :type test_status: str or ~test_base.models.TestStatus
    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param test_run_time: The run time of the test.
    :type test_run_time: str
    :param test_type: The test type of the package.
    :type test_type: str
    """

    _attribute_map = {
        'os_name': {'key': 'osName', 'type': 'str'},
        'release_name': {'key': 'releaseName', 'type': 'str'},
        'build_version': {'key': 'buildVersion', 'type': 'str'},
        'build_revision': {'key': 'buildRevision', 'type': 'str'},
        'release_version_date': {'key': 'releaseVersionDate', 'type': 'iso-8601'},
        'flighting_ring': {'key': 'flightingRing', 'type': 'str'},
        'execution_status': {'key': 'executionStatus', 'type': 'str'},
        'test_status': {'key': 'testStatus', 'type': 'str'},
        'grade': {'key': 'grade', 'type': 'str'},
        'test_run_time': {'key': 'testRunTime', 'type': 'str'},
        'test_type': {'key': 'testType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_name: Optional[str] = None,
        release_name: Optional[str] = None,
        build_version: Optional[str] = None,
        build_revision: Optional[str] = None,
        release_version_date: Optional[datetime.datetime] = None,
        flighting_ring: Optional[str] = None,
        execution_status: Optional[Union[str, "ExecutionStatus"]] = None,
        test_status: Optional[Union[str, "TestStatus"]] = None,
        grade: Optional[Union[str, "Grade"]] = None,
        test_run_time: Optional[str] = None,
        test_type: Optional[str] = None,
        **kwargs
    ):
        super(OSUpdateTestSummary, self).__init__(**kwargs)
        self.os_name = os_name
        self.release_name = release_name
        self.build_version = build_version
        self.build_revision = build_revision
        self.release_version_date = release_version_date
        self.flighting_ring = flighting_ring
        self.execution_status = execution_status
        self.test_status = test_status
        self.grade = grade
        self.test_run_time = test_run_time
        self.test_type = test_type


class PackageCheckNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters body to pass for Test Base Package name availability check.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param application_name: Required. Application name to verify.
    :type application_name: str
    :param version: Required. Version name to verify.
    :type version: str
    :param type: Required. fully qualified resource type which includes provider namespace.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
        'application_name': {'required': True},
        'version': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'application_name': {'key': 'applicationName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        application_name: str,
        version: str,
        type: str,
        **kwargs
    ):
        super(PackageCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name
        self.application_name = application_name
        self.version = version
        self.type = type


class PackageListResult(msrest.serialization.Model):
    """A list of Test Base Packages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Test Base Packages.
    :type value: list[~test_base.models.PackageResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PackageResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PackageResource"]] = None,
        **kwargs
    ):
        super(PackageListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TrackedResource(Resource):
    """The resource model definition for an ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.etag = None


class PackageResource(TrackedResource):
    """The Test Base Package resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Creating", "Deleting", "Updating".
    :vartype provisioning_state: str or ~test_base.models.ProvisioningState
    :param application_name: Application name.
    :type application_name: str
    :param version: Application version.
    :type version: str
    :ivar test_types: OOB, functional or both. Mapped to the data in 'tests' property.
    :vartype test_types: list[str or ~test_base.models.TestType]
    :param target_os_list: Specifies the target OSs of specific OS Update types.
    :type target_os_list: list[~test_base.models.TargetOSInfo]
    :ivar package_status: The status of the package. Possible values include: "Unknown",
     "Registered", "Ready", "Error", "ValidatingPackage", "PreValidationCheckPass", "Deleted",
     "ValidationLongerThanUsual", "VerifyingPackage".
    :vartype package_status: str or ~test_base.models.PackageStatus
    :ivar last_modified_time: The UTC timestamp when the package was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :param flighting_ring: The flighting ring for feature update.
    :type flighting_ring: str
    :ivar is_enabled: Flag showing that whether the package is enabled. It doesn't schedule test
     for package which is not enabled.
    :vartype is_enabled: bool
    :param blob_path: The file path of the package.
    :type blob_path: str
    :ivar validation_results: The validation results. There's validation on package when it's
     created or updated.
    :vartype validation_results: list[~test_base.models.PackageValidationResult]
    :param tests: The detailed test information.
    :type tests: list[~test_base.models.Test]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'test_types': {'readonly': True},
        'package_status': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'is_enabled': {'readonly': True},
        'validation_results': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'application_name': {'key': 'properties.applicationName', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'test_types': {'key': 'properties.testTypes', 'type': '[str]'},
        'target_os_list': {'key': 'properties.targetOSList', 'type': '[TargetOSInfo]'},
        'package_status': {'key': 'properties.packageStatus', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'flighting_ring': {'key': 'properties.flightingRing', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'blob_path': {'key': 'properties.blobPath', 'type': 'str'},
        'validation_results': {'key': 'properties.validationResults', 'type': '[PackageValidationResult]'},
        'tests': {'key': 'properties.tests', 'type': '[Test]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        application_name: Optional[str] = None,
        version: Optional[str] = None,
        target_os_list: Optional[List["TargetOSInfo"]] = None,
        flighting_ring: Optional[str] = None,
        blob_path: Optional[str] = None,
        tests: Optional[List["Test"]] = None,
        **kwargs
    ):
        super(PackageResource, self).__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.application_name = application_name
        self.version = version
        self.test_types = None
        self.target_os_list = target_os_list
        self.package_status = None
        self.last_modified_time = None
        self.flighting_ring = flighting_ring
        self.is_enabled = None
        self.blob_path = blob_path
        self.validation_results = None
        self.tests = tests


class PackageUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to update a Test Base Package.

    :param tags: A set of tags. The tags of the Package.
    :type tags: dict[str, str]
    :param target_os_list: Specifies the target OSs of specific OS Update types.
    :type target_os_list: list[~test_base.models.TargetOSInfo]
    :param flighting_ring: The flighting ring for feature update.
    :type flighting_ring: str
    :param is_enabled: Specifies whether the package is enabled. It doesn't schedule test for
     package which is not enabled.
    :type is_enabled: bool
    :param blob_path: The file name of the package.
    :type blob_path: str
    :param tests: The detailed test information.
    :type tests: list[~test_base.models.Test]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'target_os_list': {'key': 'properties.targetOSList', 'type': '[TargetOSInfo]'},
        'flighting_ring': {'key': 'properties.flightingRing', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'blob_path': {'key': 'properties.blobPath', 'type': 'str'},
        'tests': {'key': 'properties.tests', 'type': '[Test]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        target_os_list: Optional[List["TargetOSInfo"]] = None,
        flighting_ring: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        blob_path: Optional[str] = None,
        tests: Optional[List["Test"]] = None,
        **kwargs
    ):
        super(PackageUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.target_os_list = target_os_list
        self.flighting_ring = flighting_ring
        self.is_enabled = is_enabled
        self.blob_path = blob_path
        self.tests = tests


class PackageValidationResult(msrest.serialization.Model):
    """The validation results. There's validation on package when it's created or updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_name: Validation name.
    :vartype validation_name: str
    :ivar is_valid: Indicates whether the package passed the validation.
    :vartype is_valid: bool
    :ivar errors: Error information.
    :vartype errors: list[str]
    """

    _validation = {
        'validation_name': {'readonly': True},
        'is_valid': {'readonly': True},
        'errors': {'readonly': True},
    }

    _attribute_map = {
        'validation_name': {'key': 'validationName', 'type': 'str'},
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'errors': {'key': 'errors', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PackageValidationResult, self).__init__(**kwargs)
        self.validation_name = None
        self.is_valid = None
        self.errors = None


class RegressionResult(msrest.serialization.Model):
    """The regression result.

    :param file_name: FileName of the binary being analyzed.
    :type file_name: str
    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param details: Message that facilitates debugging a particular regression, if any was
     inferred.
    :type details: str
    :param diff: Difference between the two datasets being analyzed.
    :type diff: float
    :param is_regressed: Indicates if a regression was inferred.
    :type is_regressed: bool
    """

    _attribute_map = {
        'file_name': {'key': 'fileName', 'type': 'str'},
        'grade': {'key': 'grade', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'diff': {'key': 'diff', 'type': 'float'},
        'is_regressed': {'key': 'isRegressed', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        grade: Optional[Union[str, "Grade"]] = None,
        details: Optional[str] = None,
        diff: Optional[float] = None,
        is_regressed: Optional[bool] = None,
        **kwargs
    ):
        super(RegressionResult, self).__init__(**kwargs)
        self.file_name = file_name
        self.grade = grade
        self.details = details
        self.diff = diff
        self.is_regressed = is_regressed


class RegressionTestDetails(msrest.serialization.Model):
    """The details of a regression test.

    :param diff: Difference between the two datasets being analyzed.
    :type diff: float
    :param is_regressed: Indicates if a regression was inferred.
    :type is_regressed: bool
    """

    _attribute_map = {
        'diff': {'key': 'diff', 'type': 'float'},
        'is_regressed': {'key': 'isRegressed', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        diff: Optional[float] = None,
        is_regressed: Optional[bool] = None,
        **kwargs
    ):
        super(RegressionTestDetails, self).__init__(**kwargs)
        self.diff = diff
        self.is_regressed = is_regressed


class ReliabilityResult(msrest.serialization.Model):
    """The Reliability Result.

    :param file_name: File name.
    :type file_name: str
    :param launch_count: Count of number of launches.
    :type launch_count: int
    :param crash_count: Count of number of crashes.
    :type crash_count: int
    :param hang_count: Count of number of hangs.
    :type hang_count: int
    :param regression_grade: The regression grade. Possible values include: "None", "NotAvailable",
     "Pass", "Fail".
    :type regression_grade: str or ~test_base.models.Grade
    :param crash_regression_grade: The statistic regression grade for crash signal. Possible values
     include: "None", "NotAvailable", "Pass", "Fail".
    :type crash_regression_grade: str or ~test_base.models.Grade
    :param crash_regression_test_details: Details related to the crash regression analysis.
    :type crash_regression_test_details: ~test_base.models.RegressionTestDetails
    :param hang_regression_grade: The statistic regression grade for hang signal. Possible values
     include: "None", "NotAvailable", "Pass", "Fail".
    :type hang_regression_grade: str or ~test_base.models.Grade
    :param hang_regression_test_details: Details related to the hang regression analysis.
    :type hang_regression_test_details: ~test_base.models.RegressionTestDetails
    """

    _attribute_map = {
        'file_name': {'key': 'fileName', 'type': 'str'},
        'launch_count': {'key': 'launchCount', 'type': 'int'},
        'crash_count': {'key': 'crashCount', 'type': 'int'},
        'hang_count': {'key': 'hangCount', 'type': 'int'},
        'regression_grade': {'key': 'regressionGrade', 'type': 'str'},
        'crash_regression_grade': {'key': 'crashRegressionGrade', 'type': 'str'},
        'crash_regression_test_details': {'key': 'crashRegressionTestDetails', 'type': 'RegressionTestDetails'},
        'hang_regression_grade': {'key': 'hangRegressionGrade', 'type': 'str'},
        'hang_regression_test_details': {'key': 'hangRegressionTestDetails', 'type': 'RegressionTestDetails'},
    }

    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        launch_count: Optional[int] = None,
        crash_count: Optional[int] = None,
        hang_count: Optional[int] = None,
        regression_grade: Optional[Union[str, "Grade"]] = None,
        crash_regression_grade: Optional[Union[str, "Grade"]] = None,
        crash_regression_test_details: Optional["RegressionTestDetails"] = None,
        hang_regression_grade: Optional[Union[str, "Grade"]] = None,
        hang_regression_test_details: Optional["RegressionTestDetails"] = None,
        **kwargs
    ):
        super(ReliabilityResult, self).__init__(**kwargs)
        self.file_name = file_name
        self.launch_count = launch_count
        self.crash_count = crash_count
        self.hang_count = hang_count
        self.regression_grade = regression_grade
        self.crash_regression_grade = crash_regression_grade
        self.crash_regression_test_details = crash_regression_test_details
        self.hang_regression_grade = hang_regression_grade
        self.hang_regression_test_details = hang_regression_test_details


class ReliabilityResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Reliability Result.

    All required parameters must be populated in order to send to Azure.

    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Required. Type of the Analysis Result.Constant filled by server.
     Possible values include: "ScriptExecution", "Reliability", "CPUUtilization",
     "MemoryUtilization", "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    :param reliability_results: The result array data.
    :type reliability_results: list[~test_base.models.ReliabilityResult]
    """

    _validation = {
        'analysis_result_type': {'required': True},
    }

    _attribute_map = {
        'grade': {'key': 'grade', 'type': 'str'},
        'analysis_result_type': {'key': 'analysisResultType', 'type': 'str'},
        'reliability_results': {'key': 'reliabilityResults', 'type': '[ReliabilityResult]'},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        reliability_results: Optional[List["ReliabilityResult"]] = None,
        **kwargs
    ):
        super(ReliabilityResultSingletonResourceProperties, self).__init__(grade=grade, **kwargs)
        self.analysis_result_type = 'Reliability'  # type: str
        self.reliability_results = reliability_results


class ScriptExecutionResult(msrest.serialization.Model):
    """The Script Execution Result.

    :param script_name: Name of script.
    :type script_name: str
    :param start_time: Start time of script execution.
    :type start_time: ~datetime.datetime
    :param end_time: End time of script execution.
    :type end_time: ~datetime.datetime
    :param exit_code: Exit code.
    :type exit_code: int
    :param timed_out: Whether the script execution is timed out.
    :type timed_out: bool
    """

    _attribute_map = {
        'script_name': {'key': 'scriptName', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'timed_out': {'key': 'timedOut', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        script_name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        exit_code: Optional[int] = None,
        timed_out: Optional[bool] = None,
        **kwargs
    ):
        super(ScriptExecutionResult, self).__init__(**kwargs)
        self.script_name = script_name
        self.start_time = start_time
        self.end_time = end_time
        self.exit_code = exit_code
        self.timed_out = timed_out


class ScriptExecutionResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Script Execution Result.

    All required parameters must be populated in order to send to Azure.

    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Required. Type of the Analysis Result.Constant filled by server.
     Possible values include: "ScriptExecution", "Reliability", "CPUUtilization",
     "MemoryUtilization", "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    :param script_execution_results: The result array data.
    :type script_execution_results: list[~test_base.models.ScriptExecutionResult]
    """

    _validation = {
        'analysis_result_type': {'required': True},
    }

    _attribute_map = {
        'grade': {'key': 'grade', 'type': 'str'},
        'analysis_result_type': {'key': 'analysisResultType', 'type': 'str'},
        'script_execution_results': {'key': 'scriptExecutionResults', 'type': '[ScriptExecutionResult]'},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        script_execution_results: Optional[List["ScriptExecutionResult"]] = None,
        **kwargs
    ):
        super(ScriptExecutionResultSingletonResourceProperties, self).__init__(grade=grade, **kwargs)
        self.analysis_result_type = 'ScriptExecution'  # type: str
        self.script_execution_results = script_execution_results


class SubscriptionReceiverValue(msrest.serialization.Model):
    """The subscription role receiver value.

    :param subscription_id: The subscription id of the notification receiver.
    :type subscription_id: str
    :param subscription_name: The subscription name of the notification receiver.
    :type subscription_name: str
    :param role: The role of the notification receiver.
    :type role: str
    """

    _attribute_map = {
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'subscription_name': {'key': 'subscriptionName', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        subscription_name: Optional[str] = None,
        role: Optional[str] = None,
        **kwargs
    ):
        super(SubscriptionReceiverValue, self).__init__(**kwargs)
        self.subscription_id = subscription_id
        self.subscription_name = subscription_name
        self.role = role


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~test_base.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~test_base.models.CreatedByType
    :param last_modified_at: The type of identity that last modified the resource.
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TargetOSInfo(msrest.serialization.Model):
    """The information of the target OS to be tested.

    All required parameters must be populated in order to send to Azure.

    :param os_update_type: Required. Specifies the OS update type to test against, e.g., 'Security
     updates' or 'Feature updates'.
    :type os_update_type: str
    :param target_o_ss: Required. Specifies the target OSs to be tested.
    :type target_o_ss: list[str]
    """

    _validation = {
        'os_update_type': {'required': True},
        'target_o_ss': {'required': True},
    }

    _attribute_map = {
        'os_update_type': {'key': 'osUpdateType', 'type': 'str'},
        'target_o_ss': {'key': 'targetOSs', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        os_update_type: str,
        target_o_ss: List[str],
        **kwargs
    ):
        super(TargetOSInfo, self).__init__(**kwargs)
        self.os_update_type = os_update_type
        self.target_o_ss = target_o_ss


class Test(msrest.serialization.Model):
    """The definition of a Test.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param test_type: Required. The type of the test. Possible values include: "OutOfBoxTest",
     "FunctionalTest".
    :type test_type: str or ~test_base.models.TestType
    :ivar validation_run_status: The status of the validation run of the package. Possible values
     include: "Unknown", "Pending", "Passed", "Failed".
    :vartype validation_run_status: str or ~test_base.models.ValidationRunStatus
    :param is_active: Indicates if this test is active.It doesn't schedule test for not active
     Test.
    :type is_active: bool
    :param commands: Required. The commands used in the test.
    :type commands: list[~test_base.models.Command]
    """

    _validation = {
        'test_type': {'required': True},
        'validation_run_status': {'readonly': True},
        'commands': {'required': True},
    }

    _attribute_map = {
        'test_type': {'key': 'testType', 'type': 'str'},
        'validation_run_status': {'key': 'validationRunStatus', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'commands': {'key': 'commands', 'type': '[Command]'},
    }

    def __init__(
        self,
        *,
        test_type: Union[str, "TestType"],
        commands: List["Command"],
        is_active: Optional[bool] = None,
        **kwargs
    ):
        super(Test, self).__init__(**kwargs)
        self.test_type = test_type
        self.validation_run_status = None
        self.is_active = is_active
        self.commands = commands


class TestAnalysisResult(msrest.serialization.Model):
    """The test analysis result.

    :param blob_data: The data to provide more failure analysis information.
    :type blob_data: str
    :param test_analysis_status: The status of the analysis. Possible values include: "None",
     "Analyzing", "Completed", "Failed".
    :type test_analysis_status: str or ~test_base.models.TestAnalysisStatus
    :param identified_failures: The array of identified failures.
    :type identified_failures: list[~test_base.models.IdentifiedFailure]
    """

    _attribute_map = {
        'blob_data': {'key': 'blobData', 'type': 'str'},
        'test_analysis_status': {'key': 'testAnalysisStatus', 'type': 'str'},
        'identified_failures': {'key': 'identifiedFailures', 'type': '[IdentifiedFailure]'},
    }

    def __init__(
        self,
        *,
        blob_data: Optional[str] = None,
        test_analysis_status: Optional[Union[str, "TestAnalysisStatus"]] = None,
        identified_failures: Optional[List["IdentifiedFailure"]] = None,
        **kwargs
    ):
        super(TestAnalysisResult, self).__init__(**kwargs)
        self.blob_data = blob_data
        self.test_analysis_status = test_analysis_status
        self.identified_failures = identified_failures


class TestAnalysisResultSingletonResourceProperties(AnalysisResultSingletonResourceProperties):
    """The properties of Test Analysis Result.

    All required parameters must be populated in order to send to Azure.

    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param analysis_result_type: Required. Type of the Analysis Result.Constant filled by server.
     Possible values include: "ScriptExecution", "Reliability", "CPUUtilization",
     "MemoryUtilization", "CPURegression", "MemoryRegression", "TestAnalysis".
    :type analysis_result_type: str or ~test_base.models.AnalysisResultType
    :param test_analysis_result: The result of test analysis.
    :type test_analysis_result: ~test_base.models.TestAnalysisResult
    """

    _validation = {
        'analysis_result_type': {'required': True},
    }

    _attribute_map = {
        'grade': {'key': 'grade', 'type': 'str'},
        'analysis_result_type': {'key': 'analysisResultType', 'type': 'str'},
        'test_analysis_result': {'key': 'testAnalysisResult', 'type': 'TestAnalysisResult'},
    }

    def __init__(
        self,
        *,
        grade: Optional[Union[str, "Grade"]] = None,
        test_analysis_result: Optional["TestAnalysisResult"] = None,
        **kwargs
    ):
        super(TestAnalysisResultSingletonResourceProperties, self).__init__(grade=grade, **kwargs)
        self.analysis_result_type = 'TestAnalysis'  # type: str
        self.test_analysis_result = test_analysis_result


class TestBaseAccountListResult(msrest.serialization.Model):
    """A list of Test Base Accounts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Test Base Accounts.
    :type value: list[~test_base.models.TestBaseAccountResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TestBaseAccountResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TestBaseAccountResource"]] = None,
        **kwargs
    ):
        super(TestBaseAccountListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestBaseAccountResource(TrackedResource):
    """The Test Base Account resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Creating", "Deleting", "Updating".
    :vartype provisioning_state: str or ~test_base.models.ProvisioningState
    :param sku: The SKU of the Test Base Account.
    :type sku: ~test_base.models.TestBaseAccountSKU
    :ivar access_level: The access level of the Test Base Account.
    :vartype access_level: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'access_level': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'TestBaseAccountSKU'},
        'access_level': {'key': 'properties.accessLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["TestBaseAccountSKU"] = None,
        **kwargs
    ):
        super(TestBaseAccountResource, self).__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.sku = sku
        self.access_level = None


class TestBaseAccountSKU(msrest.serialization.Model):
    """Describes a Test Base Account SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: The type of resource the SKU applies to.
    :type resource_type: str
    :param name: Required. The name of the SKU. This is typically a letter + number code, such as
     B0 or S0.
    :type name: str
    :param tier: Required. The tier of this particular SKU. Possible values include: "Standard".
    :type tier: str or ~test_base.models.Tier
    :ivar capabilities: The capabilities of a SKU.
    :vartype capabilities: list[~test_base.models.TestBaseAccountSKUCapability]
    :param locations: The locations that the SKU is available.
    :type locations: list[str]
    """

    _validation = {
        'name': {'required': True},
        'tier': {'required': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': '[TestBaseAccountSKUCapability]'},
        'locations': {'key': 'locations', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Union[str, "Tier"],
        resource_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        **kwargs
    ):
        super(TestBaseAccountSKU, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.name = name
        self.tier = tier
        self.capabilities = None
        self.locations = locations


class TestBaseAccountSKUCapability(msrest.serialization.Model):
    """Properties of the Test Base Account SKU Capability.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. An invariant to describe the feature, such as 'SLA'.
    :type name: str
    :param value: Required. An invariant if the feature is measured by quantity, such as 99.9%.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        super(TestBaseAccountSKUCapability, self).__init__(**kwargs)
        self.name = name
        self.value = value


class TestBaseAccountSKUListResult(msrest.serialization.Model):
    """A list of Test Base Account SKUs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Test Base Account SKUs.
    :type value: list[~test_base.models.TestBaseAccountSKU]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TestBaseAccountSKU]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TestBaseAccountSKU"]] = None,
        **kwargs
    ):
        super(TestBaseAccountSKUListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestBaseAccountUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to update a Test Base Account.

    :param tags: A set of tags. The tags of the Test Base Account.
    :type tags: dict[str, str]
    :param sku: The SKU of the Test Base Account.
    :type sku: ~test_base.models.TestBaseAccountSKU
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'TestBaseAccountSKU'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["TestBaseAccountSKU"] = None,
        **kwargs
    ):
        super(TestBaseAccountUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku


class TestBaseAccountUsageData(msrest.serialization.Model):
    """The usage data of a Test Base Account.

    :param id: Fully qualified ARM resource id.
    :type id: str
    :param name: Localizable String object containing the name and a localized value.
    :type name: ~test_base.models.TestBaseAccountUsageName
    :param unit: Representing the units of the usage quota. Possible values are: Count, Bytes,
     Seconds, Percent, CountPerSecond, BytesPerSecond.
    :type unit: str
    :param limit: The maximum permitted value for the usage quota. If there is no limit, this value
     will be -1.
    :type limit: long
    :param current_value: Current value for the usage quota.
    :type current_value: long
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'TestBaseAccountUsageName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional["TestBaseAccountUsageName"] = None,
        unit: Optional[str] = None,
        limit: Optional[int] = None,
        current_value: Optional[int] = None,
        **kwargs
    ):
        super(TestBaseAccountUsageData, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.unit = unit
        self.limit = limit
        self.current_value = current_value


class TestBaseAccountUsageDataList(msrest.serialization.Model):
    """A list of Test Base Account usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Test Base Account usage data.
    :type value: list[~test_base.models.TestBaseAccountUsageData]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TestBaseAccountUsageData]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TestBaseAccountUsageData"]] = None,
        **kwargs
    ):
        super(TestBaseAccountUsageDataList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestBaseAccountUsageName(msrest.serialization.Model):
    """Localizable String object containing the name and a localized value.

    :param value: The identifier of the usage.
    :type value: str
    :param localized_value: Localized name of the usage.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(TestBaseAccountUsageName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class TestResultAnalysisSummary(msrest.serialization.Model):
    """The summary of a Test Analysis Result.

    :param name: Metric name.
    :type name: str
    :param analysis_status: The analysis status. Possible values include: "None", "Completed",
     "InProgress", "Failed", "Succeeded", "Available", "NotAvailable".
    :type analysis_status: str or ~test_base.models.AnalysisStatus
    :param grade: The grade of the test result. Possible values include: "None", "NotAvailable",
     "Pass", "Fail".
    :type grade: str or ~test_base.models.Grade
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'analysis_status': {'key': 'analysisStatus', 'type': 'str'},
        'grade': {'key': 'grade', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        analysis_status: Optional[Union[str, "AnalysisStatus"]] = None,
        grade: Optional[Union[str, "Grade"]] = None,
        **kwargs
    ):
        super(TestResultAnalysisSummary, self).__init__(**kwargs)
        self.name = name
        self.analysis_status = analysis_status
        self.grade = grade


class TestResultListResult(msrest.serialization.Model):
    """A list of Test Results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Test Results.
    :type value: list[~test_base.models.TestResultResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TestResultResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TestResultResource"]] = None,
        **kwargs
    ):
        super(TestResultListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestResultResource(ProxyResource):
    """The Test Result Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param baseline_test_result_id: Azure Id of the baseline test result.
    :type baseline_test_result_id: str
    :param package_id: Resource Id of the package.
    :type package_id: str
    :param application_name: Application name.
    :type application_name: str
    :param application_version: Application version.
    :type application_version: str
    :param os_name: The operating system name, e.g. Windows 10 1809.
    :type os_name: str
    :param release_name: The name of the tested release (OS update).
    :type release_name: str
    :param release_version_date: The release version date of the tested release.
    :type release_version_date: ~datetime.datetime
    :param flighting_ring: The flighting ring, only for release of feature updates.
    :type flighting_ring: str
    :param build_version: The build version of the tested release (OS update).
    :type build_version: str
    :param build_revision: The build revision of the tested release (OS update).
    :type build_revision: str
    :param test_type: Test type. E.g. 'Out of box test' or 'Functional test'.
    :type test_type: str
    :param test_run_time: The run time of the test.
    :type test_run_time: str
    :param is_download_data_available: Whether download data is available.
    :type is_download_data_available: bool
    :param is_video_available: Whether video data is available.
    :type is_video_available: bool
    :param execution_status: The execution status of the test. Possible values include: "None",
     "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", "Succeeded".
    :type execution_status: str or ~test_base.models.ExecutionStatus
    :param test_status: The status of the test. Possible values include: "None",
     "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
     "TestAndUpdateFailure", "InfrastructureFailure", "Completed".
    :type test_status: str or ~test_base.models.TestStatus
    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param kb_number: KB number.
    :type kb_number: str
    :param package_version: The version of the Windows update package.
    :type package_version: str
    :param analysis_summaries: List of analysis summaries.
    :type analysis_summaries: list[~test_base.models.TestResultAnalysisSummary]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'baseline_test_result_id': {'key': 'properties.baselineTestResultId', 'type': 'str'},
        'package_id': {'key': 'properties.packageId', 'type': 'str'},
        'application_name': {'key': 'properties.applicationName', 'type': 'str'},
        'application_version': {'key': 'properties.applicationVersion', 'type': 'str'},
        'os_name': {'key': 'properties.osName', 'type': 'str'},
        'release_name': {'key': 'properties.releaseName', 'type': 'str'},
        'release_version_date': {'key': 'properties.releaseVersionDate', 'type': 'iso-8601'},
        'flighting_ring': {'key': 'properties.flightingRing', 'type': 'str'},
        'build_version': {'key': 'properties.buildVersion', 'type': 'str'},
        'build_revision': {'key': 'properties.buildRevision', 'type': 'str'},
        'test_type': {'key': 'properties.testType', 'type': 'str'},
        'test_run_time': {'key': 'properties.testRunTime', 'type': 'str'},
        'is_download_data_available': {'key': 'properties.isDownloadDataAvailable', 'type': 'bool'},
        'is_video_available': {'key': 'properties.isVideoAvailable', 'type': 'bool'},
        'execution_status': {'key': 'properties.executionStatus', 'type': 'str'},
        'test_status': {'key': 'properties.testStatus', 'type': 'str'},
        'grade': {'key': 'properties.grade', 'type': 'str'},
        'kb_number': {'key': 'properties.kbNumber', 'type': 'str'},
        'package_version': {'key': 'properties.packageVersion', 'type': 'str'},
        'analysis_summaries': {'key': 'properties.analysisSummaries', 'type': '[TestResultAnalysisSummary]'},
    }

    def __init__(
        self,
        *,
        baseline_test_result_id: Optional[str] = None,
        package_id: Optional[str] = None,
        application_name: Optional[str] = None,
        application_version: Optional[str] = None,
        os_name: Optional[str] = None,
        release_name: Optional[str] = None,
        release_version_date: Optional[datetime.datetime] = None,
        flighting_ring: Optional[str] = None,
        build_version: Optional[str] = None,
        build_revision: Optional[str] = None,
        test_type: Optional[str] = None,
        test_run_time: Optional[str] = None,
        is_download_data_available: Optional[bool] = None,
        is_video_available: Optional[bool] = None,
        execution_status: Optional[Union[str, "ExecutionStatus"]] = None,
        test_status: Optional[Union[str, "TestStatus"]] = None,
        grade: Optional[Union[str, "Grade"]] = None,
        kb_number: Optional[str] = None,
        package_version: Optional[str] = None,
        analysis_summaries: Optional[List["TestResultAnalysisSummary"]] = None,
        **kwargs
    ):
        super(TestResultResource, self).__init__(**kwargs)
        self.system_data = None
        self.baseline_test_result_id = baseline_test_result_id
        self.package_id = package_id
        self.application_name = application_name
        self.application_version = application_version
        self.os_name = os_name
        self.release_name = release_name
        self.release_version_date = release_version_date
        self.flighting_ring = flighting_ring
        self.build_version = build_version
        self.build_revision = build_revision
        self.test_type = test_type
        self.test_run_time = test_run_time
        self.is_download_data_available = is_download_data_available
        self.is_video_available = is_video_available
        self.execution_status = execution_status
        self.test_status = test_status
        self.grade = grade
        self.kb_number = kb_number
        self.package_version = package_version
        self.analysis_summaries = analysis_summaries


class TestSummaryListResult(msrest.serialization.Model):
    """A list of Test Summaries.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Test Summaries.
    :type value: list[~test_base.models.TestSummaryResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TestSummaryResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TestSummaryResource"]] = None,
        **kwargs
    ):
        super(TestSummaryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestSummaryResource(ProxyResource):
    """Summary of a Test.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param test_summary_id: The Id of the current Test Summary.
    :type test_summary_id: str
    :param package_id: The Azure resource Id of package.
    :type package_id: str
    :param application_name: Application name.
    :type application_name: str
    :param application_version: Application version.
    :type application_version: str
    :param execution_status: The execution status of last test. Possible values include: "None",
     "InProgress", "Processing", "Completed", "NotExecuted", "Incomplete", "Failed", "Succeeded".
    :type execution_status: str or ~test_base.models.ExecutionStatus
    :param test_status: The status of last test. Possible values include: "None",
     "TestExecutionInProgress", "DataProcessing", "TestFailure", "UpdateFailure",
     "TestAndUpdateFailure", "InfrastructureFailure", "Completed".
    :type test_status: str or ~test_base.models.TestStatus
    :param grade: The grade of the test. Possible values include: "None", "NotAvailable", "Pass",
     "Fail".
    :type grade: str or ~test_base.models.Grade
    :param test_run_time: The run time of the last test.
    :type test_run_time: str
    :param feature_updates_test_summary: The result summary of tests triggered by feature updates.
    :type feature_updates_test_summary: ~test_base.models.OSUpdatesTestSummary
    :param security_updates_test_summary: The result summary of tests triggered by security
     updates.
    :type security_updates_test_summary: ~test_base.models.OSUpdatesTestSummary
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'test_summary_id': {'key': 'properties.testSummaryId', 'type': 'str'},
        'package_id': {'key': 'properties.packageId', 'type': 'str'},
        'application_name': {'key': 'properties.applicationName', 'type': 'str'},
        'application_version': {'key': 'properties.applicationVersion', 'type': 'str'},
        'execution_status': {'key': 'properties.executionStatus', 'type': 'str'},
        'test_status': {'key': 'properties.testStatus', 'type': 'str'},
        'grade': {'key': 'properties.grade', 'type': 'str'},
        'test_run_time': {'key': 'properties.testRunTime', 'type': 'str'},
        'feature_updates_test_summary': {'key': 'properties.featureUpdatesTestSummary', 'type': 'OSUpdatesTestSummary'},
        'security_updates_test_summary': {'key': 'properties.securityUpdatesTestSummary', 'type': 'OSUpdatesTestSummary'},
    }

    def __init__(
        self,
        *,
        test_summary_id: Optional[str] = None,
        package_id: Optional[str] = None,
        application_name: Optional[str] = None,
        application_version: Optional[str] = None,
        execution_status: Optional[Union[str, "ExecutionStatus"]] = None,
        test_status: Optional[Union[str, "TestStatus"]] = None,
        grade: Optional[Union[str, "Grade"]] = None,
        test_run_time: Optional[str] = None,
        feature_updates_test_summary: Optional["OSUpdatesTestSummary"] = None,
        security_updates_test_summary: Optional["OSUpdatesTestSummary"] = None,
        **kwargs
    ):
        super(TestSummaryResource, self).__init__(**kwargs)
        self.system_data = None
        self.test_summary_id = test_summary_id
        self.package_id = package_id
        self.application_name = application_name
        self.application_version = application_version
        self.execution_status = execution_status
        self.test_status = test_status
        self.grade = grade
        self.test_run_time = test_run_time
        self.feature_updates_test_summary = feature_updates_test_summary
        self.security_updates_test_summary = security_updates_test_summary


class TestTypeListResult(msrest.serialization.Model):
    """A list of test types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of test types.
    :type value: list[~test_base.models.TestTypeResource]
    :ivar next_link: Link to the next set of results. Not empty if value contains incomplete list
     of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TestTypeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TestTypeResource"]] = None,
        **kwargs
    ):
        super(TestTypeListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TestTypeResource(ProxyResource):
    """The test type resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~test_base.models.SystemData
    :param actual_test_type_name: The actual name of a test type of a Test Base Account.
    :type actual_test_type_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'actual_test_type_name': {'key': 'properties.actualTestTypeName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        actual_test_type_name: Optional[str] = None,
        **kwargs
    ):
        super(TestTypeResource, self).__init__(**kwargs)
        self.system_data = None
        self.actual_test_type_name = actual_test_type_name


class UserObjectReceiverValue(msrest.serialization.Model):
    """The user object receiver value.

    :param user_object_ids: user object ids.
    :type user_object_ids: list[str]
    """

    _attribute_map = {
        'user_object_ids': {'key': 'userObjectIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        user_object_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(UserObjectReceiverValue, self).__init__(**kwargs)
        self.user_object_ids = user_object_ids


class UtilizationBound(msrest.serialization.Model):
    """The bound of a utilization result.

    :param percentile: The percentile of the bound.
    :type percentile: float
    :param value: The value of the bound.
    :type value: float
    """

    _attribute_map = {
        'percentile': {'key': 'percentile', 'type': 'float'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        percentile: Optional[float] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(UtilizationBound, self).__init__(**kwargs)
        self.percentile = percentile
        self.value = value


class UtilizationEntry(msrest.serialization.Model):
    """The utilization entry.

    :param timestamp: The timestamp.
    :type timestamp: ~datetime.datetime
    :param value: The value.
    :type value: float
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(UtilizationEntry, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.value = value


class UtilizationResult(msrest.serialization.Model):
    """The Utilization Result.

    :param process: Process name, or '_total' for all processes.
    :type process: str
    :param upper_bound: Upper bound.
    :type upper_bound: ~test_base.models.UtilizationBound
    :param lower_bound: Lower bound.
    :type lower_bound: ~test_base.models.UtilizationBound
    :param utilization: Utilization data.
    :type utilization: list[~test_base.models.UtilizationEntry]
    """

    _attribute_map = {
        'process': {'key': 'process', 'type': 'str'},
        'upper_bound': {'key': 'upperBound', 'type': 'UtilizationBound'},
        'lower_bound': {'key': 'lowerBound', 'type': 'UtilizationBound'},
        'utilization': {'key': 'utilization', 'type': '[UtilizationEntry]'},
    }

    def __init__(
        self,
        *,
        process: Optional[str] = None,
        upper_bound: Optional["UtilizationBound"] = None,
        lower_bound: Optional["UtilizationBound"] = None,
        utilization: Optional[List["UtilizationEntry"]] = None,
        **kwargs
    ):
        super(UtilizationResult, self).__init__(**kwargs)
        self.process = process
        self.upper_bound = upper_bound
        self.lower_bound = lower_bound
        self.utilization = utilization
