/*
 * This table contains for each voxel vertex class either
 * 1) quadrangles generated by replacing two triangles with a common edge
 *    in Heller's triangle table.
 * 2) the original triangles if no quadrangles were found (4th vertex == -1)
 *
 * NB: The reduction of triangle into quadrangles was done imperfectly.
 *     Any class with exactly three vertices flagged on a face would
 *     probably be better described by triangles even though we
 *     collapsed them into quadrangles.
 *     So there is room for improvement in this table.
 */ 
static signed char qt_table[256][13] =
{
    {  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  3,  0, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   9,  0,  1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  3,  1,  9,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  10,  1,  2, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  3,  0, -1,   1,  2, 10, -1,  -1, -1, -1, -1,  -1},
    {   9,  0,  2, 10,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   3,  2,  8, -1,   2, 10,  8, -1,   8, 10,  9, -1,  -1},
    {  11,  2,  3, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  2,  0,  8,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  2,  3, -1,   0,  1,  9, -1,  -1, -1, -1, -1,  -1},
    {   2,  1, 11, -1,   1,  9, 11, -1,  11,  9,  8, -1,  -1},
    {  10,  1,  3, 11,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   1,  0, 10, -1,   0,  8, 10, -1,  10,  8, 11, -1,  -1},
    {   0,  3,  9, -1,   3, 11,  9, -1,   9, 11, 10, -1,  -1},
    {   8, 11, 10,  9,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  4,  7, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   3,  0,  4,  7,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   1,  9,  0, -1,   8,  4,  7, -1,  -1, -1, -1, -1,  -1},
    {   9,  4,  1, -1,   4,  7,  1, -1,   1,  7,  3, -1,  -1},
    {  10,  1,  2, -1,   8,  4,  7, -1,  -1, -1, -1, -1,  -1},
    {   0,  4,  7,  3,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   0,  2, 10,  9,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   2,  7,  3, -1,   9,  4,  7,  2,   2, 10,  9, -1,  -1},
    {   2,  3, 11, -1,   7,  8,  4, -1,  -1, -1, -1, -1,  -1},
    {   7, 11,  4, -1,  11,  2,  4, -1,   4,  2,  0, -1,  -1},
    {   3, 11,  2, -1,   4,  7,  8, -1,   9,  0,  1, -1,  -1},
    {   2,  7, 11, -1,   1,  4,  7,  2,   1,  9,  4, -1,  -1},
    {  11, 10,  1,  3,   8,  4,  7, -1,  -1, -1, -1, -1,  -1},
    {  11,  7,  4,  1,   1,  4, 11, 10,   1, 11,  4,  0,  -1},
    {  11,  4,  9, 10,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  4,  7, -1,  11,  9,  4, -1,  11, 10,  9, -1,  -1},
    {   9,  5,  4, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   3,  0,  8, -1,   4,  9,  5, -1,  -1, -1, -1, -1,  -1},
    {   5,  4,  0,  1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   4,  8,  5, -1,   8,  3,  5, -1,   5,  3,  1, -1,  -1},
    {   2, 10,  1, -1,   9,  5,  4, -1,  -1, -1, -1, -1,  -1},
    {   0,  8,  3, -1,   5,  4,  9, -1,  10,  1,  2, -1,  -1},
    {  10,  5,  2, -1,   5,  4,  2, -1,   2,  4,  0, -1,  -1},
    {   8,  3,  4, -1,   2,  5,  4,  3,   2, 10,  5, -1,  -1},
    {  11,  2,  3, -1,   9,  5,  4, -1,  -1, -1, -1, -1,  -1},
    {   8, 11,  2,  0,   9,  5,  4, -1,  -1, -1, -1, -1,  -1},
    {   1,  5,  4,  0,   3, 11,  2, -1,  -1, -1, -1, -1,  -1},
    {   8,  5,  4, -1,   2,  5,  8, 11,   2,  1,  5, -1,  -1},
    {   1,  3, 11, 10,   5,  4,  9, -1,  -1, -1, -1, -1,  -1},
    {   8,  5, 10, 11,   0,  9,  1, -1,  -1, -1, -1, -1,  -1},
    {   3,  4,  0, -1,  10,  5,  4,  3,   3, 11, 10, -1,  -1},
    {   4,  8,  5, -1,   5,  8, 10, -1,   8, 11, 10, -1,  -1},
    {   9,  5,  7,  8,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   0,  9,  3, -1,   9,  5,  3, -1,   3,  5,  7, -1,  -1},
    {   8,  0,  7, -1,   0,  1,  7, -1,   7,  1,  5, -1,  -1},
    {   1,  7,  3, -1,   1,  5,  7, -1,  -1, -1, -1, -1,  -1},
    {   5,  7,  8,  9,   1,  2, 10, -1,  -1, -1, -1, -1,  -1},
    {   5,  2,  3,  7,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   5,  2, 10, -1,   8,  2,  5,  7,   8,  0,  2, -1,  -1},
    {  10,  5,  2, -1,   3,  2,  5, -1,   5,  7,  3, -1,  -1},
    {   8,  9,  5,  7,  11,  2,  3, -1,  -1, -1, -1, -1,  -1},
    {   9,  2,  0, -1,   7, 11,  2,  9,   9,  5,  7, -1,  -1},
    {   1, 11,  7,  5,   0,  3,  8, -1,  -1, -1, -1, -1,  -1},
    {   2,  1, 11, -1,  11,  1,  7, -1,   1,  5,  7, -1,  -1},
    {   3,  1,  9,  8,   7, 11, 10,  5,  -1, -1, -1, -1,  -1},
    {  10, 11,  7,  5,   9,  1,  0, -1,  -1, -1, -1, -1,  -1},
    {   7,  5, 10, 11,   3,  8,  0, -1,  -1, -1, -1, -1,  -1},
    {  11, 10,  5,  7,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  10,  6,  5, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  3,  0, -1,  10,  6,  5, -1,  -1, -1, -1, -1,  -1},
    {   0,  1,  9, -1,   5, 10,  6, -1,  -1, -1, -1, -1,  -1},
    {   9,  8,  3,  1,  10,  6,  5, -1,  -1, -1, -1, -1,  -1},
    {   1,  2,  6,  5,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   2,  6,  5,  1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   5,  9,  6, -1,   9,  0,  6, -1,   6,  0,  2, -1,  -1},
    {   9,  6,  5, -1,   3,  6,  9,  8,   3,  2,  6, -1,  -1},
    {   3, 11,  2, -1,  10,  6,  5, -1,  -1, -1, -1, -1,  -1},
    {   2,  0,  8, 11,   6,  5, 10, -1,  -1, -1, -1, -1,  -1},
    {   1,  9,  0, -1,   6,  5, 10, -1,  11,  2,  3, -1,  -1},
    {   9,  6, 11,  8,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  6,  3, -1,   6,  5,  3, -1,   3,  5,  1, -1,  -1},
    {   0,  5,  1, -1,   5,  0, 11,  6,   0,  8, 11, -1,  -1},
    {   0,  5,  9, -1,   0,  3,  6,  5,   6,  3, 11, -1,  -1},
    {   5,  9,  6, -1,   6,  9, 11, -1,   9,  8, 11, -1,  -1},
    {  10,  6,  5, -1,   4,  7,  8, -1,  -1, -1, -1, -1,  -1},
    {   7,  3,  0,  4,   5, 10,  6, -1,  -1, -1, -1, -1,  -1},
    {   5, 10,  6, -1,   0,  1,  9, -1,   8,  4,  7, -1,  -1},
    {   7, 10,  1,  3,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   5,  1,  2,  6,   7,  8,  4, -1,  -1, -1, -1, -1,  -1},
    {   4,  0,  1,  5,   6,  7,  3,  2,  -1, -1, -1, -1,  -1},
    {   0,  7,  6,  2,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   6,  2,  3,  7,   4,  5,  9, -1,  -1, -1, -1, -1,  -1},
    {   7,  8,  4, -1,   2,  3, 11, -1,  10,  6,  5, -1,  -1},
    {   2,  5,  4,  0,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  6,  7, -1,   8,  0,  3, -1,   1, 10,  2, -1,   9},
    {   6,  7, 11, -1,   1, 10,  2, -1,   9,  4,  5, -1,  -1},
    {   5,  8,  3,  1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   4,  0,  1,  5,   6,  7, 11, -1,  -1, -1, -1, -1,  -1},
    {   4,  5,  9, -1,   3,  8,  0, -1,  11,  6,  7, -1,  -1},
    {   9,  4,  5, -1,   7, 11,  6, -1,  -1, -1, -1, -1,  -1},
    {  10,  6,  4,  9,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   9, 10,  6,  4,   8,  3,  0, -1,  -1, -1, -1, -1,  -1},
    {   1, 10,  0, -1,  10,  6,  0, -1,   0,  6,  4, -1,  -1},
    {   8,  6,  4, -1,   1, 10,  6,  8,   8,  3,  1, -1,  -1},
    {   9,  1,  4, -1,   1,  2,  4, -1,   4,  2,  6, -1,  -1},
    {   2,  8,  4,  6,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   2,  6,  4,  0,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   3,  2,  8, -1,   8,  2,  4, -1,   2,  6,  4, -1,  -1},
    {   6,  4,  9, 10,   2,  3, 11, -1,  -1, -1, -1, -1,  -1},
    {   0,  2, 10,  9,   4,  8, 11,  6,  -1, -1, -1, -1,  -1},
    {   6,  3,  0,  4,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  8,  4,  6,  10,  2,  1, -1,  -1, -1, -1, -1,  -1},
    {   1,  9,  4, 11,  11,  4,  1,  3,  11,  1,  4,  6,  -1},
    {   4,  6, 11,  8,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  6,  3, -1,   3,  6,  0, -1,   6,  4,  0, -1,  -1},
    {  11,  6,  4,  8,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   6,  7, 10, -1,   7,  8, 10, -1,  10,  8,  9, -1,  -1},
    {   9,  0,  3,  6,   6,  3,  9, 10,   6,  9,  3,  7,  -1},
    {   6,  7,  1, 10,   7,  8,  0,  1,  -1, -1, -1, -1,  -1},
    {   6,  7, 10, -1,  10,  7,  1, -1,   7,  3,  1, -1,  -1},
    {   7,  6,  2, -1,   7,  9,  2,  1,   7,  8,  9, -1,  -1},
    {   3,  7,  6,  2,   1,  0,  9, -1,  -1, -1, -1, -1,  -1},
    {   8,  0,  7, -1,   7,  0,  6, -1,   0,  2,  6, -1,  -1},
    {   2,  6,  7,  3,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  2, 10,  9,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  10,  9,  0,  2,  11,  6,  7, -1,  -1, -1, -1, -1,  -1},
    {   2,  1, 10, -1,   7, 11,  6, -1,   8,  0,  3, -1,  -1},
    {   1, 10,  2, -1,   6,  7, 11, -1,  -1, -1, -1, -1,  -1},
    {   3,  1,  9,  8,   7, 11,  6, -1,  -1, -1, -1, -1,  -1},
    {   9,  1,  0, -1,  11,  6,  7, -1,  -1, -1, -1, -1,  -1},
    {   0,  3,  8, -1,  11,  6,  7, -1,  -1, -1, -1, -1,  -1},
    {  11,  6,  7, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  7,  6, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   0,  8,  3, -1,  11,  7,  6, -1,  -1, -1, -1, -1,  -1},
    {   9,  0,  1, -1,  11,  7,  6, -1,  -1, -1, -1, -1,  -1},
    {   3,  1,  9,  8,   7,  6, 11, -1,  -1, -1, -1, -1,  -1},
    {   1,  2, 10, -1,   6, 11,  7, -1,  -1, -1, -1, -1,  -1},
    {   2, 10,  1, -1,   7,  6, 11, -1,   8,  3,  0, -1,  -1},
    {  10,  9,  0,  2,  11,  7,  6, -1,  -1, -1, -1, -1,  -1},
    {   8,  2, 10,  9,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   2,  3,  7,  6,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  7,  0, -1,   7,  6,  0, -1,   0,  6,  2, -1,  -1},
    {   3,  7,  6,  2,   1,  9,  0, -1,  -1, -1, -1, -1,  -1},
    {   7,  6,  2,  9,   7,  2,  9,  8,  -1, -1, -1, -1,  -1},
    {   6, 10,  7, -1,  10,  1,  7, -1,   7,  1,  3, -1,  -1},
    {   6, 10,  1,  7,   7,  1,  0,  8,  -1, -1, -1, -1,  -1},
    {   9,  0,  3, -1,   6, 10,  9,  3,   6,  3,  7, -1,  -1},
    {   6, 10,  7, -1,   7, 10,  8, -1,  10,  9,  8, -1,  -1},
    {   8,  4,  6, 11,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  3,  6, -1,   3,  0,  6, -1,   6,  0,  4, -1,  -1},
    {   4,  6, 11,  8,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   1,  9,  4,  1,  11,  4,  1,  3,  11,  1,  4,  6,  -1},
    {  11,  8,  4,  6,  10,  1,  2, -1,  -1, -1, -1, -1,  -1},
    {   6,  3,  0,  4,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   0,  2, 10,  9,   4,  8, 11,  6,  -1, -1, -1, -1,  -1},
    {   6,  4,  9, 10,   2, 11,  3, -1,  -1, -1, -1, -1,  -1},
    {   3,  8,  2, -1,   8,  4,  2, -1,   2,  4,  6, -1,  -1},
    {   2,  0,  4,  6,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   2,  8,  4,  6,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   9,  4,  1, -1,   1,  4,  2, -1,   4,  6,  2, -1,  -1},
    {   8,  4,  6,  1,   8,  6,  1,  3,  -1, -1, -1, -1,  -1},
    {   1,  0, 10, -1,  10,  0,  6, -1,   0,  4,  6, -1,  -1},
    {   9, 10,  6,  4,   8,  0,  3, -1,  -1, -1, -1, -1,  -1},
    {  10,  9,  4,  6,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   9,  5,  4, -1,   7,  6, 11, -1,  -1, -1, -1, -1,  -1},
    {   4,  9,  5, -1,   3,  0,  8, -1,  11,  7,  6, -1,  -1},
    {   4,  0,  1,  5,   6, 11,  7, -1,  -1, -1, -1, -1,  -1},
    {   5,  8,  3,  1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   6, 11,  7, -1,   1,  2, 10, -1,   9,  5,  4, -1,  -1},
    {  11,  7,  6, -1,   8,  3,  0, -1,   1,  2, 10, -1,   9},
    {   2,  5,  4,  0,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   7,  4,  8, -1,   2, 11,  3, -1,  10,  5,  6, -1,  -1},
    {   6,  2,  3,  7,   4,  9,  5, -1,  -1, -1, -1, -1,  -1},
    {   0,  7,  6,  2,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   4,  0,  1,  5,   6,  7,  3,  2,  -1, -1, -1, -1,  -1},
    {   5,  1,  2,  6,   7,  4,  8, -1,  -1, -1, -1, -1,  -1},
    {   7, 10,  1,  3,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   5,  6, 10, -1,   0,  9,  1, -1,   8,  7,  4, -1,  -1},
    {   7,  3,  0,  4,   5,  6, 10, -1,  -1, -1, -1, -1,  -1},
    {  10,  5,  6, -1,   4,  8,  7, -1,  -1, -1, -1, -1,  -1},
    {   5,  6,  9, -1,   6, 11,  9, -1,   9, 11,  8, -1,  -1},
    {   0,  9,  5, -1,   3,  0,  5,  6,   3,  6, 11, -1,  -1},
    {   0,  1,  5, 11,   0,  5, 11,  8,  -1, -1, -1, -1,  -1},
    {  11,  3,  6, -1,   6,  3,  5, -1,   3,  1,  5, -1,  -1},
    {   9,  6, 11,  8,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   1,  0,  9, -1,   6, 10,  5, -1,  11,  3,  2, -1,  -1},
    {   2,  0,  8, 11,   6, 10,  5, -1,  -1, -1, -1, -1,  -1},
    {   3,  2, 11, -1,  10,  5,  6, -1,  -1, -1, -1, -1,  -1},
    {   9,  5,  6, -1,   3,  9,  6,  2,   3,  8,  9, -1,  -1},
    {   5,  6,  9, -1,   9,  6,  0, -1,   6,  2,  0, -1,  -1},
    {   2,  6,  5,  1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   1,  5,  6,  2,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   9,  8,  3,  1,  10,  5,  6, -1,  -1, -1, -1, -1,  -1},
    {   0,  9,  1, -1,   5,  6, 10, -1,  -1, -1, -1, -1,  -1},
    {   8,  0,  3, -1,  10,  5,  6, -1,  -1, -1, -1, -1,  -1},
    {  10,  5,  6, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  7,  5, 10,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   7,  5, 10, 11,   3,  0,  8, -1,  -1, -1, -1, -1,  -1},
    {  10, 11,  7,  5,   9,  0,  1, -1,  -1, -1, -1, -1,  -1},
    {   3,  1,  9,  8,   7, 11, 10,  5,  -1, -1, -1, -1,  -1},
    {   2, 11,  1, -1,  11,  7,  1, -1,   1,  7,  5, -1,  -1},
    {   1, 11,  7,  5,   0,  8,  3, -1,  -1, -1, -1, -1,  -1},
    {   9,  0,  2, -1,   2, 11,  7,  9,   9,  7,  5, -1,  -1},
    {   8,  9,  5,  7,  11,  3,  2, -1,  -1, -1, -1, -1,  -1},
    {  10,  2,  5, -1,   2,  3,  5, -1,   5,  3,  7, -1,  -1},
    {   5, 10,  2,  5,   8,  2,  5,  7,   8,  5,  2,  0,  -1},
    {   5,  2,  3,  7,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   5,  7,  8,  9,   1, 10,  2, -1,  -1, -1, -1, -1,  -1},
    {   1,  3,  7,  5,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  7,  0, -1,   0,  7,  1, -1,   7,  5,  1, -1,  -1},
    {   0,  3,  9, -1,   9,  3,  5, -1,   3,  7,  5, -1,  -1},
    {   7,  5,  9,  8,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   4,  5,  8, -1,   5, 10,  8, -1,   8, 10, 11, -1,  -1},
    {   3,  0,  4, 10,   3,  4, 10, 11,  -1, -1, -1, -1,  -1},
    {   8,  5, 10, 11,   0,  1,  9, -1,  -1, -1, -1, -1,  -1},
    {   1,  3, 11, 10,   5,  9,  4, -1,  -1, -1, -1, -1,  -1},
    {   8,  4,  5,  8,   2,  5,  8, 11,   2,  8,  5,  1,  -1},
    {   1,  5,  4,  0,   3,  2, 11, -1,  -1, -1, -1, -1,  -1},
    {   8, 11,  2,  0,   9,  4,  5, -1,  -1, -1, -1, -1,  -1},
    {  11,  3,  2, -1,   9,  4,  5, -1,  -1, -1, -1, -1,  -1},
    {   3,  8,  4,  2,   2,  4,  5, 10,  -1, -1, -1, -1,  -1},
    {  10,  2,  5, -1,   5,  2,  4, -1,   2,  0,  4, -1,  -1},
    {   0,  3,  8, -1,   5,  9,  4, -1,  10,  2,  1, -1,  -1},
    {   2,  1, 10, -1,   9,  4,  5, -1,  -1, -1, -1, -1,  -1},
    {   4,  5,  8, -1,   8,  5,  3, -1,   5,  1,  3, -1,  -1},
    {   5,  1,  0,  4,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   3,  8,  0, -1,   4,  5,  9, -1,  -1, -1, -1, -1,  -1},
    {   9,  4,  5, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   7,  4, 11, -1,   4,  9, 11, -1,  11,  9, 10, -1,  -1},
    {  11,  4,  9, 10,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  7,  4, -1,   1, 10, 11,  4,   1,  4,  0, -1,  -1},
    {  11, 10,  1,  3,   8,  7,  4, -1,  -1, -1, -1, -1,  -1},
    {   2, 11,  7,  1,   1,  7,  4,  9,  -1, -1, -1, -1,  -1},
    {   3,  2, 11, -1,   4,  8,  7, -1,   9,  1,  0, -1,  -1},
    {   7,  4, 11, -1,  11,  4,  2, -1,   4,  0,  2, -1,  -1},
    {   2, 11,  3, -1,   7,  4,  8, -1,  -1, -1, -1, -1,  -1},
    {   2,  3,  7,  9,   2,  7,  9, 10,  -1, -1, -1, -1,  -1},
    {   0,  2, 10,  9,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   0,  4,  7,  3,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  10,  2,  1, -1,   8,  7,  4, -1,  -1, -1, -1, -1,  -1},
    {   9,  1,  4, -1,   4,  1,  7, -1,   1,  3,  7, -1,  -1},
    {   1,  0,  9, -1,   8,  7,  4, -1,  -1, -1, -1, -1,  -1},
    {   3,  7,  4,  0,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  7,  4, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  9, 10, 11,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   0,  9,  3, -1,   3,  9, 11, -1,   9, 10, 11, -1,  -1},
    {   1, 10,  0, -1,   0, 10,  8, -1,  10, 11,  8, -1,  -1},
    {  10, 11,  3,  1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   2, 11,  1, -1,   1, 11,  9, -1,  11,  8,  9, -1,  -1},
    {  11,  3,  2, -1,   0,  9,  1, -1,  -1, -1, -1, -1,  -1},
    {  11,  8,  0,  2,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  11,  3,  2, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   3,  8,  2, -1,   2,  8, 10, -1,   8,  9, 10, -1,  -1},
    {   9, 10,  2,  0,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  0,  3, -1,   1, 10,  2, -1,  -1, -1, -1, -1,  -1},
    {  10,  2,  1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  9,  1,  3,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   9,  1,  0, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {   8,  0,  3, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1},
    {  -1, -1, -1, -1,  -1, -1, -1, -1,  -1, -1, -1, -1,  -1}
};

