//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package immutable

import (
	context "context"
	fmt "fmt"

	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	scheme.AddValidationFunc((*Struct)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}, subresources ...string) field.ErrorList {
		if len(subresources) == 0 {
			return Validate_Struct(ctx, op, nil /* fldPath */, obj.(*Struct), safe.Cast[*Struct](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresources: %v", obj, subresources))}
	})
	return nil
}

func Validate_ImmutableType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *ImmutableType) (errs field.ErrorList) {
	// type ImmutableType
	errs = append(errs, validate.Immutable(ctx, op, fldPath, obj, oldObj)...)

	return errs
}

func Validate_Struct(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *Struct) (errs field.ErrorList) {
	// field Struct.TypeMeta has no validation

	// field Struct.StringField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string) (errs field.ErrorList) {
			errs = append(errs, validate.Immutable(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("stringField"), &obj.StringField, safe.Field(oldObj, func(oldObj *Struct) *string { return &oldObj.StringField }))...)

	// field Struct.StringPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string) (errs field.ErrorList) {
			errs = append(errs, validate.Immutable(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("stringPtrField"), obj.StringPtrField, safe.Field(oldObj, func(oldObj *Struct) *string { return oldObj.StringPtrField }))...)

	// field Struct.StructField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *ComparableStruct) (errs field.ErrorList) {
			errs = append(errs, validate.Immutable(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("structField"), &obj.StructField, safe.Field(oldObj, func(oldObj *Struct) *ComparableStruct { return &oldObj.StructField }))...)

	// field Struct.StructPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *ComparableStruct) (errs field.ErrorList) {
			errs = append(errs, validate.Immutable(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("structPtrField"), obj.StructPtrField, safe.Field(oldObj, func(oldObj *Struct) *ComparableStruct { return oldObj.StructPtrField }))...)

	// field Struct.NonComparableStructField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *NonComparableStruct) (errs field.ErrorList) {
			errs = append(errs, validate.ImmutableNonComparable(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("noncomparableStructField"), &obj.NonComparableStructField, safe.Field(oldObj, func(oldObj *Struct) *NonComparableStruct { return &oldObj.NonComparableStructField }))...)

	// field Struct.NonComparableStructPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *NonComparableStruct) (errs field.ErrorList) {
			errs = append(errs, validate.ImmutableNonComparable(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("noncomparableStructPtrField"), obj.NonComparableStructPtrField, safe.Field(oldObj, func(oldObj *Struct) *NonComparableStruct { return oldObj.NonComparableStructPtrField }))...)

	// field Struct.SliceField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj []string) (errs field.ErrorList) {
			errs = append(errs, validate.ImmutableNonComparable(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("sliceField"), obj.SliceField, safe.Field(oldObj, func(oldObj *Struct) []string { return oldObj.SliceField }))...)

	// field Struct.MapField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj map[string]string) (errs field.ErrorList) {
			errs = append(errs, validate.ImmutableNonComparable(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("mapField"), obj.MapField, safe.Field(oldObj, func(oldObj *Struct) map[string]string { return oldObj.MapField }))...)

	// field Struct.ImmutableField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *ImmutableType) (errs field.ErrorList) {
			errs = append(errs, Validate_ImmutableType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("immutableField"), &obj.ImmutableField, safe.Field(oldObj, func(oldObj *Struct) *ImmutableType { return &oldObj.ImmutableField }))...)

	// field Struct.ImmutablePtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *ImmutableType) (errs field.ErrorList) {
			errs = append(errs, Validate_ImmutableType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("immutablePtrField"), obj.ImmutablePtrField, safe.Field(oldObj, func(oldObj *Struct) *ImmutableType { return oldObj.ImmutablePtrField }))...)

	return errs
}
