# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CommunicationTokenScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of scopes for an access token."""

    CHAT = "chat"
    """Use this for full access to Chat APIs."""
    VOIP = "voip"
    """Use this for full access to Calling APIs."""
    CHAT_JOIN = "chat.join"
    """Access to Chat APIs but without the authorization to create, delete or update chat threads."""
    CHAT_JOIN_LIMITED = "chat.join.limited"
    """A more limited version of chat.join that doesn't allow to add or remove participants. Use this
    #: scope when the token bearer is not fully trusted, for example in guest scenarios."""
    VOIP_JOIN = "voip.join"
    """Access to Calling APIs but without the authorization to start new calls."""
