# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessProfileType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name which contains the role of the kubeconfig.
    """

    CLUSTER_USER = "clusterUser"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class Distro(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Represents a supported Fabric/Infra. (AKSEdge etc...).
    """

    AKS_EDGE = "AKSEdge"

class Provider(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Information about the connected appliance.
    """

    VM_WARE = "VMWare"
    HCI = "HCI"
    SCVMM = "SCVMM"

class ResourceIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    NONE = "None"

class Status(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Appliance’s health and state of connection to on-prem
    """

    WAITING_FOR_HEARTBEAT = "WaitingForHeartbeat"
    VALIDATING = "Validating"
    CONNECTED = "Connected"
    RUNNING = "Running"
