/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.spi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.ULogger;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.SimpleULogger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public final class JoranDocument
extends DefaultHandler {
    public static final String LOG4J_NS = "http://jakarta.apache.org/log4j/";
    public static final String LS_NS = "http://logging.apache.org/";
    private final List errorList;
    private final List events = new ArrayList(20);
    private SAXParseException fatalError;
    private Locator location;
    private final LoggerRepository repository;

    public JoranDocument(List errorList, LoggerRepository repository) {
        this.errorList = errorList;
        this.repository = repository;
    }

    public void error(SAXParseException spe) {
        this.errorReport(spe);
    }

    public void fatalError(SAXParseException spe) {
        if (this.fatalError == null) {
            this.fatalError = spe;
        }
        this.errorReport(spe);
    }

    public void warning(SAXParseException spe) {
        this.errorReport(spe);
    }

    private void errorReport(SAXParseException spe) {
        int line = spe.getLineNumber();
        ErrorItem errorItem = new ErrorItem("Parsing warning", spe);
        errorItem.setLineNumber(line);
        errorItem.setColNumber(spe.getColumnNumber());
        this.errorList.add(errorItem);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (namespaceURI == null || namespaceURI.length() == 0 || namespaceURI.equals(LOG4J_NS) || namespaceURI.equals(LS_NS)) {
            this.events.add(new StartElementEvent(localName, this.location, attributes));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (namespaceURI == null || namespaceURI.length() == 0 || namespaceURI.equals(LOG4J_NS) || namespaceURI.equals(LS_NS)) {
            this.events.add(new EndElementEvent(localName, this.location));
        }
    }

    public void replay(ContentHandler handler) throws SAXException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        LocatorImpl replayLocation = new LocatorImpl();
        handler.setDocumentLocator(replayLocation);
        Iterator iter = this.events.iterator();
        while (iter.hasNext()) {
            ElementEvent event = (ElementEvent)iter.next();
            event.replay(handler, replayLocation);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (systemId != null && systemId.endsWith("log4j.dtd")) {
            this.getLogger().warn("The 'log4j.dtd' is no longer used nor needed.");
            this.getLogger().warn((Object)"See {}#log4j_dtd for more details.", "http://logging.apache.org/log4j/docs/codes.html");
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        try {
            return super.resolveEntity(publicId, systemId);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            if (e instanceof IOException) {
                this.getLogger().error((Object)"Default entity resolver threw an IOException", e);
                return null;
            }
            return null;
        }
    }

    public void setDocumentLocator(Locator location) {
        this.location = location;
    }

    protected ULogger getLogger() {
        if (this.repository != null) {
            return this.repository.getLogger(this.getClass().getName());
        }
        return SimpleULogger.getLogger(this.getClass().getName());
    }

    private static class StartElementEvent
    extends ElementEvent {
        private Attributes attributes;

        public StartElementEvent(String localName, Locator location, Attributes attributes) {
            super(localName, location);
            this.attributes = new AttributesImpl(attributes);
        }

        public void replay(ContentHandler handler, LocatorImpl replayLocation) throws SAXException {
            super.replay(handler, replayLocation);
            handler.startElement(JoranDocument.LOG4J_NS, this.getLocalName(), this.getLocalName(), this.attributes);
        }
    }

    private static class EndElementEvent
    extends ElementEvent {
        public EndElementEvent(String localName, Locator location) {
            super(localName, location);
        }

        public void replay(ContentHandler handler, LocatorImpl replayLocation) throws SAXException {
            super.replay(handler, replayLocation);
            handler.endElement(JoranDocument.LOG4J_NS, this.getLocalName(), this.getLocalName());
        }
    }

    private static abstract class ElementEvent {
        private String localName;
        private Locator location;

        ElementEvent(String localName, Locator location) {
            this.localName = localName;
            if (location != null) {
                this.location = new LocatorImpl(location);
            }
        }

        public final String getLocalName() {
            return this.localName;
        }

        public void replay(ContentHandler handler, LocatorImpl replayLocation) throws SAXException {
            if (this.location != null) {
                replayLocation.setPublicId(this.location.getPublicId());
                replayLocation.setColumnNumber(this.location.getColumnNumber());
                replayLocation.setLineNumber(this.location.getLineNumber());
                replayLocation.setSystemId(this.location.getSystemId());
            }
        }
    }
}

