/*
Copyright 2018 Google, Inc. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package cmd

import (
	"fmt"

	"github.com/GoogleContainerTools/container-diff/version"
	"github.com/spf13/cobra"
)

var versionCmd = &cobra.Command{
	Use:   "version",
	Short: "Print the version of container-diff",
	Long:  `Print the version of container-diff.`,
	Args:  cobra.ExactArgs(0),
	Run: func(command *cobra.Command, args []string) {
		if shortVersion {
			fmt.Println(version.GetShortVersion())
		} else {
			fmt.Println(version.GetVersion())
		}
	},
}

// `version --short` is useful for `make release`
var shortVersion bool

func init() {
	versionCmd.Flags().BoolVarP(&shortVersion, "short", "", false, "Output single vX.Y.Z word")
	RootCmd.AddCommand(versionCmd)
}
