--TEST--
bcdiv() function
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
require(__DIR__ . "/run_bcmath_tests_function.inc");

$dividends = ["15", "-15", "1", "-9", "14.14", "-16.60", "0.15", "-0.01"];
$divisors = array_merge($dividends, [
    "15151324141414.412312232141241",
    "-132132245132134.1515123765412",
    "141241241241241248267654747412",
    "-149143276547656984948124912",
    "0.1322135476547459213732911312",
    "-0.123912932193769965476541321",
]);

run_bcmath_tests($dividends, $divisors, "/", bcdiv(...));

?>
--EXPECT--
Number "15" (scale 0)
15 / 15                             = 1
15 / -15                            = -1
15 / 1                              = 15
15 / -9                             = -1
15 / 14.14                          = 1
15 / -16.60                         = 0
15 / 0.15                           = 100
15 / -0.01                          = -1500
15 / 15151324141414.412312232141241 = 0
15 / -132132245132134.1515123765412 = 0
15 / 141241241241241248267654747412 = 0
15 / -149143276547656984948124912   = 0
15 / 0.1322135476547459213732911312 = 113
15 / -0.123912932193769965476541321 = -121

Number "-15" (scale 0)
-15 / 15                             = -1
-15 / -15                            = 1
-15 / 1                              = -15
-15 / -9                             = 1
-15 / 14.14                          = -1
-15 / -16.60                         = 0
-15 / 0.15                           = -100
-15 / -0.01                          = 1500
-15 / 15151324141414.412312232141241 = 0
-15 / -132132245132134.1515123765412 = 0
-15 / 141241241241241248267654747412 = 0
-15 / -149143276547656984948124912   = 0
-15 / 0.1322135476547459213732911312 = -113
-15 / -0.123912932193769965476541321 = 121

Number "1" (scale 0)
1 / 15                             = 0
1 / -15                            = 0
1 / 1                              = 1
1 / -9                             = 0
1 / 14.14                          = 0
1 / -16.60                         = 0
1 / 0.15                           = 6
1 / -0.01                          = -100
1 / 15151324141414.412312232141241 = 0
1 / -132132245132134.1515123765412 = 0
1 / 141241241241241248267654747412 = 0
1 / -149143276547656984948124912   = 0
1 / 0.1322135476547459213732911312 = 7
1 / -0.123912932193769965476541321 = -8

Number "-9" (scale 0)
-9 / 15                             = 0
-9 / -15                            = 0
-9 / 1                              = -9
-9 / -9                             = 1
-9 / 14.14                          = 0
-9 / -16.60                         = 0
-9 / 0.15                           = -60
-9 / -0.01                          = 900
-9 / 15151324141414.412312232141241 = 0
-9 / -132132245132134.1515123765412 = 0
-9 / 141241241241241248267654747412 = 0
-9 / -149143276547656984948124912   = 0
-9 / 0.1322135476547459213732911312 = -68
-9 / -0.123912932193769965476541321 = 72

Number "14.14" (scale 0)
14.14 / 15                             = 0
14.14 / -15                            = 0
14.14 / 1                              = 14
14.14 / -9                             = -1
14.14 / 14.14                          = 1
14.14 / -16.60                         = 0
14.14 / 0.15                           = 94
14.14 / -0.01                          = -1414
14.14 / 15151324141414.412312232141241 = 0
14.14 / -132132245132134.1515123765412 = 0
14.14 / 141241241241241248267654747412 = 0
14.14 / -149143276547656984948124912   = 0
14.14 / 0.1322135476547459213732911312 = 106
14.14 / -0.123912932193769965476541321 = -114

Number "-16.60" (scale 0)
-16.60 / 15                             = -1
-16.60 / -15                            = 1
-16.60 / 1                              = -16
-16.60 / -9                             = 1
-16.60 / 14.14                          = -1
-16.60 / -16.60                         = 1
-16.60 / 0.15                           = -110
-16.60 / -0.01                          = 1660
-16.60 / 15151324141414.412312232141241 = 0
-16.60 / -132132245132134.1515123765412 = 0
-16.60 / 141241241241241248267654747412 = 0
-16.60 / -149143276547656984948124912   = 0
-16.60 / 0.1322135476547459213732911312 = -125
-16.60 / -0.123912932193769965476541321 = 133

Number "0.15" (scale 0)
0.15 / 15                             = 0
0.15 / -15                            = 0
0.15 / 1                              = 0
0.15 / -9                             = 0
0.15 / 14.14                          = 0
0.15 / -16.60                         = 0
0.15 / 0.15                           = 1
0.15 / -0.01                          = -15
0.15 / 15151324141414.412312232141241 = 0
0.15 / -132132245132134.1515123765412 = 0
0.15 / 141241241241241248267654747412 = 0
0.15 / -149143276547656984948124912   = 0
0.15 / 0.1322135476547459213732911312 = 1
0.15 / -0.123912932193769965476541321 = -1

Number "-0.01" (scale 0)
-0.01 / 15                             = 0
-0.01 / -15                            = 0
-0.01 / 1                              = 0
-0.01 / -9                             = 0
-0.01 / 14.14                          = 0
-0.01 / -16.60                         = 0
-0.01 / 0.15                           = 0
-0.01 / -0.01                          = 1
-0.01 / 15151324141414.412312232141241 = 0
-0.01 / -132132245132134.1515123765412 = 0
-0.01 / 141241241241241248267654747412 = 0
-0.01 / -149143276547656984948124912   = 0
-0.01 / 0.1322135476547459213732911312 = 0
-0.01 / -0.123912932193769965476541321 = 0

Number "15" (scale 10)
15 / 15                             = 1.0000000000
15 / -15                            = -1.0000000000
15 / 1                              = 15.0000000000
15 / -9                             = -1.6666666666
15 / 14.14                          = 1.0608203677
15 / -16.60                         = -0.9036144578
15 / 0.15                           = 100.0000000000
15 / -0.01                          = -1500.0000000000
15 / 15151324141414.412312232141241 = 0.0000000000
15 / -132132245132134.1515123765412 = 0.0000000000
15 / 141241241241241248267654747412 = 0.0000000000
15 / -149143276547656984948124912   = 0.0000000000
15 / 0.1322135476547459213732911312 = 113.4528213339
15 / -0.123912932193769965476541321 = -121.0527402946

Number "-15" (scale 10)
-15 / 15                             = -1.0000000000
-15 / -15                            = 1.0000000000
-15 / 1                              = -15.0000000000
-15 / -9                             = 1.6666666666
-15 / 14.14                          = -1.0608203677
-15 / -16.60                         = 0.9036144578
-15 / 0.15                           = -100.0000000000
-15 / -0.01                          = 1500.0000000000
-15 / 15151324141414.412312232141241 = 0.0000000000
-15 / -132132245132134.1515123765412 = 0.0000000000
-15 / 141241241241241248267654747412 = 0.0000000000
-15 / -149143276547656984948124912   = 0.0000000000
-15 / 0.1322135476547459213732911312 = -113.4528213339
-15 / -0.123912932193769965476541321 = 121.0527402946

Number "1" (scale 10)
1 / 15                             = 0.0666666666
1 / -15                            = -0.0666666666
1 / 1                              = 1.0000000000
1 / -9                             = -0.1111111111
1 / 14.14                          = 0.0707213578
1 / -16.60                         = -0.0602409638
1 / 0.15                           = 6.6666666666
1 / -0.01                          = -100.0000000000
1 / 15151324141414.412312232141241 = 0.0000000000
1 / -132132245132134.1515123765412 = 0.0000000000
1 / 141241241241241248267654747412 = 0.0000000000
1 / -149143276547656984948124912   = 0.0000000000
1 / 0.1322135476547459213732911312 = 7.5635214222
1 / -0.123912932193769965476541321 = -8.0701826863

Number "-9" (scale 10)
-9 / 15                             = -0.6000000000
-9 / -15                            = 0.6000000000
-9 / 1                              = -9.0000000000
-9 / -9                             = 1.0000000000
-9 / 14.14                          = -0.6364922206
-9 / -16.60                         = 0.5421686746
-9 / 0.15                           = -60.0000000000
-9 / -0.01                          = 900.0000000000
-9 / 15151324141414.412312232141241 = 0.0000000000
-9 / -132132245132134.1515123765412 = 0.0000000000
-9 / 141241241241241248267654747412 = 0.0000000000
-9 / -149143276547656984948124912   = 0.0000000000
-9 / 0.1322135476547459213732911312 = -68.0716928003
-9 / -0.123912932193769965476541321 = 72.6316441767

Number "14.14" (scale 10)
14.14 / 15                             = 0.9426666666
14.14 / -15                            = -0.9426666666
14.14 / 1                              = 14.1400000000
14.14 / -9                             = -1.5711111111
14.14 / 14.14                          = 1.0000000000
14.14 / -16.60                         = -0.8518072289
14.14 / 0.15                           = 94.2666666666
14.14 / -0.01                          = -1414.0000000000
14.14 / 15151324141414.412312232141241 = 0.0000000000
14.14 / -132132245132134.1515123765412 = 0.0000000000
14.14 / 141241241241241248267654747412 = 0.0000000000
14.14 / -149143276547656984948124912   = 0.0000000000
14.14 / 0.1322135476547459213732911312 = 106.9481929107
14.14 / -0.123912932193769965476541321 = -114.1123831844

Number "-16.60" (scale 10)
-16.60 / 15                             = -1.1066666666
-16.60 / -15                            = 1.1066666666
-16.60 / 1                              = -16.6000000000
-16.60 / -9                             = 1.8444444444
-16.60 / 14.14                          = -1.1739745403
-16.60 / -16.60                         = 1.0000000000
-16.60 / 0.15                           = -110.6666666666
-16.60 / -0.01                          = 1660.0000000000
-16.60 / 15151324141414.412312232141241 = 0.0000000000
-16.60 / -132132245132134.1515123765412 = 0.0000000000
-16.60 / 141241241241241248267654747412 = 0.0000000000
-16.60 / -149143276547656984948124912   = 0.0000000000
-16.60 / 0.1322135476547459213732911312 = -125.5544556095
-16.60 / -0.123912932193769965476541321 = 133.9650325927

Number "0.15" (scale 10)
0.15 / 15                             = 0.0100000000
0.15 / -15                            = -0.0100000000
0.15 / 1                              = 0.1500000000
0.15 / -9                             = -0.0166666666
0.15 / 14.14                          = 0.0106082036
0.15 / -16.60                         = -0.0090361445
0.15 / 0.15                           = 1.0000000000
0.15 / -0.01                          = -15.0000000000
0.15 / 15151324141414.412312232141241 = 0.0000000000
0.15 / -132132245132134.1515123765412 = 0.0000000000
0.15 / 141241241241241248267654747412 = 0.0000000000
0.15 / -149143276547656984948124912   = 0.0000000000
0.15 / 0.1322135476547459213732911312 = 1.1345282133
0.15 / -0.123912932193769965476541321 = -1.2105274029

Number "-0.01" (scale 10)
-0.01 / 15                             = -0.0006666666
-0.01 / -15                            = 0.0006666666
-0.01 / 1                              = -0.0100000000
-0.01 / -9                             = 0.0011111111
-0.01 / 14.14                          = -0.0007072135
-0.01 / -16.60                         = 0.0006024096
-0.01 / 0.15                           = -0.0666666666
-0.01 / -0.01                          = 1.0000000000
-0.01 / 15151324141414.412312232141241 = 0.0000000000
-0.01 / -132132245132134.1515123765412 = 0.0000000000
-0.01 / 141241241241241248267654747412 = 0.0000000000
-0.01 / -149143276547656984948124912   = 0.0000000000
-0.01 / 0.1322135476547459213732911312 = -0.0756352142
-0.01 / -0.123912932193769965476541321 = 0.0807018268
