/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.printers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Printer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class HTMLPrinter
extends AbstractComponent
implements Printer {
    static final String ENCODING = "UTF8";

    public void print(Document document, CreationContext creationContext, OutputStream outputStream) throws CreationException, IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, ENCODING));
        this.printDocument(document, bufferedWriter);
        bufferedWriter.flush();
    }

    private void printAttribute(Attr attr, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(String.valueOf(attr.getName()) + "=\"" + attr.getValue() + "\"");
    }

    private void printCDATASection(CDATASection cDATASection, BufferedWriter bufferedWriter) throws IOException {
        this.printString(cDATASection.getData(), bufferedWriter);
    }

    private void printComment(Comment comment, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!--" + comment.getData() + "-->");
    }

    private void printDocument(Document document, BufferedWriter bufferedWriter) throws IOException {
        this.printNodeList(document.getChildNodes(), bufferedWriter);
    }

    private void printDocumentFragment(DocumentFragment documentFragment, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- Document Fragment Node -->");
    }

    private void printDocumentType(DocumentType documentType, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- DOCTYPE " + documentType.getName() + " -->");
    }

    private void printElement(Element element, BufferedWriter bufferedWriter) throws IOException {
        String string = element.getTagName().toUpperCase();
        bufferedWriter.write("<" + string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null && namedNodeMap.getLength() > 0) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                bufferedWriter.write(32);
                this.printAttribute((Attr)namedNodeMap.item(n), bufferedWriter);
                ++n;
            }
        }
        bufferedWriter.write(">");
        if (element.getChildNodes() != null && element.getChildNodes().getLength() > 0) {
            this.printNodeList(element.getChildNodes(), bufferedWriter);
        }
        if (string.equals("AREA")) {
            return;
        }
        if (string.equals("BASE")) {
            return;
        }
        if (string.equals("BASEFONT")) {
            return;
        }
        if (string.equals("BR")) {
            return;
        }
        if (string.equals("COL")) {
            return;
        }
        if (string.equals("FRAME")) {
            return;
        }
        if (string.equals("HR")) {
            return;
        }
        if (string.equals("IMG")) {
            return;
        }
        if (string.equals("INPUT")) {
            return;
        }
        if (string.equals("ISINDEX")) {
            return;
        }
        if (string.equals("LINK")) {
            return;
        }
        if (string.equals("META")) {
            return;
        }
        if (string.equals("PARAM")) {
            return;
        }
        bufferedWriter.write("</" + string + ">");
    }

    private void printEntity(Entity entity, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- Entity Node -->");
    }

    private void printEntityReference(EntityReference entityReference, BufferedWriter bufferedWriter) throws IOException {
        this.printString(entityReference.getFirstChild().getNodeValue(), bufferedWriter);
    }

    private void printNodeList(NodeList nodeList, BufferedWriter bufferedWriter) throws IOException {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            switch (node.getNodeType()) {
                case 2: {
                    this.printAttribute((Attr)node, bufferedWriter);
                    break;
                }
                case 4: {
                    this.printCDATASection((CDATASection)node, bufferedWriter);
                    break;
                }
                case 8: {
                    this.printComment((Comment)node, bufferedWriter);
                    break;
                }
                case 11: {
                    this.printDocumentFragment((DocumentFragment)node, bufferedWriter);
                    break;
                }
                case 9: {
                    this.printDocument((Document)node, bufferedWriter);
                    break;
                }
                case 10: {
                    this.printDocumentType((DocumentType)node, bufferedWriter);
                    break;
                }
                case 1: {
                    this.printElement((Element)node, bufferedWriter);
                    break;
                }
                case 6: {
                    this.printEntity((Entity)node, bufferedWriter);
                    break;
                }
                case 5: {
                    this.printEntityReference((EntityReference)node, bufferedWriter);
                    break;
                }
                case 12: {
                    this.printNotation((Notation)node, bufferedWriter);
                    break;
                }
                case 7: {
                    this.printProcessingInstruction((ProcessingInstruction)node, bufferedWriter);
                    break;
                }
                case 3: {
                    this.printText((Text)node, bufferedWriter);
                    break;
                }
            }
            ++n;
        }
    }

    private void printNotation(Notation notation, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- Notation Node -->");
    }

    private void printProcessingInstruction(ProcessingInstruction processingInstruction, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- PI:" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "-->");
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void printString(String var1_1, BufferedWriter var2_2) throws IOException {
        var3_3 = 0;
        while (var3_3 < var1_1.length()) {
            block100: {
                block105: {
                    block104: {
                        block103: {
                            block102: {
                                block101: {
                                    block99: {
                                        var4_4 = var1_1.charAt(var3_3);
                                        if (var4_4 != '\n') break block99;
                                        var2_2.write("\n");
                                        break block100;
                                    }
                                    if (var4_4 != '\"') break block101;
                                    var2_2.write("&quot;");
                                    break block100;
                                }
                                if (var4_4 != '&') break block102;
                                var2_2.write("&amp;");
                                break block100;
                            }
                            if (var4_4 != '<') break block103;
                            var2_2.write("&lt;");
                            break block100;
                        }
                        if (var4_4 != '>') break block104;
                        var2_2.write("&gt;");
                        break block100;
                    }
                    if (var4_4 != '\u20ac') break block105;
                    var2_2.write("&euro;");
                    break block100;
                }
                if (var4_4 < '\u00a0' || var4_4 > '\u00ff') ** GOTO lbl318
                switch (var4_4) {
                    case '\u00a0': {
                        var2_2.write("&nbsp;");
                        break;
                    }
                    case '\u00a1': {
                        var2_2.write("&iexcl;");
                        break;
                    }
                    case '\u00a2': {
                        var2_2.write("&cent;");
                        break;
                    }
                    case '\u00a3': {
                        var2_2.write("&pound;");
                        break;
                    }
                    case '\u00a4': {
                        var2_2.write("&curren;");
                        break;
                    }
                    case '\u00a5': {
                        var2_2.write("&yen;");
                        break;
                    }
                    case '\u00a6': {
                        var2_2.write("&brvbar;");
                        break;
                    }
                    case '\u00a7': {
                        var2_2.write("&sect;");
                        break;
                    }
                    case '\u00a8': {
                        var2_2.write("&uml;");
                        break;
                    }
                    case '\u00a9': {
                        var2_2.write("&copy;");
                        break;
                    }
                    case '\u00aa': {
                        var2_2.write("&ordf;");
                        break;
                    }
                    case '\u00ab': {
                        var2_2.write("&laquo;");
                        break;
                    }
                    case '\u00ac': {
                        var2_2.write("&not;");
                        break;
                    }
                    case '\u00ad': {
                        var2_2.write("&shy;");
                        break;
                    }
                    case '\u00ae': {
                        var2_2.write("&reg;");
                        break;
                    }
                    case '\u00af': {
                        var2_2.write("&macr;");
                        break;
                    }
                    case '\u00b0': {
                        var2_2.write("&deg;");
                        break;
                    }
                    case '\u00b1': {
                        var2_2.write("&plusmn;");
                        break;
                    }
                    case '\u00b2': {
                        var2_2.write("&sup2;");
                        break;
                    }
                    case '\u00b3': {
                        var2_2.write("&sup3;");
                        break;
                    }
                    case '\u00b4': {
                        var2_2.write("&acute;");
                        break;
                    }
                    case '\u00b5': {
                        var2_2.write("&micro;");
                        break;
                    }
                    case '\u00b6': {
                        var2_2.write("&para;");
                        break;
                    }
                    case '\u00b7': {
                        var2_2.write("&middot;");
                        break;
                    }
                    case '\u00b8': {
                        var2_2.write("&cedil;");
                        break;
                    }
                    case '\u00b9': {
                        var2_2.write("&sup1;");
                        break;
                    }
                    case '\u00ba': {
                        var2_2.write("&ordm;");
                        break;
                    }
                    case '\u00bb': {
                        var2_2.write("&raquo;");
                        break;
                    }
                    case '\u00bc': {
                        var2_2.write("&frac14;");
                        break;
                    }
                    case '\u00bd': {
                        var2_2.write("&frac12;");
                        break;
                    }
                    case '\u00be': {
                        var2_2.write("&frac34;");
                        break;
                    }
                    case '\u00bf': {
                        var2_2.write("&iquest;");
                        break;
                    }
                    case '\u00c0': {
                        var2_2.write("&Agrave;");
                        break;
                    }
                    case '\u00c1': {
                        var2_2.write("&Aacute;");
                        break;
                    }
                    case '\u00c2': {
                        var2_2.write("&Acirc;");
                        break;
                    }
                    case '\u00c3': {
                        var2_2.write("&Atilde;");
                        break;
                    }
                    case '\u00c4': {
                        var2_2.write("&Auml;");
                        break;
                    }
                    case '\u00c5': {
                        var2_2.write("&Aring;");
                        break;
                    }
                    case '\u00c6': {
                        var2_2.write("&AElig;");
                        break;
                    }
                    case '\u00c7': {
                        var2_2.write("&Ccedil;");
                        break;
                    }
                    case '\u00c8': {
                        var2_2.write("&Egrave;");
                        break;
                    }
                    case '\u00c9': {
                        var2_2.write("&Eacute;");
                        break;
                    }
                    case '\u00ca': {
                        var2_2.write("&Ecirc;");
                        break;
                    }
                    case '\u00cb': {
                        var2_2.write("&Euml;");
                        break;
                    }
                    case '\u00cc': {
                        var2_2.write("&Igrave;");
                        break;
                    }
                    case '\u00cd': {
                        var2_2.write("&Iacute;");
                        break;
                    }
                    case '\u00ce': {
                        var2_2.write("&Icirc;");
                        break;
                    }
                    case '\u00cf': {
                        var2_2.write("&Iuml;");
                        break;
                    }
                    case '\u00d0': {
                        var2_2.write("&ETH;");
                        break;
                    }
                    case '\u00d1': {
                        var2_2.write("&Ntilde;");
                        break;
                    }
                    case '\u00d2': {
                        var2_2.write("&Ograve;");
                        break;
                    }
                    case '\u00d3': {
                        var2_2.write("&Oacute;");
                        break;
                    }
                    case '\u00d4': {
                        var2_2.write("&Ocirc;");
                        break;
                    }
                    case '\u00d5': {
                        var2_2.write("&Otilde;");
                        break;
                    }
                    case '\u00d6': {
                        var2_2.write("&Ouml;");
                        break;
                    }
                    case '\u00d7': {
                        var2_2.write("&times;");
                        break;
                    }
                    case '\u00d8': {
                        var2_2.write("&Oslash;");
                        break;
                    }
                    case '\u00d9': {
                        var2_2.write("&Ugrave;");
                        break;
                    }
                    case '\u00da': {
                        var2_2.write("&Uacute;");
                        break;
                    }
                    case '\u00db': {
                        var2_2.write("&Ucirc;");
                        break;
                    }
                    case '\u00dc': {
                        var2_2.write("&Uuml;");
                        break;
                    }
                    case '\u00dd': {
                        var2_2.write("&Yacute;");
                        break;
                    }
                    case '\u00de': {
                        var2_2.write("&THORN;");
                        break;
                    }
                    case '\u00df': {
                        var2_2.write("&szlig;");
                        break;
                    }
                    case '\u00e0': {
                        var2_2.write("&agrave;");
                        break;
                    }
                    case '\u00e1': {
                        var2_2.write("&aacute;");
                        break;
                    }
                    case '\u00e2': {
                        var2_2.write("&acirc;");
                        break;
                    }
                    case '\u00e3': {
                        var2_2.write("&atilde;");
                        break;
                    }
                    case '\u00e4': {
                        var2_2.write("&auml;");
                        break;
                    }
                    case '\u00e5': {
                        var2_2.write("&aring;");
                        break;
                    }
                    case '\u00e6': {
                        var2_2.write("&aelig;");
                        break;
                    }
                    case '\u00e7': {
                        var2_2.write("&ccedil;");
                        break;
                    }
                    case '\u00e8': {
                        var2_2.write("&egrave;");
                        break;
                    }
                    case '\u00e9': {
                        var2_2.write("&eacute;");
                        break;
                    }
                    case '\u00ea': {
                        var2_2.write("&ecirc;");
                        break;
                    }
                    case '\u00eb': {
                        var2_2.write("&euml;");
                        break;
                    }
                    case '\u00ec': {
                        var2_2.write("&igrave;");
                        break;
                    }
                    case '\u00ed': {
                        var2_2.write("&iacute;");
                        break;
                    }
                    case '\u00ee': {
                        var2_2.write("&icirc;");
                        break;
                    }
                    case '\u00ef': {
                        var2_2.write("&iuml;");
                        break;
                    }
                    case '\u00f0': {
                        var2_2.write("&eth;");
                        break;
                    }
                    case '\u00f1': {
                        var2_2.write("&ntilde;");
                        break;
                    }
                    case '\u00f2': {
                        var2_2.write("&ograve;");
                        break;
                    }
                    case '\u00f3': {
                        var2_2.write("&oacute;");
                        break;
                    }
                    case '\u00f4': {
                        var2_2.write("&ocirc;");
                        break;
                    }
                    case '\u00f5': {
                        var2_2.write("&otilde;");
                        break;
                    }
                    case '\u00f6': {
                        var2_2.write("&ouml;");
                        break;
                    }
                    case '\u00f7': {
                        var2_2.write("&divide;");
                        break;
                    }
                    case '\u00f8': {
                        var2_2.write("&oslash;");
                        break;
                    }
                    case '\u00f9': {
                        var2_2.write("&ugrave;");
                        break;
                    }
                    case '\u00fa': {
                        var2_2.write("&uacute;");
                        break;
                    }
                    case '\u00fb': {
                        var2_2.write("&ucirc;");
                        break;
                    }
                    case '\u00fc': {
                        var2_2.write("&uuml;");
                        break;
                    }
                    case '\u00fd': {
                        var2_2.write("&yacute;");
                        break;
                    }
                    case '\u00fe': {
                        var2_2.write("&thorn;");
                        break;
                    }
                    case '\u00ff': {
                        var2_2.write("&yuml;");
                        break;
                    }
lbl318:
                    // 1 sources

                    var2_2.write(var4_4);
                    break;
                }
            }
            ++var3_3;
        }
    }

    private void printText(Text text, BufferedWriter bufferedWriter) throws IOException {
        this.printString(text.getData(), bufferedWriter);
    }
}

