/**********************************************************************
 * $list_pathout_ports example -- C source code using ACC PLI routines
 *
 * C source to scan through a module and list the names of all output
 * ports which are also connected to a pin-to-pin path delay within
 * the module.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $list_pathout_ports(<module_instance>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_ListPorts_checktf(),
 *              PLIbook_ListPorts_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_ListPorts_checktf,     /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_ListPorts_calltf,      /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$list_pathout_ports",         /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_ListPorts_checktf()
{
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$list_pathout_ports must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$list_pathout_ports arg cannot be null.");
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$list_pathout_ports arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_ListPorts_calltf()
{
  handle module_h, modpath_h, pathterm_h, net_h, port_h;

  acc_initialize();

  module_h = acc_handle_tfarg(1);
  io_printf("\nOutput ports with path delays in module %s:\n",
            acc_fetch_defname(module_h));

  modpath_h = pathterm_h = net_h = port_h = null;
  while (modpath_h = acc_next_modpath(module_h, modpath_h)) {
    while (pathterm_h = acc_next_output(modpath_h, pathterm_h)) {
      net_h = acc_handle_conn(pathterm_h);
      while (port_h = acc_next_port(net_h, port_h)) {
        io_printf("  Port %s\n", acc_fetch_name(port_h));
      }
    }
  }
  acc_close();
  return(0);
}
/*********************************************************************/

