# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AddUsersPayload(msrest.serialization.Model):
    """Payload for Add Users operation on a Lab.

    All required parameters must be populated in order to send to Azure.

    :param email_addresses: Required. List of user emails addresses to add to the lab.
    :type email_addresses: list[str]
    """

    _validation = {
        'email_addresses': {'required': True},
    }

    _attribute_map = {
        'email_addresses': {'key': 'emailAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddUsersPayload, self).__init__(**kwargs)
        self.email_addresses = kwargs['email_addresses']


class CloudErrorBody(msrest.serialization.Model):
    """Body of an error from a REST request.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param target:
    :type target: str
    :param details: Inner errors.
    :type details: list[~azure.mgmt.labservices.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class CreateLabProperties(msrest.serialization.Model):
    """Properties for creating a managed lab and a default environment setting.

    All required parameters must be populated in order to send to Azure.

    :param environment_setting_creation_parameters: Settings related to creating an environment
     setting.
    :type environment_setting_creation_parameters:
     ~azure.mgmt.labservices.models.EnvironmentSettingCreationParameters
    :param lab_creation_parameters: Required. Settings related to creating a lab.
    :type lab_creation_parameters: ~azure.mgmt.labservices.models.LabCreationParameters
    :param name: Required. The name of the resource.
    :type name: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'lab_creation_parameters': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'environment_setting_creation_parameters': {'key': 'environmentSettingCreationParameters', 'type': 'EnvironmentSettingCreationParameters'},
        'lab_creation_parameters': {'key': 'labCreationParameters', 'type': 'LabCreationParameters'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateLabProperties, self).__init__(**kwargs)
        self.environment_setting_creation_parameters = kwargs.get('environment_setting_creation_parameters', None)
        self.lab_creation_parameters = kwargs['lab_creation_parameters']
        self.name = kwargs['name']
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Environment(Resource):
    """Represents an environment instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param resource_sets: The set of a VM and the setting id it was created for.
    :type resource_sets: ~azure.mgmt.labservices.models.ResourceSet
    :ivar claimed_by_user_object_id: The AAD object Id of the user who has claimed the environment.
    :vartype claimed_by_user_object_id: str
    :ivar claimed_by_user_principal_id: The user principal Id of the user who has claimed the
     environment.
    :vartype claimed_by_user_principal_id: str
    :ivar claimed_by_user_name: The name or email address of the user who has claimed the
     environment.
    :vartype claimed_by_user_name: str
    :ivar is_claimed: Is the environment claimed or not.
    :vartype is_claimed: bool
    :ivar last_known_power_state: Last known power state of the environment.
    :vartype last_known_power_state: str
    :ivar network_interface: Network details of the environment.
    :vartype network_interface: ~azure.mgmt.labservices.models.NetworkInterface
    :ivar total_usage: How long the environment has been used by a lab user.
    :vartype total_usage: ~datetime.timedelta
    :ivar password_last_reset: When the password was last reset on the environment.
    :vartype password_last_reset: ~datetime.datetime
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex: status, error.
    :vartype latest_operation_result: ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'claimed_by_user_object_id': {'readonly': True},
        'claimed_by_user_principal_id': {'readonly': True},
        'claimed_by_user_name': {'readonly': True},
        'is_claimed': {'readonly': True},
        'last_known_power_state': {'readonly': True},
        'network_interface': {'readonly': True},
        'total_usage': {'readonly': True},
        'password_last_reset': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_sets': {'key': 'properties.resourceSets', 'type': 'ResourceSet'},
        'claimed_by_user_object_id': {'key': 'properties.claimedByUserObjectId', 'type': 'str'},
        'claimed_by_user_principal_id': {'key': 'properties.claimedByUserPrincipalId', 'type': 'str'},
        'claimed_by_user_name': {'key': 'properties.claimedByUserName', 'type': 'str'},
        'is_claimed': {'key': 'properties.isClaimed', 'type': 'bool'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterface'},
        'total_usage': {'key': 'properties.totalUsage', 'type': 'duration'},
        'password_last_reset': {'key': 'properties.passwordLastReset', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Environment, self).__init__(**kwargs)
        self.resource_sets = kwargs.get('resource_sets', None)
        self.claimed_by_user_object_id = None
        self.claimed_by_user_principal_id = None
        self.claimed_by_user_name = None
        self.is_claimed = None
        self.last_known_power_state = None
        self.network_interface = None
        self.total_usage = None
        self.password_last_reset = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None


class EnvironmentDetails(msrest.serialization.Model):
    """This represents the details about a User's environment and its state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the Environment.
    :vartype name: str
    :ivar description: Description of the Environment.
    :vartype description: str
    :ivar id: Resource Id of the environment.
    :vartype id: str
    :ivar provisioning_state: The provisioning state of the environment. This also includes
     LabIsFull and NotYetProvisioned status.
    :vartype provisioning_state: str
    :ivar virtual_machine_details: Details of backing DTL virtual machine with compute and network
     details.
    :vartype virtual_machine_details: ~azure.mgmt.labservices.models.VirtualMachineDetails
    :ivar latest_operation_result: The details of the latest operation. ex: status, error.
    :vartype latest_operation_result: ~azure.mgmt.labservices.models.LatestOperationResult
    :ivar environment_state: Publishing state of the environment setting Possible values are
     Creating, Created, Failed.
    :vartype environment_state: str
    :ivar total_usage: How long the environment has been used by a lab user.
    :vartype total_usage: ~datetime.timedelta
    :ivar password_last_reset: When the password was last reset on the environment.
    :vartype password_last_reset: ~datetime.datetime
    """

    _validation = {
        'name': {'readonly': True},
        'description': {'readonly': True},
        'id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'virtual_machine_details': {'readonly': True},
        'latest_operation_result': {'readonly': True},
        'environment_state': {'readonly': True},
        'total_usage': {'readonly': True},
        'password_last_reset': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'virtual_machine_details': {'key': 'virtualMachineDetails', 'type': 'VirtualMachineDetails'},
        'latest_operation_result': {'key': 'latestOperationResult', 'type': 'LatestOperationResult'},
        'environment_state': {'key': 'environmentState', 'type': 'str'},
        'total_usage': {'key': 'totalUsage', 'type': 'duration'},
        'password_last_reset': {'key': 'passwordLastReset', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentDetails, self).__init__(**kwargs)
        self.name = None
        self.description = None
        self.id = None
        self.provisioning_state = None
        self.virtual_machine_details = None
        self.latest_operation_result = None
        self.environment_state = None
        self.total_usage = None
        self.password_last_reset = None


class EnvironmentFragment(Resource):
    """Represents an environment instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param resource_sets: The set of a VM and the setting id it was created for.
    :type resource_sets: ~azure.mgmt.labservices.models.ResourceSetFragment
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_sets': {'key': 'properties.resourceSets', 'type': 'ResourceSetFragment'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentFragment, self).__init__(**kwargs)
        self.resource_sets = kwargs.get('resource_sets', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)


class EnvironmentOperationsPayload(msrest.serialization.Model):
    """Represents payload for any Environment operations like get, start, stop, connect.

    All required parameters must be populated in order to send to Azure.

    :param environment_id: Required. The resourceId of the environment.
    :type environment_id: str
    """

    _validation = {
        'environment_id': {'required': True},
    }

    _attribute_map = {
        'environment_id': {'key': 'environmentId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentOperationsPayload, self).__init__(**kwargs)
        self.environment_id = kwargs['environment_id']


class EnvironmentSetting(Resource):
    """Represents settings of an environment, from which environment instances would be created.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar publishing_state: Describes the readiness of this environment setting. Possible values
     include: "Draft", "Publishing", "Published", "PublishFailed", "Scaling".
    :vartype publishing_state: str or ~azure.mgmt.labservices.models.PublishingState
    :param configuration_state: Describes the user's progress in configuring their environment
     setting. Possible values include: "NotApplicable", "Completed".
    :type configuration_state: str or ~azure.mgmt.labservices.models.ConfigurationState
    :param description: Describes the environment and its resource settings.
    :type description: str
    :param title: Brief title describing the environment and its resource settings.
    :type title: str
    :param resource_settings: The resource specific settings.
    :type resource_settings: ~azure.mgmt.labservices.models.ResourceSettings
    :ivar last_changed: Time when the template VM was last changed.
    :vartype last_changed: ~datetime.datetime
    :ivar last_published: Time when the template VM was last sent for publishing.
    :vartype last_published: ~datetime.datetime
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex: status, error.
    :vartype latest_operation_result: ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'publishing_state': {'readonly': True},
        'last_changed': {'readonly': True},
        'last_published': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_state': {'key': 'properties.publishingState', 'type': 'str'},
        'configuration_state': {'key': 'properties.configurationState', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'resource_settings': {'key': 'properties.resourceSettings', 'type': 'ResourceSettings'},
        'last_changed': {'key': 'properties.lastChanged', 'type': 'iso-8601'},
        'last_published': {'key': 'properties.lastPublished', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentSetting, self).__init__(**kwargs)
        self.publishing_state = None
        self.configuration_state = kwargs.get('configuration_state', None)
        self.description = kwargs.get('description', None)
        self.title = kwargs.get('title', None)
        self.resource_settings = kwargs.get('resource_settings', None)
        self.last_changed = None
        self.last_published = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None


class EnvironmentSettingCreationParameters(msrest.serialization.Model):
    """Settings related to creating an environment setting.

    All required parameters must be populated in order to send to Azure.

    :param resource_setting_creation_parameters: Required. The resource specific settings.
    :type resource_setting_creation_parameters:
     ~azure.mgmt.labservices.models.ResourceSettingCreationParameters
    """

    _validation = {
        'resource_setting_creation_parameters': {'required': True},
    }

    _attribute_map = {
        'resource_setting_creation_parameters': {'key': 'resourceSettingCreationParameters', 'type': 'ResourceSettingCreationParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentSettingCreationParameters, self).__init__(**kwargs)
        self.resource_setting_creation_parameters = kwargs['resource_setting_creation_parameters']


class EnvironmentSettingFragment(Resource):
    """Represents settings of an environment, from which environment instances would be created.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param configuration_state: Describes the user's progress in configuring their environment
     setting. Possible values include: "NotApplicable", "Completed".
    :type configuration_state: str or ~azure.mgmt.labservices.models.ConfigurationState
    :param description: Describes the environment and its resource settings.
    :type description: str
    :param title: Brief title describing the environment and its resource settings.
    :type title: str
    :param resource_settings: The resource specific settings.
    :type resource_settings: ~azure.mgmt.labservices.models.ResourceSettingsFragment
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'configuration_state': {'key': 'properties.configurationState', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'resource_settings': {'key': 'properties.resourceSettings', 'type': 'ResourceSettingsFragment'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentSettingFragment, self).__init__(**kwargs)
        self.configuration_state = kwargs.get('configuration_state', None)
        self.description = kwargs.get('description', None)
        self.title = kwargs.get('title', None)
        self.resource_settings = kwargs.get('resource_settings', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)


class EnvironmentSize(msrest.serialization.Model):
    """Represents a size category supported by this Lab Account (small, medium or large).

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: The size category. Possible values include: "Basic", "Standard", "Performance".
    :type name: str or ~azure.mgmt.labservices.models.ManagedLabVmSize
    :param vm_sizes: Represents a set of compute sizes that can serve this given size type.
    :type vm_sizes: list[~azure.mgmt.labservices.models.SizeInfo]
    :ivar max_price: The pay-as-you-go dollar price per hour this size will cost. It does not
     include discounts and may not reflect the actual price the size will cost. This is the maximum
     price of all prices within this tier.
    :vartype max_price: float
    :ivar min_number_of_cores: The number of cores a VM of this size has. This is the minimum
     number of cores within this tier.
    :vartype min_number_of_cores: int
    :ivar min_memory: The amount of memory available (in GB). This is the minimum amount of memory
     within this tier.
    :vartype min_memory: float
    """

    _validation = {
        'max_price': {'readonly': True},
        'min_number_of_cores': {'readonly': True},
        'min_memory': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'vm_sizes': {'key': 'vmSizes', 'type': '[SizeInfo]'},
        'max_price': {'key': 'maxPrice', 'type': 'float'},
        'min_number_of_cores': {'key': 'minNumberOfCores', 'type': 'int'},
        'min_memory': {'key': 'minMemory', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentSize, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.vm_sizes = kwargs.get('vm_sizes', None)
        self.max_price = None
        self.min_number_of_cores = None
        self.min_memory = None


class EnvironmentSizeFragment(msrest.serialization.Model):
    """Represents a size category supported by this Lab Account (small, medium or large).

    :param name: The size category. Possible values include: "Basic", "Standard", "Performance".
    :type name: str or ~azure.mgmt.labservices.models.ManagedLabVmSize
    :param vm_sizes: Represents a set of compute sizes that can serve this given size type.
    :type vm_sizes: list[~azure.mgmt.labservices.models.SizeInfoFragment]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'vm_sizes': {'key': 'vmSizes', 'type': '[SizeInfoFragment]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnvironmentSizeFragment, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.vm_sizes = kwargs.get('vm_sizes', None)


class GalleryImage(Resource):
    """Represents an image from the Azure Marketplace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar author: The author of the gallery image.
    :vartype author: str
    :ivar created_date: The creation date of the gallery image.
    :vartype created_date: ~datetime.datetime
    :ivar description: The description of the gallery image.
    :vartype description: str
    :ivar image_reference: The image reference of the gallery image.
    :vartype image_reference: ~azure.mgmt.labservices.models.GalleryImageReference
    :ivar icon: The icon of the gallery image.
    :vartype icon: str
    :param is_enabled: Indicates whether this gallery image is enabled.
    :type is_enabled: bool
    :param is_override: Indicates whether this gallery has been overridden for this lab account.
    :type is_override: bool
    :ivar plan_id: The third party plan that applies to this image.
    :vartype plan_id: str
    :param is_plan_authorized: Indicates if the plan has been authorized for programmatic
     deployment.
    :type is_plan_authorized: bool
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex: status, error.
    :vartype latest_operation_result: ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'author': {'readonly': True},
        'created_date': {'readonly': True},
        'description': {'readonly': True},
        'image_reference': {'readonly': True},
        'icon': {'readonly': True},
        'plan_id': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'image_reference': {'key': 'properties.imageReference', 'type': 'GalleryImageReference'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'is_override': {'key': 'properties.isOverride', 'type': 'bool'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GalleryImage, self).__init__(**kwargs)
        self.author = None
        self.created_date = None
        self.description = None
        self.image_reference = None
        self.icon = None
        self.is_enabled = kwargs.get('is_enabled', None)
        self.is_override = kwargs.get('is_override', None)
        self.plan_id = None
        self.is_plan_authorized = kwargs.get('is_plan_authorized', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None


class GalleryImageFragment(Resource):
    """Represents an image from the Azure Marketplace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param is_enabled: Indicates whether this gallery image is enabled.
    :type is_enabled: bool
    :param is_override: Indicates whether this gallery has been overridden for this lab account.
    :type is_override: bool
    :param is_plan_authorized: Indicates if the plan has been authorized for programmatic
     deployment.
    :type is_plan_authorized: bool
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'is_override': {'key': 'properties.isOverride', 'type': 'bool'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GalleryImageFragment, self).__init__(**kwargs)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.is_override = kwargs.get('is_override', None)
        self.is_plan_authorized = kwargs.get('is_plan_authorized', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)


class GalleryImageReference(msrest.serialization.Model):
    """The reference information for an Azure Marketplace image.

    :param offer: The offer of the gallery image.
    :type offer: str
    :param publisher: The publisher of the gallery image.
    :type publisher: str
    :param sku: The SKU of the gallery image.
    :type sku: str
    :param os_type: The OS type of the gallery image.
    :type os_type: str
    :param version: The version of the gallery image.
    :type version: str
    """

    _attribute_map = {
        'offer': {'key': 'offer', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GalleryImageReference, self).__init__(**kwargs)
        self.offer = kwargs.get('offer', None)
        self.publisher = kwargs.get('publisher', None)
        self.sku = kwargs.get('sku', None)
        self.os_type = kwargs.get('os_type', None)
        self.version = kwargs.get('version', None)


class GalleryImageReferenceFragment(msrest.serialization.Model):
    """The reference information for an Azure Marketplace image.

    :param offer: The offer of the gallery image.
    :type offer: str
    :param publisher: The publisher of the gallery image.
    :type publisher: str
    :param sku: The SKU of the gallery image.
    :type sku: str
    :param os_type: The OS type of the gallery image.
    :type os_type: str
    :param version: The version of the gallery image.
    :type version: str
    """

    _attribute_map = {
        'offer': {'key': 'offer', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GalleryImageReferenceFragment, self).__init__(**kwargs)
        self.offer = kwargs.get('offer', None)
        self.publisher = kwargs.get('publisher', None)
        self.sku = kwargs.get('sku', None)
        self.os_type = kwargs.get('os_type', None)
        self.version = kwargs.get('version', None)


class GetEnvironmentResponse(msrest.serialization.Model):
    """Represents the environments details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar environment: Details of the environment.
    :vartype environment: ~azure.mgmt.labservices.models.EnvironmentDetails
    """

    _validation = {
        'environment': {'readonly': True},
    }

    _attribute_map = {
        'environment': {'key': 'environment', 'type': 'EnvironmentDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetEnvironmentResponse, self).__init__(**kwargs)
        self.environment = None


class GetPersonalPreferencesResponse(msrest.serialization.Model):
    """Represents the PersonalPreferences for the user.

    :param id: Id to be used by the cache orchestrator.
    :type id: str
    :param favorite_lab_resource_ids: Array of favorite lab resource ids.
    :type favorite_lab_resource_ids: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'favorite_lab_resource_ids': {'key': 'favoriteLabResourceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetPersonalPreferencesResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.favorite_lab_resource_ids = kwargs.get('favorite_lab_resource_ids', None)


class GetRegionalAvailabilityResponse(msrest.serialization.Model):
    """The response model from the GetRegionalAvailability action.

    :param regional_availability: Availability information for different size categories per
     region.
    :type regional_availability: list[~azure.mgmt.labservices.models.RegionalAvailability]
    """

    _attribute_map = {
        'regional_availability': {'key': 'regionalAvailability', 'type': '[RegionalAvailability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetRegionalAvailabilityResponse, self).__init__(**kwargs)
        self.regional_availability = kwargs.get('regional_availability', None)


class Lab(Resource):
    """Represents a lab.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param max_users_in_lab: Maximum number of users allowed in the lab.
    :type max_users_in_lab: int
    :ivar user_quota: Maximum value MaxUsersInLab can be set to, as specified by the service.
    :vartype user_quota: int
    :ivar invitation_code: Invitation code that users can use to join a lab.
    :vartype invitation_code: str
    :ivar created_by_object_id: Object id of the user that created the lab.
    :vartype created_by_object_id: str
    :param usage_quota: Maximum duration a user can use an environment for in the lab.
    :type usage_quota: ~datetime.timedelta
    :param user_access_mode: Lab user access mode (open to all vs. restricted to those listed on
     the lab). Possible values include: "Restricted", "Open".
    :type user_access_mode: str or ~azure.mgmt.labservices.models.LabUserAccessMode
    :ivar created_by_user_principal_name: Lab creator name.
    :vartype created_by_user_principal_name: str
    :ivar created_date: Creation date for the lab.
    :vartype created_date: ~datetime.datetime
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex: status, error.
    :vartype latest_operation_result: ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'user_quota': {'readonly': True},
        'invitation_code': {'readonly': True},
        'created_by_object_id': {'readonly': True},
        'created_by_user_principal_name': {'readonly': True},
        'created_date': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'max_users_in_lab': {'key': 'properties.maxUsersInLab', 'type': 'int'},
        'user_quota': {'key': 'properties.userQuota', 'type': 'int'},
        'invitation_code': {'key': 'properties.invitationCode', 'type': 'str'},
        'created_by_object_id': {'key': 'properties.createdByObjectId', 'type': 'str'},
        'usage_quota': {'key': 'properties.usageQuota', 'type': 'duration'},
        'user_access_mode': {'key': 'properties.userAccessMode', 'type': 'str'},
        'created_by_user_principal_name': {'key': 'properties.createdByUserPrincipalName', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Lab, self).__init__(**kwargs)
        self.max_users_in_lab = kwargs.get('max_users_in_lab', None)
        self.user_quota = None
        self.invitation_code = None
        self.created_by_object_id = None
        self.usage_quota = kwargs.get('usage_quota', None)
        self.user_access_mode = kwargs.get('user_access_mode', None)
        self.created_by_user_principal_name = None
        self.created_date = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None


class LabAccount(Resource):
    """Represents a lab account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar size_configuration: Represents the size configuration under the lab account.
    :vartype size_configuration: ~azure.mgmt.labservices.models.SizeConfigurationProperties
    :param enabled_region_selection: Represents if region selection is enabled.
    :type enabled_region_selection: bool
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex: status, error.
    :vartype latest_operation_result: ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'size_configuration': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'size_configuration': {'key': 'properties.sizeConfiguration', 'type': 'SizeConfigurationProperties'},
        'enabled_region_selection': {'key': 'properties.enabledRegionSelection', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LabAccount, self).__init__(**kwargs)
        self.size_configuration = None
        self.enabled_region_selection = kwargs.get('enabled_region_selection', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None


class LabAccountFragment(Resource):
    """Represents a lab account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param enabled_region_selection: Represents if region selection is enabled.
    :type enabled_region_selection: bool
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'enabled_region_selection': {'key': 'properties.enabledRegionSelection', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LabAccountFragment, self).__init__(**kwargs)
        self.enabled_region_selection = kwargs.get('enabled_region_selection', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)


class LabCreationParameters(msrest.serialization.Model):
    """Settings related to creating a lab.

    :param max_users_in_lab: Maximum number of users allowed in the lab.
    :type max_users_in_lab: int
    """

    _attribute_map = {
        'max_users_in_lab': {'key': 'maxUsersInLab', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LabCreationParameters, self).__init__(**kwargs)
        self.max_users_in_lab = kwargs.get('max_users_in_lab', None)


class LabDetails(msrest.serialization.Model):
    """This represents the details about a lab that the User is in, and its state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Name of the lab.
    :type name: str
    :param provisioning_state: The provisioning state of the lab.
    :type provisioning_state: str
    :param id: The Id of the lab.
    :type id: str
    :ivar usage_quota: The maximum duration a user can use a VM in this lab.
    :vartype usage_quota: ~datetime.timedelta
    """

    _validation = {
        'usage_quota': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'usage_quota': {'key': 'usageQuota', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LabDetails, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.id = kwargs.get('id', None)
        self.usage_quota = None


class LabFragment(Resource):
    """Represents a lab.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param max_users_in_lab: Maximum number of users allowed in the lab.
    :type max_users_in_lab: int
    :param usage_quota: Maximum duration a user can use an environment for in the lab.
    :type usage_quota: ~datetime.timedelta
    :param user_access_mode: Lab user access mode (open to all vs. restricted to those listed on
     the lab). Possible values include: "Restricted", "Open".
    :type user_access_mode: str or ~azure.mgmt.labservices.models.LabUserAccessMode
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'max_users_in_lab': {'key': 'properties.maxUsersInLab', 'type': 'int'},
        'usage_quota': {'key': 'properties.usageQuota', 'type': 'duration'},
        'user_access_mode': {'key': 'properties.userAccessMode', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LabFragment, self).__init__(**kwargs)
        self.max_users_in_lab = kwargs.get('max_users_in_lab', None)
        self.usage_quota = kwargs.get('usage_quota', None)
        self.user_access_mode = kwargs.get('user_access_mode', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)


class LatestOperationResult(msrest.serialization.Model):
    """Details of the status of an operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The current status of the operation.
    :vartype status: str
    :ivar error_code: Error code on failure.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar request_uri: Request URI of the operation.
    :vartype request_uri: str
    :ivar http_method: The HttpMethod - PUT/POST/DELETE for the operation.
    :vartype http_method: str
    :ivar operation_url: The URL to use to check long-running operation status.
    :vartype operation_url: str
    """

    _validation = {
        'status': {'readonly': True},
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'request_uri': {'readonly': True},
        'http_method': {'readonly': True},
        'operation_url': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
        'operation_url': {'key': 'operationUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LatestOperationResult, self).__init__(**kwargs)
        self.status = None
        self.error_code = None
        self.error_message = None
        self.request_uri = None
        self.http_method = None
        self.operation_url = None


class ListEnvironmentsPayload(msrest.serialization.Model):
    """Represents the payload to list environments owned by a user.

    :param lab_id: The resource Id of the lab.
    :type lab_id: str
    """

    _attribute_map = {
        'lab_id': {'key': 'labId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListEnvironmentsPayload, self).__init__(**kwargs)
        self.lab_id = kwargs.get('lab_id', None)


class ListEnvironmentsResponse(msrest.serialization.Model):
    """Represents the list of environments owned by a user.

    :param environments: List of all the environments.
    :type environments: list[~azure.mgmt.labservices.models.EnvironmentDetails]
    """

    _attribute_map = {
        'environments': {'key': 'environments', 'type': '[EnvironmentDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListEnvironmentsResponse, self).__init__(**kwargs)
        self.environments = kwargs.get('environments', None)


class ListLabsResponse(msrest.serialization.Model):
    """Lists the labs owned by a user.

    :param labs: List of all the labs.
    :type labs: list[~azure.mgmt.labservices.models.LabDetails]
    """

    _attribute_map = {
        'labs': {'key': 'labs', 'type': '[LabDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListLabsResponse, self).__init__(**kwargs)
        self.labs = kwargs.get('labs', None)


class NetworkInterface(msrest.serialization.Model):
    """Network details of the environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_ip_address: PrivateIp address of the Compute VM.
    :vartype private_ip_address: str
    :ivar ssh_authority: Connection information for Linux.
    :vartype ssh_authority: str
    :ivar rdp_authority: Connection information for Windows.
    :vartype rdp_authority: str
    :ivar username: Username of the VM.
    :vartype username: str
    """

    _validation = {
        'private_ip_address': {'readonly': True},
        'ssh_authority': {'readonly': True},
        'rdp_authority': {'readonly': True},
        'username': {'readonly': True},
    }

    _attribute_map = {
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterface, self).__init__(**kwargs)
        self.private_ip_address = None
        self.ssh_authority = None
        self.rdp_authority = None
        self.username = None


class OperationBatchStatusPayload(msrest.serialization.Model):
    """Payload to get the status of an operation.

    All required parameters must be populated in order to send to Azure.

    :param urls: Required. The operation url of long running operation.
    :type urls: list[str]
    """

    _validation = {
        'urls': {'required': True},
    }

    _attribute_map = {
        'urls': {'key': 'urls', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationBatchStatusPayload, self).__init__(**kwargs)
        self.urls = kwargs['urls']


class OperationBatchStatusResponse(msrest.serialization.Model):
    """Status Details of the long running operation for an environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar items: Gets a collection of items that contain the operation url and status.
    :vartype items: list[~azure.mgmt.labservices.models.OperationBatchStatusResponseItem]
    """

    _validation = {
        'items': {'readonly': True},
    }

    _attribute_map = {
        'items': {'key': 'items', 'type': '[OperationBatchStatusResponseItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationBatchStatusResponse, self).__init__(**kwargs)
        self.items = None


class OperationBatchStatusResponseItem(msrest.serialization.Model):
    """Represents the status of an operation that used the batch API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation_url: status of the long running operation for an environment.
    :vartype operation_url: str
    :ivar status: status of the long running operation for an environment.
    :vartype status: str
    """

    _validation = {
        'operation_url': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'operation_url': {'key': 'operationUrl', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationBatchStatusResponseItem, self).__init__(**kwargs)
        self.operation_url = None
        self.status = None


class OperationError(msrest.serialization.Model):
    """Error details for the operation in case of a failure.

    :param code: The error code of the operation error.
    :type code: str
    :param message: The error message of the operation error.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class OperationMetadata(msrest.serialization.Model):
    """The REST API operation supported by ManagedLab ResourceProvider.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that describes the operations.
    :type display: ~azure.mgmt.labservices.models.OperationMetadataDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationMetadataDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationMetadata, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationMetadataDisplay(msrest.serialization.Model):
    """The object that describes the operations.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param resource: Resource type on which the operation is performed.
    :type resource: str
    :param operation: Operation type: read, write, delete, listKeys/action, etc.
    :type operation: str
    :param description: Friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationMetadataDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationResult(msrest.serialization.Model):
    """An Operation Result.

    :param status: The operation status.
    :type status: str
    :param error: Error details for the operation in case of a failure.
    :type error: ~azure.mgmt.labservices.models.OperationError
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'OperationError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class OperationStatusPayload(msrest.serialization.Model):
    """Payload to get the status of an operation.

    All required parameters must be populated in order to send to Azure.

    :param operation_url: Required. The operation url of long running operation.
    :type operation_url: str
    """

    _validation = {
        'operation_url': {'required': True},
    }

    _attribute_map = {
        'operation_url': {'key': 'operationUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationStatusPayload, self).__init__(**kwargs)
        self.operation_url = kwargs['operation_url']


class OperationStatusResponse(msrest.serialization.Model):
    """Status Details of the long running operation for an environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: status of the long running operation for an environment.
    :vartype status: str
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationStatusResponse, self).__init__(**kwargs)
        self.status = None


class PersonalPreferencesOperationsPayload(msrest.serialization.Model):
    """Represents payload for any Environment operations like get, start, stop, connect.

    :param lab_account_resource_id: Resource Id of the lab account.
    :type lab_account_resource_id: str
    :param add_remove: Enum indicating if user is adding or removing a favorite lab. Possible
     values include: "Add", "Remove".
    :type add_remove: str or ~azure.mgmt.labservices.models.AddRemove
    :param lab_resource_id: Resource Id of the lab to add/remove from the favorites list.
    :type lab_resource_id: str
    """

    _attribute_map = {
        'lab_account_resource_id': {'key': 'labAccountResourceId', 'type': 'str'},
        'add_remove': {'key': 'addRemove', 'type': 'str'},
        'lab_resource_id': {'key': 'labResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PersonalPreferencesOperationsPayload, self).__init__(**kwargs)
        self.lab_account_resource_id = kwargs.get('lab_account_resource_id', None)
        self.add_remove = kwargs.get('add_remove', None)
        self.lab_resource_id = kwargs.get('lab_resource_id', None)


class ProviderOperationResult(msrest.serialization.Model):
    """Result of the request to list REST API operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by the resource provider.
    :type value: list[~azure.mgmt.labservices.models.OperationMetadata]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationMetadata]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProviderOperationResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class PublishPayload(msrest.serialization.Model):
    """Payload for Publish operation on EnvironmentSetting.

    :param use_existing_image: Whether to use existing VM custom image when publishing.
    :type use_existing_image: bool
    """

    _attribute_map = {
        'use_existing_image': {'key': 'useExistingImage', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublishPayload, self).__init__(**kwargs)
        self.use_existing_image = kwargs.get('use_existing_image', None)


class ReferenceVm(msrest.serialization.Model):
    """Details of a Reference Vm.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param user_name: Required. The username of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine. This will be set to null in GET resource
     API.
    :type password: str
    :ivar vm_state_details: The state details for the reference virtual machine.
    :vartype vm_state_details: ~azure.mgmt.labservices.models.VmStateDetails
    :ivar vm_resource_id: VM resource Id for the environment.
    :vartype vm_resource_id: str
    """

    _validation = {
        'user_name': {'required': True},
        'vm_state_details': {'readonly': True},
        'vm_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'vm_state_details': {'key': 'vmStateDetails', 'type': 'VmStateDetails'},
        'vm_resource_id': {'key': 'vmResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReferenceVm, self).__init__(**kwargs)
        self.user_name = kwargs['user_name']
        self.password = kwargs.get('password', None)
        self.vm_state_details = None
        self.vm_resource_id = None


class ReferenceVmCreationParameters(msrest.serialization.Model):
    """Creation parameters for Reference Vm.

    All required parameters must be populated in order to send to Azure.

    :param user_name: Required. The username of the virtual machine.
    :type user_name: str
    :param password: Required. The password of the virtual machine.
    :type password: str
    """

    _validation = {
        'user_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReferenceVmCreationParameters, self).__init__(**kwargs)
        self.user_name = kwargs['user_name']
        self.password = kwargs['password']


class ReferenceVmFragment(msrest.serialization.Model):
    """Details of a Reference Vm.

    :param user_name: The username of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine. This will be set to null in GET resource
     API.
    :type password: str
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReferenceVmFragment, self).__init__(**kwargs)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)


class RegionalAvailability(msrest.serialization.Model):
    """The availability information of sizes across regions.

    :param region: Corresponding region.
    :type region: str
    :param size_availabilities: List of all the size information for the region.
    :type size_availabilities: list[~azure.mgmt.labservices.models.SizeAvailability]
    """

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
        'size_availabilities': {'key': 'sizeAvailabilities', 'type': '[SizeAvailability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionalAvailability, self).__init__(**kwargs)
        self.region = kwargs.get('region', None)
        self.size_availabilities = kwargs.get('size_availabilities', None)


class RegisterPayload(msrest.serialization.Model):
    """Represents payload for Register action.

    :param registration_code: The registration code of the lab.
    :type registration_code: str
    """

    _attribute_map = {
        'registration_code': {'key': 'registrationCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegisterPayload, self).__init__(**kwargs)
        self.registration_code = kwargs.get('registration_code', None)


class ResetPasswordPayload(msrest.serialization.Model):
    """Represents the payload for resetting passwords.

    All required parameters must be populated in order to send to Azure.

    :param environment_id: Required. The resourceId of the environment.
    :type environment_id: str
    :param username: The username for which the password will be reset.
    :type username: str
    :param password: The password to assign to the user specified in.
    :type password: str
    """

    _validation = {
        'environment_id': {'required': True},
    }

    _attribute_map = {
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResetPasswordPayload, self).__init__(**kwargs)
        self.environment_id = kwargs['environment_id']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class ResourceSet(msrest.serialization.Model):
    """Represents a VM and the setting Id it was created for.

    :param vm_resource_id: VM resource Id for the environment.
    :type vm_resource_id: str
    :param resource_setting_id: resourceSettingId for the environment.
    :type resource_setting_id: str
    """

    _attribute_map = {
        'vm_resource_id': {'key': 'vmResourceId', 'type': 'str'},
        'resource_setting_id': {'key': 'resourceSettingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSet, self).__init__(**kwargs)
        self.vm_resource_id = kwargs.get('vm_resource_id', None)
        self.resource_setting_id = kwargs.get('resource_setting_id', None)


class ResourceSetFragment(msrest.serialization.Model):
    """Represents a VM and the setting Id it was created for.

    :param vm_resource_id: VM resource Id for the environment.
    :type vm_resource_id: str
    :param resource_setting_id: resourceSettingId for the environment.
    :type resource_setting_id: str
    """

    _attribute_map = {
        'vm_resource_id': {'key': 'vmResourceId', 'type': 'str'},
        'resource_setting_id': {'key': 'resourceSettingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSetFragment, self).__init__(**kwargs)
        self.vm_resource_id = kwargs.get('vm_resource_id', None)
        self.resource_setting_id = kwargs.get('resource_setting_id', None)


class ResourceSettingCreationParameters(msrest.serialization.Model):
    """Represents resource specific settings.

    All required parameters must be populated in order to send to Azure.

    :param location: The location where the virtual machine will live.
    :type location: str
    :param name: The name of the resource setting.
    :type name: str
    :param gallery_image_resource_id: Required. The resource id of the gallery image used for
     creating the virtual machine.
    :type gallery_image_resource_id: str
    :param size: The size of the virtual machine. Possible values include: "Basic", "Standard",
     "Performance".
    :type size: str or ~azure.mgmt.labservices.models.ManagedLabVmSize
    :param reference_vm_creation_parameters: Required. Creation parameters for Reference Vm.
    :type reference_vm_creation_parameters:
     ~azure.mgmt.labservices.models.ReferenceVmCreationParameters
    """

    _validation = {
        'gallery_image_resource_id': {'required': True},
        'reference_vm_creation_parameters': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'gallery_image_resource_id': {'key': 'galleryImageResourceId', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'reference_vm_creation_parameters': {'key': 'referenceVmCreationParameters', 'type': 'ReferenceVmCreationParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSettingCreationParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.name = kwargs.get('name', None)
        self.gallery_image_resource_id = kwargs['gallery_image_resource_id']
        self.size = kwargs.get('size', None)
        self.reference_vm_creation_parameters = kwargs['reference_vm_creation_parameters']


class ResourceSettings(msrest.serialization.Model):
    """Represents resource specific settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The unique id of the resource setting.
    :vartype id: str
    :param gallery_image_resource_id: The resource id of the gallery image used for creating the
     virtual machine.
    :type gallery_image_resource_id: str
    :ivar image_name: The name of the image used to created the environment setting.
    :vartype image_name: str
    :param size: The size of the virtual machine. Possible values include: "Basic", "Standard",
     "Performance".
    :type size: str or ~azure.mgmt.labservices.models.ManagedLabVmSize
    :ivar cores: The translated compute cores of the virtual machine.
    :vartype cores: int
    :param reference_vm: Required. Details specific to Reference Vm.
    :type reference_vm: ~azure.mgmt.labservices.models.ReferenceVm
    """

    _validation = {
        'id': {'readonly': True},
        'image_name': {'readonly': True},
        'cores': {'readonly': True},
        'reference_vm': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'gallery_image_resource_id': {'key': 'galleryImageResourceId', 'type': 'str'},
        'image_name': {'key': 'imageName', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'cores': {'key': 'cores', 'type': 'int'},
        'reference_vm': {'key': 'referenceVm', 'type': 'ReferenceVm'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSettings, self).__init__(**kwargs)
        self.id = None
        self.gallery_image_resource_id = kwargs.get('gallery_image_resource_id', None)
        self.image_name = None
        self.size = kwargs.get('size', None)
        self.cores = None
        self.reference_vm = kwargs['reference_vm']


class ResourceSettingsFragment(msrest.serialization.Model):
    """Represents resource specific settings.

    :param gallery_image_resource_id: The resource id of the gallery image used for creating the
     virtual machine.
    :type gallery_image_resource_id: str
    :param size: The size of the virtual machine. Possible values include: "Basic", "Standard",
     "Performance".
    :type size: str or ~azure.mgmt.labservices.models.ManagedLabVmSize
    :param reference_vm: Details specific to Reference Vm.
    :type reference_vm: ~azure.mgmt.labservices.models.ReferenceVmFragment
    """

    _attribute_map = {
        'gallery_image_resource_id': {'key': 'galleryImageResourceId', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'reference_vm': {'key': 'referenceVm', 'type': 'ReferenceVmFragment'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSettingsFragment, self).__init__(**kwargs)
        self.gallery_image_resource_id = kwargs.get('gallery_image_resource_id', None)
        self.size = kwargs.get('size', None)
        self.reference_vm = kwargs.get('reference_vm', None)


class ResponseWithContinuationEnvironment(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.labservices.models.Environment]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Environment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseWithContinuationEnvironment, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ResponseWithContinuationEnvironmentSetting(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.labservices.models.EnvironmentSetting]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EnvironmentSetting]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseWithContinuationEnvironmentSetting, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ResponseWithContinuationGalleryImage(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.labservices.models.GalleryImage]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryImage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseWithContinuationGalleryImage, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ResponseWithContinuationLab(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.labservices.models.Lab]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Lab]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseWithContinuationLab, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ResponseWithContinuationLabAccount(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.labservices.models.LabAccount]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LabAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseWithContinuationLabAccount, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ResponseWithContinuationUser(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.labservices.models.User]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[User]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseWithContinuationUser, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SizeAvailability(msrest.serialization.Model):
    """Represents the size information.

    :param size_category: The category of the size (Basic, Standard, Performance). Possible values
     include: "Basic", "Standard", "Performance".
    :type size_category: str or ~azure.mgmt.labservices.models.ManagedLabVmSize
    :param is_available: Whether or not this size category is available.
    :type is_available: bool
    """

    _attribute_map = {
        'size_category': {'key': 'sizeCategory', 'type': 'str'},
        'is_available': {'key': 'isAvailable', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SizeAvailability, self).__init__(**kwargs)
        self.size_category = kwargs.get('size_category', None)
        self.is_available = kwargs.get('is_available', None)


class SizeConfigurationProperties(msrest.serialization.Model):
    """Represents the size configuration under the lab account.

    :param environment_sizes: Represents a list of size categories supported by this Lab Account
     (Small, Medium, Large).
    :type environment_sizes: list[~azure.mgmt.labservices.models.EnvironmentSize]
    """

    _attribute_map = {
        'environment_sizes': {'key': 'environmentSizes', 'type': '[EnvironmentSize]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SizeConfigurationProperties, self).__init__(**kwargs)
        self.environment_sizes = kwargs.get('environment_sizes', None)


class SizeConfigurationPropertiesFragment(msrest.serialization.Model):
    """Represents the size configuration under the lab account.

    :param environment_sizes: Represents a list of size categories supported by this Lab Account
     (Small, Medium, Large).
    :type environment_sizes: list[~azure.mgmt.labservices.models.EnvironmentSizeFragment]
    """

    _attribute_map = {
        'environment_sizes': {'key': 'environmentSizes', 'type': '[EnvironmentSizeFragment]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SizeConfigurationPropertiesFragment, self).__init__(**kwargs)
        self.environment_sizes = kwargs.get('environment_sizes', None)


class SizeInfo(msrest.serialization.Model):
    """Contains detailed information about a size.

    :param compute_size: Represents the actual compute size, e.g. Standard_A2_v2.
    :type compute_size: str
    :param price: The pay-as-you-go price per hour this size will cost. It does not include
     discounts and may not reflect the actual price the size will cost.
    :type price: float
    :param number_of_cores: The number of cores a VM of this size has.
    :type number_of_cores: int
    :param memory: The amount of memory available (in GB).
    :type memory: float
    """

    _attribute_map = {
        'compute_size': {'key': 'computeSize', 'type': 'str'},
        'price': {'key': 'price', 'type': 'float'},
        'number_of_cores': {'key': 'numberOfCores', 'type': 'int'},
        'memory': {'key': 'memory', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SizeInfo, self).__init__(**kwargs)
        self.compute_size = kwargs.get('compute_size', None)
        self.price = kwargs.get('price', None)
        self.number_of_cores = kwargs.get('number_of_cores', None)
        self.memory = kwargs.get('memory', None)


class SizeInfoFragment(msrest.serialization.Model):
    """Contains detailed information about a size.

    :param compute_size: Represents the actual compute size, e.g. Standard_A2_v2.
    :type compute_size: str
    :param price: The pay-as-you-go price per hour this size will cost. It does not include
     discounts and may not reflect the actual price the size will cost.
    :type price: float
    :param number_of_cores: The number of cores a VM of this size has.
    :type number_of_cores: int
    :param memory: The amount of memory available (in GB).
    :type memory: float
    """

    _attribute_map = {
        'compute_size': {'key': 'computeSize', 'type': 'str'},
        'price': {'key': 'price', 'type': 'float'},
        'number_of_cores': {'key': 'numberOfCores', 'type': 'int'},
        'memory': {'key': 'memory', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SizeInfoFragment, self).__init__(**kwargs)
        self.compute_size = kwargs.get('compute_size', None)
        self.price = kwargs.get('price', None)
        self.number_of_cores = kwargs.get('number_of_cores', None)
        self.memory = kwargs.get('memory', None)


class User(Resource):
    """The User registered to a lab.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar email: The user email address, as it was specified during registration.
    :vartype email: str
    :ivar family_name: The user family name, as it was specified during registration.
    :vartype family_name: str
    :ivar given_name: The user given name, as it was specified during registration.
    :vartype given_name: str
    :ivar tenant_id: The user tenant ID, as it was specified during registration.
    :vartype tenant_id: str
    :ivar total_usage: How long the user has used his VMs in this lab.
    :vartype total_usage: ~datetime.timedelta
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex: status, error.
    :vartype latest_operation_result: ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'email': {'readonly': True},
        'family_name': {'readonly': True},
        'given_name': {'readonly': True},
        'tenant_id': {'readonly': True},
        'total_usage': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'family_name': {'key': 'properties.familyName', 'type': 'str'},
        'given_name': {'key': 'properties.givenName', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'total_usage': {'key': 'properties.totalUsage', 'type': 'duration'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(User, self).__init__(**kwargs)
        self.email = None
        self.family_name = None
        self.given_name = None
        self.tenant_id = None
        self.total_usage = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None


class UserFragment(Resource):
    """The User registered to a lab.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserFragment, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)


class VirtualMachineDetails(msrest.serialization.Model):
    """Details of the backing virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the Dtl VM.
    :vartype provisioning_state: str
    :ivar rdp_authority: Connection information for Windows.
    :vartype rdp_authority: str
    :ivar ssh_authority: Connection information for Linux.
    :vartype ssh_authority: str
    :ivar private_ip_address: PrivateIp address of the compute VM.
    :vartype private_ip_address: str
    :ivar user_name: Compute VM login user name.
    :vartype user_name: str
    :ivar last_known_power_state: Last known compute power state captured in DTL.
    :vartype last_known_power_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'rdp_authority': {'readonly': True},
        'ssh_authority': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'user_name': {'readonly': True},
        'last_known_power_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'last_known_power_state': {'key': 'lastKnownPowerState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineDetails, self).__init__(**kwargs)
        self.provisioning_state = None
        self.rdp_authority = None
        self.ssh_authority = None
        self.private_ip_address = None
        self.user_name = None
        self.last_known_power_state = None


class VmStateDetails(msrest.serialization.Model):
    """Details about the state of the reference virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rdp_authority: The RdpAuthority property is a server DNS host name or IP address followed
     by the service port number for RDP (Remote Desktop Protocol).
    :vartype rdp_authority: str
    :ivar ssh_authority: The SshAuthority property is a server DNS host name or IP address followed
     by the service port number for SSH.
    :vartype ssh_authority: str
    :ivar power_state: The power state of the reference virtual machine.
    :vartype power_state: str
    :ivar last_known_power_state: Last known compute power state captured in DTL.
    :vartype last_known_power_state: str
    """

    _validation = {
        'rdp_authority': {'readonly': True},
        'ssh_authority': {'readonly': True},
        'power_state': {'readonly': True},
        'last_known_power_state': {'readonly': True},
    }

    _attribute_map = {
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'power_state': {'key': 'powerState', 'type': 'str'},
        'last_known_power_state': {'key': 'lastKnownPowerState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmStateDetails, self).__init__(**kwargs)
        self.rdp_authority = None
        self.ssh_authority = None
        self.power_state = None
        self.last_known_power_state = None
