/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;

public class Margin
extends ImageFilterPlus {
    private Color color;
    private int size;
    private int width;
    private int height;
    private int newWidth;
    private boolean started = false;

    public Margin(ImageProducer imageProducer, Color color, int n) {
        super(imageProducer, true);
        this.color = color;
        this.size = n;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            Margin.usage();
        }
        Margin margin = new Margin(null, Color.black, Integer.parseInt(stringArray[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, margin));
    }

    public void resendTopDownLeftRight(ImageProducer imageProducer) {
        this.started = false;
        super.resendTopDownLeftRight(imageProducer);
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.newWidth = n + this.size * 2;
        this.consumer.setDimensions(this.newWidth, n2 + this.size * 2);
        this.started = false;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (!this.started) {
            this.start();
        }
        this.consumer.setPixels(n + this.size, n2 + this.size, n3, n4, colorModel, byArray, n5, n6);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (!this.started) {
            this.start();
        }
        this.consumer.setPixels(n + this.size, n2 + this.size, n3, n4, colorModel, nArray, n5, n6);
    }

    private void start() {
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.started = true;
        int n = this.color.getRGB();
        int[] nArray = new int[this.newWidth];
        int n2 = 0;
        while (n2 < this.newWidth) {
            nArray[n2] = n;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.size) {
            this.consumer.setPixels(0, n3, this.newWidth, 1, (ColorModel)directColorModel, nArray, 0, this.newWidth);
            this.consumer.setPixels(0, this.size + this.height + n3, this.newWidth, 1, (ColorModel)directColorModel, nArray, 0, this.newWidth);
            ++n3;
        }
        int[] nArray2 = new int[this.size];
        int n4 = 0;
        while (n4 < this.size) {
            nArray2[n4] = n;
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.height) {
            this.consumer.setPixels(0, this.size + n5, this.size, 1, (ColorModel)directColorModel, nArray2, 0, this.size);
            this.consumer.setPixels(this.size + this.width, this.size + n5, this.size, 1, (ColorModel)directColorModel, nArray2, 0, this.size);
            ++n5;
        }
    }

    private static void usage() {
        System.err.println("usage: Margin <size>");
        System.exit(1);
    }
}

