# Unix SMB/CIFS implementation.
#
# Copyright (C) Samuel Cabrero <scabrero@suse.de> 2017
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from samba.tests.ntlm_auth_base import NTLMAuthTestCase
import os

class NTLMAuthDefaultDomainTests(NTLMAuthTestCase):

    def test_winbind_empty_domain_arg(self):
        username = os.environ["DC_USERNAME"]
        password = os.environ["DC_PASSWORD"]
        domain = ""
        ret = self.run_helper(client_username=username,
                              client_password=password,
                              client_domain=domain,
                              server_use_winbind=True)
        self.assertTrue(ret)


    def test_winbind_empty_domain_part(self):
        username = "/" + os.environ["DC_USERNAME"]
        password = os.environ["DC_PASSWORD"]
        ret = self.run_helper(client_username=username,
                              client_password=password,
                              server_use_winbind=True)
        self.assertTrue(ret)


    def test_winbind_domain_arg(self):
        username = os.environ["DC_USERNAME"]
        password = os.environ["DC_PASSWORD"]
        domain = os.environ["DOMAIN"]
        ret = self.run_helper(client_username=username,
                              client_password=password,
                              client_domain=domain,
                              server_use_winbind=True)
        self.assertTrue(ret)


    def test_winbind_domain_part(self):
        username = os.environ["DOMAIN"] + "/" + os.environ["DC_USERNAME"]
        password = os.environ["DC_PASSWORD"]
        ret = self.run_helper(client_username=username,
                              client_password=password,
                              server_use_winbind=True)
        self.assertTrue(ret)
