# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DiskMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the different types of disk modes.
    """

    PERSISTENT = "persistent"
    INDEPENDENT_PERSISTENT = "independent_persistent"
    INDEPENDENT_NONPERSISTENT = "independent_nonpersistent"

class DiskType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the different types of disks.
    """

    FLAT = "flat"
    PMEM = "pmem"
    RAWPHYSICAL = "rawphysical"
    RAWVIRTUAL = "rawvirtual"
    SPARSE = "sparse"
    SESPARSE = "sesparse"
    UNKNOWN = "unknown"

class FirmwareType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Firmware type
    """

    BIOS = "bios"
    EFI = "efi"

class IdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of managed service identity.
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"

class InventoryType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The inventory type.
    """

    RESOURCE_POOL = "ResourcePool"
    VIRTUAL_MACHINE = "VirtualMachine"
    VIRTUAL_MACHINE_TEMPLATE = "VirtualMachineTemplate"
    VIRTUAL_NETWORK = "VirtualNetwork"
    CLUSTER = "Cluster"
    DATASTORE = "Datastore"
    HOST = "Host"

class IPAddressAllocationMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """IP address allocation method.
    """

    UNSET = "unset"
    DYNAMIC = "dynamic"
    STATIC = "static"
    LINKLAYER = "linklayer"
    RANDOM = "random"
    OTHER = "other"

class NICType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """NIC type
    """

    VMXNET3 = "vmxnet3"
    VMXNET2 = "vmxnet2"
    VMXNET = "vmxnet"
    E1000 = "e1000"
    E1000_E = "e1000e"
    PCNET32 = "pcnet32"

class OsType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the different types of VM guest operating systems.
    """

    WINDOWS = "Windows"
    LINUX = "Linux"
    OTHER = "Other"

class PowerOnBootOption(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the options for power on boot.
    """

    ENABLED = "enabled"
    DISABLED = "disabled"

class ProvisioningAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the different types of operations for guest agent.
    """

    INSTALL = "install"
    UNINSTALL = "uninstall"
    REPAIR = "repair"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The current deployment state of resource.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    UPDATING = "Updating"
    DELETING = "Deleting"
    ACCEPTED = "Accepted"
    CREATED = "Created"

class SCSIControllerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the different types of SCSI controllers.
    """

    LSILOGIC = "lsilogic"
    BUSLOGIC = "buslogic"
    PVSCSI = "pvscsi"
    LSILOGICSAS = "lsilogicsas"

class StatusLevelTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The level code.
    """

    INFO = "Info"
    WARNING = "Warning"
    ERROR = "Error"

class StatusTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the hybrid machine agent.
    """

    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    ERROR = "Error"

class VirtualSCSISharing(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the sharing mode for sharing the SCSI bus.
    """

    NO_SHARING = "noSharing"
    PHYSICAL_SHARING = "physicalSharing"
    VIRTUAL_SHARING = "virtualSharing"
