#include <stdio.h>
#include "misc.h"
int timeout_yet (int msec)
{
  static struct timeval tstart = { 0, 0 };
  struct timeval tnow;

  if (msec == 0)                /* initialiseation */
   {
     gettimeofday (&tstart, NULL);
     return 0;
   }
  gettimeofday (&tnow, NULL);
  return ((tnow.tv_sec * 1e6 + tnow.tv_usec) -
          (tstart.tv_sec * 1e6 + tstart.tv_usec) >= msec * 1e3);
}

void delay (int msec)
{
  struct timeval del;

  del.tv_sec = 0;
  del.tv_usec = msec * 1000;
  select (0, NULL, NULL, NULL, &del);
}

void shortdelay (unsigned msec)
{
  struct timeval start, now;

  struct timezone tz;

  gettimeofday (&start, &tz);
  do
   {
     gettimeofday (&now, &tz);
   }
  while (elapsed_msec (&start, &now) < msec);
}

unsigned elapsed_msec (struct timeval *t1, struct timeval *t2)
{
  unsigned diff, error = 0xFFFFFFFF;

  if (t1->tv_sec > t2->tv_sec)
    return (error);
  diff = (t2->tv_sec - t1->tv_sec) * 1000L;
  if (diff == 0 && t1->tv_usec > t2->tv_usec)
    return (error);
  diff += (t2->tv_usec - t1->tv_usec) / 1000L;
  return (diff);
}
