/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};

static gint ValaInterface_private_offset;
static gpointer vala_interface_parent_class = NULL;

static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);
static GType vala_interface_get_type_once (void);

static inline gpointer
vala_interface_get_instance_private (ValaInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInterface_private_offset);
}

/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}

/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp18_ = FALSE;
	ValaDataType* _tmp19_;
	ValaDataType* _tmp20_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		_tmp4_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_parameter_new ("this", _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		vala_method_set_this_parameter (m, _tmp9_);
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_method_get_this_parameter (m);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_get_this_parameter (m);
		_tmp17_ = _tmp16_;
		vala_scope_add (_tmp11_, _tmp15_, (ValaSymbol*) _tmp17_);
	}
	_tmp19_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp20_ = _tmp19_;
	if (!VALA_IS_VOID_TYPE (_tmp20_)) {
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = vala_method_get_postconditions (m);
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp18_ = _tmp23_ > 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaSourceReference* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaLocalVariable* _tmp33_;
		_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_data_type_copy (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_local_variable_new (_tmp27_, "result", NULL, _tmp29_);
		_tmp31_ = _tmp30_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp31_);
		_vala_code_node_unref0 (_tmp31_);
		_vala_code_node_unref0 (_tmp27_);
		_tmp32_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp33_ = _tmp32_;
		vala_local_variable_set_is_result (_tmp33_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaMemberBinding _tmp4_;
	ValaMemberBinding _tmp5_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_property_get_binding (prop);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		ValaScope* _tmp12_;
		ValaScope* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		ValaParameter* _tmp18_;
		ValaParameter* _tmp19_;
		_tmp6_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_parameter_new ("this", _tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		vala_property_set_this_parameter (prop, _tmp11_);
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_node_unref0 (_tmp7_);
		_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_symbol_get_name ((ValaSymbol*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_property_get_this_parameter (prop);
		_tmp19_ = _tmp18_;
		vala_scope_add (_tmp13_, _tmp17_, (ValaSymbol*) _tmp19_);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	ValaInterfaceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VALA_INTERFACE_GET_CLASS (self);
	if (_klass_->get_virtuals) {
		return _klass_->get_virtuals (self);
	}
	return NULL;
}

static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}

static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
}

static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		gint _prerequisite_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_prerequisite_list = _tmp0_;
		_tmp1_ = _prerequisite_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prerequisite_size = _tmp3_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_prerequisite_index = _prerequisite_index + 1;
			_tmp4_ = _prerequisite_index;
			_tmp5_ = _prerequisite_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prerequisite_list;
			_tmp7_ = vala_list_get (_tmp6_, _prerequisite_index);
			prerequisite = (ValaDataType*) _tmp7_;
			_tmp9_ = prerequisite;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = prerequisite;
				_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp14_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->prerequisites;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->prerequisites;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->prerequisites;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp125_;
	gboolean _tmp126_;
	ValaMap* positions = NULL;
	GHashFunc _tmp256_;
	GEqualFunc _tmp257_;
	GEqualFunc _tmp258_;
	ValaHashMap* _tmp259_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	ValaSemanticAnalyzer* _tmp324_;
	ValaSemanticAnalyzer* _tmp325_;
	ValaSourceFile* _tmp326_;
	ValaSemanticAnalyzer* _tmp327_;
	ValaSemanticAnalyzer* _tmp328_;
	ValaSymbol* _tmp329_;
	gboolean _tmp330_;
	gboolean _tmp331_;
	gboolean result;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_interface_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp40_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			_tmp28_ = _prerequisite_reference_index;
			_tmp29_ = _prerequisite_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _prerequisite_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _prerequisite_reference_index);
			prerequisite_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = prerequisite_reference;
			if (!vala_data_type_is_accessible (_tmp32_, (ValaSymbol*) self)) {
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaDataType* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = prerequisite_reference;
				_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp39_ = _tmp38_;
				vala_report_error (_tmp34_, "prerequisite `%s' is less accessible than interface `%s'", _tmp37_, _tmp39_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp40_ = prerequisite_reference;
			if (!vala_data_type_check_type_arguments (_tmp40_, context, FALSE)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp41_;
		gint _prereq_size = 0;
		ValaList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _prereq_index = 0;
		_tmp41_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp41_;
		_tmp42_ = _prereq_list;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_prereq_size = _tmp44_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp47_;
			gpointer _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			_prereq_index = _prereq_index + 1;
			_tmp45_ = _prereq_index;
			_tmp46_ = _prereq_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _prereq_list;
			_tmp48_ = vala_list_get (_tmp47_, _prereq_index);
			prereq = (ValaDataType*) _tmp48_;
			_tmp49_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp49_)) {
				ValaSourceReference* _tmp50_;
				ValaSourceReference* _tmp51_;
				ValaDataType* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp51_ = _tmp50_;
				_tmp52_ = prereq;
				_tmp53_ = vala_code_node_to_string ((ValaCodeNode*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp56_ = _tmp55_;
				vala_report_error (_tmp51_, "Prerequisite `%s' of interface `%s' is not a class or interface", _tmp54_, _tmp56_);
				_g_free0 (_tmp56_);
				_g_free0 (_tmp54_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp57_ = prereq;
			_tmp58_ = vala_data_type_get_type_symbol (_tmp57_);
			_tmp59_ = _tmp58_;
			if (VALA_IS_CLASS (_tmp59_)) {
				ValaClass* _tmp60_;
				ValaDataType* _tmp73_;
				ValaTypeSymbol* _tmp74_;
				ValaTypeSymbol* _tmp75_;
				ValaClass* _tmp76_;
				_tmp60_ = prereq_class;
				if (_tmp60_ != NULL) {
					ValaSourceReference* _tmp61_;
					ValaSourceReference* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					ValaDataType* _tmp65_;
					ValaTypeSymbol* _tmp66_;
					ValaTypeSymbol* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					ValaClass* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp62_ = _tmp61_;
					_tmp63_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp64_ = _tmp63_;
					_tmp65_ = prereq;
					_tmp66_ = vala_data_type_get_type_symbol (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = prereq_class;
					_tmp71_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp70_);
					_tmp72_ = _tmp71_;
					vala_report_error (_tmp62_, "%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp64_, _tmp69_, _tmp72_);
					_g_free0 (_tmp72_);
					_g_free0 (_tmp69_);
					_g_free0 (_tmp64_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp73_ = prereq;
				_tmp74_ = vala_data_type_get_type_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp76_;
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp77_;
		gint _type_size = 0;
		ValaList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		gint _type_index = 0;
		_tmp77_ = self->priv->prerequisites;
		_type_list = _tmp77_;
		_tmp78_ = _type_list;
		_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		_type_size = _tmp80_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp81_;
			gint _tmp82_;
			ValaDataType* type = NULL;
			ValaList* _tmp83_;
			gpointer _tmp84_;
			ValaDataType* _tmp85_;
			ValaSemanticAnalyzer* _tmp86_;
			ValaSemanticAnalyzer* _tmp87_;
			ValaDataType* _tmp88_;
			_type_index = _type_index + 1;
			_tmp81_ = _type_index;
			_tmp82_ = _type_size;
			if (!(_tmp81_ < _tmp82_)) {
				break;
			}
			_tmp83_ = _type_list;
			_tmp84_ = vala_list_get (_tmp83_, _type_index);
			type = (ValaDataType*) _tmp84_;
			_tmp85_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp85_, context);
			_tmp86_ = vala_code_context_get_analyzer (context);
			_tmp87_ = _tmp86_;
			_tmp88_ = type;
			vala_semantic_analyzer_check_type (_tmp87_, _tmp88_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp89_;
		gint _p_size = 0;
		ValaList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _p_index = 0;
		_tmp89_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp89_;
		_tmp90_ = _p_list;
		_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		_p_size = _tmp92_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp93_;
			gint _tmp94_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp95_;
			gpointer _tmp96_;
			ValaTypeParameter* _tmp97_;
			_p_index = _p_index + 1;
			_tmp93_ = _p_index;
			_tmp94_ = _p_size;
			if (!(_tmp93_ < _tmp94_)) {
				break;
			}
			_tmp95_ = _p_list;
			_tmp96_ = vala_list_get (_tmp95_, _p_index);
			p = (ValaTypeParameter*) _tmp96_;
			_tmp97_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp97_, context);
			_vala_code_node_unref0 (p);
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp98_;
		gint _en_size = 0;
		ValaList* _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		gint _en_index = 0;
		_tmp98_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp98_;
		_tmp99_ = _en_list;
		_tmp100_ = vala_collection_get_size ((ValaCollection*) _tmp99_);
		_tmp101_ = _tmp100_;
		_en_size = _tmp101_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp102_;
			gint _tmp103_;
			ValaEnum* en = NULL;
			ValaList* _tmp104_;
			gpointer _tmp105_;
			ValaEnum* _tmp106_;
			_en_index = _en_index + 1;
			_tmp102_ = _en_index;
			_tmp103_ = _en_size;
			if (!(_tmp102_ < _tmp103_)) {
				break;
			}
			_tmp104_ = _en_list;
			_tmp105_ = vala_list_get (_tmp104_, _en_index);
			en = (ValaEnum*) _tmp105_;
			_tmp106_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp106_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp107_;
		gint _f_size = 0;
		ValaList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _f_index = 0;
		_tmp107_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp107_;
		_tmp108_ = _f_list;
		_tmp109_ = vala_collection_get_size ((ValaCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_f_size = _tmp110_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp111_;
			gint _tmp112_;
			ValaField* f = NULL;
			ValaList* _tmp113_;
			gpointer _tmp114_;
			ValaField* _tmp115_;
			_f_index = _f_index + 1;
			_tmp111_ = _f_index;
			_tmp112_ = _f_size;
			if (!(_tmp111_ < _tmp112_)) {
				break;
			}
			_tmp113_ = _f_list;
			_tmp114_ = vala_list_get (_tmp113_, _f_index);
			f = (ValaField*) _tmp114_;
			_tmp115_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp115_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp116_;
		gint _c_size = 0;
		ValaList* _tmp117_;
		gint _tmp118_;
		gint _tmp119_;
		gint _c_index = 0;
		_tmp116_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp116_;
		_tmp117_ = _c_list;
		_tmp118_ = vala_collection_get_size ((ValaCollection*) _tmp117_);
		_tmp119_ = _tmp118_;
		_c_size = _tmp119_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp120_;
			gint _tmp121_;
			ValaConstant* c = NULL;
			ValaList* _tmp122_;
			gpointer _tmp123_;
			ValaConstant* _tmp124_;
			_c_index = _c_index + 1;
			_tmp120_ = _c_index;
			_tmp121_ = _c_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _c_list;
			_tmp123_ = vala_list_get (_tmp122_, _c_index);
			c = (ValaConstant*) _tmp123_;
			_tmp124_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp124_, context);
			_vala_code_node_unref0 (c);
		}
	}
	_tmp125_ = vala_code_context_get_abi_stability (context);
	_tmp126_ = _tmp125_;
	if (_tmp126_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp127_;
			gint _s_size = 0;
			ValaList* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			gint _s_index = 0;
			_tmp127_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_s_list = _tmp127_;
			_tmp128_ = _s_list;
			_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
			_tmp130_ = _tmp129_;
			_s_size = _tmp130_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp131_;
				gint _tmp132_;
				ValaSymbol* s = NULL;
				ValaList* _tmp133_;
				gpointer _tmp134_;
				ValaSymbol* _tmp135_;
				_s_index = _s_index + 1;
				_tmp131_ = _s_index;
				_tmp132_ = _s_size;
				if (!(_tmp131_ < _tmp132_)) {
					break;
				}
				_tmp133_ = _s_list;
				_tmp134_ = vala_list_get (_tmp133_, _s_index);
				s = (ValaSymbol*) _tmp134_;
				_tmp135_ = s;
				if (VALA_IS_METHOD (_tmp135_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp136_;
					ValaMethod* _tmp137_;
					ValaMethod* _tmp138_;
					gboolean _tmp139_ = FALSE;
					ValaMethod* _tmp140_;
					gboolean _tmp141_;
					gboolean _tmp142_;
					_tmp136_ = s;
					_tmp137_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp137_;
					_tmp138_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp138_, context);
					_tmp140_ = m;
					_tmp141_ = vala_method_get_is_virtual (_tmp140_);
					_tmp142_ = _tmp141_;
					if (_tmp142_) {
						_tmp139_ = TRUE;
					} else {
						ValaMethod* _tmp143_;
						gboolean _tmp144_;
						gboolean _tmp145_;
						_tmp143_ = m;
						_tmp144_ = vala_method_get_is_abstract (_tmp143_);
						_tmp145_ = _tmp144_;
						_tmp139_ = _tmp145_;
					}
					if (_tmp139_) {
						ValaList* _tmp146_;
						ValaMethod* _tmp147_;
						_tmp146_ = self->priv->virtuals;
						_tmp147_ = m;
						vala_collection_add ((ValaCollection*) _tmp146_, (ValaSymbol*) _tmp147_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp148_;
					_tmp148_ = s;
					if (VALA_IS_SIGNAL (_tmp148_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp149_;
						ValaSignal* _tmp150_;
						ValaSignal* _tmp151_;
						ValaSignal* _tmp152_;
						gboolean _tmp153_;
						gboolean _tmp154_;
						_tmp149_ = s;
						_tmp150_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp149_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp150_;
						_tmp151_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp151_, context);
						_tmp152_ = sig;
						_tmp153_ = vala_signal_get_is_virtual (_tmp152_);
						_tmp154_ = _tmp153_;
						if (_tmp154_) {
							ValaList* _tmp155_;
							ValaSignal* _tmp156_;
							_tmp155_ = self->priv->virtuals;
							_tmp156_ = sig;
							vala_collection_add ((ValaCollection*) _tmp155_, (ValaSymbol*) _tmp156_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp157_;
						_tmp157_ = s;
						if (VALA_IS_PROPERTY (_tmp157_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp158_;
							ValaProperty* _tmp159_;
							ValaProperty* _tmp160_;
							gboolean _tmp161_ = FALSE;
							ValaProperty* _tmp162_;
							gboolean _tmp163_;
							gboolean _tmp164_;
							_tmp158_ = s;
							_tmp159_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp159_;
							_tmp160_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp160_, context);
							_tmp162_ = prop;
							_tmp163_ = vala_property_get_is_virtual (_tmp162_);
							_tmp164_ = _tmp163_;
							if (_tmp164_) {
								_tmp161_ = TRUE;
							} else {
								ValaProperty* _tmp165_;
								gboolean _tmp166_;
								gboolean _tmp167_;
								_tmp165_ = prop;
								_tmp166_ = vala_property_get_is_abstract (_tmp165_);
								_tmp167_ = _tmp166_;
								_tmp161_ = _tmp167_;
							}
							if (_tmp161_) {
								ValaList* _tmp168_;
								ValaProperty* _tmp169_;
								_tmp168_ = self->priv->virtuals;
								_tmp169_ = prop;
								vala_collection_add ((ValaCollection*) _tmp168_, (ValaSymbol*) _tmp169_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp170_;
			gint _m_size = 0;
			ValaList* _tmp171_;
			gint _tmp172_;
			gint _tmp173_;
			gint _m_index = 0;
			_tmp170_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_m_list = _tmp170_;
			_tmp171_ = _m_list;
			_tmp172_ = vala_collection_get_size ((ValaCollection*) _tmp171_);
			_tmp173_ = _tmp172_;
			_m_size = _tmp173_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp174_;
				gint _tmp175_;
				ValaMethod* m = NULL;
				ValaList* _tmp176_;
				gpointer _tmp177_;
				ValaMethod* _tmp178_;
				gboolean _tmp179_ = FALSE;
				ValaMethod* _tmp180_;
				gboolean _tmp181_;
				gboolean _tmp182_;
				_m_index = _m_index + 1;
				_tmp174_ = _m_index;
				_tmp175_ = _m_size;
				if (!(_tmp174_ < _tmp175_)) {
					break;
				}
				_tmp176_ = _m_list;
				_tmp177_ = vala_list_get (_tmp176_, _m_index);
				m = (ValaMethod*) _tmp177_;
				_tmp178_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp178_, context);
				_tmp180_ = m;
				_tmp181_ = vala_method_get_is_virtual (_tmp180_);
				_tmp182_ = _tmp181_;
				if (_tmp182_) {
					_tmp179_ = TRUE;
				} else {
					ValaMethod* _tmp183_;
					gboolean _tmp184_;
					gboolean _tmp185_;
					_tmp183_ = m;
					_tmp184_ = vala_method_get_is_abstract (_tmp183_);
					_tmp185_ = _tmp184_;
					_tmp179_ = _tmp185_;
				}
				if (_tmp179_) {
					ValaList* _tmp186_;
					ValaMethod* _tmp187_;
					_tmp186_ = self->priv->virtuals;
					_tmp187_ = m;
					vala_collection_add ((ValaCollection*) _tmp186_, (ValaSymbol*) _tmp187_);
				}
				_vala_code_node_unref0 (m);
			}
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp188_;
			gint _sig_size = 0;
			ValaList* _tmp189_;
			gint _tmp190_;
			gint _tmp191_;
			gint _sig_index = 0;
			_tmp188_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_sig_list = _tmp188_;
			_tmp189_ = _sig_list;
			_tmp190_ = vala_collection_get_size ((ValaCollection*) _tmp189_);
			_tmp191_ = _tmp190_;
			_sig_size = _tmp191_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp192_;
				gint _tmp193_;
				ValaSignal* sig = NULL;
				ValaList* _tmp194_;
				gpointer _tmp195_;
				ValaSignal* _tmp196_;
				ValaSignal* _tmp197_;
				gboolean _tmp198_;
				gboolean _tmp199_;
				_sig_index = _sig_index + 1;
				_tmp192_ = _sig_index;
				_tmp193_ = _sig_size;
				if (!(_tmp192_ < _tmp193_)) {
					break;
				}
				_tmp194_ = _sig_list;
				_tmp195_ = vala_list_get (_tmp194_, _sig_index);
				sig = (ValaSignal*) _tmp195_;
				_tmp196_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp196_, context);
				_tmp197_ = sig;
				_tmp198_ = vala_signal_get_is_virtual (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_) {
					ValaList* _tmp200_;
					ValaSignal* _tmp201_;
					_tmp200_ = self->priv->virtuals;
					_tmp201_ = sig;
					vala_collection_add ((ValaCollection*) _tmp200_, (ValaSymbol*) _tmp201_);
				}
				_vala_code_node_unref0 (sig);
			}
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp202_;
			gint _prop_size = 0;
			ValaList* _tmp203_;
			gint _tmp204_;
			gint _tmp205_;
			gint _prop_index = 0;
			_tmp202_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_prop_list = _tmp202_;
			_tmp203_ = _prop_list;
			_tmp204_ = vala_collection_get_size ((ValaCollection*) _tmp203_);
			_tmp205_ = _tmp204_;
			_prop_size = _tmp205_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp206_;
				gint _tmp207_;
				ValaProperty* prop = NULL;
				ValaList* _tmp208_;
				gpointer _tmp209_;
				ValaProperty* _tmp210_;
				gboolean _tmp211_ = FALSE;
				ValaProperty* _tmp212_;
				gboolean _tmp213_;
				gboolean _tmp214_;
				_prop_index = _prop_index + 1;
				_tmp206_ = _prop_index;
				_tmp207_ = _prop_size;
				if (!(_tmp206_ < _tmp207_)) {
					break;
				}
				_tmp208_ = _prop_list;
				_tmp209_ = vala_list_get (_tmp208_, _prop_index);
				prop = (ValaProperty*) _tmp209_;
				_tmp210_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
				_tmp212_ = prop;
				_tmp213_ = vala_property_get_is_virtual (_tmp212_);
				_tmp214_ = _tmp213_;
				if (_tmp214_) {
					_tmp211_ = TRUE;
				} else {
					ValaProperty* _tmp215_;
					gboolean _tmp216_;
					gboolean _tmp217_;
					_tmp215_ = prop;
					_tmp216_ = vala_property_get_is_abstract (_tmp215_);
					_tmp217_ = _tmp216_;
					_tmp211_ = _tmp217_;
				}
				if (_tmp211_) {
					ValaList* _tmp218_;
					ValaProperty* _tmp219_;
					_tmp218_ = self->priv->virtuals;
					_tmp219_ = prop;
					vala_collection_add ((ValaCollection*) _tmp218_, (ValaSymbol*) _tmp219_);
				}
				_vala_code_node_unref0 (prop);
			}
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp220_;
		gint _cl_size = 0;
		ValaList* _tmp221_;
		gint _tmp222_;
		gint _tmp223_;
		gint _cl_index = 0;
		_tmp220_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp220_;
		_tmp221_ = _cl_list;
		_tmp222_ = vala_collection_get_size ((ValaCollection*) _tmp221_);
		_tmp223_ = _tmp222_;
		_cl_size = _tmp223_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp224_;
			gint _tmp225_;
			ValaClass* cl = NULL;
			ValaList* _tmp226_;
			gpointer _tmp227_;
			ValaClass* _tmp228_;
			_cl_index = _cl_index + 1;
			_tmp224_ = _cl_index;
			_tmp225_ = _cl_size;
			if (!(_tmp224_ < _tmp225_)) {
				break;
			}
			_tmp226_ = _cl_list;
			_tmp227_ = vala_list_get (_tmp226_, _cl_index);
			cl = (ValaClass*) _tmp227_;
			_tmp228_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp228_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp229_;
		gint _iface_size = 0;
		ValaList* _tmp230_;
		gint _tmp231_;
		gint _tmp232_;
		gint _iface_index = 0;
		_tmp229_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp229_;
		_tmp230_ = _iface_list;
		_tmp231_ = vala_collection_get_size ((ValaCollection*) _tmp230_);
		_tmp232_ = _tmp231_;
		_iface_size = _tmp232_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp233_;
			gint _tmp234_;
			ValaInterface* iface = NULL;
			ValaList* _tmp235_;
			gpointer _tmp236_;
			ValaInterface* _tmp237_;
			_iface_index = _iface_index + 1;
			_tmp233_ = _iface_index;
			_tmp234_ = _iface_size;
			if (!(_tmp233_ < _tmp234_)) {
				break;
			}
			_tmp235_ = _iface_list;
			_tmp236_ = vala_list_get (_tmp235_, _iface_index);
			iface = (ValaInterface*) _tmp236_;
			_tmp237_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp237_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp238_;
		gint _st_size = 0;
		ValaList* _tmp239_;
		gint _tmp240_;
		gint _tmp241_;
		gint _st_index = 0;
		_tmp238_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp238_;
		_tmp239_ = _st_list;
		_tmp240_ = vala_collection_get_size ((ValaCollection*) _tmp239_);
		_tmp241_ = _tmp240_;
		_st_size = _tmp241_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp242_;
			gint _tmp243_;
			ValaStruct* st = NULL;
			ValaList* _tmp244_;
			gpointer _tmp245_;
			ValaStruct* _tmp246_;
			_st_index = _st_index + 1;
			_tmp242_ = _st_index;
			_tmp243_ = _st_size;
			if (!(_tmp242_ < _tmp243_)) {
				break;
			}
			_tmp244_ = _st_list;
			_tmp245_ = vala_list_get (_tmp244_, _st_index);
			st = (ValaStruct*) _tmp245_;
			_tmp246_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp247_;
		gint _d_size = 0;
		ValaList* _tmp248_;
		gint _tmp249_;
		gint _tmp250_;
		gint _d_index = 0;
		_tmp247_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp247_;
		_tmp248_ = _d_list;
		_tmp249_ = vala_collection_get_size ((ValaCollection*) _tmp248_);
		_tmp250_ = _tmp249_;
		_d_size = _tmp250_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp251_;
			gint _tmp252_;
			ValaDelegate* d = NULL;
			ValaList* _tmp253_;
			gpointer _tmp254_;
			ValaDelegate* _tmp255_;
			_d_index = _d_index + 1;
			_tmp251_ = _d_index;
			_tmp252_ = _d_size;
			if (!(_tmp251_ < _tmp252_)) {
				break;
			}
			_tmp253_ = _d_list;
			_tmp254_ = vala_list_get (_tmp253_, _d_index);
			d = (ValaDelegate*) _tmp254_;
			_tmp255_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp255_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp256_ = g_direct_hash;
	_tmp257_ = g_direct_equal;
	_tmp258_ = g_direct_equal;
	_tmp259_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp256_, _tmp257_, _tmp258_);
	positions = (ValaMap*) _tmp259_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp260_;
		gint _sym_size = 0;
		ValaList* _tmp261_;
		gint _tmp262_;
		gint _tmp263_;
		gint _sym_index = 0;
		_tmp260_ = self->priv->virtuals;
		_sym_list = _tmp260_;
		_tmp261_ = _sym_list;
		_tmp262_ = vala_collection_get_size ((ValaCollection*) _tmp261_);
		_tmp263_ = _tmp262_;
		_sym_size = _tmp263_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp264_;
			gint _tmp265_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp266_;
			gpointer _tmp267_;
			gint ordering = 0;
			ValaSymbol* _tmp268_;
			gboolean ordered = FALSE;
			gboolean _tmp275_ = FALSE;
			gboolean _tmp276_ = FALSE;
			gboolean _tmp283_ = FALSE;
			gboolean _tmp284_ = FALSE;
			gboolean _tmp285_ = FALSE;
			gboolean _tmp292_ = FALSE;
			gboolean _tmp293_ = FALSE;
			_sym_index = _sym_index + 1;
			_tmp264_ = _sym_index;
			_tmp265_ = _sym_size;
			if (!(_tmp264_ < _tmp265_)) {
				break;
			}
			_tmp266_ = _sym_list;
			_tmp267_ = vala_list_get (_tmp266_, _sym_index);
			sym = (ValaSymbol*) _tmp267_;
			_tmp268_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp268_, "CCode", "ordering", -1);
			if (ordering < -1) {
				ValaSymbol* _tmp269_;
				ValaSourceReference* _tmp270_;
				ValaSourceReference* _tmp271_;
				ValaSymbol* _tmp272_;
				gchar* _tmp273_;
				gchar* _tmp274_;
				_tmp269_ = sym;
				_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp269_);
				_tmp271_ = _tmp270_;
				_tmp272_ = sym;
				_tmp273_ = vala_symbol_get_full_name (_tmp272_);
				_tmp274_ = _tmp273_;
				vala_report_error (_tmp271_, "%s: Invalid ordering", _tmp274_);
				_g_free0 (_tmp274_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			ordered = ordering != -1;
			if (ordered) {
				_tmp276_ = unordered_seen;
			} else {
				_tmp276_ = FALSE;
			}
			if (_tmp276_) {
				_tmp275_ = !ordered_seen;
			} else {
				_tmp275_ = FALSE;
			}
			if (_tmp275_) {
				ValaSymbol* _tmp277_;
				ValaSourceReference* _tmp278_;
				ValaSourceReference* _tmp279_;
				ValaSymbol* _tmp280_;
				gchar* _tmp281_;
				gchar* _tmp282_;
				_tmp277_ = sym;
				_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp277_);
				_tmp279_ = _tmp278_;
				_tmp280_ = sym;
				_tmp281_ = vala_symbol_get_full_name (_tmp280_);
				_tmp282_ = _tmp281_;
				vala_report_error (_tmp279_, "%s: Cannot mix ordered and unordered virtuals", _tmp282_);
				_g_free0 (_tmp282_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (ordered_seen) {
				_tmp283_ = TRUE;
			} else {
				_tmp283_ = ordered;
			}
			ordered_seen = _tmp283_;
			if (!ordered) {
				_tmp285_ = !unordered_seen;
			} else {
				_tmp285_ = FALSE;
			}
			if (_tmp285_) {
				_tmp284_ = ordered_seen;
			} else {
				_tmp284_ = FALSE;
			}
			if (_tmp284_) {
				ValaSymbol* _tmp286_;
				ValaSourceReference* _tmp287_;
				ValaSourceReference* _tmp288_;
				ValaSymbol* _tmp289_;
				gchar* _tmp290_;
				gchar* _tmp291_;
				_tmp286_ = sym;
				_tmp287_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp286_);
				_tmp288_ = _tmp287_;
				_tmp289_ = sym;
				_tmp290_ = vala_symbol_get_full_name (_tmp289_);
				_tmp291_ = _tmp290_;
				vala_report_error (_tmp288_, "%s: Cannot mix ordered and unordered virtuals", _tmp291_);
				_g_free0 (_tmp291_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (unordered_seen) {
				_tmp292_ = TRUE;
			} else {
				_tmp292_ = !ordered;
			}
			unordered_seen = _tmp292_;
			if (!ordered_seen) {
				_tmp293_ = TRUE;
			} else {
				_tmp293_ = !unordered_seen;
			}
			if (_tmp293_) {
				if (ordered) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp294_;
					gpointer _tmp295_;
					ValaSymbol* _tmp296_;
					ValaMap* _tmp306_;
					ValaSymbol* _tmp307_;
					_tmp294_ = positions;
					_tmp295_ = vala_map_get (_tmp294_, (gpointer) ((gintptr) ordering));
					prev = (ValaSymbol*) _tmp295_;
					_tmp296_ = prev;
					if (_tmp296_ != NULL) {
						ValaSymbol* _tmp297_;
						ValaSourceReference* _tmp298_;
						ValaSourceReference* _tmp299_;
						ValaSymbol* _tmp300_;
						gchar* _tmp301_;
						gchar* _tmp302_;
						ValaSymbol* _tmp303_;
						const gchar* _tmp304_;
						const gchar* _tmp305_;
						_tmp297_ = sym;
						_tmp298_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp297_);
						_tmp299_ = _tmp298_;
						_tmp300_ = sym;
						_tmp301_ = vala_symbol_get_full_name (_tmp300_);
						_tmp302_ = _tmp301_;
						_tmp303_ = prev;
						_tmp304_ = vala_symbol_get_name (_tmp303_);
						_tmp305_ = _tmp304_;
						vala_report_error (_tmp299_, "%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp302_, _tmp305_);
						_g_free0 (_tmp302_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp306_ = positions;
					_tmp307_ = sym;
					vala_map_set (_tmp306_, (gpointer) ((gintptr) ordering), _tmp307_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
	}
	if (ordered_seen) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp308_ = FALSE;
				_tmp308_ = TRUE;
				while (TRUE) {
					ValaList* _tmp310_;
					gint _tmp311_;
					gint _tmp312_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp313_;
					gpointer _tmp314_;
					ValaSymbol* _tmp315_;
					gboolean _tmp320_;
					gboolean _tmp321_;
					if (!_tmp308_) {
						gint _tmp309_;
						_tmp309_ = i;
						i = _tmp309_ + 1;
					}
					_tmp308_ = FALSE;
					_tmp310_ = self->priv->virtuals;
					_tmp311_ = vala_collection_get_size ((ValaCollection*) _tmp310_);
					_tmp312_ = _tmp311_;
					if (!(i < _tmp312_)) {
						break;
					}
					_tmp313_ = positions;
					_tmp314_ = vala_map_get (_tmp313_, (gpointer) ((gintptr) i));
					sym = (ValaSymbol*) _tmp314_;
					_tmp315_ = sym;
					if (_tmp315_ == NULL) {
						ValaSourceReference* _tmp316_;
						ValaSourceReference* _tmp317_;
						gchar* _tmp318_;
						gchar* _tmp319_;
						_tmp316_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp317_ = _tmp316_;
						_tmp318_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp319_ = _tmp318_;
						vala_report_error (_tmp317_, "%s: Gap in ordering in position %d", _tmp319_, i);
						_g_free0 (_tmp319_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp320_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp321_ = _tmp320_;
					if (!_tmp321_) {
						ValaList* _tmp322_;
						ValaSymbol* _tmp323_;
						_tmp322_ = self->priv->virtuals;
						_tmp323_ = sym;
						vala_list_set (_tmp322_, i, _tmp323_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp324_ = vala_code_context_get_analyzer (context);
	_tmp325_ = _tmp324_;
	_tmp326_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp325_, _tmp326_);
	_tmp327_ = vala_code_context_get_analyzer (context);
	_tmp328_ = _tmp327_;
	_tmp329_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp328_, _tmp329_);
	_tmp330_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp331_ = _tmp330_;
	result = !_tmp331_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_interface_class_init (ValaInterfaceClass * klass,
                           gpointer klass_data)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInterface_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}

static void
vala_interface_instance_init (ValaInterface * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}

static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}

/**
 * Represents an interface declaration in the source code.
 */
static GType
vala_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
	GType vala_interface_type_id;
	vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
	ValaInterface_private_offset = g_type_add_instance_private (vala_interface_type_id, sizeof (ValaInterfacePrivate));
	return vala_interface_type_id;
}

GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__once = 0;
	if (g_once_init_enter (&vala_interface_type_id__once)) {
		GType vala_interface_type_id;
		vala_interface_type_id = vala_interface_get_type_once ();
		g_once_init_leave (&vala_interface_type_id__once, vala_interface_type_id);
	}
	return vala_interface_type_id__once;
}

