Elpres v0.8 2021-02-20

# Short description

The `elpres` class is intended to be used for presentations on a screen or
with a beamer/projector. It is derived from LaTeX’s article class and can
be used with with LaTeX, pdfLaTeX and LuaLaTeX. The default "virtual paper
size" of presentations generated by this class corresponds to a 4:3
(width:height) aspect ratio. Other aspect ratios for widescreen monitors
(16:9, 16x:10) may be selected. 

The elpres class requires: `ifthen`, `fancyhdr`, `hyperref`, `graphicx`,
`xcolor` and `geometry`.

For enhanced features the packages `ragged2e`, `overlays`, `wallpaper`,
`eso-pic`, `tcolorbox` and `footmisc` are useful.

A homepage for the elpres project: http://vkiefel.de/elpres.html with
additional material.

# Changes in v0.8

* A bug fixed in the `elpres...scheme.sty` files (incorrect value for
  `\labelitemiv`)
* Installation instructions in the manual completed
* Detailed installation instructions added to this file (`README.md`).
* Manual: a description of the new commands `\overlaysoff` and `\alertsoff`
  of the `overlays` package (introduced in version 2.12 of `overlays`)
  included


# Installation 

For a working installation of `elpres.cls` it is required that all of the
following files:

	elpres.cls,
	elpresbluelightgrayscheme.sty,
	elpresgrayscheme.sty,
	elpreswhitebluescheme.sty,
	elpreswhiteredscheme.sty,
	elpreswhitetealscheme.sty,
	ctan-lion.png,
	ep-ball-01.png,
	ep-ball-02.png,
	ep-ball-03.png,
	ep-ball-04.png,
	ep-ball-05.png,
	ep-ball-01.eps,
	ep-ball-02.eps,
	ep-ball-03.eps,
	ep-ball-04.eps,
	ep-ball-05.eps

(in short: `elpres.cls` and all `*.sty`, `*.png` and `*.eps` files) should
be copied into a directory in the `.../tex/...`-branch of a `texmf`-tree
like `../texmf/tex/latex/elpres`, where `texmf` may be `texmf-dist` or
`texmf-local` or an analogous directory. 

The manual and the example file:

	elpres-manual.pdf,
	elpres-manual.tex,
	elpres-example.pdf,
	elpres-example.tex

should be copied into a directory of the `.../doc/...`-branch of a
`texmf`-tree like `../texmf/doc/latex/elpres`, where `texmf` may be
`texmf-dist` or `texmf-local` or an analogous directory.  Finally the file
location database (e.g. `ls-R`) should be updated. More details can be found
in the manual.

# License

This work may be distributed and/or modified under the conditions of the
LaTeX Project Public License (LPPL). The latest version of this license is
available in the file:

   http://www.latex-project.org/lppl.txt

Current maintainer is Volker Kiefel.
