; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I

define i1 @and_icmp_eq(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: and_icmp_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    xor a2, a2, a3
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_icmp_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    xor a2, a2, a3
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %cmp1 = icmp eq i32 %a, %b
  %cmp2 = icmp eq i32 %c, %d
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @or_icmp_ne(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: or_icmp_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    xor a2, a2, a3
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_icmp_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    xor a2, a2, a3
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %cmp1 = icmp ne i32 %a, %b
  %cmp2 = icmp ne i32 %c, %d
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @or_icmps_const_1bit_diff(i64 %x) nounwind {
; RV32I-LABEL: or_icmps_const_1bit_diff:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a2, a0, -13
; RV32I-NEXT:    sltu a0, a2, a0
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    andi a2, a2, -5
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_icmps_const_1bit_diff:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, -13
; RV64I-NEXT:    andi a0, a0, -5
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %a = icmp eq i64 %x, 17
  %b = icmp eq i64 %x, 13
  %r = or i1 %a, %b
  ret i1 %r
}

define i1 @and_icmps_const_1bit_diff(i32 %x) nounwind {
; RV32I-LABEL: and_icmps_const_1bit_diff:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, -44
; RV32I-NEXT:    andi a0, a0, -17
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_icmps_const_1bit_diff:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a0, a0, -44
; RV64I-NEXT:    andi a0, a0, -17
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %a = icmp ne i32 %x, 44
  %b = icmp ne i32 %x, 60
  %r = and i1 %a, %b
  ret i1 %r
}

define i1 @and_icmps_const_not1bit_diff(i32 %x) nounwind {
; RV32I-LABEL: and_icmps_const_not1bit_diff:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a1, a0, -44
; RV32I-NEXT:    snez a1, a1
; RV32I-NEXT:    addi a0, a0, -92
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_icmps_const_not1bit_diff:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    addi a1, a0, -44
; RV64I-NEXT:    snez a1, a1
; RV64I-NEXT:    addi a0, a0, -92
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
  %a = icmp ne i32 %x, 44
  %b = icmp ne i32 %x, 92
  %r = and i1 %a, %b
  ret i1 %r
}

define i1 @and_icmp_sge(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: and_icmp_sge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a0, a1
; RV32I-NEXT:    slt a1, a2, a3
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_icmp_sge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    slt a1, a2, a3
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %cmp1 = icmp sge i32 %a, %b
  %cmp2 = icmp sge i32 %c, %d
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @and_icmp_sle(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: and_icmp_sle:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a1, a0
; RV32I-NEXT:    slt a1, a3, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_icmp_sle:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    slt a1, a3, a2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %cmp1 = icmp sle i32 %a, %b
  %cmp2 = icmp sle i32 %c, %d
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @and_icmp_uge(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: and_icmp_uge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    sltu a1, a2, a3
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_icmp_uge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    sltu a1, a2, a3
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %cmp1 = icmp uge i32 %a, %b
  %cmp2 = icmp uge i32 %c, %d
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @and_icmp_ule(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: and_icmp_ule:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    sltu a1, a3, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_icmp_ule:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sltu a1, a3, a2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %cmp1 = icmp ule i32 %a, %b
  %cmp2 = icmp ule i32 %c, %d
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @or_icmp_sge(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: or_icmp_sge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a0, a1
; RV32I-NEXT:    slt a1, a2, a3
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_icmp_sge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    slt a1, a2, a3
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %cmp1 = icmp sge i32 %a, %b
  %cmp2 = icmp sge i32 %c, %d
  %and = or i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @or_icmp_sle(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: or_icmp_sle:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a1, a0
; RV32I-NEXT:    slt a1, a3, a2
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_icmp_sle:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    slt a1, a3, a2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %cmp1 = icmp sle i32 %a, %b
  %cmp2 = icmp sle i32 %c, %d
  %and = or i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @or_icmp_uge(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: or_icmp_uge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    sltu a1, a2, a3
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_icmp_uge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    sltu a1, a2, a3
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %cmp1 = icmp uge i32 %a, %b
  %cmp2 = icmp uge i32 %c, %d
  %and = or i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @or_icmp_ule(i32 signext %a, i32 signext %b, i32 signext %c, i32 signext %d) nounwind {
; RV32I-LABEL: or_icmp_ule:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    sltu a1, a3, a2
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_icmp_ule:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    sltu a1, a3, a2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %cmp1 = icmp ule i32 %a, %b
  %cmp2 = icmp ule i32 %c, %d
  %and = or i1 %cmp1, %cmp2
  ret i1 %and
}

declare void @bar(...)

define void @and_sge_eq(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_sge_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    blt a0, a1, .LBB13_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bne a2, a3, .LBB13_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB13_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_sge_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a0, a1, .LBB13_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bne a2, a3, .LBB13_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB13_3:
; RV64I-NEXT:    tail bar
  %5 = icmp sge i32 %0, %1
  %6 = icmp eq i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_sle_eq(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_sle_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    blt a1, a0, .LBB14_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bne a2, a3, .LBB14_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB14_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_sle_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a1, a0, .LBB14_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bne a2, a3, .LBB14_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB14_3:
; RV64I-NEXT:    tail bar
  %5 = icmp sle i32 %0, %1
  %6 = icmp eq i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_uge_eq(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_uge_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bltu a0, a1, .LBB15_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bne a2, a3, .LBB15_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB15_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_uge_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bltu a0, a1, .LBB15_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bne a2, a3, .LBB15_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB15_3:
; RV64I-NEXT:    tail bar
  %5 = icmp uge i32 %0, %1
  %6 = icmp eq i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_ule_eq(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_ule_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bltu a1, a0, .LBB16_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bne a2, a3, .LBB16_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB16_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_ule_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bltu a1, a0, .LBB16_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bne a2, a3, .LBB16_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB16_3:
; RV64I-NEXT:    tail bar
  %5 = icmp ule i32 %0, %1
  %6 = icmp eq i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_sge_ne(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_sge_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    blt a0, a1, .LBB17_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    beq a2, a3, .LBB17_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB17_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_sge_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a0, a1, .LBB17_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    beq a2, a3, .LBB17_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB17_3:
; RV64I-NEXT:    tail bar
  %5 = icmp sge i32 %0, %1
  %6 = icmp ne i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_sle_ne(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_sle_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    blt a1, a0, .LBB18_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    beq a2, a3, .LBB18_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB18_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_sle_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a1, a0, .LBB18_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    beq a2, a3, .LBB18_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB18_3:
; RV64I-NEXT:    tail bar
  %5 = icmp sle i32 %0, %1
  %6 = icmp ne i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_uge_ne(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_uge_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bltu a0, a1, .LBB19_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    beq a2, a3, .LBB19_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB19_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_uge_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bltu a0, a1, .LBB19_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    beq a2, a3, .LBB19_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB19_3:
; RV64I-NEXT:    tail bar
  %5 = icmp uge i32 %0, %1
  %6 = icmp ne i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_ule_ne(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_ule_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bltu a1, a0, .LBB20_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    beq a2, a3, .LBB20_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB20_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_ule_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bltu a1, a0, .LBB20_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    beq a2, a3, .LBB20_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB20_3:
; RV64I-NEXT:    tail bar
  %5 = icmp ule i32 %0, %1
  %6 = icmp ne i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @or_sge_eq(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: or_sge_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bge a0, a1, .LBB21_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    beq a2, a3, .LBB21_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB21_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_sge_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bge a0, a1, .LBB21_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    beq a2, a3, .LBB21_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB21_3:
; RV64I-NEXT:    ret
  %5 = icmp sge i32 %0, %1
  %6 = icmp eq i32 %2, %3
  %7 = or i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @or_sle_eq(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: or_sle_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bge a1, a0, .LBB22_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    beq a2, a3, .LBB22_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB22_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_sle_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bge a1, a0, .LBB22_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    beq a2, a3, .LBB22_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB22_3:
; RV64I-NEXT:    ret
  %5 = icmp sle i32 %0, %1
  %6 = icmp eq i32 %2, %3
  %7 = or i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @or_uge_eq(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: or_uge_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bgeu a0, a1, .LBB23_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    beq a2, a3, .LBB23_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB23_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_uge_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bgeu a0, a1, .LBB23_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    beq a2, a3, .LBB23_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB23_3:
; RV64I-NEXT:    ret
  %5 = icmp uge i32 %0, %1
  %6 = icmp eq i32 %2, %3
  %7 = or i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @or_ule_eq(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: or_ule_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bgeu a1, a0, .LBB24_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    beq a2, a3, .LBB24_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB24_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_ule_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bgeu a1, a0, .LBB24_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    beq a2, a3, .LBB24_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB24_3:
; RV64I-NEXT:    ret
  %5 = icmp ule i32 %0, %1
  %6 = icmp eq i32 %2, %3
  %7 = or i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @or_sge_ne(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: or_sge_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bge a0, a1, .LBB25_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bne a2, a3, .LBB25_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB25_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_sge_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bge a0, a1, .LBB25_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bne a2, a3, .LBB25_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB25_3:
; RV64I-NEXT:    ret
  %5 = icmp sge i32 %0, %1
  %6 = icmp ne i32 %2, %3
  %7 = or i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @or_sle_ne(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: or_sle_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bge a1, a0, .LBB26_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bne a2, a3, .LBB26_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB26_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_sle_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bge a1, a0, .LBB26_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bne a2, a3, .LBB26_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB26_3:
; RV64I-NEXT:    ret
  %5 = icmp sle i32 %0, %1
  %6 = icmp ne i32 %2, %3
  %7 = or i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @or_uge_ne(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: or_uge_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bgeu a0, a1, .LBB27_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bne a2, a3, .LBB27_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB27_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_uge_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bgeu a0, a1, .LBB27_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bne a2, a3, .LBB27_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB27_3:
; RV64I-NEXT:    ret
  %5 = icmp uge i32 %0, %1
  %6 = icmp ne i32 %2, %3
  %7 = or i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @or_ule_ne(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: or_ule_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bgeu a1, a0, .LBB28_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bne a2, a3, .LBB28_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB28_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_ule_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bgeu a1, a0, .LBB28_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bne a2, a3, .LBB28_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB28_3:
; RV64I-NEXT:    ret
  %5 = icmp ule i32 %0, %1
  %6 = icmp ne i32 %2, %3
  %7 = or i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_eq_sge(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_eq_sge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bne a0, a1, .LBB29_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    blt a2, a3, .LBB29_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB29_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_eq_sge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bne a0, a1, .LBB29_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    blt a2, a3, .LBB29_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB29_3:
; RV64I-NEXT:    tail bar
  %5 = icmp eq  i32 %0, %1
  %6 = icmp sge i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_eq_sle(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_eq_sle:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bne a0, a1, .LBB30_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    blt a3, a2, .LBB30_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB30_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_eq_sle:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bne a0, a1, .LBB30_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    blt a3, a2, .LBB30_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB30_3:
; RV64I-NEXT:    tail bar
  %5 = icmp eq  i32 %0, %1
  %6 = icmp sle i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_eq_uge(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_eq_uge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bne a0, a1, .LBB31_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bltu a2, a3, .LBB31_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB31_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_eq_uge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bne a0, a1, .LBB31_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bltu a2, a3, .LBB31_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB31_3:
; RV64I-NEXT:    tail bar
  %5 = icmp eq  i32 %0, %1
  %6 = icmp uge i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_eq_ule(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_eq_ule:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bne a0, a1, .LBB32_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bltu a3, a2, .LBB32_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB32_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_eq_ule:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bne a0, a1, .LBB32_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bltu a3, a2, .LBB32_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB32_3:
; RV64I-NEXT:    tail bar
  %5 = icmp eq  i32 %0, %1
  %6 = icmp ule i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_ne_sge(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_ne_sge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a0, a1, .LBB33_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    blt a2, a3, .LBB33_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB33_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_ne_sge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beq a0, a1, .LBB33_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    blt a2, a3, .LBB33_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB33_3:
; RV64I-NEXT:    tail bar
  %5 = icmp ne  i32 %0, %1
  %6 = icmp sge i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_ne_sle(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_ne_sle:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a0, a1, .LBB34_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    blt a3, a2, .LBB34_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB34_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_ne_sle:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beq a0, a1, .LBB34_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    blt a3, a2, .LBB34_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB34_3:
; RV64I-NEXT:    tail bar
  %5 = icmp ne  i32 %0, %1
  %6 = icmp sle i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_ne_uge(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_ne_uge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a0, a1, .LBB35_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bltu a2, a3, .LBB35_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB35_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_ne_uge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beq a0, a1, .LBB35_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bltu a2, a3, .LBB35_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB35_3:
; RV64I-NEXT:    tail bar
  %5 = icmp ne  i32 %0, %1
  %6 = icmp uge i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_ne_ule(i32 signext %0, i32 signext %1, i32 signext %2, i32 signext %3) {
; RV32I-LABEL: and_ne_ule:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a0, a1, .LBB36_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bltu a3, a2, .LBB36_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB36_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_ne_ule:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beq a0, a1, .LBB36_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bltu a3, a2, .LBB36_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB36_3:
; RV64I-NEXT:    tail bar
  %5 = icmp ne  i32 %0, %1
  %6 = icmp ule i32 %2, %3
  %7 = and i1 %5, %6
  br i1 %7, label %9, label %8

8:                                                ; preds = %4
  tail call void @bar()
  br label %9

9:                                                ; preds = %8, %4
  ret void
}

define void @and_sge_gt0(i32 signext %0, i32 signext %1, i32 signext %2) {
; RV32I-LABEL: and_sge_gt0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    blt a0, a1, .LBB37_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    blez a2, .LBB37_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB37_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_sge_gt0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a0, a1, .LBB37_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    blez a2, .LBB37_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB37_3:
; RV64I-NEXT:    tail bar
  %4 = icmp sge i32 %0, %1
  %5 = icmp sgt i32 %2, 0
  %6 = and i1 %4, %5
  br i1 %6, label %8, label %7

7:                                                ; preds = %4
  tail call void @bar()
  br label %8

8:                                                ; preds = %8, %4
  ret void
}

define void @and_sle_lt1(i32 signext %0, i32 signext %1, i32 signext %2) {
; RV32I-LABEL: and_sle_lt1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    blt a1, a0, .LBB38_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bgtz a2, .LBB38_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB38_3:
; RV32I-NEXT:    tail bar
;
; RV64I-LABEL: and_sle_lt1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a1, a0, .LBB38_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bgtz a2, .LBB38_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB38_3:
; RV64I-NEXT:    tail bar
  %4 = icmp sle i32 %0, %1
  %5 = icmp slt i32 %2, 1
  %6 = and i1 %4, %5
  br i1 %6, label %8, label %7

7:                                                ; preds = %4
  tail call void @bar()
  br label %8

8:                                                ; preds = %8, %4
  ret void
}

define void @or_uge_gt0(i32 signext %0, i32 signext %1, i32 signext %2) {
; RV32I-LABEL: or_uge_gt0:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bgeu a0, a1, .LBB39_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    bgtz a2, .LBB39_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB39_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_uge_gt0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bgeu a0, a1, .LBB39_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    bgtz a2, .LBB39_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB39_3:
; RV64I-NEXT:    ret
  %4 = icmp uge i32 %0, %1
  %5 = icmp sgt i32 %2, 0
  %6 = or i1 %4, %5
  br i1 %6, label %8, label %7

7:                                                ; preds = %4
  tail call void @bar()
  br label %8

8:                                                ; preds = %8, %4
  ret void
}

define void @or_ule_lt1(i32 signext %0, i32 signext %1, i32 signext %2) {
; RV32I-LABEL: or_ule_lt1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bgeu a1, a0, .LBB40_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    blez a2, .LBB40_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar
; RV32I-NEXT:  .LBB40_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: or_ule_lt1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bgeu a1, a0, .LBB40_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    blez a2, .LBB40_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar
; RV64I-NEXT:  .LBB40_3:
; RV64I-NEXT:    ret
  %4 = icmp ule i32 %0, %1
  %5 = icmp slt i32 %2, 1
  %6 = or i1 %4, %5
  br i1 %6, label %8, label %7

7:                                                ; preds = %4
  tail call void @bar()
  br label %8

8:                                                ; preds = %8, %4
  ret void
}
