// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/tauri-apps/gir-files)
// DO NOT EDIT

use glib::{
  prelude::*,
  signal::{connect_raw, SignalHandlerId},
  translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "WebKitURIRequest")]
    pub struct URIRequest(Object<ffi::WebKitURIRequest, ffi::WebKitURIRequestClass>);

    match fn {
        type_ => || ffi::webkit_uri_request_get_type(),
    }
}

impl URIRequest {
  pub const NONE: Option<&'static URIRequest> = None;

  #[doc(alias = "webkit_uri_request_new")]
  pub fn new(uri: &str) -> URIRequest {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::webkit_uri_request_new(uri.to_glib_none().0)) }
  }

  // rustdoc-stripper-ignore-next
  /// Creates a new builder-pattern struct instance to construct [`URIRequest`] objects.
  ///
  /// This method returns an instance of [`URIRequestBuilder`](crate::builders::URIRequestBuilder) which can be used to create [`URIRequest`] objects.
  pub fn builder() -> URIRequestBuilder {
    URIRequestBuilder::new()
  }
}

impl Default for URIRequest {
  fn default() -> Self {
    glib::object::Object::new::<Self>()
  }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`URIRequest`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct URIRequestBuilder {
  builder: glib::object::ObjectBuilder<'static, URIRequest>,
}

impl URIRequestBuilder {
  fn new() -> Self {
    Self {
      builder: glib::object::Object::builder(),
    }
  }

  pub fn uri(self, uri: impl Into<glib::GString>) -> Self {
    Self {
      builder: self.builder.property("uri", uri.into()),
    }
  }

  // rustdoc-stripper-ignore-next
  /// Build the [`URIRequest`].
  #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
  pub fn build(self) -> URIRequest {
    self.builder.build()
  }
}

mod sealed {
  pub trait Sealed {}
  impl<T: super::IsA<super::URIRequest>> Sealed for T {}
}

pub trait URIRequestExt: IsA<URIRequest> + sealed::Sealed + 'static {
  #[doc(alias = "webkit_uri_request_get_http_headers")]
  #[doc(alias = "get_http_headers")]
  fn http_headers(&self) -> Option<soup::MessageHeaders> {
    unsafe {
      from_glib_none(ffi::webkit_uri_request_get_http_headers(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_12")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_12")))]
  #[doc(alias = "webkit_uri_request_get_http_method")]
  #[doc(alias = "get_http_method")]
  fn http_method(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_uri_request_get_http_method(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_uri_request_get_uri")]
  #[doc(alias = "get_uri")]
  fn uri(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_uri_request_get_uri(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_uri_request_set_uri")]
  fn set_uri(&self, uri: &str) {
    unsafe {
      ffi::webkit_uri_request_set_uri(self.as_ref().to_glib_none().0, uri.to_glib_none().0);
    }
  }

  #[doc(alias = "uri")]
  fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_uri_trampoline<P: IsA<URIRequest>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitURIRequest,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(URIRequest::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::uri\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_uri_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }
}

impl<O: IsA<URIRequest>> URIRequestExt for O {}
