use crate::inc::inc::BigFloatInc;

// sin(s)
pub(crate) const SIN_VALUES1: [BigFloatInc; 1571] = [
    BigFloatInc {
        sign: 1,
        e: 0,
        n: 0,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    },
    BigFloatInc {
        sign: 1,
        e: -47,
        n: 44,
        m: [1473, 1513, 9700, 7100, 2539, 6468, 6666, 3416, 3333, 9983, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [2974, 9469, 4262, 3474, 6509, 793, 3333, 6933, 6666, 9986, 1999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [4119, 2094, 9556, 8124, 1482, 6607, 9995, 2024, 0, 9955, 2999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [9725, 2123, 9986, 2714, 3738, 1587, 6634, 1866, 3334, 9893, 3999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [3847, 8730, 5752, 1289, 6652, 3234, 3178, 2708, 6669, 9791, 4999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [1625, 2357, 3974, 5623, 628, 5717, 9444, 4799, 6, 9640, 5999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [6482, 6618, 3541, 4512, 8981, 6538, 5032, 3391, 3347, 9428, 6999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [3514, 2829, 3727, 6084, 5899, 3211, 9172, 9732, 6693, 9146, 7999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [8006, 7338, 5298, 9370, 1911, 9928, 509, 2074, 49, 8785, 8999],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [3854, 8964, 2903, 997, 8269, 4243, 6825, 6664, 3416, 8333, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7792, 4329, 5750, 8226, 4865, 8376, 4466, 875, 1680, 9778, 1099],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3453, 6259, 3766, 7100, 466, 5285, 2890, 7359, 20, 9712, 1199],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6310, 1299, 1857, 4133, 1041, 5933, 9216, 2742, 8364, 9633, 1299],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [595, 8028, 3769, 278, 9176, 124, 2418, 4851, 6711, 9542, 1399],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3664, 7188, 7626, 8796, 9651, 4362, 1099, 2809, 5063, 9437, 1499],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4440, 324, 3576, 8503, 6407, 8528, 3405, 7141, 3420, 9317, 1599],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2520, 3329, 8914, 5750, 5585, 2567, 6917, 9872, 1784, 9181, 1699],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1579, 9896, 1688, 9944, 5198, 3180, 8528, 4627, 157, 9028, 1799],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1301, 1498, 8855, 6811, 3469, 521, 4312, 6731, 8539, 8856, 1899],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9230, 7167, 5151, 2974, 9469, 4902, 9366, 3307, 6933, 8666, 1999],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1829, 6942, 3981, 4522, 1410, 3513, 7643, 3381, 5340, 8456, 2099],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7288, 9954, 1742, 1340, 9727, 7141, 1757, 7977, 3762, 8225, 2199],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4981, 9767, 2265, 7764, 3985, 6922, 2777, 218, 2203, 7972, 2299],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [215, 718, 8285, 8819, 4667, 1086, 9993, 5428, 663, 7696, 2399],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7476, 4003, 2217, 9734, 2964, 1739, 662, 1233, 9147, 7395, 2499],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6037, 6137, 8956, 4639, 3926, 1653, 9735, 7653, 7656, 7070, 2599],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8279, 3674, 8933, 8346, 600, 1086, 9554, 7214, 6195, 6719, 2699],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5464, 464, 365, 2751, 9210, 4622, 9527, 5038, 4767, 6341, 2799],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [802, 8514, 5439, 6832, 7898, 8050, 5778, 8948, 3375, 5935, 2899],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6183, 2319, 6180, 6261, 4192, 5263, 768, 9566, 2024, 5500, 2999],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3530, 3220, 1937, 5338, 9014, 5203, 2887, 413, 719, 5035, 3099],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3190, 4137, 1914, 325, 7887, 8847, 6021, 8011, 9462, 4538, 3199],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8762, 2981, 2840, 9160, 2866, 6231, 9087, 1981, 8261, 4010, 3299],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4083, 2736, 3953, 8021, 1746, 3529, 5534, 5144, 7119, 3449, 3399],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9562, 8950, 8858, 245, 4162, 187, 2817, 3619, 6043, 2854, 3499],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4214, 8948, 6638, 7631, 7439, 6115, 1834, 6925, 5038, 2224, 3599],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1515, 8826, 2869, 8148, 8326, 8945, 6334, 8080, 4111, 1558, 3699],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2814, 4675, 5018, 7524, 131, 1361, 2284, 3703, 3269, 855, 3799],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3608, 9756, 6079, 5021, 8316, 8503, 7200, 4109, 2518, 114, 3899],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1445, 5668, 5392, 5914, 1171, 5468, 9452, 3415, 1866, 9334, 3998],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2503, 1875, 6365, 4748, 5908, 4882, 7514, 9636, 1320, 8514, 4098],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8921, 19, 7491, 4282, 4301, 4593, 9189, 4785, 890, 7653, 4198],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3374, 3283, 5569, 5130, 5910, 5453, 787, 4976, 583, 6750, 4298],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5164, 6883, 8627, 432, 916, 9227, 6264, 518, 409, 5804, 4398],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8863, 1843, 728, 8394, 8693, 6616, 6320, 6023, 376, 4814, 4498],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8732, 739, 1774, 3155, 2459, 5425, 7450, 499, 496, 3779, 4598],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5571, 7663, 2726, 1211, 4607, 8856, 956, 7454, 777, 2698, 4698],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [61, 1930, 433, 6371, 1771, 3971, 1913, 4992, 1232, 1570, 4798],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4656, 7508, 6690, 1054, 3132, 303, 8084, 5917, 1871, 394, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [566, 8269, 3393, 5490, 84, 8650, 8794, 7832, 2706, 9169, 4997],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7718, 6901, 9774, 9051, 100, 46, 3758, 3237, 3750, 7894, 5097],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2118, 4939, 9045, 9534, 2393, 4934, 1846, 9629, 5014, 6568, 5197],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5780, 7684, 351, 6544, 7904, 2544, 9819, 9603, 6513, 5190, 5297],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [792, 3634, 8057, 4321, 1126, 495, 995, 955, 8261, 3759, 5397],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4948, 8343, 4204, 7220, 6378, 4624, 3874, 6773, 270, 2275, 5497],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7654, 308, 1755, 7574, 6339, 9077, 708, 5547, 2557, 735, 5597],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6698, 6625, 6139, 900, 5946, 6648, 6015, 1261, 5137, 9139, 5696],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [746, 2106, 1009, 7101, 163, 9405, 5037, 3499, 8025, 7486, 5796],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1923, 3424, 1088, 8588, 9632, 9602, 2148, 7540, 1238, 5776, 5896],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5614, 4533, 1039, 6983, 3785, 911, 9199, 4459, 4794, 4006, 5996],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6137, 9840, 4474, 9149, 6732, 9961, 3804, 1231, 8710, 2176, 6096],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [511, 5866, 2059, 792, 7012, 8239, 7579, 823, 3004, 286, 6196],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8797, 4105, 2329, 1613, 8187, 4337, 4303, 2302, 7695, 8333, 6295],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3686, 2364, 3770, 9996, 3284, 6585, 8031, 928, 2803, 6318, 6395],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9540, 821, 2199, 7354, 2150, 6076, 1143, 8260, 8347, 4238, 6495],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2032, 7375, 3963, 2533, 7000, 113, 2326, 2249, 4350, 2094, 6595],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [108, 8295, 3308, 4988, 7743, 6091, 4493, 7344, 831, 9884, 6694],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5402, 4239, 1872, 1730, 5048, 5834, 2644, 4589, 7814, 7606, 6794],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8589, 8966, 110, 7275, 5608, 414, 1650, 1722, 5321, 5261, 6894],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6949, 7541, 4959, 7887, 680, 5473, 3976, 3276, 3375, 2847, 6994],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7659, 5725, 5703, 1278, 5636, 7063, 7340, 679, 2001, 363, 7094],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9595, 6962, 1350, 499, 5088, 8043, 2294, 2354, 1223, 7808, 7193],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2849, 72, 8312, 6010, 5031, 5037, 9742, 3815, 1067, 5181, 7293],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4682, 6162, 7415, 2738, 437, 5997, 8383, 7774, 1559, 2481, 7393],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8720, 5562, 4822, 9250, 3830, 8382, 2086, 4234, 2727, 9707, 7492],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9087, 1361, 2839, 3990, 7586, 7992, 7189, 590, 4598, 6858, 7592],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4672, 7641, 4571, 8653, 9950, 8471, 9724, 1733, 7200, 3933, 7692],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3818, 2622, 1488, 1243, 2216, 1517, 2570, 146, 563, 932, 7792],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5473, 4656, 5911, 1033, 1942, 7819, 2524, 6002, 4716, 7852, 7891],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7378, 4710, 1979, 4497, 4731, 8763, 7306, 7268, 9691, 4693, 7991],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1442, 3, 9394, 5160, 4746, 8922, 2473, 9804, 5519, 1455, 8091],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2761, 9609, 5104, 1263, 1952, 9369, 8263, 7458, 2233, 8136, 8190],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2486, 4190, 9736, 2910, 1959, 1844, 6357, 2173, 9866, 4734, 8290],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6692, 6554, 8868, 5095, 2336, 3808, 6556, 4080, 8451, 1250, 8390],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2244, 1478, 5106, 4373, 7346, 4413, 3385, 1602, 8024, 7682, 8489],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7334, 9888, 6067, 5097, 1256, 1429, 2605, 1551, 8620, 4029, 8589],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4096, 3969, 6954, 5825, 8662, 9150, 7644, 9229, 275, 291, 8689],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [297, 5895, 5123, 7726, 8654, 7338, 5949, 8529, 3028, 6465, 8788],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [414, 2206, 9145, 4476, 8144, 1211, 5241, 2031, 6917, 2551, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4956, 3501, 7103, 7136, 8260, 2539, 9691, 1104, 1980, 8549, 8987],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7886, 5785, 9563, 7751, 6413, 1872, 6009, 6007, 8257, 4456, 9087],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2119, 9954, 2692, 1873, 5411, 1942, 9438, 5984, 5790, 273, 9187],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8724, 6679, 7663, 2697, 9901, 2281, 9663, 9369, 4620, 5998, 9286],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9451, 3903, 4855, 8062, 9405, 5096, 6627, 3682, 4791, 1630, 9386],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5731, 2057, 6716, 5943, 6291, 2437, 6257, 5729, 6345, 7168, 9485],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9136, 6160, 2695, 4359, 6217, 4709, 6093, 1703, 9328, 2611, 9585],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8463, 522, 4733, 7539, 7879, 568, 830, 7283, 3784, 7959, 9684],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9380, 4926, 3703, 1829, 8266, 8244, 7756, 7731, 9761, 3209, 9784],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3612, 1798, 7377, 1924, 9112, 8338, 2106, 7998, 7306, 8362, 9883],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5388, 8991, 269, 622, 9841, 8141, 2306, 2815, 6468, 3416, 9983],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9896, 8531, 671, 2319, 1195, 9752, 9512, 5679, 729, 2837, 1008],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4726, 4386, 3213, 8065, 2960, 8642, 1074, 9455, 3983, 2322, 1018],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9025, 2452, 8523, 458, 2105, 404, 2769, 1075, 5415, 1797, 1028],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9366, 5008, 6772, 6945, 7546, 8970, 9768, 3026, 4028, 1262, 1038],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9577, 9163, 1916, 2678, 6000, 6553, 9043, 8824, 8828, 716, 1048],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2325, 6694, 7508, 1871, 6180, 2090, 8823, 3021, 8822, 160, 1058],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2952, 9065, 2789, 1646, 7024, 5880, 8052, 1218, 3014, 9594, 1067],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6644, 1539, 5446, 3158, 4490, 9411, 5835, 74, 410, 9017, 1077],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7909, 1918, 1291, 5544, 2530, 9385, 869, 7316, 15, 8429, 1087],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4463, 516, 4710, 8345, 4900, 4949, 866, 1748, 837, 7830, 1097],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2229, 2759, 1102, 7693, 5536, 7136, 1964, 3263, 1880, 7220, 1107],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2494, 5373, 7047, 520, 6301, 9519, 8131, 2851, 2151, 6599, 1117],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6797, 189, 7670, 9519, 1996, 9090, 553, 2612, 656, 5967, 1127],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [780, 3738, 4922, 9366, 3639, 6363, 7013, 5759, 6401, 5323, 1137],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5482, 3445, 5466, 1969, 2087, 3717, 1259, 6638, 8393, 4668, 1147],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [878, 863, 1723, 5083, 5242, 972, 2361, 728, 5639, 4002, 1157],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3567, 9443, 2735, 4593, 3181, 7219, 4055, 4658, 7144, 3324, 1167],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1186, 2759, 9972, 6103, 6679, 7896, 4080, 6214, 1916, 2635, 1177],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9887, 6788, 3335, 6117, 5773, 6132, 3496, 4349, 8962, 1933, 1187],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9756, 600, 9719, 7096, 6142, 7350, 5996, 9193, 7288, 1220, 1197],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5075, 3660, 4662, 4028, 2265, 6150, 7206, 2064, 5903, 495, 1207],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1200, 3093, 353, 2719, 7483, 4467, 3970, 5477, 3812, 9758, 1216],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1100, 7514, 2598, 2010, 2291, 25, 3626, 3153, 24, 9009, 1226],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2854, 2603, 6779, 3293, 3370, 4074, 3267, 31, 3546, 8247, 1236],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3490, 5878, 8467, 1210, 7087, 7442, 8995, 2276, 3385, 7473, 1246],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3779, 5049, 7638, 9173, 2398, 3890, 5157, 7292, 8549, 6686, 1256],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2236, 588, 4525, 2346, 9333, 9782, 3569, 3727, 8047, 5887, 1266],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4454, 8331, 7494, 8971, 444, 9092, 2735, 1487, 886, 5076, 1276],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4691, 7833, 5146, 8396, 3901, 2726, 7043, 1744, 6074, 4251, 1286],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6726, 9983, 1489, 831, 8107, 1205, 5954, 6948, 2619, 3414, 1296],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1457, 4935, 8893, 9762, 9030, 9683, 3179, 834, 9531, 2563, 1306],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2301, 411, 1832, 3014, 2704, 4328, 5844, 8433, 5816, 1700, 1316],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6292, 3881, 7646, 2684, 6609, 9066, 3632, 6084, 485, 824, 1326],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1602, 5308, 9944, 7625, 5001, 1707, 7929, 1440, 2546, 9934, 1335],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [412, 9265, 6259, 4655, 4504, 8443, 938, 3483, 1007, 9031, 1345],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9350, 388, 3527, 6417, 7626, 5746, 4799, 2527, 4878, 8114, 1355],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [333, 4800, 1217, 4609, 3192, 8665, 677, 236, 3168, 7184, 1365],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9523, 504, 9993, 7233, 3995, 4528, 7852, 9626, 4885, 6240, 1375],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3096, 8976, 9875, 7553, 3344, 1071, 2784, 5083, 9041, 5282, 1385],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2985, 5553, 1620, 537, 3517, 7988, 8171, 2364, 4644, 4311, 1395],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4941, 7138, 2616, 9768, 508, 923, 1995, 8616, 703, 3326, 1405],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8943, 4015, 7683, 4028, 841, 6906, 6542, 2377, 6230, 2326, 1415],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1301, 5008, 7972, 8030, 7567, 249, 7427, 3594, 233, 1313, 1425],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7645, 3913, 9329, 6095, 4026, 7909, 2584, 3628, 1723, 285, 1435],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6219, 9653, 5317, 891, 5285, 3321, 1263, 5264, 9710, 9242, 1444],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6707, 786, 9173, 1658, 8637, 7728, 2992, 2723, 3205, 8186, 1454],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4938, 4958, 1672, 7676, 5942, 8002, 6543, 1671, 1218, 7115, 1464],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3016, 4710, 5809, 2978, 2031, 9972, 8870, 9229, 2759, 6029, 1474],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4586, 4984, 693, 7598, 4836, 6273, 4041, 3983, 6841, 4928, 1484],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5587, 918, 1818, 8764, 4386, 7725, 2149, 5992, 2473, 3813, 1494],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3162, 9098, 7228, 2619, 9233, 7246, 8215, 6800, 8667, 2682, 1504],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [531, 438, 2732, 3028, 384, 5324, 1070, 9448, 4434, 1537, 1514],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1761, 5963, 6640, 8974, 4286, 6039, 2225, 8477, 8786, 376, 1524],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8798, 5731, 7218, 5867, 7897, 2674, 4727, 9945, 734, 9201, 1533],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2964, 5251, 4506, 8732, 387, 1898, 1996, 1434, 9291, 8009, 1543],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5532, 5356, 2176, 6811, 7542, 5546, 6651, 2058, 3467, 6803, 1553],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2322, 7516, 3049, 9465, 6434, 9019, 9319, 2477, 2275, 5581, 1563],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7069, 9851, 1513, 2464, 9493, 5287, 7428, 4904, 4727, 4343, 1573],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5374, 342, 3910, 1754, 8623, 3538, 3983, 3115, 9836, 3089, 1583],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8820, 2385, 9633, 8598, 1596, 1463, 6331, 2459, 6614, 1820, 1593],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4151, 4397, 5853, 5552, 4488, 199, 4906, 9870, 4073, 535, 1603],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2723, 2013, 1036, 7078, 5507, 947, 1960, 3874, 1228, 9234, 1612],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3806, 4985, 9507, 1692, 7164, 2263, 278, 4600, 7090, 7916, 1622],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5388, 2717, 2812, 4350, 5293, 7050, 1876, 3790, 673, 6583, 1632],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4595, 1164, 4256, 8289, 5072, 8254, 6685, 4809, 990, 5233, 1642],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8806, 6637, 483, 4819, 5772, 2284, 1216, 2656, 7055, 3866, 1652],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5610, 6192, 6944, 7407, 7607, 9164, 7208, 3969, 7881, 2483, 1662],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7524, 8705, 349, 3034, 5692, 8434, 268, 7043, 2482, 1084, 1672],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1279, 7890, 7459, 8976, 7733, 9810, 8481, 1830, 9873, 9667, 1681],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6300, 5666, 1522, 7085, 3766, 7624, 1015, 9960, 9066, 8234, 1691],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2101, 5588, 153, 50, 7877, 8046, 6702, 4739, 9078, 6784, 1701],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7697, 3661, 5192, 5272, 3550, 8119, 2607, 1170, 8922, 5317, 1711],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6521, 235, 8882, 1591, 5952, 5600, 2577, 5954, 7612, 3833, 1721],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8712, 5505, 3387, 2361, 6140, 8645, 5773, 7505, 4164, 2332, 1731],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1481, 9860, 3026, 5141, 3919, 4332, 5189, 5959, 7593, 813, 1741],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [127, 943, 459, 3591, 7748, 5049, 6146, 3182, 6914, 9277, 1750],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6259, 911, 8305, 967, 1837, 1762, 4778, 2782, 1142, 7724, 1760],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7111, 7201, 4138, 6969, 2305, 3166, 6492, 117, 9293, 6152, 1770],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7469, 5715, 6336, 463, 6010, 9754, 4417, 2307, 382, 4564, 1780],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8850, 6030, 6830, 9920, 7396, 1802, 7834, 8241, 3425, 2957, 1790],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3205, 6962, 9254, 1081, 509, 294, 581, 8591, 7439, 1332, 1800],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3006, 5931, 1249, 7546, 5030, 9799, 9452, 5815, 1440, 9690, 1809],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4252, 2520, 724, 4512, 7047, 2327, 2574, 4177, 4444, 8029, 1819],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4103, 9690, 9620, 8867, 6980, 1161, 7756, 9745, 5467, 6350, 1829],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7546, 393, 6167, 144, 8962, 3698, 836, 412, 3528, 4653, 1839],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4137, 227, 7704, 6533, 7714, 2310, 4000, 5896, 7641, 2937, 1849],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4130, 58, 9970, 8195, 841, 2239, 4083, 7758, 6825, 1203, 1859],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1066, 4047, 3190, 6427, 6236, 5545, 855, 9407, 97, 9451, 1868],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1960, 3890, 7545, 1900, 6179, 132, 5288, 6110, 6475, 7679, 1878],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8214, 4840, 6580, 8130, 1529, 2851, 7799, 5005, 4976, 5889, 1888],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1446, 130, 1982, 7505, 1288, 5715, 6484, 5108, 4618, 4080, 1898],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2422, 8220, 938, 6677, 4660, 4238, 5325, 7323, 4419, 2252, 1908],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5612, 7539, 1161, 5776, 4641, 6913, 2380, 4453, 3398, 405, 1918],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7225, 8807, 655, 1790, 4034, 4848, 7958, 1208, 573, 8539, 1927],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2395, 7583, 678, 535, 6696, 582, 2769, 4219, 4962, 6653, 1937],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5625, 2010, 1130, 3882, 8733, 5097, 6058, 2041, 5585, 4748, 1947],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6683, 8452, 7082, 9305, 6270, 2043, 3723, 5170, 1460, 2824, 1957],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3786, 1037, 1474, 7353, 8356, 8196, 6404, 6047, 1607, 880, 1967],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2605, 7017, 9353, 9279, 5497, 9173, 7565, 9072, 5045, 8916, 1976],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [673, 3702, 9750, 1838, 6271, 9412, 1545, 612, 795, 6933, 1986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8148, 524, 7439, 9028, 6408, 5450, 1597, 9009, 7874, 4929, 1996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6906, 9948, 2927, 1479, 6729, 1507, 7903, 4593, 5305, 2906, 2006],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5980, 6215, 8134, 3064, 8254, 6403, 5571, 9692, 2106, 863, 2016],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4955, 551, 9791, 1257, 4850, 826, 2615, 8638, 7299, 8799, 2025],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6397, 2898, 3945, 2664, 5713, 3968, 7905, 7779, 9904, 6715, 2035],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4973, 1393, 3353, 8075, 2041, 8558, 9110, 5491, 8942, 4611, 2045],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3666, 1834, 4460, 2233, 4239, 3300, 612, 2185, 3434, 2487, 2055],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5971, 4803, 443, 2299, 8028, 1751, 1399, 315, 2401, 342, 2065],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8421, 8796, 8831, 5713, 9886, 6648, 2944, 4393, 4864, 8176, 2074],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1700, 2915, 2984, 2764, 4262, 8712, 7060, 995, 9846, 5989, 2084],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9472, 2057, 1631, 1626, 7081, 8946, 3732, 8773, 6367, 3782, 2094],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1925, 3237, 4251, 4009, 2124, 3459, 8932, 8461, 3451, 1554, 2104],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [244, 254, 5759, 7689, 8928, 9818, 2409, 2891, 120, 9305, 2113],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7267, 8750, 4337, 8196, 2946, 3977, 5467, 6995, 5395, 7034, 2123],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9750, 6447, 2810, 5706, 798, 6774, 8707, 7822, 8300, 4742, 2133],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8726, 6804, 7249, 4730, 5550, 9049, 9764, 4544, 7858, 2429, 2143],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8559, 3841, 6187, 3493, 9071, 4386, 1012, 8467, 3091, 95, 2153],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8358, 1822, 8392, 6914, 638, 8507, 7249, 3037, 3024, 7739, 2162],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [831, 3334, 4360, 1855, 3102, 4339, 3368, 3858, 6679, 5361, 2172],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2573, 9629, 3090, 5701, 54, 1791, 1995, 8693, 3080, 2962, 2182],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [751, 5847, 7036, 9450, 9612, 1239, 1115, 7479, 1252, 541, 2192],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5694, 2216, 9053, 4202, 2576, 9773, 1671, 2335, 219, 8098, 2201],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6256, 7615, 9435, 5299, 4898, 9196, 5146, 7572, 9004, 5632, 2211],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9187, 8579, 1461, 1328, 6595, 4837, 1115, 9704, 6633, 3145, 2221],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [73, 9750, 2051, 5720, 1400, 4170, 4782, 7454, 2131, 636, 2231],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9771, 7594, 978, 6789, 3686, 4279, 4494, 1769, 4523, 8104, 2240],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9202, 9176, 7344, 7650, 1370, 7198, 9230, 5825, 2833, 5550, 2250],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [983, 9353, 4638, 630, 5760, 2135, 6071, 5041, 6088, 2973, 2260],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [983, 9511, 3440, 1377, 1511, 3625, 7642, 7084, 3313, 374, 2270],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9232, 6004, 680, 6007, 2123, 4617, 9540, 1883, 3535, 7752, 2279],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2215, 7395, 2163, 137, 8638, 3541, 7732, 1637, 5779, 5107, 2289],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1259, 2304, 5830, 1644, 1468, 4368, 5933, 824, 9072, 2439, 2299],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3699, 7755, 850, 9341, 7567, 8685, 2962, 6212, 2440, 9749, 2308],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1716, 4796, 5213, 7509, 7412, 8835, 75, 6868, 4911, 7035, 2318],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3886, 9703, 3912, 1340, 8565, 1116, 8273, 4167, 5512, 4298, 2328],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8134, 5358, 2285, 743, 4893, 8094, 5586, 1806, 3270, 1538, 2338],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5054, 5404, 4508, 9747, 2818, 9039, 4343, 5807, 7212, 8754, 2347],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3977, 9596, 4903, 5735, 8295, 7522, 8405, 4531, 6367, 5947, 2357],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [929, 9780, 7583, 7041, 533, 5198, 384, 8689, 9762, 3116, 2367],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8242, 3231, 5308, 8981, 844, 792, 8836, 1345, 6427, 262, 2377],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5302, 881, 7373, 7120, 7309, 3339, 5429, 7936, 5388, 7384, 2386],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [385, 7670, 4131, 2537, 8340, 8685, 2091, 6272, 5676, 4482, 2396],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1215, 7207, 6601, 6934, 572, 8285, 8131, 6550, 6319, 1556, 2406],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4379, 2280, 6802, 5719, 8902, 9327, 7335, 1366, 6347, 8606, 2415],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2504, 1343, 301, 4540, 8862, 5221, 5043, 5720, 4788, 5632, 2425],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9114, 1421, 8242, 9242, 3937, 5457, 5196, 7028, 673, 2634, 2435],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1829, 2674, 2239, 771, 2824, 3887, 7365, 5132, 3032, 9611, 2444],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8659, 4435, 1343, 5111, 4040, 4450, 3750, 2310, 895, 6564, 2454],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1102, 7359, 4222, 4025, 7748, 3368, 6159, 3283, 3292, 3492, 2464],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9098, 8933, 9195, 4938, 7048, 6848, 2959, 5229, 9254, 395, 2474],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6202, 7902, 6292, 7940, 3483, 3316, 6007, 7788, 7812, 7274, 2483],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2824, 6714, 4588, 4425, 3925, 9218, 7549, 3076, 7998, 4128, 2493],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9026, 4834, 9206, 5381, 8484, 7418, 7105, 5692, 8842, 957, 2503],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5307, 1225, 9168, 7719, 1566, 7223, 8317, 2728, 9377, 7761, 2512],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2874, 3060, 2297, 4299, 670, 5061, 5782, 3780, 8634, 4540, 2522],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1823, 3338, 8261, 7439, 21, 4860, 1854, 956, 5646, 1294, 2532],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5746, 604, 6245, 6644, 8644, 7140, 3424, 8886, 9444, 8022, 2541],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9882, 4794, 9368, 9018, 4974, 5868, 8674, 4733, 9063, 4725, 2551],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9189, 9098, 2511, 5403, 2650, 2089, 3804, 8203, 3534, 1403, 2561],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9421, 5678, 1454, 6522, 4643, 3388, 9735, 1550, 1892, 8055, 2570],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4436, 4669, 5950, 1466, 5439, 8200, 8788, 9593, 3168, 4681, 2580],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2747, 9884, 3379, 5544, 3518, 4005, 1336, 9720, 6398, 1281, 2590],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [722, 9556, 7778, 5927, 8967, 8443, 2426, 1898, 616, 7856, 2599],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6624, 6943, 5245, 1575, 3597, 2387, 8386, 8686, 4854, 4404, 2609],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1445, 9330, 3879, 8576, 3547, 3993, 3392, 5244, 8149, 926, 2619],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4176, 7736, 6468, 3337, 6938, 2783, 6023, 9338, 9534, 7422, 2628],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3170, 6508, 8091, 3886, 1717, 2778, 5779, 1356, 8046, 3892, 2638],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2353, 7277, 8689, 3951, 1489, 3719, 9579, 4313, 2718, 336, 2648],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8386, 6282, 1491, 5403, 9701, 9421, 8230, 3864, 2587, 6753, 2657],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [500, 6092, 97, 2054, 5210, 2286, 2873, 8311, 6688, 3143, 2667],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8086, 1150, 7124, 1701, 4882, 3005, 1394, 8613, 4058, 9507, 2676],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1018, 3183, 1761, 3617, 1534, 4505, 4821, 8397, 3733, 5844, 2686],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5648, 4681, 7594, 5436, 8173, 9154, 3684, 3968, 4750, 2154, 2696],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [417, 2397, 9818, 6543, 2164, 8281, 4354, 4316, 6145, 8437, 2705],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3961, 4575, 5800, 4527, 5633, 3024, 5351, 1128, 6956, 4693, 2715],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3528, 6083, 7132, 7137, 1095, 5573, 3627, 8797, 6219, 922, 2725],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3203, 1193, 6181, 4307, 4001, 9813, 825, 4431, 2974, 7124, 2734],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9036, 335, 6104, 3236, 6588, 433, 9507, 7862, 6257, 3298, 2744],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1454, 1944, 9738, 4214, 154, 9518, 9350, 1660, 5108, 9445, 2753],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3254, 5367, 8145, 5784, 5584, 9669, 3331, 1137, 8564, 5564, 2763],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6430, 4597, 1424, 4946, 4700, 2700, 3865, 4358, 5664, 1656, 2773],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [415, 3940, 9172, 1406, 7748, 2927, 8926, 2153, 5448, 7720, 2782],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6895, 7044, 1295, 4312, 5090, 4113, 8142, 8126, 6954, 3756, 2792],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6022, 6509, 6308, 5442, 3936, 9088, 8856, 8662, 9223, 9764, 2801],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4272, 7213, 7488, 4521, 3712, 1098, 2165, 2940, 1295, 5745, 2811],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3455, 8154, 9944, 9978, 6459, 5913, 8922, 2938, 2209, 1697, 2821],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3839, 3955, 5530, 2267, 1444, 3740, 5725, 3450, 1006, 7621, 2830],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1195, 3843, 8358, 6587, 5950, 9973, 861, 2088, 6727, 3516, 2840],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [484, 7491, 1250, 7605, 7065, 3836, 237, 9295, 8412, 9383, 2849],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3092, 299, 1626, 437, 2055, 3940, 3268, 8355, 5104, 5222, 2859],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4086, 6912, 1975, 9799, 7783, 9808, 8750, 5402, 5844, 1032, 2869],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4966, 125, 2129, 2701, 2467, 8413, 698, 9431, 9673, 6813, 2878],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8018, 2313, 3921, 9466, 5881, 4750, 4153, 2302, 5635, 2566, 2888],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3972, 942, 8667, 3052, 7039, 5513, 965, 8758, 2770, 8290, 2897],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9567, 7514, 8049, 7683, 1179, 4893, 5547, 6427, 123, 3985, 2907],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5778, 8437, 2752, 4595, 833, 1553, 597, 5838, 6736, 9650, 2916],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8161, 6509, 2523, 5268, 8577, 5824, 2792, 424, 1653, 5287, 2926],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8786, 7656, 7531, 791, 2019, 6160, 8457, 6537, 3916, 894, 2936],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1752, 1264, 4098, 9979, 4439, 3888, 9198, 3456, 2571, 6472, 2945],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3211, 6778, 7373, 8502, 7456, 5320, 7510, 3395, 6661, 2020, 2955],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2355, 245, 7649, 6581, 4975, 245, 2357, 1514, 5231, 7539, 2964],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [709, 4669, 3023, 3658, 657, 5859, 4716, 5927, 7325, 3028, 2974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5175, 9279, 5544, 4939, 4055, 5176, 3102, 7715, 1989, 8488, 2983],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2098, 8991, 6086, 6710, 3542, 8966, 9051, 931, 8269, 3917, 2993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2360, 5692, 9634, 4843, 7107, 256, 2585, 2615, 5209, 9317, 3002],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1117, 4792, 834, 3953, 5077, 454, 7635, 2796, 1856, 4687, 3012],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [739, 2059, 2190, 3115, 1807, 6127, 7447, 4510, 7256, 26, 3022],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5404, 9605, 5775, 7996, 6366, 5490, 9950, 3803, 456, 5336, 3031],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6346, 5403, 4451, 8520, 5261, 3650, 3093, 9745, 502, 615, 3041],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9020, 7428, 2, 5896, 3239, 5643, 156, 4435, 6443, 5863, 3050],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4028, 3976, 2154, 2842, 1246, 6324, 5030, 3014, 7325, 1081, 3060],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8334, 4455, 1808, 6167, 3640, 6148, 7464, 3675, 2196, 6269, 3069],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7937, 7709, 993, 1468, 9805, 1894, 8284, 7670, 104, 1426, 3079],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8640, 7373, 6771, 5570, 8349, 1378, 4579, 9321, 98, 6552, 3088],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4061, 915, 1663, 3398, 5159, 1200, 4860, 6028, 1227, 1647, 3098],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7754, 3851, 3037, 2219, 9613, 6581, 4184, 8281, 2539, 6711, 3107],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9499, 7614, 1372, 7640, 6371, 2336, 9252, 9667, 3084, 1744, 3117],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3914, 7280, 4437, 2246, 3228, 4023, 3468, 6883, 1912, 6746, 3126],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1946, 9999, 2401, 9440, 8610, 8332, 1977, 9740, 8072, 1716, 3136],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8820, 3042, 7834, 1714, 5434, 1757, 6666, 1177, 616, 6656, 3145],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [281, 2059, 3724, 4346, 1111, 6593, 1130, 7271, 8592, 1563, 3155],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2206, 2311, 355, 2217, 6672, 3323, 5619, 7241, 1053, 6440, 3164],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3410, 5022, 5390, 9188, 1058, 8440, 1938, 3465, 7050, 1284, 3174],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7800, 7081, 7292, 6093, 9826, 6742, 8330, 1482, 5634, 6097, 3183],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5305, 1019, 5621, 4964, 623, 7181, 4315, 9, 5857, 878, 3193],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8393, 8221, 7313, 3545, 994, 1277, 5507, 943, 6771, 5627, 3202],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3150, 9172, 9309, 5416, 7223, 3192, 8391, 9376, 7428, 344, 3212],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1334, 2901, 7379, 7133, 6117, 484, 5077, 3603, 6883, 5029, 3221],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4116, 5383, 449, 4665, 4821, 4604, 8012, 5129, 4187, 9682, 3230],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8297, 6817, 9737, 7021, 6961, 195, 4670, 8683, 8394, 4302, 3240],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8439, 9104, 2355, 5307, 6628, 2239, 2199, 2223, 8559, 8890, 3249],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4211, 4294, 8560, 432, 4922, 105, 2047, 6948, 3734, 3446, 3259],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5934, 659, 8301, 2425, 7025, 7556, 4545, 7307, 2975, 7969, 3268],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6360, 8478, 3109, 8533, 1003, 7769, 3468, 1009, 5337, 2459, 3278],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5492, 3641, 9596, 6218, 2783, 2414, 553, 9031, 9873, 6916, 3287],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3051, 6104, 5907, 577, 5015, 3863, 9990, 5627, 5641, 1341, 3297],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7041, 8717, 6525, 3653, 804, 9567, 2882, 8343, 1695, 5733, 3306],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9304, 4488, 6840, 5597, 6567, 7664, 1669, 8017, 7092, 91, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5558, 2305, 9213, 4500, 1552, 2882, 4517, 8796, 888, 4417, 3325],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9471, 2234, 7995, 3078, 4870, 1771, 9678, 8143, 2140, 8709, 3334],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1851, 8924, 2427, 6096, 4185, 6349, 9816, 6847, 9905, 2967, 3344],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4708, 3427, 2922, 2508, 3528, 5192, 6300, 9031, 3240, 7193, 3353],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3245, 2190, 6250, 695, 1018, 1044, 3460, 2162, 1204, 1385, 3363],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3928, 6599, 6158, 3872, 626, 3994, 2813, 7061, 2853, 5543, 3372],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4742, 7931, 4350, 5702, 5443, 9283, 7257, 7912, 7247, 9667, 3381],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8742, 5299, 8223, 3335, 3275, 8798, 5228, 2273, 3445, 3758, 3391],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3621, 365, 854, 6464, 8753, 5305, 4823, 1082, 505, 7815, 3400],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1000, 5042, 9161, 6508, 9520, 8495, 7891, 8669, 7486, 1837, 3410],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6433, 4262, 686, 9728, 7425, 1883, 4093, 2766, 3450, 5826, 3419],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1350, 9707, 9828, 1762, 9069, 9634, 4918, 4513, 7455, 9780, 3428],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7724, 7828, 1533, 8958, 3419, 2372, 7681, 8471, 8562, 3700, 3438],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4359, 6432, 4222, 3608, 7658, 1024, 9467, 2630, 5833, 7586, 3447],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [909, 6132, 3240, 6105, 5798, 7777, 1058, 8419, 8327, 1437, 3457],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5214, 5015, 9237, 6722, 8085, 3186, 819, 712, 5108, 5254, 3466],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3143, 136, 9857, 3472, 2596, 8517, 8543, 7842, 5235, 9036, 3475],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8162, 9379, 4013, 34, 3921, 2366, 9276, 1610, 7773, 2783, 3485],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2548, 4590, 1129, 9188, 7260, 635, 7091, 7291, 1782, 6496, 3494],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5656, 9257, 7251, 2431, 9742, 8911, 8840, 3645, 6327, 173, 3504],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9770, 7537, 9362, 5472, 4223, 6320, 7868, 2928, 470, 3816, 3513],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [434, 3718, 764, 2073, 4359, 9913, 7684, 899, 3275, 7423, 3522],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [154, 5502, 5741, 5196, 3175, 8657, 5610, 6831, 3805, 995, 3532],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5018, 2545, 1214, 4584, 920, 6081, 6384, 3519, 1126, 4532, 3541],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [225, 7571, 6457, 3671, 1461, 651, 5734, 7291, 4301, 8033, 3550],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4940, 1042, 7816, 6188, 27, 2936, 3913, 8016, 2396, 1499, 3560],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9807, 880, 1404, 3754, 8627, 8625, 9203, 9113, 4476, 4929, 3569],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8373, 8006, 9870, 304, 9009, 6471, 1380, 7564, 9607, 8323, 3578],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [90, 4858, 5239, 7220, 6588, 210, 5142, 3916, 6855, 1682, 3588],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2182, 5597, 3563, 4485, 2325, 3539, 3504, 2299, 5286, 5005, 3597],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4884, 5041, 2632, 8157, 3094, 7207, 1160, 429, 3967, 8292, 3606],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4515, 6968, 4274, 2715, 4691, 7292, 7803, 9619, 1964, 1543, 3616],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2560, 470, 54, 8536, 5176, 3725, 1412, 4792, 8347, 4757, 3625],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1567, 8664, 4526, 9735, 9891, 8132, 1502, 4483, 2182, 7936, 3634],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1225, 8275, 3964, 5902, 3050, 64, 2343, 855, 2538, 1078, 3644],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2121, 3643, 9876, 2769, 4458, 671, 6131, 9705, 8482, 4183, 3653],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1301, 1764, 4157, 1626, 3517, 2909, 6137, 475, 9086, 7252, 3662],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4215, 1772, 3723, 5185, 6316, 7325, 9809, 6259, 3416, 285, 3672],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8616, 715, 3547, 8704, 5251, 2508, 1843, 3816, 544, 3281, 3681],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7591, 1239, 3722, 9310, 4268, 9262, 7211, 3573, 9539, 6239, 3690],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5215, 9038, 3171, 3733, 6491, 7580, 4164, 9643, 9471, 9161, 3699],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2318, 4874, 3640, 4920, 4663, 5485, 7184, 9826, 9412, 2046, 3709],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9755, 603, 5431, 1273, 8520, 8805, 9909, 5624, 8433, 4894, 3718],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7002, 4427, 2879, 8480, 6886, 963, 8020, 2248, 5605, 7705, 3727],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8379, 5008, 3690, 3056, 6013, 1839, 2083, 8627, 9999, 478, 3737],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6934, 2577, 2038, 8755, 9351, 4789, 366, 7417, 689, 3215, 3746],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [677, 4454, 9814, 1879, 7712, 886, 1610, 5012, 6747, 5913, 3755],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7797, 4685, 1756, 9228, 2449, 9453, 7762, 1552, 7246, 8574, 3764],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8584, 3690, 5617, 2864, 8085, 3966, 6681, 934, 1259, 1198, 3774],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3057, 7570, 4352, 9121, 4492, 2403, 4790, 818, 7860, 3783, 3783],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5403, 8179, 8860, 5125, 2560, 1096, 9706, 2638, 6123, 6331, 3792],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2955, 4307, 1562, 4716, 978, 1182, 2823, 1614, 5123, 8841, 3801],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [667, 5507, 6563, 6794, 5596, 6710, 1860, 6755, 3934, 1313, 3811],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1625, 5018, 3889, 2936, 6568, 3489, 3373, 874, 1633, 3747, 3820],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8080, 9998, 4982, 7390, 2292, 7743, 5222, 595, 7294, 6142, 3829],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6072, 4391, 5051, 1441, 2972, 3655, 9011, 6362, 9993, 8499, 3838],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8856, 9584, 4745, 5397, 406, 8877, 2477, 2450, 8808, 818, 3848],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6250, 870, 7942, 5206, 4473, 7072, 1854, 6970, 2814, 3099, 3857],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3645, 406, 2032, 6835, 567, 6579, 4186, 1883, 1090, 5341, 3866],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3003, 7287, 9170, 21, 6114, 4260, 9611, 3007, 2712, 7544, 3875],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4678, 4025, 7456, 3839, 8117, 3628, 3601, 28, 6759, 9708, 3884],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6018, 5930, 5264, 9570, 7567, 6311, 9166, 6504, 2308, 1834, 3894],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1274, 7271, 4159, 1735, 388, 5947, 9019, 9882, 8439, 3920, 3903],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8682, 3163, 9329, 5650, 8483, 3577, 7700, 1501, 4232, 5968, 3912],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2697, 6085, 3745, 9577, 8343, 3630, 3663, 6604, 8764, 7976, 3921],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3427, 1466, 4762, 1347, 8536, 9554, 1324, 4346, 1117, 9946, 3930],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6505, 6227, 179, 3271, 1332, 8200, 3071, 7804, 370, 1876, 3940],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4905, 6871, 4627, 5066, 7631, 2017, 1230, 3987, 5605, 3766, 3949],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8862, 4663, 5147, 2534, 8252, 8159, 9995, 3842, 5902, 5617, 3958],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5533, 8455, 4943, 9621, 8606, 3560, 7324, 2269, 343, 7429, 3967],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3584, 7835, 3307, 3383, 7707, 5081, 6782, 8123, 8009, 9200, 3976],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [25, 4620, 3668, 5114, 6400, 3797, 9359, 4228, 7984, 932, 3986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2436, 4149, 5685, 6509, 3693, 2511, 5238, 7386, 9349, 2624, 3995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3006, 9367, 5375, 7144, 3992, 5575, 5528, 8383, 1188, 4277, 4004],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9565, 8977, 2718, 8745, 2057, 104, 3958, 2002, 2585, 5889, 4013],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2399, 7640, 1290, 2639, 6464, 7660, 8524, 7029, 2622, 7461, 4022],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4531, 9604, 663, 9390, 6351, 5499, 3109, 6266, 385, 8993, 4031],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9138, 6545, 5, 3885, 253, 6453, 9047, 6534, 4958, 484, 4041],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7186, 9592, 113, 5014, 9800, 6539, 6660, 8690, 5426, 1935, 4050],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5921, 7410, 9659, 6534, 5135, 9387, 6747, 7629, 875, 3346, 4059],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3718, 2252, 7391, 4692, 2883, 6546, 2037, 2298, 391, 4716, 4068],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9983, 6477, 2315, 8634, 1580, 2787, 8597, 5701, 3059, 6045, 4077],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2180, 6437, 4292, 1582, 3513, 5464, 7203, 4914, 7967, 7333, 4086],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8711, 6914, 3038, 4065, 5963, 7031, 4671, 1088, 4202, 8581, 4095],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2592, 4650, 8317, 5197, 8950, 9797, 5143, 9461, 850, 9788, 4104],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9593, 3848, 1230, 4047, 609, 2010, 1337, 9368, 7001, 953, 4114],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9644, 7275, 8264, 430, 5453, 4349, 5749, 4247, 1743, 2078, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3293, 1776, 7430, 3066, 4852, 5931, 1825, 1653, 4164, 3161, 4132],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1655, 478, 9833, 2765, 3174, 8894, 5081, 3261, 3353, 4203, 4141],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7507, 8394, 9902, 9301, 7133, 668, 4189, 4881, 8400, 5203, 4150],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9017, 1, 1789, 2652, 37, 3015, 2014, 6463, 8395, 6162, 4159],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1498, 524, 5866, 2456, 6726, 6918, 6621, 2107, 2429, 7080, 4168],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8360, 2698, 4591, 3727, 9177, 2433, 2231, 75, 9592, 7955, 4177],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [435, 9093, 7008, 2033, 6856, 2565, 136, 2795, 8975, 8789, 4186],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7066, 7969, 936, 7533, 89, 281, 9579, 6873, 9670, 9581, 4195],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4812, 3685, 5343, 4291, 8887, 7740, 8584, 3105, 770, 332, 4205],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7041, 4366, 5755, 9270, 3818, 6844, 4753, 6480, 1366, 1040, 4214],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8422, 6295, 4949, 4140, 9744, 176, 6011, 6192, 552, 1706, 4223],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [55, 8804, 985, 2644, 7388, 1455, 1315, 5651, 7421, 2329, 4232],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9880, 9056, 5243, 6554, 1952, 4564, 1323, 2488, 1067, 2911, 4241],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3001, 1487, 4020, 4296, 2181, 270, 9016, 8567, 583, 3450, 4250],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9685, 9504, 7022, 7991, 7507, 9720, 276, 9996, 5065, 3946, 4259],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6418, 8669, 2450, 7007, 5151, 3807, 4433, 7128, 3608, 4400, 4268],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9624, 9514, 8029, 8977, 3273, 7498, 4751, 4580, 5307, 4811, 4277],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7732, 5339, 6291, 2714, 544, 8229, 8891, 1235, 9258, 5179, 4286],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6760, 2284, 5458, 1341, 6741, 7451, 9317, 255, 4557, 5505, 4295],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8124, 3020, 8633, 8386, 3266, 4434, 3666, 9088, 300, 5788, 4304],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9491, 3132, 6713, 4356, 6742, 1409, 5073, 9476, 5586, 6027, 4313],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2077, 1410, 6818, 6480, 3130, 9168, 2453, 7468, 9512, 6223, 4322],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5649, 5558, 9404, 9812, 4131, 2194, 745, 3425, 1176, 6377, 4331],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8000, 4563, 4044, 3643, 1903, 2441, 1100, 2031, 9676, 6486, 4340],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4441, 1052, 5649, 3189, 2462, 844, 1042, 2302, 4111, 6553, 4349],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9613, 562, 8346, 2746, 2462, 5671, 4573, 7594, 3580, 6576, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8270, 9055, 1003, 2839, 8356, 6806, 2243, 5614, 7184, 6555, 4367],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4459, 9352, 3387, 383, 1307, 5072, 1170, 8426, 4022, 6491, 4376],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8193, 4610, 1052, 7421, 5550, 5678, 5020, 2462, 3196, 6383, 4385],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7640, 8891, 5367, 531, 2281, 4916, 3944, 8532, 3805, 6231, 4394],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6132, 5523, 6676, 9581, 5486, 9177, 4468, 1830, 4953, 6035, 4403],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6897, 9583, 6705, 946, 555, 5417, 9344, 1945, 5740, 5795, 4412],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8221, 4064, 3376, 6701, 832, 2149, 7350, 2871, 5269, 5511, 4421],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1572, 3680, 8458, 7500, 1741, 85, 3053, 3013, 2643, 5183, 4430],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5318, 4472, 6701, 2889, 6439, 1513, 6524, 5197, 6965, 4810, 4439],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [264, 9721, 3710, 8558, 1429, 7524, 3010, 6682, 7339, 4393, 4448],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1811, 5358, 7732, 5564, 4959, 2180, 2563, 9164, 2869, 3932, 4457],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3541, 1916, 5464, 1704, 5450, 2745, 9618, 8788, 2660, 3426, 4466],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4363, 8430, 998, 12, 1672, 5062, 2537, 6159, 5817, 2875, 4475],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7556, 7516, 6057, 3751, 802, 3195, 3101, 6344, 1445, 2280, 4484],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6101, 2504, 3966, 1175, 4974, 2438, 5958, 8888, 8650, 1639, 4493],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [162, 5646, 3605, 6738, 1384, 4795, 8029, 7820, 6539, 954, 4502],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3202, 305, 6216, 8317, 5511, 6032, 7868, 1662, 4219, 224, 4511],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8097, 3939, 9898, 2251, 1466, 3423, 4976, 3438, 796, 9449, 4519],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3614, 6479, 5538, 9640, 8003, 3274, 9070, 682, 5379, 8628, 4528],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1105, 8283, 4351, 8279, 3224, 7359, 9309, 5450, 7075, 7762, 4537],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5966, 9604, 1091, 4825, 5492, 7346, 3474, 4326, 4994, 6851, 4546],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2373, 8871, 7106, 1206, 2633, 6352, 7100, 8430, 8244, 5894, 4555],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6493, 7054, 1833, 7923, 5997, 6708, 2566, 3432, 5936, 4892, 4564],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5049, 9008, 7146, 4608, 511, 3066, 8139, 9554, 7178, 3844, 4573],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2819, 5500, 2409, 5086, 6378, 9936, 6969, 1586, 1083, 2751, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9192, 8506, 4469, 8, 2670, 2788, 6047, 8889, 6759, 1611, 4591],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7681, 9597, 631, 5063, 7582, 1800, 5103, 5407, 3320, 426, 4600],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8166, 9533, 7362, 6548, 4731, 7394, 5473, 9675, 9876, 9194, 4608],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7602, 4003, 5838, 8863, 9425, 6642, 8913, 4828, 5541, 7917, 4617],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5440, 2493, 9150, 44, 3457, 9681, 6364, 8611, 9426, 6593, 4626],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8865, 5391, 5986, 1909, 1544, 5223, 6679, 3385, 646, 5224, 4635],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5033, 7853, 1838, 524, 7177, 4297, 5295, 6139, 8313, 3807, 4644],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8866, 95, 408, 636, 221, 1322, 2867, 8497, 1542, 2345, 4653],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2244, 2863, 3085, 4275, 3275, 1620, 3849, 6727, 9448, 835, 4662],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8804, 6285, 511, 8946, 8408, 4505, 5033, 1751, 1146, 9280, 4670],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7898, 9820, 3722, 4617, 543, 1039, 4040, 9153, 5750, 7677, 4679],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1920, 1529, 8821, 1054, 8409, 5577, 7761, 9187, 2378, 6028, 4688],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7326, 4056, 3157, 7853, 8654, 234, 760, 6789, 146, 4332, 4697],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1692, 675, 6464, 8795, 3371, 1358, 3618, 1580, 8171, 2588, 4706],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4716, 1559, 128, 9826, 5965, 7152, 1242, 7882, 5569, 798, 4715],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4088, 2301, 3893, 5936, 5001, 5555, 1121, 4721, 1460, 8961, 4723],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5521, 2630, 2841, 6583, 341, 1490, 1533, 5839, 4961, 7076, 4732],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8062, 2181, 8802, 1823, 610, 2608, 9709, 9701, 5191, 5144, 4741],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3166, 4994, 8739, 2143, 5721, 2644, 9950, 9507, 1270, 3165, 4750],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8355, 7358, 6656, 3894, 2941, 1501, 1693, 3197, 2318, 1138, 4759],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [195, 503, 2776, 9318, 9685, 1178, 7532, 3459, 7454, 9063, 4767],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [476, 4739, 879, 5267, 989, 6678, 1191, 7745, 5799, 6941, 4776],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [801, 2619, 7632, 7874, 4343, 988, 5452, 8270, 6475, 4771, 4785],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [337, 818, 1388, 1557, 9352, 3287, 27, 2030, 8604, 2553, 4794],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6891, 2049, 6500, 9769, 4420, 9472, 9394, 802, 1307, 288, 4803],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3738, 4933, 5739, 1873, 7482, 4137, 578, 1163, 3707, 7974, 4811],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6530, 9196, 379, 5219, 2528, 3136, 881, 4487, 4927, 5612, 4820],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8143, 753, 6308, 4090, 8536, 5830, 5573, 6963, 4091, 3202, 4829],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [96, 2652, 5719, 7433, 2154, 6169, 5529, 9601, 323, 744, 4838],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9038, 6814, 7276, 5236, 349, 1702, 4818, 8239, 2748, 8237, 4846],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4324, 2505, 1852, 9045, 4014, 9669, 8243, 3553, 491, 5682, 4855],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [665, 1234, 4082, 5261, 8390, 9279, 8840, 1067, 2677, 3078, 4864],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1340, 6228, 9024, 621, 963, 9307, 5316, 1160, 8432, 425, 4873],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8686, 5163, 4396, 7457, 2376, 130, 9450, 9074, 6882, 7724, 4881],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9803, 5937, 7502, 2010, 733, 9343, 3435, 4927, 7156, 4974, 4890],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8902, 637, 6507, 2147, 4525, 59, 7187, 3715, 8380, 2175, 4899],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3907, 6759, 1692, 1207, 4322, 1041, 5582, 5328, 9682, 9327, 4907],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4745, 6563, 6510, 2444, 8206, 7777, 5667, 4553, 191, 6431, 4916],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6720, 4825, 2364, 3480, 850, 3641, 3810, 1086, 9036, 3484, 4925],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5946, 6677, 6143, 2324, 1025, 251, 2799, 9539, 5345, 489, 4934],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [242, 5229, 5608, 5865, 7234, 6174, 8899, 9449, 8250, 7444, 4942],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9755, 2437, 4030, 8113, 6090, 3090, 8859, 5289, 6881, 4350, 4951],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3672, 5212, 348, 8972, 2970, 8549, 6861, 6473, 368, 1207, 4960],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1399, 5542, 1986, 4775, 9425, 4458, 1433, 7367, 7843, 8013, 4968],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2439, 1677, 956, 9256, 6756, 427, 2299, 7296, 8438, 4770, 4977],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8631, 4561, 5719, 7952, 133, 1094, 7189, 555, 1286, 1478, 4986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8135, 6902, 6304, 240, 2569, 6577, 8596, 6417, 5518, 8135, 4994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2946, 2753, 2391, 1186, 3058, 5180, 484, 9141, 269, 4743, 5003],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9762, 4023, 6601, 159, 8151, 7477, 4942, 7978, 4673, 1300, 5012],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3205, 1881, 317, 4618, 1217, 923, 8796, 7186, 7864, 7807, 5020],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7922, 9822, 8366, 5580, 8660, 4107, 161, 6035, 8977, 4264, 5029],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1574, 9856, 2411, 6049, 7336, 9808, 4954, 8812, 7147, 671, 5038],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5204, 1437, 467, 4904, 2451, 5956, 3349, 4838, 1511, 7028, 5046],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7284, 6681, 495, 6608, 224, 3661, 6181, 8469, 1204, 3334, 5055],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6404, 6162, 7346, 1286, 4641, 1433, 1306, 9110, 5364, 9589, 5063],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3240, 2975, 1517, 416, 2650, 4733, 9905, 1218, 3129, 5794, 5072],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2277, 3565, 1510, 358, 7215, 9985, 2741, 4319, 3635, 1948, 5081],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4538, 1428, 4249, 9300, 2676, 2202, 6364, 3006, 6022, 8051, 5089],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7691, 2846, 4581, 2731, 1953, 5343, 9260, 6957, 9428, 4103, 5098],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2706, 5497, 8943, 8357, 171, 4561, 7962, 939, 2994, 105, 5107],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9531, 3751, 2523, 3303, 4416, 9463, 3096, 4817, 5858, 6055, 5115],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6167, 6037, 5614, 4461, 4352, 7535, 5387, 3562, 7162, 1954, 5124],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1317, 6722, 4346, 6966, 3600, 6860, 1605, 7263, 6046, 7802, 5132],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [976, 9359, 3726, 5824, 6829, 7280, 467, 1131, 1653, 3599, 5141],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3722, 1357, 6274, 1799, 2658, 9139, 8484, 5510, 3123, 9344, 5149],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7189, 8817, 5876, 4575, 7581, 8742, 5758, 5888, 9600, 5037, 5158],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3927, 1059, 1465, 4003, 1264, 9689, 1726, 2900, 227, 680, 5167],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [325, 9123, 5356, 3828, 8692, 9201, 855, 2340, 4147, 6270, 5175],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4715, 3508, 2602, 1620, 9815, 8613, 8283, 5169, 504, 1809, 5184],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5679, 1301, 5296, 3635, 2480, 7145, 5410, 7526, 8443, 7295, 5192],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2834, 16, 3823, 4029, 9619, 8116, 5436, 731, 7110, 2730, 5201],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6529, 9077, 8625, 4062, 6824, 6748, 8849, 1298, 5649, 8113, 5209],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [475, 5013, 3785, 8758, 1638, 8682, 8858, 943, 3207, 3444, 5218],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2552, 4358, 9052, 5728, 1077, 8378, 6778, 6591, 8930, 8722, 5226],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5905, 1600, 708, 3621, 9092, 6531, 7359, 385, 1967, 3949, 5235],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5963, 7269, 3618, 5708, 910, 5655, 4065, 9696, 1463, 9123, 5243],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1746, 4361, 6108, 7597, 6390, 2969, 4301, 7129, 6569, 4244, 5252],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4220, 7385, 3981, 6717, 9767, 9762, 4585, 534, 6433, 9313, 5260],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6042, 7350, 7475, 5188, 8393, 6351, 5674, 3013, 203, 4330, 5269],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3244, 5197, 1592, 6784, 8326, 1803, 7627, 2929, 7030, 9293, 5277],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3515, 5448, 1749, 2908, 9871, 7565, 4824, 3915, 6064, 4204, 5286],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5817, 8863, 7754, 1828, 1432, 4150, 933, 4881, 6456, 9062, 5294],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9383, 8513, 3669, 9701, 5318, 25, 3815, 23, 7358, 3867, 5303],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2352, 7106, 2220, 1203, 4411, 1869, 385, 8834, 7920, 8619, 5311],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9690, 7431, 2271, 1783, 3882, 5327, 1418, 6108, 7297, 3318, 5320],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6949, 4218, 7831, 2576, 7476, 5434, 6300, 1952, 4641, 7964, 5328],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7342, 374, 7642, 2885, 3133, 5852, 7726, 1794, 9105, 2556, 5337],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6073, 9072, 5261, 3725, 8071, 6068, 6347, 6390, 9843, 7095, 5345],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8674, 5547, 9502, 9241, 8754, 5723, 5362, 1833, 6011, 1581, 5354],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7456, 9241, 2097, 748, 6506, 5205, 5057, 9562, 6762, 6013, 5362],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1245, 3762, 679, 670, 4854, 1677, 7291, 6370, 1254, 392, 5371],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6526, 5610, 6783, 766, 63, 9689, 9926, 4413, 8642, 4716, 5379],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2225, 5353, 6159, 557, 1633, 5527, 1211, 1219, 8083, 8987, 5387],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3576, 967, 6651, 7882, 4930, 4463, 4099, 9692, 8733, 3204, 5396],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [710, 3350, 1150, 3895, 3479, 54, 524, 8128, 9752, 7367, 5404],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8626, 1438, 2445, 9488, 3813, 4651, 5614, 216, 298, 1477, 5413],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7225, 9641, 5269, 9124, 1198, 280, 1859, 5053, 9528, 5531, 5421],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4498, 6753, 9725, 1223, 9899, 9044, 3213, 7146, 6603, 9532, 5429],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3823, 5016, 9829, 1617, 7101, 2219, 9158, 6425, 683, 3479, 5438],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2344, 5918, 815, 8034, 4994, 7182, 8694, 8251, 928, 7371, 5446],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6309, 260, 7617, 9090, 945, 1356, 4296, 3422, 6500, 1208, 5455],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8164, 3042, 2565, 796, 1122, 2313, 5797, 8182, 6559, 4991, 5463],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3465, 7782, 9748, 7005, 8370, 3207, 4232, 4232, 269, 8720, 5471],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4760, 4397, 2842, 7646, 595, 2696, 5618, 8735, 6791, 2393, 5480],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6256, 4864, 7884, 9702, 1334, 8505, 4682, 4327, 5290, 6012, 5488],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7130, 2946, 6918, 944, 9702, 3816, 8538, 9123, 4928, 9576, 5496],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1133, 1475, 6292, 5058, 2331, 5627, 300, 6729, 4871, 3085, 5505],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8428, 3236, 7526, 9240, 5441, 4244, 2652, 6244, 4283, 6539, 5513],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7316, 2384, 994, 1290, 625, 3094, 1353, 2276, 2330, 9938, 5521],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8960, 3485, 4361, 2804, 3462, 7990, 8692, 4944, 8177, 3281, 5530],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8344, 9493, 9086, 8146, 9575, 5044, 6889, 9892, 991, 6570, 5538],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1236, 1817, 8789, 5372, 8238, 6374, 1434, 8292, 9940, 9802, 5546],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4988, 3617, 1537, 5226, 9183, 2777, 4380, 6854, 4191, 2980, 5555],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5878, 9979, 1968, 7577, 3788, 2543, 7572, 7837, 2912, 6102, 5563],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2743, 9776, 5498, 1227, 7349, 5563, 5827, 9055, 5272, 9168, 5571],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4254, 9205, 1929, 2789, 4695, 1917, 56, 3885, 441, 2179, 5580],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3834, 8107, 4787, 3309, 6974, 4090, 327, 1275, 7588, 5133, 5588],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9705, 1560, 166, 7396, 2970, 2007, 8880, 5754, 5883, 8032, 5596],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8352, 2987, 8404, 8745, 3917, 37, 3078, 7442, 4498, 875, 5605],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6797, 6539, 6359, 8143, 6330, 5154, 8307, 2051, 2605, 3662, 5613],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9336, 320, 9338, 5108, 2979, 5413, 821, 903, 9375, 6392, 5621],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4297, 6963, 1069, 2386, 7718, 7916, 525, 929, 3981, 9067, 5629],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7793, 3292, 7781, 3327, 5492, 5449, 3709, 4684, 5596, 1685, 5638],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8808, 1098, 7907, 5865, 4456, 945, 5720, 353, 3395, 4247, 5646],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1949, 2458, 969, 3138, 2761, 8965, 3580, 1759, 6551, 6752, 5654],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6668, 8701, 5475, 9888, 8191, 3357, 8553, 8370, 4239, 9201, 5662],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4641, 7585, 3341, 5423, 4486, 278, 8642, 5311, 5636, 1593, 5671],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2916, 2295, 3518, 8136, 3800, 5740, 1043, 3369, 9917, 3928, 5679],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6727, 6217, 5580, 3349, 447, 6874, 4538, 9000, 6258, 6207, 5687],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8552, 6033, 9497, 5396, 6695, 6070, 1827, 4343, 3838, 8429, 5695],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [490, 4851, 4404, 6455, 7092, 7186, 1808, 7222, 1833, 594, 5704],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1665, 9788, 9806, 8535, 3443, 2986, 1800, 1158, 9423, 2701, 5712],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3358, 4146, 9313, 1236, 8278, 2999, 9705, 5375, 5785, 4752, 5720],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4636, 4625, 970, 6272, 321, 976, 6119, 4812, 100, 6746, 5728],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9037, 8431, 9975, 360, 1205, 1108, 6380, 125, 1548, 8682, 5736],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2056, 6517, 8555, 751, 8343, 2211, 2563, 7701, 9308, 560, 5745],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8515, 9779, 2896, 2381, 4645, 9036, 5415, 9662, 2563, 2382, 5753],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5105, 1976, 6171, 2401, 1445, 9889, 6236, 3877, 495, 4146, 5761],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5996, 4112, 7002, 6469, 6773, 9753, 8697, 3967, 2285, 5852, 5769],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7107, 4388, 542, 1733, 6843, 8085, 606, 9316, 7116, 7500, 5777],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4341, 1670, 103, 3812, 4369, 466, 5614, 5074, 4173, 9091, 5785],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8229, 3095, 5745, 9203, 3110, 3298, 4861, 2173, 2639, 624, 5794],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8360, 5632, 6188, 365, 3783, 725, 8572, 7328, 1698, 2099, 5802],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7010, 4329, 4933, 8221, 2275, 2963, 7584, 3050, 537, 3516, 5810],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4910, 9000, 2794, 5897, 6894, 5222, 4825, 7651, 8340, 4874, 5818],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3647, 9425, 8551, 8108, 7133, 6412, 6729, 5253, 4295, 6175, 5826],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6688, 6807, 7708, 2695, 2298, 6808, 4595, 5798, 7588, 7417, 5834],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [675, 8719, 6221, 4295, 4095, 3869, 5888, 5053, 7407, 8601, 5842],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6234, 6894, 440, 5008, 3141, 5399, 5480, 4621, 2940, 9727, 5850],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2978, 6953, 4579, 3053, 5150, 9227, 6836, 1947, 3376, 794, 5859],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4417, 1300, 143, 7830, 8408, 8607, 3139, 328, 7904, 1802, 5867],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7898, 1772, 4364, 8354, 9985, 2518, 8356, 8918, 5713, 2752, 5875],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6824, 9273, 2630, 1780, 3972, 57, 8246, 2741, 5996, 3643, 5883],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2328, 3425, 7944, 9461, 907, 8112, 1311, 2695, 7942, 4475, 5891],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4475, 9142, 2784, 9815, 3421, 1512, 9690, 5559, 743, 5249, 5899],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5158, 1177, 8636, 9961, 8981, 4838, 9983, 4008, 3592, 5963, 5907],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4954, 9281, 8296, 1760, 6538, 5090, 4033, 6614, 5681, 6618, 5915],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8868, 3776, 7676, 2297, 9734, 4398, 9635, 7855, 6204, 7214, 5923],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4397, 8903, 7855, 4121, 5259, 1982, 1193, 8129, 4355, 7751, 5931],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6826, 6841, 4877, 6469, 822, 4536, 315, 3753, 9329, 8228, 5939],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6818, 4959, 3210, 5312, 3145, 4247, 6352, 6978, 320, 8647, 5947],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4545, 3176, 7591, 7258, 2294, 3636, 6873, 5996, 6525, 9005, 5955],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4621, 8396, 4571, 74, 4606, 6412, 8084, 4945, 7140, 9304, 5963],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7014, 6071, 6433, 792, 2392, 3546, 5188, 3920, 1362, 9544, 5971],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7227, 4672, 2194, 1014, 4574, 3749, 2681, 8979, 8388, 9723, 5979],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5152, 4972, 8424, 7982, 8332, 7563, 4594, 2152, 7418, 9843, 5987],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9684, 4483, 932, 9305, 7838, 4253, 4673, 1450, 7649, 9903, 5995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1148, 156, 681, 8710, 2094, 702, 6496, 871, 8281, 9903, 6003],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2754, 7601, 6345, 9946, 9898, 1507, 3535, 410, 8514, 9843, 6011],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3261, 2802, 3751, 5740, 5932, 9484, 9156, 6064, 7548, 9723, 6019],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3966, 557, 201, 8616, 7964, 5759, 6561, 9845, 4585, 9543, 6027],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2342, 4980, 9865, 274, 1176, 8677, 8662, 9782, 8827, 9302, 6035],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [735, 3307, 4507, 6041, 1609, 700, 7908, 9934, 9476, 9001, 6043],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9919, 3184, 706, 594, 6786, 2521, 6037, 395, 5736, 8640, 6051],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2433, 5665, 8399, 723, 7537, 3579, 3782, 7303, 6808, 8218, 6059],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7326, 9463, 3183, 141, 1156, 8184, 505, 2848, 1899, 7736, 6067],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3082, 8906, 2840, 338, 2004, 6456, 3778, 5279, 212, 7193, 6075],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4415, 672, 2551, 129, 1763, 9287, 8897, 8914, 953, 6589, 6083],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3660, 1451, 8081, 4696, 7586, 6518, 8343, 4147, 3329, 5924, 6091],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7116, 586, 5865, 2680, 2467, 7552, 1174, 7455, 6545, 5198, 6099],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3368, 7618, 6590, 7022, 8216, 3591, 2364, 1405, 9810, 4411, 6107],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8539, 7562, 7068, 1850, 7533, 728, 2074, 4666, 2330, 3564, 6115],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5765, 432, 5435, 3584, 7730, 3073, 4867, 2013, 3315, 2655, 6123],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1734, 5981, 7969, 9629, 4793, 5145, 8861, 4337, 1973, 1685, 6131],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1824, 2659, 2040, 2414, 2544, 2723, 4819, 8653, 7514, 653, 6139],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4008, 2610, 8167, 65, 7796, 1373, 5178, 8105, 9149, 9560, 6146],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7757, 8365, 3409, 7667, 8531, 1860, 3019, 1978, 6089, 8406, 6154],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9841, 8712, 5877, 4685, 8234, 1648, 974, 5703, 7544, 7190, 6162],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3280, 5072, 3050, 4808, 5665, 1710, 71, 866, 2728, 5913, 6170],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6802, 2775, 835, 3961, 5520, 7851, 8518, 5215, 852, 4574, 6178],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7253, 394, 1229, 663, 1550, 5762, 428, 2672, 1131, 3173, 6186],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2765, 6601, 8562, 50, 9897, 9010, 4475, 3332, 2778, 1710, 6194],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3684, 1458, 1353, 8791, 6567, 9192, 2498, 3481, 5008, 185, 6202],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9175, 8779, 1690, 2659, 9141, 7443, 8035, 5596, 7036, 8598, 6209],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8512, 3424, 9010, 1708, 8996, 6542, 4799, 8359, 8078, 6949, 6217],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [368, 7375, 1398, 9653, 6540, 2806, 5092, 6659, 7351, 5238, 6225],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2302, 2738, 5871, 4235, 8124, 7002, 8154, 1604, 4072, 3465, 6233],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6845, 2451, 9083, 3954, 9520, 3491, 8456, 528, 7458, 1629, 6241],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1012, 3156, 771, 3430, 7095, 6817, 3921, 6998, 6727, 9731, 6248],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1778, 7073, 2050, 4914, 3993, 4962, 4094, 821, 1100, 7771, 6256],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5649, 9473, 6988, 6908, 4907, 8486, 8239, 8054, 9794, 5747, 6264],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [902, 1522, 5296, 2438, 9245, 4770, 3383, 1012, 2032, 3662, 6272],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5485, 4559, 2400, 9260, 8746, 6581, 2288, 8272, 7032, 1513, 6280],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6512, 661, 5718, 2024, 1874, 4178, 1370, 4685, 4018, 9302, 6287],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8665, 1101, 6903, 2142, 3544, 182, 8547, 1381, 2211, 7028, 6295],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1553, 6948, 2815, 4746, 5064, 6436, 1028, 5781, 833, 4691, 6303],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1775, 837, 5641, 3624, 5399, 2065, 3043, 1597, 9109, 2290, 6311],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8186, 7239, 7013, 4302, 1188, 1970, 3499, 8848, 6261, 9827, 6318],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6415, 2638, 3354, 2433, 9232, 4972, 3585, 3863, 1516, 7301, 6326],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2077, 6782, 345, 9343, 1464, 842, 4308, 9290, 4097, 4711, 6334],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2505, 5081, 3209, 8845, 8743, 5416, 3963, 4104, 3232, 2058, 6342],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9881, 3805, 5072, 9238, 6105, 3059, 5549, 3614, 8146, 9341, 6349],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7514, 3902, 6338, 1686, 8466, 5661, 4110, 9472, 8066, 6561, 6357],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5217, 8492, 931, 872, 2070, 7429, 4023, 9679, 2221, 3718, 6365],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3244, 4942, 7100, 5845, 3351, 4673, 6216, 8594, 9839, 810, 6373],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9588, 1622, 6951, 8320, 3199, 9838, 5323, 6942, 149, 7840, 6380],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6109, 547, 5035, 2197, 995, 8990, 6781, 1820, 2381, 4805, 6388],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8390, 6493, 6342, 1803, 9140, 1997, 3855, 6707, 5764, 1706, 6396],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2701, 1776, 1472, 7122, 5183, 4637, 4603, 1469, 9531, 8543, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1406, 5116, 4192, 2101, 5019, 1846, 8782, 2369, 2912, 5317, 6411],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7274, 1703, 6053, 6922, 7023, 1362, 4680, 2075, 5140, 2026, 6419],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7904, 1708, 5253, 6786, 3402, 6977, 5892, 9664, 5447, 8671, 6426],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8249, 8169, 3049, 8304, 1408, 635, 8031, 634, 3069, 5252, 6434],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1384, 658, 183, 9872, 3513, 2614, 5367, 6910, 7237, 1768, 6442],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8993, 9309, 6957, 4414, 2033, 9020, 7414, 6850, 7188, 8220, 6449],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5893, 4771, 1846, 1535, 128, 5826, 5445, 5256, 2157, 4608, 6457],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1384, 8835, 2055, 1334, 7545, 8696, 8940, 3378, 1380, 931, 6465],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7618, 5498, 2007, 3915, 5898, 7830, 1979, 8926, 4093, 7189, 6472],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [449, 8690, 7866, 6786, 4742, 7054, 9561, 6071, 9535, 3382, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6465, 1544, 3172, 6962, 6149, 6410, 3864, 5462, 6943, 9511, 6487],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1683, 4816, 6488, 5465, 1961, 7471, 438, 4224, 5556, 5575, 6495],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2347, 8280, 348, 9120, 4368, 619, 4335, 5971, 4613, 1574, 6503],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6864, 2644, 4269, 7858, 6941, 3535, 6169, 814, 3355, 7508, 6510],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7828, 4892, 5303, 5283, 9728, 127, 8121, 5366, 1021, 3377, 6518],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3189, 8701, 8639, 5759, 8534, 9146, 9866, 2751, 6854, 9180, 6525],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5077, 8741, 8585, 2872, 4995, 1725, 4450, 2612, 95, 4919, 6533],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8664, 8550, 6614, 1576, 568, 7086, 4083, 1116, 9987, 591, 6541],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4424, 8138, 6893, 9707, 4087, 5654, 5888, 965, 5773, 6199, 6548],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2801, 4559, 9034, 3699, 9054, 8825, 7566, 1402, 6697, 1741, 6556],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6414, 1017, 122, 8235, 3354, 4625, 3009, 8219, 2003, 7218, 6563],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5064, 8453, 28, 131, 667, 8505, 7837, 3762, 938, 2629, 6571],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8423, 1558, 1503, 2950, 9333, 8525, 4880, 6944, 2746, 7974, 6578],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9184, 1529, 4686, 527, 1056, 4166, 9585, 3246, 6675, 3253, 6586],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3160, 9154, 8917, 4816, 8326, 8003, 5361, 4731, 1971, 8467, 6593],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [908, 4971, 6593, 6059, 6070, 9520, 8862, 45, 7883, 3614, 6601],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4223, 8058, 7281, 1231, 9575, 271, 5198, 4431, 3658, 8696, 6608],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7394, 6808, 7451, 9958, 7341, 9673, 3079, 9731, 8546, 3711, 6616],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2834, 1224, 3326, 5532, 4114, 652, 9907, 4396, 1798, 8661, 6623],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [844, 2834, 2223, 2254, 5919, 4408, 6778, 3496, 2663, 3544, 6631],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1214, 6568, 1105, 9009, 5575, 3543, 3443, 8722, 392, 8361, 6638],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1161, 1943, 9060, 2656, 3746, 2799, 3184, 8397, 4238, 3111, 6646],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3349, 288, 1435, 3474, 7213, 6663, 7633, 7483, 3453, 7795, 6653],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8946, 7110, 4976, 8396, 2716, 3091, 1524, 7590, 7290, 2412, 6661],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8160, 2404, 2410, 6153, 1307, 2594, 7373, 6978, 5003, 6963, 6668],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7072, 3408, 7599, 1473, 4831, 1954, 99, 573, 5847, 1447, 6676],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3758, 5640, 4085, 3319, 2803, 1813, 1573, 9965, 9075, 5864, 6683],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7560, 2220, 5054, 4484, 4603, 7389, 5102, 3423, 3946, 215, 6691],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8835, 46, 5489, 6851, 8577, 1584, 9849, 5899, 9714, 4498, 6698],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8582, 712, 586, 8011, 6322, 9730, 5177, 9037, 5637, 8715, 6705],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [501, 2232, 788, 799, 7103, 5231, 4942, 1177, 974, 2865, 6713],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2957, 877, 4712, 7498, 4044, 5366, 1700, 7367, 4981, 6947, 6720],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9660, 2076, 7674, 4926, 450, 6499, 863, 9367, 6919, 962, 6728],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4304, 8177, 5630, 5326, 1282, 7964, 4779, 5658, 6048, 4910, 6735],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3378, 244, 1544, 817, 1576, 3881, 6748, 1450, 1628, 8791, 6742],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7324, 7213, 2145, 6091, 265, 2160, 4968, 8688, 2919, 2604, 6750],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8051, 6669, 5720, 4980, 4634, 9957, 6417, 6059, 9185, 6349, 6757],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2152, 3853, 3062, 1403, 7334, 4845, 669, 9002, 9687, 27, 6765],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3699, 938, 621, 3973, 4661, 955, 3633, 9711, 3689, 3638, 6772],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [793, 853, 2774, 6133, 1533, 9355, 1235, 7148, 455, 7181, 6779],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [131, 1333, 4080, 6, 5358, 1930, 3032, 7045, 9249, 655, 6787],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1995, 3330, 6567, 2153, 7757, 8027, 5745, 1915, 9337, 4062, 6794],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3028, 3351, 5048, 3056, 9885, 3124, 6745, 1058, 9984, 7401, 6801],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5046, 772, 7922, 9289, 3847, 8797, 7450, 568, 457, 673, 6809],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8239, 3383, 3935, 7989, 9527, 3241, 6673, 3341, 23, 3876, 6816],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [890, 4592, 8234, 7257, 2910, 1628, 3885, 9082, 7950, 7010, 6823],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1488, 396, 4297, 3530, 8809, 5542, 2423, 4312, 3508, 77, 6831],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5019, 6074, 1821, 7575, 7690, 794, 2625, 2376, 5965, 3075, 6838],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8616, 7026, 3463, 4652, 3130, 2851, 4892, 3450, 4591, 6005, 6845],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2037, 627, 3801, 1348, 3239, 9173, 2691, 4549, 8657, 8866, 6852],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2481, 8040, 9718, 1652, 6239, 7719, 5484, 9532, 7434, 1659, 6860],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2822, 1837, 9427, 7900, 7206, 891, 1587, 9113, 195, 4384, 6867],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3793, 2210, 3729, 8183, 9840, 4189, 963, 864, 6213, 7039, 6874],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8257, 3932, 3383, 676, 3972, 8853, 7950, 9225, 4759, 9626, 6881],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7304, 4116, 5169, 6972, 6387, 7755, 3914, 5513, 5110, 2144, 6889],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4129, 4160, 546, 862, 9412, 3830, 9835, 7923, 6539, 4593, 6896],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7165, 2517, 7849, 6025, 8560, 303, 8826, 1543, 8323, 6973, 6903],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2021, 6961, 4329, 5707, 7464, 1997, 8582, 8355, 9736, 9284, 6910],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1338, 6071, 9819, 9552, 5154, 6997, 3761, 7246, 57, 1527, 6918],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6637, 8181, 450, 7376, 7688, 7942, 8295, 4012, 8563, 3699, 6925],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7890, 5462, 9066, 6558, 3005, 2228, 7631, 1370, 4532, 5803, 6932],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8041, 6704, 8331, 9060, 4813, 389, 903, 8961, 7242, 7837, 6939],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2742, 9083, 2001, 5509, 8221, 1950, 3038, 3357, 5975, 9802, 6946],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [169, 6899, 7529, 7525, 6755, 8016, 6789, 8072, 9, 1698, 6954],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1203, 6909, 6630, 5220, 7344, 9883, 4701, 3567, 8627, 3523, 6961],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9043, 7934, 6351, 4601, 6775, 2955, 1005, 7256, 1109, 5280, 6968],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1013, 6070, 7590, 9424, 92, 5241, 3442, 3514, 6739, 6966, 6975],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1988, 8652, 6220, 3688, 8349, 9715, 5024, 3686, 4799, 8583, 6982],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3433, 3299, 8560, 4473, 87, 9834, 5718, 6092, 4573, 130, 6990],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7160, 3268, 1743, 87, 7899, 7467, 4062, 6035, 5346, 1607, 6997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3399, 2052, 3776, 5412, 8381, 2562, 8713, 5807, 6403, 3014, 7004],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9811, 4731, 91, 4931, 796, 3792, 9923, 4699, 7030, 4351, 7011],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7239, 5727, 4989, 3982, 6723, 9493, 948, 9006, 6513, 5618, 7018],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6751, 2061, 8465, 417, 1, 8179, 9385, 2031, 4141, 6815, 7025],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1168, 281, 1842, 1792, 3251, 7897, 8436, 4101, 9200, 7941, 7032],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7009, 5198, 8955, 7569, 4291, 3744, 8108, 2565, 980, 8998, 7039],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [826, 7362, 2185, 1411, 2765, 2803, 6337, 1806, 8770, 9983, 7046],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9924, 4720, 2593, 5401, 4332, 5805, 46, 3247, 1860, 899, 7054],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [969, 3702, 8187, 6000, 6818, 4802, 6131, 5356, 9541, 1743, 7061],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4240, 4569, 666, 473, 9730, 6138, 2374, 3659, 1105, 2518, 7068],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1227, 8664, 4852, 2500, 5619, 8013, 8290, 739, 5844, 3221, 7075],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4268, 5430, 1753, 6582, 8817, 1926, 5901, 6251, 3050, 3854, 7082],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5084, 8065, 358, 2522, 4125, 7301, 436, 6923, 2018, 4416, 7089],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1728, 6726, 8782, 3812, 5110, 8570, 970, 6565, 2042, 4907, 7096],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1151, 8619, 5349, 6919, 8749, 4028, 981, 6078, 2417, 5327, 7103],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3388, 5783, 7205, 2294, 220, 5739, 8841, 3458, 2439, 5676, 7110],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8164, 1463, 9728, 2353, 8745, 9788, 8239, 3807, 1404, 5954, 7117],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2986, 6008, 5517, 6519, 2491, 6196, 8529, 9335, 8609, 6160, 7124],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7914, 5430, 7366, 8746, 7620, 7756, 5005, 9371, 3353, 6296, 7131],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2542, 411, 5040, 8598, 3704, 7132, 9112, 367, 4935, 6360, 7138],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8661, 5879, 9842, 2864, 4837, 1478, 8579, 5909, 2652, 6353, 7145],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3823, 9017, 2072, 861, 2894, 3908, 7482, 6720, 5806, 6274, 7152],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1456, 3373, 2100, 2809, 6529, 1093, 6241, 669, 3698, 6124, 7159],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2112, 2197, 2777, 7047, 6630, 6302, 1536, 2778, 5628, 5902, 7166],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8524, 1927, 5366, 8138, 6105, 7174, 6162, 5227, 899, 5609, 7173],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2773, 4721, 8547, 4201, 9020, 7533, 8803, 7365, 8814, 5243, 7180],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8828, 2478, 5115, 7888, 1272, 2545, 3741, 5714, 8677, 4806, 7187],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [24, 4565, 7714, 1306, 2152, 6512, 488, 3975, 9792, 4297, 7194],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6619, 44, 6750, 781, 3304, 2625, 3354, 3037, 1464, 3717, 7201],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3242, 4886, 3064, 2557, 8806, 3959, 932, 985, 2999, 3064, 7208],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7277, 3772, 7075, 5331, 7244, 5032, 5522, 3103, 3703, 2339, 7215],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7027, 7251, 6040, 9788, 3874, 3221, 2476, 1886, 2884, 1542, 7222],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [427, 1138, 2541, 8983, 8157, 9352, 9472, 7041, 9849, 672, 7229],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [442, 7633, 9987, 6479, 9158, 6768, 5721, 5501, 3908, 9731, 7235],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6709, 3133, 4162, 1454, 8525, 8176, 1092, 1425, 4370, 8717, 7242],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7707, 5227, 1939, 1491, 7974, 9592, 5175, 6208, 544, 7631, 7249],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7532, 9695, 7224, 4457, 5447, 688, 6266, 8490, 1742, 6472, 7256],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2480, 3176, 6849, 540, 1335, 851, 277, 4160, 7276, 5240, 7263],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3981, 8379, 2101, 4226, 3405, 266, 9583, 6361, 6457, 3936, 7270],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7743, 7620, 471, 3611, 6332, 5337, 1786, 5505, 8599, 2559, 7277],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7030, 6916, 2020, 880, 8965, 7752, 8414, 9268, 3015, 1110, 7284],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2555, 2734, 9968, 3002, 9751, 6511, 3542, 2609, 9021, 9587, 7290],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9673, 5679, 9184, 5611, 7993, 2228, 2343, 7767, 5930, 7992, 7297],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2741, 9305, 2306, 5564, 5896, 3022, 9565, 4273, 3060, 6324, 7304],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8833, 4849, 3411, 8772, 3646, 1313, 7938, 8958, 9726, 4582, 7311],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7146, 6141, 5158, 9452, 7057, 837, 6503, 5955, 5247, 2768, 7318],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3371, 7271, 8002, 4909, 4610, 3201, 8872, 6709, 8940, 880, 7325],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4420, 2841, 9629, 6276, 8023, 3286, 1414, 9985, 124, 8920, 7331],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8083, 7170, 8793, 183, 7803, 2831, 1366, 1870, 8120, 6885, 7338],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6209, 9556, 9041, 9077, 2530, 1501, 4873, 5785, 2246, 4778, 7345],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6871, 3765, 2563, 8772, 7987, 4768, 4953, 2490, 1825, 2597, 7352],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7822, 6296, 155, 695, 9528, 7929, 9391, 89, 6178, 342, 7359],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7456, 686, 6778, 3172, 8468, 5567, 8557, 4040, 4627, 8014, 7365],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6237, 8698, 9567, 835, 597, 5793, 3150, 7159, 6496, 5612, 7372],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2709, 8869, 1942, 3808, 2261, 8580, 1872, 9627, 1109, 3137, 7379],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5590, 1951, 8292, 8654, 6848, 7524, 9026, 8998, 7791, 587, 7386],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1931, 67, 2856, 1062, 1848, 4343, 2039, 208, 5868, 7964, 7392],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8987, 3512, 7141, 5802, 4042, 5443, 8913, 5574, 4664, 5267, 7399],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3643, 7942, 5352, 2653, 7773, 9887, 5603, 4811, 3508, 2496, 7406],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4040, 4442, 8907, 7503, 8590, 8077, 3320, 5030, 1727, 9651, 7412],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9591, 133, 545, 5820, 2010, 486, 5758, 749, 8650, 6731, 7419],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4292, 3978, 6557, 884, 4485, 5763, 6248, 3900, 3605, 3738, 7426],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9105, 7793, 2295, 1696, 1111, 7549, 4844, 3834, 5923, 670, 7433],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [619, 9535, 741, 5042, 2006, 9315, 5324, 7328, 4934, 7528, 7439],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9921, 2635, 5258, 2964, 6706, 6572, 2125, 8593, 9970, 4311, 7446],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7806, 1562, 3690, 554, 3359, 5771, 7199, 9278, 363, 1021, 7453],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2852, 8929, 9149, 9650, 6932, 9224, 6798, 8481, 5446, 7655, 7459],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6290, 9634, 9752, 1531, 8084, 5391, 8184, 2751, 4553, 4215, 7466],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7363, 2733, 1335, 5964, 1784, 3849, 6260, 6098, 7017, 700, 7473],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4925, 4056, 9106, 4979, 2260, 4286, 133, 9998, 2174, 7111, 7479],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3302, 2948, 982, 7379, 8251, 8858, 9598, 3398, 9361, 3446, 7486],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [826, 2469, 1013, 4142, 69, 7236, 1550, 2730, 7913, 9707, 7492],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2573, 5523, 9238, 5618, 7401, 3675, 6317, 1906, 7168, 5893, 7499],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [753, 2747, 7150, 8443, 4296, 5466, 3922, 2336, 6464, 2004, 7506],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4891, 3540, 7765, 3546, 5242, 2071, 271, 2927, 5140, 8040, 7512],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6325, 7831, 7452, 6318, 3744, 4315, 3260, 92, 2536, 4001, 7519],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7047, 5339, 3844, 5850, 2322, 2949, 8815, 7758, 7991, 9886, 7525],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2976, 5013, 416, 2151, 327, 5937, 6849, 7372, 848, 5697, 7532],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5743, 2627, 3039, 8264, 3515, 3801, 7151, 7905, 448, 1432, 7539],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4399, 8304, 5687, 8175, 6827, 2370, 5193, 5862, 6134, 7091, 7545],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6244, 982, 9625, 1267, 9335, 2269, 7867, 5286, 7249, 2675, 7552],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3389, 8065, 136, 9755, 7872, 4496, 9144, 7767, 3137, 8184, 7558],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9522, 9041, 4039, 6925, 3395, 1427, 5659, 2447, 3144, 3617, 7565],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7833, 1753, 5797, 1101, 1648, 2595, 2217, 6026, 6614, 8974, 7571],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3214, 3135, 5578, 2864, 7295, 4588, 7229, 2769, 2895, 4256, 7578],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2408, 8285, 3784, 1256, 8212, 4412, 8068, 4515, 1333, 9462, 7584],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6152, 7324, 7521, 8263, 4199, 5660, 6350, 680, 1277, 4592, 7591],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5379, 103, 8717, 9835, 1967, 6842, 3141, 8265, 2074, 9646, 7597],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7278, 110, 3871, 5920, 5799, 1221, 4087, 1862, 3076, 4624, 7604],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3856, 8452, 3919, 1438, 901, 7504, 4465, 3662, 3631, 9526, 7610],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5969, 3443, 925, 4686, 4031, 730, 4168, 3460, 3091, 4352, 7617],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3202, 5148, 7113, 9271, 3600, 2723, 2598, 8662, 807, 9102, 7623],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4928, 5657, 1377, 295, 9037, 1439, 3500, 4291, 6133, 3775, 7630],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8243, 5746, 8294, 4978, 6823, 8579, 9706, 2994, 8421, 8372, 7636],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3212, 7341, 3881, 2285, 8237, 4802, 7814, 5050, 7025, 2893, 7643],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5260, 6875, 8995, 5133, 1431, 1910, 2779, 8373, 1300, 7338, 7649],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4091, 145, 3066, 2577, 8144, 1339, 2438, 8520, 602, 1706, 7656],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8046, 217, 4714, 7650, 2946, 8335, 1953, 8699, 4287, 5997, 7662],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [422, 2294, 8057, 9466, 591, 1140, 8182, 9773, 1712, 212, 7669],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4345, 6930, 9809, 5453, 4670, 4575, 3963, 270, 2236, 4350, 7675],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9291, 5073, 7685, 1299, 8440, 7358, 2337, 6384, 5215, 8411, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5434, 7560, 9480, 2150, 6354, 2519, 682, 1986, 11, 2396, 7688],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [709, 1497, 8288, 8794, 2487, 272, 4773, 8628, 5982, 6303, 7694],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2438, 8281, 5686, 6877, 9731, 2704, 2769, 5552, 2491, 134, 7701],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8172, 1087, 3904, 5599, 1307, 9645, 9120, 9692, 8898, 3887, 7707],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5072, 5506, 1682, 4697, 3848, 5061, 8399, 5686, 4567, 7564, 7713],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6871, 9265, 8080, 4802, 8978, 3364, 9051, 5877, 8860, 1163, 7720],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4927, 8459, 4228, 6374, 8030, 4971, 7074, 323, 1142, 4686, 7726],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3511, 8199, 5040, 6259, 2247, 490, 9618, 6801, 776, 8131, 7732],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3407, 9556, 337, 8488, 8523, 2895, 8504, 816, 7130, 1498, 7739],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6128, 8816, 6348, 7031, 8467, 7060, 3673, 5605, 9568, 4788, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4575, 6266, 2154, 2925, 6289, 6001, 6552, 2143, 7459, 8001, 7751],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4226, 4564, 8658, 6252, 8751, 3211, 3343, 9153, 169, 1137, 7758],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4352, 1359, 6820, 4972, 8162, 447, 8237, 3107, 7069, 4194, 7764],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4670, 529, 3280, 7318, 7129, 333, 6549, 8238, 7526, 7174, 7770],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5345, 5576, 564, 2491, 1554, 3156, 7776, 6541, 912, 77, 7777],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [474, 376, 630, 5467, 6093, 7216, 8577, 7783, 6597, 2901, 7783],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5685, 6172, 8758, 5913, 4092, 2112, 5676, 9508, 3953, 5648, 7789],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3982, 3204, 3321, 8358, 1749, 4317, 8683, 7042, 2353, 8317, 7795],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5900, 6388, 8603, 799, 4063, 4432, 2846, 3503, 1170, 908, 7802],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3158, 2637, 5043, 1838, 7883, 5482, 1716, 9802, 9777, 3420, 7808],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [60, 5683, 5531, 2009, 5193, 1628, 9740, 4653, 7551, 5855, 7814],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4912, 1169, 8923, 3307, 7526, 6668, 4771, 4581, 3866, 8212, 7820],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1991, 1744, 2998, 1767, 238, 1711, 508, 3922, 8099, 490, 7827],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4792, 1401, 8623, 1354, 3157, 1382, 8846, 4833, 9627, 2690, 7833],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [342, 1535, 3919, 3270, 1951, 7958, 2159, 7302, 7828, 4812, 7839],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7889, 5738, 421, 2927, 2371, 2787, 5501, 9145, 2081, 6856, 7845],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3454, 8370, 410, 7354, 7354, 4388, 8722, 6021, 1766, 8821, 7851],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7174, 7439, 3113, 8427, 4812, 2602, 8518, 1434, 6263, 707, 7858],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9110, 9675, 3986, 2120, 1757, 8170, 391, 6740, 4952, 2515, 7864],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2722, 6643, 1853, 798, 8272, 7128, 540, 1151, 7217, 4244, 7870],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5755, 3176, 8701, 4370, 2688, 9397, 7664, 1745, 2439, 5895, 7876],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5381, 4332, 1276, 6807, 7174, 937, 4696, 3472, 2, 7467, 7882],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3603, 7027, 6422, 6994, 822, 8875, 447, 9156, 9290, 8959, 7888],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2769, 9272, 6978, 7154, 5178, 8957, 1187, 9504, 9689, 373, 7895],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1152, 2239, 4939, 7886, 5044, 4742, 2130, 3113, 585, 1709, 7901],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [154, 2043, 5822, 6357, 5259, 7893, 8850, 6474, 1363, 2965, 7907],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2389, 5704, 4523, 3090, 2056, 8973, 8619, 3981, 1412, 4142, 7913],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4892, 6539, 9448, 3142, 5489, 8119, 1660, 7934, 119, 5240, 7919],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1063, 4128, 8934, 9162, 7324, 4992, 2325, 8545, 6874, 6258, 7925],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1640, 5386, 1757, 6736, 6695, 7380, 192, 3948, 1067, 7198, 7931],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9721, 2942, 1157, 6563, 3733, 7852, 1086, 201, 2088, 8058, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8949, 4032, 7937, 3211, 9316, 7848, 8016, 1294, 9328, 8838, 7943],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3437, 6789, 898, 6429, 6984, 8602, 2036, 9157, 2179, 9540, 7949],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8790, 8590, 9530, 8161, 1024, 8276, 3026, 3660, 36, 162, 7956],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7832, 6455, 1386, 6473, 2642, 4712, 393, 2626, 2291, 704, 7962],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7627, 9897, 1092, 6348, 4103, 3190, 3692, 1832, 8339, 1166, 7968],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2926, 1558, 5136, 6903, 8661, 8579, 3169, 5019, 7575, 1549, 7974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1977, 9611, 1392, 4643, 2055, 1287, 226, 3895, 9396, 1852, 7980],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [199, 5507, 9269, 3084, 9313, 6391, 7797, 8141, 3198, 2076, 7986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1664, 3983, 9044, 222, 8576, 5366, 660, 5422, 8380, 2219, 7992],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4240, 6047, 782, 6811, 1620, 9780, 5653, 1384, 4340, 2283, 7998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9670, 8193, 6578, 282, 8749, 6376, 1823, 9670, 476, 2267, 8004],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6016, 463, 6878, 1167, 3690, 2938, 485, 1918, 6191, 2170, 8010],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2602, 7809, 3596, 1065, 2159, 4319, 5208, 7771, 883, 1994, 8016],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9911, 4919, 499, 3484, 5712, 8061, 1719, 4884, 3956, 1737, 8022],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [571, 9181, 4954, 1102, 543, 8988, 7726, 8925, 4811, 1400, 8028],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5958, 6434, 4380, 5149, 8872, 2174, 2661, 3588, 2853, 983, 8034],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2823, 5930, 4361, 4566, 8606, 3707, 7341, 591, 7485, 485, 8040],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8078, 8249, 1978, 4329, 4951, 8624, 3555, 9690, 8111, 9907, 8045],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7637, 2655, 5092, 3676, 5710, 5446, 3565, 8678, 4139, 9249, 8051],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6311, 1551, 3371, 5952, 13, 6708, 9525, 3395, 4975, 8510, 8057],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [251, 4564, 6349, 2225, 8280, 4883, 2827, 7735, 25, 7691, 8063],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3144, 7946, 3695, 733, 9251, 3126, 3359, 3646, 8699, 6790, 8069],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5842, 9125, 8629, 3414, 7986, 219, 8687, 1142, 405, 5810, 8075],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2234, 9686, 1797, 9289, 6778, 9149, 3153, 8308, 4552, 4748, 8081],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8680, 5210, 4152, 2091, 8998, 8715, 6899, 1301, 553, 3606, 8087],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6704, 1442, 7093, 6347, 3948, 7579, 4799, 4363, 7817, 2382, 8093],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2595, 7467, 9342, 1851, 8903, 164, 5321, 9821, 5757, 1078, 8099],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [855, 399, 5205, 1228, 2553, 3827, 9300, 8096, 3787, 9693, 8104],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8564, 916, 9823, 8844, 2202, 6694, 8639, 7709, 1320, 8227, 8110],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6700, 7690, 5101, 1693, 5132, 5598, 4920, 5285, 7771, 6679, 8116],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2375, 6373, 5744, 3912, 2646, 3513, 7938, 5559, 2555, 5051, 8122],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3286, 906, 8478, 6285, 3441, 5905, 4154, 1385, 5089, 3341, 8128],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4319, 5460, 8495, 255, 1021, 5422, 5068, 3737, 4789, 1550, 8134],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9272, 5046, 4370, 2642, 8016, 4327, 5507, 1719, 1074, 9678, 8139],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [258, 7122, 4492, 2280, 8390, 4106, 1835, 2569, 3362, 7724, 8145],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1848, 3599, 2226, 3105, 6625, 1651, 81, 1664, 1073, 5689, 8151],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5461, 1837, 640, 9738, 1135, 1454, 3984, 2527, 3627, 3572, 8157],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5278, 2719, 7401, 1274, 7284, 3219, 2959, 6834, 445, 1374, 8163],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9234, 9451, 2260, 6677, 3521, 4325, 9980, 4416, 950, 9094, 8168],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1825, 3182, 8915, 830, 2336, 6541, 9381, 3270, 4564, 6732, 8174],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7154, 5400, 4738, 3874, 5832, 6439, 4577, 9560, 710, 4289, 8180],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7037, 8563, 227, 7757, 3947, 8912, 5701, 7624, 8814, 1763, 8186],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8708, 1415, 8653, 3042, 1464, 3222, 7163, 9982, 8300, 9156, 8191],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1596, 8113, 8478, 5690, 8159, 1009, 5121, 7340, 8595, 6467, 8197],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7658, 601, 9156, 7795, 4615, 5685, 4877, 8595, 9125, 3696, 8203],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8793, 6303, 6825, 8017, 4393, 2627, 8189, 842, 9319, 843, 8209],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5475, 5014, 1708, 6550, 1470, 9617, 495, 9381, 8603, 7908, 8214],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5892, 7758, 4302, 5927, 36, 6937, 8067, 7717, 6409, 4891, 8220],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1776, 2821, 3185, 2629, 1951, 6560, 5069, 7575, 2166, 1792, 8226],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3910, 3977, 2899, 5268, 5367, 9861, 544, 8897, 5305, 8610, 8231],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9565, 2131, 5188, 3019, 6246, 3279, 5315, 9851, 5258, 5346, 8237],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3800, 6677, 9225, 2820, 2706, 1361, 8799, 6839, 1458, 2000, 8243],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7650, 1147, 4459, 5634, 378, 6620, 5747, 4500, 3338, 8571, 8248],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7858, 3392, 587, 643, 5168, 5641, 2898, 5715, 332, 5060, 8254],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3702, 5898, 9872, 1576, 8061, 868, 5547, 1614, 1876, 1466, 8260],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3948, 5817, 3670, 1335, 4862, 7502, 4034, 1583, 7405, 7789, 8265],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1588, 165, 3439, 9613, 1989, 4950, 155, 3267, 6356, 4030, 8271],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2447, 5784, 1667, 3277, 7721, 2261, 3479, 2576, 8167, 188, 8277],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6202, 3527, 4710, 668, 6526, 6986, 7592, 3693, 2276, 6264, 8282],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4792, 8470, 1380, 8781, 2406, 6891, 6257, 9078, 8122, 2256, 8288],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3520, 7310, 1812, 6257, 5426, 3974, 9486, 9472, 5146, 8166, 8293],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3227, 834, 3356, 5309, 3883, 221, 9534, 3906, 2789, 3993, 8299],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8282, 7988, 6467, 1914, 2877, 4533, 6808, 9704, 491, 9737, 8304],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8345, 5709, 5403, 5852, 8296, 277, 5697, 2489, 7697, 5397, 8310],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3718, 3031, 7205, 299, 3555, 2898, 310, 6190, 3848, 975, 8316],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7576, 5892, 8620, 4659, 4696, 7026, 142, 3045, 8390, 6469, 8321],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5263, 4639, 4250, 4015, 7802, 2540, 5650, 3609, 767, 1881, 8327],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6113, 9215, 9900, 3958, 939, 9016, 3744, 6760, 425, 7209, 8332],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4306, 1160, 1759, 509, 1203, 8008, 3205, 9701, 6811, 2453, 8338],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7724, 2680, 3017, 1258, 5736, 2619, 7, 7969, 9373, 7614, 8343],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2080, 7747, 2761, 5752, 3925, 3794, 2563, 5438, 7559, 2692, 8349],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1640, 3730, 4613, 284, 6316, 2787, 6889, 4327, 818, 7687, 8354],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4728, 7109, 1474, 4711, 4115, 9259, 1678, 5205, 8600, 2597, 8360],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3439, 1369, 3990, 6483, 1512, 4442, 3299, 6993, 356, 7425, 8365],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [726, 1311, 9573, 9754, 1374, 8831, 701, 6975, 5538, 2168, 8371],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7163, 9881, 1182, 5085, 3250, 3849, 248, 799, 3599, 6828, 8376],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3657, 6001, 4957, 7825, 957, 6938, 455, 2485, 3991, 1404, 8382],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9738, 8471, 7307, 676, 5413, 9526, 6654, 4429, 6169, 5896, 8387],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1269, 2849, 8577, 8041, 6715, 7332, 5567, 7411, 9588, 304, 8393],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2711, 1787, 4747, 6603, 7889, 2450, 9798, 596, 3705, 4629, 8398],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [428, 5483, 3253, 7928, 1058, 6680, 2241, 1545, 7975, 8869, 8403],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1270, 493, 5566, 4771, 5226, 5550, 408, 6214, 1856, 3026, 8409],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6306, 6225, 8999, 3029, 3216, 2502, 665, 8965, 4807, 7098, 8414],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5040, 1798, 3986, 5894, 3734, 2677, 2390, 2569, 6288, 1086, 8420],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3894, 2287, 879, 5595, 2916, 5780, 2046, 8212, 5757, 4990, 8425],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2872, 9170, 1910, 1128, 8128, 7468, 7169, 5499, 2677, 8810, 8430],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9096, 5902, 8238, 7426, 5209, 8733, 271, 2463, 6509, 2545, 8436],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6034, 9684, 7635, 2494, 8769, 2727, 2661, 5564, 6715, 6196, 8441],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7413, 9445, 3291, 3985, 3555, 8510, 8177, 9701, 2759, 9763, 8446],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5745, 2356, 5828, 5489, 3375, 1161, 6844, 8215, 4106, 3245, 8452],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7806, 9210, 5947, 5315, 2456, 7738, 8431, 2892, 221, 6643, 8457],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3510, 1824, 455, 6709, 2589, 8533, 5943, 3972, 569, 9956, 8462],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2267, 6962, 5580, 8200, 7847, 3098, 9012, 151, 4618, 3184, 8468],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1806, 8453, 3909, 5982, 7114, 506, 7211, 8590, 1834, 6328, 8473],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5955, 1058, 9510, 6831, 3123, 3308, 3284, 4917, 1688, 9387, 8478],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8034, 5544, 4323, 27, 5169, 4662, 6290, 3233, 3648, 2361, 8484],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1039, 2192, 1231, 9857, 1114, 8101, 4660, 6120, 7184, 5250, 8489],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7343, 4738, 8576, 6623, 2809, 9400, 9173, 4642, 1768, 8055, 8494],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2629, 9217, 9991, 3404, 7482, 28, 5845, 8355, 6871, 774, 8500],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1266, 7110, 4214, 8161, 6191, 1643, 8730, 5307, 1967, 3409, 8505],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9410, 7128, 3775, 6011, 8880, 1105, 2646, 2049, 6529, 5958, 8510],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2375, 3174, 56, 4512, 4085, 5488, 5804, 3634, 31, 8423, 8515],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2432, 5680, 5742, 5537, 9854, 6549, 2361, 3629, 1949, 802, 8521],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1914, 5666, 4162, 724, 927, 4150, 4882, 4114, 1759, 3096, 8526],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6577, 8025, 7835, 3382, 5741, 8079, 6719, 5692, 8938, 5304, 8531],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3372, 569, 4733, 8170, 5353, 7783, 4308, 7492, 2964, 7428, 8536],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4742, 9342, 8658, 596, 4872, 9453, 9374, 7173, 3316, 9466, 8541],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7810, 2096, 7718, 1493, 6531, 9966, 1057, 934, 9474, 1418, 8547],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1636, 4443, 9381, 6865, 2074, 7151, 7949, 3511, 917, 3286, 8552],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3423, 211, 9072, 933, 638, 5857, 46, 8193, 7127, 5067, 8557],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8237, 9622, 7781, 9619, 6873, 9312, 616, 6816, 7587, 6763, 8562],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6427, 2970, 8793, 3116, 2606, 5249, 7982, 9776, 1779, 8374, 8567],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4002, 5259, 9421, 9441, 3852, 6274, 7214, 6033, 9188, 9898, 8572],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6817, 3646, 5575, 5907, 3612, 3978, 1744, 3113, 9298, 1337, 8578],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2969, 1336, 9092, 2187, 9376, 6256, 4887, 7114, 1594, 2691, 8583],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8360, 5996, 3993, 6996, 2889, 7335, 1283, 2715, 5564, 3958, 8588],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9294, 3967, 1229, 264, 8268, 9978, 8248, 3175, 694, 5140, 8593],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5098, 7151, 4835, 4017, 3139, 9377, 7043, 345, 6473, 6235, 8598],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5579, 7347, 7922, 7815, 6080, 8189, 4054, 4667, 2389, 7245, 8603],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6670, 7343, 6188, 8539, 2194, 2237, 1889, 5182, 7933, 8168, 8608],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1549, 7028, 902, 9432, 7271, 6335, 385, 9535, 2595, 9006, 8613],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [585, 5741, 3149, 9502, 9578, 9753, 7536, 3979, 5868, 9757, 8618],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2103, 9024, 6730, 1616, 6921, 791, 328, 3384, 7243, 422, 8624],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6900, 7941, 8086, 5743, 5231, 9967, 5486, 1234, 6214, 1001, 8629],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9549, 8922, 7070, 2796, 3556, 1309, 150, 9642, 2274, 1494, 8634],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [340, 4596, 979, 4244, 8923, 1240, 2441, 9346, 4920, 1900, 8639],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8842, 9159, 4010, 3057, 3207, 4558, 1963, 9721, 3647, 2220, 8644],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2667, 6814, 2909, 2532, 2728, 6992, 206, 8780, 7952, 2453, 8649],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6240, 2055, 4018, 989, 9963, 3850, 866, 3180, 7333, 2600, 8654],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2370, 433, 3909, 2230, 5380, 4241, 77, 8228, 1287, 2661, 8659],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8668, 1191, 1276, 3817, 6057, 366, 6561, 7884, 9315, 2634, 8664],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4182, 670, 7409, 7666, 6389, 1395, 1685, 4770, 917, 2522, 8669],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2248, 5605, 1432, 27, 4850, 1409, 9438, 168, 5594, 2322, 8674],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9512, 2133, 9138, 529, 9421, 918, 6316, 4034, 2847, 2036, 8679],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9946, 6806, 4743, 2623, 2987, 1458, 1123, 4995, 2180, 1663, 8684],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5874, 404, 6856, 182, 8638, 2755, 4685, 357, 3097, 1203, 8689],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5734, 5232, 6369, 7384, 3512, 1984, 9477, 6112, 5101, 656, 8694],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3717, 3186, 7568, 947, 8495, 4594, 9162, 6941, 7699, 22, 8699],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8197, 5218, 6413, 5465, 9748, 6238, 8046, 6218, 397, 9302, 8703],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9869, 219, 3453, 3741, 6774, 5284, 443, 6017, 2702, 8494, 8708],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1862, 6005, 4092, 4655, 367, 5432, 9954, 7113, 4122, 7599, 8713],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7659, 5082, 6699, 1094, 2544, 7936, 8660, 8995, 4166, 6617, 8718],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4616, 4483, 9276, 9741, 9219, 2945, 6228, 9862, 2344, 5548, 8723],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7471, 5600, 7851, 2991, 5125, 9465, 8925, 6632, 8167, 4391, 8728],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4444, 918, 3394, 828, 9158, 3451, 8556, 4948, 1146, 3148, 8733],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3082, 3377, 7610, 7088, 7094, 3555, 1299, 9181, 793, 1817, 8738],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5188, 2847, 9534, 55, 7301, 4018, 6468, 2433, 6623, 398, 8743],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3520, 1540, 2047, 1686, 3815, 4240, 5179, 6548, 8148, 8892, 8747],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9205, 664, 7496, 2896, 9907, 4525, 8932, 2110, 4885, 7299, 8752],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2102, 3042, 1103, 4126, 3958, 7531, 8105, 8453, 6348, 5618, 8757],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6479, 2661, 6046, 749, 8245, 4918, 362, 3663, 2056, 3850, 8762],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8134, 6081, 640, 1796, 9963, 8739, 8969, 4581, 1525, 1994, 8767],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1415, 6500, 1186, 7682, 2577, 7063, 1030, 6816, 4274, 50, 8772],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6382, 2944, 8469, 8269, 4342, 3362, 5627, 4738, 9823, 8018, 8776],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2825, 6159, 5878, 6374, 9597, 9185, 1877, 1494, 7692, 5899, 8781],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3053, 7994, 6403, 3814, 7213, 9625, 6904, 9004, 7401, 3692, 8786],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6955, 6710, 7627, 7115, 9335, 1105, 3716, 7973, 8474, 1397, 8791],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3178, 5177, 1112, 7973, 2345, 1013, 8997, 7889, 433, 9015, 8795],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7168, 4237, 7540, 9443, 743, 8690, 816, 7035, 2802, 6544, 8800],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [880, 3234, 3494, 2506, 3446, 7314, 6244, 2485, 5106, 3985, 8805],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9966, 8184, 1202, 8993, 775, 6189, 8879, 118, 6870, 1338, 8810],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4419, 9299, 9808, 5884, 9226, 2966, 6291, 4617, 7620, 8603, 8814],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4136, 5533, 6170, 2475, 9876, 5334, 7373, 9474, 6884, 5780, 8819],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [881, 3995, 4793, 5866, 5134, 1686, 9609, 6997, 4191, 2869, 8824],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1127, 1299, 9696, 1563, 7318, 306, 6247, 8314, 9069, 9869, 8828],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2152, 2261, 4799, 4524, 1361, 6601, 3390, 3376, 1049, 6782, 8833],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3086, 1908, 2328, 1744, 2792, 7895, 6998, 963, 9661, 3605, 8838],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3081, 5262, 8770, 330, 923, 5336, 9797, 8690, 4436, 341, 8843],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9110, 2472, 2696, 4834, 6041, 2425, 8104, 3010, 4909, 6988, 8847],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6537, 1313, 5345, 4366, 8212, 9718, 8562, 9218, 611, 3547, 8852],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8564, 286, 9933, 3617, 4147, 5218, 4791, 1458, 1079, 17, 8857],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6424, 6692, 5298, 2187, 7436, 9999, 3939, 2725, 5846, 6398, 8861],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2882, 4545, 9498, 3604, 6286, 8600, 3160, 4872, 4449, 2691, 8866],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1916, 2004, 4490, 8940, 1764, 3711, 5990, 8613, 6425, 8895, 8870],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [720, 6009, 8892, 9883, 8397, 4699, 8641, 3529, 1313, 5011, 8875],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2941, 5049, 6265, 2545, 7842, 9512, 6207, 8072, 8650, 1037, 8880],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2975, 3289, 5263, 5892, 5209, 9484, 8779, 9568, 7977, 6975, 8884],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8097, 5165, 8743, 7598, 6497, 6598, 7470, 4225, 8835, 2824, 8889],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7758, 3199, 4375, 5073, 4454, 2738, 354, 7135, 764, 8585, 8893],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7210, 5711, 1941, 432, 9083, 467, 8315, 2277, 3308, 4256, 8898],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1341, 5307, 4347, 5132, 7881, 4884, 807, 2529, 6009, 9838, 8902],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5746, 9530, 1876, 2779, 9798, 6087, 1527, 9662, 8411, 5331, 8907],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [932, 3189, 3538, 7170, 5778, 1802, 3995, 4353, 61, 736, 8912],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3313, 2715, 6038, 6873, 7677, 9706, 7046, 6186, 503, 6051, 8916],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9266, 4652, 162, 7437, 6214, 9005, 240, 3658, 9285, 1276, 8921],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [869, 2751, 5838, 7637, 7556, 797, 9171, 4179, 5954, 6413, 8925],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7466, 1778, 146, 6878, 7024, 6781, 693, 4086, 59, 1461, 8930],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3452, 1124, 5830, 6863, 7337, 5849, 8063, 8635, 1149, 6419, 8934],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1782, 6145, 9771, 1937, 7729, 8117, 5981, 2018, 8776, 1287, 8939],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7468, 6094, 9325, 8840, 9194, 5940, 5553, 7358, 2489, 6067, 8943],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [527, 6647, 6803, 8081, 62, 1465, 9157, 6718, 1842, 757, 8948],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6412, 173, 5719, 5511, 5010, 265, 5223, 1106, 6388, 5357, 8952],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6578, 9823, 3212, 3937, 9593, 625, 2924, 476, 5680, 9868, 8956],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1354, 9046, 7451, 653, 1291, 8009, 6775, 3735, 9273, 4289, 8961],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7570, 3478, 2357, 7502, 7028, 4274, 1147, 8749, 6723, 8621, 8965],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3987, 5118, 2, 5389, 6080, 1198, 4683, 2342, 7588, 2863, 8970],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1784, 7352, 8121, 5035, 6220, 7849, 4633, 307, 1424, 7016, 8974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8009, 638, 739, 9996, 9947, 1379, 1099, 7406, 7789, 1078, 8979],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8883, 7129, 7783, 6560, 6579, 787, 1180, 7375, 6244, 5051, 8983],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2592, 9878, 8138, 8012, 4970, 3208, 3041, 2930, 6349, 8934, 8987],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5001, 5856, 2838, 7674, 603, 2298, 9884, 5770, 7664, 2727, 8992],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8805, 3929, 3610, 6240, 9759, 8262, 3829, 6584, 9752, 6430, 8996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [967, 5056, 8762, 3914, 2473, 9103, 9711, 5049, 2176, 44, 9001],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1606, 901, 5159, 6767, 4960, 2627, 8780, 9843, 4499, 3567, 9005],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4506, 9047, 2955, 9430, 1195, 8804, 2313, 8643, 6287, 7000, 9009],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6379, 8996, 9629, 2651, 2319, 2012, 5144, 8130, 7105, 343, 9014],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9703, 3887, 1980, 4243, 1549, 2757, 9088, 3997, 6520, 3596, 9018],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8902, 7589, 9100, 5482, 1286, 8416, 6291, 951, 4099, 6759, 9022],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4139, 2587, 5284, 2026, 8097, 2580, 2482, 2716, 9410, 9831, 9026],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2676, 4570, 8465, 8670, 288, 2564, 131, 2039, 2023, 2814, 9031],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2528, 4212, 5707, 896, 1799, 4639, 1527, 694, 1508, 5706, 9035],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1430, 9413, 587, 2839, 5147, 6581, 1758, 9487, 7435, 8507, 9039],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [492, 69, 5849, 1139, 5224, 7081, 1603, 8259, 9378, 1218, 9044],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7830, 2812, 5654, 6913, 4724, 1601, 334, 5891, 6909, 3839, 9048],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [769, 7465, 2121, 3748, 1067, 4247, 8425, 307, 9602, 6369, 9052],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3530, 3310, 6906, 8119, 3679, 5227, 177, 8483, 7030, 8809, 9056],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2856, 4749, 6515, 9808, 9577, 3475, 6245, 6442, 8771, 1158, 9061],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2954, 4259, 5337, 3702, 4212, 4009, 6078, 9269, 4400, 3417, 9065],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3928, 5714, 8209, 712, 3608, 9597, 269, 1108, 3496, 5585, 9069],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3676, 9753, 9488, 4314, 2882, 6321, 2815, 5167, 5635, 7662, 9073],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6079, 7843, 2321, 347, 5285, 2599, 3281, 3726, 398, 9649, 9077],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5417, 854, 4031, 1092, 4970, 1256, 8880, 8137, 7364, 1544, 9082],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [809, 3363, 4720, 220, 5781, 4215, 6459, 8832, 6115, 3349, 9086],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4977, 1807, 9366, 2803, 7400, 9395, 4395, 5323, 6233, 5063, 9090],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2818, 510, 1474, 4235, 9296, 9392, 4400, 6209, 7300, 6686, 9094],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1998, 3383, 996, 3390, 1981, 1528, 3234, 9180, 8900, 8218, 9098],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5946, 119, 2451, 8702, 4177, 8845, 4326, 1020, 619, 9660, 9102],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7343, 2694, 2395, 843, 3588, 1642, 9314, 7612, 2040, 1010, 9107],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1210, 8460, 9553, 2363, 8047, 9119, 9475, 3943, 2752, 2269, 9111],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5377, 5148, 6508, 2837, 2947, 734, 7087, 4106, 2341, 3437, 9115],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4176, 2605, 9042, 7676, 9916, 6840, 6676, 1305, 396, 4514, 9119],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5658, 3815, 7702, 9775, 850, 8214, 6195, 7860, 6505, 5499, 9123],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5734, 6576, 5191, 5367, 497, 4033, 8094, 5210, 260, 6394, 9127],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2577, 3850, 1693, 8895, 9917, 7923, 306, 3919, 1251, 7197, 9131],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7772, 5475, 6650, 6175, 2264, 1646, 7146, 3675, 9070, 7908, 9135],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5275, 8948, 7906, 607, 1438, 6015, 107, 3303, 3310, 8529, 9139],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9329, 6193, 5123, 3537, 3313, 8653, 8579, 758, 3565, 9058, 9143],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3935, 1095, 1246, 7061, 8360, 8162, 465, 3141, 9429, 9495, 9147],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2954, 3063, 339, 5425, 3617, 4312, 2711, 6691, 498, 9842, 9151],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [143, 8073, 8758, 9679, 1110, 3834, 1743, 6799, 6369, 96, 9156],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4129, 1229, 5393, 9274, 8972, 1425, 3815, 8006, 6639, 259, 9160],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7563, 2007, 1210, 3741, 638, 5555, 5261, 4010, 907, 331, 9164],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5998, 9093, 3773, 7433, 6668, 8661, 2661, 7669, 8771, 310, 9168],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3796, 5805, 3565, 347, 2899, 1359, 2911, 1004, 9833, 198, 9172],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4644, 3584, 251, 8282, 7766, 232, 3200, 5205, 3692, 9995, 9175],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5851, 7828, 2475, 5898, 845, 8833, 902, 634, 9952, 9699, 9179],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1212, 8135, 7932, 6514, 3772, 1470, 3374, 6828, 8214, 9312, 9183],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9830, 6542, 4564, 2648, 3934, 9407, 7652, 2505, 8084, 8833, 9187],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1272, 6539, 1564, 1270, 446, 9056, 75, 5568, 9165, 8262, 9191],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4953, 6714, 2813, 7418, 1147, 1781, 5798, 3104, 1064, 7600, 9195],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8221, 9839, 7462, 9092, 8512, 4915, 8222, 1396, 3387, 6845, 9199],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8333, 3328, 4198, 5156, 1566, 3595, 8336, 5921, 5741, 5998, 9203],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2617, 1012, 8491, 6202, 89, 3013, 3957, 1356, 7736, 5059, 9207],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1427, 6399, 6681, 5918, 6590, 711, 8886, 1580, 8980, 4028, 9211],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9204, 7972, 7470, 7283, 719, 8511, 1967, 9683, 9083, 2905, 9215],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3365, 6858, 350, 3920, 8, 3688, 6061, 7962, 7658, 1690, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3006, 378, 1325, 1929, 21, 9015, 6915, 7933, 4316, 383, 9223],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [524, 9457, 8202, 1556, 6221, 1270, 1956, 330, 8671, 8983, 9226],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2066, 4465, 9657, 897, 9063, 7832, 8974, 5108, 335, 7492, 9230],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5816, 6192, 2593, 5515, 3049, 969, 4733, 1453, 8925, 5907, 9234],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7861, 940, 9253, 8197, 9706, 9436, 3468, 7778, 4055, 4231, 9238],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1384, 6749, 6589, 2039, 3665, 7008, 5312, 1732, 5344, 2462, 9242],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4535, 6962, 3094, 7476, 258, 7538, 4610, 203, 2408, 601, 9246],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3314, 2360, 9356, 9800, 2293, 6187, 8156, 9320, 4865, 8647, 9249],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3308, 6953, 4744, 7874, 2875, 6424, 3329, 4460, 2337, 6601, 9253],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5768, 6020, 9886, 7181, 420, 2419, 6141, 247, 4443, 4462, 9257],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4402, 5613, 8794, 954, 1234, 6451, 9188, 561, 804, 2231, 9261],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3775, 4309, 1058, 1696, 4277, 952, 9516, 8539, 1042, 9907, 9264],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2796, 9574, 8384, 2015, 2004, 4805, 6383, 6579, 4782, 7490, 9268],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [726, 6413, 5634, 8116, 406, 3518, 8942, 6343, 1647, 4981, 9272],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6690, 2669, 8601, 1466, 664, 2903, 3819, 8764, 1262, 2379, 9276],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4986, 4129, 2989, 4079, 4062, 5878, 2606, 4045, 3254, 9684, 9279],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7256, 6630, 4869, 267, 1116, 2021, 9260, 1666, 7249, 6896, 9283],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [454, 6518, 5455, 2707, 5095, 9496, 7404, 389, 2875, 4016, 9287],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7023, 722, 5102, 2977, 9441, 8990, 7546, 8257, 9760, 1042, 9291],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5623, 9476, 5344, 6401, 7829, 9275, 4192, 2602, 7536, 7976, 9294],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8059, 3600, 5598, 7891, 4926, 4031, 2877, 46, 5832, 4817, 9298],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8006, 8646, 4416, 9464, 5171, 9561, 7095, 6506, 4279, 1565, 9302],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9603, 2148, 5290, 1124, 6207, 3026, 5146, 7199, 2511, 8220, 9305],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5905, 7450, 4646, 4747, 2873, 831, 6876, 6642, 161, 4782, 9309],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3172, 4181, 5624, 5387, 6990, 6794, 337, 8660, 6863, 1250, 9313],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7577, 3614, 5376, 5965, 7436, 9739, 8349, 6384, 2253, 7626, 9316],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7059, 4150, 5995, 9482, 4354, 134, 4967, 2263, 5967, 3908, 9320],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5870, 9899, 8987, 7657, 619, 5421, 1853, 8059, 7641, 97, 9324],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6181, 9475, 9653, 6105, 3008, 3669, 4567, 4855, 6915, 6193, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8166, 1440, 9424, 3765, 4845, 5190, 8748, 3059, 3427, 2196, 9331],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1829, 8644, 9494, 8171, 1197, 1751, 6215, 2407, 6817, 8105, 9334],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8606, 8992, 5939, 8220, 7037, 3024, 966, 1965, 6726, 3921, 9338],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4438, 9083, 2475, 2254, 8100, 9921, 5090, 133, 2796, 9644, 9341],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1962, 4129, 9443, 1443, 3507, 4439, 4584, 4652, 4669, 5273, 9345],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5153, 6996, 3222, 6530, 8559, 5670, 5070, 2603, 1990, 809, 9349],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8459, 4232, 5750, 9871, 5436, 1620, 7431, 413, 4403, 6251, 9352],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1479, 9452, 5199, 4360, 8885, 6464, 3341, 3859, 1553, 1600, 9356],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4880, 3807, 2040, 6015, 3324, 2906, 713, 8069, 3087, 6855, 9359],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6222, 6070, 5043, 7825, 7147, 9264, 9041, 7527, 8653, 2016, 9363],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1100, 4031, 4457, 8658, 9345, 952, 4663, 6080, 7899, 7084, 9366],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4594, 3275, 9244, 2593, 2940, 5984, 5913, 6934, 474, 2059, 9370],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8925, 2792, 6384, 886, 9070, 4159, 8199, 2664, 6029, 6939, 9373],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5506, 7647, 6785, 735, 4942, 9585, 8969, 5215, 4214, 1726, 9377],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1153, 9372, 8026, 2096, 8218, 6167, 2598, 5906, 4682, 6419, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6968, 198, 2282, 5800, 9786, 5741, 5169, 5431, 7086, 1018, 9384],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9598, 5748, 1361, 3145, 6234, 8481, 9170, 3867, 1080, 5524, 9387],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2057, 2302, 2437, 8837, 2718, 5245, 8093, 675, 6319, 9935, 9390],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5421, 512, 16, 5524, 6314, 1512, 937, 4703, 2458, 4253, 9394],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1010, 9416, 4012, 9169, 9294, 2565, 6621, 4188, 9155, 8476, 9397],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7053, 4795, 1931, 3, 1200, 9572, 8302, 6765, 6067, 2606, 9401],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [977, 5954, 6449, 3683, 7927, 6222, 7600, 9465, 2853, 6642, 9404],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5622, 5037, 9017, 1534, 5481, 5589, 8723, 8720, 9173, 583, 9408],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2418, 1839, 5969, 7165, 5410, 6853, 2507, 368, 4688, 4431, 9411],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9075, 719, 6341, 9350, 8371, 1568, 357, 9653, 9057, 8184, 9414],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8673, 8169, 9956, 7668, 1648, 9120, 8091, 1231, 1946, 1844, 9418],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2054, 9289, 9908, 7942, 5880, 1036, 9701, 9175, 3015, 5409, 9421],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8740, 4612, 4541, 8924, 5653, 3823, 1002, 6975, 1931, 8880, 9424],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9017, 6026, 9268, 9826, 8025, 9976, 3206, 7540, 8358, 2256, 9428],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3713, 7444, 6570, 115, 2478, 6842, 6390, 3207, 1963, 5539, 9431],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6550, 1939, 1474, 8345, 5201, 2987, 2870, 5741, 2412, 8727, 9434],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1427, 5172, 7589, 5682, 61, 1751, 486, 6337, 9374, 1820, 9438],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [975, 1074, 2868, 1982, 7993, 1635, 5790, 5625, 2518, 4820, 9441],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1374, 8176, 1814, 7779, 6038, 3216, 7139, 3675, 1514, 7725, 9444],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3777, 3608, 8811, 4274, 6646, 2228, 7695, 9997, 6032, 535, 9448],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5230, 7952, 1973, 5167, 7305, 8508, 8328, 3546, 5746, 3251, 9451],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [200, 9569, 4769, 8972, 27, 459, 431, 2726, 327, 5873, 9454],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5181, 3692, 9311, 8178, 9630, 4705, 8628, 5389, 9449, 8399, 9457],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5285, 898, 6332, 2074, 9225, 626, 3405, 8847, 2787, 832, 9461],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6672, 1870, 7569, 3313, 764, 9418, 3628, 9865, 17, 3170, 9464],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8161, 9521, 1433, 4126, 7962, 7378, 8984, 4671, 816, 5413, 9467],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [585, 2080, 7051, 6443, 8350, 3087, 2311, 8959, 4860, 7561, 9470],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6345, 5687, 9162, 1017, 699, 8148, 1844, 7887, 1829, 9615, 9473],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6313, 3092, 930, 3741, 3497, 1177, 3367, 6086, 1402, 1574, 9477],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9792, 3081, 6910, 2765, 9654, 4723, 2259, 7661, 3259, 3438, 9480],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1965, 6047, 7631, 7545, 2047, 4786, 5461, 6193, 7082, 5207, 9483],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7610, 2288, 3251, 508, 4030, 2616, 3335, 4745, 2553, 6882, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1603, 3780, 9250, 3604, 8470, 8490, 1434, 5862, 9355, 8461, 9489],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3902, 3663, 4386, 5400, 8397, 7127, 2180, 1576, 7173, 9946, 9492],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4534, 851, 2080, 9532, 1788, 4437, 6439, 3409, 5691, 1336, 9496],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9267, 2950, 2749, 2223, 2538, 5285, 5008, 2377, 4596, 2631, 9499],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1344, 5016, 7625, 4963, 9124, 1960, 6, 8991, 3574, 3831, 9502],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4667, 2166, 5332, 8389, 1998, 3028, 6166, 3260, 2315, 4936, 9505],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5670, 123, 1656, 4692, 199, 2253, 2038, 4699, 506, 5946, 9508],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3124, 9555, 895, 8494, 7206, 7291, 1091, 2325, 7838, 6860, 9511],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7742, 8560, 4005, 9922, 5551, 7830, 2726, 4665, 4001, 7680, 9514],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2600, 3518, 4209, 8519, 9196, 2865, 3188, 9758, 8687, 8404, 9517],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5591, 2184, 4321, 2542, 2214, 6816, 6385, 5157, 1590, 9034, 9520],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5048, 3734, 790, 5034, 1806, 4157, 4617, 7934, 2402, 9568, 9523],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7328, 6250, 6322, 5693, 3216, 2273, 9200, 4680, 819, 7, 9527],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5402, 8938, 4367, 5952, 3603, 2219, 1003, 1513, 6536, 350, 9530],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9103, 7528, 2983, 3659, 1475, 7086, 886, 4074, 9249, 598, 9533],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2085, 7495, 524, 3318, 7794, 7666, 45, 7537, 8656, 751, 9536],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [553, 7990, 8859, 7794, 4400, 5119, 258, 6608, 4456, 809, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8390, 3069, 8688, 7731, 4926, 324, 4039, 5529, 6348, 771, 9542],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7183, 4720, 3006, 5470, 2907, 9634, 4694, 8082, 4032, 638, 9545],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4089, 8511, 5562, 1007, 1333, 6715, 6289, 7590, 7210, 409, 9548],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3369, 6161, 7629, 8288, 7421, 181, 3509, 6922, 5584, 85, 9551],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9239, 2957, 4695, 874, 5940, 6725, 1432, 8494, 8857, 9665, 9553],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2331, 8596, 548, 6632, 3936, 9439, 5209, 4273, 6734, 9150, 9556],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7202, 7784, 5167, 1476, 9309, 1040, 9640, 5781, 8919, 8539, 9559],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6510, 4868, 40, 2240, 5170, 1700, 8657, 4097, 5119, 7833, 9562],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6003, 191, 4946, 8383, 1535, 1177, 4719, 9859, 5040, 7031, 9565],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5804, 2337, 8384, 1382, 5414, 4969, 8101, 3267, 8392, 6133, 9568],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4598, 8686, 4107, 9129, 9933, 4188, 6095, 4089, 4882, 5140, 9571],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5026, 6867, 2567, 487, 2714, 8862, 2109, 1660, 4221, 4051, 9574],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3855, 2343, 2266, 2148, 3241, 4373, 4678, 4886, 6119, 2866, 9577],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2263, 3335, 5454, 6028, 8591, 753, 6370, 2249, 289, 1586, 9580],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9916, 4210, 8436, 558, 6404, 4533, 2604, 1808, 6443, 209, 9583],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4401, 2244, 1825, 3239, 3586, 2862, 371, 1201, 4295, 8737, 9585],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6261, 9156, 2962, 4665, 8813, 9615, 6853, 7649, 3559, 7169, 9588],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2857, 5406, 3676, 5786, 6457, 3200, 7957, 7961, 3952, 5505, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9754, 7187, 3544, 332, 9171, 5770, 6739, 8533, 5190, 3745, 9594],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1464, 6556, 3618, 3054, 5931, 3574, 1748, 5353, 6991, 1889, 9597],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5570, 4270, 9476, 1558, 1944, 8144, 5260, 4002, 9073, 9937, 9599],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2701, 9913, 6723, 4990, 6393, 8050, 1427, 9661, 1155, 7890, 9602],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8870, 8016, 7434, 6530, 3620, 938, 4322, 7108, 2959, 5746, 9605],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3917, 1813, 3105, 8537, 2912, 5561, 5890, 726, 4206, 3506, 9608],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9277, 2791, 8776, 9058, 1680, 3540, 3810, 4503, 4617, 1170, 9611],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2651, 4751, 4036, 6310, 6408, 562, 9249, 2034, 3917, 8738, 9613],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2437, 438, 9392, 3415, 5362, 6748, 4528, 6528, 1829, 6210, 9616],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8207, 6549, 421, 9196, 6656, 5903, 693, 805, 8080, 3585, 9619],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9273, 2204, 6377, 1916, 4886, 3386, 4982, 7302, 2394, 865, 9622],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6058, 3921, 3348, 1622, 9139, 2312, 8203, 8077, 4500, 8048, 9624],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4621, 6831, 3383, 2855, 4840, 7825, 2013, 4810, 4126, 5135, 9627],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9605, 315, 8396, 3114, 1471, 9154, 6103, 8803, 1000, 2126, 9630],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7683, 1884, 9339, 3244, 7854, 9196, 5282, 989, 4854, 9020, 9632],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4849, 3420, 4815, 3955, 6300, 1348, 6470, 1929, 5417, 5818, 9635],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9875, 8051, 6483, 7783, 6555, 3310, 5589, 1818, 2422, 2520, 9638],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4965, 4360, 8634, 7897, 107, 7608, 4366, 486, 5602, 9125, 9640],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8786, 8770, 3046, 4134, 5045, 8550, 7032, 7401, 4690, 5634, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8416, 8800, 4487, 2442, 1305, 5368, 6927, 1673, 9423, 2046, 9646],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1792, 1493, 3346, 6404, 5771, 1255, 3009, 2055, 9535, 8362, 9648],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8101, 4832, 6142, 8585, 6340, 8060, 6266, 6945, 4763, 4582, 9651],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [602, 6712, 7891, 5078, 3702, 6352, 6036, 4392, 4846, 705, 9654],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6873, 6625, 8175, 8613, 9237, 605, 6221, 2095, 9522, 6731, 9656],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5754, 9076, 694, 3942, 7083, 9241, 1411, 7408, 8530, 2661, 9659],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8257, 2378, 9113, 3749, 8059, 9257, 2916, 7340, 1612, 8495, 9661],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9368, 7930, 5055, 4031, 2817, 5195, 4689, 8561, 8509, 4231, 9664],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9746, 6571, 1752, 4550, 1217, 2177, 9162, 7402, 8964, 9871, 9666],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4651, 1156, 3376, 2647, 4604, 2762, 2983, 9860, 2720, 5415, 9669],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5896, 5828, 9670, 7120, 7314, 7358, 2656, 1596, 9523, 861, 9672],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7667, 7152, 1836, 3095, 3412, 7935, 85, 7943, 9116, 6211, 9674],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6039, 1107, 2363, 8642, 4311, 4783, 8019, 3904, 1248, 1465, 9677],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7716, 9811, 1901, 9301, 2626, 6067, 5402, 4160, 5665, 6621, 9679],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3424, 5225, 3405, 7467, 7244, 9913, 2628, 3066, 2116, 1681, 9682],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3622, 1793, 369, 9806, 4307, 8787, 6697, 4657, 350, 6644, 9684],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8014, 8909, 4704, 7277, 8459, 5899, 6273, 2652, 118, 1510, 9687],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2255, 4699, 2777, 8948, 8387, 3401, 6648, 453, 1171, 6279, 9689],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [694, 6817, 7514, 2414, 387, 2110, 4608, 1150, 3261, 951, 9692],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3710, 9670, 2029, 274, 3342, 2518, 3202, 7522, 6141, 5526, 9694],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9855, 290, 7410, 3558, 8219, 6846, 6414, 2040, 9567, 4, 9697],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7911, 87, 5503, 9292, 4852, 1881, 3740, 6871, 3292, 4386, 9699],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8522, 2988, 7734, 252, 8489, 2358, 4662, 3877, 7074, 8670, 9701],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6734, 964, 3967, 508, 8261, 4650, 3034, 4621, 669, 2858, 9704],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5491, 6977, 1758, 284, 9456, 505, 1365, 367, 3836, 6948, 9706],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3283, 6574, 6341, 8050, 1135, 604, 5004, 2083, 6333, 941, 9709],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1728, 8039, 5337, 6379, 377, 7683, 6233, 445, 7921, 4837, 9711],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7980, 4220, 9406, 929, 4103, 8995, 8261, 5837, 8360, 8636, 9713],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9987, 5081, 307, 8846, 9170, 7856, 9117, 8355, 7413, 2338, 9716],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [772, 7894, 557, 3757, 1118, 4046, 5451, 7809, 4843, 5943, 9718],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2264, 1697, 3062, 9375, 1647, 2818, 6235, 3724, 414, 9451, 9720],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2231, 4437, 3668, 2292, 4668, 2295, 6369, 5345, 3890, 2861, 9723],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7861, 5432, 3132, 6880, 416, 8999, 187, 1638, 5038, 6174, 9725],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9432, 2700, 5872, 1115, 6908, 1285, 4871, 1290, 3624, 9390, 9727],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7143, 3870, 9270, 1561, 7675, 456, 3757, 2717, 9416, 2508, 9730],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5884, 9894, 7068, 8577, 4489, 9305, 9557, 4060, 2183, 5530, 9732],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1304, 435, 1248, 8955, 3480, 7870, 7478, 3193, 1695, 8454, 9734],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5443, 5262, 6140, 2556, 2789, 6164, 8238, 7720, 7722, 1280, 9737],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2150, 2265, 3611, 1990, 9635, 3647, 994, 4982, 37, 4010, 9739],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2589, 2909, 5891, 9864, 4401, 5219, 6167, 2054, 8412, 6641, 9741],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3263, 1218, 9861, 6581, 9076, 3490, 8173, 5754, 2620, 9176, 9743],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5500, 1220, 9726, 2883, 7125, 7125, 8052, 2640, 2437, 1613, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5351, 6305, 420, 5332, 1619, 5009, 6006, 9014, 7637, 3952, 9748],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3338, 5108, 7765, 9522, 8172, 6027, 3832, 924, 7999, 6194, 9750],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3650, 2264, 9228, 4976, 8989, 4232, 7265, 4166, 3298, 8339, 9752],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9618, 5092, 6699, 7223, 4072, 9164, 8217, 4288, 3314, 386, 9755],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2069, 1704, 5392, 6521, 5392, 1113, 6926, 6590, 7826, 2335, 9757],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3834, 969, 5946, 8819, 9557, 1101, 3996, 6127, 6615, 4187, 9759],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4980, 4832, 5027, 2869, 4293, 5357, 2353, 7711, 9462, 5941, 9761],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6273, 8699, 7856, 7752, 3778, 4066, 9095, 5913, 6150, 7598, 9763],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7355, 1555, 8686, 7390, 7661, 4184, 7244, 5068, 6462, 9157, 9765],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3766, 4512, 6546, 2760, 8315, 6089, 7405, 9272, 182, 619, 9768],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5803, 9984, 7664, 8447, 675, 3856, 9325, 2388, 7097, 1982, 9770],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9381, 3503, 6641, 7735, 8757, 8939, 3352, 8048, 6991, 3248, 9772],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1798, 504, 9405, 9553, 2707, 7058, 1803, 9652, 9653, 4416, 9774],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8629, 9569, 5557, 1195, 32, 8048, 225, 374, 4872, 5487, 9776],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3905, 3786, 9128, 2662, 4394, 8492, 8567, 3161, 2435, 6460, 9778],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3621, 8770, 8011, 1718, 5163, 6904, 2249, 740, 2134, 7335, 9780],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1369, 8895, 6212, 3102, 654, 1255, 3135, 5612, 3759, 8112, 9782],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5888, 4533, 1988, 827, 7792, 8636, 406, 62, 7104, 8791, 9784],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2000, 8143, 1475, 8899, 695, 6855, 1343, 6156, 1960, 9373, 9786],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9572, 3767, 3495, 3108, 474, 7738, 1999, 5746, 8123, 9856, 9788],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9426, 3580, 8886, 4611, 8294, 1958, 7786, 470, 5388, 242, 9791],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6333, 9279, 8673, 4796, 3578, 5164, 3954, 1757, 3550, 530, 9793],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7183, 378, 1096, 247, 8966, 5205, 5982, 824, 2407, 720, 9795],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [46, 2481, 9342, 6462, 3470, 267, 9862, 8683, 1756, 812, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2196, 4843, 877, 9193, 5048, 7688, 2288, 6142, 1398, 806, 9799],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9331, 7815, 6338, 2735, 3594, 3281, 754, 3803, 1132, 702, 9801],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3563, 8070, 1897, 5252, 5162, 938, 3540, 2069, 759, 500, 9803],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6451, 4986, 4169, 1919, 8033, 2333, 9613, 1144, 81, 200, 9805],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [710, 8033, 1509, 7515, 1009, 6516, 8424, 1036, 8901, 9801, 9806],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [43, 5882, 9975, 705, 4163, 9198, 9608, 1556, 7023, 9305, 9808],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5273, 7259, 6210, 2770, 2025, 1545, 2586, 2324, 4252, 8711, 9810],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6735, 5187, 2769, 3660, 9046, 8261, 6065, 2766, 394, 8019, 9812],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3836, 4436, 3390, 8067, 6932, 4791, 7452, 2122, 5256, 7228, 9814],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5146, 553, 5792, 3445, 3296, 3425, 2153, 9444, 8645, 6339, 9816],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4510, 1302, 6786, 604, 852, 8131, 2787, 3597, 372, 5353, 9818],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3907, 653, 7804, 5487, 6217, 7912, 8298, 3264, 245, 4268, 9820],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9357, 3830, 7031, 7936, 7179, 8503, 2965, 6948, 8075, 3084, 9822],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1133, 554, 5770, 9556, 7112, 2209, 5320, 2969, 3675, 1803, 9824],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1905, 2619, 9736, 8111, 5048, 5706, 6961, 9472, 6856, 423, 9826],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9582, 157, 8899, 121, 9722, 5608, 1276, 4426, 7434, 8945, 9827],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9381, 5543, 130, 6373, 5734, 1621, 2059, 5624, 5222, 7369, 9829],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [771, 628, 3142, 6841, 9808, 7084, 2032, 689, 37, 5695, 9831],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5995, 5520, 9500, 1902, 4921, 6733, 1273, 7073, 1694, 3922, 9833],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3918, 7222, 4360, 5628, 9944, 1478, 5537, 2059, 13, 2051, 9835],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2177, 3568, 8110, 4290, 2244, 38, 4484, 2765, 4811, 81, 9837],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6987, 9318, 7445, 8880, 518, 7221, 9809, 6142, 5908, 8013, 9838],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4534, 1424, 9310, 4310, 4996, 8698, 3274, 8981, 3125, 5847, 9840],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3828, 1364, 3296, 10, 1945, 2070, 4637, 7908, 6284, 3582, 9842],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6729, 3028, 5034, 6657, 9281, 4051, 9485, 9392, 5207, 1219, 9844],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3100, 826, 1026, 1783, 9911, 3604, 6974, 9745, 9718, 8757, 9845],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1728, 7287, 495, 2786, 9262, 829, 7462, 5121, 9642, 6197, 9847],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [747, 1769, 8037, 9457, 3332, 1448, 48, 1522, 4804, 3539, 9849],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6006, 7808, 7903, 9295, 3399, 6697, 13, 4795, 5030, 782, 9851],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8597, 8320, 2311, 7612, 3393, 8462, 6162, 638, 149, 7927, 9852],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6167, 3562, 7517, 609, 5788, 9474, 8065, 4601, 9988, 4972, 9854],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4157, 832, 7918, 3101, 1701, 8401, 3203, 2086, 4378, 1920, 9856],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1261, 7446, 5093, 3305, 760, 9656, 4013, 8348, 3148, 8769, 9857],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1376, 5451, 420, 5029, 6127, 7761, 4837, 8500, 6131, 5519, 9859],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [401, 9231, 1400, 2515, 9948, 6090, 8769, 7512, 3159, 2171, 9861],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2034, 2411, 7688, 5090, 4331, 9823, 4406, 215, 4066, 8724, 9862],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1917, 367, 7339, 7508, 2833, 2944, 2502, 1299, 8685, 5178, 9864],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3510, 6338, 1305, 7354, 7276, 9123, 2515, 5318, 6852, 1534, 9866],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [451, 4805, 8634, 3026, 4590, 6308, 9070, 6690, 8404, 7791, 9867],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1046, 2377, 139, 4503, 8234, 4861, 8307, 9701, 3178, 3950, 9869],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9836, 5631, 8185, 4223, 8619, 9088, 4142, 8503, 1013, 10, 9871],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2418, 3357, 8205, 6962, 6808, 1983, 4427, 7117, 1748, 5971, 9872],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6596, 8135, 7036, 5280, 5657, 3037, 7004, 9436, 5223, 1833, 9874],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [801, 4090, 7386, 1094, 2409, 8947, 5672, 9226, 1280, 7597, 9875],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4092, 2959, 9688, 3866, 6641, 7063, 6048, 126, 9762, 3261, 9877],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8729, 2609, 5300, 1853, 7330, 1422, 1328, 5652, 510, 8828, 9878],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7210, 7592, 1058, 4658, 2668, 1200, 7953, 9195, 3370, 4295, 9880],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [865, 1203, 7305, 2896, 6157, 1434, 1177, 4029, 8188, 9663, 9881],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7424, 7076, 2012, 4010, 2361, 5861, 532, 3304, 4809, 4933, 9883],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9826, 3599, 4859, 2055, 5601, 1704, 5199, 54, 3081, 104, 9885],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8792, 7613, 9112, 3569, 4733, 6273, 9273, 7197, 2851, 5176, 9886],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8708, 9650, 7985, 1232, 7054, 5207, 6940, 7536, 3970, 149, 9888],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6256, 8984, 7479, 1949, 4243, 2223, 7544, 3759, 6288, 5023, 9889],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4089, 3873, 1310, 6056, 3150, 207, 562, 8444, 9655, 9798, 9890],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7337, 4220, 6818, 9479, 4115, 3509, 478, 4056, 3925, 4475, 9892],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7275, 6955, 5132, 818, 9397, 1285, 1560, 2953, 8950, 9052, 9893],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7242, 7929, 5491, 281, 4175, 1744, 2533, 7385, 4584, 3531, 9895],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8152, 9792, 3589, 7204, 2492, 7144, 1159, 9496, 683, 7911, 9896],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1593, 7379, 7987, 7295, 377, 9407, 8716, 1324, 7104, 2191, 9898],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3498, 7175, 7781, 9790, 8292, 6191, 4376, 4807, 3702, 6373, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [313, 4305, 9468, 8182, 4954, 7291, 9485, 1777, 337, 456, 9901],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4578, 112, 1727, 6089, 4454, 1207, 1748, 3970, 6867, 4439, 9902],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6123, 8884, 4009, 1956, 8518, 1760, 9307, 3018, 3153, 8324, 9903],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [895, 8469, 8544, 2661, 5637, 4599, 4729, 461, 9056, 2109, 9905],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9850, 3310, 5654, 6480, 8707, 3460, 8889, 7738, 4437, 5796, 9906],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6161, 8268, 9083, 300, 2712, 6051, 4754, 6197, 9161, 9383, 9907],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3542, 7632, 1056, 4260, 3888, 9405, 1072, 7090, 3091, 2872, 9909],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2423, 7758, 5655, 9048, 1730, 4587, 5959, 1577, 6093, 6261, 9910],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [162, 6775, 3348, 6895, 5075, 597, 385, 730, 8032, 9551, 9911],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [17, 5413, 8374, 6597, 3433, 7353, 1565, 5528, 8775, 2742, 9913],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8205, 4872, 3487, 5798, 4639, 7604, 6252, 6864, 8191, 5834, 9914],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8489, 7698, 2294, 9938, 9798, 7654, 3923, 5545, 6149, 8827, 9915],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4362, 3815, 7059, 6839, 6425, 6757, 9874, 2290, 2519, 1721, 9917],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6626, 5172, 8170, 8574, 575, 5050, 8212, 7737, 7171, 4515, 9918],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6707, 8675, 9190, 8082, 8699, 9902, 4748, 2439, 9979, 7210, 9919],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5046, 8886, 7009, 6792, 9847, 550, 9795, 6867, 814, 9807, 9920],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [543, 760, 8579, 1192, 8783, 879, 856, 1415, 9552, 2303, 9922],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [890, 413, 2262, 778, 477, 240, 5228, 6393, 6066, 4701, 9923],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4522, 1188, 1154, 6976, 6373, 2163, 2494, 2038, 234, 7000, 9924],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6926, 6098, 5841, 2431, 2741, 858, 6923, 8507, 1931, 9199, 9925],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3243, 9540, 2881, 2301, 1343, 5354, 9766, 5884, 1037, 1299, 9927],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2829, 4700, 570, 3874, 2588, 1181, 1459, 4179, 7430, 3299, 9928],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [820, 2304, 2970, 7803, 1242, 9455, 3717, 3326, 990, 5201, 9929],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6302, 5413, 4249, 3402, 4713, 3249, 1543, 3191, 1598, 7003, 9930],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1171, 8088, 5504, 1720, 3839, 1136, 5120, 3567, 9136, 8705, 9931],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7494, 7099, 2732, 3382, 6055, 7774, 1619, 4180, 3487, 309, 9933],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9171, 9709, 4621, 3343, 723, 1428, 6903, 4685, 4535, 1813, 9934],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9769, 787, 9410, 1684, 6353, 8297, 7123, 4673, 2165, 3218, 9935],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [870, 3116, 8124, 8238, 9373, 3549, 232, 3668, 6263, 4523, 9936],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3012, 9116, 3912, 9118, 4041, 8928, 7380, 1127, 6716, 5729, 9937],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3438, 3664, 568, 5003, 3012, 6832, 4228, 6448, 3411, 6836, 9938],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [105, 8912, 4332, 4214, 8031, 750, 2148, 8963, 6238, 7843, 9939],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [429, 5445, 8124, 8110, 144, 1940, 9331, 7943, 5087, 8751, 9940],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1578, 1433, 2786, 2023, 8759, 2231, 1797, 2602, 9849, 9559, 9941],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1730, 3857, 2081, 1760, 8824, 2864, 4300, 2090, 415, 269, 9943],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8538, 3931, 3075, 3517, 5349, 9227, 1137, 5503, 6678, 878, 9944],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4048, 2261, 7262, 3748, 4408, 1406, 6860, 1877, 8533, 1388, 9945],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5924, 7058, 6252, 5081, 9724, 431, 6879, 195, 5874, 1799, 9946],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3013, 9072, 4816, 4592, 3875, 115, 7979, 9383, 8596, 2110, 9947],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6748, 6940, 9284, 1608, 3099, 4372, 8727, 8314, 6598, 2322, 9948],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4425, 2794, 6336, 3556, 4627, 9928, 9785, 5808, 9777, 2434, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [903, 5336, 1549, 137, 5420, 4304, 4122, 634, 8032, 2447, 9950],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6542, 500, 4094, 8200, 1120, 8978, 7122, 1508, 1262, 2361, 9951],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8455, 1221, 8953, 1964, 4002, 7621, 6604, 7099, 9368, 2174, 9952],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [337, 9662, 6190, 5640, 8617, 9314, 2729, 6026, 2253, 1889, 9953],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [688, 8164, 3139, 7924, 3828, 6637, 7818, 6859, 9819, 1503, 9954],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6344, 8512, 4935, 164, 9828, 8534, 6063, 8124, 1970, 1019, 9955],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5127, 886, 6461, 2135, 8725, 7870, 3145, 8299, 8611, 434, 9956],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8726, 793, 9229, 1216, 7226, 3560, 5747, 5817, 9648, 9750, 9956],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1050, 9535, 4766, 2241, 9879, 7197, 969, 9069, 4987, 8967, 9957],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1699, 5081, 6180, 6268, 1325, 4075, 5648, 6400, 4537, 8084, 9958],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1550, 7918, 6332, 6932, 5941, 8507, 5569, 6116, 8206, 7101, 9959],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4, 1053, 8816, 2739, 3221, 3368, 4588, 6480, 5904, 6019, 9960],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3642, 4053, 955, 2620, 7202, 3741, 3643, 5715, 7542, 4837, 9961],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6556, 5105, 658, 89, 8201, 4606, 9677, 2004, 3032, 3556, 9962],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4392, 8323, 5144, 8448, 5077, 2460, 4454, 3494, 2286, 2175, 9963],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5643, 9891, 3468, 5435, 6217, 792, 3277, 8291, 5218, 694, 9964],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6660, 8280, 248, 537, 7370, 9325, 3607, 4466, 1744, 9114, 9964],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3437, 1087, 8961, 1712, 4459, 6933, 3586, 54, 1779, 7434, 9965],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9768, 2567, 3347, 403, 9430, 8151, 450, 3055, 5239, 5654, 9966],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2872, 8267, 8554, 4369, 7170, 3200, 8855, 1433, 2043, 3775, 9967],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8974, 995, 3221, 6990, 1505, 1429, 9093, 3122, 2109, 1796, 9968],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8614, 8518, 3292, 9034, 8232, 8106, 5215, 6021, 5357, 9717, 9968],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [758, 8414, 1396, 4565, 3126, 4476, 3054, 7997, 1708, 7539, 9969],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9417, 8345, 5372, 6356, 2814, 988, 8141, 6886, 1084, 5261, 9970],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2904, 7108, 9417, 7975, 6394, 3639, 3530, 496, 3408, 2883, 9971],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7252, 7753, 4347, 9369, 5623, 3336, 7521, 6602, 8602, 405, 9972],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3181, 1344, 2870, 290, 1491, 8205, 1279, 2954, 6593, 7828, 9972],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [246, 8568, 4487, 1140, 4948, 8773, 6360, 7270, 7305, 5151, 9973],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7670, 4709, 5695, 3644, 9548, 5949, 2131, 7245, 666, 2375, 9974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5142, 7066, 7322, 4148, 3711, 1723, 3094, 544, 6604, 9498, 9974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8470, 6420, 5051, 131, 309, 2512, 6109, 4808, 5046, 6522, 9975],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8242, 6926, 3987, 5633, 1237, 5089, 7519, 7653, 5923, 3446, 9976],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [454, 698, 6357, 3652, 4618, 5013, 173, 6671, 9166, 270, 9977],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8855, 1169, 5509, 3020, 2241, 7495, 349, 9428, 4706, 6995, 9977],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1626, 7226, 1926, 3759, 4843, 627, 4581, 3469, 2477, 3620, 9978],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [348, 41, 327, 8337, 2789, 915, 6379, 6317, 2411, 145, 9979],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2791, 6087, 3533, 6476, 9702, 1034, 2859, 5473, 4444, 6570, 9979],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7243, 9867, 918, 8128, 6558, 9757, 1264, 8416, 8511, 2895, 9980],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7718, 3247, 9080, 2816, 3759, 3971, 5394, 2605, 4550, 9121, 9980],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5474, 6936, 2190, 3671, 8648, 2737, 1924, 5481, 2497, 5247, 9981],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [637, 3316, 1256, 990, 5943, 3320, 6636, 4463, 2292, 1273, 9982],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6002, 5565, 7346, 3061, 8512, 9121, 542, 6955, 3874, 7199, 9982],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6500, 445, 5716, 1035, 5926, 9467, 5912, 339, 7185, 3025, 9983],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4494, 3205, 7519, 9865, 8177, 1179, 2198, 1984, 2165, 8752, 9983],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3014, 2294, 5372, 8581, 1963, 1877, 1859, 9239, 8757, 4378, 9984],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9030, 5725, 132, 308, 6885, 4945, 6092, 9438, 6906, 9905, 9984],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4279, 4287, 680, 5452, 8925, 6121, 456, 9901, 6556, 5332, 9985],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [444, 889, 7848, 187, 8538, 1632, 399, 7930, 7653, 659, 9986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1620, 9153, 9592, 6720, 656, 7837, 6683, 814, 144, 5887, 9986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6094, 4118, 8580, 1684, 3941, 2312, 717, 5830, 3975, 1014, 9987],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4782, 7274, 7050, 4318, 6540, 6337, 9776, 237, 9097, 6041, 9987],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6073, 7936, 8626, 6706, 5651, 8715, 2136, 1287, 5458, 969, 9988],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9387, 1420, 3980, 4210, 8136, 885, 2098, 6214, 3009, 5797, 9988],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8916, 7011, 8342, 5203, 9442, 3277, 4913, 2243, 1703, 525, 9989],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [152, 8092, 5029, 5238, 8068, 2854, 1616, 6588, 1491, 5153, 9989],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [142, 2962, 1661, 1690, 2795, 1798, 3749, 6450, 2328, 9681, 9989],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9281, 5044, 5824, 712, 9897, 7289, 7990, 9021, 4168, 4109, 9990],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5936, 9766, 5657, 8810, 7536, 2340, 684, 1484, 6968, 8437, 9990],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5980, 4081, 9342, 6465, 4533, 7623, 2265, 1009, 683, 2666, 9991],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1265, 2217, 6815, 897, 687, 4265, 1592, 4760, 5271, 6794, 9991],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6149, 3775, 8180, 9113, 5829, 7554, 170, 9891, 691, 823, 9992],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9214, 1091, 7225, 816, 4771, 1524, 6285, 3547, 6904, 4751, 9992],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9951, 2074, 6096, 3356, 5284, 4364, 9026, 2867, 3869, 8580, 9992],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9497, 233, 9404, 7688, 6287, 4627, 2220, 4982, 1548, 2309, 9993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5160, 9904, 3644, 5081, 3352, 8188, 8256, 7013, 9904, 5937, 9993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5130, 3710, 1655, 9034, 8670, 5915, 1817, 6079, 8901, 9466, 9993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7118, 10, 2583, 5425, 2607, 2024, 3506, 9288, 8503, 2895, 9994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2853, 6619, 6304, 6166, 3949, 3063, 3376, 3745, 8677, 6224, 9994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2816, 6696, 8001, 7563, 5966, 7515, 4360, 6548, 9388, 9453, 9994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1989, 3748, 4376, 4003, 5384, 5963, 5600, 4790, 605, 2583, 9995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8812, 2632, 8353, 456, 1369, 1796, 5674, 5559, 2296, 5612, 9995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8661, 6906, 4631, 3478, 1618, 2420, 5726, 5938, 4431, 8541, 9995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6314, 1464, 4681, 9799, 2643, 946, 2497, 3006, 6981, 1370, 9996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5900, 1968, 7200, 4165, 1330, 8319, 1251, 3837, 9917, 4099, 9996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8053, 4914, 9171, 3648, 4848, 5862, 8609, 5501, 3212, 6729, 9996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [939, 7264, 3881, 4167, 5997, 8210, 5272, 5067, 6840, 9258, 9996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [641, 2412, 6052, 6290, 1048, 6599, 8656, 9597, 775, 1688, 9997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9655, 6969, 929, 1468, 7154, 2488, 5418, 6153, 4994, 4017, 9997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9770, 4546, 4176, 6519, 6387, 1496, 3886, 1792, 9473, 6246, 9997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9011, 9696, 3009, 3447, 3476, 7611, 6389, 3569, 4189, 8376, 9997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1423, 5715, 6577, 3290, 4282, 7667, 1488, 8538, 9121, 405, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [452, 9403, 5300, 6718, 2088, 6058, 6102, 3748, 4250, 2335, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7999, 6671, 5143, 279, 8743, 9664, 7539, 6249, 9555, 4164, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1263, 4408, 3683, 5564, 7709, 2981, 5428, 3088, 5019, 5894, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6994, 2892, 724, 8912, 6077, 3418, 3543, 1310, 624, 7524, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4049, 2824, 7160, 1591, 2576, 6761, 1538, 7959, 6353, 9053, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4427, 2282, 2077, 4524, 8633, 2773, 6575, 77, 2193, 483, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4795, 9424, 9811, 7468, 9535, 925, 4851, 4707, 8127, 1812, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3686, 1088, 6021, 91, 2718, 6229, 3030, 8889, 4143, 3042, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3183, 7497, 4868, 1348, 234, 5170, 9574, 9662, 229, 4172, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4634, 7766, 8332, 4074, 2445, 1723, 5969, 4067, 6374, 5201, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9239, 5716, 3452, 3441, 9967, 3436, 7856, 9141, 2566, 6131, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6655, 3506, 4173, 954, 914, 7575, 6062, 1923, 8798, 6960, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7465, 1710, 1359, 9813, 478, 7308, 7529, 9450, 5059, 7690, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9729, 5690, 7603, 2604, 9889, 7942, 6142, 8760, 1344, 8320, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3019, 3389, 2713, 8418, 1772, 3184, 3461, 6890, 7646, 8849, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3729, 101, 1216, 3383, 8974, 1416, 9348, 876, 3960, 9279, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8683, 9414, 4975, 6297, 3857, 2008, 2499, 7757, 280, 9609, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9681, 1447, 2021, 9297, 5131, 1620, 873, 4568, 6605, 9838, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1288, 1949, 7000, 2332, 9238, 529, 2021, 8346, 2931, 9968, 9999],
    },
];

// sin(s + pi/2)
pub(crate) const SIN_VALUES2: [BigFloatInc; 1571] = [
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9189, 8037, 9364, 257, 7778, 5277, 6666, 416, 0, 9950, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8668, 7971, 3844, 2698, 7841, 7777, 6657, 6666, 0, 9800, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6662, 3939, 8013, 2319, 1627, 7500, 9898, 3749, 3, 9550, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7388, 2025, 4215, 7431, 4031, 7779, 6097, 6666, 10, 9200, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7932, 3716, 6316, 9512, 4658, 5287, 4496, 416, 26, 8750, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [40, 2587, 4290, 2619, 6571, 41, 3520, 9999, 53, 8200, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8769, 3559, 2978, 1521, 7539, 5420, 326, 415, 100, 7550, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6750, 4621, 5046, 6918, 8790, 8193, 257, 6663, 170, 6800, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7466, 138, 4853, 4806, 6260, 8567, 6188, 3742, 273, 5950, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7058, 2124, 6673, 5220, 9337, 257, 7778, 6652, 416, 5000, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2103, 5079, 7497, 3111, 2111, 594, 617, 392, 610, 3950, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6342, 543, 1471, 868, 2115, 664, 5281, 9958, 863, 2800, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [649, 3455, 9994, 7918, 1564, 5509, 6278, 349, 1190, 1550, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5240, 2892, 8605, 7817, 6091, 4379, 901, 6562, 1600, 200, 9999],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4224, 9060, 9059, 7123, 5966, 1063, 7975, 3591, 2109, 8750, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3121, 5504, 2583, 3164, 4811, 4299, 6508, 6433, 2730, 7200, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7269, 4760, 8149, 9277, 793, 8287, 4243, 81, 3480, 5550, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7156, 6060, 7941, 6307, 5303, 3311, 6107, 9527, 4373, 3800, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8251, 9485, 971, 7827, 4096, 6495, 2558, 9763, 5429, 1950, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8810, 1260, 5263, 3747, 5908, 2695, 7841, 5777, 6666, 0, 9998],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7743, 3798, 9201, 2480, 3519, 5562, 8132, 2558, 8103, 7950, 9997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8508, 819, 3760, 5587, 2268, 8779, 9593, 5091, 9760, 5800, 9997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6723, 6474, 9450, 762, 999, 7503, 6320, 8360, 1659, 3551, 9997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4875, 7015, 5257, 8986, 420, 25, 8193, 7345, 3823, 1201, 9997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8789, 8287, 1658, 9563, 3876, 9673, 8624, 7025, 6275, 8751, 9996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4611, 1234, 6337, 2568, 5491, 6981, 2215, 2376, 9040, 6201, 9996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2426, 4785, 9609, 1717, 678, 2144, 2299, 8369, 2142, 3552, 9996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2965, 3, 7180, 1848, 3988, 7785, 8394, 9973, 5609, 802, 9996],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9417, 5186, 874, 3928, 9262, 2066, 3557, 2155, 9469, 7952, 9995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3212, 7803, 3831, 6661, 7064, 2158, 1627, 9875, 3748, 5003, 9995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9400, 9617, 5557, 7298, 4356, 8103, 4381, 8090, 8478, 1953, 9995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [989, 5134, 4658, 5004, 1377, 7101, 8584, 1753, 3689, 8804, 9994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1762, 4374, 3337, 8078, 683, 8244, 2936, 5813, 9411, 5554, 9994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5824, 7991, 8319, 1277, 3305, 7732, 4926, 5211, 5678, 2205, 9994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2450, 9525, 8158, 1423, 6960, 4601, 7581, 4885, 2523, 8756, 9993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5506, 5077, 7416, 8232, 1277, 6996, 6116, 9767, 9980, 5206, 9993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4151, 8539, 4462, 2845, 4960, 9018, 4487, 4782, 8086, 1557, 9993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8587, 9372, 2183, 8693, 9818, 8193, 1840, 4849, 6876, 7808, 9992],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5950, 3499, 274, 8065, 6608, 3581, 8862, 4879, 6388, 3959, 9992],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5882, 4572, 4660, 2913, 7581, 4570, 4031, 9779, 6660, 10, 9992],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4430, 6290, 4578, 9961, 664, 399, 9770, 4444, 7733, 5961, 9991],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8170, 4834, 1617, 7947, 181, 432, 8494, 3765, 9646, 1812, 9991],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6816, 7263, 8341, 8770, 8993, 5241, 8564, 2622, 2441, 7564, 9990],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8093, 4977, 7709, 4284, 6971, 8527, 138, 5888, 6160, 3215, 9990],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [693, 4291, 9175, 6395, 661, 9917, 921, 8424, 847, 8767, 9989],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7831, 6662, 3978, 9930, 9030, 8692, 1817, 5084, 6547, 4218, 9989],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [708, 2159, 1531, 5240, 143, 8488, 2480, 711, 3305, 9570, 9988],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1945, 8938, 1971, 714, 3628, 2992, 6767, 137, 1167, 4822, 9988],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4171, 1603, 7803, 4090, 3777, 2718, 8087, 8184, 180, 9974, 9987],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8026, 9589, 1094, 5652, 8111, 2870, 4656, 9662, 394, 5026, 9987],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4783, 5645, 3079, 5920, 6226, 2368, 4647, 9368, 1858, 9978, 9986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1677, 1062, 1179, 5262, 3738, 4067, 1242, 2088, 4623, 4830, 9986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4872, 554, 5755, 2750, 6120, 6231, 7585, 2593, 8739, 9582, 9985],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4346, 2342, 6347, 6624, 7216, 5307, 1634, 5644, 4259, 4235, 9985],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1871, 9614, 6128, 8632, 7209, 48, 913, 5984, 1237, 8788, 9984],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4431, 4479, 5045, 9342, 4793, 7043, 7163, 8343, 9727, 3240, 9984],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8675, 5881, 7976, 1051, 8303, 7703, 900, 7438, 9785, 7593, 9983],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1768, 4596, 5677, 9131, 523, 6764, 5862, 7966, 1467, 1847, 9983],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [131, 2009, 4658, 1394, 1906, 2348, 3365, 4612, 4831, 6000, 9982],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9933, 220, 9082, 8283, 6871, 7661, 6554, 2041, 9935, 53, 9982],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [487, 9173, 4753, 4242, 7905, 4364, 4561, 4903, 6838, 4007, 9981],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4181, 6755, 3967, 2431, 2091, 7686, 6552, 7828, 5601, 7861, 9980],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4158, 9647, 2056, 940, 4747, 3336, 5687, 5429, 6286, 1615, 9980],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4627, 71, 3698, 8646, 4784, 6281, 2968, 2299, 8955, 5269, 9979],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6586, 5485, 1136, 2859, 6410, 1437, 999, 3011, 3671, 8824, 9978],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9203, 7875, 9420, 8709, 1754, 6351, 7634, 2117, 499, 2279, 9978],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [549, 4744, 7336, 1834, 9013, 5924, 9538, 4150, 9504, 5633, 9977],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6127, 7717, 9044, 1128, 638, 9257, 5636, 3620, 753, 8889, 9976],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5594, 4099, 2465, 7148, 6125, 8657, 472, 5014, 4313, 2044, 9976],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8644, 3351, 8339, 3973, 3899, 908, 7462, 2795, 253, 5100, 9975],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6390, 719, 824, 7960, 6780, 834, 2048, 1406, 8642, 8055, 9974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7316, 4713, 8665, 5640, 5511, 7256, 4757, 5261, 9550, 911, 9974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2146, 9229, 7762, 5079, 4766, 1389, 4157, 8752, 3049, 3668, 9973],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5824, 4398, 3681, 17, 6074, 7764, 9707, 6243, 9212, 6324, 9972],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6592, 7015, 8812, 4190, 2034, 7740, 4522, 2074, 8112, 8881, 9971],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9348, 88, 5968, 4080, 6201, 5676, 8023, 554, 9823, 1338, 9971],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6654, 4751, 790, 1972, 2964, 7848, 8496, 5967, 4420, 3696, 9970],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6748, 3695, 2165, 7515, 1741, 4167, 5551, 2567, 1981, 5954, 9969],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4936, 5169, 5523, 4809, 9771, 2792, 2476, 4578, 2582, 8112, 9968],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1235, 6363, 1384, 3351, 7746, 7706, 8497, 6193, 6302, 170, 9968],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7075, 4947, 3562, 4839, 2524, 9325, 937, 1577, 3221, 2129, 9967],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8431, 2158, 1115, 3763, 1105, 8234, 7272, 4858, 3418, 3988, 9966],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3818, 8841, 8412, 7764, 34, 2120, 7091, 136, 6976, 5747, 9965],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1552, 239, 1730, 3918, 4369, 5981, 3953, 1475, 3976, 7407, 9964],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4697, 3105, 1751, 9151, 298, 5700, 7151, 2904, 4502, 8967, 9963],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2198, 1150, 2584, 7002, 5489, 5054, 3367, 8419, 8638, 427, 9963],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5480, 7245, 2661, 8610, 1179, 6261, 8234, 1977, 6471, 1788, 9962],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7075, 2566, 4739, 3214, 20, 4124, 7797, 7501, 8085, 3049, 9961],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3637, 7360, 4556, 2374, 3620, 3882, 9872, 8874, 3569, 4211, 9960],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6030, 2715, 4281, 2514, 3718, 2839, 5309, 9942, 3011, 5273, 9959],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2876, 8928, 1238, 2152, 863, 5861, 9152, 4509, 6501, 6235, 9958],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2885, 9083, 8488, 3188, 4449, 4833, 1703, 6342, 4128, 7098, 9957],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2411, 5501, 5349, 9815, 7910, 2166, 9482, 9162, 5984, 7861, 9956],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2658, 4721, 7011, 3829, 2842, 8438, 6090, 6653, 2162, 8525, 9955],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2665, 538, 6923, 1360, 5765, 4263, 2976, 2452, 2755, 9089, 9954],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3757, 4867, 7836, 3065, 1225, 6490, 94, 153, 7857, 9553, 9953],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6086, 7176, 1495, 7688, 4857, 8805, 6473, 3304, 7563, 9918, 9952],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6377, 2900, 7248, 7359, 11, 6855, 679, 5410, 1970, 184, 9952],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4432, 1250, 788, 2088, 1486, 7964, 1179, 9925, 1175, 350, 9951],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7622, 8385, 294, 387, 9878, 5561, 6609, 257, 5278, 416, 9950],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6602, 1788, 3032, 2896, 9998, 8402, 5937, 9766, 4375, 383, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6232, 8138, 5704, 5986, 6764, 4685, 8533, 1760, 8570, 250, 9948],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2986, 5769, 1347, 2663, 1928, 1167, 4132, 9498, 7961, 18, 9947],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8836, 3018, 9131, 8464, 4944, 7374, 2703, 6185, 2653, 9687, 9945],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2585, 7963, 6210, 405, 1246, 5013, 4220, 4974, 2748, 9256, 9944],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9472, 8944, 7709, 7221, 1118, 2676, 8325, 8964, 8350, 8725, 9943],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1762, 8041, 7333, 9177, 2343, 5956, 3900, 1200, 9566, 8095, 9942],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6537, 3415, 2220, 5332, 9694, 3065, 8538, 4668, 6500, 7366, 9941],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8220, 6788, 6892, 5393, 4335, 6070, 7909, 2300, 9261, 6537, 9940],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4812, 7556, 8064, 1984, 6114, 7839, 5035, 6968, 7956, 5609, 9939],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6112, 6946, 189, 7199, 1670, 4827, 9459, 1484, 2696, 4582, 9938],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1080, 8576, 6750, 4665, 1241, 5784, 6316, 8602, 3589, 3455, 9937],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3819, 3330, 201, 4845, 6967, 6516, 5308, 1012, 749, 2229, 9936],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6673, 6988, 95, 6851, 5460, 798, 9576, 1342, 4286, 903, 9935],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3844, 1618, 372, 4649, 7318, 7548, 4471, 2158, 4314, 9478, 9933],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [264, 2377, 9088, 8897, 6214, 4387, 6235, 5958, 947, 7954, 9932],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4945, 8594, 3454, 7901, 132, 7684, 568, 5177, 4301, 6330, 9931],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1563, 3095, 6130, 2004, 7236, 9207, 1110, 2180, 4492, 4607, 9930],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9292, 453, 1918, 5217, 8816, 9502, 7814, 9265, 1636, 2785, 9929],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3859, 9560, 3866, 5763, 1678, 8098, 5224, 8662, 5853, 863, 9928],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4342, 7218, 1019, 3560, 2264, 671, 653, 2528, 7262, 8842, 9926],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6999, 8631, 3531, 7195, 4742, 3285, 2259, 2948, 5982, 6722, 9925],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1128, 909, 1545, 5733, 5222, 3818, 7029, 1935, 2135, 4503, 9924],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1884, 2792, 9116, 1500, 4175, 702, 8655, 1428, 5843, 2184, 9923],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2730, 5433, 869, 8825, 9077, 9096, 5314, 3290, 7229, 9766, 9921],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1610, 5106, 4165, 370, 9218, 4617, 7355, 9306, 6417, 7249, 9920],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8675, 1082, 902, 7208, 4518, 4744, 4873, 1185, 3534, 4633, 9919],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7890, 4376, 8130, 889, 173, 8028, 5198, 555, 8704, 1917, 9918],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2434, 1309, 3166, 5538, 8794, 1229, 278, 8965, 2054, 9103, 9916],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3160, 7365, 4603, 5181, 1711, 4512, 3959, 7880, 3714, 6189, 9915],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5080, 735, 3527, 6157, 954, 4810, 9177, 8684, 3812, 3176, 9914],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6486, 2089, 7306, 6302, 3402, 7513, 5039, 2677, 2479, 64, 9913],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4362, 9844, 9862, 1706, 8470, 6585, 3813, 1071, 9845, 6852, 9911],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3119, 2277, 5481, 7970, 635, 3254, 7814, 4992, 6042, 3542, 9910],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4994, 4501, 6573, 6049, 8023, 3394, 6193, 5479, 1204, 133, 9909],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8041, 6042, 7861, 2800, 8164, 3754, 1628, 3480, 5465, 6624, 9907],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7779, 1253, 8885, 3157, 1973, 7135, 6913, 9851, 8959, 3016, 9906],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5458, 8896, 2446, 4385, 6894, 6674, 1451, 5359, 1824, 9310, 9904],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8314, 8790, 7511, 2948, 65, 9367, 7644, 673, 4196, 5504, 9903],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2399, 3275, 283, 1140, 2270, 8948, 7189, 6371, 6212, 1599, 9902],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1780, 1041, 5931, 3571, 3350, 8291, 7270, 2932, 8013, 7595, 9900],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9465, 3107, 5107, 2938, 9649, 1445, 6655, 738, 9738, 3492, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3429, 8423, 3461, 9913, 3969, 5462, 1689, 72, 1528, 9291, 9897],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [658, 3481, 8511, 3607, 8428, 2139, 2197, 1115, 3525, 4990, 9896],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1029, 608, 6203, 6597, 483, 9840, 7275, 3947, 5872, 590, 9895],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2903, 7737, 9274, 1965, 2328, 5508, 997, 8546, 8713, 6091, 9893],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6943, 3369, 1109, 9081, 3715, 7044, 8007, 4781, 2194, 1494, 9892],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2546, 9057, 2423, 9779, 8205, 6168, 9027, 2419, 6460, 6797, 9890],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5166, 3186, 4171, 7181, 2692, 1927, 6256, 1117, 1658, 2002, 9889],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5002, 9183, 8957, 5433, 9986, 4980, 8673, 422, 7936, 7107, 9887],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9866, 3422, 5738, 120, 4103, 2829, 7245, 9772, 5442, 2114, 9886],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5526, 7812, 9318, 5861, 7807, 6112, 28, 8492, 4328, 7022, 9884],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [395, 3589, 8218, 9583, 1852, 6144, 7178, 5791, 4744, 1831, 9883],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7443, 216, 2784, 5014, 5233, 3820, 5856, 767, 6842, 6541, 9881],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9757, 9752, 1356, 6048, 5667, 63, 5038, 2398, 774, 1153, 9880],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5461, 5312, 7127, 3608, 9403, 7942, 224, 9545, 6694, 5665, 9878],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6236, 4193, 3620, 2434, 9326, 6633, 8054, 947, 4759, 79, 9877],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6749, 2793, 4206, 726, 229, 7364, 814, 5226, 5122, 4394, 9875],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9393, 1594, 2472, 6715, 9984, 1502, 855, 876, 7942, 8610, 9873],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9462, 3042, 7693, 1833, 5240, 952, 4904, 6269, 3375, 2728, 9872],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1531, 628, 5174, 234, 129, 992, 8284, 9651, 1581, 6747, 9870],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6558, 77, 7167, 8747, 6371, 5738, 9029, 9140, 2720, 667, 9869],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6542, 7934, 8892, 9955, 3011, 6380, 1905, 2725, 6953, 4488, 9867],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6346, 1982, 8483, 3755, 3902, 2341, 2328, 8262, 4440, 8211, 9865],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7347, 3238, 2229, 9493, 932, 5542, 185, 3477, 5346, 1835, 9864],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4588, 9993, 268, 1389, 855, 7913, 3560, 5960, 9833, 5360, 9862],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7046, 7996, 5885, 4433, 3428, 2328, 2356, 3167, 8067, 8787, 9860],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8588, 2624, 7172, 6101, 8479, 7119, 1818, 2415, 213, 2116, 9859],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8548, 1676, 6350, 1045, 9329, 4338, 5966, 882, 6438, 5345, 9857],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1897, 1895, 3123, 1250, 9902, 1929, 917, 5607, 6909, 8476, 9855],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [89, 6402, 7808, 2890, 2702, 9983, 8117, 3483, 1796, 1509, 9854],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5182, 9308, 1567, 3214, 4685, 1234, 7476, 1263, 1268, 4443, 9852],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [461, 304, 8909, 6081, 7927, 5979, 391, 5552, 5495, 7278, 9850],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9745, 5601, 6015, 3251, 1840, 1576, 2691, 2806, 4650, 15, 9849],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9933, 8650, 1781, 9954, 3533, 6697, 7463, 9334, 8904, 2653, 9847],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6457, 7699, 1286, 7732, 2790, 517, 7797, 1294, 8433, 5193, 9845],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4168, 7422, 8576, 4750, 7952, 6993, 9416, 4690, 3409, 7635, 9843],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1954, 4626, 1979, 3777, 8881, 4425, 3225, 5373, 4009, 9978, 9841],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [524, 6114, 5831, 640, 2998, 459, 7745, 9035, 409, 2223, 9840],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9049, 8802, 2753, 1153, 246, 2716, 1459, 1214, 2788, 4369, 9838],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7465, 2890, 5890, 2068, 2677, 5224, 5058, 7284, 1322, 6417, 9836],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1836, 8815, 6471, 1601, 4192, 826, 3586, 2461, 6193, 8366, 9834],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7742, 4198, 4467, 7227, 5813, 9743, 8485, 1795, 7580, 217, 9833],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [992, 9734, 4923, 2807, 1705, 4476, 9552, 173, 5665, 1970, 9831],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [841, 194, 6035, 3480, 986, 1221, 6781, 2314, 630, 3625, 9829],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1969, 846, 3339, 5087, 230, 7987, 2121, 2768, 2659, 5181, 9827],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6938, 7938, 4264, 5082, 1364, 9590, 1132, 5914, 1936, 6639, 9825],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3600, 6934, 5196, 3827, 9518, 9713, 4537, 5959, 8647, 7998, 9823],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8724, 831, 6221, 8748, 5205, 217, 9683, 6936, 2978, 9260, 9821],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2699, 4826, 3786, 8991, 5041, 7877, 1896, 2703, 5117, 423, 9820],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2500, 8686, 5927, 4813, 5029, 8750, 5751, 6936, 5251, 1488, 9818],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7840, 4741, 5891, 3920, 272, 343, 6228, 3135, 3571, 2455, 9816],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6278, 1487, 5578, 6176, 4791, 1777, 9777, 4616, 266, 3324, 9814],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3867, 8579, 8005, 8515, 4943, 2143, 5290, 4513, 5528, 4094, 9812],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3713, 169, 5972, 3333, 9758, 7224, 4965, 5772, 9549, 4766, 9810],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9508, 5337, 459, 6059, 1324, 4794, 5080, 1153, 2523, 5341, 9808],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8405, 5376, 5452, 903, 8178, 8664, 6661, 3226, 4643, 5817, 9806],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4086, 9560, 4275, 7840, 4442, 1698, 6062, 4370, 6105, 6195, 9804],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8580, 8432, 5106, 8605, 7300, 7956, 5434, 6770, 7105, 6475, 9802],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2436, 3935, 8877, 4816, 5167, 4196, 3112, 2416, 7841, 6657, 9800],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3766, 8858, 546, 7097, 8755, 902, 3887, 3100, 8510, 6741, 9798],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3876, 6475, 4004, 243, 7021, 3057, 9192, 415, 9312, 6727, 9796],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2739, 9305, 1216, 5936, 9777, 841, 7187, 5754, 446, 6616, 9794],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5221, 299, 7383, 1097, 8579, 470, 2742, 305, 2115, 6406, 9792],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [664, 8633, 5753, 6727, 7255, 5361, 7327, 5050, 4519, 6098, 9790],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1071, 5616, 8522, 8729, 3294, 7836, 8803, 766, 7863, 5692, 9788],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4799, 5313, 4154, 8837, 1049, 1559, 1113, 8020, 2349, 5189, 9786],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9946, 1739, 7218, 106, 7550, 4914, 3874, 7165, 8184, 4587, 9784],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5530, 3452, 4943, 7525, 1479, 5529, 1879, 8344, 5573, 3888, 9782],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1472, 1217, 6312, 9934, 5680, 6138, 4491, 1482, 4724, 3091, 9780],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9622, 9990, 5618, 4622, 3319, 2013, 4946, 6288, 5843, 2196, 9778],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9768, 7880, 4473, 505, 7641, 142, 9554, 2250, 9141, 1203, 9776],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6968, 7315, 5714, 9662, 5025, 389, 6806, 8636, 4826, 113, 9774],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2018, 2616, 1413, 55, 829, 8822, 6380, 4488, 3111, 8925, 9771],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4439, 8404, 7054, 4420, 7272, 3435, 8054, 8623, 4206, 7639, 9769],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5162, 9256, 7250, 1506, 2434, 2472, 511, 9631, 8325, 6255, 9767],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3832, 6378, 7363, 5887, 9147, 5550, 59, 5869, 5682, 4774, 9765],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5724, 4575, 2806, 1503, 2402, 7823, 9246, 5463, 6491, 3195, 9763],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [664, 3947, 6332, 1660, 3602, 7365, 5378, 6307, 968, 1519, 9761],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7811, 5685, 6359, 4469, 9810, 6022, 8940, 6054, 9330, 9744, 9758],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1453, 8600, 9550, 7418, 5867, 3924, 1920, 2122, 1795, 7873, 9756],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5379, 9095, 1911, 7966, 7042, 7879, 6034, 1684, 8581, 5903, 9754],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8169, 6873, 8268, 8500, 9628, 3879, 857, 1674, 9908, 3836, 9752],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3611, 3681, 4017, 3751, 6661, 3921, 1849, 8777, 5996, 1672, 9750],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8556, 2633, 9608, 6548, 5688, 7369, 8292, 9432, 7068, 9410, 9747],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8840, 7716, 1653, 3730, 5281, 7082, 1125, 9830, 3346, 7051, 9745],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8191, 683, 9379, 7767, 6719, 522, 681, 5906, 5054, 4594, 9743],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9605, 6110, 6125, 1357, 7047, 6070, 4326, 3343, 2416, 2040, 9741],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9416, 1626, 7755, 1564, 9426, 4770, 4008, 7568, 5657, 9388, 9738],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [740, 2300, 8292, 7159, 6480, 7730, 3696, 3748, 5005, 6639, 9736],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7536, 4770, 3415, 7326, 2048, 9399, 6733, 6789, 686, 3793, 9734],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5537, 2565, 118, 1938, 6513, 6953, 3085, 1335, 2930, 849, 9732],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8324, 9159, 1884, 2955, 617, 6018, 6494, 1762, 1965, 7808, 9729],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9195, 4967, 9179, 3098, 2406, 2945, 1536, 2181, 8022, 4669, 9727],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [849, 8641, 1250, 1721, 1673, 3890, 578, 6430, 1332, 1434, 9725],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6758, 6592, 3785, 8606, 6016, 905, 642, 8076, 2128, 8101, 9722],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7530, 6672, 4579, 4216, 2352, 5291, 166, 411, 644, 4671, 9720],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7005, 5615, 3171, 9526, 7438, 8428, 5675, 6449, 7112, 1143, 9718],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5020, 2356, 7544, 1, 717, 336, 8349, 8926, 1769, 7519, 9715],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4931, 1193, 9034, 6337, 2469, 6175, 492, 296, 4852, 3797, 9713],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2948, 3997, 3217, 9216, 41, 949, 1916, 2726, 6596, 9978, 9710],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [579, 6171, 7717, 6449, 4571, 2622, 6210, 8099, 7240, 6062, 9708],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1921, 6534, 5790, 8370, 399, 3907, 6928, 8009, 7024, 2049, 9706],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9488, 8860, 5615, 1083, 9043, 2944, 3670, 3758, 6188, 7939, 9703],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2867, 6755, 8118, 7150, 9320, 3132, 8069, 6353, 4972, 3732, 9701],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6663, 64, 9770, 9305, 4937, 2326, 9682, 6507, 3619, 9428, 9698],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6364, 7900, 293, 4813, 533, 1664, 1782, 4634, 2372, 5027, 9696],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2912, 9617, 7940, 5991, 6902, 4254, 7054, 844, 1475, 529, 9694],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2592, 881, 6583, 6132, 5808, 3971, 3195, 4948, 1172, 5934, 9691],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3419, 8041, 9199, 9418, 4494, 4595, 8414, 6447, 1710, 1242, 9689],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2858, 1577, 1490, 8470, 9705, 9552, 6838, 4537, 3336, 6453, 9686],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9203, 9791, 7677, 3616, 718, 2496, 3822, 8101, 6297, 1567, 9684],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4760, 8233, 8700, 3917, 579, 8969, 1154, 5709, 843, 6585, 9681],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7378, 9221, 1711, 1144, 4431, 9411, 2178, 5615, 7223, 1505, 9679],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8258, 9122, 272, 4369, 3494, 3745, 6805, 5755, 5688, 6329, 9676],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5582, 7375, 8107, 4345, 2964, 7797, 6434, 3745, 6490, 1056, 9674],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6322, 7989, 7409, 3402, 1753, 1805, 8781, 6876, 9881, 5686, 9671],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8426, 6837, 7279, 8059, 1695, 1262, 2599, 2115, 6116, 220, 9669],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9855, 11, 1005, 7869, 3507, 350, 2314, 6098, 5448, 4657, 9666],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [174, 880, 4914, 5006, 6464, 8217, 2555, 5132, 8134, 8997, 9663],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4197, 4636, 9031, 4792, 8434, 8352, 2595, 5190, 4430, 3241, 9661],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5705, 4409, 3578, 7517, 2575, 1314, 687, 1909, 4594, 7388, 9658],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8336, 4346, 8595, 6554, 6666, 1068, 8308, 586, 8884, 1438, 9656],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2555, 813, 9967, 6739, 707, 5198, 4309, 6180, 7559, 5392, 9653],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4895, 7158, 7517, 165, 8092, 9232, 8964, 3302, 881, 9250, 9650],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [851, 310, 3481, 3933, 5301, 5370, 7924, 6220, 9110, 3010, 9648],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1308, 3918, 6660, 5785, 4739, 5841, 6072, 8851, 2509, 6675, 9645],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9609, 3040, 3371, 8917, 4969, 1181, 1288, 4761, 1342, 243, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9512, 4170, 5441, 6472, 2273, 3675, 8109, 7160, 5872, 3714, 9640],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7333, 765, 3044, 9220, 7094, 6232, 1301, 8905, 6365, 7089, 9637],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4769, 1302, 1129, 6540, 8582, 6963, 9328, 2488, 3088, 368, 9635],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1456, 705, 8123, 1061, 84, 9716, 7727, 44, 6307, 3550, 9632],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3325, 6511, 97, 986, 8084, 840, 2389, 3340, 6290, 6636, 9629],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5137, 904, 8715, 1168, 6722, 2457, 2736, 3775, 3307, 9626, 9626],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3825, 3791, 3178, 4391, 9654, 2481, 4814, 2379, 7628, 2519, 9624],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [466, 7636, 1643, 7751, 660, 1687, 4278, 9809, 9523, 5316, 9621],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7107, 723, 2854, 5721, 4024, 8070, 9286, 6345, 9266, 8017, 9618],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4695, 2265, 1160, 1011, 5343, 8794, 3299, 1891, 7129, 622, 9616],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1738, 1651, 4918, 6856, 3047, 9975, 7778, 5966, 3385, 3131, 9613],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8106, 7242, 7054, 9647, 535, 4590, 4792, 7709, 8310, 5543, 9610],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2108, 9690, 5235, 8791, 8436, 8779, 9523, 5869, 2180, 7860, 9607],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3056, 3059, 5665, 1293, 6145, 6820, 2684, 8809, 5271, 80, 9605],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [180, 5826, 7480, 1646, 1375, 5039, 2830, 4496, 7862, 2204, 9602],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8756, 3877, 2678, 3123, 6095, 4950, 8581, 504, 231, 4233, 9599],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8580, 8701, 8414, 4395, 6810, 5895, 746, 4011, 2657, 6165, 9596],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2857, 3902, 3637, 5462, 6766, 7455, 4351, 1790, 5422, 8001, 9593],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [833, 8036, 9789, 9020, 7252, 1925, 572, 215, 8807, 9741, 9590],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8060, 4996, 5584, 7643, 4776, 7126, 8568, 5250, 3094, 1386, 9588],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8578, 5520, 8604, 3228, 482, 9836, 7227, 2454, 8568, 2934, 9585],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3636, 2301, 2128, 3186, 7779, 124, 6807, 6971, 5512, 4387, 9582],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3795, 520, 4676, 7510, 3737, 6876, 481, 3532, 4213, 5744, 9579],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7116, 5156, 3270, 2263, 9393, 4779, 5799, 6448, 4956, 7005, 9576],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6625, 1558, 457, 7879, 3692, 3078, 6036, 9613, 8029, 8170, 9573],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7377, 6996, 1233, 5068, 5393, 6359, 1457, 6496, 3721, 9240, 9570],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2709, 3468, 928, 6805, 6805, 7677, 483, 139, 2321, 214, 9568],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4191, 5463, 801, 1860, 2849, 4293, 759, 3156, 4118, 1092, 9565],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7698, 4160, 7048, 3472, 8465, 6320, 127, 7729, 9404, 1874, 9562],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6724, 8509, 3569, 5975, 6997, 8574, 7507, 5604, 8472, 2561, 9559],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [317, 3826, 2267, 2355, 1722, 5904, 3678, 8092, 1614, 3153, 9556],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1408, 2442, 9898, 6804, 2275, 2310, 1964, 6060, 9125, 3648, 9553],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4645, 3353, 1192, 8155, 7286, 4136, 8826, 9932, 1299, 4049, 9550],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3102, 5186, 7763, 2610, 4082, 7630, 4359, 9688, 8433, 4353, 9547],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3361, 6968, 5418, 7337, 5888, 1164, 2692, 4855, 824, 4563, 9544],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4966, 2784, 3148, 57, 6510, 2422, 2289, 4509, 8769, 4676, 9541],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6214, 8533, 34, 3833, 2006, 838, 6164, 7270, 2567, 4695, 9538],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7098, 731, 6503, 542, 8452, 5589, 1990, 1301, 2519, 4618, 9535],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9405, 7230, 9009, 1074, 4390, 9449, 2121, 4301, 8924, 4445, 9532],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9757, 5506, 7993, 4922, 6146, 8783, 3513, 3506, 2085, 4178, 9529],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2795, 2099, 3523, 6516, 3702, 9, 7552, 5684, 2304, 3815, 9526],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5661, 1318, 7752, 220, 4362, 2805, 9784, 7133, 9885, 3356, 9523],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [595, 4610, 4465, 341, 978, 382, 9558, 3677, 5133, 2803, 9520],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5882, 3363, 442, 6623, 1040, 7113, 9561, 663, 8353, 2154, 9517],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3918, 3641, 8115, 9513, 2444, 3834, 5271, 2959, 9851, 1410, 9514],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1634, 3698, 1450, 2791, 1288, 1114, 4302, 4949, 9935, 571, 9511],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4899, 2564, 4760, 3916, 6563, 803, 5664, 532, 8914, 9637, 9507],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9271, 3969, 5279, 4610, 6131, 6171, 8923, 3118, 7096, 8608, 9504],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4390, 2977, 3038, 5519, 7873, 934, 3269, 5626, 4792, 7484, 9501],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5485, 5752, 4478, 9381, 9429, 7491, 6481, 477, 2314, 6265, 9498],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8745, 2661, 8230, 6713, 9444, 4671, 3811, 9597, 9972, 4950, 9495],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2811, 1559, 1741, 6609, 2737, 5307, 6757, 4408, 8082, 3541, 9492],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [315, 4763, 5515, 2692, 1328, 3945, 1754, 5830, 6956, 2037, 9489],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2539, 5365, 7412, 516, 2733, 5009, 8762, 4272, 6910, 438, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3206, 3580, 2912, 7596, 6455, 1726, 9764, 9636, 8259, 8744, 9482],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1225, 688, 8926, 789, 9080, 6133, 7164, 1308, 1322, 6956, 9479],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [317, 6536, 9378, 7746, 7864, 479, 2098, 8157, 6414, 5072, 9476],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8341, 6713, 1500, 9541, 2226, 340, 2639, 8531, 3856, 3094, 9473],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5143, 7492, 3929, 327, 1982, 9764, 1918, 256, 3968, 1021, 9470],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [620, 9889, 3054, 6782, 688, 8769, 6147, 630, 7069, 8853, 9466],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1176, 7122, 4568, 5130, 1923, 3505, 2541, 6423, 3481, 6591, 9463],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6585, 8941, 5269, 6620, 5783, 9410, 7152, 3869, 3528, 4234, 9460],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7056, 6358, 8461, 3305, 2385, 7677, 2611, 8669, 7532, 1782, 9457],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3888, 2974, 7791, 4805, 8593, 5351, 5765, 5981, 5819, 9236, 9453],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4941, 2985, 2408, 3284, 3681, 9394, 5228, 423, 8714, 6595, 9450],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2062, 5834, 4495, 8084, 9078, 5018, 8837, 6065, 6542, 3860, 9447],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7034, 3879, 2524, 3210, 6826, 8642, 1006, 6430, 9632, 1030, 9444],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7332, 8063, 4270, 49, 804, 5769, 9997, 4484, 8312, 8106, 9440],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2218, 7602, 7324, 4298, 4257, 4132, 5085, 2643, 2911, 5088, 9437],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9948, 7610, 6451, 9879, 6587, 2432, 3637, 2759, 3759, 1975, 9434],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7780, 1136, 1997, 3633, 1820, 4989, 8092, 6123, 1187, 8768, 9430],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5435, 153, 7141, 2657, 600, 2644, 2850, 3462, 5528, 5466, 9427],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4896, 6949, 140, 1210, 7013, 245, 1062, 4931, 7114, 2070, 9424],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6947, 8074, 6981, 6034, 948, 1045, 1330, 114, 6280, 8580, 9420],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [749, 4037, 6686, 7722, 6166, 8337, 4311, 8019, 3359, 4996, 9417],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3651, 6342, 2801, 1135, 3649, 4684, 9229, 7075, 8689, 1317, 9414],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2888, 6545, 7567, 9969, 9241, 9047, 285, 5130, 2606, 7545, 9410],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4942, 6569, 7514, 9090, 4020, 2178, 2986, 9442, 5447, 3678, 9407],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7674, 1525, 8682, 3217, 5221, 586, 365, 6684, 7552, 9717, 9403],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8461, 9901, 4538, 1845, 4996, 9441, 9119, 2933, 9260, 5662, 9400],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5121, 3448, 8597, 7784, 3670, 4732, 5650, 3674, 911, 1514, 9397],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6105, 9740, 5582, 366, 3573, 5032, 2003, 3789, 2847, 7271, 9393],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4925, 313, 9111, 4025, 8921, 3206, 1724, 7558, 5410, 2934, 9390],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8995, 8607, 9724, 8627, 6652, 8406, 5613, 8655, 8944, 8503, 9386],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7890, 2323, 4828, 9369, 2470, 8688, 7391, 145, 3794, 3979, 9383],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4318, 6692, 1764, 1336, 5787, 4605, 9266, 4479, 303, 9361, 9379],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8393, 5411, 7698, 6696, 6619, 4116, 7409, 3492, 8819, 4648, 9376],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7460, 5011, 6002, 987, 6900, 9150, 7337, 8398, 9688, 9842, 9372],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6978, 9742, 9869, 8889, 8021, 4181, 9202, 9788, 3259, 4943, 9369],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [970, 3691, 1510, 9232, 5844, 7156, 2980, 7627, 9881, 9949, 9365],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6029, 2513, 1555, 3565, 3746, 3123, 3578, 1247, 9904, 4862, 9362],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7384, 7978, 559, 2474, 3681, 912, 5835, 9348, 3677, 9682, 9358],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4465, 4009, 5427, 8697, 4585, 3216, 9438, 9992, 1554, 4408, 9355],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [111, 2709, 1267, 6048, 6822, 423, 3742, 601, 3888, 9040, 9351],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9018, 1827, 7016, 7956, 727, 8553, 2492, 7950, 1030, 3579, 9348],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7028, 8892, 4867, 9116, 6682, 1646, 8462, 8167, 3337, 8024, 9344],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1405, 7433, 3260, 8078, 3484, 8971, 7984, 6730, 1164, 2376, 9341],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8762, 491, 5332, 7658, 1142, 7385, 5404, 8460, 4867, 6634, 9337],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9321, 5741, 4166, 3568, 3578, 9223, 7425, 7519, 4804, 799, 9334],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1990, 1053, 8011, 9667, 6048, 6061, 7371, 7408, 1333, 4871, 9330],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7379, 702, 8417, 589, 1457, 8712, 9348, 961, 4814, 8849, 9326],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [528, 6894, 7885, 9087, 9044, 3812, 2320, 344, 5606, 2734, 9323],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2078, 9280, 7258, 6222, 8308, 7367, 4082, 7047, 4070, 6526, 9319],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7234, 715, 3417, 7351, 295, 5599, 5151, 1886, 570, 225, 9316],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2, 7267, 1761, 5691, 7777, 3471, 2553, 4996, 5467, 3830, 9312],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6183, 3528, 2793, 7944, 5110, 1254, 3524, 5827, 9126, 7342, 9308],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9100, 951, 5508, 2955, 7922, 9476, 9114, 3142, 1912, 762, 9305],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1583, 8435, 374, 4576, 2067, 2649, 7704, 5014, 4190, 4088, 9301],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6282, 2227, 9708, 3700, 624, 2110, 8417, 8819, 6327, 7321, 9297],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8593, 7087, 2088, 1764, 6995, 8364, 4451, 1236, 8692, 461, 9294],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6234, 2197, 9224, 8701, 1490, 3284, 6312, 8240, 1651, 3509, 9290],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6564, 1224, 7791, 2455, 8077, 2530, 4949, 5102, 5576, 6463, 9286],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4062, 1183, 5196, 4376, 7257, 8579, 4806, 6382, 836, 9325, 9282],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3603, 1074, 7091, 5319, 360, 4705, 6777, 5927, 7803, 2093, 9279],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6346, 6374, 6446, 703, 9796, 301, 1063, 6868, 6849, 4769, 9275],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8693, 2259, 11, 9232, 9120, 7915, 9943, 1612, 8348, 7352, 9271],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7739, 4473, 9389, 9277, 6047, 2350, 454, 1847, 2673, 9843, 9267],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3956, 3386, 2468, 8989, 804, 2229, 6966, 8526, 199, 2241, 9264],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6635, 8483, 8588, 912, 1528, 4381, 3679, 1876, 1304, 4546, 9260],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2749, 4205, 149, 9259, 7645, 1432, 7019, 1384, 6363, 6758, 9256],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2624, 2275, 7069, 7737, 1476, 2973, 7941, 5800, 5754, 8878, 9252],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5601, 9984, 1930, 8110, 7528, 676, 4145, 3130, 9857, 905, 9249],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6532, 8045, 6245, 4113, 8250, 7757, 2192, 632, 9051, 2840, 9245],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4310, 4891, 6089, 2144, 4236, 3136, 9537, 4813, 3716, 4683, 9241],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9944, 4626, 2685, 8935, 6146, 695, 6457, 1428, 4235, 6433, 9237],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1982, 9262, 5062, 7330, 4849, 4010, 7898, 5470, 989, 8091, 9233],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3767, 5609, 2794, 4085, 5532, 6930, 5225, 1172, 4363, 9656, 9229],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6734, 3086, 2485, 8253, 783, 398, 7879, 1999, 4740, 1129, 9226],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1328, 6136, 7997, 5140, 6873, 5885, 4939, 648, 2506, 2510, 9222],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8800, 4553, 7594, 8860, 6694, 5837, 6602, 9040, 8046, 3798, 9218],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8264, 1474, 7879, 6145, 2067, 1500, 5558, 8320, 1749, 4995, 9214],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5957, 258, 1614, 5180, 7320, 8526, 8279, 8850, 4002, 6099, 9210],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5678, 8983, 1597, 5688, 5298, 745, 6221, 208, 5195, 7111, 9206],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6342, 7489, 3549, 285, 6156, 2477, 6919, 1181, 5716, 8031, 9202],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9687, 877, 5546, 2063, 8512, 9793, 5007, 9764, 5956, 8859, 9198],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7184, 9399, 8541, 9448, 1756, 1101, 3137, 3154, 6309, 9595, 9194],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7347, 1642, 810, 6453, 7499, 7448, 2800, 7747, 7165, 239, 9191],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4714, 8540, 8089, 4439, 7358, 2945, 5073, 9134, 8919, 791, 9187],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3202, 657, 562, 355, 3485, 5683, 1253, 2098, 1966, 1252, 9183],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2235, 8323, 7581, 5937, 7415, 9554, 3416, 607, 6700, 1620, 9179],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5488, 7765, 1893, 2634, 2029, 7367, 4875, 7814, 3517, 1897, 9175],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8560, 6275, 7742, 7701, 582, 5642, 547, 6051, 2816, 2082, 9171],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [916, 292, 3152, 8209, 5972, 1498, 7232, 6823, 4994, 2175, 9167],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5427, 679, 7373, 1230, 2557, 2019, 3796, 810, 451, 2177, 9163],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2213, 1214, 2182, 396, 2040, 6494, 1266, 7856, 9585, 2086, 9159],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [559, 3398, 2817, 1016, 4100, 1944, 2832, 6969, 2799, 1905, 9155],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4965, 8859, 3763, 8139, 1603, 2323, 3753, 6317, 494, 1632, 9151],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6313, 5985, 9608, 4049, 9413, 1796, 1180, 3223, 3073, 1267, 9147],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1560, 6206, 5463, 3770, 4955, 2507, 3880, 4160, 939, 811, 9143],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [129, 2626, 9085, 9005, 7871, 7217, 1872, 4750, 4497, 263, 9139],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8844, 2768, 2270, 2569, 5228, 7245, 5972, 9756, 4152, 9624, 9134],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [368, 8656, 7280, 6566, 7896, 6088, 7243, 3082, 312, 8894, 9130],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8115, 8384, 219, 8398, 2879, 9149, 6357, 7766, 3382, 8072, 9126],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6004, 6488, 3140, 8862, 5476, 9959, 2866, 5977, 3772, 7159, 9122],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3469, 3118, 6331, 6254, 4328, 3321, 4379, 9010, 1890, 6155, 9118],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2095, 5849, 8160, 9199, 1510, 5764, 5647, 7284, 8147, 5059, 9114],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4083, 7086, 9030, 9013, 8970, 3730, 7564, 336, 2954, 3873, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4646, 1190, 5663, 9511, 1723, 9904, 6066, 6818, 6721, 2595, 9106],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4358, 6427, 9880, 8302, 7347, 8080, 950, 4492, 9863, 1226, 9102],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8677, 5954, 380, 8653, 424, 7008, 4591, 225, 2793, 9767, 9097],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2518, 7095, 5267, 4818, 9693, 3594, 577, 9989, 5924, 8216, 9093],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2527, 5592, 6295, 6344, 4776, 5910, 2247, 8851, 9674, 6574, 9089],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9098, 5617, 2224, 7998, 8456, 6384, 1143, 974, 4459, 4842, 9085],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3390, 8095, 8231, 1752, 9565, 5628, 5366, 9609, 694, 3019, 9081],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [512, 6484, 1105, 5426, 646, 7288, 7844, 7094, 8800, 1104, 9077],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7120, 2673, 6644, 9115, 3650, 4347, 4510, 4848, 9195, 9099, 9072],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5965, 2337, 7287, 5390, 5988, 7307, 2385, 3366, 2299, 7004, 9068],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1704, 8550, 5993, 2186, 8366, 4649, 7577, 2216, 8533, 4817, 9064],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [793, 6551, 8612, 8422, 4899, 6009, 3181, 37, 8319, 2540, 9060],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4787, 4534, 3751, 1436, 5071, 8480, 7096, 4529, 2079, 173, 9056],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4988, 9046, 9166, 2293, 6165, 6471, 9747, 2455, 238, 7715, 9051],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3608, 2340, 76, 9837, 3889, 5537, 1716, 9634, 3219, 5166, 9047],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7572, 4859, 1104, 6822, 7938, 607, 1286, 934, 1450, 2527, 9043],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5153, 8588, 3792, 1662, 8313, 9040, 1889, 273, 5355, 9797, 9038],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8042, 2770, 106, 6962, 7276, 8923, 9473, 611, 5362, 6977, 9034],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4299, 4740, 4014, 1170, 853, 3049, 9766, 3949, 1899, 4067, 9030],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6701, 2437, 3229, 2180, 2832, 8993, 5457, 1321, 5396, 1066, 9026],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1664, 2691, 7236, 1461, 3280, 5725, 3291, 2791, 6282, 7975, 9021],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2939, 4513, 1965, 4270, 2588, 7175, 1061, 7450, 4988, 4794, 9017],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [136, 5511, 2329, 5506, 1125, 3192, 4523, 3410, 1947, 1523, 9013],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1488, 9094, 8386, 1837, 3581, 8322, 4210, 7802, 7590, 8161, 9008],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2309, 7576, 6439, 8644, 6114, 8840, 2166, 6769, 2352, 4710, 9004],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7962, 7705, 785, 5106, 3438, 8465, 8580, 5462, 6667, 1168, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6645, 4945, 3349, 2249, 1975, 3193, 8337, 8039, 970, 7537, 8995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3222, 2370, 5717, 6904, 4245, 5686, 7474, 7656, 5698, 3815, 8991],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8012, 6954, 302, 9195, 8637, 9648, 9552, 6465, 1288, 4, 8987],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7577, 3010, 4034, 2328, 7716, 4626, 1933, 5611, 8178, 6102, 8982],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1564, 6470, 9067, 962, 7221, 1671, 1966, 5223, 6807, 2111, 8978],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6003, 4662, 1012, 8207, 6902, 303, 3089, 4415, 7615, 8030, 8973],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3154, 6368, 6885, 1286, 3319, 7213, 836, 1279, 1043, 3860, 8969],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8177, 9586, 3759, 1984, 3709, 7143, 8759, 2879, 7532, 9599, 8964],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3070, 3102, 6612, 40, 9035, 6389, 4253, 5252, 7525, 5249, 8960],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7115, 5123, 2363, 5704, 3254, 9365, 4298, 3396, 1466, 810, 8956],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9601, 8692, 9165, 1450, 4861, 8665, 1110, 1272, 9799, 6280, 8951],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3143, 6916, 8694, 2459, 5687, 9084, 7699, 1795, 2969, 1662, 8947],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5155, 5140, 8041, 655, 933, 6022, 3342, 6835, 1422, 6954, 8942],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3914, 726, 737, 7906, 3334, 8727, 8962, 7205, 5606, 2156, 8938],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4630, 6784, 7843, 212, 3340, 8827, 2423, 2665, 5969, 7269, 8933],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8422, 9761, 4786, 6372, 6104, 4585, 3730, 1909, 2959, 2293, 8929],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6112, 9605, 2929, 1500, 5068, 1339, 142, 2568, 7026, 7227, 8924],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8230, 3686, 2558, 7942, 802, 8565, 1196, 1200, 8621, 2072, 8920],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4393, 9819, 2124, 3339, 2765, 4019, 3645, 3289, 8195, 6828, 8915],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6340, 6312, 3918, 7869, 509, 5410, 6296, 3239, 6201, 1495, 8911],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8389, 2443, 5859, 9894, 9843, 45, 4773, 4370, 3092, 6073, 8906],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [834, 1982, 401, 1278, 8333, 2917, 6178, 8912, 9322, 561, 8902],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1096, 1857, 2533, 441, 3469, 3665, 3674, 8003, 5347, 4961, 8897],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3435, 8592, 8025, 2692, 5735, 2883, 970, 1682, 1623, 9272, 8892],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [478, 850, 9284, 3405, 7704, 8223, 6721, 8885, 8605, 3493, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [172, 3755, 8748, 153, 9206, 744, 8842, 7443, 6753, 7626, 8883],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9760, 7084, 8554, 4843, 7502, 1972, 8723, 4074, 6525, 1670, 8879],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2079, 2495, 354, 6133, 299, 2124, 5369, 4380, 8380, 5625, 8874],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [386, 1171, 1522, 5874, 8311, 9954, 9439, 2841, 2779, 9492, 8869],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [323, 6992, 4612, 935, 2980, 4692, 7206, 2814, 183, 3270, 8865],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1685, 2480, 7472, 3380, 3828, 510, 4417, 6524, 1054, 6959, 8860],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2523, 2125, 3981, 7591, 8804, 4010, 75, 5062, 5856, 559, 8856],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2913, 1248, 2513, 2375, 9841, 5171, 129, 8379, 5052, 4071, 8851],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5739, 2845, 3869, 9347, 4715, 2227, 1072, 5283, 9108, 7494, 8846],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7583, 6544, 6146, 5797, 5171, 940, 3453, 3433, 8489, 829, 8842],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8390, 680, 4651, 789, 96, 8737, 5301, 9335, 3661, 4076, 8837],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8475, 8295, 4973, 7277, 1423, 4164, 5463, 8337, 5093, 7234, 8832],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1383, 7119, 1566, 495, 9262, 2140, 6844, 4624, 3253, 304, 8828],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1570, 6490, 7903, 3665, 1591, 5468, 9570, 1214, 8610, 3285, 8823],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9936, 1441, 3399, 6136, 2721, 3066, 4058, 9954, 1633, 6179, 8818],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4333, 1817, 2923, 6238, 3523, 5410, 3994, 1512, 2796, 8984, 8813],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9769, 2568, 3738, 1455, 5280, 7632, 9230, 5376, 2568, 1701, 8809],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2370, 3546, 9183, 1733, 7825, 762, 8588, 9849, 1423, 4330, 8804],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5030, 8188, 6109, 7921, 1458, 1580, 2574, 2042, 9836, 6870, 8799],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1880, 6375, 2073, 6275, 938, 1547, 6012, 7869, 8279, 9323, 8794],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8325, 2486, 7218, 1649, 8658, 5300, 581, 2047, 7230, 1688, 8790],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1245, 9039, 3724, 6282, 2926, 9176, 7270, 8084, 7163, 3965, 8785],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2986, 9726, 2220, 7926, 6064, 235, 8743, 8282, 8557, 6154, 8780],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4520, 9916, 9651, 382, 5826, 6281, 1611, 3727, 1890, 8256, 8775],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5329, 8861, 7347, 1143, 2442, 7331, 8630, 4283, 7640, 269, 8771],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2796, 909, 2331, 4783, 2378, 9028, 795, 8595, 6287, 2195, 8766],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1550, 9922, 784, 6878, 8664, 8472, 9357, 4073, 8313, 4033, 8761],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3531, 92, 1964, 1447, 6441, 2949, 7748, 6899, 4198, 5784, 8756],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9278, 5429, 6099, 5152, 1134, 2033, 3418, 2013, 4426, 7447, 8751],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2120, 6071, 3936, 3665, 5440, 3553, 9588, 3111, 9479, 9022, 8746],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6588, 6296, 1802, 9606, 52, 3905, 6912, 2644, 9842, 510, 8742],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5004, 7028, 8422, 7224, 1838, 3179, 5052, 1807, 6000, 1911, 8737],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7766, 9805, 2396, 6402, 1901, 5609, 4166, 538, 8439, 3224, 8732],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6163, 8709, 7171, 7550, 4735, 5808, 6310, 7512, 7645, 4450, 8727],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9275, 2784, 8777, 9471, 8401, 1290, 6750, 137, 4108, 5589, 8722],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9543, 6719, 6362, 4112, 4403, 1758, 5187, 4548, 8314, 6640, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9795, 4382, 2926, 5356, 4666, 5645, 6898, 5602, 754, 7605, 8712],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8837, 9429, 363, 3407, 1761, 4406, 3787, 6875, 1918, 8482, 8707],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2751, 8147, 6315, 1886, 7218, 5036, 5347, 654, 2298, 9272, 8702],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8059, 6676, 8023, 1373, 1515, 1321, 9540, 7935, 2384, 9975, 8697],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3090, 7326, 8729, 692, 8023, 4292, 3584, 8418, 2671, 591, 8693],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2818, 9935, 3813, 5711, 1903, 2403, 4660, 498, 3653, 1120, 8688],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1115, 9635, 6062, 4649, 3657, 1891, 524, 1266, 5823, 1562, 8683],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4958, 8231, 1915, 8851, 5719, 7847, 38, 6499, 9677, 1917, 8678],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1048, 8938, 3436, 8526, 9190, 6465, 3614, 658, 5713, 2186, 8673],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [202, 7802, 4812, 4070, 6478, 8981, 3565, 6883, 4426, 2368, 8668],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4106, 1466, 8557, 5094, 4314, 7789, 4378, 6986, 6316, 2463, 8663],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9950, 7273, 7010, 1194, 282, 5240, 2893, 1448, 1882, 2472, 8658],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2482, 9945, 1329, 638, 4665, 5613, 8399, 9412, 1622, 2394, 8653],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7329, 4124, 5643, 5498, 8100, 767, 2644, 8682, 6039, 2229, 8648],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8772, 744, 1596, 4188, 4177, 9963, 9753, 5711, 5634, 1978, 8643],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5025, 4655, 1777, 4793, 4781, 4363, 6071, 5605, 909, 1641, 8638],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1968, 7698, 3708, 4977, 4642, 6712, 9902, 2109, 2368, 1217, 8633],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5302, 9556, 3831, 6420, 185, 6695, 1180, 7610, 514, 707, 8628],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1377, 8929, 8470, 3707, 6433, 2478, 1041, 3124, 5854, 110, 8623],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8381, 5597, 1705, 9202, 4341, 8944, 1312, 8298, 8892, 9427, 8617],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3597, 9287, 4697, 6611, 9589, 3110, 3920, 1401, 137, 8659, 8612],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3475, 5710, 3920, 6652, 2462, 7257, 201, 9321, 94, 7804, 8607],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [210, 6751, 4159, 8284, 7105, 251, 140, 7557, 9274, 6862, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5088, 2897, 3792, 8392, 7025, 7594, 1507, 217, 8186, 5835, 8597],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3885, 2588, 2879, 1424, 2345, 683, 8926, 11, 7339, 4722, 8592],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6321, 2780, 7784, 8266, 2913, 5807, 2837, 8249, 7244, 3523, 8587],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6164, 959, 8548, 474, 9989, 3387, 8393, 4829, 8415, 2238, 8582],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8185, 8288, 6846, 1779, 7789, 7968, 4253, 8241, 1363, 868, 8577],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7386, 6637, 3286, 3492, 4822, 9471, 1303, 5554, 6603, 9411, 8571],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2765, 138, 3787, 3916, 3476, 6230, 1282, 2415, 4649, 7869, 8566],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8661, 5907, 7145, 4092, 4939, 317, 5326, 3043, 6016, 6241, 8561],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8924, 8333, 1339, 3039, 5097, 5674, 2425, 225, 1221, 4528, 8556],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4460, 3598, 6991, 5030, 5626, 9565, 7799, 5307, 780, 2729, 8551],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9003, 8340, 5509, 9307, 3066, 7868, 1181, 8195, 5212, 844, 8546],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1400, 5131, 61, 8810, 7221, 4719, 5018, 7342, 5036, 8874, 8540],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7007, 7165, 3513, 9040, 8787, 7034, 2587, 9751, 771, 6819, 8535],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5697, 6055, 3244, 851, 4669, 4417, 6027, 963, 2939, 4678, 8530],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1900, 403, 3051, 1777, 7976, 4981, 4280, 5057, 2059, 2452, 8525],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [191, 8176, 2727, 9370, 8251, 7606, 953, 4641, 8655, 140, 8520],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1778, 8783, 2140, 6793, 5999, 1143, 2092, 848, 3250, 7744, 8514],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [798, 2899, 5207, 5573, 4122, 1098, 3867, 3332, 6367, 5262, 8509],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4408, 5178, 7079, 2842, 7406, 4314, 180, 262, 8532, 2695, 8504],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3101, 5402, 2486, 501, 9698, 2177, 182, 8315, 269, 44, 8499],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2008, 6748, 2608, 1463, 6949, 2867, 5704, 2673, 2107, 7307, 8493],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3366, 4904, 579, 3370, 2798, 3183, 8608, 7018, 4571, 4485, 8488],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4486, 5930, 764, 2829, 1877, 469, 8049, 3525, 8191, 1578, 8483],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5670, 8063, 3936, 3250, 4518, 5167, 7652, 2857, 3495, 8587, 8477],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4086, 2215, 9450, 6631, 5038, 4525, 2609, 4161, 1013, 5511, 8472],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2562, 526, 7139, 4101, 4263, 7988, 6683, 5060, 1276, 2350, 8467],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7772, 7019, 7086, 1575, 5433, 4805, 9136, 1652, 4816, 9104, 8461],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7883, 4796, 6310, 5449, 1119, 4382, 1564, 8502, 2164, 5774, 8456],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [176, 5111, 2, 8725, 7244, 9907, 4654, 8634, 3855, 2359, 8451],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5438, 7506, 4002, 292, 8769, 5793, 4855, 3532, 423, 8860, 8445],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [525, 5480, 7932, 9170, 68, 9454, 958, 3130, 2402, 5276, 8440],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9766, 1938, 8696, 1247, 1492, 7960, 603, 5807, 328, 1608, 8435],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9045, 9160, 6205, 8397, 2017, 111, 6691, 8383, 4738, 7855, 8429],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1348, 6603, 2079, 8683, 6403, 4448, 3715, 6115, 6170, 4018, 8424],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8175, 4278, 3112, 1601, 3639, 3756, 4013, 2687, 5162, 97, 8419],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6091, 5400, 478, 3904, 1956, 6582, 3925, 209, 2253, 6092, 8413],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5474, 2305, 9368, 9361, 4088, 6319, 9876, 9209, 7982, 2002, 8408],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9422, 2280, 9119, 9821, 4880, 8387, 4368, 8631, 2892, 7829, 8402],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9409, 6458, 8432, 4983, 1778, 6052, 1893, 5824, 7524, 3571, 8397],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3644, 9193, 2061, 4383, 7142, 5425, 4757, 6541, 2420, 9230, 8391],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5501, 1559, 3073, 7042, 9733, 188, 8825, 4933, 8124, 4804, 8386],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8820, 4049, 7575, 2053, 1122, 6578, 9176, 3543, 5180, 295, 8381],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6531, 746, 6432, 6903, 1169, 9179, 5683, 3300, 4133, 5702, 8375],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5553, 6563, 1154, 9544, 5127, 8074, 8499, 3513, 5529, 1025, 8370],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8443, 1029, 9755, 5001, 3280, 7887, 3465, 1869, 9915, 6264, 8364],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2092, 9560, 4145, 7577, 2436, 9268, 7434, 4422, 7838, 1420, 8359],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8779, 148, 5625, 5361, 6963, 3372, 3511, 5594, 9847, 6492, 8353],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9969, 3196, 1507, 4799, 5408, 9875, 6205, 8163, 6491, 1481, 8348],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [864, 5660, 7061, 9259, 7134, 9071, 6508, 3263, 8321, 6386, 8342],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4964, 4873, 6108, 6973, 1746, 8612, 6877, 375, 5887, 1208, 8337],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8715, 3682, 5031, 154, 2435, 5425, 6143, 7323, 9740, 5946, 8331],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8734, 1055, 3169, 8583, 2727, 3374, 4331, 268, 435, 602, 8326],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2974, 6494, 2795, 7288, 4464, 7203, 7399, 3702, 8523, 5173, 8320],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1329, 7095, 9872, 9135, 3156, 3324, 1895, 445, 4560, 9662, 8314],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9837, 5639, 8783, 9067, 5224, 7996, 9524, 1634, 9100, 4067, 8309],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6784, 5398, 7155, 7290, 9930, 3456, 1643, 6726, 2699, 8390, 8303],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7034, 5679, 8051, 3875, 7143, 2552, 3660, 3482, 5915, 2629, 8298],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9243, 7628, 4205, 6856, 390, 2433, 9361, 7970, 9304, 6785, 8292],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8974, 9587, 1097, 9953, 2959, 7858, 5147, 4557, 3426, 859, 8287],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1676, 2145, 1567, 4419, 3114, 4682, 4193, 5900, 8839, 4849, 8281],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2220, 9281, 3970, 2100, 2789, 4067, 517, 2945, 6104, 8757, 8275],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6964, 4218, 8778, 3561, 2425, 7990, 2974, 4918, 5781, 2582, 8270],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2281, 1606, 5678, 5965, 2885, 6601, 9164, 9322, 8432, 6324, 8264],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7173, 9005, 6067, 205, 3678, 7994, 9254, 1931, 4621, 9984, 8258],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9104, 8780, 6038, 5537, 4989, 952, 9724, 6782, 4909, 3561, 8253],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3984, 4087, 5071, 2493, 9301, 1229, 7022, 6172, 9862, 7055, 8247],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4507, 4928, 8604, 1170, 6622, 1934, 1146, 651, 45, 468, 8242],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8522, 3126, 1963, 1942, 5637, 8575, 9135, 9015, 6022, 3797, 8236],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1131, 3565, 2926, 9164, 1318, 9339, 8484, 8306, 8362, 7044, 8230],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8737, 454, 5153, 5495, 7798, 1161, 471, 3800, 7632, 209, 8225],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9565, 9548, 2, 4870, 3536, 2164, 3403, 9002, 4399, 3292, 8219],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [539, 6740, 5754, 5947, 4066, 1016, 5786, 5645, 9234, 6292, 8213],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [732, 4070, 7238, 4875, 5820, 3798, 9403, 3680, 2706, 9211, 8207],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5363, 4749, 2361, 6382, 2762, 8932, 2317, 1273, 5386, 2047, 8202],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8993, 1807, 2428, 5482, 5786, 746, 1790, 4795, 7845, 4801, 8196],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9536, 4643, 8602, 8348, 3035, 2253, 7114, 8821, 656, 7474, 8190],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5833, 8150, 5970, 80, 7522, 7701, 2372, 6124, 4393, 64, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9945, 2542, 8642, 9118, 6612, 5485, 9108, 7664, 9629, 2572, 8179],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8149, 7187, 3951, 2843, 6162, 1975, 8915, 2590, 6940, 4999, 8173],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9443, 1848, 1465, 6320, 241, 6851, 5945, 8228, 6900, 7344, 8167],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9442, 9840, 4044, 6213, 5620, 506, 9339, 77, 88, 9608, 8161],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5848, 6578, 5221, 4419, 8321, 4108, 5565, 1806, 7079, 1789, 8156],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6377, 43, 1609, 952, 7746, 2879, 689, 5244, 8452, 3889, 8150],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3344, 193, 3742, 2926, 2043, 3184, 2551, 376, 4787, 5908, 8144],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3228, 1243, 6740, 6069, 6543, 3999, 2868, 5339, 6662, 7845, 8138],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3772, 6671, 7404, 6950, 5247, 3347, 9252, 6413, 4659, 9701, 8132],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1712, 6134, 1132, 7979, 3502, 265, 7147, 8019, 9359, 1475, 8127],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5743, 679, 5329, 3110, 8147, 2900, 1684, 2709, 1345, 3169, 8121],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8908, 216, 1371, 11, 9542, 3308, 9458, 1161, 1199, 4781, 8115],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7615, 4001, 735, 4108, 8039, 9534, 218, 2179, 9505, 6311, 8109],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2285, 4143, 9359, 1402, 5570, 5564, 8483, 2676, 6848, 7761, 8103],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4386, 9640, 4935, 66, 1146, 9729, 5067, 7681, 3813, 9130, 8097],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [626, 676, 2530, 5587, 7195, 2144, 8536, 322, 988, 418, 8092],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1838, 5102, 3086, 531, 1757, 1776, 6569, 1828, 8958, 1624, 8086],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1320, 3436, 6121, 7705, 9657, 3708, 7252, 1518, 8312, 2750, 8080],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5882, 2446, 1773, 4620, 3906, 7217, 282, 6799, 9638, 3795, 8074],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2586, 890, 8644, 7535, 6617, 5216, 8094, 3155, 3527, 4760, 8068],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3179, 5718, 3277, 4982, 6873, 5687, 6904, 4149, 568, 5644, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2956, 3989, 6094, 3354, 1006, 5664, 7676, 1409, 1353, 6447, 8056],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7959, 3084, 9095, 965, 8865, 8371, 7004, 4627, 6473, 7169, 8050],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3278, 3394, 5221, 1667, 7690, 4112, 7917, 1551, 6522, 7811, 8044],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1757, 742, 1077, 4764, 3289, 5483, 598, 7981, 2092, 8373, 8038],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3768, 9426, 7520, 4372, 6262, 7522, 3030, 7759, 3779, 8854, 8032],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8921, 9470, 742, 8517, 9069, 3381, 1556, 2769, 2178, 9255, 8026],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6966, 9946, 4812, 6032, 7792, 6110, 1358, 2926, 7884, 9575, 8020],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5321, 6182, 814, 7705, 460, 7155, 6862, 6172, 1494, 9816, 8014],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [682, 8390, 3695, 6894, 1867, 2162, 2056, 8472, 3606, 9976, 8008],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4136, 580, 2583, 4118, 2810, 4691, 729, 3803, 4819, 56, 8003],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1102, 9472, 822, 9628, 9718, 8424, 6635, 4152, 5731, 56, 7997],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1207, 9148, 6345, 7790, 8651, 8481, 3571, 9511, 6942, 9976, 7990],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5375, 235, 9585, 7043, 5643, 2428, 5377, 7866, 9054, 9816, 7984],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7941, 8057, 4236, 9223, 3395, 1591, 5855, 5196, 2668, 9577, 7978],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4511, 231, 5315, 2084, 2294, 3268, 8612, 5464, 8386, 9257, 7972],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9221, 8222, 9524, 8798, 1732, 4443, 6819, 613, 6812, 8858, 7966],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9589, 5104, 5873, 7990, 5706, 7604, 2891, 558, 8549, 8379, 7960],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8463, 4794, 1137, 7429, 4612, 9271, 8089, 3180, 4202, 7821, 7954],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9606, 2013, 7427, 3729, 3174, 1831, 2041, 4324, 4377, 7183, 7948],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7926, 4619, 341, 9240, 2371, 9294, 2180, 7786, 9680, 6465, 7942],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1517, 8278, 9389, 5647, 1218, 7569, 3114, 5313, 719, 5669, 7936],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5703, 2996, 1405, 1640, 2180, 9868, 5900, 6594, 8101, 4792, 7930],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3896, 3002, 7089, 9096, 1983, 7847, 7253, 9255, 2435, 3837, 7924],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8200, 788, 5757, 8747, 7503, 9088, 8666, 8852, 4331, 2802, 7918],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [537, 9582, 9518, 1858, 4348, 1538, 5458, 8866, 4399, 1688, 7912],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9813, 2401, 1885, 9284, 3702, 5502, 5734, 695, 3251, 495, 7906],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5654, 4321, 4072, 3024, 912, 3817, 9278, 3650, 1497, 9223, 7899],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9286, 7052, 2677, 8220, 7192, 802, 6354, 4949, 9751, 7871, 7893],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6781, 4657, 3049, 5158, 3791, 611, 6436, 9708, 8626, 6441, 7887],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6584, 447, 2398, 1344, 5804, 5583, 6857, 938, 8738, 4932, 7881],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8630, 1771, 4857, 2892, 769, 5226, 1380, 9538, 699, 3345, 7875],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3224, 2352, 7332, 2326, 5048, 6425, 8686, 4286, 5128, 1678, 7869],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9575, 7227, 676, 6302, 8887, 5512, 789, 1840, 2640, 9933, 7862],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9216, 2290, 6760, 1665, 8944, 2794, 1368, 6722, 3852, 8109, 7856],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3954, 8851, 179, 1592, 4925, 168, 4022, 1320, 9384, 6206, 7850],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5612, 2418, 6190, 5180, 4868, 2436, 446, 5879, 9853, 4225, 7844],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [832, 9365, 6966, 3811, 1448, 2942, 8530, 8492, 5880, 2166, 7838],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7152, 5299, 278, 5638, 9549, 4141, 376, 5101, 8086, 28, 7832],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7818, 7142, 2337, 5772, 3204, 3736, 240, 9481, 7091, 7812, 7825],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4928, 9659, 4975, 3928, 7831, 6978, 2393, 3242, 3519, 5518, 7819],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3135, 7226, 1892, 3418, 1548, 5785, 8907, 5819, 7991, 3145, 7813],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [556, 9493, 5749, 5401, 7174, 5264, 7358, 4468, 1132, 695, 7807],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4298, 5740, 4115, 84, 4350, 8296, 8455, 4256, 3566, 8166, 7800],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3409, 9109, 5126, 2040, 9029, 8773, 3590, 8059, 5918, 5559, 7794],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1631, 9917, 1292, 9961, 5414, 4143, 2308, 6552, 8815, 2874, 7788],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2309, 5653, 751, 1801, 3207, 7861, 9699, 8205, 2883, 112, 7782],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4514, 7702, 8835, 4431, 840, 2394, 3718, 9279, 8750, 7271, 7775],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9509, 7996, 8905, 2445, 3181, 3392, 2416, 3813, 7045, 4353, 7769],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5624, 9929, 606, 3604, 9941, 5661, 1105, 3624, 8396, 1357, 7763],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7028, 2736, 7199, 8506, 8847, 1563, 9438, 8297, 3433, 8284, 7756],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4433, 9185, 3162, 9312, 5384, 2469, 8411, 5183, 2788, 5133, 7750],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7168, 8832, 1349, 6657, 8692, 3903, 7293, 9387, 7091, 1904, 7744],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4558, 1230, 8575, 5260, 970, 5005, 473, 3766, 6976, 8598, 7737],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6671, 2679, 3415, 6961, 5490, 2933, 4232, 8919, 3074, 5215, 7731],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7224, 1286, 4420, 5029, 6076, 2861, 3436, 3186, 6021, 1754, 7725],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9507, 8047, 5894, 5493, 8645, 4177, 8154, 2636, 6450, 8216, 7718],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8011, 9239, 7457, 9776, 3154, 3539, 197, 1066, 4997, 4601, 7712],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7354, 875, 8939, 8137, 2017, 5406, 9579, 9987, 2297, 909, 7706],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3330, 1098, 694, 5139, 8784, 694, 904, 8629, 8989, 7139, 7699],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4582, 8864, 8572, 6549, 8602, 4184, 9670, 3921, 5710, 3293, 7693],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4082, 8704, 689, 1677, 9680, 1316, 8505, 498, 3098, 9370, 7686],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3102, 4756, 8575, 5990, 2683, 5020, 3315, 685, 1792, 5370, 7680],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5280, 4982, 7619, 6032, 2702, 3206, 9366, 4493, 2432, 1293, 7674],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8092, 7683, 983, 1859, 6105, 7569, 7279, 9617, 5659, 7139, 7667],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7959, 987, 8028, 1617, 2295, 4335, 8958, 1423, 2116, 2909, 7661],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2384, 8073, 4067, 8201, 8063, 7592, 3431, 2947, 2443, 8602, 7654],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1055, 2682, 4909, 9186, 9901, 5859, 2625, 4884, 7284, 4218, 7648],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9971, 4841, 9679, 8383, 7305, 2516, 7055, 5585, 7283, 9758, 7641],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1188, 4909, 2205, 208, 7773, 753, 1442, 1051, 3085, 5222, 7635],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6185, 7318, 8480, 6649, 1836, 3679, 253, 4922, 5334, 609, 7629],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3980, 6759, 92, 830, 4138, 227, 3166, 8475, 4677, 5920, 7622],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5990, 188, 6037, 847, 4177, 7516, 453, 617, 1762, 1155, 7616],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1444, 5478, 3911, 2827, 8016, 298, 8298, 7875, 7234, 6313, 7609],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6023, 2492, 2515, 2661, 9844, 8153, 4022, 4396, 1744, 1396, 7603],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6690, 7259, 8469, 1829, 9925, 1068, 1253, 1933, 5940, 6402, 7596],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [330, 5741, 7371, 3821, 3078, 4056, 4997, 9843, 471, 1333, 7590],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [482, 8198, 3564, 3955, 9441, 1457, 6654, 5081, 5990, 6187, 7583],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8449, 71, 929, 6780, 6872, 1585, 8942, 2191, 3147, 966, 7577],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7602, 4211, 9797, 1609, 1947, 2348, 755, 3302, 2594, 5669, 7570],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1601, 5095, 2587, 8051, 4087, 8516, 1940, 8117, 4984, 296, 7564],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6614, 8243, 3928, 9547, 4959, 1279, 8003, 3912, 972, 4848, 7557],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4076, 1755, 1651, 3906, 2832, 744, 4730, 5528, 1211, 9324, 7550],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [328, 8266, 5237, 5417, 9179, 2031, 2745, 5361, 6357, 3724, 7544],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7428, 950, 1199, 3442, 2363, 5626, 1983, 3359, 7066, 8049, 7537],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3646, 9888, 3877, 7173, 790, 2629, 6092, 7014, 3994, 2299, 7531],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5088, 3564, 9713, 5574, 5493, 5578, 6755, 1357, 7800, 6473, 7524],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2445, 5229, 7864, 5194, 9622, 5486, 7944, 8949, 9140, 572, 7518],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8261, 5924, 5907, 6581, 9883, 5755, 91, 9877, 8675, 4596, 7511],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1203, 3431, 2267, 2304, 2478, 3627, 4189, 1743, 7065, 8545, 7504],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5242, 2338, 4027, 6022, 3630, 9827, 5814, 9664, 4968, 2419, 7498],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6088, 707, 7299, 2605, 2307, 7067, 9078, 6260, 3048, 6218, 7491],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5846, 9152, 5627, 3869, 241, 8056, 497, 1651, 1966, 9942, 7484],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9751, 2134, 8811, 3016, 1882, 3691, 2795, 3445, 2384, 3591, 7478],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9780, 7330, 9538, 3269, 4387, 2086, 8624, 6738, 4966, 7165, 7471],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4630, 8315, 8587, 2368, 5265, 9100, 4215, 4105, 377, 665, 7465],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4260, 9778, 1774, 4531, 2765, 1030, 2955, 5590, 9281, 4089, 7458],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [760, 1955, 4970, 5033, 1585, 132, 8879, 8703, 2344, 7440, 7451],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7105, 5900, 9390, 9715, 3940, 3637, 102, 8415, 233, 716, 7445],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6908, 239, 931, 2351, 3507, 6926, 2167, 7144, 3615, 3917, 7438],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8204, 9670, 7957, 6883, 7200, 1528, 1321, 4757, 3158, 7044, 7431],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1245, 9934, 5945, 8963, 7218, 8616, 7713, 8557, 9530, 96, 7425],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8581, 2217, 9401, 1882, 3204, 8659, 8528, 3281, 3402, 3075, 7418],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3171, 3609, 7185, 5926, 1833, 7906, 1033, 1090, 5443, 5979, 7411],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8595, 531, 2789, 7158, 8569, 2370, 5559, 1561, 6324, 8809, 7404],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4212, 7828, 3133, 1739, 3732, 9983, 8402, 1686, 6717, 1565, 7398],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1773, 647, 5607, 4931, 2467, 1583, 4660, 5861, 7294, 4247, 7391],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7944, 5114, 1425, 9883, 5606, 1424, 979, 5879, 8729, 6855, 7384],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6742, 2080, 2915, 87, 5807, 7865, 8243, 924, 1696, 9390, 7377],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8303, 8103, 2410, 942, 764, 4916, 4181, 7568, 6868, 1850, 7371],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9596, 5847, 1388, 64, 2689, 5316, 5897, 9757, 4922, 4237, 7364],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6842, 456, 1022, 2836, 608, 5822, 2335, 8811, 6534, 6550, 7357],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5011, 6789, 1113, 9042, 9439, 5371, 6664, 3412, 2381, 8790, 7350],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8662, 8666, 5518, 8260, 7160, 6811, 8591, 9602, 3139, 956, 7344],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6992, 3502, 1620, 5905, 8748, 2853, 6602, 773, 9489, 3048, 7337],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6976, 3213, 2691, 8327, 2936, 6949, 125, 7661, 2107, 5068, 7330],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5434, 3087, 9337, 4158, 5175, 9749, 1627, 8338, 1675, 7014, 7323],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4128, 8405, 4543, 8, 7530, 1838, 8631, 8208, 8873, 8886, 7316],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8129, 1476, 1769, 1644, 3593, 3415, 5659, 0, 4383, 686, 7310],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9749, 7518, 3278, 6846, 3809, 1603, 6111, 3757, 8885, 2412, 7303],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1393, 2732, 3471, 3096, 3942, 6075, 4059, 6834, 3063, 4066, 7296],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8553, 3620, 6922, 2135, 6721, 3668, 5978, 3888, 7601, 5646, 7289],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8472, 7449, 1587, 4088, 4030, 2677, 2395, 6874, 3182, 7154, 7282],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1106, 4103, 3050, 6228, 4287, 7504, 9472, 5034, 492, 8589, 7275],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8481, 1290, 5547, 5520, 6970, 4356, 515, 4897, 216, 9951, 7268],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1766, 4430, 125, 9676, 3531, 8669, 7404, 262, 3041, 1240, 7262],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5307, 7973, 707, 8604, 1228, 4944, 1961, 2203, 9653, 2456, 7255],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [12, 4076, 6803, 6700, 3666, 9688, 7233, 9051, 740, 3601, 7248],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1470, 1406, 9525, 6341, 9128, 8141, 8715, 6396, 6992, 4672, 7241],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7038, 9540, 8538, 4167, 5022, 5479, 5489, 7075, 9097, 5671, 7234],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5490, 1737, 5385, 4173, 4031, 3177, 1298, 1166, 7746, 6598, 7227],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7507, 8279, 7739, 5202, 4806, 1233, 5545, 5981, 3628, 7453, 7220],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2833, 6939, 4794, 5086, 7275, 6930, 4219, 6062, 7436, 8235, 7213],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3730, 2169, 1880, 9317, 9881, 834, 753, 3170, 9862, 8945, 7206],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8700, 6222, 9279, 8724, 3292, 718, 6800, 6279, 1598, 9584, 7199],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6008, 6644, 3119, 8049, 2335, 4100, 2949, 1573, 3339, 150, 7193],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6826, 3170, 3199, 5514, 5138, 99, 9362, 2432, 5778, 644, 7186],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6792, 2418, 2250, 2434, 5653, 1290, 6337, 9433, 9610, 1066, 7179],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4941, 9273, 2722, 1439, 2945, 6258, 4806, 336, 5533, 1417, 7172],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [268, 4149, 764, 2036, 7820, 3546, 6757, 81, 4241, 1696, 7165],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5543, 3298, 3296, 2838, 4551, 7697, 5581, 781, 6432, 1903, 7158],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9667, 3593, 4409, 846, 2642, 8073, 6356, 1713, 2804, 2039, 7151],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5471, 9990, 3751, 9548, 739, 1166, 6051, 9313, 4055, 2103, 7144],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [237, 4473, 4993, 9286, 1973, 7085, 3660, 7168, 886, 2096, 7137],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1984, 2983, 266, 5215, 7152, 925, 273, 6009, 3996, 2017, 7130],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8363, 4277, 925, 188, 9407, 9715, 9059, 3703, 4086, 1867, 7123],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3080, 909, 875, 1998, 1010, 5644, 5198, 5251, 1857, 1646, 7116],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9064, 196, 1696, 6456, 237, 6265, 5721, 2773, 8012, 1353, 7109],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7805, 5528, 5127, 9800, 3268, 2388, 9296, 5507, 3253, 990, 7102],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9944, 6833, 5106, 5761, 3249, 4350, 5931, 9801, 8284, 555, 7095],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4542, 9818, 6217, 4235, 5749, 7372, 6614, 9103, 3810, 50, 7088],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8490, 4913, 6449, 9849, 6964, 6710, 2877, 3958, 536, 9474, 7080],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3374, 6427, 8666, 9663, 8111, 3297, 6290, 1997, 9167, 8826, 7073],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1453, 4028, 6999, 9794, 6551, 587, 7885, 7934, 409, 8109, 7066],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9597, 9838, 1881, 764, 1284, 3303, 7509, 3556, 4971, 7320, 7059],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2147, 2930, 1989, 834, 7513, 8796, 3107, 7717, 3559, 6461, 7052],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1182, 4489, 4685, 5386, 2080, 1730, 9934, 6329, 6883, 5531, 7045],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3271, 1608, 1449, 8495, 8610, 2780, 9691, 2360, 5652, 4531, 7038],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9529, 7551, 4387, 135, 8285, 2083, 9602, 5821, 575, 3461, 7031],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9180, 2400, 8423, 8909, 9206, 8118, 1409, 3763, 2364, 2320, 7024],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5758, 6958, 5765, 5681, 4372, 2752, 306, 266, 1730, 1109, 7017],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7801, 4477, 326, 8013, 5291, 3144, 3792, 6436, 9384, 9827, 7009],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3928, 8928, 5920, 8744, 5341, 1233, 466, 397, 6041, 8476, 7002],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5385, 1983, 334, 4346, 3958, 1509, 8742, 7280, 2412, 7055, 6995],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8573, 4566, 5149, 9758, 9784, 7788, 5499, 9223, 9213, 5563, 6988],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [761, 4678, 6956, 6249, 7912, 9706, 4661, 5356, 7159, 4002, 6981],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3899, 1427, 8172, 7257, 3344, 9635, 5703, 1799, 6965, 2371, 6974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8601, 1017, 4926, 4232, 9816, 749, 2092, 1654, 9347, 670, 6967],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [500, 1210, 5727, 20, 88, 6954, 9652, 4995, 5022, 8900, 6959],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1767, 3104, 9072, 1324, 812, 5380, 4871, 8867, 4708, 7060, 6952],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5024, 5519, 2651, 4112, 2049, 2185, 3123, 7271, 9124, 5150, 6945],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7742, 3574, 3911, 6494, 8473, 2356, 6831, 1162, 8989, 3171, 6938],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7441, 5086, 4768, 2483, 6268, 4248, 3558, 8442, 5021, 1123, 6931],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8683, 8955, 6215, 7060, 6667, 9564, 4027, 3949, 7943, 9005, 6923],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [890, 5649, 6170, 8123, 4043, 9512, 74, 9454, 8474, 6818, 6916],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8398, 9021, 1625, 4029, 3374, 7844, 2528, 3650, 7338, 4562, 6909],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1747, 6746, 154, 6545, 8863, 1509, 9026, 2148, 5256, 2237, 6902],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9424, 4066, 2956, 8010, 2406, 9639, 1754, 7470, 2951, 9843, 6894],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7295, 4798, 9561, 8297, 7508, 1581, 5129, 9036, 1148, 7380, 6887],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [885, 5400, 1327, 1713, 1176, 4722, 3394, 3165, 572, 4848, 6880],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8992, 9223, 6045, 6175, 3202, 2798, 8165, 3061, 1947, 2247, 6873],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9494, 7766, 9094, 6854, 9165, 5445, 5892, 8811, 5999, 9577, 6865],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3583, 2471, 8133, 3783, 337, 9694, 5262, 7373, 3456, 6839, 6858],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6976, 9223, 9553, 7800, 593, 4139, 4529, 2572, 5045, 4032, 6851],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7508, 6215, 7750, 1397, 7281, 6522, 8772, 5091, 1493, 1157, 6844],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1363, 2418, 5393, 599, 9862, 5441, 7094, 2466, 3530, 8213, 6836],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3493, 3675, 7735, 826, 7024, 6918, 9742, 9075, 1884, 5201, 6829],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3447, 5281, 645, 3693, 9784, 6557, 5166, 6135, 7287, 2120, 6822],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9011, 3442, 5409, 2829, 4968, 8024, 7005, 1690, 469, 8972, 6814],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4450, 420, 8986, 5016, 276, 8567, 1008, 609, 2161, 5755, 6807],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1547, 866, 2637, 8084, 8984, 2321, 1885, 4573, 3095, 2470, 6800],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7798, 2683, 1725, 9132, 9142, 2126, 88, 2073, 4005, 9117, 6792],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4269, 5383, 2788, 5586, 8953, 577, 8530, 8398, 5623, 5696, 6785],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4127, 8032, 9234, 7320, 6820, 1060, 9229, 5633, 8685, 2207, 6778],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [577, 4825, 3424, 539, 1356, 9492, 9888, 2646, 3925, 8651, 6770],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4692, 4812, 482, 3192, 3425, 7504, 409, 5085, 2078, 5027, 6763],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2597, 4538, 8619, 7388, 9102, 7806, 9331, 5365, 3881, 1335, 6756],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8599, 1388, 3487, 6445, 9178, 2462, 211, 2671, 71, 7576, 6748],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [63, 3425, 2322, 2833, 7637, 4814, 7928, 2937, 1385, 3749, 6741],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [599, 5996, 262, 8309, 8284, 5796, 4928, 8852, 8561, 9854, 6733],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3795, 6648, 9893, 8807, 5463, 5372, 7394, 9842, 2339, 5893, 6726],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2759, 6999, 201, 4244, 1539, 9834, 1352, 2070, 3459, 1864, 6719],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3761, 8570, 7775, 7082, 582, 5704, 8712, 8422, 2659, 7768, 6711],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5828, 6953, 7202, 3387, 4413, 977, 3235, 8508, 682, 3605, 6704],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4389, 2439, 5714, 5909, 3886, 4446, 6439, 8645, 8269, 9374, 6696],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9310, 8850, 6637, 631, 5032, 3846, 3438, 1858, 6163, 5077, 6689],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6726, 2160, 5130, 5929, 6361, 3567, 8708, 7866, 5105, 713, 6682],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9627, 2495, 6881, 7085, 368, 2671, 1792, 3081, 5841, 6282, 6674],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [752, 9641, 5513, 8253, 8938, 3955, 2935, 593, 9114, 1784, 6667],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9926, 8436, 7583, 9018, 9078, 4818, 8654, 169, 5669, 7220, 6659],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3135, 1581, 6453, 3398, 2057, 651, 7240, 8244, 6251, 2589, 6652],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3758, 4678, 9668, 5379, 5719, 1517, 4192, 7911, 1608, 7892, 6644],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4327, 6504, 1344, 6858, 6411, 2863, 7589, 8915, 2486, 3128, 6637],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8360, 621, 4737, 1039, 3605, 997, 3391, 7648, 9633, 8297, 6629],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8254, 3417, 4693, 6935, 6965, 4091, 674, 7137, 3797, 3401, 6622],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9437, 2166, 9792, 8447, 2257, 9456, 6802, 7039, 5727, 8438, 6614],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8669, 8373, 5219, 4650, 9109, 7825, 2530, 3636, 6173, 3409, 6607],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2434, 6386, 6073, 6146, 294, 5416, 7039, 9821, 5884, 8314, 6599],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [522, 8041, 3836, 5765, 8812, 4492, 2909, 5098, 5613, 3153, 6592],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3661, 3544, 3999, 271, 5657, 3210, 1024, 5568, 6110, 7926, 6584],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1315, 5782, 8730, 3152, 7776, 5464, 5410, 3925, 8128, 2633, 6577],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9906, 1609, 4398, 6845, 2325, 1515, 8010, 9449, 2419, 7275, 6569],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3432, 664, 9599, 5879, 9904, 128, 3388, 7997, 9738, 1850, 6562],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4465, 7265, 5984, 347, 6057, 2997, 3373, 1994, 839, 6361, 6554],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9270, 4128, 3049, 1687, 6890, 2181, 1635, 429, 6476, 805, 6547],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8851, 7223, 1479, 54, 1236, 1337, 8193, 8844, 7404, 5184, 6539],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9860, 4426, 662, 4356, 8343, 1477, 3861, 9331, 4381, 9498, 6531],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4077, 4259, 8299, 2385, 6642, 2030, 4627, 518, 8164, 3746, 6524],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9705, 1579, 8318, 9258, 5667, 7938, 5966, 7567, 9508, 7929, 6516],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3809, 6806, 2687, 7530, 9775, 3568, 7091, 2164, 9174, 2047, 6509],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [442, 8298, 9399, 1841, 8804, 4184, 5131, 2512, 7919, 6100, 6501],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1599, 6836, 9560, 4673, 7372, 5736, 9254, 3322, 6503, 88, 6494],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6549, 4716, 8819, 7684, 1013, 3734, 4718, 5809, 5686, 4011, 6486],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1798, 9549, 562, 5150, 3854, 1956, 6858, 7679, 6229, 7869, 6478],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3156, 2351, 9502, 2086, 9052, 1762, 5010, 3127, 8894, 1662, 6471],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1276, 3571, 4315, 9723, 9697, 2762, 6369, 2825, 4442, 5391, 6463],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [545, 3104, 7482, 4954, 4376, 5607, 9782, 3917, 3636, 9055, 6455],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6447, 2737, 719, 8283, 8054, 7663, 9477, 11, 7240, 2654, 6448],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [402, 7497, 7607, 6374, 5442, 2337, 8727, 1170, 6017, 6189, 6440],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7321, 2482, 4005, 740, 430, 2803, 3447, 3906, 732, 9660, 6432],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7020, 7538, 5263, 3076, 1665, 908, 5733, 1170, 2151, 3066, 6425],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1972, 617, 1580, 441, 782, 2017, 7329, 2348, 1039, 6408, 6417],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4639, 9230, 4131, 9603, 6227, 6556, 3035, 3251, 8163, 9685, 6409],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1793, 1623, 954, 9546, 2077, 9032, 4049, 6106, 4290, 2899, 6402],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1754, 1935, 9483, 4144, 7641, 5279, 1244, 9552, 188, 6049, 6394],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [243, 2708, 9816, 3434, 90, 8721, 8380, 8628, 6626, 9134, 6386],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7849, 5484, 7229, 1538, 8745, 6389, 5258, 4771, 4373, 2156, 6379],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8769, 48, 3380, 2209, 6057, 5498, 801, 5802, 4198, 5114, 6371],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3733, 7770, 2651, 8969, 6721, 1312, 6079, 5921, 6872, 8008, 6363],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5005, 2338, 3837, 5938, 2742, 7104, 7264, 5702, 3166, 839, 6356],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7657, 1052, 9076, 7580, 8645, 6954, 8529, 2081, 3852, 3606, 6348],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1568, 8836, 3790, 693, 7418, 2177, 4874, 8351, 9701, 6309, 6340],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [932, 6435, 6102, 9943, 4100, 2132, 4894, 4152, 1488, 8950, 6332],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1027, 5665, 5508, 9088, 333, 203, 3485, 5466, 9985, 1526, 6325],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2669, 6765, 2842, 3584, 9485, 5713, 4481, 4607, 5967, 4040, 6317],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9325, 7944, 1888, 6590, 8352, 2555, 3235, 215, 209, 6491, 6309],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9542, 6687, 3406, 9298, 7742, 5296, 9127, 7246, 3485, 8878, 6301],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6229, 3946, 1479, 8025, 573, 3553, 8020, 6968, 6573, 1202, 6294],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [760, 5945, 7477, 4521, 2449, 5395, 4643, 6949, 249, 3464, 6286],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9552, 2492, 6823, 2429, 5977, 565, 4919, 1051, 5291, 5662, 6278],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3051, 9011, 7158, 1665, 6392, 4283, 8222, 9423, 2475, 7798, 6270],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1162, 6685, 3297, 3701, 2350, 2417, 9581, 8493, 2582, 9871, 6262],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3306, 3637, 5034, 4145, 2039, 8797, 1810, 960, 6391, 1881, 6255],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3480, 5984, 9903, 4680, 1031, 5454, 7587, 5783, 4680, 3829, 6247],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2695, 7446, 6420, 4181, 4576, 6556, 1458, 8181, 8231, 5714, 6239],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3368, 2634, 7158, 8688, 3294, 6830, 1790, 9616, 7825, 7537, 6231],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [448, 7707, 8894, 1784, 7486, 5240, 2654, 7792, 4244, 9298, 6223],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6137, 7217, 3508, 713, 1514, 4716, 5648, 6644, 8270, 996, 6216],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1920, 7325, 3534, 9283, 5971, 8697, 1658, 6332, 686, 2633, 6208],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8198, 4227, 6401, 6120, 1561, 5295, 2558, 3230, 2276, 4207, 6200],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1144, 1515, 8150, 6098, 4843, 9834, 2842, 9922, 3823, 5719, 6192],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7114, 3883, 8501, 3763, 2232, 6577, 1204, 5192, 6114, 7169, 6184],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [258, 216, 2880, 176, 4819, 399, 2045, 4016, 9933, 8557, 6176],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8144, 5672, 2606, 8782, 2803, 9213, 6924, 7555, 6066, 9884, 6168],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [510, 2053, 1866, 1623, 4514, 7916, 5952, 3148, 5301, 1149, 6161],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7841, 8872, 24, 4343, 1166, 4657, 9111, 4301, 8424, 2352, 6153],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7377, 23, 1900, 6989, 4710, 199, 7523, 683, 6224, 3494, 6145],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8066, 9266, 9026, 7467, 2261, 1178, 4652, 8115, 9488, 4574, 6137],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [239, 6305, 4893, 5642, 6784, 8029, 7447, 8563, 9007, 5593, 6129],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1620, 1379, 432, 8397, 9853, 8387, 7423, 132, 5571, 6551, 6121],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4736, 7516, 7434, 9460, 8452, 6735, 1677, 7056, 9968, 7447, 6113],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5000, 8837, 2469, 2343, 3915, 1099, 3848, 9689, 2991, 8283, 6105],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7666, 5749, 8561, 304, 7240, 7577, 5011, 4501, 5432, 9057, 6097],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4433, 6594, 3412, 3816, 1137, 3498, 4518, 4067, 8082, 9770, 6089],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6570, 7757, 9128, 3390, 5269, 9988, 764, 7060, 1734, 423, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8066, 8159, 7864, 3933, 7261, 4759, 1909, 8242, 7182, 1014, 6074],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1246, 3608, 9984, 5791, 8155, 5889, 6522, 8458, 5220, 1545, 6066],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3220, 8526, 6405, 7437, 7066, 7404, 4179, 4628, 6643, 2015, 6058],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1107, 2517, 5809, 5120, 5885, 7448, 5991, 9736, 2245, 2425, 6050],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5564, 7285, 2089, 5821, 945, 9839, 5074, 2826, 2824, 2774, 6042],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6227, 6712, 460, 1359, 4639, 9802, 6960, 8991, 9174, 3062, 6034],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2788, 7294, 5311, 3508, 6022, 4684, 9945, 9367, 2094, 3291, 6026],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9745, 8709, 3498, 2378, 5503, 434, 5377, 1125, 2382, 3459, 6018],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6086, 4953, 8158, 3064, 4746, 4657, 7885, 7460, 834, 3567, 6010],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7107, 339, 6169, 8632, 8962, 7034, 5549, 7588, 8251, 3614, 6002],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9536, 8009, 3600, 747, 4782, 7910, 5, 6734, 5432, 3602, 5994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3485, 4700, 5265, 2723, 2916, 5840, 6494, 6124, 3177, 3530, 5986],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3605, 1071, 4966, 3298, 844, 4907, 3849, 2982, 2287, 3398, 5978],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6871, 7647, 1221, 3038, 6739, 2598, 4424, 515, 3563, 3206, 5970],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [399, 3380, 8861, 8861, 1860, 9051, 3960, 7910, 7806, 2954, 5962],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2696, 9271, 513, 5686, 4619, 8458, 1397, 324, 5821, 2643, 5954],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1284, 2866, 5032, 7561, 5497, 3449, 8618, 8875, 8408, 2272, 5946],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9611, 3355, 4438, 3869, 7983, 3236, 139, 639, 6374, 1842, 5938],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6669, 3448, 43, 9073, 6633, 6337, 2740, 8633, 520, 1353, 5930],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5969, 6, 5741, 7146, 9342, 8673, 5034, 1816, 1654, 804, 5922],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3782, 8883, 6672, 4057, 6826, 7852, 6977, 5076, 579, 196, 5914],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4956, 5588, 9900, 3498, 8289, 4433, 9319, 9223, 8102, 9528, 5905],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3114, 586, 6568, 2401, 8152, 989, 2996, 982, 5031, 8802, 5897],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7456, 3359, 9290, 3544, 4653, 9763, 8462, 2981, 2171, 8017, 5889],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [716, 4889, 1948, 2754, 7045, 9730, 4967, 3750, 331, 7173, 5881],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5689, 6771, 310, 7688, 4015, 3875, 9766, 7705, 319, 6270, 5873],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9190, 6417, 332, 3998, 1859, 7484, 7276, 5147, 2945, 5308, 5865],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3527, 3813, 6836, 2642, 6816, 8269, 8177, 2248, 9018, 4287, 5857],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [416, 6958, 9539, 9289, 1875, 9131, 8446, 1047, 9348, 3208, 5849],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4685, 5449, 7941, 2993, 4218, 4362, 8339, 9440, 4745, 2071, 5841],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6546, 183, 3996, 6618, 5328, 116, 1310, 1173, 6023, 875, 5833],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6888, 3446, 5278, 5752, 1681, 9939, 2874, 5831, 3991, 9621, 5824],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4034, 1393, 5717, 6045, 9737, 6180, 9416, 8834, 9463, 8308, 5816],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [49, 1610, 1006, 949, 4838, 8101, 6928, 1428, 3253, 6938, 5808],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3826, 7418, 7395, 2703, 9416, 7476, 9704, 673, 6173, 5509, 5800],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8929, 2671, 2390, 9013, 1767, 2525, 8966, 9440, 9037, 4022, 5792],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8138, 6302, 1447, 6137, 2441, 961, 1435, 6400, 2662, 2478, 5784],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4148, 6339, 4406, 6052, 1117, 2998, 7846, 6014, 7862, 875, 5776],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4555, 7103, 8189, 824, 2644, 5107, 1403, 8532, 5453, 9215, 5767],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [731, 2282, 8286, 1333, 6693, 5354, 6176, 9975, 6252, 7497, 5759],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5655, 664, 1376, 9955, 1281, 1128, 5441, 2136, 1077, 5722, 5751],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [47, 5128, 6779, 7659, 6181, 72, 9961, 2565, 744, 3889, 5743],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9890, 3773, 7609, 5185, 8003, 5050, 6212, 4566, 6072, 1998, 5735],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9433, 5810, 6762, 5418, 4511, 3946, 4551, 7184, 7880, 50, 5727],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5464, 6479, 2246, 9815, 1464, 5129, 7322, 5200, 6988, 8045, 5718],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8391, 5218, 5634, 5580, 1032, 9399, 6911, 9123, 4215, 5983, 5710],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9703, 2852, 2340, 2284, 6560, 9231, 3741, 5180, 383, 3864, 5702],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3170, 9372, 9388, 6633, 4198, 6141, 4208, 5308, 6312, 1687, 5694],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3082, 1195, 2715, 2152, 7616, 6986, 8562, 7147, 2824, 9454, 5685],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6495, 3441, 9888, 6465, 7733, 35, 8733, 4032, 742, 7164, 5677],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [320, 2761, 4466, 2762, 5119, 1615, 6093, 4983, 888, 4817, 5669],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9811, 5615, 4684, 3636, 8377, 4166, 9171, 4697, 4086, 2413, 5661],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6983, 9222, 2484, 4986, 7548, 6527, 1303, 3543, 1160, 9953, 5652],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4744, 4550, 368, 4762, 7218, 7268, 8229, 7547, 2934, 7436, 5644],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7854, 8826, 5466, 6169, 9701, 1903, 5633, 8393, 234, 4863, 5636],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9365, 9544, 5602, 7324, 4325, 4803, 6624, 3406, 3886, 2233, 5628],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [645, 4042, 4838, 9289, 4498, 6630, 9167, 5549, 4715, 9547, 5619],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2697, 5351, 784, 1840, 9883, 8130, 3450, 3414, 3549, 6805, 5611],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2389, 4955, 8302, 1154, 6636, 1100, 9200, 1210, 1215, 4007, 5603],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1464, 2326, 499, 5834, 4310, 7356, 2937, 8762, 8540, 1152, 5595],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [892, 8734, 5308, 7184, 3621, 6540, 5183, 1494, 6355, 8242, 5586],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3329, 6338, 2442, 6492, 4902, 3583, 7601, 428, 5487, 5276, 5578],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9177, 4844, 9925, 5993, 2673, 6658, 87, 2173, 6766, 2254, 5570],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2942, 8643, 1474, 1393, 7344, 6448, 7806, 8913, 1022, 9177, 5561],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5198, 4369, 6104, 1988, 655, 7568, 8167, 8407, 9087, 6043, 5553],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4406, 348, 872, 9744, 7045, 2953, 7748, 3973, 1792, 2855, 5545],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7201, 11, 8783, 860, 8701, 2070, 9160, 4483, 9968, 9610, 5536],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8283, 8025, 9485, 2575, 7595, 3755, 7861, 4355, 4448, 6311, 5528],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4004, 5101, 4364, 3932, 3406, 4530, 8911, 3543, 6065, 2956, 5520],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8437, 3215, 4582, 2106, 1713, 3221, 3672, 7531, 5652, 9546, 5511],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3201, 4057, 6033, 5466, 2430, 2715, 6453, 7321, 4044, 6081, 5503],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6448, 1097, 5321, 835, 3964, 9686, 1100, 9430, 2075, 2561, 5495],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3331, 983, 2936, 5361, 4086, 3126, 7534, 5875, 581, 8986, 5486],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4564, 9537, 1728, 2934, 4049, 2515, 8224, 4172, 397, 5356, 5478],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2703, 9230, 9362, 1147, 7947, 6466, 4618, 7322, 2359, 1671, 5470],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4599, 2656, 2333, 7347, 4848, 2682, 3512, 3804, 7305, 7931, 5461],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2487, 6520, 6824, 1270, 6693, 54, 3362, 7568, 6071, 4137, 5453],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9271, 6556, 9457, 7136, 429, 3751, 547, 8026, 9496, 288, 5445],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3229, 2389, 996, 9674, 8350, 4120, 5576, 42, 8419, 6385, 5436],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9956, 7685, 1333, 6506, 6027, 259, 9237, 3927, 3677, 2428, 5428],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1890, 4257, 8366, 3429, 2710, 9071, 8693, 5428, 6111, 8416, 5419],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3484, 7406, 1358, 9386, 4505, 666, 3531, 5720, 6561, 4350, 5411],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1042, 7323, 6603, 4297, 6074, 936, 1740, 1397, 5868, 230, 5403],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1166, 1239, 5916, 5354, 2019, 2144, 5654, 4465, 4872, 6056, 5394],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [483, 2896, 3947, 5729, 4566, 2369, 7828, 2334, 4416, 1828, 5386],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3551, 192, 6491, 4033, 9532, 4654, 6864, 7808, 5341, 7546, 5377],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6886, 5871, 7716, 3042, 7995, 6689, 3184, 9077, 8491, 3210, 5369],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [785, 8983, 9317, 2252, 6467, 1875, 4748, 9708, 4709, 8821, 5360],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7260, 3180, 9444, 644, 3757, 2617, 2716, 8639, 4839, 4378, 5352],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2829, 1139, 5362, 3558, 8091, 6681, 7062, 167, 9726, 9881, 5343],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2156, 26, 3310, 773, 3428, 7468, 2130, 3944, 213, 5332, 5335],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5617, 2248, 5026, 1696, 9260, 9035, 2136, 4963, 7147, 728, 5327],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6857, 8663, 6849, 7917, 3557, 6731, 6620, 3554, 1374, 6072, 5318],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3011, 2494, 8892, 3255, 3842, 4264, 5841, 5375, 3740, 1362, 5310],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4594, 5346, 4136, 6737, 6720, 8075, 6121, 1401, 5093, 6599, 5301],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4130, 1016, 6902, 4654, 1535, 9844, 5137, 7918, 6279, 1783, 5293],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3780, 7536, 4197, 3910, 9105, 7980, 7156, 6513, 8148, 6914, 5284],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5951, 8152, 223, 196, 1840, 8957, 8219, 4067, 1548, 1993, 5276],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8641, 3626, 2654, 1135, 6815, 9314, 1274, 2746, 7328, 7018, 5267],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [72, 3663, 9171, 6289, 8687, 9206, 1253, 9990, 6337, 1991, 5259],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1799, 8225, 4714, 2821, 4614, 8320, 98, 8509, 9427, 6911, 5250],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [789, 756, 5588, 7578, 8613, 5026, 1734, 6271, 7448, 1779, 5242],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8109, 7702, 8295, 3380, 8080, 9613, 6988, 6495, 1251, 6595, 5233],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [885, 2638, 2023, 9244, 415, 2448, 8461, 7643, 1688, 1358, 5225],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4570, 1652, 8071, 1186, 2998, 7920, 5336, 3410, 9612, 6068, 5216],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9351, 582, 2268, 2017, 4944, 5024, 8150, 2715, 5875, 727, 5208],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5364, 8244, 3180, 5084, 4364, 5423, 3497, 9696, 1330, 5334, 5199],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7919, 5811, 6459, 8308, 23, 9854, 8691, 3696, 6833, 9888, 5190],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8722, 7217, 1379, 867, 1546, 3725, 6373, 9261, 3236, 4391, 5182],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6803, 4176, 7916, 5612, 7505, 2762, 9061, 6125, 1396, 8842, 5173],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6139, 1599, 700, 5628, 5947, 9555, 3657, 9207, 2167, 3241, 5165],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7598, 3526, 2, 3182, 7072, 1857, 5899, 8597, 6406, 7588, 5156],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6467, 9516, 388, 3735, 2998, 3502, 4753, 9553, 4969, 1884, 5148],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3328, 9766, 6613, 6460, 4695, 8783, 6768, 2488, 8714, 6128, 5139],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3596, 2006, 6315, 5976, 1343, 1162, 370, 2965, 8497, 321, 5131],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4968, 2463, 3589, 7550, 2526, 7153, 101, 1684, 5177, 4463, 5122],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8247, 192, 887, 9910, 8827, 6251, 821, 4478, 9612, 8553, 5113],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9187, 2544, 4064, 5905, 1519, 7756, 1842, 2302, 2662, 2593, 5105],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [848, 8708, 2884, 1565, 7183, 5345, 1023, 1225, 5186, 6581, 5096],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6998, 8102, 3703, 8548, 8211, 274, 8807, 2420, 8044, 518, 5088],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3140, 6687, 206, 3517, 5262, 4039, 2209, 2160, 2097, 4405, 5079],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9301, 3698, 570, 543, 2829, 1379, 8757, 1801, 8206, 8240, 5070],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3421, 6793, 4706, 9217, 4209, 4473, 373, 7784, 7232, 2025, 5062],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3566, 8947, 3692, 1638, 7221, 9193, 7213, 1615, 39, 5760, 5053],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6950, 6072, 6276, 5839, 7097, 4274, 1451, 9868, 7487, 9443, 5044],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8585, 1666, 6520, 1446, 8086, 4263, 1010, 4166, 442, 3077, 5036],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [33, 2020, 5143, 5354, 302, 7114, 3250, 1179, 9766, 6659, 5027],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8480, 2045, 8708, 966, 3474, 7282, 8600, 2613, 6323, 192, 5019],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [817, 3814, 117, 3961, 4237, 5197, 4140, 5203, 978, 3675, 5010],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8385, 5058, 6454, 604, 8695, 3960, 7134, 700, 4597, 7107, 5001],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5910, 7716, 2382, 1293, 6964, 4146, 8513, 5868, 8044, 489, 4993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4920, 3004, 6332, 2152, 1467, 7564, 6307, 2472, 2187, 3822, 4984],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7811, 2514, 677, 1210, 5728, 849, 9029, 7269, 7891, 7104, 4975],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2404, 8850, 4975, 2727, 5435, 9753, 9002, 2002, 6025, 337, 4967],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9119, 5797, 2956, 3764, 8529, 4989, 5651, 3389, 7455, 3520, 4958],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3562, 33, 9974, 841, 6056, 513, 8726, 3114, 3050, 6654, 4949],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6064, 3720, 9694, 1671, 500, 5096, 1490, 7822, 3678, 9738, 4940],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9338, 1717, 9226, 7227, 3284, 8064, 3854, 9104, 209, 2773, 4932],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9480, 6725, 4089, 2949, 8077, 74, 5459, 3495, 3513, 5758, 4923],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8249, 613, 2480, 4500, 1494, 9789, 8707, 2461, 4459, 8694, 4914],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4486, 6963, 7258, 3227, 7737, 7322, 1756, 2393, 3918, 1581, 4906],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9203, 6801, 9907, 9224, 8622, 5335, 1446, 4594, 2761, 4419, 4897],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2444, 1303, 77, 5641, 5399, 8637, 6191, 5275, 1860, 7208, 4888],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4057, 8146, 4984, 6560, 3649, 3174, 8818, 5545, 2087, 9948, 4879],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7658, 4822, 3307, 2341, 7489, 5274, 9351, 1401, 4315, 2639, 4871],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7934, 6395, 7716, 699, 4171, 2021, 7757, 3720, 9416, 5281, 4862],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5741, 7143, 9114, 9025, 5086, 3624, 6632, 8250, 8264, 7875, 4853],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6901, 6377, 5048, 3343, 4044, 8668, 3847, 5602, 1734, 421, 4845],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3746, 5743, 6717, 1951, 8565, 3105, 5142, 1240, 700, 2918, 4836],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8662, 6551, 6323, 7051, 4814, 3873, 6667, 5474, 6036, 5366, 4827],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5060, 5008, 2986, 5521, 1624, 8003, 7484, 3450, 8619, 7766, 4818],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1028, 5019, 5675, 405, 3918, 8104, 2014, 5142, 9324, 118, 4810],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8541, 2483, 1104, 7592, 681, 5093, 2436, 5341, 9028, 2422, 4801],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7727, 1830, 9650, 7492, 7455, 9042, 1039, 3650, 8608, 4678, 4792],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2471, 350, 356, 9303, 8132, 9034, 2529, 4472, 8941, 6886, 4783],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6770, 3990, 5060, 5509, 5668, 2884, 6282, 7003, 905, 9047, 4774],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [58, 9773, 691, 6733, 6101, 7620, 8551, 5223, 5379, 1159, 4766],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6511, 4589, 7621, 1644, 5083, 1595, 4632, 7887, 3241, 3224, 4757],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5883, 1981, 1450, 3573, 888, 9106, 968, 8515, 5371, 5241, 4748],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9600, 839, 7357, 4447, 2667, 8402, 7223, 5384, 2649, 7211, 4739],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [514, 136, 2634, 7868, 7452, 3963, 8292, 1522, 5955, 9133, 4730],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8802, 7777, 7704, 6297, 4199, 3924, 6273, 4695, 6169, 1008, 4722],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7846, 9072, 3009, 2603, 7885, 3524, 2391, 7400, 4173, 2836, 4713],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1081, 8868, 3798, 3363, 1431, 5473, 8871, 6855, 849, 4617, 4704],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7404, 2094, 3129, 479, 7945, 8096, 767, 4995, 7079, 6350, 4695],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5616, 8762, 2137, 8620, 496, 2165, 7743, 8454, 3745, 8037, 4686],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5861, 2558, 3715, 8852, 1365, 7266, 5803, 8567, 1731, 9677, 4677],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9465, 5399, 9745, 3404, 7388, 8620, 8984, 1352, 1921, 1270, 4669],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4978, 3846, 2636, 2859, 2740, 5215, 991, 7508, 5197, 2816, 4660],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4670, 4067, 9379, 5069, 5172, 138, 6791, 2399, 2446, 4316, 4651],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6084, 8298, 2182, 4789, 6393, 4005, 4159, 6054, 4551, 5769, 4642],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5777, 1652, 6001, 4218, 1965, 2354, 5181, 3150, 2399, 7176, 4633],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9714, 8681, 3141, 7514, 738, 7897, 7702, 3008, 6875, 8536, 4624],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4953, 4531, 2527, 6573, 8501, 8517, 6738, 9583, 8865, 9850, 4615],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6611, 6166, 990, 1180, 5164, 1894, 5833, 1454, 9258, 1118, 4607],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1538, 20, 1922, 3757, 9429, 7637, 8372, 1816, 8939, 2340, 4598],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2897, 7760, 9303, 7479, 9530, 7831, 8855, 8472, 8796, 3516, 4589],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [579, 17, 162, 6356, 3227, 6862, 4113, 3823, 9719, 4646, 4580],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7832, 5634, 4158, 6970, 4861, 1422, 4487, 4858, 2595, 5731, 4571],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5051, 1383, 4708, 3923, 1872, 1584, 4956, 3148, 8314, 6769, 4562],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2780, 1880, 1824, 4491, 7760, 3821, 6224, 4835, 7765, 7762, 4553],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [281, 1971, 3935, 2668, 3068, 6879, 5757, 624, 1839, 8710, 4544],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6730, 1214, 6122, 8471, 517, 1370, 8777, 5773, 1425, 9612, 4535],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8020, 1172, 8453, 5132, 5009, 3998, 9206, 86, 7416, 468, 4527],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2902, 5858, 4064, 4563, 3738, 7295, 573, 7903, 701, 1280, 4518],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5316, 9554, 6980, 161, 6231, 5756, 6868, 8088, 2174, 2046, 4509],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8353, 5158, 9892, 5635, 8638, 9277, 3352, 4028, 2727, 2767, 4500],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6576, 904, 8625, 8966, 1153, 4776, 7327, 3615, 3252, 3443, 4491],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8471, 8789, 132, 1899, 1933, 6891, 8852, 9244, 4642, 4074, 4482],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5083, 8157, 2713, 7383, 5415, 8659, 1424, 7801, 7792, 4660, 4473],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5103, 9899, 9864, 141, 7434, 3053, 2607, 652, 3596, 5202, 4464],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9370, 5827, 2736, 8959, 3997, 6281, 4616, 3639, 2947, 5699, 4455],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7566, 1425, 1372, 3357, 5119, 3737, 4864, 7068, 6741, 6151, 4446],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9175, 2865, 3600, 1964, 9517, 9504, 6453, 5700, 5874, 6559, 4437],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9832, 6663, 5221, 5072, 506, 298, 8633, 8743, 1241, 6923, 4428],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5415, 4227, 9563, 9557, 7831, 4744, 7201, 9843, 3739, 7242, 4419],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9867, 5812, 2994, 485, 4652, 8903, 4874, 7074, 4265, 7517, 4410],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2151, 5682, 948, 253, 3318, 8910, 1603, 2930, 3716, 7748, 4401],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5657, 8458, 2617, 3050, 8020, 1654, 4849, 4315, 2989, 7935, 4392],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8551, 5345, 8901, 9619, 6794, 4379, 9812, 2536, 2983, 8078, 4383],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7484, 5600, 5427, 4829, 9793, 4103, 9623, 3293, 4596, 8177, 4374],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1281, 3532, 9461, 8280, 5120, 7766, 5482, 6669, 8727, 8232, 4365],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4858, 1338, 6076, 6112, 7939, 3988, 6761, 7121, 6276, 8244, 4356],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [997, 1586, 5816, 212, 2922, 7356, 1055, 3474, 8143, 8212, 4347],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6287, 4073, 4853, 9221, 4505, 6117, 4199, 8907, 5227, 8137, 4338],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6270, 4299, 1838, 3924, 3777, 4200, 232, 950, 8431, 8018, 4329],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1830, 3280, 6695, 7858, 5158, 8447, 1323, 1469, 8654, 7856, 4320],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9785, 8406, 9826, 2168, 429, 1969, 7655, 6661, 6798, 7651, 4311],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7230, 2921, 796, 1852, 1943, 4516, 7257, 7045, 3766, 7403, 4302],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6813, 5466, 9657, 8552, 1242, 776, 5806, 7450, 460, 7112, 4293],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6787, 972, 8732, 2904, 3580, 7490, 6372, 7008, 7783, 6777, 4284],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3002, 5979, 5705, 7048, 3177, 299, 9134, 9145, 6638, 6400, 4275],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5924, 1975, 9258, 5353, 8356, 1215, 1037, 1573, 7930, 5980, 4266],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5699, 958, 5780, 8464, 9959, 7630, 5422, 6276, 2561, 5518, 4257],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6518, 8715, 684, 2550, 777, 3756, 1605, 9509, 1437, 5013, 4248],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2672, 7353, 1950, 2036, 7957, 5404, 4410, 1781, 5464, 4465, 4239],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3820, 1032, 9230, 50, 4658, 9020, 3669, 7852, 5545, 3875, 4230],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [779, 1431, 2511, 6327, 1446, 5853, 3673, 6720, 2588, 3243, 4221],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9055, 2082, 4136, 7303, 2202, 2192, 2580, 1614, 7499, 2568, 4212],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3770, 3893, 2131, 7612, 3524, 6560, 1784, 9984, 1183, 1852, 4203],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4478, 3027, 7334, 6012, 865, 4775, 5243, 3492, 4550, 1093, 4194],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3688, 1195, 8685, 2046, 8846, 3784, 8758, 8004, 8505, 292, 4185],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8624, 4575, 8136, 2257, 7408, 5186, 9217, 3580, 3958, 9450, 4175],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3122, 6084, 7715, 6645, 9669, 9332, 3794, 4465, 1816, 8566, 4166],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [320, 2959, 6019, 7115, 1541, 935, 9108, 9078, 2988, 7640, 4157],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7479, 102, 426, 9950, 7349, 7073, 333, 9, 8385, 6672, 4148],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8851, 1737, 6071, 3778, 9879, 8521, 281, 4001, 8914, 5663, 4139],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4912, 6413, 5551, 3064, 7428, 5293, 8428, 1948, 5487, 4613, 4130],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6823, 8356, 7722, 4758, 4616, 7324, 9906, 8885, 9013, 3521, 4121],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8703, 9294, 4047, 2428, 7838, 1195, 4456, 3976, 405, 2389, 4112],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4884, 3631, 1887, 7818, 393, 3814, 5331, 505, 573, 1215, 4103],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1457, 1573, 1922, 4402, 6460, 3953, 8169, 5870, 428, 0, 4094],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2714, 9846, 8539, 991, 7188, 2576, 9815, 1572, 884, 8744, 4084],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4338, 7533, 5343, 5841, 6314, 2840, 7107, 3206, 2852, 7447, 4075],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [350, 8113, 1744, 2894, 6800, 705, 5621, 451, 7246, 6109, 4066],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8695, 8204, 564, 1796, 4075, 7055, 8372, 7062, 4978, 4731, 4057],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6658, 509, 1292, 2040, 5576, 2242, 4481, 862, 6964, 3312, 4048],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3715, 276, 632, 9031, 328, 3974, 7790, 3729, 4116, 1853, 4039],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3118, 8306, 3684, 5961, 6393, 9448, 5449, 1592, 7350, 353, 4030],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4043, 9730, 8810, 105, 8054, 2661, 6456, 4417, 7580, 8813, 4020],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1771, 5115, 1267, 5441, 8674, 7791, 152, 6202, 5722, 7233, 4011],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5709, 9282, 172, 5336, 9191, 9582, 4689, 4963, 2692, 5613, 4002],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2507, 9909, 6374, 9400, 6233, 1639, 5445, 2731, 9406, 3952, 3993],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [742, 8809, 2346, 7380, 7889, 3549, 3402, 5538, 6780, 2252, 3984],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [331, 4097, 7235, 201, 9146, 7750, 3491, 3409, 5732, 512, 3975],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7266, 9498, 9458, 3879, 3033, 7057, 2889, 354, 7179, 8732, 3965],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [426, 8247, 5545, 5930, 7498, 3764, 9278, 4357, 2038, 6913, 3956],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [755, 9667, 7876, 6175, 2013, 1250, 9066, 7370, 1228, 5054, 3947],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6749, 3083, 7227, 4328, 1904, 8984, 5567, 5300, 5668, 3155, 3938],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3591, 6492, 983, 5461, 2348, 1874, 7146, 8001, 6276, 1217, 3929],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2822, 4894, 8065, 1359, 7947, 4857, 5312, 9267, 3972, 9240, 3919],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7640, 5637, 1220, 818, 7725, 3663, 2789, 6820, 9676, 7223, 3910],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [737, 1765, 1758, 5050, 9350, 2661, 1533, 2302, 4308, 5168, 3901],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9897, 5317, 7089, 5621, 294, 720, 718, 1266, 8788, 3073, 3892],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4959, 683, 4753, 1517, 7572, 5988, 4679, 3166, 4037, 940, 3883],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3970, 955, 5922, 9176, 1614, 535, 821, 1350, 977, 8768, 3873],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3428, 7181, 5649, 4482, 3729, 5745, 7479, 3046, 529, 6557, 3864],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2896, 6040, 6150, 8755, 485, 9418, 1753, 9360, 3615, 4307, 3855],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7105, 186, 4020, 1722, 2265, 5470, 7293, 5258, 1159, 2019, 3846],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4802, 4782, 4138, 3193, 7067, 7177, 2048, 9566, 4082, 9692, 3836],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6455, 8419, 4717, 1722, 4547, 4872, 5982, 4952, 3309, 7327, 3827],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2270, 2622, 3046, 2817, 9100, 9019, 8743, 7924, 9762, 4923, 3818],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [590, 2273, 4442, 1276, 4667, 9599, 7302, 8817, 4366, 2482, 3809],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4388, 9333, 3111, 1907, 7761, 2711, 3547, 1784, 8046, 2, 3800],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9473, 6466, 9322, 194, 9054, 5336, 1840, 4787, 1725, 7485, 3790],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9953, 4505, 9784, 9401, 7668, 9167, 6542, 9588, 6329, 4929, 3781],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8698, 7303, 5524, 3050, 6144, 4443, 9493, 1741, 2785, 2336, 3772],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8095, 2739, 2919, 1726, 7827, 4708, 7454, 581, 2017, 9705, 3762],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8070, 792, 8911, 617, 2249, 3422, 9518, 9214, 4951, 7036, 3753],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6334, 1733, 1728, 9122, 7816, 3343, 4476, 4511, 2516, 4330, 3744],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3369, 8216, 5455, 6168, 4924, 9623, 8149, 7094, 5637, 1586, 3735],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [902, 2324, 3403, 4609, 6353, 7520, 684, 1333, 5243, 8805, 3725],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4869, 3487, 5033, 5046, 5583, 5679, 3806, 5329, 2260, 5987, 3716],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7335, 3560, 8926, 3782, 7382, 5889, 8040, 912, 7618, 3131, 3707],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6750, 9747, 5379, 1160, 8773, 257, 9893, 3628, 2244, 239, 3698],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1602, 7415, 3296, 5341, 2208, 6720, 8995, 2730, 7068, 7309, 3688],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9183, 4115, 4382, 2560, 6496, 3823, 5213, 1169, 3019, 4343, 3679],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8590, 6192, 1720, 8002, 4725, 5704, 5714, 5584, 1026, 1340, 3670],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [573, 8520, 8765, 1674, 2147, 8194, 2004, 6295, 2020, 8300, 3660],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [384, 3871, 8907, 958, 639, 6982, 6923, 7290, 6931, 5223, 3651],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6297, 1658, 6128, 5832, 84, 8764, 1604, 6221, 6690, 2110, 3642],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4951, 3565, 5971, 4109, 641, 6309, 2399, 4388, 2228, 8961, 3632],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4778, 3399, 6020, 2307, 3556, 8373, 7763, 6735, 4476, 5775, 3623],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1849, 1868, 312, 2982, 1822, 5393, 5108, 1840, 4367, 2553, 3614],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9948, 3024, 7388, 1454, 5623, 1888, 7614, 1902, 2832, 9295, 3604],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5564, 8344, 2817, 3818, 1137, 6509, 1008, 2737, 804, 6001, 3595],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2760, 2131, 720, 3859, 4903, 654, 309, 3763, 9216, 2670, 3586],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3289, 2214, 2705, 9084, 9556, 6601, 6527, 7995, 9001, 9304, 3576],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6466, 8799, 5316, 5320, 359, 6074, 3341, 2036, 1094, 5903, 3567],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8530, 3906, 8018, 5341, 5531, 179, 3727, 6063, 6427, 2465, 3558],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3708, 5407, 3429, 9642, 6988, 1661, 6557, 3822, 5936, 8992, 3548],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [208, 7701, 1298, 6764, 1661, 387, 3165, 2618, 555, 5484, 3539],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7397, 6522, 9866, 6478, 7136, 3010, 3870, 3303, 1219, 1940, 3530],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1259, 9434, 6096, 1579, 8929, 7749, 4470, 270, 8864, 8360, 3520],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6872, 1144, 3891, 3014, 233, 5205, 2698, 1442, 4425, 4746, 3511],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2783, 6144, 1972, 8573, 8542, 6159, 4640, 8262, 8838, 1096, 3502],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5164, 3280, 6673, 7259, 7063, 7298, 1124, 5686, 3041, 7412, 3492],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6891, 5341, 6357, 9834, 2359, 5776, 4069, 2170, 7970, 3692, 3483],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1795, 6785, 1594, 750, 3187, 3576, 2800, 9665, 4561, 9938, 3473],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6050, 1302, 7294, 7778, 8967, 2596, 329, 3604, 3754, 6149, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5086, 9706, 9631, 3042, 9859, 1397, 9601, 2893, 6485, 2325, 3455],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4630, 7884, 2457, 2832, 3843, 4550, 9704, 9906, 3692, 8467, 3445],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5343, 6466, 6631, 3519, 9744, 5522, 2047, 470, 6316, 4574, 3436],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [942, 5993, 4008, 7030, 8547, 4046, 6500, 3856, 5293, 647, 3427],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [24, 258, 9099, 1626, 8841, 8894, 7501, 2775, 1564, 6686, 3417],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [419, 5012, 264, 2232, 5653, 7015, 132, 3364, 6068, 2690, 3408],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [76, 4042, 4076, 9074, 5394, 9960, 6153, 5175, 9745, 8660, 3398],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7263, 3760, 7522, 4076, 3040, 8545, 11, 1173, 3536, 4597, 3389],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5352, 7527, 387, 1082, 1099, 6683, 4807, 7717, 8380, 499, 3380],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7426, 4775, 2598, 8692, 3339, 5332, 8234, 4559, 5220, 6368, 3370],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7784, 12, 7762, 3143, 9627, 7497, 8479, 4830, 4996, 2203, 3361],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8424, 8198, 4696, 3229, 1619, 5228, 93, 5032, 8650, 8004, 3351],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7964, 7577, 4453, 9766, 2454, 9547, 9823, 5025, 7124, 3772, 3342],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3613, 154, 3198, 8465, 6932, 4266, 2418, 8027, 1360, 9507, 3332],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6065, 8236, 4276, 7249, 2040, 4616, 6391, 592, 2302, 5208, 3323],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7907, 3842, 9721, 7065, 1049, 1637, 9759, 2611, 891, 876, 3314],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9201, 7216, 7143, 8992, 7727, 3280, 5740, 7298, 8071, 6510, 3304],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3338, 5329, 8251, 9939, 561, 3155, 8424, 1179, 4787, 2112, 3295],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3327, 1732, 6722, 4443, 198, 7862, 8405, 4087, 1981, 7681, 3285],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1167, 6058, 3598, 914, 6630, 3870, 8386, 9149, 598, 3217, 3276],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [436, 8559, 6286, 7198, 5958, 4868, 8743, 2778, 1584, 8720, 3266],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6875, 2694, 2181, 2421, 9859, 536, 3066, 4664, 5882, 4190, 3257],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4922, 6991, 399, 9738, 4156, 7693, 3657, 7762, 4438, 9628, 3247],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2430, 9488, 6498, 7840, 6205, 4747, 7007, 8286, 8198, 5033, 3238],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2571, 3693, 7729, 7760, 4021, 415, 9227, 5698, 8108, 406, 3229],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4766, 3462, 3689, 5703, 3384, 7636, 1456, 2699, 5114, 5747, 3219],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9736, 7859, 3413, 2254, 2366, 3641, 5238, 5216, 162, 1056, 3210],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6679, 4392, 179, 3332, 5986, 7115, 7855, 2399, 4200, 6332, 3200],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7059, 7986, 5783, 8647, 6920, 3405, 7643, 6607, 8174, 1576, 3191],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3050, 4358, 3849, 9176, 1411, 8714, 9262, 3399, 3033, 6789, 3181],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2706, 6617, 4864, 6187, 2735, 4232, 8947, 1526, 9724, 1969, 3172],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7662, 8762, 3183, 700, 7786, 1156, 9714, 2920, 9195, 7118, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8571, 7279, 8013, 3803, 5524, 7538, 6544, 2686, 2395, 2236, 3153],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7475, 5969, 7388, 5051, 9223, 7911, 1534, 9091, 272, 7322, 3143],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8725, 1841, 8123, 8107, 7611, 6652, 9010, 3554, 3777, 2376, 3134],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5757, 5686, 8501, 9921, 3180, 6014, 615, 642, 3858, 7399, 3124],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8628, 9258, 7749, 1944, 9077, 9789, 363, 8051, 1464, 2391, 3115],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5518, 9526, 1821, 9201, 9137, 3551, 9664, 6604, 7547, 7351, 3105],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1995, 8277, 4328, 5404, 8771, 2416, 2311, 242, 3057, 2281, 3096],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6375, 6205, 1145, 9688, 7500, 7286, 9445, 6006, 8943, 7179, 3086],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1851, 5781, 4849, 2908, 7108, 516, 4485, 4039, 6158, 2047, 3077],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9966, 8903, 9168, 8813, 2422, 1960, 8021, 7566, 5652, 6884, 3067],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1173, 9722, 3469, 7648, 4891, 6342, 2688, 2893, 8378, 1690, 3058],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2015, 3154, 3364, 6925, 2157, 2913, 8001, 9390, 5286, 6466, 3048],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1719, 8944, 7100, 6146, 9947, 8330, 5158, 9489, 7330, 1211, 3039],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9669, 5983, 806, 9114, 5641, 3730, 1822, 8668, 5462, 5926, 3029],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5992, 5000, 2076, 9162, 5952, 6925, 6859, 5444, 635, 611, 3020],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4938, 1704, 5081, 9099, 4189, 699, 5060, 1366, 3802, 5265, 3010],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8847, 1754, 6385, 8842, 5626, 8136, 1818, 1001, 5916, 9889, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9163, 3507, 5147, 9648, 2518, 5948, 7791, 1926, 7931, 4483, 2991],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7235, 3081, 1340, 4448, 3333, 6745, 3518, 4722, 801, 9048, 2981],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1503, 8952, 9077, 9041, 3771, 1212, 4019, 2958, 5481, 3582, 2972],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2821, 4799, 8022, 8795, 160, 1137, 3355, 3187, 2925, 8087, 2962],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8563, 1949, 4060, 9951, 8779, 4248, 9166, 4933, 4088, 2562, 2953],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [86, 9371, 1836, 3701, 7678, 1822, 7175, 685, 9926, 7007, 2943],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1496, 6201, 8150, 4752, 502, 1, 5661, 5883, 1393, 1424, 2934],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7239, 2237, 9360, 4183, 4821, 5790, 9906, 8911, 9446, 5810, 2924],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4214, 8144, 1618, 8941, 388, 8689, 6613, 1089, 5042, 168, 2915],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7409, 4381, 4540, 7335, 5724, 8898, 8290, 6659, 9135, 4496, 2905],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9127, 6431, 2499, 1300, 4333, 3079, 7609, 2780, 2684, 8796, 2895],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7127, 2590, 9723, 1979, 4799, 8603, 1732, 9516, 6644, 3066, 2886],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7325, 9558, 3208, 5375, 1920, 7262, 6616, 9825, 1974, 7308, 2876],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3901, 4647, 9792, 9258, 8935, 9386, 1277, 9555, 9631, 1520, 2867],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6216, 3139, 9840, 1361, 3809, 9338, 2036, 7427, 573, 5705, 2857],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5433, 6791, 479, 1888, 5412, 3323, 6730, 5031, 5758, 9860, 2847],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6205, 9165, 7360, 711, 8329, 496, 8895, 6815, 6144, 3987, 2838],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8829, 5826, 8008, 1127, 7868, 8304, 1923, 75, 2691, 8086, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8376, 1509, 5138, 7714, 9728, 3031, 3192, 4943, 6356, 2156, 2819],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8515, 2859, 9141, 5724, 1616, 6507, 8157, 4382, 8100, 6198, 2809],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9853, 9397, 473, 3398, 6938, 9928, 4428, 4175, 8882, 212, 2800],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7844, 9373, 1078, 6659, 3538, 5768, 5809, 2912, 9662, 4198, 2790],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1184, 3708, 6357, 7824, 3257, 8713, 6310, 1985, 1400, 8157, 2780],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9296, 5798, 3649, 6118, 900, 6606, 4138, 5576, 5056, 2087, 2771],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3650, 8856, 8734, 8006, 4006, 2342, 5651, 647, 1592, 5990, 2761],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [748, 5528, 8507, 9553, 7601, 7687, 9289, 6932, 1967, 9865, 2751],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5289, 8136, 6692, 1139, 891, 9973, 9480, 6927, 7144, 3712, 2742],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6789, 7322, 2149, 6971, 5626, 2630, 512, 5880, 8084, 7532, 2732],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3105, 4678, 8846, 7787, 8644, 530, 379, 1779, 5749, 1325, 2723],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7037, 3187, 6828, 5025, 3815, 1083, 4605, 5347, 1100, 5091, 2713],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7603, 2614, 9231, 8404, 1395, 2061, 35, 31, 5101, 8829, 2703],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7515, 5235, 7386, 6430, 5505, 7112, 8600, 1988, 8713, 2540, 2694],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1023, 8388, 1039, 612, 3171, 9922, 1057, 84, 2900, 6225, 2684],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2992, 2759, 1359, 9287, 1092, 7984, 699, 5874, 8624, 9882, 2674],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7165, 1196, 9377, 5762, 9001, 6947, 7039, 3600, 6850, 3513, 2665],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4966, 254, 1416, 8010, 1153, 6505, 9469, 180, 8541, 7117, 2655],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [875, 2743, 6462, 3368, 212, 8775, 890, 5197, 4660, 695, 2646],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2023, 2800, 9907, 1594, 423, 156, 1318, 887, 6173, 4246, 2636],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1778, 8287, 6083, 3086, 9671, 7605, 1456, 2135, 4043, 7771, 2626],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [126, 8374, 2040, 6227, 2651, 315, 6255, 6461, 9235, 1269, 2617],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9064, 6330, 1458, 8484, 36, 7738, 8427, 4013, 2715, 4742, 2607],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8236, 349, 5899, 126, 1162, 4945, 1955, 7556, 5447, 8188, 2597],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2381, 5113, 7068, 7195, 370, 6265, 5556, 2460, 8398, 1608, 2588],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8534, 7762, 5770, 1619, 9786, 8176, 6133, 6696, 2532, 5003, 2578],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8277, 7996, 9024, 1098, 3877, 2422, 2194, 822, 8817, 8371, 2568],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1837, 99, 5678, 9569, 3786, 300, 7244, 7973, 8217, 1714, 2559],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5699, 7007, 2970, 648, 1982, 9113, 3156, 3856, 1701, 5032, 2549],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8011, 3249, 3090, 1462, 354, 1728, 3517, 6734, 234, 8324, 2539],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6792, 5474, 1943, 2627, 7480, 221, 6937, 7421, 4784, 1590, 2530],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6606, 250, 5286, 1843, 3303, 4575, 348, 9272, 6318, 4831, 2520],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1375, 8391, 4067, 3606, 2044, 7385, 2269, 8169, 5804, 8047, 2510],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7182, 1132, 6426, 5837, 6701, 5558, 6046, 2517, 4210, 1238, 2501],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8373, 4698, 4202, 5832, 1013, 9961, 3067, 3232, 2503, 4404, 2491],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6919, 8131, 4165, 2735, 7294, 3982, 5957, 3729, 1652, 7545, 2481],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8897, 2657, 6232, 1800, 1050, 1993, 1738, 9917, 2625, 661, 2472],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4406, 5555, 1813, 6919, 5795, 8651, 4974, 184, 6393, 3752, 2462],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8389, 4711, 4880, 2295, 3972, 42, 889, 5393, 3922, 6819, 2452],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [582, 2418, 7255, 1688, 2359, 7603, 8450, 8866, 6183, 9861, 2442],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8343, 4948, 9870, 4289, 2836, 5816, 3445, 6382, 4146, 2879, 2433],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4270, 3039, 6046, 49, 1821, 4631, 1516, 6159, 8780, 5872, 2423],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1770, 3245, 5003, 4080, 4152, 7589, 1181, 8850, 1055, 8842, 2413],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3436, 445, 8581, 9616, 9644, 6619, 6828, 7531, 1942, 1787, 2404],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9867, 2282, 7167, 1878, 2958, 4476, 1682, 7694, 2411, 4708, 2394],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4512, 190, 8839, 1057, 9860, 5784, 751, 7232, 3433, 7605, 2384],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3444, 2557, 6309, 1474, 5372, 7676, 3748, 6434, 5979, 478, 2375],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9905, 349, 8075, 5733, 1688, 969, 7988, 7974, 1020, 3328, 2365],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5152, 6370, 2761, 7409, 6157, 2876, 1258, 6902, 9528, 6153, 2355],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5422, 6523, 9596, 3382, 1997, 2211, 4672, 630, 2475, 8956, 2345],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2719, 5398, 4760, 7435, 6790, 8053, 5492, 8929, 831, 1735, 2336],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2825, 2303, 5536, 5, 6177, 2861, 9935, 3914, 5571, 4490, 2326],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [776, 5786, 5188, 5181, 2502, 988, 5946, 38, 7666, 7222, 2316],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4371, 215, 5783, 4936, 548, 3584, 5958, 4078, 8088, 9931, 2306],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6987, 2554, 9112, 2346, 4784, 853, 9624, 5129, 7811, 2617, 2297],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3058, 8473, 3922, 14, 4923, 2639, 6523, 4594, 7808, 5280, 2287],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9375, 6345, 8075, 7130, 8873, 8308, 8849, 6171, 9052, 7920, 2277],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9277, 4161, 5462, 8544, 4488, 6911, 4074, 5848, 2517, 538, 2268],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8500, 5692, 8737, 1800, 3806, 8586, 7585, 1888, 9177, 3132, 2258],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1652, 7622, 480, 3400, 5769, 8189, 5305, 4825, 5, 5705, 2248],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7548, 1602, 8533, 3430, 5690, 2115, 6286, 7449, 5976, 8254, 2238],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5506, 3234, 8165, 8267, 1984, 9288, 5279, 4800, 8065, 781, 2229],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1582, 865, 7635, 4145, 2969, 7294, 5290, 4156, 7246, 3286, 2219],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5597, 8560, 8746, 122, 8759, 4634, 100, 5025, 4494, 5769, 2209],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5163, 7, 5373, 7190, 5540, 68, 6774, 9132, 784, 8230, 2199],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2421, 8967, 6660, 1062, 1730, 22, 8142, 415, 7093, 668, 2190],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4317, 9949, 4917, 9456, 7734, 5043, 5261, 5010, 4394, 3085, 2180],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [308, 2269, 9009, 438, 3261, 6273, 9854, 1242, 3665, 5480, 2170],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9723, 5560, 1558, 6635, 8294, 2906, 6725, 9619, 5880, 7853, 2160],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1884, 3069, 2337, 758, 6086, 1629, 6154, 2817, 2018, 205, 2151],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1607, 4637, 1939, 995, 8639, 8994, 6271, 5674, 3053, 2535, 2141],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5944, 6672, 1157, 260, 7382, 7723, 5410, 5179, 9963, 4843, 2131],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2479, 4306, 5328, 1169, 3856, 7903, 4434, 462, 3725, 7131, 2121],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [280, 7056, 3232, 8794, 7408, 4059, 9048, 2784, 5315, 9397, 2111],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2545, 3918, 1816, 5770, 9020, 9081, 2083, 5530, 5711, 1642, 2102],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1560, 4300, 6909, 9185, 2523, 5975, 5767, 4193, 5891, 3866, 2092],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6641, 4069, 3123, 5791, 6598, 8420, 3964, 6372, 6832, 6069, 2082],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2234, 8977, 1024, 1463, 3034, 1117, 4404, 1756, 9513, 8251, 2072],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4538, 1926, 5321, 2490, 8857, 886, 880, 2118, 4911, 413, 2063],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8689, 2654, 3940, 117, 2011, 9517, 5435, 1302, 4005, 2554, 2053],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3954, 2545, 5299, 5827, 2357, 9323, 524, 5218, 7773, 4674, 2043],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5615, 7423, 1474, 3112, 1847, 2404, 1151, 1826, 7195, 6774, 2033],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4933, 2972, 1131, 1862, 9761, 4574, 6990, 1131, 3249, 8854, 2023],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7504, 328, 1628, 4076, 986, 4951, 4489, 5173, 6914, 913, 2014],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [194, 8922, 9380, 4243, 7328, 2165, 8946, 8013, 9170, 2952, 2004],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4859, 3064, 6964, 4530, 3896, 8198, 6568, 5729, 997, 4972, 1994],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7189, 1556, 1222, 3738, 4623, 794, 6515, 6401, 3374, 6971, 1984],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9405, 1066, 6436, 9922, 2994, 5455, 2911, 105, 7282, 8950, 1974],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6541, 3729, 8960, 9498, 6067, 7978, 6852, 8900, 3699, 910, 1965],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2086, 2841, 4246, 621, 1850, 8529, 8380, 6822, 3608, 2850, 1955],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [206, 1325, 4398, 5602, 2101, 8220, 8444, 9871, 7988, 4770, 1945],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [952, 9491, 5853, 6067, 4590, 9185, 840, 6003, 7821, 6671, 1935],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2170, 7273, 4981, 5455, 801, 9123, 4132, 5117, 4087, 8553, 1925],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5200, 1374, 7814, 6310, 7049, 1291, 3553, 9051, 7767, 415, 1916],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7074, 5366, 3284, 4584, 8901, 939, 2884, 1567, 9844, 2258, 1906],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6924, 4500, 2626, 9820, 735, 9150, 6320, 8343, 1297, 4083, 1896],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2020, 425, 7491, 8655, 4206, 5078, 314, 6965, 3110, 5888, 1886],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4656, 9636, 3236, 9469, 1282, 7572, 5395, 6912, 6264, 7674, 1876],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1975, 2517, 150, 8266, 9449, 7145, 7980, 9553, 1741, 9442, 1866],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4703, 2162, 3436, 9964, 8551, 9299, 2156, 8133, 524, 1191, 1857],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9813, 6310, 3049, 5132, 641, 160, 1451, 7762, 3595, 2921, 1847],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5846, 3557, 8135, 9887, 6075, 5425, 577, 5409, 1937, 4633, 1837],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1565, 9936, 361, 6115, 975, 3603, 7169, 9889, 6532, 6326, 1827],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3400, 491, 9052, 332, 3006, 4512, 3489, 1857, 8365, 8001, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [391, 4272, 3031, 2467, 4301, 4045, 8124, 3792, 8417, 9658, 1807],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4394, 8912, 4809, 405, 2178, 6163, 7659, 9994, 7672, 1297, 1798],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [678, 64, 8316, 2531, 121, 3111, 8336, 6569, 7115, 2918, 1788],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1384, 9501, 9181, 8439, 3336, 4838, 7690, 1422, 7729, 4521, 1778],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9428, 4314, 4725, 7668, 4977, 8605, 6173, 4246, 497, 6107, 1768],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4633, 3110, 8511, 7600, 945, 9761, 8756, 6512, 6404, 7674, 1758],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2230, 4492, 1881, 4580, 2960, 4674, 6514, 1461, 6435, 9224, 1748],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5821, 7250, 3288, 6808, 1365, 6806, 8192, 4091, 1573, 757, 1739],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9964, 9097, 7814, 3697, 911, 6904, 1759, 1151, 2804, 2272, 1729],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1044, 1589, 7031, 4014, 4508, 8304, 5937, 1126, 1112, 3770, 1719],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6786, 6257, 7497, 4369, 1702, 8327, 1718, 4234, 7482, 5250, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8392, 9281, 9802, 364, 352, 6748, 3861, 2409, 2900, 6714, 1699],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3522, 4155, 5207, 4971, 1725, 2333, 2373, 9297, 8350, 8160, 1689],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8015, 7389, 753, 2477, 950, 8421, 3971, 242, 4820, 9590, 1679],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2120, 4905, 4206, 1587, 6458, 8537, 3533, 2279, 3293, 1003, 1670],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7904, 2122, 6427, 7974, 3769, 3029, 5523, 4122, 4756, 2399, 1660],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [380, 8132, 814, 4720, 650, 7701, 5404, 6156, 195, 3779, 1650],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1486, 8286, 8262, 8684, 2350, 5443, 1039, 426, 597, 5142, 1640],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1280, 1836, 3708, 1838, 7315, 1835, 4065, 626, 6947, 6488, 1630],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3900, 2108, 9761, 8969, 5399, 5713, 1258, 2093, 232, 7819, 1620],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9105, 7006, 8089, 6980, 2296, 5681, 5882, 1792, 1439, 9133, 1610],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [513, 65, 5143, 6091, 5493, 3562, 9016, 8311, 1554, 431, 1601],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4749, 3361, 1394, 9783, 8738, 5771, 869, 1849, 1566, 1713, 1591],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1347, 5159, 9485, 8102, 3593, 3594, 2080, 4203, 2460, 2979, 1581],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1325, 5899, 4400, 8094, 8268, 3361, 4997, 8764, 5224, 4229, 1571],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [1238, 3539, 6981, 5536, 5543, 7511, 4945, 504, 847, 5464, 1561],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4599, 720, 625, 3886, 3156, 7515, 1477, 5966, 314, 6683, 1551],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7224, 1226, 755, 9287, 1634, 9666, 9606, 3253, 4615, 7886, 1541],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9901, 4392, 9499, 4743, 6108, 4710, 1027, 2024, 4737, 9074, 1531],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5982, 1242, 6807, 2002, 205, 2314, 5317, 3474, 1668, 247, 1522],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4768, 9408, 7825, 6371, 1688, 1347, 1126, 335, 6397, 1404, 1512],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7691, 7682, 9585, 7590, 1029, 6982, 7348, 6857, 9911, 2546, 1502],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5938, 7327, 3706, 8926, 5642, 5585, 4281, 8806, 3200, 3674, 1492],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4483, 9262, 2784, 6913, 4035, 8398, 4765, 3447, 7253, 4786, 1482],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3465, 9837, 4100, 5566, 5635, 4989, 5314, 9539, 3057, 5884, 1472],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4325, 3271, 4133, 1420, 3557, 7473, 7224, 7323, 1603, 6967, 1462],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3357, 1911, 813, 9432, 9067, 6478, 7675, 8513, 3879, 8035, 1452],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7364, 9431, 8295, 4557, 7991, 9860, 810, 6286, 875, 9089, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6741, 8907, 2994, 9699, 759, 5140, 8807, 5269, 3580, 128, 1433],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [347, 9517, 2470, 7672, 9291, 6664, 2928, 1537, 2984, 1153, 1423],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8317, 6375, 4224, 2884, 5320, 8480, 4563, 2593, 76, 2164, 1413],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8786, 4734, 4215, 7492, 6245, 3897, 6253, 7366, 5846, 3160, 1403],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6935, 4166, 747, 6931, 6012, 2749, 2699, 6198, 1285, 4143, 1393],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2645, 8207, 4905, 857, 9940, 7327, 1761, 833, 7383, 5111, 1383],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7598, 5451, 1700, 7711, 3843, 7986, 5441, 4409, 5129, 6066, 1373],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4667, 3524, 5139, 4247, 9194, 9402, 849, 1449, 5515, 7007, 1363],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4362, 2177, 5294, 5540, 7447, 8491, 1160, 7847, 9530, 7934, 1353],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2270, 2287, 6689, 6057, 8065, 4953, 6554, 862, 8167, 8848, 1343],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4198, 3117, 6681, 8471, 6125, 5457, 5143, 9108, 2414, 9749, 1333],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2445, 4817, 2563, 3877, 6771, 2440, 3887, 2541, 3265, 636, 1324],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7959, 6546, 524, 5011, 5116, 8522, 9491, 2451, 1709, 1510, 1314],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6703, 9925, 2970, 2917, 1561, 7520, 9297, 1454, 8738, 2370, 1304],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7262, 8372, 8662, 7246, 3804, 3057, 2153, 3479, 5343, 3218, 1294],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7228, 971, 9251, 1008, 8169, 5758, 9275, 3757, 2516, 4053, 1284],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8677, 1679, 3701, 2100, 4163, 20, 5098, 8818, 1248, 4875, 1274],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2761, 524, 7356, 6304, 7515, 1347, 8105, 6472, 2532, 5684, 1264],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [574, 6361, 4589, 9666, 8203, 5253, 1654, 5807, 7359, 6480, 1254],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [750, 9489, 3703, 2195, 1290, 8708, 4785, 7172, 6721, 7264, 1244],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3691, 2125, 1490, 9727, 9646, 5128, 3017, 2174, 1611, 8036, 1234],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3413, 8480, 5253, 6445, 8923, 3910, 9130, 3662, 3020, 8795, 1224],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6512, 6019, 5641, 7048, 6356, 5479, 3939, 5723, 1941, 9542, 1214],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5424, 7915, 8839, 4801, 6272, 2866, 7053, 3665, 9367, 276, 1205],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4162, 7724, 7163, 9753, 6365, 795, 7620, 4014, 6290, 999, 1195],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2951, 7878, 9249, 177, 64, 3274, 5063, 4500, 3703, 1710, 1185],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5318, 4625, 2503, 9849, 1495, 681, 9804, 4047, 2599, 2409, 1175],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5299, 9887, 9658, 4027, 800, 7347, 3971, 2767, 3971, 3096, 1165],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7796, 7921, 7756, 8026, 8690, 613, 2103, 1944, 8812, 3771, 1155],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2226, 2232, 2045, 3939, 389, 2373, 1829, 4029, 8115, 4435, 1145],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [6365, 5302, 736, 3514, 212, 4072, 4551, 2628, 2874, 5088, 1135],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [588, 11, 1675, 8253, 9255, 6182, 6104, 2493, 4082, 5729, 1125],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [829, 7859, 2274, 1577, 9787, 3126, 7410, 9511, 2732, 6359, 1115],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [4460, 8712, 4018, 2337, 1091, 4648, 5117, 695, 9820, 6977, 1105],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7987, 6494, 7834, 4033, 2657, 4629, 2232, 4173, 6337, 7585, 1095],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2871, 6849, 3224, 9828, 1717, 8345, 8737, 9178, 3278, 8182, 1085],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [7584, 3710, 9576, 9794, 3264, 9145, 2199, 6042, 1638, 8768, 1075],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5324, 6552, 1037, 3824, 1777, 5561, 8365, 6178, 2410, 9343, 1065],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [2827, 1448, 6158, 1180, 4987, 9831, 1747, 2080, 6589, 9907, 1055],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [8177, 8914, 579, 5893, 1097, 8840, 6201, 7303, 5168, 461, 1046],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [958, 1995, 6838, 5916, 1944, 8460, 5487, 6462, 9143, 1004, 1036],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5322, 2834, 2212, 3352, 5655, 2299, 3826, 5216, 9508, 1537, 1026],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [5989, 1217, 6955, 2906, 3417, 5841, 6440, 260, 7258, 2060, 1016],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [9864, 3839, 5532, 6240, 6014, 6974, 90, 9317, 3386, 2573, 1006],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4680, 7783, 1072, 8468, 8260, 9096, 5953, 1233, 8901, 758, 9963],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5187, 6251, 8115, 6424, 43, 4729, 3451, 4238, 7625, 5684, 9863],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4898, 7129, 7274, 5098, 5731, 7755, 8046, 9588, 9992, 511, 9764],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2576, 1111, 3503, 5953, 1843, 2522, 55, 4553, 5955, 5241, 9664],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [291, 7246, 9813, 2455, 2743, 633, 288, 6163, 5465, 9874, 9564],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9144, 6838, 3847, 270, 3441, 8573, 4781, 1115, 8477, 4411, 9465],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3305, 8530, 4942, 3211, 654, 8876, 9431, 5671, 4944, 8854, 9365],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3105, 9829, 3367, 5104, 8803, 4794, 4529, 5559, 4823, 3203, 9266],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [936, 7892, 20, 7532, 7189, 8429, 9204, 5870, 8070, 7459, 9166],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8199, 6890, 7850, 7837, 4064, 2265, 5776, 965, 4643, 1624, 9067],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9264, 3666, 9015, 569, 2669, 4078, 4006, 4369, 4499, 5698, 8967],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9406, 5962, 7726, 8729, 3580, 5168, 5267, 8675, 7598, 9682, 8867],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5156, 1887, 1253, 8614, 6885, 1875, 6615, 5444, 3901, 3578, 8768],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5331, 3230, 3953, 3635, 6743, 339, 4773, 5105, 3368, 7386, 8668],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4563, 139, 4789, 8173, 9893, 4461, 28, 6855, 5961, 1107, 8569],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3440, 4386, 775, 2165, 8519, 7033, 40, 8559, 1643, 4743, 8469],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [345, 8416, 440, 686, 6637, 3989, 3562, 6652, 378, 8294, 8369],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4411, 3384, 5783, 139, 7877, 1749, 4075, 6039, 2130, 1761, 8270],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9547, 6449, 1535, 3742, 1058, 7616, 3340, 9994, 6864, 5145, 8170],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4760, 8481, 9876, 3713, 8456, 3184, 4868, 61, 4548, 8448, 8070],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1004, 7306, 114, 5847, 14, 742, 7299, 5955, 5146, 1670, 7971],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5974, 2721, 9320, 3856, 5031, 2607, 7709, 5462, 8628, 4812, 7871],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1687, 5068, 4410, 6044, 1018, 3395, 4832, 4339, 4962, 7876, 7771],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2550, 8026, 1695, 5212, 7501, 5155, 2201, 6214, 4117, 862, 7672],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7682, 6999, 9348, 4427, 500, 5373, 1213, 2487, 6064, 3771, 7572],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9124, 3226, 4497, 6011, 1305, 7780, 4114, 2230, 773, 6605, 7472],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2046, 2627, 2549, 8972, 928, 5968, 6910, 2088, 8216, 9363, 7372],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [526, 2932, 4733, 963, 9288, 9756, 2198, 6179, 8365, 2048, 7273],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8084, 9812, 3497, 4562, 5751, 4300, 1929, 5992, 1194, 4661, 7173],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1028, 8509, 7090, 4268, 5143, 1898, 88, 291, 6677, 7201, 7073],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3703, 4477, 7093, 9951, 684, 6487, 5310, 5012, 4787, 9671, 6973],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6661, 1514, 8613, 4499, 2615, 784, 3422, 3167, 5501, 2071, 6874],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [231, 6813, 4911, 8066, 8415, 6062, 9907, 4739, 8794, 4402, 6774],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6850, 6341, 9136, 8480, 7627, 4526, 2312, 6589, 4643, 6666, 6674],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1927, 3619, 8144, 7043, 1236, 4267, 2573, 2348, 3026, 8863, 6574],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4458, 6082, 9763, 973, 2459, 6774, 9282, 2324, 3920, 994, 6475],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7426, 1594, 7829, 8153, 2553, 6983, 9884, 3401, 7304, 3060, 6375],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1630, 5694, 1469, 6465, 1945, 5831, 2807, 8937, 3157, 5063, 6275],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1669, 4102, 8996, 8848, 3528, 5304, 9529, 8663, 1460, 7003, 6175],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2210, 1199, 4826, 6193, 1491, 5955, 6581, 8590, 2193, 8881, 6075],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3764, 6888, 2659, 3198, 5377, 6868, 7487, 901, 5338, 698, 5976],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3525, 8092, 2119, 7399, 5375, 8058, 4642, 3857, 875, 2456, 5876],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [358, 3348, 1649, 8527, 1010, 5276, 1130, 1694, 8788, 4154, 5776],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9885, 1832, 139, 4230, 1469, 7210, 2480, 4524, 9059, 5795, 5676],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2523, 6091, 5889, 8868, 1789, 5064, 8368, 8236, 1672, 7380, 5576],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [811, 3357, 6509, 4532, 5007, 4491, 4255, 4397, 6612, 8908, 5476],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9228, 544, 9598, 7558, 6127, 9872, 2973, 148, 3863, 382, 5377],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9496, 9600, 3897, 9610, 9477, 918, 6256, 8108, 3409, 1802, 5277],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3596, 5770, 6381, 9736, 6560, 1587, 6207, 6274, 5238, 3169, 5177],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4458, 5732, 4792, 2727, 7015, 1292, 6726, 7919, 9335, 4484, 5077],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9733, 6907, 9784, 9433, 659, 8398, 4872, 1494, 5688, 5749, 4977],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5144, 7552, 8307, 6517, 3881, 5979, 2183, 527, 4283, 6964, 4877],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7978, 1479, 2551, 6241, 8797, 9840, 5935, 3523, 5108, 8130, 4777],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6575, 6615, 8842, 1377, 8706, 8774, 363, 3867, 8152, 9248, 4677],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [668, 6688, 669, 6058, 8313, 7051, 7823, 9718, 3403, 320, 4578],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1171, 7329, 1682, 310, 2105, 9129, 9912, 3917, 852, 1346, 4478],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1955, 7290, 389, 4174, 9002, 6567, 8541, 3881, 487, 2327, 4378],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7038, 1291, 470, 6496, 6133, 7145, 6958, 1505, 2299, 3264, 4278],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [442, 311, 1442, 3820, 9112, 6156, 732, 3063, 6278, 4158, 4178],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7647, 7730, 5995, 6120, 707, 9890, 8688, 9105, 2415, 5011, 4078],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [551, 2980, 4854, 8434, 4159, 1271, 3805, 4364, 703, 5823, 3978],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6220, 7226, 9708, 701, 1679, 7668, 4062, 7647, 1132, 6595, 3878],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9733, 3671, 1775, 2267, 2838, 841, 3260, 1742, 3696, 7328, 3778],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5498, 3949, 9986, 2489, 1654, 9040, 1783, 3315, 8386, 8023, 3678],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1536, 2597, 910, 4729, 5127, 1231, 7343, 2810, 5196, 8682, 3578],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4660, 2923, 4342, 7538, 9888, 3454, 5664, 4352, 4119, 9305, 3478],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8804, 1917, 6244, 4235, 7382, 7298, 1150, 5643, 5149, 9893, 3378],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9292, 7900, 6470, 11, 1692, 488, 7505, 7863, 8280, 447, 3279],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2148, 1528, 4623, 4422, 7694, 9581, 8317, 5574, 3507, 969, 3179],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1960, 1783, 5522, 6396, 707, 4768, 7622, 6615, 824, 1459, 3079],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8070, 4631, 8313, 8774, 2174, 6758, 415, 2005, 227, 1918, 2979],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [871, 5121, 2193, 9836, 9208, 5768, 3148, 5840, 1710, 2347, 2879],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2638, 468, 9285, 220, 8998, 2590, 4185, 5198, 5270, 2747, 2779],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5857, 6495, 3375, 5112, 2153, 1738, 4232, 35, 903, 3120, 2679],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3906, 7994, 4154, 3446, 2061, 6674, 6738, 3086, 8604, 3465, 2579],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4631, 4688, 2320, 8255, 174, 7110, 8269, 9766, 8370, 3785, 2479],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2734, 4894, 3554, 4989, 9968, 8371, 8851, 8069, 199, 4081, 2379],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [5087, 5149, 958, 7775, 4950, 2834, 2293, 8469, 4087, 4352, 2279],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7665, 5108, 8168, 7019, 8712, 3414, 6479, 3817, 32, 4601, 2179],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [604, 7375, 1090, 5556, 7469, 9127, 3643, 9247, 8030, 4827, 2079],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2538, 4097, 7088, 4588, 7931, 2695, 618, 2070, 8081, 5033, 1979],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [1092, 9006, 8554, 5052, 5618, 214, 9058, 1676, 181, 5220, 1879],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [2107, 794, 5193, 4586, 915, 2869, 5649, 9438, 4328, 5387, 1779],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3590, 2175, 8035, 5139, 2240, 700, 2295, 8605, 522, 5537, 1679],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3064, 6673, 335, 1272, 7682, 8418, 6282, 4206, 8761, 5669, 1579],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [8614, 9631, 7998, 4400, 8337, 3265, 434, 2952, 9043, 5786, 1479],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [7850, 9889, 7216, 3648, 8365, 4917, 3238, 3130, 1367, 5889, 1379],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [6926, 6022, 1526, 9465, 8446, 7434, 8968, 4509, 5732, 5977, 1279],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9702, 3014, 6608, 1864, 925, 3251, 7785, 8238, 2137, 6053, 1179],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [303, 5358, 870, 906, 6376, 9206, 5823, 6744, 582, 6117, 1079],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [4564, 8031, 2452, 9205, 7422, 6192, 2714, 6345, 663, 1701, 9796],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [5786, 9887, 6996, 9698, 4401, 3959, 4301, 5954, 5883, 2133, 8796],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [9562, 6893, 7863, 668, 312, 1830, 7706, 2937, 1482, 2478, 7796],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [9474, 6662, 1501, 8011, 1271, 5548, 9754, 2755, 7456, 2744, 6796],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [8444, 7824, 3223, 1820, 1799, 2402, 9737, 8665, 3802, 2943, 5796],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [1124, 5750, 4002, 7208, 6840, 3865, 9678, 720, 520, 3084, 4796],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [3514, 8847, 3709, 180, 1025, 8610, 4535, 4770, 7606, 3176, 3796],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [1359, 9731, 9303, 3956, 5027, 5888, 2343, 1460, 5061, 3231, 2796],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [1074, 6413, 7060, 4059, 4728, 9288, 4305, 5232, 2883, 3258, 1796],
    },
    BigFloatInc {
        sign: 1,
        e: -47,
        n: 44,
        m: [9402, 1753, 5880, 5418, 6453, 8533, 8540, 3254, 733, 2671, 7963],
    },
];
